###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_mult_vuln.nasl 958 2009-02-05 12:40:29Z feb $
#
# Google Chrome Multiple Vulnerabilities (Feb-09)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800229);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0276", "CVE-2009-0411");
  script_name("Google Chrome Multiple Vulnerabilities (Feb-09)");
  desc = "

  Overview: This host is installed with Google Chrome and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Multiple Flaws are due to,
  - an error exists in the V8 JavaScript engine while re-directing to
    another windows through iframe tag as it allows to bypass the same
    origin policy through a crafted iframe crafted script.
  - a flaw in the 'XMLHttpRequest' header which contains the cookie
    information of the logged user.

  Impact:
  Successful exploitation will let the attacker read the full URL and
  potentially other attributes or data from another frame in a different
  domain and can conduct cross site scripting attacks to gain users
  sensitive information and can also able to hijack legitimate user session
  and could gain sensitive information for the victim accounts.

  Affected Software/OS:
  Google Chrome version prior to 1.0.154.46

  Fix: Upgrade Google Chrome to version 1.0.154.46 or later.
  http://www.google.com/chrome

  References:
  http://secunia.com/advisories/33754
  http://src.chromium.org/viewvc/chrome?view=rev&revision=8524
  http://src.chromium.org/viewvc/chrome?view=rev&revision=8529
  http://sites.google.com/a/chromium.org/dev/getting-involved/dev-channel/release-notes

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

#Grep for Chrome version prior to 1.0.154.46
if(version_is_less(version:chromeVer, test_version:"1.0.154.46")){
  security_warning(0);
}
