###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_gdGetColors_bof_vuln.nasl 5387 2009-10-23 12:19:56Z oct $
#
# PHP '_gdGetColors()' Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801123);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3546");
  script_bugtraq_id(36712);
  script_name("PHP '_gdGetColors()' Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is running PHP and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in '_gdGetColors' function in gd_gd.c which fails to
  check certain colorsTotal structure member, whicn can be exploited to cause
  buffer overflow or buffer over-read attacks via a crafted GD file.

  Impact:
  Successful exploitation could allow attackers to potentially compromise a
  vulnerable system.

  Impact Level: System

  Affected Software/OS:
  PHP version 5.2.x to 5.2.11 and 5.3.0 on Linux.

  Fix: Apply patches from SVN repository,
  http://svn.php.net/viewvc?view=revision&revision=289557

  *****
  NOTE: Ignore this warning if patch is already applied.
  *****

  References:
  http://secunia.com/advisories/37080/
  http://www.vupen.com/english/advisories/2009/2930
  http://marc.info/?l=oss-security&m=125562113503923&w=2

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(phpVer)
{
  # Check PHP version 5.2.x through 5.2.11 or 5.3.0
  if(version_is_equal(version:phpVer, test_version:"5.3.0")||
     version_in_range(version:phpVer, test_version:"5.2",
                                     test_version2:"5.2.11")){
    security_hole(phpPort);
  }
}
