###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_quiksoft_easymail_obj_activex_bof_vuln_mar10.nasl 7548 2010-03-09 17:25:36Z mar $
#
# Quiksoft EasyMail Objects AddAttachments() ActiveX Control BOF Vulnerability
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800993);
  script_version("$Revision: 8165 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4663");
  script_bugtraq_id(36440);
  script_name("Quiksoft EasyMail Objects AddAttachments() ActiveX Control BOF Vulnerability");
  desc = "
  Overview: This host is installed with QuikSoft EasyMail Objects ActiveX
  Control and is prone to Buffer Overflow vulnerability.

  Vulnerability Insight:
  The flaw exists in AddAttachments() method, which fails to perform adequate
  boundary checks on user-supplied data.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  code in the context of the application with elevated privileges or cause
  the browser to crash.

  Impact Level: Application

  Affected Software/OS:
  Quiksoft EasyMail Objects 6.0 on Windows

  Fix: No solution or patch is available as on 9th March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.quiksoft.com/

  Workaround:
  Set the killbit for the following CLSID,
  {68AC0D5F-0424-11D5-822F-00C04F6BA8D9}
  http://support.microsoft.com/kb/240797

  References:
  http://www.milw0rm.com/exploits/9705
  http://xforce.iss.net/xforce/xfdb/53325
  http://www.bmgsec.com.au/advisories/easymail-6-activex-exploit.txt

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 8.4
  Risk factor : High";

  script_description(desc);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Check for the version of QuikSoft EasyMail Objects");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_activex.inc");

## Check for Windows
if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

## Confirm EasyMail Objects 6.0 installed by checking below registry key
key = "SOFTWARE\Quiksoft Corporation\EasyMail Objects\6.0";
if(registry_key_exists(key:key))
{
  ## Workaround check
  if(is_killbit_set(clsid:"{68AC0D5F-0424-11D5-822F-00C04F6BA8D9}") == 0){
    security_hole(0);
  }
}
