###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for PostgresSQL 123591-12
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855849);
  script_version("$Revision: 8166 $: 1.0");
  script_tag(name:"cvss_base", value:"8.5");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "SUNSolve", value: "123591-12");
  script_cve_id("CVE-2007-0555", "CVE-2007-0556");
  script_name("Solaris Update for PostgresSQL 123591-12");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  PostgresSQL
  For more information please visit the below reference link.

  Affected Software/OS:
  PostgresSQL on solaris_5.10_x86

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-123591-12-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of PostgresSQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"i386", patch:"123591-12", package:"SUNWpostgr-jdbcS SUNWpostgr-contrib SUNWpostgrS SUNWpostgr-tclS SUNWpostgr-server-data SUNWpostgr-devel SUNWpostgr-libs SUNWpostgr-jdbc SUNWpostgr-tcl SUNWpostgr-server SUNWpostgr-pl SUNWpostgr-docs SUNWpostgr") < 0)
{
  security_hole(0);
  exit(0);
}