###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for tomcat6 vulnerabilities USN-899-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840386);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "899-1");
  script_cve_id("CVE-2009-2693", "CVE-2009-2901", "CVE-2009-2902");
  script_name("Ubuntu Update for tomcat6 vulnerabilities USN-899-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Tomcat did not correctly validate WAR filenames or
  paths when deploying. A remote attacker could send a specially crafted WAR
  file to be deployed and cause arbitrary files and directories to be
  created, overwritten, or deleted.

  Affected Software/OS:
  tomcat6 vulnerabilities on Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001044.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tomcat6 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libservlet2.5-java-doc", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libservlet2.5-java", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtomcat6-java", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-admin", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-common", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-docs", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-examples", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-user", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6", ver:"6.0.20-2ubuntu2.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libservlet2.5-java-doc", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libservlet2.5-java", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtomcat6-java", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-admin", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-common", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-docs", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-examples", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-user", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6", ver:"6.0.18-0ubuntu6.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libservlet2.5-java", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtomcat6-java", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-admin", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-common", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-docs", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-examples", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6-user", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tomcat6", ver:"6.0.18-0ubuntu3.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}