###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gnome-screensaver vulnerabilities USN-907-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840397);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"5.6");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "907-1");
  script_cve_id("CVE-2010-0285", "CVE-2010-0422");
  script_name("Ubuntu Update for gnome-screensaver vulnerabilities USN-907-1");
  desc = "

  Vulnerability Insight:

  It was discovered that gnome-screensaver did not correctly lock all screens
  when monitors get hotplugged. An attacker with physical access could use
  this flaw to gain access to a locked session. (CVE-2010-0285)
  
  It was discovered that gnome-screensaver did not correctly handle keyboard
  grab when monitors get hotplugged. An attacker with physical access could
  use this flaw to gain access to a locked session. This issue only affected
  Ubuntu 9.10. (CVE-2010-0422)

  Affected Software/OS:
  gnome-screensaver vulnerabilities on Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-March/001056.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnome-screensaver vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.28.0-0ubuntu3.5", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.24.0-0ubuntu6.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.24.0-0ubuntu2.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}