# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:093 (mpg123)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63871);
 script_cve_id("CVE-2009-1301");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:093 (mpg123)";
 script_name(name);

 desc = "The remote host is missing an update to mpg123
announced via advisory MDVSA-2009:093.

A vulnerability has been found and corrected in mpg123:

Integer signedness error in the store_id3_text function in the
ID3v2 code in mpg123 before 1.7.2 allows remote attackers to cause a
denial of service (out-of-bounds memory access) and possibly execute
arbitrary code via an ID3 tag with a negative encoding value.  NOTE:
some of these details are obtained from third party information
(CVE-2009-1301).

The updated packages have been patched to correct this issue.

Affected: 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:093

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:093 (mpg123)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libmpg123_0", rpm:"libmpg123_0~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmpg123-devel", rpm:"libmpg123-devel~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123", rpm:"mpg123~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-arts", rpm:"mpg123-arts~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-esd", rpm:"mpg123-esd~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-jack", rpm:"mpg123-jack~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-nas", rpm:"mpg123-nas~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-portaudio", rpm:"mpg123-portaudio~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-pulse", rpm:"mpg123-pulse~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-sdl", rpm:"mpg123-sdl~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mpg123_0", rpm:"lib64mpg123_0~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mpg123-devel", rpm:"lib64mpg123-devel~1.3.0~2.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmpg123_0", rpm:"libmpg123_0~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmpg123-devel", rpm:"libmpg123-devel~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123", rpm:"mpg123~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-arts", rpm:"mpg123-arts~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-esd", rpm:"mpg123-esd~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-jack", rpm:"mpg123-jack~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-nas", rpm:"mpg123-nas~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-portaudio", rpm:"mpg123-portaudio~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-pulse", rpm:"mpg123-pulse~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mpg123-sdl", rpm:"mpg123-sdl~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mpg123_0", rpm:"lib64mpg123_0~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mpg123-devel", rpm:"lib64mpg123-devel~1.5.1~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
