#CESA-2009:0013 63246 2
# $Id$
# Description: Auto-generated from advisory CESA-2009:0013 (avahi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63246);
 script_cve_id("CVE-2008-5081");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "CentOS Security Advisory CESA-2009:0013 (avahi)";
 script_name(name);

 desc = "The remote host is missing updates to avahi announced in
advisory CESA-2009:0013.

For details on the issues addressed in this update,
please visit the referenced security advisories.

Solution:
Update the appropriate packages on your system.

http://www.securityspace.com/smysecure/catid.html?in=CESA-2009:0013
http://www.securityspace.com/smysecure/catid.html?in=RHSA-2009:0013
https://rhn.redhat.com/errata/RHSA-2009-0013.html

Risk factor : Medium";

 script_description(desc);

 summary = "CentOS Security Advisory CESA-2009:0013 (avahi)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "CentOS Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl", rpm:"avahi-compat-howl~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl-devel", rpm:"avahi-compat-howl-devel~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-libdns_sd", rpm:"avahi-compat-libdns_sd~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-libdns_sd-devel", rpm:"avahi-compat-libdns_sd-devel~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-devel", rpm:"avahi-devel~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-glib", rpm:"avahi-glib~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-glib-devel", rpm:"avahi-glib-devel~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt3", rpm:"avahi-qt3~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-qt3-devel", rpm:"avahi-qt3-devel~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-tools", rpm:"avahi-tools~0.6.16~1.el5_2.1", rls:"CentOS5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
