###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_detect.nasl 1940 2009-04-27 12:25:24Z apr $
#
# Apache Web Server Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900498);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Apache Web ServerVersion Detection");
  desc = "
  Overview : This script finds the running Apache Version and saves the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set Version of Apache Web Server in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

banner = get_http_banner(port:port);
if("Apache" >!< banner){
  exit(0);
}

apacheVer = eregmatch(pattern:"Server: Apache/([0-9]\.[0-9]+\.[0-9][0-9]?)",
                      string:banner);
if(apacheVer[1] != NULL){
  set_kb_item(name:"www/" + port + "/Apache", value:apacheVer[1]);
  security_note(data:"Apache Web Server version " + apacheVer[1] +
                                                 " was detected on the host");
}
