###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_memcached_mult_bof_vuln.nasl 3900 2009-08-19 15:25:29Z aug $
#
# Memcached Multiple Buffer Overflow Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900914);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2415");
  script_bugtraq_id(35989);
  script_name("Memcached Multiple Buffer Overflow Vulnerabilities");
  desc = "

  Overview: The host is running Memcached and is prone to multiple Buffer
  Overflow vulnerabilities.

  Vulnerability Insight:
  Heap overflow errors occur due to integer conversions when parsing certain
  length attributes.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code on the
  affected system via readily available network utilities.

  Affected Software/OS:
  Memcached version 1.1.12 and 1.2.2

  Fix: Apply the patch for Debian
  http://www.debian.org/security/2009/dsa-1853

  *****
  NOTE: Please ignore this warning if the patch is applied.
  *****

  References:
  http://seclists.org/bugtraq/2009/Aug/0055.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Memcached");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_memcached_detect.nasl");
  script_require_keys("MemCached/Ver");
  exit(0);
}


include("version_func.inc");

memPort = 11211;
if(!get_port_state(memPort)){
  exit(0);
}

memVer = get_kb_item("MemCached/Ver");
if(memVer == NULL){
  exit(0);
}

# Grep for Memcached version 1.1.12 and 1.2.2
if(version_is_equal(version:memVer, test_version:"1.1.12") ||
   version_is_equal(version:memVer, test_version:"1.2.2")){
  security_hole(memPort);
}
