###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-061.nasl 5268 2009-10-15 10:51:45Z oct $
#
# Microsoft .NET Common Language Runtime Remote Code Execution Vulnerability (974378)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900964);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0090", "CVE-2009-0091", "CVE-2009-2497");
  script_bugtraq_id(36611, 36612, 36618);
  script_name("Microsoft .NET Common Language Runtime Code Execution Vulnerability (974378)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-061.

  Vulnerability Insight:
  - An unspecified error can be exploited to obtain a managed pointer to stack
    memory which can be used to overwrite data at that stack location.
  - An error in the type equality check can be exploited to cast an object of
    one type into another type.
  - An error when handling interfaces can be exploited by malicious .NET or
    Silverlight applications to corrupt memory.

  Impact:
  Remote attackers could execute arbitrary code and compromise the affected
  system.

  Impact Level: System.

  Affected Software/OS:
  Microsoft .NET Framework 3.5/SP 1
  Microsoft .NET Framework 1.1 SP 1
  Microsoft .NET Framework 2.0 SP 1/SP 2

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-061.mspx

  References:
  http://secunia.com/advisories/37006/
  http://www.vupen.com/english/advisories/2009/2896
  http://www.microsoft.com/technet/security/bulletin/MS09-061.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of mscorlib.dll file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-061 Hotfix check
if((hotfix_missing(name:"953297") == 0) || (hotfix_missing(name:"953298") == 0)||
   (hotfix_missing(name:"953300") == 0) || (hotfix_missing(name:"974417") == 0)){
    exit(0);
}

key  = "SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDlls\";

# Get the location of mscorlib.dll
foreach dllPath (registry_enum_values(key:key))
{
  if((".NET" >< dllPath) && ("\mscorlib.dll" >< dllPath))
  {
    share = ereg_replace(pattern:"([a-zA-Z]):.*", replace:"\1$", string:dllPath);
    file = ereg_replace(pattern:"[a-zA-Z]:(.*)", replace:"\1", string:dllPath);

    # Get the version of mscorlib.dll
    dllVer = GetVer(file:file, share:toupper(share));
    if(!isnull(dllVer))
    {
      # Check for mscorlib.dll < 1.1.4322.2433, 2.0.50727.1873, 2.0.50727.3603,
      # 2.0.50727.4062
      if(version_in_range(version:dllVer, test_version:"1.1",test_version2:"1.1.4322.2442") ||
         version_in_range(version:dllVer, test_version:"2.0",test_version2:"2.0.50727.1872")||
         version_in_range(version:dllVer, test_version:"2.0.50727.3000",test_version2:"2.0.50727.3602")||
         version_in_range(version:dllVer, test_version:"2.0.50727.4000",test_version2:"2.0.50727.4061"))
      {
        security_hole(0);
        exit(0);
      }
    }
  }
}

