"""
Data downloaded from Henke tables at https://henke.lbl.gov/optical_constants/asf.html
"""
nan = float("nan")

# flake8: noqa
# fmt: off
XRAY_SCATTERING_FACTORS = {
    'H':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159, 0.0161, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551,
         0.0175342, 0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503,
         0.0223053, 0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002,
         0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337,
         0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609,
         0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794,
         0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 1.07342, 1.07482, 1.07577, 1.07696, 1.07825, 1.0794, 1.08039, 1.08123, 1.08195, 1.08254, 1.083,
         1.08337, 1.08362, 1.08376, 1.0838, 1.08375, 1.08362, 1.08341, 1.08312, 1.08278, 1.08238, 1.08198, 1.08151,
         1.08094, 1.08032, 1.07964, 1.07892, 1.07815, 1.07735, 1.07651, 1.07564, 1.07476, 1.07386, 1.07294, 1.07201,
         1.07105, 1.07008, 1.06908, 1.06808, 1.06708, 1.06607, 1.06505, 1.06404, 1.06302, 1.06202, 1.06102, 1.06005,
         1.05907, 1.05809, 1.05711, 1.05611, 1.05511, 1.05411, 1.05312, 1.05213, 1.05114, 1.05017, 1.0492, 1.04825,
         1.0473, 1.04637, 1.04544, 1.04453, 1.04364, 1.04276, 1.0419, 1.04105, 1.0402, 1.03936, 1.03853, 1.0377,
         1.03689, 1.03609, 1.03531, 1.03453, 1.03377, 1.03302, 1.03229, 1.03156, 1.03085, 1.03015, 1.02946, 1.02879,
         1.02813, 1.02749, 1.02685, 1.02623, 1.02562, 1.02503, 1.02445, 1.02389, 1.02334, 1.02279, 1.02225, 1.02172,
         1.0212, 1.02069, 1.02019, 1.0197, 1.01923, 1.01876, 1.0183, 1.01785, 1.01741, 1.01698, 1.01657, 1.01616,
         1.01576, 1.01537, 1.01499, 1.01462, 1.01425, 1.0139, 1.01354, 1.0132, 1.01286, 1.01253, 1.01221, 1.0119,
         1.01159, 1.01129, 1.011, 1.01071, 1.01043, 1.01016, 1.00989, 1.00963, 1.00938, 1.00913, 1.00889, 1.00866,
         1.00843, 1.00821, 1.00799, 1.00777, 1.00757, 1.00737, 1.00717, 1.00698, 1.00679, 1.00661, 1.00643, 1.00626,
         1.00609, 1.00592, 1.00577, 1.00561, 1.00546, 1.00531, 1.00517, 1.00503, 1.00489, 1.00476, 1.00463, 1.0045,
         1.00438, 1.00426, 1.00414, 1.00402, 1.00391, 1.0038, 1.0037, 1.00359, 1.00349, 1.0034, 1.0033, 1.00321,
         1.00312, 1.00303, 1.00294, 1.00286, 1.00278, 1.0027, 1.00262, 1.00255, 1.00248, 1.00241, 1.00234, 1.00227,
         1.00221, 1.00214, 1.00208, 1.00202, 1.00196, 1.00191, 1.00185, 1.0018, 1.00175, 1.0017, 1.00165, 1.0016,
         1.00155, 1.00151, 1.00146, 1.00142, 1.00138, 1.00134, 1.0013, 1.00126, 1.00122, 1.00119, 1.00115, 1.00112,
         1.00109, 1.00105, 1.00102, 1.00099, 1.00096, 1.00093, 1.00091, 1.00088, 1.00085, 1.00083, 1.0008, 1.00078,
         1.00075, 1.00073, 1.00071, 1.00069, 1.00067, 1.00065, 1.00063, 1.00061, 1.00059, 1.00057, 1.00055, 1.00054,
         1.00052, 1.0005, 1.00049, 1.00047, 1.00046, 1.00044, 1.00043, 1.00042, 1.0004, 1.00039, 1.00038, 1.00037,
         1.00035, 1.00034, 1.00033, 1.00032, 1.00031, 1.0003, 1.00029, 1.00028, 1.00027, 1.00026, 1.00025, 1.00025,
         1.00024, 1.00023, 1.00022, 1.00021, 1.00021, 1.0002, 1.00019, 1.00019, 1.00018, 1.00017, 1.00017, 1.00016,
         1.00016, 1.00015, 1.00015, 1.00014, 1.00014, 1.00013, 1.00013, 1.00012, 1.00012, 1.00011, 1.00011, 1.0001,
         1.0001, 1.0001, 1.00009, 1.00009, 1.00008, 1.00008, 1.00008, 1.00007, 1.00007, 1.00007, 1.00007, 1.00006,
         1.00006, 1.00006, 1.00005, 1.00005, 1.00005, 1.00005, 1.00005, 1.00004, 1.00004, 1.00004, 1.00004, 1.00003,
         1.00003, 1.00003, 1.00003, 1.00003, 1.00003, 1.00002, 1.00002, 1.00002, 1.00002, 1.00002, 1.00002, 1.00001,
         1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.00001, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.999999,
         0.999998, 0.999997, 0.999996, 0.999995, 0.999995, 0.999994, 0.999993, 0.999993, 0.999992, 0.999991, 0.999991,
         0.99999, 0.99999, 0.999989, 0.999988, 0.999988, 0.999987, 0.999987, 0.999986, 0.999986, 0.999985, 0.999985,
         0.999985, 0.999984, 0.999984, 0.999983, 0.999983, 0.999983, 0.999982, 0.999982, 0.999982, 0.999981, 0.999981,
         0.999981, 0.99998, 0.99998, 0.99998, 0.99998, 0.999979, 0.999979, 0.999979, 0.999979, 0.999978, 0.999978,
         0.999978, 0.999978, 0.999978, 0.999977, 0.999977, 0.999977, 0.999977, 0.999977, 0.999977, 0.999976, 0.999976,
         0.999976, 0.999976, 0.999976, 0.999976, 0.999975, 0.999975, 0.999975, 0.999975, 0.999975, 0.999975, 0.999975,
         0.999975, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974, 0.999974,
         0.999974, 0.999974, 0.999974, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973,
         0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999973, 0.999972,
         0.999972, 0.999972, 0.999972, 0.999972, 0.999972, 0.999972, 0.999972, 0.999972],
        [2.3954e-17, 2.43414e-17, 2.47351e-17, 2.51352e-17, 2.55417e-17, 2.59549e-17, 2.63746e-17, 2.68012e-17,
         2.72347e-17, 2.76752e-17, 2.81229e-17, 2.85777e-17, 2.90399e-17, 2.95096e-17, 2.99869e-17, 3.0472e-17,
         3.09648e-17, 3.14656e-17, 3.19746e-17, 3.24917e-17, 3.30173e-17, 3.35513e-17, 3.4094e-17, 3.46454e-17,
         3.52058e-17, 3.57752e-17, 3.63538e-17, 3.69418e-17, 3.75393e-17, 3.80868e-17, 6.11915e-15, 3.92474e-13,
         1.85104e-07, 0.0873013, 0.960229, 0.931364, 0.903367, 0.876211, 0.849873, 0.824325, 0.799546, 0.775511,
         0.752199, 0.729131, 0.705642, 0.682908, 0.660907, 0.639615, 0.619009, 0.599067, 0.579767, 0.561089, 0.543013,
         0.525519, 0.508588, 0.492203, 0.476347, 0.460795, 0.445595, 0.430897, 0.416683, 0.402938, 0.389647, 0.376794,
         0.364365, 0.352346, 0.340723, 0.329484, 0.318616, 0.308106, 0.298515, 0.289718, 0.281082, 0.2726, 0.264377,
         0.256403, 0.248667, 0.241163, 0.233886, 0.226829, 0.21996, 0.213297, 0.206836, 0.200567, 0.194485, 0.188585,
         0.182864, 0.177319, 0.171944, 0.166725, 0.161576, 0.156586, 0.15175, 0.147051, 0.142495, 0.138078, 0.133798,
         0.12965, 0.125634, 0.121741, 0.11796, 0.114297, 0.110729, 0.107265, 0.10391, 0.100659, 0.0975106, 0.0944602,
         0.0915051, 0.0886427, 0.0858697, 0.0831839, 0.0805822, 0.0780614, 0.0756082, 0.0732062, 0.0708702, 0.0685836,
         0.0663707, 0.0642289, 0.0621564, 0.0601513, 0.0582104, 0.0563323, 0.054515, 0.0527566, 0.0510546, 0.0494071,
         0.0478129, 0.0462703, 0.0447771, 0.043332, 0.0419309, 0.0405709, 0.0392348, 0.0379426, 0.036692, 0.0354828,
         0.0343137, 0.0331831, 0.0320897, 0.0310324, 0.0300101, 0.0290214, 0.0280652, 0.0271368, 0.0262374, 0.0253737,
         0.0245376, 0.023729, 0.0229472, 0.0221911, 0.0214598, 0.0207528, 0.020069, 0.0194077, 0.0187681, 0.0181496,
         0.0175503, 0.016958, 0.0163857, 0.0158328, 0.0152983, 0.014782, 0.0142832, 0.0138012, 0.0133353, 0.0128851,
         0.0124503, 0.0120301, 0.011624, 0.0112318, 0.0108526, 0.0104863, 0.0101325, 0.00978989, 0.00945798, 0.00913121,
         0.00881506, 0.00850979, 0.00821516, 0.0079308, 0.0076563, 0.00739119, 0.00713519, 0.00688805, 0.00664962,
         0.00641948, 0.00619731, 0.00598257, 0.00577539, 0.00557553, 0.00538225, 0.00519584, 0.00501608, 0.00484241,
         0.00467475, 0.00451287, 0.00435661, 0.00420577, 0.00406014, 0.00391955, 0.00378382, 0.00365277, 0.00352625,
         0.00340413, 0.00328624, 0.0031724, 0.00306252, 0.00295645, 0.00285407, 0.00275523, 0.00265984, 0.00256773,
         0.00247864, 0.00239241, 0.00230717, 0.0022244, 0.0021446, 0.00206767, 0.00199351, 0.00192206, 0.00185312,
         0.00178664, 0.00172253, 0.00166075, 0.00160119, 0.00154377, 0.00148837, 0.00143498, 0.00138356, 0.00133393,
         0.00128607, 0.00123994, 0.00119547, 0.00115259, 0.00111124, 0.00107134, 0.00103287, 0.000995812, 0.000960079,
         0.000925627, 0.000892416, 0.000860393, 0.000829518, 0.000799751, 0.000771052, 0.000743383, 0.000716714,
         0.000690999, 0.000666203, 0.000642299, 0.000619249, 0.000597026, 0.000575597, 0.000554945, 0.000535035,
         0.000515832, 0.000497219, 0.000479195, 0.000461657, 0.000444758, 0.000428477, 0.000412792, 0.00039768,
         0.00038312, 0.000369094, 0.000355582, 0.000342565, 0.000330026, 0.000317945, 0.000306305, 0.000295082,
         0.000284275, 0.000273869, 0.000263852, 0.000254197, 0.00024489, 0.000235924, 0.000227288, 0.000218969,
         0.000210948, 0.000203223, 0.000195782, 0.000188614, 0.000181709, 0.000175057, 0.000168649, 0.000162475,
         0.000156527, 0.000150796, 0.000145275, 0.000139956, 0.000134833, 0.000129897, 0.00012514, 0.000120559,
         0.000116145, 0.000111894, 0.000107798, 0.000103851, 0.000100048, 9.63431e-05, 9.27658e-05, 8.93136e-05,
         8.59897e-05, 8.2789e-05, 7.97065e-05, 7.67399e-05, 7.38845e-05, 7.11367e-05, 6.8489e-05, 6.59394e-05,
         6.34846e-05, 6.11222e-05, 5.88497e-05, 5.66648e-05, 5.4565e-05, 5.25439e-05, 5.05984e-05, 4.87229e-05,
         4.69171e-05, 4.51791e-05, 4.34988e-05, 4.18788e-05, 4.03175e-05, 3.88144e-05, 3.73672e-05, 3.59738e-05,
         3.46325e-05, 3.33413e-05, 3.20983e-05, 3.09117e-05, 2.97548e-05, 2.86399e-05, 2.75656e-05, 2.65311e-05,
         2.5534e-05, 2.45737e-05, 2.36488e-05, 2.27578e-05, 2.18996e-05, 2.10728e-05, 2.02763e-05, 1.95099e-05,
         1.87711e-05, 1.80601e-05, 1.73752e-05, 1.67157e-05, 1.60808e-05, 1.54691e-05, 1.48806e-05, 1.43137e-05,
         1.37685e-05, 1.32435e-05, 1.27377e-05, 1.2251e-05, 1.17831e-05, 1.13326e-05, 1.08987e-05, 1.04815e-05,
         1.00803e-05, 9.69407e-06, 9.3228e-06, 8.9657e-06, 8.62159e-06, 8.29117e-06, 7.97348e-06, 7.66792e-06,
         7.37417e-06, 7.09177e-06, 6.8204e-06, 6.55955e-06, 6.30887e-06, 6.06802e-06, 5.83417e-06, 5.61182e-06,
         5.39804e-06, 5.19262e-06, 4.99505e-06, 4.80512e-06, 4.62252e-06, 4.44693e-06, 4.27824e-06, 4.11592e-06,
         3.9598e-06, 3.80971e-06, 3.66534e-06, 3.52656e-06, 3.39308e-06, 3.26467e-06, 3.14122e-06, 3.0224e-06,
         2.90811e-06, 2.7982e-06, 2.69252e-06, 2.5908e-06, 2.49292e-06, 2.39878e-06, 2.30825e-06, 2.22111e-06,
         2.13725e-06, 2.05662e-06, 1.97895e-06, 1.90427e-06, 1.83248e-06, 1.76329e-06, 1.6967e-06, 1.63268e-06,
         1.57105e-06, 1.51173e-06, 1.45464e-06, 1.3997e-06, 1.34683e-06, 1.29594e-06, 1.24696e-06, 1.19981e-06,
         1.15443e-06, 1.11076e-06, 1.06872e-06, 1.02826e-06, 9.89303e-07, 9.51814e-07, 9.15734e-07, 8.80992e-07,
         8.47563e-07, 8.15359e-07, 7.84388e-07, 7.54553e-07, 7.25847e-07, 6.98223e-07, 6.71626e-07, 6.46075e-07,
         6.21481e-07, 5.97806e-07, 5.75016e-07, 5.53081e-07, 5.31965e-07, 5.11641e-07, 4.92077e-07, 4.73248e-07,
         4.55123e-07, 4.37678e-07, 4.20889e-07, 4.04728e-07, 3.89176e-07, 3.74207e-07, 3.59802e-07, 3.45939e-07,
         3.32598e-07, 3.1976e-07, 3.07406e-07, 2.95519e-07, 2.84081e-07, 2.73076e-07, 2.62488e-07, 2.52302e-07,
         2.42502e-07, 2.33075e-07, 2.24007e-07, 2.15284e-07, 2.06894e-07, 1.98825e-07, 1.91065e-07, 1.83603e-07,
         1.76428e-07, 1.69528e-07, 1.62895e-07, 1.56518e-07, 1.50387e-07, 1.44495e-07, 1.38831e-07, 1.33389e-07,
         1.28159e-07, 1.23133e-07, 1.18381e-07, 1.13744e-07, 1.09292e-07, 1.05019e-07, 1.00917e-07, 9.69783e-08,
         9.31972e-08, 8.95669e-08, 8.6081e-08, 8.27338e-08, 7.95195e-08, 7.64328e-08, 7.34683e-08, 7.06213e-08,
         6.78867e-08, 6.52602e-08, 6.27372e-08, 6.03136e-08, 5.79854e-08, 5.57487e-08, 5.35999e-08, 5.15352e-08,
         4.95516e-08, 4.76455e-08, 4.58139e-08, 4.40539e-08]],
    'He':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245, 0.0247, 0.024956600000000002,
         0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337,
         0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609,
         0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794,
         0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 0.26747, 0.362843, 0.451234, 0.534067, 0.611945, 0.685527, 0.755443, 0.822211, 0.887846, 0.951922,
         1.01126, 1.06605, 1.11755, 1.16625, 1.21249, 1.25652, 1.29857, 1.33882, 1.37746, 1.41467, 1.4507, 1.48603,
         1.52089, 1.55372, 1.58406, 1.61289, 1.64032, 1.66651, 1.69154, 1.71551, 1.73847, 1.76048, 1.78155, 1.80162,
         1.82066, 1.83934, 1.85796, 1.87622, 1.89417, 1.91185, 1.92933, 1.94669, 1.96406, 1.98163, 1.99969, 2.01823,
         2.04407, 2.06855, 2.08356, 2.0959, 2.10574, 2.11331, 2.11846, 2.11942, 2.11942, 2.12233, 2.12643, 2.13093,
         2.13567, 2.14055, 2.14552, 2.15055, 2.15565, 2.16086, 2.16625, 2.17187, 2.17877, 2.18648, 2.19271, 2.19719,
         2.20071, 2.20348, 2.20554, 2.20703, 2.20503, 2.20321, 2.21029, 2.21897, 2.22247, 2.22456, 2.22622, 2.2273,
         2.22795, 2.22825, 2.22826, 2.22802, 2.22759, 2.22699, 2.22627, 2.22547, 2.22468, 2.22415, 2.22353, 2.22227,
         2.2207, 2.21894, 2.21702, 2.21502, 2.213, 2.21116, 2.20922, 2.20672, 2.20396, 2.20099, 2.19784, 2.19452,
         2.19093, 2.18694, 2.18298, 2.17956, 2.17636, 2.17331, 2.17038, 2.16759, 2.16507, 2.16258, 2.15987, 2.15714,
         2.15442, 2.1517, 2.149, 2.14632, 2.14366, 2.14103, 2.13843, 2.13587, 2.13334, 2.13086, 2.12841, 2.12601,
         2.12366, 2.12136, 2.11912, 2.11695, 2.11487, 2.11291, 2.11132, 2.11022, 2.10794, 2.10459, 2.10213, 2.09979,
         2.09752, 2.09531, 2.09315, 2.09103, 2.08896, 2.08693, 2.08493, 2.08298, 2.08107, 2.07919, 2.07736, 2.07556,
         2.0738, 2.07207, 2.07038, 2.06873, 2.06712, 2.06554, 2.06401, 2.06252, 2.06106, 2.05962, 2.05819, 2.05679,
         2.05541, 2.05405, 2.05273, 2.05142, 2.05015, 2.0489, 2.04767, 2.04648, 2.04531, 2.04417, 2.04305, 2.04196,
         2.0409, 2.03986, 2.03884, 2.03785, 2.03688, 2.03595, 2.03505, 2.03415, 2.03326, 2.03239, 2.03155, 2.03074,
         2.02994, 2.02918, 2.02845, 2.02772, 2.02698, 2.02624, 2.02548, 2.02476, 2.0241, 2.02347, 2.02285, 2.02224,
         2.02165, 2.02107, 2.0205, 2.01995, 2.01942, 2.01889, 2.01837, 2.01787, 2.01737, 2.01689, 2.01642, 2.01597,
         2.01553, 2.0151, 2.01469, 2.01429, 2.01389, 2.01351, 2.01315, 2.01279, 2.01244, 2.0121, 2.01177, 2.01144,
         2.01113, 2.01082, 2.01051, 2.01022, 2.00994, 2.00966, 2.00939, 2.00912, 2.00886, 2.00861, 2.00837, 2.00813,
         2.0079, 2.00768, 2.00747, 2.00726, 2.00705, 2.00686, 2.00667, 2.00649, 2.00631, 2.00613, 2.00596, 2.00579,
         2.00563, 2.00547, 2.00531, 2.00516, 2.00501, 2.00487, 2.00473, 2.0046, 2.00446, 2.00433, 2.00421, 2.00408,
         2.00396, 2.00385, 2.00374, 2.00363, 2.00352, 2.00342, 2.00331, 2.00322, 2.00312, 2.00303, 2.00294, 2.00285,
         2.00276, 2.00268, 2.0026, 2.00252, 2.00244, 2.00237, 2.00229, 2.00222, 2.00215, 2.00209, 2.00202, 2.00196,
         2.0019, 2.00184, 2.00178, 2.00172, 2.00167, 2.00161, 2.00156, 2.00151, 2.00146, 2.00141, 2.00137, 2.00132,
         2.00128, 2.00124, 2.00119, 2.00115, 2.00111, 2.00108, 2.00104, 2.001, 2.00097, 2.00094, 2.0009, 2.00087,
         2.00084, 2.00081, 2.00078, 2.00075, 2.00073, 2.0007, 2.00068, 2.00065, 2.00063, 2.0006, 2.00058, 2.00056,
         2.00054, 2.00052, 2.0005, 2.00048, 2.00046, 2.00044, 2.00042, 2.0004, 2.00039, 2.00037, 2.00036, 2.00034,
         2.00033, 2.00031, 2.0003, 2.00028, 2.00027, 2.00026, 2.00025, 2.00023, 2.00022, 2.00021, 2.0002, 2.00019,
         2.00018, 2.00017, 2.00016, 2.00015, 2.00014, 2.00013, 2.00012, 2.00012, 2.00011, 2.0001, 2.00009, 2.00008,
         2.00008, 2.00007, 2.00006, 2.00006, 2.00005, 2.00005, 2.00004, 2.00003, 2.00003, 2.00002, 2.00002, 2.00001,
         2.00001, 2.0, 2.0, 1.99999, 1.99999, 1.99999, 1.99998, 1.99998, 1.99997, 1.99997, 1.99997, 1.99996, 1.99996,
         1.99996, 1.99995, 1.99995, 1.99995, 1.99994, 1.99994, 1.99994, 1.99994, 1.99993, 1.99993, 1.99993, 1.99993,
         1.99992, 1.99992, 1.99992, 1.99992, 1.99992, 1.99991, 1.99991, 1.99991, 1.99991, 1.99991, 1.9999, 1.9999,
         1.9999, 1.9999, 1.9999, 1.9999, 1.99989, 1.99989, 1.99989, 1.99989, 1.99989, 1.99989, 1.99989, 1.99989,
         1.99989, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988, 1.99988,
         1.99987, 1.99987],
        [9.5123e-17, 9.66615e-17, 9.82249e-17, 9.98136e-17, 1.01428e-16, 1.03069e-16, 1.04736e-16, 1.0643e-16,
         1.08151e-16, 1.099e-16, 1.11678e-16, 1.13484e-16, 1.1532e-16, 1.17185e-16, 1.1908e-16, 1.21006e-16,
         1.22964e-16, 1.24952e-16, 1.26973e-16, 1.29027e-16, 1.31114e-16, 1.33235e-16, 1.3539e-16, 1.37579e-16,
         1.39805e-16, 1.42066e-16, 1.44364e-16, 1.46699e-16, 1.49071e-16, 1.51483e-16, 1.53933e-16, 1.56422e-16,
         1.58952e-16, 1.61523e-16, 1.64136e-16, 1.66791e-16, 1.69488e-16, 1.7223e-16, 1.75015e-16, 1.77846e-16,
         1.80723e-16, 1.83646e-16, 1.86616e-16, 1.89634e-16, 1.92702e-16, 1.95818e-16, 1.98986e-16, 2.02204e-16,
         2.05474e-16, 2.08798e-16, 2.12175e-16, 2.15607e-16, 2.19094e-16, 2.22638e-16, 2.26239e-16, 2.29898e-16,
         2.33051e-16, 2.76823, 2.74626, 2.7125, 2.67915, 2.64621, 2.61368, 2.58155, 2.54981, 2.51846, 2.4875, 2.45692,
         2.42672, 2.39689, 2.36853, 2.34051, 2.31282, 2.28545, 2.25841, 2.23169, 2.20529, 2.17643, 2.14429, 2.11264,
         2.08145, 2.05072, 2.02044, 1.99061, 1.96122, 1.93227, 1.90374, 1.87564, 1.84795, 1.82066, 1.79233, 1.76283,
         1.73381, 1.70527, 1.6772, 1.64959, 1.62244, 1.59573, 1.56946, 1.54363, 1.51822, 1.49323, 1.46914, 1.44608,
         1.42339, 1.40105, 1.37907, 1.35743, 1.33612, 1.31516, 1.29452, 1.2742, 1.25421, 1.23453, 1.21515, 1.18262,
         1.15072, 1.11968, 1.08948, 1.06009, 1.0315, 1.00367, 0.984085, 0.965555, 0.947372, 0.929534, 0.912031,
         0.894858, 0.878008, 0.861474, 0.845254, 0.829337, 0.813721, 0.798399, 0.783365, 0.766782, 0.747865, 0.729416,
         0.711421, 0.693871, 0.676753, 0.660057, 0.643774, 0.634306, 0.626245, 0.610238, 0.5927, 0.576422, 0.56059,
         0.545193, 0.53022, 0.515658, 0.501495, 0.487721, 0.474327, 0.4613, 0.44863, 0.436308, 0.424326, 0.412671,
         0.400327, 0.388289, 0.376612, 0.365286, 0.354301, 0.343646, 0.333312, 0.323288, 0.312726, 0.302492, 0.292593,
         0.283018, 0.273756, 0.264798, 0.256133, 0.247841, 0.24085, 0.234056, 0.227455, 0.221039, 0.214804, 0.208745,
         0.202828, 0.196671, 0.190702, 0.184913, 0.1793, 0.173858, 0.168581, 0.163464, 0.158502, 0.153691, 0.149026,
         0.144503, 0.140116, 0.135862, 0.131736, 0.127734, 0.123855, 0.120093, 0.116446, 0.112909, 0.10948, 0.106155,
         0.10293, 0.0994029, 0.0941967, 0.0908527, 0.0879361, 0.0850658, 0.0822728, 0.0795694, 0.0769556, 0.0744264,
         0.0719808, 0.0696165, 0.0673286, 0.0651156, 0.0629754, 0.0609068, 0.0589059, 0.0569701, 0.0550978, 0.0532873,
         0.0515374, 0.0498434, 0.0482049, 0.0466205, 0.0450888, 0.0435958, 0.0421268, 0.0406931, 0.0393032, 0.0379631,
         0.0366677, 0.0354162, 0.0342073, 0.0330398, 0.0319128, 0.0308267, 0.0297797, 0.0287692, 0.0277928, 0.0268495,
         0.0259383, 0.0250583, 0.024208, 0.0233872, 0.0225968, 0.0218376, 0.0211062, 0.0203995, 0.0196897, 0.0189948,
         0.0183411, 0.0177148, 0.0171129, 0.0165319, 0.0159706, 0.0154266, 0.0148835, 0.0143347, 0.0137903, 0.0132667,
         0.012807, 0.0123966, 0.012009, 0.0116123, 0.0112146, 0.0108303, 0.0104593, 0.010101, 0.00975343, 0.00941479,
         0.00908546, 0.00876776, 0.0084609, 0.00816451, 0.00788252, 0.0076141, 0.00735815, 0.00711087, 0.00687187,
         0.0066409, 0.00641889, 0.0062046, 0.00599768, 0.00579768, 0.00560349, 0.00541492, 0.00522484, 0.00504261,
         0.00486804, 0.00469946, 0.00453673, 0.00437964, 0.00422801, 0.00408163, 0.00394032, 0.00380385, 0.00367215,
         0.00354507, 0.00342352, 0.00330743, 0.00319685, 0.00308992, 0.00298659, 0.00288676, 0.00279024, 0.00269692,
         0.00260671, 0.00251952, 0.00243458, 0.00235152, 0.00226698, 0.00218491, 0.00210584, 0.00202959, 0.00195614,
         0.00188542, 0.00181712, 0.00175132, 0.00168795, 0.00162588, 0.00156576, 0.00150761, 0.00145162, 0.0013977,
         0.00134578, 0.0012958, 0.00124768, 0.00120133, 0.00115724, 0.00111375, 0.00107178, 0.00103129, 0.000992242,
         0.000954583, 0.000918257, 0.000883244, 0.000849488, 0.000816939, 0.000785565, 0.000755334, 0.00072622,
         0.000698159, 0.000671108, 0.000645079, 0.000619993, 0.000595853, 0.000572612, 0.000550216, 0.000528679,
         0.000507958, 0.00048801, 0.000468829, 0.000450387, 0.000432633, 0.000415595, 0.000399184, 0.000383415,
         0.000368279, 0.000353746, 0.000339766, 0.000326349, 0.000313472, 0.000301111, 0.000289253, 0.000277876,
         0.000266965, 0.000256505, 0.000246479, 0.000236873, 0.000227671, 0.000218857, 0.000210456, 0.000202354,
         0.000194569, 0.000187095, 0.000179915, 0.000173016, 0.000166391, 0.000160023, 0.000153908, 0.000148032,
         0.000142385, 0.000136961, 0.000131745, 0.000126734, 0.000121919, 0.000117291, 0.000112845, 0.000108569,
         0.000104459, 0.000100509, 9.67114e-05, 9.30583e-05, 8.95479e-05, 8.6171e-05, 8.29271e-05, 7.98013e-05,
         7.68045e-05, 7.39192e-05, 7.11412e-05, 6.84727e-05, 6.5905e-05, 6.34339e-05, 6.10575e-05, 5.87721e-05,
         5.65742e-05, 5.44591e-05, 5.24244e-05, 5.04667e-05, 4.8583e-05, 4.67709e-05, 4.50273e-05, 4.33495e-05,
         4.17344e-05, 4.01808e-05, 3.86851e-05, 3.72463e-05, 3.58607e-05, 3.45279e-05, 3.32444e-05, 3.20095e-05,
         3.08211e-05, 2.96762e-05, 2.85749e-05, 2.75144e-05, 2.6493e-05, 2.55105e-05, 2.45639e-05, 2.36529e-05,
         2.27757e-05, 2.19312e-05, 2.1118e-05, 2.0335e-05, 1.95811e-05, 1.88551e-05, 1.8156e-05, 1.74828e-05,
         1.68345e-05, 1.62102e-05, 1.56091e-05, 1.50301e-05, 1.44725e-05, 1.39355e-05, 1.34184e-05, 1.29203e-05,
         1.24406e-05, 1.19786e-05, 1.15336e-05, 1.11051e-05, 1.06923e-05, 1.02948e-05, 9.91188e-06, 9.54309e-06,
         9.18789e-06, 8.84577e-06, 8.51627e-06, 8.19889e-06, 7.89321e-06, 7.59879e-06, 7.31522e-06, 7.0421e-06,
         6.77905e-06, 6.5257e-06, 6.28168e-06, 6.04668e-06, 5.82034e-06, 5.60236e-06, 5.39242e-06, 5.19025e-06,
         4.99555e-06, 4.80804e-06, 4.74564e-06, 4.55916e-06, 4.38013e-06, 4.20822e-06, 4.04316e-06, 3.88467e-06,
         3.73247e-06, 3.58632e-06, 3.44596e-06, 3.31117e-06, 3.18171e-06, 3.05738e-06, 2.93795e-06, 2.82325e-06,
         2.71307e-06, 2.60724e-06, 2.50558e-06, 2.40791e-06, 2.31409e-06, 2.22396e-06, 2.13737e-06, 2.05418e-06,
         1.97425e-06, 1.89745e-06, 1.82367e-06, 1.75277e-06]],
    'Li':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0546, 0.054799999999999995, 0.0556667, 0.056567, 0.057482,
         0.058411700000000004, 0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908,
         0.0643145, 0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138,
         0.07195910000000001, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 0.680884, 0.672057, 0.662457, 0.652204, 0.641495, 0.630185, 0.618217, 0.605541, 0.592108, 0.577867,
         0.562767, 0.546756, 0.52979, 0.511913, 0.492899, 0.4723, 0.450106, 0.426271, 0.40066, 0.373113, 0.343436,
         0.311403, 0.276728, 0.239096, 0.198182, 0.153553, 0.104628, 0.0507173, -0.00904566, -0.075763, -0.150875,
         -0.236314, -0.33476, -0.450076, -0.58823, -0.759145, -0.981045, -1.29425, -1.82877, -3.20462, -3.26778,
         -2.01988, -1.68391, -1.44905, -1.20997, -0.978073, -0.760569, -0.54209, -0.319116, -0.0699885, 0.209528,
         0.490103, 0.743078, 0.976848, 1.16223, 1.24896, 1.30607, 1.34649, 1.37483, 1.38674, 1.40488, 1.42925, 1.46026,
         1.49817, 1.56749, 1.65297, 1.74778, 1.84633, 1.96188, 2.09531, 2.24307, 2.39, 2.53184, 2.64865, 2.72433,
         2.7974, 2.85171, 2.87356, 2.92523, 2.97852, 2.97334, 2.98478, 2.99098, 2.9958, 3.0052, 3.02065, 3.04395,
         3.06819, 3.0879, 3.10614, 3.12324, 3.13943, 3.15484, 3.16966, 3.18417, 3.19888, 3.2133, 3.2254, 3.23556,
         3.24442, 3.25202, 3.25797, 3.26235, 3.26778, 3.27528, 3.2827, 3.28877, 3.29388, 3.29834, 3.30227, 3.30557,
         3.30839, 3.31098, 3.31372, 3.31737, 3.32179, 3.32594, 3.32824, 3.32851, 3.32778, 3.32732, 3.3269, 3.32669,
         3.32652, 3.32698, 3.3275, 3.32695, 3.32594, 3.32445, 3.32265, 3.32059, 3.31831, 3.31587, 3.31327, 3.31055,
         3.30771, 3.30479, 3.3018, 3.29878, 3.29574, 3.29282, 3.29002, 3.28707, 3.28389, 3.28043, 3.27686, 3.27318,
         3.26943, 3.26563, 3.26179, 3.25793, 3.25404, 3.25015, 3.24626, 3.24237, 3.2385, 3.23464, 3.23082, 3.22703,
         3.22328, 3.21959, 3.21599, 3.21253, 3.20905, 3.20547, 3.20187, 3.19827, 3.19469, 3.19113, 3.18762, 3.18416,
         3.18077, 3.17744, 3.17411, 3.17076, 3.1674, 3.16407, 3.16076, 3.15749, 3.15424, 3.15103, 3.14785, 3.14473,
         3.14169, 3.13876, 3.13591, 3.13303, 3.13018, 3.12737, 3.12462, 3.12192, 3.11929, 3.11676, 3.11431, 3.11187,
         3.10934, 3.10662, 3.10384, 3.10129, 3.09896, 3.09682, 3.09467, 3.09249, 3.09035, 3.08825, 3.08618, 3.08416,
         3.08217, 3.08021, 3.07829, 3.0764, 3.07455, 3.07274, 3.07097, 3.06925, 3.06756, 3.06592, 3.06432, 3.06274,
         3.06119, 3.05967, 3.05818, 3.05671, 3.05528, 3.0539, 3.05256, 3.05123, 3.04994, 3.04868, 3.04745, 3.04624,
         3.04507, 3.04392, 3.0428, 3.04172, 3.04066, 3.03963, 3.03862, 3.03762, 3.03665, 3.0357, 3.03477, 3.03387,
         3.03298, 3.03212, 3.03128, 3.03047, 3.02967, 3.02889, 3.02812, 3.02737, 3.02664, 3.02593, 3.02524, 3.02456,
         3.02391, 3.02327, 3.02264, 3.02202, 3.02142, 3.02083, 3.02025, 3.01969, 3.01915, 3.01863, 3.01811, 3.01761,
         3.01713, 3.01666, 3.0162, 3.01575, 3.01532, 3.0149, 3.01449, 3.01409, 3.0137, 3.01333, 3.01297, 3.01262,
         3.01226, 3.01192, 3.01159, 3.01126, 3.01094, 3.01063, 3.01033, 3.01003, 3.00974, 3.00946, 3.00919, 3.00892,
         3.00866, 3.00841, 3.00816, 3.00792, 3.00769, 3.00746, 3.00724, 3.00702, 3.00681, 3.00661, 3.00641, 3.00621,
         3.00602, 3.00584, 3.00566, 3.00549, 3.00532, 3.00515, 3.00499, 3.00484, 3.00469, 3.00454, 3.0044, 3.00426,
         3.00413, 3.00399, 3.00387, 3.00374, 3.00362, 3.00351, 3.00339, 3.00328, 3.00318, 3.00307, 3.00297, 3.00287,
         3.00278, 3.00269, 3.0026, 3.00251, 3.00242, 3.00234, 3.00226, 3.00218, 3.00211, 3.00203, 3.00196, 3.00189,
         3.00183, 3.00176, 3.0017, 3.00164, 3.00158, 3.00152, 3.00146, 3.00141, 3.00136, 3.0013, 3.00125, 3.00121,
         3.00116, 3.00111, 3.00107, 3.00103, 3.00098, 3.00094, 3.0009, 3.00087, 3.00083, 3.00079, 3.00076, 3.00072,
         3.00069, 3.00066, 3.00063, 3.0006, 3.00057, 3.00054, 3.00051, 3.00048, 3.00046, 3.00043, 3.00041, 3.00039,
         3.00036, 3.00034, 3.00032, 3.0003, 3.00028, 3.00026, 3.00024, 3.00022, 3.0002, 3.00018, 3.00017, 3.00015,
         3.00013, 3.00012, 3.0001, 3.00009, 3.00007, 3.00006, 3.00005, 3.00003, 3.00002, 3.00001, 3.0, 2.99998, 2.99997,
         2.99996, 2.99995, 2.99994, 2.99993, 2.99992, 2.99991, 2.9999, 2.99989, 2.99989, 2.99988, 2.99987, 2.99986,
         2.99985, 2.99985, 2.99984, 2.99983, 2.99983, 2.99982, 2.99981, 2.99981, 2.9998, 2.9998, 2.99979, 2.99978,
         2.99978, 2.99977, 2.99977, 2.99976, 2.99976, 2.99976, 2.99975, 2.99975, 2.99974, 2.99974],
        [0.116418, 0.117427, 0.118445, 0.119472, 0.120508, 0.121552, 0.122606, 0.123668, 0.12444, 0.125017, 0.125598,
         0.126181, 0.126767, 0.127356, 0.127947, 0.128541, 0.129138, 0.129738, 0.13034, 0.130945, 0.13155, 0.132137,
         0.132727, 0.133319, 0.133914, 0.134512, 0.135113, 0.135716, 0.136322, 0.13693, 0.137541, 0.138155, 0.138772,
         0.139071, 0.138903, 0.138735, 0.138567, 0.138399, 0.138232, 0.138065, 0.137898, 0.137709, 0.137514, 0.137318,
         0.137123, 0.136928, 0.136733, 0.136539, 0.136345, 0.136151, 0.135586, 0.134963, 0.134343, 0.133726, 0.133111,
         0.1325, 0.131891, 0.131285, 0.130681, 0.130081, 0.129483, 0.128888, 0.127621, 0.125603, 0.123616, 0.121662,
         0.119738, 0.117845, 0.115981, 0.114147, 0.112619, 0.111196, 0.109791, 0.108404, 0.107034, 0.105682, 0.104347,
         0.103028, 0.101727, 0.100441, 0.0991722, 0.0974117, 0.0955735, 0.0937699, 0.0920004, 0.0902642, 0.0885608,
         0.0868896, 0.0852499, 0.0836412, 0.0820959, 0.0806583, 0.079246, 0.0778582, 0.0764948, 0.0751554, 0.0738393,
         0.0725463, 0.0712759, 0.0700278, 0.0688015, 0.0674866, 0.0661458, 0.0648315, 0.0636408, 0.0627145, 0.0619885,
         1.99565, 2.17298, 2.3706, 2.58621, 2.78791, 2.94577, 3.08872, 3.21499, 3.33533, 3.4478, 3.5001, 3.5138,
         3.44849, 3.38439, 3.20844, 3.07443, 2.96708, 2.89749, 2.82954, 2.79758, 2.78483, 2.79626, 2.8082, 2.85028,
         2.89349, 2.93282, 2.95689, 2.98116, 3.00563, 3.01725, 3.00041, 2.95722, 2.88927, 2.77915, 2.68556, 2.59906,
         2.48846, 2.39352, 2.36108, 2.23552, 2.1708, 2.10776, 2.05038, 2.00447, 1.967, 1.9344, 1.9, 1.85974, 1.81856,
         1.77829, 1.73891, 1.7004, 1.66274, 1.62592, 1.58989, 1.55441, 1.51713, 1.47975, 1.44328, 1.40771, 1.37302,
         1.33918, 1.30831, 1.28017, 1.25177, 1.22254, 1.19295, 1.16408, 1.13591, 1.10842, 1.08158, 1.05569, 1.03081,
         1.00703, 0.983784, 0.960465, 0.934802, 0.909232, 0.884027, 0.86101, 0.839043, 0.817994, 0.797466, 0.777459,
         0.75796, 0.737532, 0.717367, 0.697533, 0.678251, 0.659499, 0.641261, 0.623542, 0.606309, 0.589546, 0.573246,
         0.557394, 0.541978, 0.527003, 0.512429, 0.498243, 0.48449, 0.470846, 0.457242, 0.443849, 0.430821, 0.418174,
         0.405896, 0.393981, 0.382416, 0.371191, 0.360294, 0.349719, 0.339453, 0.329488, 0.319816, 0.310428, 0.301315,
         0.292473, 0.283888, 0.275554, 0.267464, 0.259613, 0.251897, 0.244208, 0.236732, 0.229475, 0.222436, 0.215618,
         0.20901, 0.202601, 0.196389, 0.19035, 0.184411, 0.178594, 0.172928, 0.167439, 0.162127, 0.156984, 0.152005,
         0.147184, 0.142522, 0.138026, 0.13371, 0.129547, 0.125509, 0.121508, 0.117597, 0.113829, 0.110194, 0.106681,
         0.103275, 0.0999807, 0.0967852, 0.0935986, 0.090385, 0.0871976, 0.0841223, 0.0814099, 0.0789774, 0.0766669,
         0.0742675, 0.0718383, 0.069489, 0.0672168, 0.0650189, 0.0628898, 0.0608226, 0.058817, 0.0568785, 0.0550035,
         0.0531901, 0.0514403, 0.0497524, 0.0481237, 0.0465489, 0.0450255, 0.0435519, 0.0421079, 0.0407079, 0.0393511,
         0.0380389, 0.0367729, 0.0355517, 0.0343936, 0.0332643, 0.0321625, 0.0310974, 0.0300677, 0.0290722, 0.0281097,
         0.0271788, 0.0262784, 0.0254085, 0.0245671, 0.0237533, 0.0229618, 0.0221907, 0.0214382, 0.0207116, 0.0200097,
         0.0193314, 0.0186762, 0.0180431, 0.0174315, 0.0168406, 0.0162689, 0.0157153, 0.0151752, 0.014653, 0.0141488,
         0.0136619, 0.0131917, 0.0127378, 0.0122994, 0.0118761, 0.0114673, 0.0110671, 0.010679, 0.0103031, 0.00994046,
         0.00959413, 0.00926777, 0.00895249, 0.00864796, 0.00835378, 0.0080696, 0.0077951, 0.00752992, 0.00727378,
         0.00702633, 0.00678732, 0.00655644, 0.0063334, 0.00611795, 0.00590983, 0.0057088, 0.00551262, 0.00531145,
         0.00511762, 0.00493087, 0.00475093, 0.00457755, 0.00441008, 0.00424784, 0.00409159, 0.00394107, 0.0037961,
         0.00365646, 0.00352145, 0.00339096, 0.00326531, 0.0031443, 0.00302778, 0.00291558, 0.00280726, 0.00270283,
         0.00260229, 0.00250549, 0.00241229, 0.00232255, 0.00223631, 0.00215327, 0.00207333, 0.00199635, 0.00192222,
         0.00185088, 0.00178266, 0.00171696, 0.00165368, 0.00159274, 0.00153404, 0.00147754, 0.00142325, 0.00137097,
         0.0013206, 0.00127208, 0.00122534, 0.00118039, 0.00113717, 0.00109554, 0.00105543, 0.00101679, 0.000979567,
         0.000943747, 0.000909264, 0.000876043, 0.000844037, 0.000813196, 0.000783486, 0.000754904, 0.000727378,
         0.000700857, 0.0006753, 0.000650677, 0.000626951, 0.000604111, 0.000582105, 0.0005609, 0.000540466,
         0.000520778, 0.000501809, 0.00048354, 0.000465936, 0.000448971, 0.000432626, 0.000416874, 0.000401695,
         0.000387063, 0.000372963, 0.000359378, 0.000346287, 0.000333673, 0.000321512, 0.00030979, 0.000298496,
         0.000287612, 0.000277127, 0.000267023, 0.000257276, 0.000247879, 0.000238826, 0.000230102, 0.000221698,
         0.000213601, 0.000205779, 0.000198251, 0.000190995, 0.000184002, 0.000177261, 0.000170764, 0.000164502,
         0.000158467, 0.000152651, 0.000147044, 0.000141641, 0.000136434, 0.000131415, 0.000126578, 0.000121916,
         0.000117424, 0.000113094, 0.000108922, 0.000104901, 0.000101026, 9.72922e-05, 9.36942e-05, 9.02272e-05,
         8.68865e-05, 8.36676e-05, 8.05662e-05, 7.7578e-05, 7.46991e-05, 7.19256e-05, 6.92535e-05, 6.66795e-05,
         6.41998e-05, 6.18114e-05, 5.95107e-05, 5.72949e-05, 5.51607e-05, 5.31053e-05, 5.11259e-05, 4.92198e-05,
         4.73844e-05, 4.56171e-05, 4.39156e-05, 4.22775e-05, 4.07005e-05, 3.90553e-05, 3.7551e-05, 3.61054e-05,
         3.47159e-05, 3.33804e-05, 3.20968e-05, 3.0863e-05, 2.96771e-05, 2.8537e-05, 2.74411e-05, 2.63875e-05,
         2.53747e-05, 2.4401e-05, 2.34648e-05, 2.25648e-05, 2.16994e-05, 2.08674e-05, 2.00674e-05, 1.92981e-05,
         1.85584e-05, 1.78472e-05, 1.71632e-05, 1.65056e-05, 1.58731e-05, 1.52649e-05, 1.468e-05]],
    'Be':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.011010500000000001, 0.0111886, 0.0113696,
         0.0115535, 0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268,
         0.013135899999999999, 0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146972,
         0.014935, 0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.0183988, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258099999999998, 0.020585799999999998, 0.020918700000000002, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234052, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253602, 0.0257704, 0.0261872, 0.0266108, 0.0270412, 0.0274786, 0.027923, 0.0283747,
         0.0288336, 0.0293, 0.029773900000000002, 0.030255400000000002, 0.030744800000000003, 0.031242100000000002,
         0.0317474, 0.0322609, 0.0327827, 0.0333129, 0.0338517, 0.0343992, 0.034955599999999996, 0.035521000000000004,
         0.0360955, 0.0366793, 0.037272599999999996, 0.0378754, 0.038488, 0.0389, 0.039200000000000006, 0.0395, 0.0399,
         0.04, 0.040276000000000006, 0.040555999999999995, 0.040697000000000004, 0.041127000000000004,
         0.041566000000000006, 0.042167, 0.042473, 0.042942, 0.04326, 0.043746, 0.044076, 0.044411, 0.044581, 0.044924,
         0.045272, 0.045448, 0.045985, 0.0467288, 0.0474846, 0.047674, 0.048265, 0.048871000000000005, 0.049076,
         0.049283, 0.049893, 0.0507, 0.05152, 0.051901, 0.052401, 0.0532485, 0.053401000000000004, 0.053899999999999997,
         0.054401000000000005, 0.054901000000000005, 0.0554, 0.055901000000000006, 0.0568052, 0.056901, 0.057401,
         0.057901, 0.0584, 0.0593446, 0.0603044, 0.060901000000000004, 0.061401000000000004, 0.0623941,
         0.062401000000000005, 0.0634, 0.063902, 0.0644, 0.065401, 0.065901, 0.0669669, 0.06805, 0.0691507,
         0.06940099999999999, 0.07023399999999999, 0.07137, 0.0725243, 0.07256699999999999, 0.0729, 0.073568, 0.0747579,
         0.07490000000000001, 0.075235, 0.075567, 0.076568, 0.077235, 0.077567, 0.077901, 0.078567, 0.07890000000000001,
         0.0801761, 0.0809, 0.081234, 0.081568, 0.0828873, 0.083568, 0.08490099999999999, 0.0862742, 0.0876696,
         0.08908759999999999, 0.0905285, 0.0919928, 0.0934807, 0.0949926, 0.0965291, 0.09756699999999999, 0.098568,
         0.098777, 0.09952599999999999, 0.09990099999999999, 0.10027, 0.10066, 0.10203, 0.1024, 0.10377, 0.10403,
         0.10553, 0.10653, 0.10690000000000001, 0.10776999999999999, 0.10803, 0.10828, 0.10840000000000001, 0.10853,
         0.10865000000000001, 0.10876999999999999, 0.10903, 0.10915000000000001, 0.10926999999999999,
         0.10940000000000001, 0.10953, 0.10976999999999999, 0.10990000000000001, 0.11003, 0.11016, 0.11026999999999999,
         0.11053, 0.11066, 0.11077, 0.11090000000000001, 0.11103, 0.11115, 0.11128, 0.1114, 0.11153,
         0.11159999999999999, 0.1118, 0.112, 0.11225, 0.1125, 0.11275, 0.113, 0.11325, 0.1135, 0.11375, 0.114, 0.11425,
         0.1145, 0.11475, 0.115, 0.1155, 0.11575, 0.116, 0.11625, 0.1165, 0.11675, 0.117, 0.11725, 0.1175, 0.11775,
         0.118, 0.11825, 0.1185, 0.11875, 0.119, 0.11925, 0.1195, 0.1205, 0.121, 0.1215, 0.122, 0.1225, 0.123, 0.1235,
         0.124, 0.125, 0.1255, 0.126, 0.1265, 0.127, 0.1275, 0.128, 0.1285, 0.129, 0.1295, 0.13, 0.1305, 0.131, 0.1315,
         0.132, 0.133, 0.1335, 0.134, 0.1345, 0.1355, 0.136, 0.1365, 0.1375, 0.138, 0.1385, 0.139, 0.14, 0.141, 0.1415,
         0.142, 0.1425, 0.143, 0.1435, 0.144, 0.1445, 0.145, 0.1455, 0.146, 0.1465, 0.148, 0.1485, 0.149, 0.15, 0.151,
         0.152, 0.153, 0.1535, 0.155, 0.1555, 0.1565, 0.157, 0.1575, 0.158, 0.159, 0.16, 0.1605, 0.1615, 0.162, 0.163,
         0.1645, 0.1655, 0.166, 0.167, 0.1675, 0.168, 0.1695, 0.17, 0.1705, 0.171, 0.1715, 0.17299, 0.17399, 0.1745,
         0.17551, 0.176, 0.1765, 0.17751, 0.178, 0.1785, 0.18, 0.181, 0.18151, 0.182, 0.1835, 0.18449000000000002,
         0.187474, 0.1875, 0.188, 0.1885, 0.189, 0.19, 0.1905, 0.191, 0.192, 0.19351, 0.194, 0.1945, 0.195, 0.1955,
         0.1965, 0.1975, 0.19901, 0.2, 0.2015, 0.203, 0.2045, 0.207, 0.2075, 0.20801, 0.2085, 0.2105, 0.212, 0.2125,
         0.213, 0.2135, 0.2145, 0.215, 0.2155, 0.217, 0.218, 0.219, 0.22, 0.2205, 0.221, 0.2215, 0.222, 0.2225, 0.223,
         0.2235, 0.224, 0.2245, 0.226, 0.22649, 0.2275, 0.228, 0.2285, 0.229, 0.2295, 0.2305, 0.231, 0.2315, 0.232,
         0.2345, 0.235, 0.2355, 0.2365, 0.2375, 0.238, 0.2385, 0.2395, 0.24, 0.2405, 0.241, 0.2415, 0.242, 0.2425,
         0.2435, 0.244, 0.2445, 0.245, 0.246, 0.2465, 0.2475, 0.2485, 0.24899000000000002, 0.2495, 0.25, 0.25154,
         0.255608, 0.259743, 0.263944, 0.26821300000000003, 0.272551, 0.276959, 0.281439, 0.285991, 0.290617, 0.295317,
         0.30009399999999997, 0.304947, 0.30988, 0.314892, 0.319985, 0.32516, 0.33042, 0.335764, 0.34119499999999997,
         0.34671300000000005, 0.35232100000000005, 0.35802, 0.36381, 0.369695, 0.37567399999999995, 0.38175, 0.387925,
         0.394199, 0.400575, 0.40705399999999997, 0.41363799999999995, 0.420328, 0.42712599999999995, 0.434035,
         0.44105500000000003, 0.448189, 0.455438, 0.462804, 0.47029000000000004, 0.477896, 0.485626,
         0.49348000000000003, 0.501462, 0.5095729999999999, 0.517815, 0.52619, 0.534701, 0.5433490000000001, 0.552137,
         0.561068, 0.570142, 0.579364, 0.588735, 0.5982569999999999, 0.607933, 0.6177659999999999, 0.627758, 0.637912,
         0.648229, 0.658714, 0.6693680000000001, 0.6801950000000001, 0.691196, 0.702376, 0.713736, 0.7252799999999999,
         0.737011, 0.748932, 0.761045, 0.7733540000000001, 0.7858630000000001, 0.798573, 0.81149, 0.824615, 0.837952,
         0.851505, 0.865278, 0.879273, 0.893495, 0.907946, 0.922631, 0.937554, 0.9527190000000001, 0.968128,
         0.9837870000000001, 0.999699, 1.01587, 1.0323, 1.049, 1.06596, 1.0832, 1.10072, 1.11853, 1.13662, 1.155,
         1.17368, 1.1926700000000001, 1.21196, 1.23156, 1.25148, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.37795,
         1.40023, 1.4228800000000001, 1.4459000000000002, 1.46928, 1.49305, 1.5172, 1.54173, 1.56667, 1.59201, 1.61776,
         1.6439300000000001, 1.67052, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.83933, 1.8690799999999999, 1.89931,
         1.93003, 1.96125, 1.9929700000000001, 2.0252, 2.05796, 2.09124, 2.12507, 2.15944, 2.1943699999999997, 2.22986,
         2.26593, 2.3025700000000002, 2.33982, 2.3776599999999997, 2.41612, 2.4551999999999996, 2.49491, 2.53526,
         2.57627, 2.61794, 2.66028, 2.70331, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998, 2.92911,
         2.9764899999999996, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27728, 3.3302899999999998,
         3.38415, 3.43889, 3.49451, 3.5510300000000004, 3.60846, 3.66683, 3.72613, 3.7864, 3.8476399999999997,
         3.9098800000000002, 3.9731199999999998, 4.03738, 4.10268, 4.16904, 4.236470000000001, 4.30499, 4.37462,
         4.44537, 4.517270000000001, 4.59034, 4.66458, 4.74003, 4.8167, 4.8946000000000005, 4.97377, 5.05421, 5.13596,
         5.21903, 5.30345, 5.3892299999999995, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644,
         5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.74653, 6.85565, 6.96654, 7.07921, 7.19371, 7.31007, 7.4283, 7.54845, 7.67054, 7.7946, 7.92068, 8.04879,
         8.17897, 8.31126, 8.44568, 8.58229, 8.7211, 8.86216, 9.00549, 9.15115, 9.29916, 9.44957, 9.602409999999999,
         9.757719999999999, 9.91554, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998,
         10.9176, 11.094100000000001, 11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153,
         12.412799999999999, 12.6136, 12.8176, 13.024899999999999, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8088, 15.0483, 15.2917, 15.539100000000001, 15.7904, 16.0458, 16.3053, 16.5691,
         16.837, 17.1094, 17.3861, 17.6673, 17.9531, 18.2434, 18.5385, 18.8384, 19.143, 19.4527, 19.7673, 20.087,
         20.411900000000003, 20.742099999999997, 21.0775, 21.4185, 21.7649, 22.1169, 22.4746, 22.838099999999997,
         23.2075, 23.582900000000002, 23.964299999999998, 24.3519, 24.7458, 25.146099999999997, 25.552799999999998,
         25.966099999999997, 26.386, 26.8128, 27.2465, 27.6872, 28.135, 28.5901, 29.0525, 29.5224, 29.9999, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, 2.30967,
         2.31367, 2.31537, 2.31755, 2.32374, 2.34045, 2.37239, 2.38699, 2.396, 2.40177, 2.40538, 2.40746, 2.40846,
         2.40939, 2.41248, 2.4157, 2.42027, 2.41808, 2.40985, 2.39826, 2.38435, 2.36859, 2.35116, 2.33226, 2.30996,
         2.28594, 2.26312, 2.24541, 2.22901, 2.21325, 2.198, 2.18311, 2.16844, 2.15391, 2.13952, 2.12325, 2.10677,
         2.09142, 2.07852, 2.06586, 2.05353, 2.04141, 2.02931, 2.01697, 2.00799, 2.00121, 1.99567, 1.98913, 1.98733,
         1.98264, 1.97786, 1.9761, 1.9696, 1.96327, 1.954, 1.94966, 1.9428, 1.93854, 1.93138, 1.92708, 1.92291, 1.9207,
         1.91607, 1.91126, 1.90903, 1.90129, 1.89036, 1.87948, 1.87667, 1.86782, 1.85943, 1.85755, 1.85503, 1.84657,
         1.83364, 1.82367, 1.81956, 1.81434, 1.80585, 1.80449, 1.79914, 1.79325, 1.78748, 1.78219, 1.77644, 1.76616,
         1.76491, 1.75779, 1.75138, 1.74467, 1.73066, 1.71666, 1.70803, 1.70036, 1.68542, 1.68532, 1.67044, 1.66247,
         1.65492, 1.63983, 1.63182, 1.61497, 1.59766, 1.57948, 1.57524, 1.56001, 1.53888, 1.51676, 1.51586, 1.50929,
         1.49567, 1.47049, 1.46741, 1.46015, 1.45305, 1.43052, 1.41539, 1.40764, 1.40006, 1.38396, 1.37631, 1.34408,
         1.32524, 1.31669, 1.30817, 1.27205, 1.25273, 1.21283, 1.16875, 1.12068, 1.0678, 1.00938, 0.94463, 0.872376,
         0.791324, 0.699761, 0.63131, 0.560328, 0.544993, 0.486543, 0.455599, 0.424344, 0.389731, 0.258588, 0.219148,
         0.0597848, 0.0260858, -0.191568, -0.368308, -0.441904, -0.637412, -0.702374, -0.768299, -0.802126, -0.840651,
         -0.876311, -0.912731, -0.997553, -1.03849, -1.08113, -1.12894, -1.17915, -1.27829, -1.33524, -1.3958, -1.45968,
         -1.5164, -1.66366, -1.74613, -1.81926, -1.91441, -2.01892, -2.12502, -2.25725, -2.40087, -2.58708, -2.70637,
         -3.21583, -3.42252, -3.41684, -3.59292, -3.95038, -3.99197, -3.32582, -2.3851, -1.77257, -1.49267, -1.40646,
         -1.45558, -1.51462, -1.58085, -1.68141, -1.68766, -1.67443, -1.69668, -1.74476, -1.841, -1.91971, -2.01798,
         -2.09181, -1.98599, -1.69069, -1.41511, -1.1717, -1.03307, -0.919695, -0.899806, -0.833607, -0.607801,
         -0.546931, -0.418154, -0.0951663, 0.195563, 0.28727, 0.285511, 0.326778, 0.899833, 1.34102, 1.95659, 2.54905,
         3.16414, 3.67151, 3.96394, 4.07172, 4.14772, 4.13409, 4.07072, 3.96867, 3.81583, 3.62226, 3.45638, 3.17671,
         3.07605, 3.00843, 2.96221, 2.89396, 2.87584, 2.86874, 2.85627, 2.83336, 2.81506, 2.79734, 2.73715, 2.69982,
         2.70638, 2.7155, 2.72019, 2.72987, 2.74333, 2.75592, 2.76383, 2.76841, 2.77007, 2.76964, 2.76561, 2.76343,
         2.77483, 2.7874, 2.81919, 2.85322, 2.86818, 2.89266, 2.89847, 2.93623, 2.96092, 3.01251, 3.0443, 3.08675,
         3.13492, 3.2283, 3.32359, 3.37652, 3.48313, 3.5344, 3.64004, 3.74596, 3.78278, 3.79484, 3.82135, 3.82362,
         3.81959, 3.80124, 3.79268, 3.78838, 3.78748, 3.78804, 3.80814, 3.80347, 3.81339, 3.829, 3.83339, 3.83871,
         3.85216, 3.8443, 3.84361, 3.79942, 3.78489, 3.78464, 3.77923, 3.77455, 3.77588, 3.78737, 3.78737, 3.7791,
         3.77675, 3.77711, 3.78555, 3.79166, 3.79603, 3.80715, 3.82898, 3.83942, 3.84007, 3.83469, 3.83653, 3.84812,
         3.85281, 3.86036, 3.87172, 3.88191, 3.8945, 3.92105, 3.9678, 3.97172, 3.97628, 3.97935, 4.00635, 4.02425,
         4.0276, 4.03863, 4.04264, 4.04244, 4.04818, 4.05146, 4.07177, 4.07937, 4.08572, 4.09161, 4.09066, 4.09659,
         4.10445, 4.11052, 4.115, 4.12075, 4.12176, 4.12134, 4.12348, 4.15704, 4.16101, 4.1785, 4.1919, 4.19439,
         4.19072, 4.19374, 4.19691, 4.20734, 4.21071, 4.2121, 4.215, 4.2048, 4.20096, 4.20132, 4.20371, 4.20288,
         4.20322, 4.20097, 4.20624, 4.20812, 4.2111, 4.20782, 4.19755, 4.1993, 4.21118, 4.20763, 4.20246, 4.19678,
         4.19512, 4.19511, 4.19613, 4.18859, 4.19626, 4.21213, 4.22653, 4.26661, 4.25156, 4.26764, 4.28045, 4.29117,
         4.30032, 4.30821, 4.31501, 4.32087, 4.32588, 4.33013, 4.33368, 4.33653, 4.33874, 4.34029, 4.34126, 4.34227,
         4.34307, 4.34364, 4.34399, 4.34413, 4.34408, 4.34387, 4.34352, 4.34307, 4.34247, 4.34234, 4.34238, 4.34228,
         4.34177, 4.34059, 4.33897, 4.33688, 4.33438, 4.33165, 4.3287, 4.32557, 4.32228, 4.31886, 4.31532, 4.31169,
         4.30798, 4.30421, 4.30038, 4.29651, 4.29262, 4.28871, 4.2848, 4.28091, 4.27707, 4.27342, 4.26964, 4.26575,
         4.26181, 4.25782, 4.25382, 4.24986, 4.24601, 4.24229, 4.23849, 4.23444, 4.22972, 4.22459, 4.22029, 4.21661,
         4.2131, 4.20947, 4.20574, 4.20199, 4.19823, 4.19446, 4.19072, 4.187, 4.18331, 4.17967, 4.17606, 4.17249,
         4.16897, 4.16547, 4.16203, 4.15866, 4.1554, 4.1522, 4.14905, 4.14591, 4.1428, 4.13974, 4.13672, 4.13375,
         4.13082, 4.12794, 4.12511, 4.12233, 4.1196, 4.11692, 4.11429, 4.1117, 4.10917, 4.10668, 4.10424, 4.10185,
         4.09951, 4.09722, 4.09497, 4.09277, 4.09061, 4.08851, 4.08644, 4.08442, 4.08245, 4.08052, 4.07864, 4.07683,
         4.07504, 4.07327, 4.07153, 4.06982, 4.06814, 4.0665, 4.06489, 4.06331, 4.06176, 4.06025, 4.05877, 4.05733,
         4.05592, 4.05453, 4.05319, 4.05187, 4.05059, 4.04935, 4.04813, 4.04693, 4.04575, 4.0446, 4.04346, 4.04236,
         4.04127, 4.04021, 4.03918, 4.03817, 4.03718, 4.03621, 4.03527, 4.03435, 4.03345, 4.03257, 4.03171, 4.03088,
         4.03006, 4.02926, 4.02849, 4.02773, 4.027, 4.02628, 4.02559, 4.02491, 4.02424, 4.02359, 4.02295, 4.02233,
         4.02172, 4.02113, 4.02055, 4.01998, 4.01943, 4.0189, 4.01837, 4.01786, 4.01736, 4.01688, 4.01641, 4.01595,
         4.0155, 4.01506, 4.01464, 4.01423, 4.01382, 4.01343, 4.01304, 4.01267, 4.0123, 4.01195, 4.0116, 4.01126,
         4.01093, 4.01061, 4.0103, 4.01, 4.0097, 4.00941, 4.00913, 4.00886, 4.0086, 4.00834, 4.00808, 4.00784, 4.0076,
         4.00737, 4.00714, 4.00692, 4.00671, 4.0065, 4.0063, 4.0061, 4.00591, 4.00572, 4.00554, 4.00536, 4.00519,
         4.00502, 4.00485, 4.00469, 4.00454, 4.00439, 4.00424, 4.0041, 4.00396, 4.00383, 4.0037, 4.00357, 4.00345,
         4.00333, 4.00321, 4.0031, 4.00299, 4.00288, 4.00277, 4.00267, 4.00257, 4.00248, 4.00238, 4.00229, 4.00221,
         4.00212, 4.00204, 4.00196, 4.00188, 4.0018, 4.00173, 4.00165, 4.00158, 4.00152, 4.00145, 4.00139, 4.00132,
         4.00126, 4.0012, 4.00115, 4.00109, 4.00104, 4.00098, 4.00093, 4.00088, 4.00083, 4.00079, 4.00074, 4.0007,
         4.00065, 4.00061, 4.00057, 4.00053, 4.00049, 4.00046, 4.00042, 4.00039, 4.00035, 4.00032, 4.00029, 4.00026,
         4.00023, 4.0002, 4.00017, 4.00014, 4.00011, 4.00009, 4.00006, 4.00004, 4.00001, 3.99999, 3.99997, 3.99995,
         3.99992, 3.9999, 3.99988, 3.99986, 3.99985, 3.99983, 3.99981, 3.99979, 3.99978, 3.99976, 3.99974, 3.99973,
         3.99971, 3.9997, 3.99969, 3.99967, 3.99966, 3.99966],
        [1.70333, 1.71802, 1.73284, 1.74778, 1.75737, 1.76678, 1.77624, 1.78574, 1.7953, 1.80306, 1.80629, 1.80952,
         1.81276, 1.816, 1.81871, 1.81609, 1.81347, 1.80922, 1.8041, 1.79747, 1.78729, 1.77705, 1.76267, 1.74841,
         1.72956, 1.71004, 1.68541, 1.65917, 1.62778, 1.59448, 1.55788, 1.5205, 1.47675, 1.43237, 1.38176, 1.33102,
         1.27265, 1.22588, 1.19605, 1.16961, 1.14509, 1.10518, 1.0695, 1.03964, 1.01722, 0.999039, 0.987135, 0.952742,
         0.912693, 0.874329, 0.837576, 0.802368, 0.768641, 0.736331, 0.70538, 0.675729, 0.647325, 0.609275, 0.5679,
         0.529334, 0.493388, 0.459883, 0.428653, 0.399544, 0.372411, 0.347121, 0.328404, 0.315229, 0.302582, 0.290443,
         0.278791, 0.267606, 0.25687, 0.246565, 0.236673, 0.227178, 0.218064, 0.211374, 0.206573, 0.201882, 0.197297,
         0.192816, 0.188437, 0.184157, 0.179975, 0.177252, 0.176713, 0.176983, 0.175827, 0.175565, 0.174663, 0.174609,
         0.174013, 0.173456, 0.171435, 0.170039, 0.168799, 0.168198, 0.166905, 0.165791, 0.16539, 0.164383, 0.163618,
         0.162962, 0.161326, 0.161038, 0.159149, 0.157516, 0.15599, 0.155621, 0.155028, 0.155666, 0.155951, 0.154508,
         0.154198, 0.155814, 0.157447, 0.158203, 0.158683, 0.158768, 0.158784, 0.157647, 0.156933, 0.157035, 0.156125,
         0.155633, 0.152967, 0.152689, 0.15156, 0.151256, 0.149795, 0.148143, 0.147555, 0.147236, 0.146656, 0.147197,
         0.147201, 0.146706, 0.147388, 0.147185, 0.147806, 0.147426, 0.147801, 0.147747, 0.147404, 0.147327, 0.14595,
         0.145981, 0.146011, 0.146012, 0.145632, 0.146079, 0.146106, 0.146109, 0.146426, 0.146447, 0.14731, 0.147639,
         0.148124, 0.148179, 0.148938, 0.148969, 0.150222, 0.150928, 0.151099, 0.151573, 0.15238, 0.152793, 0.152919,
         0.153088, 0.152944, 0.152717, 0.152457, 0.152189, 0.15192, 0.151867, 0.151828, 0.151801, 0.152508, 0.152245,
         0.151861, 0.151904, 0.151744, 0.152054, 0.151656, 0.151818, 0.151969, 0.152169, 0.151371, 0.151676, 0.152246,
         0.154099, 0.155662, 0.15622, 0.155741, 0.156004, 0.158215, 0.158122, 0.159793, 0.161052, 0.161306, 0.163454,
         0.163557, 0.165902, 0.168057, 0.168777, 0.171253, 0.172992, 0.17608, 0.179584, 0.183052, 0.183759, 0.188659,
         0.191441, 0.192239, 0.199075, 0.209517, 0.223326, 0.378238, 1.0386, 1.3819, 1.57501, 2.03965, 3.05986, 4.01793,
         4.15418, 3.84564, 3.56793, 3.26353, 3.11127, 3.06546, 3.03372, 3.14487, 3.23324, 3.28469, 3.30771, 3.36223,
         3.42546, 3.58866, 3.75177, 4.02099, 4.48576, 4.69519, 4.80543, 4.79021, 4.76242, 4.72326, 4.70943, 4.73952,
         5.01171, 4.97342, 5.37885, 5.50733, 5.47638, 5.41101, 5.46448, 5.80078, 6.30269, 6.64803, 6.68559, 6.6479,
         6.40082, 6.01367, 5.39328, 5.00813, 4.55903, 4.20865, 3.8273, 3.59578, 3.26529, 3.15721, 3.02786, 2.9266,
         2.9356, 2.93684, 2.94578, 2.93779, 2.94397, 2.93959, 2.89893, 2.87398, 2.87098, 2.84887, 2.83539, 2.87711,
         2.90329, 2.90287, 2.91465, 2.91685, 2.9265, 2.91495, 2.91585, 2.90262, 2.90346, 2.89577, 2.89537, 2.93154,
         2.94822, 2.95243, 2.98597, 2.98029, 2.98203, 3.01367, 3.01671, 3.06074, 3.08803, 3.1284, 3.14926, 3.17679,
         3.18715, 3.19053, 3.19716, 3.19224, 3.16079, 3.15119, 3.07868, 2.93822, 2.85215, 2.81725, 2.73264, 2.6968,
         2.65488, 2.57094, 2.5518, 2.54214, 2.52605, 2.51896, 2.4736, 2.4339, 2.43394, 2.40213, 2.38083, 2.36562,
         2.32073, 2.28306, 2.27434, 2.22984, 2.22505, 2.22872, 2.21064, 2.19974, 2.18992, 2.16785, 2.16766, 2.1558,
         2.16037, 2.15869, 2.16413, 2.15995, 2.16059, 2.14936, 2.14231, 2.13531, 2.11653, 2.11378, 2.11602, 2.10677,
         2.09245, 2.09404, 2.08193, 2.07385, 2.07146, 2.06855, 2.04405, 2.03179, 2.03019, 2.02063, 2.00156, 1.97791,
         1.97716, 1.96995, 1.95601, 1.94417, 1.94719, 1.93625, 1.91827, 1.90175, 1.89162, 1.87778, 1.87308, 1.87799,
         1.86891, 1.8648, 1.85638, 1.85152, 1.84131, 1.83756, 1.84253, 1.82599, 1.81782, 1.80946, 1.79537, 1.77053,
         1.76739, 1.75778, 1.74263, 1.7386, 1.72476, 1.70717, 1.6665, 1.65173, 1.64949, 1.65027, 1.63115, 1.62857,
         1.62029, 1.61693, 1.61172, 1.60246, 1.59846, 1.58125, 1.57866, 1.58572, 1.57948, 1.5614, 1.56099, 1.55568,
         1.55713, 1.55644, 1.55114, 1.55086, 1.56821, 1.56785, 1.55043, 1.54085, 1.50042, 1.46106, 1.42272, 1.38539,
         1.34904, 1.31364, 1.27917, 1.24561, 1.21293, 1.1811, 1.15011, 1.11993, 1.09055, 1.06193, 1.03488, 1.00851,
         0.982821, 0.957781, 0.93338, 0.9096, 0.886427, 0.863843, 0.841835, 0.820388, 0.799486, 0.779118, 0.759267,
         0.738576, 0.718448, 0.697922, 0.677984, 0.658616, 0.639799, 0.621521, 0.603766, 0.586516, 0.569761, 0.553484,
         0.537671, 0.522311, 0.50739, 0.492894, 0.478813, 0.465133, 0.451845, 0.438937, 0.426397, 0.414215, 0.402382,
         0.390887, 0.379297, 0.368051, 0.357139, 0.34655, 0.336275, 0.326305, 0.31663, 0.307242, 0.297321, 0.28772,
         0.27843, 0.270148, 0.262802, 0.255654, 0.247975, 0.240525, 0.233102, 0.225907, 0.218934, 0.212177, 0.205628,
         0.199281, 0.193131, 0.18717, 0.181392, 0.175794, 0.170368, 0.16511, 0.160057, 0.15516, 0.150411, 0.145809,
         0.14125, 0.136834, 0.132557, 0.128412, 0.124398, 0.120509, 0.116741, 0.113091, 0.109556, 0.106131, 0.102813,
         0.0995984, 0.0964847, 0.0934681, 0.0905461, 0.0877153, 0.084973, 0.0823165, 0.079743, 0.0772499, 0.0748349,
         0.0724952, 0.0702288, 0.0680301, 0.0659001, 0.0638369, 0.0618382, 0.0599022, 0.0580268, 0.05621, 0.0543948,
         0.0526382, 0.0509382, 0.0492933, 0.0477014, 0.0461609, 0.0446702, 0.0432276, 0.0418316, 0.0404807, 0.0391734,
         0.0379083, 0.0366841, 0.0354994, 0.034353, 0.0332436, 0.03217, 0.0311311, 0.0300957, 0.0290947, 0.028127,
         0.0271914, 0.026287, 0.0254127, 0.0245675, 0.0237503, 0.0229604, 0.0221967, 0.0214584, 0.0207447, 0.0200547,
         0.0193877, 0.0187429, 0.0181195, 0.0175168, 0.0169342, 0.0163709, 0.0158264, 0.0153, 0.0147911, 0.0142992,
         0.0138236, 0.0133638, 0.0129072, 0.0124663, 0.0120403, 0.011629, 0.0112317, 0.010848, 0.0104774, 0.0101194,
         0.00977365, 0.00943974, 0.00911724, 0.00880575, 0.00850491, 0.00821432, 0.00793369, 0.00766264, 0.00740085,
         0.00714801, 0.0069038, 0.00666401, 0.00643256, 0.00620915, 0.0059935, 0.00578535, 0.00558442, 0.00539045,
         0.00520323, 0.00502252, 0.00484809, 0.00467971, 0.00451716, 0.00436028, 0.00420884, 0.00406267, 0.00391977,
         0.00378191, 0.00364888, 0.00352054, 0.00339671, 0.00327724, 0.00316197, 0.00305075, 0.00294344, 0.00283992,
         0.00274003, 0.00264365, 0.00254975, 0.00245918, 0.00237183, 0.00228759, 0.00220633, 0.00212796, 0.00205238,
         0.00197947, 0.00190916, 0.00184135, 0.00177595, 0.00171287, 0.00165202, 0.00159334, 0.00153675, 0.00148216,
         0.00142952, 0.00137819, 0.0013287, 0.00128099, 0.00123499, 0.00119064, 0.00114789, 0.00110667, 0.00106693,
         0.00102862, 0.000991686, 0.000956077, 0.000921746, 0.000888646, 0.000856737, 0.000825973, 0.000796314,
         0.000767721, 0.000740154, 0.000713574, 0.000687952, 0.000663249, 0.000639433, 0.000616473, 0.000594337,
         0.000572994, 0.000552174, 0.000532111, 0.000512776, 0.000494145, 0.000476188, 0.000458886, 0.000442212,
         0.000426144, 0.00041066, 0.000395739, 0.000381358, 0.000367502, 0.000354148, 0.00034128, 0.00032888,
         0.000316929, 0.000305413, 0.000294207, 0.000283413, 0.000273015, 0.000262998, 0.000253348, 0.000244052,
         0.000235098, 0.000226472, 0.000218163, 0.000210159, 0.000202447, 0.000195019, 0.000187864, 0.000180971,
         0.000174332, 0.000167935, 0.000161773, 0.000155838, 0.00015012, 0.000144612, 0.000139307, 0.000134195,
         0.000129271, 0.000124528, 0.000119959, 0.000115558, 0.000111318, 0.000107234, 0.000103299, 9.95092e-05,
         9.58583e-05, 9.23412e-05, 8.89532e-05, 8.56893e-05, 8.25453e-05, 7.95168e-05, 7.65993e-05, 7.37888e-05,
         7.37882e-05]],
    'B':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.1879, 0.1881, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 2.70114, 2.70924, 2.71684, 2.72467, 2.73292, 2.74123, 2.74958, 2.75795, 2.76635, 2.77479, 2.78332, 2.7922,
         2.80101, 2.80936, 2.81743, 2.82532, 2.83309, 2.84076, 2.84837, 2.85607, 2.86381, 2.87121, 2.87824, 2.88508,
         2.89177, 2.89833, 2.90488, 2.91145, 2.91778, 2.9238, 2.92962, 2.93531, 2.94094, 2.9467, 2.95245, 2.95768,
         2.96242, 2.96687, 2.97107, 2.97504, 2.97882, 2.98242, 2.98589, 2.98929, 2.9927, 2.99591, 2.99887, 3.00149,
         3.00359, 3.0054, 3.00694, 3.00824, 3.00933, 3.0103, 3.01114, 3.01173, 3.01194, 3.01167, 3.01097, 3.00995,
         3.00862, 3.00704, 3.00517, 3.00296, 3.00044, 2.99744, 2.99392, 2.98998, 2.98566, 2.98095, 2.97584, 2.9703,
         2.96424, 2.95761, 2.95047, 2.94283, 2.93493, 2.92657, 2.91715, 2.90673, 2.89532, 2.88287, 2.86954, 2.85569,
         2.84162, 2.82707, 2.8116, 2.79476, 2.77657, 2.75708, 2.73621, 2.71386, 2.68993, 2.66427, 2.63679, 2.60723,
         2.57523, 2.54059, 2.50303, 2.4622, 2.4175, 2.36863, 2.31566, 2.25735, 2.19207, 2.11854, 2.03507, 1.93966,
         1.82931, 1.69968, 1.54436, 1.3536, 1.11057, 0.782171, 0.290493, -0.637089, -4.78581, -4.77338, -2.81976,
         -0.0321484, 0.859101, 1.41819, 1.8326, 2.16495, 2.44452, 2.68979, 2.90804, 3.09795, 3.26593, 3.41619, 3.55209,
         3.67588, 3.7893, 3.89373, 3.9903, 4.07992, 4.16334, 4.24126, 4.31429, 4.38295, 4.44782, 4.50978, 4.56954,
         4.62551, 4.6768, 4.72393, 4.76763, 4.80833, 4.84632, 4.88183, 4.91505, 4.94621, 4.9754, 5.00279, 5.02857,
         5.05277, 5.07551, 5.09696, 5.11718, 5.13624, 5.15427, 5.17136, 5.18754, 5.20299, 5.21918, 5.23517, 5.24857,
         5.26049, 5.27124, 5.28107, 5.29012, 5.29851, 5.30657, 5.31408, 5.32065, 5.32625, 5.33098, 5.33508, 5.33862,
         5.34167, 5.34435, 5.34673, 5.34893, 5.35064, 5.35143, 5.35135, 5.35073, 5.35066, 5.35087, 5.35065, 5.35003,
         5.34917, 5.34826, 5.34744, 5.34702, 5.34607, 5.34351, 5.33936, 5.3339, 5.32934, 5.32662, 5.32467, 5.32199,
         5.3189, 5.31562, 5.31223, 5.30882, 5.30534, 5.30171, 5.29797, 5.29417, 5.29037, 5.28662, 5.2828, 5.27882,
         5.27471, 5.27049, 5.26617, 5.2618, 5.25754, 5.25338, 5.24931, 5.24536, 5.24154, 5.23778, 5.23388, 5.22991,
         5.22591, 5.22191, 5.21792, 5.21394, 5.20998, 5.20605, 5.20216, 5.19831, 5.1945, 5.19075, 5.18704, 5.18336,
         5.17972, 5.17612, 5.17257, 5.16907, 5.16562, 5.16223, 5.1589, 5.15563, 5.15243, 5.14929, 5.14615, 5.14305,
         5.13999, 5.13698, 5.13402, 5.1311, 5.12824, 5.12544, 5.1227, 5.11999, 5.11732, 5.11469, 5.1121, 5.10955,
         5.10705, 5.10459, 5.10216, 5.09981, 5.09757, 5.09532, 5.09311, 5.09094, 5.08881, 5.08672, 5.08468, 5.08267,
         5.0807, 5.07877, 5.07689, 5.07503, 5.07322, 5.07144, 5.06971, 5.068, 5.06633, 5.0647, 5.0631, 5.06154, 5.06001,
         5.05851, 5.05705, 5.05561, 5.05421, 5.05284, 5.0515, 5.05019, 5.04891, 5.04765, 5.04643, 5.04523, 5.04406,
         5.04292, 5.0418, 5.04071, 5.03964, 5.0386, 5.03758, 5.03658, 5.03561, 5.03466, 5.03373, 5.03283, 5.03195,
         5.03109, 5.03024, 5.02942, 5.02862, 5.02784, 5.02708, 5.02633, 5.0256, 5.0249, 5.0242, 5.02353, 5.02287,
         5.02223, 5.02161, 5.021, 5.0204, 5.01982, 5.01926, 5.01871, 5.01817, 5.01765, 5.01714, 5.01665, 5.01616,
         5.01569, 5.01523, 5.01478, 5.01435, 5.01392, 5.01351, 5.01311, 5.01271, 5.01233, 5.01196, 5.0116, 5.01124,
         5.0109, 5.01056, 5.01024, 5.00992, 5.00961, 5.00931, 5.00902, 5.00873, 5.00845, 5.00818, 5.00792, 5.00766,
         5.00741, 5.00717, 5.00693, 5.0067, 5.00648, 5.00626, 5.00605, 5.00584, 5.00564, 5.00545, 5.00526, 5.00507,
         5.00489, 5.00472, 5.00455, 5.00438, 5.00422, 5.00406, 5.00391, 5.00376, 5.00362, 5.00348, 5.00334, 5.00321,
         5.00308, 5.00295, 5.00283, 5.00271, 5.00259, 5.00248, 5.00237, 5.00227, 5.00216, 5.00206, 5.00196, 5.00187,
         5.00178, 5.00169, 5.0016, 5.00152, 5.00143, 5.00135, 5.00128, 5.0012, 5.00113, 5.00105, 5.00099, 5.00092,
         5.00085, 5.00079, 5.00073, 5.00067, 5.00061, 5.00055, 5.0005, 5.00044, 5.00039, 5.00034, 5.00029, 5.00025,
         5.0002, 5.00015, 5.00011, 5.00007, 5.00003, 4.99999, 4.99995, 4.99991, 4.99988, 4.99984, 4.99981, 4.99977,
         4.99974, 4.99971, 4.99968],
        [1.48933, 1.48084, 1.4724, 1.46401, 1.45567, 1.44738, 1.43913, 1.43093, 1.42278, 1.41467, 1.40661, 1.3986,
         1.39063, 1.38271, 1.37483, 1.367, 1.35921, 1.35146, 1.34376, 1.33611, 1.32849, 1.32092, 1.3134, 1.30592,
         1.29847, 1.29108, 1.28304, 1.27123, 1.25954, 1.24795, 1.23647, 1.22509, 1.21382, 1.20265, 1.19158, 1.18062,
         1.16976, 1.15899, 1.14833, 1.13777, 1.1273, 1.11692, 1.10665, 1.09647, 1.08638, 1.07638, 1.06648, 1.05666,
         1.04694, 1.03731, 1.02777, 1.01831, 1.00894, 0.999657, 0.990606, 0.981763, 0.973, 0.964313, 0.955706, 0.947175,
         0.93872, 0.93034, 0.922036, 0.913805, 0.905648, 0.897563, 0.889552, 0.881611, 0.873741, 0.866681, 0.860334,
         0.854029, 0.847767, 0.84155, 0.835377, 0.82925, 0.823169, 0.817131, 0.811138, 0.804267, 0.797376, 0.790543,
         0.783769, 0.777052, 0.77039, 0.763785, 0.757243, 0.750307, 0.743136, 0.736032, 0.728996, 0.722028, 0.715129,
         0.708294, 0.701381, 0.694129, 0.686952, 0.679852, 0.672826, 0.665869, 0.658982, 0.651457, 0.643703, 0.636041,
         0.62847, 0.620981, 0.613587, 0.606281, 0.599067, 0.59194, 0.584894, 0.577734, 0.570345, 0.562897, 0.555186,
         0.547583, 0.540088, 0.532694, 0.525399, 0.518204, 0.511109, 0.503853, 0.496542, 0.488988, 0.481482, 0.474092,
         0.466822, 0.459657, 0.452598, 0.445455, 0.438421, 0.43126, 0.424073, 0.416993, 0.410033, 0.403193, 0.396414,
         0.389685, 0.382981, 0.37624, 0.369619, 0.363116, 0.356731, 0.350464, 0.343808, 0.336799, 0.330006, 0.323331,
         0.317003, 0.311354, 0.306228, 0.301331, 0.296255, 0.290579, 0.284822, 0.27918, 0.273649, 0.268226, 0.262912,
         0.257703, 0.252595, 0.247574, 0.242496, 0.237462, 0.23253, 0.227702, 0.222974, 0.218344, 0.214205, 0.210328,
         0.205697, 0.200712, 0.195525, 0.190474, 0.185553, 0.180757, 0.176085, 0.171826, 0.168067, 0.164874, 0.161758,
         0.158617, 0.155123, 0.152313, 4.25155, 4.24286, 4.1667, 4.09191, 4.02128, 3.95414, 3.88815, 3.82327, 3.75945,
         3.68555, 3.61074, 3.53565, 3.46212, 3.39013, 3.31961, 3.25058, 3.183, 3.11683, 3.05201, 2.98855, 2.92641,
         2.86554, 2.80593, 2.74757, 2.69044, 2.63274, 2.57409, 2.51536, 2.45779, 2.40154, 2.34657, 2.29285, 2.24035,
         2.18908, 2.13898, 2.09001, 2.0422, 1.99548, 1.94978, 1.90518, 1.8616, 1.81899, 1.77735, 1.73667, 1.69691,
         1.65808, 1.6203, 1.58371, 1.5454, 1.50702, 1.46951, 1.43298, 1.39737, 1.36262, 1.32873, 1.29556, 1.26256,
         1.22991, 1.19786, 1.16667, 1.13629, 1.1067, 1.07788, 1.04981, 1.02238, 0.995385, 0.968563, 0.942202, 0.91655,
         0.892625, 0.869687, 0.84655, 0.823799, 0.801516, 0.779833, 0.758739, 0.738149, 0.717286, 0.695804, 0.674188,
         0.65325, 0.634968, 0.618719, 0.603267, 0.586951, 0.570232, 0.553984, 0.538204, 0.522872, 0.507937, 0.493312,
         0.479013, 0.465121, 0.451634, 0.438538, 0.425697, 0.413094, 0.400743, 0.388746, 0.377113, 0.365835, 0.355111,
         0.344749, 0.334727, 0.324999, 0.315525, 0.306299, 0.297006, 0.287954, 0.279137, 0.270598, 0.262319, 0.254289,
         0.246507, 0.238961, 0.231645, 0.224555, 0.217682, 0.211021, 0.204548, 0.198261, 0.192151, 0.186228, 0.180488,
         0.174925, 0.169534, 0.16431, 0.159248, 0.154338, 0.149571, 0.144939, 0.140388, 0.135973, 0.131697, 0.127556,
         0.123544, 0.119658, 0.115894, 0.112248, 0.108716, 0.105266, 0.101916, 0.0986663, 0.0955176, 0.0924686,
         0.0895166, 0.0866612, 0.0838971, 0.0812206, 0.0787027, 0.0761739, 0.0737227, 0.0713481, 0.0690489, 0.066814,
         0.0646543, 0.0625607, 0.0605286, 0.0585635, 0.0566582, 0.0548123, 0.0530246, 0.0512928, 0.0496148, 0.0479897,
         0.0464157, 0.0448913, 0.0434149, 0.0419853, 0.0406005, 0.0392606, 0.0379625, 0.0367055, 0.0354884, 0.0343104,
         0.0331697, 0.0320658, 0.0309971, 0.0299625, 0.0289616, 0.0279922, 0.0270543, 0.0261471, 0.0252687, 0.024419,
         0.0235963, 0.0228007, 0.0220309, 0.0212856, 0.0205649, 0.0198682, 0.0191937, 0.0185476, 0.0179165, 0.0173072,
         0.0167181, 0.0161487, 0.015598, 0.0150659, 0.0145518, 0.0140547, 0.0135741, 0.0131094, 0.0126607, 0.0122266,
         0.0118072, 0.0114019, 0.0110101, 0.0106315, 0.0102655, 0.00991185, 0.00957001, 0.00923971, 0.00892048,
         0.00861194, 0.0083138, 0.00802574, 0.00774736, 0.0074783, 0.00721834, 0.00696712, 0.00672443, 0.00648984,
         0.00626329, 0.0060444, 0.00583287, 0.00562839, 0.005431, 0.00524026, 0.00505601, 0.004878, 0.00470595,
         0.0045399, 0.00437949, 0.00422456, 0.00407489, 0.0039302, 0.00379062, 0.00365578, 0.00352547, 0.00339979,
         0.00327838, 0.00316109, 0.00304783, 0.00293857, 0.00283291, 0.00273103, 0.00263256, 0.00253775, 0.00244607,
         0.00235757, 0.00227215, 0.0021897, 0.00211014, 0.00203335, 0.00195925, 0.00188774, 0.00181875, 0.00175219,
         0.00168796, 0.00162601, 0.00156625, 0.0015086, 0.001453, 0.00139938, 0.00134766, 0.0012978, 0.00124972,
         0.00120336, 0.00115867, 0.00111559, 0.00107406, 0.00103404, 0.000995465, 0.000958296, 0.000922482, 0.000887977,
         0.000854736, 0.000822718, 0.000791879, 0.00076218, 0.000733582, 0.000706047, 0.00067954, 0.000654024,
         0.000629466, 0.000605832, 0.000583093, 0.000561215, 0.000540171, 0.00051993, 0.000500466, 0.00048156,
         0.000463572, 0.000446275, 0.000429641, 0.000413645, 0.00039826, 0.000383463, 0.000369231, 0.000355541,
         0.000342372, 0.000329702, 0.000317515, 0.000305788, 0.000294506, 0.00028365, 0.000273204, 0.000263151,
         0.000253477, 0.000244167, 0.000235206, 0.000226582, 0.000218281, 0.00021029, 0.000202598, 0.000195192,
         0.000188063]],
    'C':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.2841, 0.2843,
         0.285989, 0.290615, 0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158,
         0.330418, 0.335762, 0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748,
         0.38792200000000004, 0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124,
         0.434032, 0.441052, 0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894,
         0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065,
         0.5701390000000001, 0.579361, 0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755,
         0.637908, 0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008,
         0.748928, 0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502,
         0.865274, 0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586,
         1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155,
         1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.63318, 3.67378, 3.7127, 3.74753, 3.77973, 3.80969, 3.83764, 3.86374, 3.88807, 3.91071, 3.93156, 3.95026,
         3.96709, 3.98488, 4.00253, 4.01992, 4.03712, 4.05432, 4.0736, 4.09449, 4.1101, 4.12229, 4.13211, 4.13985,
         4.14559, 4.14925, 4.14955, 4.14584, 4.14175, 4.14174, 4.143, 4.14486, 4.14698, 4.14913, 4.15113, 4.15277,
         4.15371, 4.15307, 4.1496, 4.14997, 4.1527, 4.15681, 4.16209, 4.16851, 4.17625, 4.186, 4.19949, 4.21096, 4.2191,
         4.22582, 4.23161, 4.23666, 4.24111, 4.24504, 4.24852, 4.2516, 4.2543, 4.25667, 4.25872, 4.26047, 4.26194,
         4.26314, 4.26408, 4.26478, 4.26524, 4.26546, 4.26547, 4.26525, 4.26481, 4.26417, 4.26332, 4.26226, 4.261,
         4.25953, 4.25787, 4.256, 4.25393, 4.25166, 4.24919, 4.24651, 4.24363, 4.24054, 4.23724, 4.23373, 4.23, 4.22606,
         4.22189, 4.21751, 4.21289, 4.20806, 4.20299, 4.19772, 4.19225, 4.18666, 4.18122, 4.17533, 4.1686, 4.16122,
         4.15329, 4.14484, 4.13587, 4.12638, 4.11636, 4.10578, 4.09464, 4.0829, 4.07054, 4.05754, 4.04385, 4.02945,
         4.01429, 3.99834, 3.98158, 3.96398, 3.94558, 3.92716, 3.90705, 3.88443, 3.85977, 3.83308, 3.80428, 3.77323,
         3.73972, 3.70351, 3.66428, 3.62164, 3.57499, 3.52435, 3.46902, 3.40812, 3.34061, 3.26522, 3.18027, 3.08474,
         2.97293, 2.84002, 2.67985, 2.48138, 2.22505, 1.87159, 1.32192, 0.158573, -4.04882, -4.04031, -0.28333, 1.43967,
         2.20576, 2.71286, 3.09475, 3.40186, 3.65884, 3.87969, 4.07315, 4.2451, 4.39967, 4.53993, 4.66823, 4.78642,
         4.89606, 4.99852, 5.09524, 5.1891, 5.27926, 5.36049, 5.43267, 5.49897, 5.5601, 5.61669, 5.6692, 5.71803,
         5.76351, 5.80593, 5.84557, 5.88264, 5.91737, 5.94998, 5.98074, 6.01022, 6.03767, 6.06268, 6.08579, 6.10721,
         6.12709, 6.14556, 6.16271, 6.17864, 6.19344, 6.20717, 6.21992, 6.23174, 6.24271, 6.25287, 6.26227, 6.27097,
         6.279, 6.28639, 6.29312, 6.29901, 6.30406, 6.30972, 6.31822, 6.32783, 6.33449, 6.33933, 6.34306, 6.34594,
         6.34813, 6.34973, 6.3508, 6.3514, 6.3516, 6.35148, 6.35111, 6.35042, 6.34934, 6.34793, 6.34628, 6.34445,
         6.34244, 6.34016, 6.33768, 6.33503, 6.33222, 6.3293, 6.32643, 6.32362, 6.32048, 6.3171, 6.31359, 6.30996,
         6.30622, 6.30242, 6.29857, 6.29469, 6.29081, 6.28694, 6.28313, 6.27931, 6.27534, 6.27127, 6.26716, 6.26302,
         6.25886, 6.25469, 6.25054, 6.2464, 6.2423, 6.23822, 6.23418, 6.2301, 6.22604, 6.222, 6.21798, 6.214, 6.21005,
         6.20616, 6.20233, 6.19857, 6.1948, 6.19106, 6.18734, 6.18366, 6.18003, 6.17643, 6.17288, 6.16938, 6.16594,
         6.16261, 6.15928, 6.156, 6.15276, 6.14957, 6.14643, 6.14334, 6.14028, 6.13729, 6.13433, 6.13143, 6.12857,
         6.12576, 6.123, 6.12028, 6.11762, 6.115, 6.11243, 6.1099, 6.10742, 6.10498, 6.10259, 6.10024, 6.09794, 6.09569,
         6.09347, 6.0913, 6.08917, 6.08708, 6.08503, 6.08302, 6.08105, 6.07912, 6.07723, 6.07538, 6.07357, 6.07179,
         6.07005, 6.06834, 6.06667, 6.06504, 6.06343, 6.06186, 6.06033, 6.05883, 6.05736, 6.05592, 6.05451, 6.05313,
         6.05178, 6.05046, 6.04917, 6.04791, 6.04667, 6.04547, 6.04429, 6.04313, 6.042, 6.0409, 6.03983, 6.03877,
         6.03774, 6.03674, 6.03576, 6.0348, 6.03386, 6.03295, 6.03205, 6.03118, 6.03033, 6.0295, 6.02869, 6.02789,
         6.02712, 6.02637, 6.02563, 6.02491, 6.02421, 6.02352, 6.02285, 6.0222, 6.02156, 6.02094, 6.02034, 6.01975,
         6.01917, 6.01861, 6.01806, 6.01753, 6.017, 6.0165, 6.016, 6.01552, 6.01505, 6.01459, 6.01414, 6.0137, 6.01328,
         6.01286, 6.01246, 6.01206, 6.01168, 6.01131, 6.01094, 6.01059, 6.01024, 6.00991, 6.00958, 6.00926, 6.00895,
         6.00864, 6.00835, 6.00806, 6.00778, 6.00751, 6.00724, 6.00698, 6.00673, 6.00648, 6.00625, 6.00601, 6.00579,
         6.00557, 6.00535, 6.00514, 6.00494, 6.00474, 6.00455, 6.00436, 6.00418, 6.004, 6.00383, 6.00366, 6.0035,
         6.00334, 6.00319, 6.00304, 6.00289, 6.00275, 6.00261, 6.00248, 6.00235, 6.00222, 6.00211, 6.00199, 6.00187,
         6.00176, 6.00165, 6.00154, 6.00144, 6.00134, 6.00124, 6.00115, 6.00105, 6.00096, 6.00088, 6.00079, 6.00071,
         6.00063, 6.00055, 6.00048, 6.0004, 6.00033, 6.00026, 6.0002, 6.00013, 6.00007, 6.0],
        [0.806885, 0.851522, 0.898628, 0.948341, 1.0008, 1.05755, 1.12167, 1.18968, 1.26181, 1.33832, 1.41946, 1.50553,
         1.58971, 1.6782, 1.77161, 1.87023, 1.97433, 2.08423, 2.20025, 2.29235, 2.38287, 2.47696, 2.57477, 2.67645,
         2.77114, 2.84605, 2.92298, 3.00199, 3.08313, 3.16647, 3.24213, 3.28778, 3.33408, 3.38103, 3.42863, 3.47691,
         3.52041, 3.54277, 3.56528, 3.58793, 3.61072, 3.63366, 3.65674, 3.67997, 3.70335, 3.69489, 3.67204, 3.64934,
         3.62677, 3.60434, 3.58205, 3.5599, 3.5332, 3.47892, 3.42547, 3.37285, 3.32103, 3.27, 3.21977, 3.1703, 3.12096,
         3.0635, 3.00708, 2.95171, 2.89736, 2.84401, 2.79164, 2.74024, 2.68978, 2.63618, 2.5836, 2.53206, 2.48155,
         2.43205, 2.38354, 2.33599, 2.2894, 2.24373, 2.19898, 2.15799, 2.11827, 2.07928, 2.04101, 2.00344, 1.96657,
         1.93037, 1.89011, 1.8465, 1.8039, 1.76228, 1.72163, 1.68191, 1.6431, 1.6052, 1.56917, 1.54376, 1.51876,
         1.49417, 1.46998, 1.44618, 1.42276, 1.39972, 1.37705, 1.35475, 1.33282, 1.31546, 1.30168, 1.28804, 1.27454,
         1.26118, 1.24797, 1.23489, 1.22195, 1.20654, 1.18498, 1.16381, 1.14301, 1.12258, 1.10252, 1.08282, 1.06347,
         1.04447, 1.0258, 1.00747, 0.98947, 0.971788, 0.954423, 0.937369, 0.920617, 0.904167, 0.888009, 0.872141,
         0.856556, 0.84125, 0.826217, 0.811453, 0.796952, 0.782711, 0.768724, 0.754987, 0.741496, 0.728246, 0.715232,
         0.702451, 0.689898, 0.67757, 0.665462, 0.65357, 0.641891, 0.630421, 0.619156, 0.608091, 0.597224, 0.586552,
         0.576071, 0.565777, 0.555666, 0.545737, 0.535985, 0.526406, 0.517, 0.507761, 0.497457, 0.487361, 0.477469,
         0.467777, 0.458283, 0.448981, 0.439868, 0.430941, 0.422193, 0.413624, 0.405229, 0.397004, 0.388946, 0.381052,
         0.373318, 0.365741, 0.358317, 0.351045, 0.343919, 0.336939, 0.3301, 0.320995, 0.312096, 0.303443, 0.295031,
         0.286851, 0.278898, 0.271166, 0.263648, 0.256338, 0.249231, 0.242516, 0.236381, 0.230402, 0.224573, 0.218892,
         0.213355, 0.207958, 0.202179, 0.194683, 0.187465, 0.180514, 0.173821, 0.167377, 0.161171, 0.155195, 0.149441,
         0.146163, 4.18872, 4.15857, 4.07798, 3.99896, 3.92146, 3.84546, 3.77095, 3.69787, 3.6262, 3.55593, 3.48703,
         3.41945, 3.35318, 3.2882, 3.22448, 3.162, 3.10072, 3.04063, 2.9817, 2.91649, 2.84817, 2.78144, 2.71628,
         2.65264, 2.5905, 2.52981, 2.47054, 2.41266, 2.35614, 2.30094, 2.24703, 2.19439, 2.14298, 2.09278, 2.04367,
         1.99418, 1.94589, 1.89876, 1.85278, 1.80791, 1.76412, 1.7214, 1.67971, 1.63903, 1.59933, 1.5606, 1.52281,
         1.48593, 1.44994, 1.41483, 1.38056, 1.34713, 1.3145, 1.28267, 1.2516, 1.22249, 1.19523, 1.16897, 1.13958,
         1.10844, 1.07816, 1.04871, 1.02006, 0.992182, 0.965046, 0.938635, 0.912939, 0.887954, 0.863661, 0.839923,
         0.816714, 0.794041, 0.772006, 0.750584, 0.729761, 0.709358, 0.6895, 0.670177, 0.651378, 0.633116, 0.615377,
         0.598194, 0.581226, 0.564459, 0.548198, 0.532391, 0.51702, 0.502116, 0.48764, 0.473579, 0.459933, 0.446675,
         0.433794, 0.421175, 0.408804, 0.396652, 0.384872, 0.373439, 0.362342, 0.351578, 0.341132, 0.330994, 0.321159,
         0.311605, 0.302316, 0.29323, 0.284407, 0.275847, 0.267545, 0.259493, 0.251684, 0.24411, 0.236764, 0.229642,
         0.222665, 0.215877, 0.209279, 0.202884, 0.196685, 0.190676, 0.18485, 0.179202, 0.173726, 0.168474, 0.163292,
         0.158263, 0.153384, 0.148648, 0.144053, 0.139593, 0.135267, 0.131069, 0.126998, 0.123042, 0.11921, 0.115492,
         0.111882, 0.108383, 0.10499, 0.101694, 0.0985042, 0.0954028, 0.0923971, 0.0894832, 0.0866617, 0.0839148,
         0.0812599, 0.0786821, 0.0761825, 0.0737584, 0.071408, 0.0691288, 0.0669194, 0.0647767, 0.0626991, 0.0606853,
         0.0587327, 0.0568396, 0.0550042, 0.0532244, 0.0514997, 0.0498278, 0.0482071, 0.0466352, 0.0451127, 0.0436367,
         0.0422212, 0.0408351, 0.0394919, 0.0381921, 0.0369324, 0.035713, 0.0345329, 0.0333896, 0.0322825, 0.03121,
         0.0301723, 0.0291678, 0.0281953, 0.0272539, 0.0263428, 0.0254606, 0.0246074, 0.023781, 0.0229809, 0.0222063,
         0.0214569, 0.0207329, 0.0200314, 0.0193522, 0.0186948, 0.0180595, 0.0174453, 0.0168501, 0.0162746, 0.015718,
         0.0151795, 0.0146587, 0.0141549, 0.0136678, 0.0131966, 0.0127407, 0.0123, 0.0118738, 0.0114619, 0.0110634,
         0.0106782, 0.0103059, 0.00994583, 0.00959775, 0.00926134, 0.00893624, 0.0086219, 0.0083182, 0.00802475,
         0.00774104, 0.00746686, 0.00720204, 0.00694614, 0.00669902, 0.00646026, 0.00622938, 0.00600659, 0.00579136,
         0.0055835, 0.00538276, 0.00518891, 0.00500173, 0.00482101, 0.00464654, 0.0044781, 0.00431552, 0.00415859,
         0.00400712, 0.00386096, 0.00371991, 0.00358382, 0.00345251, 0.00332584, 0.00320365, 0.0030858, 0.00297213,
         0.00286252, 0.00275683, 0.00265492, 0.00255668, 0.00246198, 0.00237071, 0.00228275, 0.00219799, 0.00211632,
         0.00203764, 0.00196186, 0.00188887, 0.00181858, 0.00175089, 0.00168574, 0.00162301, 0.00156265, 0.00150455,
         0.00144866, 0.00139489, 0.00134317, 0.00129343, 0.00124561, 0.00119964, 0.00116295, 0.00111818, 0.00107519,
         0.00103391, 0.000994268, 0.000956195, 0.000919629, 0.000884508, 0.000850771, 0.000818364, 0.00078723,
         0.00075732, 0.000728582, 0.000700971, 0.000674438, 0.000648942, 0.000624439, 0.00060089, 0.000578257,
         0.000556501, 0.00053559, 0.000515487, 0.000496161, 0.000477581, 0.000459716, 0.00044254]],
    'N':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794,
         0.037200000000000004, 0.037399999999999996, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861,
         0.041039299999999994, 0.0417031, 0.0423776, 0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004,
         0.045917400000000004, 0.04665999999999999, 0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528,
         0.0505576, 0.051375300000000006, 0.0522062, 0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567,
         0.057482, 0.058411700000000004, 0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834,
         0.0632908, 0.0643145, 0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138,
         0.07195910000000001, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.4098, 0.41, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052,
         0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478,
         0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.0967, 3.18574, 3.26861, 3.34589, 3.41793, 3.48497, 3.54521, 3.60004, 3.65406, 3.70766, 3.75942, 3.80887,
         3.85551, 3.89834, 3.93428, 3.93988, 3.95594, 4.02773, 4.0871, 4.13881, 4.18663, 4.23179, 4.27486, 4.31619,
         4.35601, 4.39451, 4.43188, 4.46832, 4.504, 4.54124, 4.57806, 4.61022, 4.6391, 4.66531, 4.68891, 4.70963,
         4.72672, 4.73743, 4.72873, 4.74381, 4.79551, 4.82377, 4.85174, 4.87868, 4.90536, 4.93244, 4.95892, 4.98466,
         5.00922, 5.03169, 5.05325, 5.07398, 5.09412, 5.11385, 5.1335, 5.15315, 5.17222, 5.19044, 5.20726, 5.22311,
         5.23827, 5.25289, 5.26721, 5.28116, 5.29458, 5.30767, 5.31977, 5.3309, 5.34142, 5.35147, 5.36108, 5.3703,
         5.37913, 5.3874, 5.39514, 5.4025, 5.40957, 5.41689, 5.42415, 5.43019, 5.4353, 5.43994, 5.44406, 5.44773,
         5.45099, 5.45389, 5.45644, 5.45866, 5.46061, 5.4623, 5.46373, 5.46493, 5.46595, 5.46695, 5.46801, 5.46877,
         5.46881, 5.46841, 5.46766, 5.46663, 5.46534, 5.46382, 5.46208, 5.4602, 5.4582, 5.45616, 5.45421, 5.45304,
         5.45202, 5.44957, 5.44577, 5.44112, 5.4358, 5.42989, 5.42343, 5.41647, 5.40903, 5.40111, 5.39274, 5.38392,
         5.37465, 5.36494, 5.35477, 5.34415, 5.33308, 5.32155, 5.30957, 5.29733, 5.2845, 5.27067, 5.25612, 5.24084,
         5.2248, 5.20796, 5.19029, 5.17175, 5.15227, 5.13178, 5.11023, 5.08753, 5.06357, 5.03826, 5.01147, 4.98307,
         4.95292, 4.92083, 4.88664, 4.85017, 4.81152, 4.77024, 4.7242, 4.67285, 4.61616, 4.55339, 4.48353, 4.40525,
         4.31681, 4.21577, 4.09877, 3.96099, 3.79504, 3.58874, 3.32035, 2.94481, 2.34175, 0.902755, -3.34729, -3.3407,
         1.37475, 2.76993, 3.4718, 3.9503, 4.31518, 4.61038, 4.85808, 5.07115, 5.25773, 5.42335, 5.57192, 5.70635,
         5.82888, 5.94124, 6.04487, 6.14095, 6.23051, 6.31452, 6.39405, 6.47106, 6.54609, 6.61317, 6.67262, 6.72717,
         6.77737, 6.82373, 6.86664, 6.90643, 6.94337, 6.97771, 7.00967, 7.03943, 7.06718, 7.09308, 7.11728, 7.13995,
         7.16124, 7.18132, 7.20082, 7.21973, 7.2371, 7.2523, 7.2655, 7.27724, 7.28754, 7.29659, 7.30472, 7.31226,
         7.31934, 7.32586, 7.33212, 7.33793, 7.34274, 7.34685, 7.35026, 7.35311, 7.35545, 7.35753, 7.35965, 7.36113,
         7.36187, 7.36219, 7.36212, 7.36171, 7.36099, 7.36002, 7.35885, 7.35751, 7.35616, 7.35479, 7.35321, 7.35124,
         7.34877, 7.34603, 7.34309, 7.33996, 7.33664, 7.33321, 7.32971, 7.32611, 7.3225, 7.31883, 7.31491, 7.31092,
         7.30688, 7.30279, 7.29866, 7.29452, 7.29037, 7.28628, 7.28224, 7.27808, 7.27386, 7.26959, 7.2653, 7.26101,
         7.25672, 7.25245, 7.24817, 7.24396, 7.2399, 7.23578, 7.23167, 7.22757, 7.2235, 7.21945, 7.21543, 7.21145,
         7.2075, 7.20358, 7.1997, 7.19586, 7.19206, 7.18831, 7.18459, 7.18093, 7.1773, 7.17372, 7.17019, 7.1667,
         7.16327, 7.15988, 7.15654, 7.15324, 7.15, 7.1468, 7.14365, 7.14055, 7.1375, 7.13451, 7.13155, 7.12865, 7.12579,
         7.12299, 7.12023, 7.11752, 7.11486, 7.11224, 7.10967, 7.10714, 7.10467, 7.10224, 7.09985, 7.09749, 7.09518,
         7.09292, 7.0907, 7.08853, 7.0864, 7.0843, 7.08226, 7.08025, 7.07828, 7.07635, 7.07446, 7.07262, 7.07081,
         7.06903, 7.0673, 7.0656, 7.06394, 7.06231, 7.06072, 7.05916, 7.05764, 7.05615, 7.0547, 7.05327, 7.05188,
         7.05052, 7.04918, 7.04788, 7.04661, 7.04537, 7.04415, 7.04296, 7.04181, 7.04067, 7.03957, 7.03848, 7.03743,
         7.0364, 7.03539, 7.03441, 7.03345, 7.03251, 7.03159, 7.0307, 7.02983, 7.02898, 7.02814, 7.02733, 7.02654,
         7.02577, 7.02502, 7.02428, 7.02356, 7.02286, 7.02218, 7.02152, 7.02087, 7.02023, 7.01962, 7.01901, 7.01843,
         7.01785, 7.0173, 7.01675, 7.01622, 7.0157, 7.0152, 7.01471, 7.01423, 7.01376, 7.01331, 7.01287, 7.01243,
         7.01201, 7.0116, 7.0112, 7.01082, 7.01044, 7.01007, 7.00971, 7.00936, 7.00902, 7.00868, 7.00836, 7.00805,
         7.00774, 7.00744, 7.00715, 7.00687, 7.00659, 7.00632, 7.00606, 7.00581, 7.00556, 7.00532, 7.00509, 7.00486,
         7.00464, 7.00442, 7.00422, 7.00401, 7.00381, 7.00362, 7.00344, 7.00325, 7.00308, 7.00291, 7.00274, 7.00258,
         7.00242, 7.00227, 7.00212, 7.00197, 7.00183, 7.0017, 7.00156, 7.00143, 7.00131, 7.00119, 7.00107, 7.00095,
         7.00084, 7.00073, 7.00063],
        [0.677847, 0.689631, 0.70162, 0.713817, 0.726227, 0.738852, 0.751697, 0.765839, 0.786026, 0.806743, 0.828008,
         0.849833, 0.872233, 0.895223, 0.91928, 0.954622, 0.991323, 1.02943, 1.06901, 1.11011, 1.15279, 1.22432,
         1.30424, 1.38938, 1.48008, 1.5767, 1.68655, 1.80625, 1.93445, 2.07175, 2.21879, 2.37627, 2.54492, 2.68091,
         2.82044, 2.96724, 3.12169, 3.28417, 3.45511, 3.63494, 3.79196, 3.94069, 4.09526, 4.25588, 4.42281, 4.54192,
         4.62172, 4.70292, 4.78554, 4.86963, 4.92315, 4.94757, 4.97211, 4.99678, 5.02156, 5.02138, 4.99215, 4.96309,
         4.9342, 4.90547, 4.87692, 4.84853, 4.8203, 4.77252, 4.69687, 4.62241, 4.54913, 4.47701, 4.40604, 4.33619,
         4.26745, 4.1998, 4.13322, 4.0677, 4.00711, 3.95223, 3.8981, 3.84471, 3.79205, 3.74012, 3.68889, 3.63837,
         3.59457, 3.64104, 3.6015, 3.55191, 3.503, 3.45476, 3.40719, 3.36027, 3.314, 3.26836, 3.22336, 3.17897, 3.1352,
         3.09203, 3.04945, 3.00283, 2.95442, 2.90678, 2.85992, 2.81381, 2.76844, 2.72381, 2.67989, 2.63668, 2.65841,
         2.63101, 2.59803, 2.56546, 2.53328, 2.5015, 2.46913, 2.43557, 2.40164, 2.3663, 2.33146, 2.2971, 2.26327,
         2.22997, 2.19716, 2.16482, 2.13196, 2.09899, 2.06521, 2.03172, 1.99878, 1.96635, 1.93446, 1.90309, 1.87156,
         1.84053, 1.80919, 1.77788, 1.74711, 1.71687, 1.68715, 1.65784, 1.62891, 1.60031, 1.5719, 1.544, 1.51661,
         1.48969, 1.46326, 1.43628, 1.40887, 1.38222, 1.35606, 1.33039, 1.30519, 1.28048, 1.25624, 1.23245, 1.20914,
         1.18627, 1.16381, 1.14177, 1.12014, 1.09894, 1.07815, 1.0576, 1.03651, 1.01582, 0.995549, 0.975693, 0.956241,
         0.937174, 0.918471, 0.900155, 0.882212, 0.86461, 0.847362, 0.830458, 0.813567, 0.795548, 0.77626, 0.757438,
         0.739074, 0.721154, 0.70367, 0.686608, 0.669961, 0.653718, 0.637868, 0.622402, 0.607312, 0.592587, 0.578219,
         0.5642, 0.550521, 0.537173, 0.524149, 0.51144, 0.498997, 0.486268, 0.473865, 0.461778, 0.449999, 0.438521,
         0.427335, 0.416435, 0.405812, 0.395461, 0.385374, 0.375544, 0.365965, 0.35663, 0.347533, 0.338668, 0.33003,
         0.321611, 0.313408, 0.305413, 0.297623, 0.290032, 0.280969, 0.271097, 0.261571, 0.25238, 0.243512, 0.234956,
         0.2267, 0.218734, 0.211049, 0.203644, 0.196614, 0.189827, 0.183275, 0.176948, 0.17084, 0.164943, 0.159249,
         0.156919, 4.19145, 4.14308, 4.05657, 3.97187, 3.88894, 3.80774, 3.72824, 3.65039, 3.57417, 3.49954, 3.42648,
         3.35493, 3.28488, 3.21629, 3.14914, 3.08339, 3.01901, 2.95597, 2.89425, 2.83382, 2.77465, 2.71065, 2.64396,
         2.5789, 2.51545, 2.45355, 2.39319, 2.3343, 2.27687, 2.22084, 2.1662, 2.1129, 2.06091, 2.01021, 1.96074, 1.9125,
         1.86544, 1.81954, 1.77478, 1.73111, 1.68755, 1.64348, 1.5998, 1.55727, 1.51588, 1.47559, 1.43672, 1.39924,
         1.36305, 1.32778, 1.29344, 1.26, 1.22669, 1.1941, 1.16223, 1.13121, 1.10104, 1.07169, 1.0434, 1.01539,
         0.987635, 0.960644, 0.934382, 0.908828, 0.883967, 0.859792, 0.836289, 0.813426, 0.791189, 0.769561, 0.74822,
         0.727154, 0.706299, 0.686031, 0.666348, 0.647237, 0.62864, 0.610591, 0.593089, 0.576061, 0.559505, 0.543407,
         0.527586, 0.512213, 0.49731, 0.482831, 0.468772, 0.45512, 0.441867, 0.429, 0.416509, 0.404201, 0.392198,
         0.380508, 0.369169, 0.358167, 0.347492, 0.337134, 0.327086, 0.31734, 0.307997, 0.298733, 0.289725, 0.280975,
         0.272469, 0.26421, 0.256185, 0.248394, 0.240822, 0.233471, 0.226326, 0.21939, 0.212656, 0.20612, 0.199772,
         0.193608, 0.18763, 0.181816, 0.176182, 0.170711, 0.165399, 0.16025, 0.155248, 0.150389, 0.14568, 0.14111,
         0.136673, 0.13237, 0.128195, 0.124153, 0.120219, 0.116411, 0.112717, 0.109134, 0.105658, 0.102286, 0.0990161,
         0.0958453, 0.092771, 0.089789, 0.0868981, 0.0840951, 0.0813777, 0.0787312, 0.0761794, 0.0737062, 0.071312,
         0.0689915, 0.066744, 0.0645673, 0.0624588, 0.0604167, 0.058439, 0.056523, 0.0546688, 0.0528719, 0.0511327,
         0.0494484, 0.0478178, 0.0462392, 0.0447096, 0.0432299, 0.0417965, 0.0404085, 0.0390665, 0.0377663, 0.0365079,
         0.035289, 0.0341103, 0.0329685, 0.031864, 0.0307956, 0.0297618, 0.0287609, 0.0277916, 0.0268536, 0.0259475,
         0.02507, 0.0242218, 0.0234003, 0.0226054, 0.0218367, 0.0210932, 0.0203739, 0.0196782, 0.0190053, 0.0183546,
         0.0177251, 0.0171163, 0.0165279, 0.0159585, 0.0154081, 0.014876, 0.0143614, 0.013864, 0.0133831, 0.0129181,
         0.0124689, 0.0120344, 0.0116146, 0.0112088, 0.0108166, 0.0104376, 0.0100714, 0.00971753, 0.0093756, 0.00904524,
         0.00872607, 0.00841776, 0.00811993, 0.00783223, 0.00755438, 0.00728601, 0.00702685, 0.00677659, 0.00653494,
         0.00630162, 0.00607636, 0.0058589, 0.00564898, 0.00544636, 0.0052508, 0.00506207, 0.00487994, 0.00470421,
         0.00453465, 0.00437107, 0.00421328, 0.00406106, 0.00391426, 0.00377268, 0.00363616, 0.00350453, 0.00337762,
         0.00325528, 0.00313736, 0.0030237, 0.00291418, 0.00280864, 0.00270697, 0.00260902, 0.00251467, 0.0024238,
         0.00233706, 0.00225277, 0.00217158, 0.00209337, 0.00201803, 0.00194545, 0.00187552, 0.00180815, 0.00174324,
         0.00168069, 0.00162043, 0.00156235, 0.00150639, 0.00145246, 0.00140048, 0.00135039, 0.00130212, 0.00125559,
         0.00121074, 0.00116751, 0.00112584, 0.00108567, 0.00104695, 0.00100962, 0.000973629, 0.000938934]],
    'O':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543, 0.5432, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 1.29108, 1.3753, 1.45987, 1.545, 1.63089, 1.71782, 1.80604, 1.89591, 1.98784, 2.0824, 2.18037, 2.28303,
         2.3936, 2.51838, 2.6594, 2.77356, 2.87789, 2.9762, 3.0702, 3.16085, 3.24882, 3.33461, 3.4186, 3.50113, 3.58251,
         3.66302, 3.74299, 3.82277, 3.90281, 3.98375, 4.06668, 4.15435, 4.25303, 4.34278, 4.42066, 4.4926, 4.56033,
         4.6246, 4.68591, 4.74464, 4.80103, 4.85533, 4.90769, 4.95827, 5.0072, 5.05457, 5.10049, 5.14504, 5.18829,
         5.23031, 5.27115, 5.31086, 5.34947, 5.38698, 5.42322, 5.45837, 5.49332, 5.52779, 5.5617, 5.59505, 5.62788,
         5.6602, 5.69205, 5.72347, 5.7545, 5.78519, 5.81559, 5.84576, 5.87577, 5.90572, 5.9357, 5.96588, 5.99646,
         6.02776, 6.06038, 6.09575, 6.13917, 6.17528, 6.2052, 6.23136, 6.25498, 6.27656, 6.2964, 6.31474, 6.33175,
         6.34755, 6.36224, 6.37593, 6.38867, 6.40053, 6.41155, 6.42176, 6.43119, 6.43983, 6.44761, 6.45377, 6.45983,
         6.4664, 6.47299, 6.47949, 6.48585, 6.49207, 6.49816, 6.50413, 6.51001, 6.51583, 6.52164, 6.52749, 6.53347,
         6.53968, 6.54628, 6.55353, 6.56188, 6.57285, 6.59062, 6.60126, 6.60656, 6.6089, 6.60909, 6.60756, 6.60459,
         6.60037, 6.59504, 6.58869, 6.58141, 6.57324, 6.56421, 6.55434, 6.54358, 6.53186, 6.5191, 6.50289, 6.4878,
         6.47469, 6.46187, 6.44917, 6.43647, 6.4237, 6.41077, 6.39774, 6.38453, 6.37093, 6.35684, 6.34223, 6.3271,
         6.31143, 6.29521, 6.27839, 6.26093, 6.24279, 6.22392, 6.20424, 6.18372, 6.16227, 6.13982, 6.11627, 6.09153,
         6.0655, 6.03805, 6.00904, 5.97834, 5.94581, 5.91108, 5.87378, 5.83371, 5.79051, 5.74378, 5.69301, 5.6376,
         5.57677, 5.50955, 5.43473, 5.35075, 5.25548, 5.14604, 5.01831, 4.86623, 4.68029, 4.44433, 4.12757, 3.65977,
         2.81057, -2.97417, -2.9682, -1.76427, 3.14873, 4.13655, 4.73493, 5.16768, 5.50836, 5.78966, 6.02905, 6.23761,
         6.4227, 6.59031, 6.74023, 6.87017, 6.98234, 7.079, 7.17176, 7.26537, 7.35632, 7.43725, 7.51096, 7.57923,
         7.64278, 7.70301, 7.75952, 7.81002, 7.8556, 7.89685, 7.934, 7.96689, 7.99727, 8.02738, 8.05676, 8.08546,
         8.11385, 8.14164, 8.16639, 8.18822, 8.20773, 8.22524, 8.2411, 8.25591, 8.27017, 8.28286, 8.29421, 8.30443,
         8.31363, 8.32191, 8.32937, 8.33606, 8.34205, 8.34741, 8.35226, 8.3567, 8.36065, 8.36377, 8.3662, 8.36809,
         8.36949, 8.37047, 8.37109, 8.37136, 8.37135, 8.37123, 8.37088, 8.37025, 8.36901, 8.36742, 8.36555, 8.3634,
         8.36104, 8.35851, 8.35582, 8.35305, 8.35021, 8.3471, 8.34378, 8.34028, 8.33665, 8.33291, 8.32907, 8.32516,
         8.32116, 8.31719, 8.31332, 8.30931, 8.30523, 8.30109, 8.29692, 8.29272, 8.28851, 8.28427, 8.28002, 8.27576,
         8.27151, 8.26726, 8.26301, 8.25878, 8.25456, 8.25035, 8.24617, 8.242, 8.23786, 8.23375, 8.22967, 8.22562,
         8.22161, 8.21762, 8.21367, 8.20976, 8.20589, 8.20205, 8.19826, 8.1945, 8.19079, 8.18711, 8.18349, 8.17991,
         8.17636, 8.17287, 8.16942, 8.16599, 8.16262, 8.15929, 8.15601, 8.15276, 8.14954, 8.14635, 8.14321, 8.14011,
         8.13705, 8.13404, 8.13108, 8.12816, 8.12529, 8.12246, 8.11969, 8.11695, 8.11427, 8.11163, 8.10904, 8.10649,
         8.104, 8.10154, 8.09913, 8.09677, 8.09445, 8.09218, 8.08995, 8.08776, 8.08562, 8.08351, 8.08146, 8.07944,
         8.07746, 8.07552, 8.07362, 8.07176, 8.06994, 8.06816, 8.06642, 8.06471, 8.06304, 8.0614, 8.0598, 8.05824,
         8.0567, 8.05521, 8.05374, 8.05231, 8.05091, 8.04954, 8.0482, 8.04689, 8.04561, 8.04436, 8.04313, 8.04194,
         8.04077, 8.03963, 8.03852, 8.03743, 8.03637, 8.03533, 8.03432, 8.03333, 8.03236, 8.03142, 8.03049, 8.0296,
         8.02872, 8.02786, 8.02703, 8.02621, 8.02541, 8.02464, 8.02388, 8.02314, 8.02242, 8.02172, 8.02103, 8.02036,
         8.01971, 8.01907, 8.01845, 8.01785, 8.01726, 8.01668, 8.01612, 8.01557, 8.01504, 8.01452, 8.01402, 8.01352,
         8.01304, 8.01257, 8.01212, 8.01167, 8.01124, 8.01082, 8.01041, 8.01001, 8.00962, 8.00924, 8.00887, 8.00851,
         8.00816, 8.00782, 8.00749, 8.00717, 8.00686, 8.00655, 8.00626, 8.00597, 8.00569, 8.00541, 8.00515, 8.00489,
         8.00464, 8.00439, 8.00416, 8.00393, 8.0037, 8.00348, 8.00327, 8.00307, 8.00286, 8.00267, 8.00248, 8.0023,
         8.00212, 8.00194],
        [0.70328, 0.707226, 0.707377, 0.707528, 0.707678, 0.70783, 0.70798, 0.708131, 0.708282, 0.708433, 0.708584,
         0.710169, 0.712421, 0.71468, 0.716947, 0.719221, 0.721502, 0.72379, 0.726085, 0.73364, 0.746066, 0.758702,
         0.771553, 0.784622, 0.801406, 0.832915, 0.865663, 0.899699, 0.973496, 1.07691, 1.19131, 1.31787, 1.45787,
         1.61274, 1.78407, 1.97359, 2.19084, 2.44589, 2.73065, 3.04856, 3.31541, 3.47952, 3.65175, 3.77879, 3.8365,
         3.89509, 3.95457, 4.01497, 4.07078, 4.11386, 4.15739, 4.20138, 4.24585, 4.29077, 4.33618, 4.37108, 4.39198,
         4.41297, 4.43407, 4.45527, 4.47657, 4.49797, 4.51948, 4.54108, 4.5628, 4.58461, 4.60653, 4.62855, 4.65068,
         4.67292, 4.69526, 4.7177, 4.74026, 4.76292, 4.78569, 4.80857, 4.83156, 4.85466, 4.87787, 4.90119, 4.92462,
         4.90853, 4.88177, 4.85515, 4.82868, 4.80235, 4.77617, 4.75012, 4.72423, 4.69846, 4.67285, 4.64737, 4.62203,
         4.59683, 4.57176, 4.54683, 4.52204, 4.49738, 4.47286, 4.43924, 4.3853, 4.33201, 4.27937, 4.22737, 4.17601,
         4.12526, 4.07514, 4.02562, 3.9767, 3.92838, 3.88065, 3.83349, 3.78691, 3.7409, 3.69544, 3.65054, 3.60618,
         3.56236, 3.51907, 3.47631, 3.43407, 3.39234, 3.35206, 3.31248, 3.27336, 3.2347, 3.19651, 3.15877, 3.12146,
         3.0846, 3.04818, 3.01218, 2.97661, 2.94146, 2.90673, 2.8724, 2.83848, 2.80496, 2.77184, 2.73911, 2.70676,
         2.6748, 2.64321, 2.60698, 2.55821, 2.51035, 2.46339, 2.4173, 2.37208, 2.3277, 2.28416, 2.24143, 2.19949,
         2.15834, 2.11797, 2.07834, 2.03946, 2.00131, 1.96387, 1.92713, 1.89108, 1.8557, 1.82102, 1.78919, 1.75791,
         1.72717, 1.69698, 1.66731, 1.63816, 1.60952, 1.58138, 1.55374, 1.52657, 1.49989, 1.47366, 1.4479, 1.42259,
         1.39772, 1.37328, 1.34927, 1.32568, 1.29775, 1.25985, 1.22306, 1.18734, 1.15266, 1.119, 1.08632, 1.05459,
         1.02379, 0.993894, 0.964869, 0.93669, 0.909335, 0.882777, 0.856997, 0.831968, 0.807672, 0.785141, 0.76705,
         0.749377, 0.732111, 0.715246, 0.698766, 0.682666, 0.666936, 0.651568, 0.63639, 0.62136, 0.606567, 0.592106,
         0.577987, 0.564206, 0.550756, 0.537625, 0.524809, 0.512296, 0.500078, 0.488156, 0.476518, 0.46516, 0.454068,
         0.44324, 0.432677, 0.422359, 0.412287, 0.402455, 0.392859, 0.383399, 0.373965, 0.364734, 0.355718, 0.346911,
         0.338332, 0.329966, 0.321805, 0.313842, 0.306078, 0.298525, 0.291171, 0.284004, 0.277005, 0.270184, 0.263535,
         0.257056, 0.250722, 0.244542, 0.238528, 0.232662, 0.227165, 4.41017, 4.40843, 4.30605, 4.20603, 4.10874,
         4.01631, 3.92668, 3.83948, 3.75417, 3.67071, 3.58878, 3.50519, 3.41851, 3.33072, 3.24518, 3.17061, 3.1044,
         3.04097, 2.97253, 2.90138, 2.8321, 2.76441, 2.69824, 2.63299, 2.56707, 2.50097, 2.43656, 2.37381, 2.31267,
         2.2549, 2.20048, 2.14904, 2.0988, 2.04974, 2.00183, 1.95125, 1.90102, 1.85129, 1.80284, 1.75575, 1.71001,
         1.66625, 1.62304, 1.58035, 1.53877, 1.49828, 1.45885, 1.42048, 1.38311, 1.34671, 1.31127, 1.27676, 1.24316,
         1.21022, 1.17789, 1.14609, 1.11516, 1.08507, 1.05579, 1.02732, 0.999604, 0.972611, 0.94638, 0.920766, 0.895701,
         0.870806, 0.846549, 0.822997, 0.800062, 0.777767, 0.756111, 0.735037, 0.714548, 0.694627, 0.67503, 0.655908,
         0.63727, 0.619158, 0.60156, 0.584462, 0.567849, 0.551708, 0.536027, 0.52098, 0.506059, 0.491524, 0.477384,
         0.463634, 0.450251, 0.437232, 0.424568, 0.412245, 0.400261, 0.388605, 0.377269, 0.366239, 0.355523, 0.345085,
         0.334943, 0.325079, 0.315489, 0.306159, 0.297084, 0.288266, 0.279693, 0.271352, 0.263238, 0.255349, 0.247687,
         0.240232, 0.232981, 0.225931, 0.219077, 0.212417, 0.205937, 0.199644, 0.193525, 0.187574, 0.181787, 0.17616,
         0.170681, 0.165363, 0.160196, 0.155167, 0.150282, 0.145531, 0.140899, 0.136421, 0.132079, 0.127871, 0.123789,
         0.119833, 0.115998, 0.11228, 0.108678, 0.105185, 0.1018, 0.0985193, 0.0953398, 0.0922592, 0.0892732, 0.0863801,
         0.0835779, 0.080862, 0.0782309, 0.0756813, 0.0732117, 0.0708205, 0.068504, 0.0662596, 0.0640857, 0.0619792,
         0.0599416, 0.0579659, 0.0560545, 0.0542032, 0.0524097, 0.0506725, 0.0489916, 0.047365, 0.0457894, 0.0442644,
         0.0427875, 0.0413582, 0.0399759, 0.0386359, 0.0373402, 0.0360851, 0.034871, 0.033698, 0.0325612, 0.0314612,
         0.0303967, 0.029367, 0.0283707, 0.027407, 0.0264746, 0.0255728, 0.0247005, 0.0238566, 0.0230406, 0.0222513,
         0.0214883, 0.0207501, 0.0200363, 0.0193461, 0.0186788, 0.0180336, 0.0174099, 0.0168069, 0.016224, 0.0156607,
         0.0151161, 0.0145898, 0.0140812, 0.0135897, 0.0131147, 0.0126558, 0.0122124, 0.0117841, 0.0113702, 0.0109705,
         0.0105844, 0.0102115, 0.00985132, 0.00950352, 0.00916766, 0.00884339, 0.0085303, 0.00822805, 0.00793628,
         0.00765465, 0.00738283, 0.00712049, 0.00686735, 0.00662308, 0.00638742, 0.00616006, 0.00594073, 0.00572919,
         0.00552516, 0.00532841, 0.00513869, 0.00495577, 0.00477943, 0.00460945, 0.00444652, 0.00428858, 0.00413632,
         0.00398954, 0.00384804, 0.00371162, 0.00358009, 0.00345328, 0.003331, 0.0032131, 0.00309941, 0.00298978,
         0.00288407, 0.00278212, 0.0026838, 0.00258899, 0.00249755, 0.00240935, 0.00232429, 0.00224225, 0.00216311,
         0.00208678, 0.00201316, 0.00194214, 0.00187363, 0.00180754]],
    'F':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.6966, 0.6968, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 0.226996, 0.384977, 0.517012, 0.63293, 0.741702, 0.843041, 0.935161, 1.01869, 1.09087, 1.16564, 1.2409,
         1.31432, 1.38409, 1.44517, 1.51571, 1.59158, 1.67171, 1.75846, 1.85565, 1.94343, 2.02685, 2.10858, 2.18907,
         2.26852, 2.34674, 2.42403, 2.50254, 2.58173, 2.66148, 2.74181, 2.8228, 2.9045, 2.98703, 3.07048, 3.15497,
         3.24062, 3.32756, 3.41588, 3.50572, 3.59394, 3.66975, 3.80894, 3.93129, 4.04771, 4.16932, 4.28507, 4.40251,
         4.51175, 4.61445, 4.71396, 4.81148, 4.9078, 5.0039, 5.1021, 5.20433, 5.30366, 5.40026, 5.49039, 5.57643,
         5.66011, 5.74238, 5.8249, 5.9064, 5.98696, 6.06832, 6.14317, 6.21375, 6.28211, 6.34916, 6.41631, 6.48102,
         6.54638, 6.60671, 6.66374, 6.71854, 6.77197, 6.82552, 6.88114, 6.92943, 6.97366, 7.01511, 7.05418, 7.09118,
         7.12636, 7.15983, 7.19182, 7.22246, 7.25186, 7.28017, 7.30755, 7.33412, 7.36015, 7.3861, 7.4138, 7.43894,
         7.46113, 7.48123, 7.49981, 7.5171, 7.53325, 7.54838, 7.5626, 7.57606, 7.58883, 7.60109, 7.61317, 7.62467,
         7.63562, 7.645, 7.65329, 7.66076, 7.6675, 7.67358, 7.67908, 7.68406, 7.6887, 7.69322, 7.69756, 7.70097,
         7.70356, 7.70552, 7.70701, 7.70817, 7.70909, 7.70941, 7.70899, 7.70797, 7.70649, 7.70463, 7.70242, 7.7,
         7.69747, 7.69442, 7.69085, 7.68679, 7.68229, 7.67744, 7.67232, 7.66701, 7.66142, 7.65544, 7.64914, 7.64258,
         7.63584, 7.62913, 7.62289, 7.61565, 7.60745, 7.59852, 7.58904, 7.57904, 7.56858, 7.55766, 7.54631, 7.53454,
         7.52236, 7.50977, 7.4968, 7.48346, 7.46981, 7.45597, 7.4425, 7.42885, 7.41329, 7.39596, 7.37744, 7.35778,
         7.33701, 7.3151, 7.29202, 7.26769, 7.24189, 7.2149, 7.18665, 7.15697, 7.12566, 7.09257, 7.05748, 7.02018,
         6.98039, 6.93783, 6.89211, 6.84283, 6.78953, 6.73141, 6.66747, 6.59672, 6.51789, 6.42927, 6.32851, 6.21291,
         6.0769, 5.91248, 5.70824, 5.44338, 5.07493, 4.49043, 3.15666, -1.94772, -1.94318, 3.32349, 4.82037, 5.54534,
         6.03412, 6.40462, 6.70309, 6.95272, 7.16683, 7.35385, 7.51947, 7.66774, 7.80166, 7.92355, 8.03528, 8.13844,
         8.23477, 8.32638, 8.40972, 8.48485, 8.55409, 8.61813, 8.67783, 8.73399, 8.78586, 8.83342, 8.87741, 8.91817,
         8.95607, 8.99143, 9.02433, 9.05493, 9.08348, 9.11025, 9.13541, 9.15924, 9.18115, 9.20115, 9.21971, 9.23745,
         9.25383, 9.26857, 9.28196, 9.29416, 9.30537, 9.31553, 9.32471, 9.33307, 9.34101, 9.34812, 9.35415, 9.35919,
         9.36343, 9.36691, 9.36981, 9.3722, 9.37408, 9.37567, 9.37681, 9.37738, 9.37745, 9.37707, 9.37632, 9.37523,
         9.37382, 9.37213, 9.37009, 9.36817, 9.36612, 9.36371, 9.36107, 9.35823, 9.35523, 9.35205, 9.34874, 9.3453,
         9.34174, 9.33807, 9.3343, 9.33045, 9.32652, 9.32252, 9.31846, 9.31435, 9.31019, 9.30599, 9.30177, 9.29751,
         9.29324, 9.28894, 9.28464, 9.28033, 9.27602, 9.27171, 9.26741, 9.26311, 9.25882, 9.25455, 9.2503, 9.24606,
         9.24185, 9.23767, 9.23351, 9.22937, 9.22526, 9.22119, 9.21715, 9.21313, 9.20915, 9.20519, 9.20127, 9.19738,
         9.19352, 9.18969, 9.1859, 9.18217, 9.17846, 9.17481, 9.1712, 9.16764, 9.16412, 9.16065, 9.15723, 9.15386,
         9.15054, 9.14726, 9.14404, 9.14087, 9.13774, 9.13467, 9.13165, 9.12867, 9.12575, 9.12287, 9.12005, 9.11727,
         9.11454, 9.11187, 9.10923, 9.10665, 9.10411, 9.10162, 9.09918, 9.09679, 9.09444, 9.09213, 9.08987, 9.08765,
         9.08548, 9.08335, 9.08126, 9.07922, 9.07722, 9.07525, 9.07333, 9.07145, 9.06961, 9.0678, 9.06603, 9.0643,
         9.06261, 9.06096, 9.05933, 9.05775, 9.0562, 9.05468, 9.05319, 9.05174, 9.05032, 9.04894, 9.04758, 9.04625,
         9.04496, 9.04369, 9.04245, 9.04124, 9.04006, 9.0389, 9.03777, 9.03667, 9.0356, 9.03454, 9.03352, 9.03251,
         9.03153, 9.03058, 9.02965, 9.02873, 9.02785, 9.02698, 9.02613, 9.0253, 9.0245, 9.02371, 9.02294, 9.02219,
         9.02146, 9.02075, 9.02005, 9.01937, 9.01871, 9.01807, 9.01744, 9.01683, 9.01623, 9.01565, 9.01508, 9.01453,
         9.01399, 9.01346, 9.01295, 9.01245, 9.01196, 9.01149, 9.01103, 9.01058, 9.01014, 9.00972, 9.0093, 9.0089,
         9.00851, 9.00812, 9.00775, 9.00739, 9.00704, 9.00669, 9.00636, 9.00604, 9.00572, 9.00541, 9.00511, 9.00482,
         9.00454, 9.00427, 9.00401, 9.00371],
        [0.0516473, 0.0564796, 0.0617639, 0.0675427, 0.0738623, 0.0807729, 0.0883303, 0.0965947, 0.108313, 0.124621,
         0.147675, 0.182934, 0.286819, 0.427324, 0.526258, 0.597229, 0.676277, 0.758009, 0.849618, 0.92183, 0.987157,
         1.05711, 1.13203, 1.21042, 1.29408, 1.38352, 1.47159, 1.55088, 1.63444, 1.7225, 1.80568, 1.89012, 1.97852,
         2.07103, 2.15963, 2.25202, 2.34836, 2.44883, 2.549, 2.64222, 2.73886, 2.83903, 2.94287, 3.00878, 3.07304,
         3.13868, 3.20572, 3.27419, 3.34589, 3.42018, 3.49611, 3.57373, 3.65342, 3.73752, 3.82355, 3.91157, 4.00163,
         4.09386, 4.18821, 4.28474, 4.37975, 4.45994, 4.5416, 4.62477, 4.70945, 4.78193, 4.8473, 4.91356, 4.95547,
         4.96088, 4.9663, 4.97169, 4.96961, 4.96752, 4.96544, 4.96877, 4.98028, 4.99181, 5.00336, 5.01495, 5.03487,
         5.06402, 5.09333, 5.12282, 5.15247, 5.17148, 5.18208, 5.1927, 5.20335, 5.21402, 5.22471, 5.23542, 5.24813,
         5.26164, 5.27519, 5.28879, 5.30241, 5.31607, 5.32976, 5.34349, 5.35725, 5.37106, 5.38489, 5.39876, 5.41267,
         5.42661, 5.44059, 5.47877, 5.50844, 5.50408, 5.49978, 5.49039, 5.47242, 5.45038, 5.4187, 5.38722, 5.35596,
         5.32485, 5.29387, 5.26314, 5.23266, 5.19583, 5.15523, 5.10646, 5.0565, 5.007, 4.9579, 4.90928, 4.86112,
         4.80893, 4.75718, 4.7, 4.63995, 4.58088, 4.52256, 4.46501, 4.40662, 4.34714, 4.28615, 4.22208, 4.15894, 4.0967,
         4.03538, 3.97497, 3.91047, 3.8421, 3.77553, 3.71011, 3.64583, 3.58268, 3.5206, 3.45959, 3.39966, 3.34076,
         3.28287, 3.22601, 3.17011, 3.11517, 3.06119, 3.00816, 2.95521, 2.89798, 2.84188, 2.78686, 2.7329, 2.67999,
         2.6281, 2.57722, 2.52734, 2.47844, 2.43047, 2.3834, 2.33722, 2.29077, 2.24467, 2.19877, 2.15387, 2.10987,
         2.06676, 2.0245, 1.98311, 1.94258, 1.90291, 1.86384, 1.82515, 1.78639, 1.74843, 1.71126, 1.67487, 1.63917,
         1.60412, 1.56903, 1.53468, 1.50109, 1.46825, 1.43613, 1.40471, 1.37397, 1.34363, 1.31361, 1.28406, 1.25513,
         1.22683, 1.19923, 1.17223, 1.14583, 1.11977, 1.09423, 1.06924, 1.04483, 1.02097, 0.997652, 0.974426, 0.95023,
         0.926635, 0.903624, 0.881185, 0.859304, 0.837966, 0.817158, 0.796866, 0.77708, 0.757783, 0.738966, 0.720616,
         0.702721, 0.685272, 0.668255, 0.651661, 0.633203, 0.614319, 0.595997, 0.578222, 0.560977, 0.544246, 0.528014,
         0.512267, 0.496989, 0.482202, 0.468296, 0.454791, 0.441676, 0.428938, 0.416567, 0.404554, 0.392888, 0.381557,
         0.370553, 0.359867, 0.349489, 0.33941, 0.329269, 0.31934, 0.30971, 0.300371, 0.291313, 0.282529, 0.274009,
         0.264419, 0.254836, 0.245599, 0.236698, 0.228119, 0.219851, 0.211882, 0.208117, 4.25895, 4.21271, 4.12109,
         4.03145, 3.94377, 3.858, 3.77409, 3.69201, 3.6117, 3.53315, 3.45631, 3.38114, 3.3076, 3.23567, 3.16529,
         3.09645, 3.0291, 2.96067, 2.8903, 2.82159, 2.75453, 2.68905, 2.62525, 2.56216, 2.49961, 2.43829, 2.37845,
         2.32006, 2.26315, 2.20754, 2.15315, 2.10007, 2.04828, 1.99776, 1.94833, 1.89964, 1.8515, 1.80462, 1.75892,
         1.71436, 1.66995, 1.62652, 1.58407, 1.54272, 1.50232, 1.46279, 1.42423, 1.38668, 1.35014, 1.31361, 1.27789,
         1.24306, 1.20914, 1.17615, 1.14412, 1.11293, 1.08257, 1.05302, 1.02396, 0.995586, 0.967927, 0.941048, 0.914906,
         0.889466, 0.86474, 0.840703, 0.817335, 0.794916, 0.772632, 0.750928, 0.729789, 0.709212, 0.689181, 0.669677,
         0.650699, 0.632218, 0.614237, 0.596729, 0.579696, 0.56312, 0.546979, 0.53128, 0.516004, 0.501142, 0.486672,
         0.4726, 0.458907, 0.445585, 0.432617, 0.420009, 0.407744, 0.395808, 0.38419, 0.372905, 0.361916, 0.35122,
         0.340826, 0.330716, 0.320869, 0.311308, 0.302003, 0.292948, 0.284136, 0.275569, 0.267242, 0.259143, 0.25125,
         0.243587, 0.236125, 0.228872, 0.221828, 0.21498, 0.208329, 0.201871, 0.19562, 0.189531, 0.18363, 0.177901,
         0.172344, 0.16695, 0.161717, 0.156639, 0.151715, 0.146934, 0.1423, 0.137803, 0.133443, 0.129212, 0.12511,
         0.121133, 0.117276, 0.113536, 0.109908, 0.106394, 0.102985, 0.0996809, 0.0964772, 0.0933711, 0.0903615,
         0.0874446, 0.0846192, 0.0818799, 0.079225, 0.0766529, 0.0741586, 0.0717451, 0.0694045, 0.0671388, 0.0649421,
         0.0628154, 0.060755, 0.0587594, 0.0568259, 0.0549528, 0.0531394, 0.0513851, 0.0496838, 0.048037, 0.046443,
         0.0448991, 0.0434069, 0.0419581, 0.0405582, 0.0392026, 0.0378903, 0.0366203, 0.0353915, 0.0342018, 0.0330505,
         0.0319365, 0.0308584, 0.0298153, 0.028806, 0.0278296, 0.0268849, 0.0259711, 0.0250872, 0.0242321, 0.0234051,
         0.0226052, 0.0218317, 0.0210836, 0.0203602, 0.0196608, 0.0189845, 0.0183307, 0.0176985, 0.0170875, 0.0164968,
         0.0159259, 0.0153741, 0.0148408, 0.0143254, 0.0138274, 0.0133462, 0.0128813, 0.0124321, 0.0119982, 0.0115791,
         0.0111742, 0.0107832, 0.0104056, 0.0100409, 0.00968875, 0.00934876, 0.00902052, 0.00870365, 0.00839779,
         0.00810257, 0.00781765, 0.00754257, 0.00727735, 0.00702156, 0.00677484, 0.00653687, 0.00630733, 0.00608592,
         0.00587235, 0.00566631, 0.00546756, 0.00527582, 0.00509084, 0.00491238, 0.00474021, 0.0045741, 0.00441383,
         0.00425919, 0.00410999, 0.00396602, 0.0038271, 0.00369306, 0.00356371, 0.00343889, 0.00331845, 0.00320221,
         0.00309004]],
    'Ne':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0215, 0.0217, 0.0219503,
         0.0223053, 0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002,
         0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337,
         0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609,
         0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794,
         0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.8701, 0.8703, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, -0.722786, -0.638325, -0.572576, -0.547169, -0.527238, -0.488279, -0.439885, -0.385659, -0.32116,
         -0.252235, -0.186891, -0.122622, -0.0582012, 0.00674596, 0.0716378, 0.139639, 0.212833, 0.291005, 0.377165,
         0.479881, 0.583162, 0.675584, 0.785214, 0.886627, 0.950661, 0.995369, 1.0426, 1.0986, 1.15509, 1.21056, 1.2677,
         1.3269, 1.38098, 1.43043, 1.49011, 1.56422, 1.6565, 1.75929, 1.85924, 1.9596, 2.06458, 2.18172, 2.30444,
         2.41966, 2.53134, 2.65269, 2.7661, 2.84275, 2.9141, 3.00481, 3.10324, 3.2081, 3.3197, 3.43868, 3.58, 3.73593,
         3.87602, 3.99693, 4.10545, 4.2123, 4.32332, 4.43449, 4.54643, 4.6593, 4.77363, 4.89047, 5.0115, 5.14335,
         5.27923, 5.40393, 5.52126, 5.63579, 5.74841, 5.86002, 5.96754, 6.07102, 6.21026, 6.36239, 6.49005, 6.62335,
         6.74851, 6.85669, 6.95637, 7.0499, 7.1387, 7.22406, 7.30822, 7.388, 7.46106, 7.53053, 7.59679, 7.66034,
         7.72164, 7.78103, 7.84246, 7.90168, 7.95319, 8.00152, 8.04685, 8.08951, 8.12971, 8.16754, 8.20301, 8.23612,
         8.2633, 8.28781, 8.31714, 8.35015, 8.38588, 8.42488, 8.46918, 8.52709, 8.60566, 8.63273, 8.60965, 8.61713,
         8.62845, 8.64103, 8.65396, 8.66744, 8.68132, 8.69565, 8.71077, 8.72822, 8.74635, 8.76064, 8.77223, 8.78174,
         8.78979, 8.79661, 8.80235, 8.80715, 8.81111, 8.81436, 8.81697, 8.81896, 8.82046, 8.82164, 8.82249, 8.82346,
         8.82493, 8.82552, 8.82447, 8.82217, 8.81886, 8.81476, 8.81001, 8.80468, 8.7988, 8.79238, 8.78549, 8.77817,
         8.77043, 8.76232, 8.75385, 8.74505, 8.73594, 8.72656, 8.71694, 8.70715, 8.69761, 8.68824, 8.67788, 8.66621,
         8.6539, 8.641, 8.62755, 8.61357, 8.59908, 8.5841, 8.56866, 8.5527, 8.53615, 8.51899, 8.50122, 8.48282, 8.46377,
         8.44404, 8.42359, 8.40239, 8.38037, 8.3575, 8.33378, 8.30914, 8.28343, 8.25634, 8.22785, 8.1981, 8.16694,
         8.13419, 8.09971, 8.06333, 8.0249, 7.98369, 7.93886, 7.88993, 7.83651, 7.77932, 7.71813, 7.65152, 7.57766,
         7.49521, 7.40231, 7.29647, 7.17415, 7.03, 6.85573, 6.6382, 6.35358, 5.95155, 5.29351, 3.59708, -1.59786,
         -1.59368, 4.56045, 5.91462, 6.62676, 7.11804, 7.49445, 7.7996, 8.05596, 8.27687, 8.47121, 8.64476, 8.79982,
         8.93632, 9.0589, 9.16978, 9.27054, 9.36245, 9.44655, 9.52375, 9.59478, 9.66028, 9.72084, 9.77699, 9.82924,
         9.87761, 9.92223, 9.96338, 10.0014, 10.0366, 10.0693, 10.0997, 10.1279, 10.1543, 10.179, 10.2023, 10.224,
         10.2432, 10.2607, 10.2767, 10.2912, 10.3045, 10.3167, 10.3278, 10.3383, 10.348, 10.3563, 10.3636, 10.3699,
         10.3753, 10.38, 10.384, 10.3874, 10.3901, 10.3926, 10.395, 10.3964, 10.3973, 10.3978, 10.3979, 10.3976,
         10.3969, 10.3958, 10.3944, 10.3927, 10.3907, 10.3885, 10.386, 10.3833, 10.3804, 10.3774, 10.3741, 10.3707,
         10.3671, 10.3634, 10.3596, 10.3557, 10.3516, 10.3475, 10.3433, 10.339, 10.3347, 10.3303, 10.3259, 10.3214,
         10.3169, 10.3124, 10.3078, 10.3032, 10.2986, 10.294, 10.2894, 10.2848, 10.2802, 10.2756, 10.2711, 10.2665,
         10.262, 10.2574, 10.2529, 10.2483, 10.2439, 10.2394, 10.235, 10.2306, 10.2263, 10.222, 10.2177, 10.2135,
         10.2093, 10.2052, 10.2011, 10.197, 10.193, 10.1891, 10.1852, 10.1813, 10.1775, 10.1738, 10.1701, 10.1664,
         10.1628, 10.1593, 10.1558, 10.1524, 10.149, 10.1457, 10.1424, 10.1392, 10.136, 10.1329, 10.1298, 10.1268,
         10.1239, 10.121, 10.1181, 10.1153, 10.1126, 10.1099, 10.1072, 10.1046, 10.1021, 10.0996, 10.0971, 10.0947,
         10.0923, 10.09, 10.0878, 10.0855, 10.0834, 10.0812, 10.0791, 10.0771, 10.0751, 10.0731, 10.0712, 10.0693,
         10.0675, 10.0657, 10.0639, 10.0622, 10.0605, 10.0588, 10.0572, 10.0556, 10.0541, 10.0526, 10.0511, 10.0496,
         10.0482, 10.0468, 10.0455, 10.0442, 10.0429, 10.0416, 10.0404, 10.0392, 10.038, 10.0369, 10.0357, 10.0346,
         10.0336, 10.0325, 10.0315, 10.0305, 10.0295, 10.0286, 10.0277, 10.0268, 10.0259, 10.025, 10.0242, 10.0234,
         10.0226, 10.0218, 10.021, 10.0203, 10.0195, 10.0188, 10.0182, 10.0175, 10.0168, 10.0162, 10.0156, 10.015,
         10.0144, 10.0138, 10.0132, 10.0127, 10.0122, 10.0117, 10.0112, 10.0107, 10.0102, 10.0097, 10.0093, 10.0088,
         10.0084, 10.008, 10.0076, 10.0072, 10.0068, 10.0064],
        [4.79576e-16, 4.87333e-16, 4.95215e-16, 5.03225e-16, 5.11364e-16, 5.19635e-16, 5.2804e-16, 5.3658e-16,
         5.45259e-16, 5.54078e-16, 5.6304e-16, 5.72147e-16, 5.81401e-16, 5.90805e-16, 6.00361e-16, 6.10071e-16,
         6.19938e-16, 6.29965e-16, 6.40155e-16, 6.50509e-16, 6.6103e-16, 6.71722e-16, 6.82586e-16, 6.93627e-16,
         7.04846e-16, 7.16246e-16, 7.27831e-16, 7.39603e-16, 7.51565e-16, 7.63721e-16, 7.76074e-16, 7.88626e-16,
         8.01382e-16, 8.14343e-16, 8.27515e-16, 8.40899e-16, 8.545e-16, 8.68321e-16, 8.82365e-16, 8.96637e-16,
         9.11139e-16, 9.25876e-16, 9.40852e-16, 9.56069e-16, 9.71533e-16, 9.87247e-16, 1.00321e-15, 1.01944e-15,
         1.03109e-15, 1.79139, 1.95643, 2.21315, 2.50079, 2.64889, 2.78606, 2.90136, 3.01168, 3.10817, 3.20074, 3.28061,
         3.36247, 3.44638, 3.51648, 3.57443, 3.63332, 3.69319, 3.72541, 3.75454, 3.7839, 3.80667, 3.80777, 3.80887,
         3.86953, 3.93403, 4.00099, 4.06909, 4.13833, 4.19845, 4.25469, 4.3117, 4.36946, 4.428, 4.48853, 4.55288,
         4.61816, 4.68437, 4.75153, 4.81744, 4.85348, 4.8898, 4.92638, 4.9233, 4.91981, 4.92915, 4.96679, 5.00472,
         5.04294, 5.08375, 5.12979, 5.17624, 5.22312, 5.27991, 5.35683, 5.43488, 5.51407, 5.57909, 5.63469, 5.69085,
         5.74756, 5.80484, 5.83933, 5.86771, 5.89623, 5.92489, 5.91786, 5.90994, 5.95107, 5.9925, 6.03421, 6.07621,
         6.11849, 6.16108, 6.20396, 6.22061, 6.20429, 6.18801, 6.17671, 6.17497, 6.17323, 6.17149, 6.16951, 6.16729,
         6.16507, 6.16286, 6.16065, 6.15843, 6.1319, 6.09959, 6.06745, 6.03548, 6.00367, 5.97204, 5.94057, 5.9164,
         5.91586, 5.86022, 5.80511, 5.74533, 5.66045, 5.57681, 5.49442, 5.41324, 5.33326, 5.25446, 5.17522, 5.09217,
         5.01045, 4.93005, 4.85093, 4.77309, 4.69648, 4.62112, 4.54697, 4.46606, 4.3862, 4.30777, 4.23074, 4.15509,
         4.08079, 4.00782, 3.93615, 3.86577, 3.79664, 3.73619, 3.68212, 3.62882, 3.5763, 3.52453, 3.47352, 3.42324,
         3.33971, 3.18737, 3.12893, 3.06989, 3.01163, 2.95426, 2.89868, 2.84434, 2.79115, 2.73904, 2.68788, 2.63765,
         2.58158, 2.5253, 2.46916, 2.4143, 2.36065, 2.30819, 2.25686, 2.20669, 2.15765, 2.10972, 2.06282, 2.01694,
         1.97218, 1.92836, 1.88543, 1.84358, 1.80142, 1.75865, 1.7161, 1.67444, 1.63373, 1.59405, 1.55535, 1.51761,
         1.48071, 1.44471, 1.40962, 1.37537, 1.34195, 1.30936, 1.27755, 1.24651, 1.21623, 1.18669, 1.15786, 1.12973,
         1.10229, 1.07477, 1.04635, 1.01886, 0.992161, 0.966161, 0.940839, 0.916181, 0.892172, 0.868792, 0.846004,
         0.823712, 0.801953, 0.780739, 0.760082, 0.739973, 0.720396, 0.701336, 0.682789, 0.66474, 0.647177, 0.630129,
         0.61355, 0.597392, 0.581446, 0.565869, 0.550989, 0.53659, 0.522623, 0.509022, 0.495782, 0.482858, 0.469866,
         0.456687, 0.443532, 0.430757, 0.419564, 0.409597, 0.400185, 0.390453, 0.380595, 0.370963, 0.361591, 0.35246,
         0.343481, 0.33449, 0.325538, 0.316826, 0.308346, 0.300094, 0.292063, 0.284248, 0.281588, 4.51161, 4.44449,
         4.34146, 4.24078, 4.1424, 4.04632, 3.95247, 3.86078, 3.77122, 3.6831, 3.59637, 3.50583, 3.41781, 3.33231,
         3.24896, 3.16769, 3.08843, 3.01119, 2.93587, 2.86243, 2.79083, 2.72102, 2.65295, 2.58624, 2.52088, 2.45679,
         2.39428, 2.33337, 2.27403, 2.21618, 2.1598, 2.10484, 2.05128, 1.9989, 1.94758, 1.89639, 1.84637, 1.79766,
         1.75022, 1.70405, 1.65912, 1.61535, 1.57273, 1.53124, 1.49017, 1.44996, 1.4106, 1.37235, 1.33513, 1.29892,
         1.26371, 1.22944, 1.19608, 1.1641, 1.13218, 1.10097, 1.07062, 1.0411, 1.01223, 0.984136, 0.95677, 0.930103,
         0.904127, 0.878825, 0.854188, 0.830187, 0.806817, 0.784061, 0.761901, 0.740321, 0.71932, 0.69887, 0.678965,
         0.659589, 0.640726, 0.622378, 0.604504, 0.587115, 0.570193, 0.553728, 0.537703, 0.522116, 0.506956, 0.492196,
         0.477824, 0.463861, 0.450268, 0.437039, 0.42418, 0.41166, 0.399495, 0.387646, 0.376136, 0.364929, 0.354038,
         0.343434, 0.333068, 0.323058, 0.313321, 0.303851, 0.294663, 0.285729, 0.27704, 0.268603, 0.260404, 0.252455,
         0.244712, 0.237208, 0.22992, 0.222838, 0.215963, 0.209289, 0.202809, 0.196519, 0.190412, 0.184485, 0.178735,
         0.173151, 0.167735, 0.162478, 0.157379, 0.152431, 0.147632, 0.142974, 0.138457, 0.134077, 0.129827, 0.125706,
         0.121709, 0.117834, 0.114074, 0.110431, 0.106898, 0.103474, 0.100154, 0.096935, 0.093814, 0.0907908, 0.0878584,
         0.085018, 0.0822656, 0.0795985, 0.0770135, 0.074508, 0.0720825, 0.0697322, 0.0674551, 0.0652458, 0.0631096,
         0.0610392, 0.0590324, 0.0570907, 0.0552107, 0.0533891, 0.0516251, 0.0499169, 0.048263, 0.0466616, 0.0451112,
         0.0436103, 0.0421572, 0.0407507, 0.0393893, 0.0380715, 0.0367961, 0.0355617, 0.0343672, 0.0332113, 0.0320928,
         0.0310105, 0.0299634, 0.0289504, 0.0279703, 0.0270223, 0.0261052, 0.0252182, 0.0243603, 0.0235306, 0.0227282,
         0.0219522, 0.021202, 0.0204765, 0.0197751, 0.019097, 0.0184415, 0.0178078, 0.0171953, 0.0166034, 0.0160312,
         0.0154784, 0.0149441, 0.0144279, 0.0139291, 0.0134472, 0.0129817, 0.012532, 0.0121005, 0.0116811, 0.0112763,
         0.0108855, 0.0105083, 0.0101442, 0.0097927, 0.00945338, 0.00912581, 0.00880958, 0.00850428, 0.00820956,
         0.00792501, 0.00765031, 0.00738508, 0.00712903, 0.00688181, 0.00664311, 0.00641266, 0.00619014, 0.00597531,
         0.00576787, 0.00556759, 0.0053742, 0.00518748, 0.00500718]],
    'Na':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.0304, 0.030600000000000002, 0.030744900000000002, 0.031242100000000002,
         0.0317475, 0.0322609, 0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211,
         0.0360956, 0.0366794, 0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994,
         0.0417031, 0.0423776, 0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004,
         0.04665999999999999, 0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576,
         0.051375300000000006, 0.0522062, 0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482,
         0.058411700000000004, 0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908,
         0.0643145, 0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138,
         0.07195910000000001, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0707,
         1.0709000000000002, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147,
         1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -2.0395, -2.47455, -3.36315, -4.05942, -4.11461, -3.47735, -2.73139, -2.40933, -2.20846, -2.06454,
         -1.95293, -1.86154, -1.78343, -1.71413, -1.65048, -1.58983, -1.52916, -1.46249, -1.39993, -1.34414, -1.29174,
         -1.24091, -1.1908, -1.14068, -1.08995, -1.03796, -0.98405, -0.927363, -0.866628, -0.797934, -0.720079,
         -0.649149, -0.580495, -0.511218, -0.440371, -0.366996, -0.289843, -0.205353, -0.113753, -0.0274963, 0.0570975,
         0.14248, 0.229379, 0.318413, 0.410163, 0.505472, 0.605953, 0.710711, 0.816965, 0.926526, 1.04047, 1.15981,
         1.28571, 1.41983, 1.56454, 1.72804, 1.93808, 2.11892, 2.28017, 2.43538, 2.58724, 2.73746, 2.88729, 3.03778,
         3.18994, 3.34487, 3.50402, 3.66963, 3.84659, 4.05244, 4.24012, 4.4127, 4.57752, 4.73855, 4.8977, 5.05663,
         5.21722, 5.38272, 5.56287, 5.76027, 5.92746, 6.07806, 6.21847, 6.35123, 6.47782, 6.59919, 6.71608, 6.82905,
         6.93857, 7.0451, 7.14905, 7.25111, 7.35243, 7.44995, 7.54438, 7.63664, 7.7271, 7.81608, 7.90397, 7.99117,
         8.07824, 8.16605, 8.25638, 8.35595, 8.45437, 8.5398, 8.61598, 8.68701, 8.75383, 8.81713, 8.87736, 8.9349,
         8.99006, 9.04309, 9.09424, 9.14374, 9.19183, 9.23877, 9.28488, 9.33065, 9.37694, 9.427, 9.47721, 9.51989,
         9.55672, 9.5903, 9.62118, 9.64978, 9.67639, 9.70123, 9.7245, 9.74638, 9.76703, 9.7866, 9.80525, 9.8232,
         9.84068, 9.85812, 9.87783, 9.89789, 9.91284, 9.9246, 9.9342, 9.94206, 9.94845, 9.95356, 9.95754, 9.9605,
         9.96254, 9.96376, 9.96422, 9.96402, 9.96323, 9.96195, 9.96028, 9.95838, 9.95734, 9.95588, 9.95232, 9.94743,
         9.94158, 9.93492, 9.92757, 9.91958, 9.91101, 9.90191, 9.89231, 9.88223, 9.87171, 9.86076, 9.84939, 9.83762,
         9.82544, 9.81287, 9.79988, 9.78647, 9.77233, 9.75786, 9.74347, 9.72898, 9.71428, 9.69932, 9.68408, 9.66853,
         9.65271, 9.63644, 9.61965, 9.60243, 9.58457, 9.56605, 9.54575, 9.52566, 9.50632, 9.48803, 9.47032, 9.45186,
         9.43025, 9.40579, 9.37895, 9.35176, 9.3252, 9.29807, 9.26898, 9.23798, 9.20514, 9.17037, 9.13354, 9.09436,
         9.05237, 9.0073, 8.95881, 8.90639, 8.84948, 8.78742, 8.71942, 8.64432, 8.56067, 8.4667, 8.35944, 8.23504,
         8.088, 7.91008, 7.68757, 7.39535, 6.9797, 6.28827, 4.3543, -0.861678, -0.858176, 5.77584, 7.05429, 7.74835,
         8.23083, 8.60108, 8.90076, 9.15156, 9.36631, 9.55317, 9.7178, 9.86424, 9.9955, 10.1139, 10.2211, 10.3186,
         10.4077, 10.4894, 10.5643, 10.6333, 10.6969, 10.7556, 10.8099, 10.8602, 10.907, 10.9504, 10.9908, 11.0286,
         11.0639, 11.097, 11.1289, 11.1588, 11.1861, 11.2107, 11.2329, 11.2533, 11.2719, 11.289, 11.3047, 11.3189,
         11.3327, 11.3459, 11.3574, 11.3676, 11.3766, 11.3847, 11.3918, 11.3981, 11.4035, 11.408, 11.4119, 11.4151,
         11.4176, 11.4196, 11.4209, 11.4217, 11.4221, 11.422, 11.4214, 11.4204, 11.4191, 11.4173, 11.4153, 11.413,
         11.4103, 11.4074, 11.4043, 11.401, 11.3974, 11.3937, 11.3897, 11.3856, 11.3814, 11.3771, 11.3726, 11.368,
         11.3633, 11.3586, 11.3537, 11.3488, 11.3439, 11.3389, 11.3339, 11.3288, 11.3237, 11.3186, 11.3135, 11.3083,
         11.3032, 11.2981, 11.293, 11.2879, 11.2828, 11.2777, 11.2727, 11.2677, 11.2628, 11.2578, 11.2529, 11.2481,
         11.2433, 11.2386, 11.2338, 11.2292, 11.2246, 11.22, 11.2155, 11.2111, 11.2067, 11.2023, 11.1981, 11.1938,
         11.1897, 11.1856, 11.1815, 11.1776, 11.1736, 11.1698, 11.166, 11.1622, 11.1586, 11.155, 11.1514, 11.1479,
         11.1445, 11.1411, 11.1378, 11.1345, 11.1313, 11.1282, 11.1251, 11.1221, 11.1191, 11.1162, 11.1133, 11.1105,
         11.1078, 11.1051, 11.1024, 11.0999, 11.0973, 11.0948, 11.0924, 11.09, 11.0877, 11.0854, 11.0831, 11.081,
         11.0788, 11.0767, 11.0746, 11.0726, 11.0707, 11.0687, 11.0668, 11.065, 11.0632, 11.0614, 11.0597, 11.058,
         11.0564, 11.0548, 11.0532, 11.0516, 11.0501, 11.0487, 11.0472, 11.0458, 11.0445, 11.0431, 11.0418, 11.0405,
         11.0393, 11.0381, 11.0369, 11.0357, 11.0346, 11.0335, 11.0324, 11.0313, 11.0303, 11.0293, 11.0283, 11.0273,
         11.0264, 11.0255, 11.0246, 11.0237, 11.0229, 11.0221, 11.0213, 11.0205, 11.0197, 11.019, 11.0182, 11.0175,
         11.0168, 11.0162, 11.0155, 11.0149, 11.0142, 11.0136, 11.013, 11.0125, 11.0119, 11.0113, 11.0108, 11.0103,
         11.0098],
        [0.0147534, 0.0151684, 0.015595, 0.0160337, 0.0164847, 0.0169485, 0.0174252, 0.0179154, 0.0184193, 0.0189374,
         0.0194701, 0.0200178, 0.0205809, 0.0211598, 0.021755, 0.022367, 0.0229962, 0.023643, 0.0243081, 0.0249919,
         0.025515, 0.0259862, 0.0264661, 0.0269549, 0.0274527, 0.0279597, 0.0284761, 0.029002, 0.0294125, 0.0297985,
         0.0301895, 0.0305857, 0.030987, 0.0313936, 0.0318055, 0.0322229, 0.0325671, 0.0328178, 0.0330704, 0.033325,
         0.0335815, 0.03384, 0.0341004, 0.0343629, 0.0346274, 0.0348264, 0.0349017, 0.0349772, 0.0350529, 0.0351287,
         0.0352047, 0.0352808, 0.0353571, 0.0354336, 0.0355102, 0.035587, 0.0358675, 0.0361683, 0.0364716, 0.0367775,
         0.037086, 0.0372048, 0.0370648, 0.0369253, 0.0367864, 0.0366479, 0.03651, 0.0363726, 0.0362357, 0.0360994,
         0.036059, 2.39177, 2.41235, 2.48359, 2.55694, 2.63245, 2.71019, 2.79022, 2.87263, 2.95746, 3.0448, 3.13471,
         3.22729, 3.32259, 3.41755, 3.49959, 3.5836, 3.66962, 3.75771, 3.84791, 3.94028, 4.03487, 4.13172, 4.23091,
         4.33247, 4.43647, 4.54297, 4.63804, 4.72878, 4.82129, 4.91562, 5.01178, 5.10983, 5.2098, 5.31172, 5.40276,
         5.49076, 5.5802, 5.6711, 5.76347, 5.85735, 5.95276, 6.04972, 6.14826, 6.24351, 6.33921, 6.43637, 6.53502,
         6.63519, 6.73689, 6.84014, 6.94499, 7.05143, 7.13276, 7.16815, 7.20372, 7.23946, 7.27537, 7.31147, 7.34775,
         7.3842, 7.42084, 7.45766, 7.49465, 7.53184, 7.56921, 7.5916, 7.57278, 7.55402, 7.53529, 7.51662, 7.49799,
         7.47941, 7.46088, 7.44238, 7.42395, 7.36974, 7.29136, 7.21382, 7.1371, 7.0612, 6.9861, 6.91181, 6.8383,
         6.76558, 6.69362, 6.62244, 6.55202, 6.48233, 6.41171, 6.34007, 6.26925, 6.19922, 6.12997, 6.06149, 5.99377,
         5.92682, 5.86061, 5.79514, 5.7304, 5.66639, 5.57644, 5.48463, 5.39434, 5.30552, 5.21817, 5.13226, 5.04777,
         4.96465, 4.88292, 4.80253, 4.72346, 4.64569, 4.5692, 4.49398, 4.41999, 4.34722, 4.27564, 4.20525, 4.12344,
         4.03997, 3.95818, 3.87805, 3.79954, 3.72262, 3.64726, 3.57342, 3.50108, 3.4302, 3.36076, 3.29272, 3.22606,
         3.16075, 3.09676, 3.03407, 2.97265, 2.90618, 2.83824, 2.77188, 2.70708, 2.64379, 2.58198, 2.52162, 2.46267,
         2.40509, 2.34887, 2.29396, 2.24033, 2.18795, 2.1368, 2.08684, 2.03805, 1.99041, 1.94388, 1.89573, 1.84798,
         1.80144, 1.75607, 1.71184, 1.66873, 1.6267, 1.58573, 1.54579, 1.50686, 1.4689, 1.43191, 1.39584, 1.36069,
         1.32642, 1.29301, 1.26045, 1.2287, 1.19775, 1.16759, 1.13889, 1.11108, 1.08395, 1.05744, 1.03155, 1.00629,
         0.98159, 0.957444, 0.933713, 0.910558, 0.887949, 0.865735, 0.844073, 0.823237, 0.80479, 0.787093, 0.769875,
         0.751284, 0.730662, 0.709016, 0.688027, 0.66959, 0.653119, 0.63747, 0.62103, 0.604227, 0.587853, 0.571943,
         0.556473, 0.54137, 0.526506, 0.511915, 0.49776, 0.483985, 0.470581, 0.457646, 0.445154, 0.433081, 0.421336,
         0.40991, 0.398795, 0.387375, 0.376134, 0.36509, 0.35437, 0.343972, 0.333887, 0.324144, 0.314686, 0.305505,
         0.303012, 4.56315, 4.48199, 4.37039, 4.26157, 4.15551, 4.05207, 3.95118, 3.85283, 3.75692, 3.66337, 3.57219,
         3.48328, 3.39658, 3.31201, 3.22955, 3.14913, 3.07076, 2.99433, 2.91977, 2.84711, 2.77625, 2.70714, 2.63981,
         2.57417, 2.51017, 2.44775, 2.38689, 2.32756, 2.26967, 2.21324, 2.15824, 2.10256, 2.04765, 1.99371, 1.94119,
         1.89005, 1.84025, 1.79176, 1.74456, 1.69862, 1.6548, 1.61025, 1.56664, 1.52408, 1.48254, 1.44197, 1.40236,
         1.36373, 1.32597, 1.28918, 1.25329, 1.21828, 1.18414, 1.15087, 1.11842, 1.0868, 1.056, 1.02598, 0.996722,
         0.968234, 0.940485, 0.913468, 0.887163, 0.861554, 0.836624, 0.812351, 0.788746, 0.765755, 0.743395, 0.721644,
         0.700476, 0.679893, 0.659883, 0.640411, 0.621488, 0.603067, 0.585176, 0.567775, 0.550867, 0.534432, 0.518461,
         0.502941, 0.487859, 0.473204, 0.458952, 0.445127, 0.43168, 0.41864, 0.405953, 0.393637, 0.381676, 0.370061,
         0.358789, 0.347849, 0.337226, 0.32691, 0.316871, 0.307154, 0.297721, 0.288568, 0.279665, 0.271038, 0.262663,
         0.254539, 0.246653, 0.239003, 0.231581, 0.224381, 0.217395, 0.210617, 0.204045, 0.19767, 0.191485, 0.185487,
         0.17967, 0.174028, 0.168557, 0.163253, 0.15811, 0.15312, 0.148287, 0.143596, 0.139051, 0.134644, 0.130374,
         0.126234, 0.122218, 0.11833, 0.114557, 0.110903, 0.107363, 0.103929, 0.100602, 0.0973804, 0.0942536, 0.0912268,
         0.0882941, 0.085453, 0.0827005, 0.0800322, 0.0774482, 0.074945, 0.0725201, 0.0701711, 0.0678958, 0.0656919,
         0.0635572, 0.0614898, 0.0594875, 0.0575483, 0.0556703, 0.0538517, 0.0520907, 0.0503855, 0.0487343, 0.0471356,
         0.0455877, 0.044089, 0.0426382, 0.0412335, 0.0398738, 0.0385575, 0.0372834, 0.0360501, 0.0348564, 0.033701,
         0.0325828, 0.0315006, 0.0304532, 0.0294397, 0.0284589, 0.0275099, 0.0265915, 0.025703, 0.0248433, 0.0240116,
         0.0232069, 0.0224285, 0.0216755, 0.020947, 0.0202424, 0.0195609, 0.0189017, 0.0182679, 0.0176514, 0.0170554,
         0.0164792, 0.0159221, 0.0153835, 0.0148628, 0.0143595, 0.0138729, 0.0134024, 0.0129476, 0.012508, 0.012083,
         0.0116721, 0.0112749, 0.010891, 0.0105198, 0.010161, 0.00981422, 0.00947897, 0.00915492, 0.00884169,
         0.00853893, 0.00824628, 0.00796342, 0.00769003]],
    'Mg':                                                                           [
        [0.0005, 0.000507932, 0.0005159899999999999, 0.000524176, 0.000532492, 0.0005409389999999999,
         0.0005495210000000001, 0.000558238, 0.000567095, 0.000576091, 0.0005852300000000001, 0.000594515, 0.000603946,
         0.000613527, 0.00062326, 0.000633148, 0.000643192, 0.000653396, 0.0006637619999999999, 0.0006742920000000001,
         0.000684989, 0.000695856, 0.000706895, 0.000718109, 0.000729502, 0.000741075, 0.000752831, 0.000764775,
         0.000776907, 0.0007892320000000001, 0.0008017530000000001, 0.000814472, 0.000827393, 0.000840519, 0.000853853,
         0.000867399, 0.0008811590000000001, 0.000895138, 0.000909339, 0.0009237649999999999, 0.00093842, 0.000953307,
         0.0009684310000000001, 0.0009837939999999999, 0.000999401, 0.00101526, 0.00103136, 0.00104772, 0.00106435,
         0.0010812299999999999, 0.00109838, 0.00111581, 0.0011335100000000001, 0.0011514899999999998, 0.00116976,
         0.00118832, 0.00120717, 0.0012263200000000001, 0.00124577, 0.0012655400000000001, 0.00128561,
         0.0013060099999999998, 0.00132673, 0.00134778, 0.00136916, 0.00139088, 0.0014129400000000001,
         0.0014353599999999999, 0.00145813, 0.00148126, 0.0015047600000000002, 0.00152863, 0.00155288, 0.00157752,
         0.0016025400000000002, 0.0016279699999999999, 0.00165379, 0.0016800299999999999, 0.00170668, 0.00173376,
         0.00176126, 0.0017892, 0.00181759, 0.0018464199999999999, 0.00187572, 0.00190547, 0.0019357, 0.00196641,
         0.00199761, 0.0020293, 0.00206149, 0.00209419, 0.0021274199999999997, 0.00216117, 0.0021954500000000003,
         0.00223028, 0.00226566, 0.0023016, 0.00233812, 0.00237521, 0.00241289, 0.00245117, 0.00249006, 0.00252956,
         0.00256969, 0.0026104599999999998, 0.00265187, 0.00269394, 0.0027366799999999996, 0.00278009,
         0.0028241900000000003, 0.002869, 0.00291451, 0.00296075, 0.0030077199999999998, 0.00305543, 0.00310391,
         0.00315315, 0.00320317, 0.00325399, 0.00330561, 0.00335805, 0.00341132, 0.00346544, 0.0035204200000000002,
         0.00357627, 0.003633, 0.0036906400000000002, 0.00374918, 0.00380866, 0.00386908, 0.00393046, 0.00399282,
         0.0040561600000000005, 0.00412051, 0.00418588, 0.00425228, 0.004319740000000001, 0.0043882700000000005,
         0.00445789, 0.00452861, 0.004600450000000001, 0.00467344, 0.00474758, 0.00482289, 0.00489941, 0.00497713,
         0.00505609, 0.0051363, 0.00521778, 0.00530056, 0.0053846499999999995, 0.00547007, 0.0055568499999999995,
         0.00564501, 0.0057345600000000005, 0.00582553, 0.00591795, 0.00601184, 0.00610721, 0.006204100000000001,
         0.006302520000000001, 0.0064025, 0.00650407, 0.00660726, 0.0067120800000000005, 0.0068185599999999996,
         0.00692673, 0.00703662, 0.00714825, 0.007261650000000001, 0.00737685, 0.00749388, 0.00761276, 0.00773353,
         0.00785622, 0.00798085, 0.00810746, 0.00823608, 0.00836674, 0.00849947, 0.00863431, 0.008771290000000001,
         0.008910439999999999, 0.0090518, 0.0091954, 0.00934127, 0.009489470000000002, 0.009640010000000001,
         0.009779999999999999, 0.009880000000000002, 0.010036699999999999, 0.0101, 0.010199999999999999, 0.0103, 0.0103,
         0.0104634, 0.0105, 0.0105, 0.0106666, 0.0107, 0.0107, 0.0108697, 0.0109, 0.011, 0.0111745, 0.0113518,
         0.0115319, 0.011714800000000001, 0.011800000000000001, 0.0119, 0.012, 0.0121904, 0.0123838, 0.0125802,
         0.0127798, 0.0129825, 0.013188499999999999, 0.0133977, 0.0136103, 0.0138262, 0.0140455, 0.0142683, 0.0144947,
         0.0147247, 0.0149582, 0.015195499999999999, 0.0154366, 0.0156815, 0.0159303, 0.016183, 0.016439699999999998,
         0.0167005, 0.016965499999999998, 0.0172346, 0.017508, 0.017785799999999997, 0.0180679, 0.018354600000000002,
         0.0186458, 0.0189416, 0.0192421, 0.0195473, 0.019857399999999997, 0.0201724, 0.0204925, 0.0208176, 0.0211478,
         0.0214833, 0.021824100000000003, 0.0221704, 0.0225221, 0.0228794, 0.0232423, 0.0236111, 0.023985600000000003,
         0.024366099999999998, 0.024752700000000002, 0.0251454, 0.0255443, 0.0259495, 0.0263612, 0.0267794, 0.0272042,
         0.0276358, 0.0280742, 0.0285196, 0.0289721, 0.029431699999999998, 0.029898599999999997, 0.0303729,
         0.030854700000000002, 0.0313442, 0.0318415, 0.0323466, 0.0328598, 0.033381100000000004, 0.0339107,
         0.034448599999999996, 0.0349951, 0.0355503, 0.0361143, 0.036687199999999996, 0.037269199999999995,
         0.037860500000000005, 0.038461100000000005, 0.0390712, 0.0396911, 0.0403208, 0.0409604, 0.0416102, 0.0422703,
         0.0429409, 0.043622100000000004, 0.0443142, 0.0450172, 0.045731299999999996, 0.0464568, 0.0471938,
         0.047942500000000006, 0.048125, 0.048625, 0.049125, 0.04925, 0.049375, 0.0494, 0.0496, 0.049625, 0.04975,
         0.049875, 0.05, 0.0501, 0.0503, 0.0507, 0.0509, 0.0511, 0.0515, 0.0517, 0.0525, 0.0533329, 0.0535, 0.0541,
         0.0549583, 0.0558301, 0.056715800000000004, 0.0576156, 0.0585296, 0.0594581, 0.0604014, 0.0613596, 0.062333,
         0.0633219, 0.0643265, 0.06534699999999999, 0.0663836, 0.0674368, 0.0685066, 0.0695934, 0.07069750000000001,
         0.07181900000000001, 0.07295839999999999, 0.0741158, 0.0752916, 0.076486, 0.0776994, 0.0789321, 0.0801843,
         0.0814563, 0.08274859999999999, 0.0840613, 0.08539490000000001, 0.0867496, 0.0881258, 0.0884,
         0.08940000000000001, 0.09081829999999999, 0.092259, 0.0937227, 0.0952095, 0.0967199, 0.0982543, 0.0994, 0.0999,
         0.101485, 0.10309499999999999, 0.10473, 0.106392, 0.10808, 0.109794, 0.1115, 0.112, 0.113777,
         0.11558199999999999, 0.117415, 0.11927800000000001, 0.12117, 0.12309300000000001, 0.125045, 0.127029,
         0.12904400000000002, 0.13109200000000001, 0.132, 0.13240000000000002, 0.1345, 0.13663399999999998,
         0.13880199999999998, 0.141004, 0.143241, 0.145513, 0.147822, 0.150167, 0.15254900000000002, 0.154969,
         0.15742699999999998, 0.159925, 0.162462, 0.165039, 0.16765799999999997, 0.170317, 0.173019, 0.175764, 0.178552,
         0.181385, 0.184263, 0.18718600000000002, 0.188, 0.189, 0.191998, 0.19504400000000002, 0.198138,
         0.20128200000000002, 0.204475, 0.207719, 0.211014, 0.214362, 0.217762, 0.22121700000000002, 0.224727, 0.228292,
         0.231913, 0.23559200000000002, 0.23933000000000001, 0.243127, 0.246984, 0.250902, 0.254882, 0.258926, 0.263034,
         0.267206, 0.271445, 0.275752, 0.280126, 0.28457, 0.289085, 0.293671, 0.29833, 0.30306299999999997, 0.30787,
         0.312755, 0.317716, 0.322757, 0.32787700000000003, 0.333078, 0.338362, 0.34373000000000004,
         0.34918299999999997, 0.354723, 0.36035, 0.36606700000000003, 0.37187400000000004, 0.377774,
         0.38376699999999997, 0.389855, 0.39604, 0.402323, 0.408705, 0.41518900000000003, 0.421776, 0.428467, 0.435264,
         0.442169, 0.449184, 0.45631, 0.463549, 0.470903, 0.478373, 0.485962, 0.493672, 0.501503, 0.509459,
         0.5175420000000001, 0.525752, 0.5340929999999999, 0.542566, 0.551173, 0.559917, 0.5688, 0.577823, 0.58699,
         0.596302, 0.6057619999999999, 0.6153719999999999, 0.625134, 0.6350520000000001, 0.645126, 0.655361,
         0.6657580000000001, 0.676319, 0.687049, 0.697948, 0.709021, 0.720269, 0.7316950000000001, 0.743303,
         0.7550950000000001, 0.7670739999999999, 0.779243, 0.791605, 0.804163, 0.816921, 0.829881, 0.8430460000000001,
         0.85642, 0.870007, 0.883809, 0.89783, 0.912073, 0.926543, 0.9412419999999999, 0.956174, 0.971343, 0.986752,
         1.00241, 1.01831, 1.03446, 1.05087, 1.06755, 1.08448, 1.10169, 1.1191600000000002, 1.1369200000000002,
         1.1549500000000001, 1.1732799999999999, 1.1918900000000001, 1.2107999999999999, 1.23001, 1.24952, 1.26934,
         1.28948, 1.3025, 1.3029000000000002, 1.3031, 1.304, 1.3246900000000001, 1.3457000000000001, 1.3670499999999999,
         1.38874, 1.41077, 1.4331500000000001, 1.4558900000000001, 1.47898, 1.50245, 1.52628, 1.55049,
         1.5750899999999999, 1.60008, 1.6254600000000001, 1.65125, 1.67745, 1.70406, 1.73109, 1.75855, 1.78645, 1.81479,
         1.84358, 1.87283, 1.90254, 1.93272, 1.9633800000000001, 1.99453, 2.0, 2.026, 2.052, 2.079, 2.106, 2.134, 2.161,
         2.19, 2.218, 2.247, 2.277, 2.306, 2.337, 2.367, 2.398, 2.429, 2.461, 2.493, 2.526, 2.559, 2.592, 2.626, 2.66,
         2.695, 2.73, 2.766, 2.802, 2.839, 2.876, 2.914, 2.952, 2.99, 3.029, 3.069, 3.109, 3.15, 3.191, 3.232, 3.275,
         3.317, 3.361, 3.405, 3.449, 3.494, 3.54, 3.586, 3.633, 3.68, 3.729, 3.777, 3.827, 3.877, 3.927, 3.979, 4.031,
         4.083, 4.137, 4.191, 4.245, 4.301, 4.357, 4.414, 4.472, 4.53, 4.589, 4.649, 4.71, 4.771, 4.834, 4.897, 4.961,
         5.026, 5.091, 5.158, 5.225, 5.294, 5.363, 5.433, 5.504, 5.576, 5.649, 5.722, 5.797, 5.873, 5.95, 6.027, 6.106,
         6.186, 6.267, 6.349, 6.432, 6.516, 6.601, 6.687, 6.774, 6.863, 6.952, 7.043, 7.135, 7.229, 7.323, 7.419, 7.516,
         7.614, 7.713, 7.814, 7.916, 8.019, 8.124, 8.23, 8.338, 8.447, 8.557, 8.669, 8.782, 8.897, 9.013, 9.131, 9.25,
         9.371, 9.494, 9.618, 9.743, 9.89757, 10.0546, 10.2141, 10.376100000000001, 10.540700000000001, 10.708,
         10.877799999999999, 11.0504, 11.225700000000002, 11.403799999999999, 11.584700000000002, 11.7685,
         11.955200000000001, 12.1449, 12.3375, 12.5332, 12.7321, 12.9341, 13.139299999999999, 13.347700000000001,
         13.5594, 13.7746, 13.9931, 14.2151, 14.4406, 14.6697, 14.9024, 15.1388, 15.379, 15.623, 15.8708,
         16.122600000000002, 16.3784, 16.6382, 16.902099999999997, 17.1703, 17.442700000000002, 17.7194, 18.0005,
         18.286099999999998, 18.5761, 18.8708, 19.1702, 19.4743, 19.7833, 20.097099999999998, 20.416, 20.7398,
         21.068900000000003, 21.4031, 21.7427, 22.0876, 22.438, 22.7939, 23.1556, 23.5229, 23.896099999999997, 24.2752,
         24.6603, 25.0515, 25.448900000000002, 25.8526, 26.2628, 26.6794, 27.102700000000002, 27.5326, 27.9694, 28.4131,
         28.8639, 29.3218, 29.787, 30.0],
        [0.116976, 0.116835, 0.116533, 0.116533, 0.116226, 0.116155, 0.116161, 0.116106, 0.116343, 0.116663, 0.116876,
         0.117113, 0.117271, 0.117366, 0.11746, 0.117471, 0.117577, 0.117624, 0.117636, 0.117753, 0.117747, 0.117947,
         0.118014, 0.118147, 0.11824, 0.118402, 0.118558, 0.118755, 0.118974, 0.119179, 0.119449, 0.119694, 0.120034,
         0.120361, 0.120758, 0.121163, 0.121654, 0.122134, 0.122709, 0.12329, 0.123977, 0.124719, 0.12552, 0.126703,
         0.128066, 0.129452, 0.130724, 0.131784, 0.132868, 0.133939, 0.135045, 0.136126, 0.137247, 0.138361, 0.139542,
         0.140735, 0.141939, 0.143174, 0.144458, 0.14579, 0.147143, 0.148548, 0.149991, 0.151505, 0.153043, 0.154641,
         0.156288, 0.158013, 0.1598, 0.161627, 0.163528, 0.165508, 0.167566, 0.169696, 0.171889, 0.174186, 0.176578,
         0.179058, 0.181618, 0.184292, 0.187088, 0.190006, 0.193021, 0.196168, 0.199479, 0.202946, 0.206558, 0.210354,
         0.214373, 0.218672, 0.223394, 0.228378, 0.23349, 0.238671, 0.2438, 0.248747, 0.253819, 0.258998, 0.264293,
         0.26969, 0.275201, 0.280859, 0.286678, 0.292651, 0.298759, 0.305047, 0.311532, 0.318216, 0.325074, 0.332135,
         0.339434, 0.346977, 0.354751, 0.362755, 0.37104, 0.379628, 0.388519, 0.397693, 0.40721, 0.41711, 0.427414,
         0.438118, 0.449284, 0.461008, 0.473411, 0.486835, 0.501054, 0.515666, 0.530448, 0.54504, 0.559192, 0.573682,
         0.588447, 0.603514, 0.618883, 0.634589, 0.650693, 0.667225, 0.684196, 0.701606, 0.719528, 0.738008, 0.757074,
         0.776726, 0.797038, 0.818089, 0.839916, 0.862498, 0.887179, 0.913055, 0.93967, 0.966594, 0.993416, 1.0206,
         1.04835, 1.07678, 1.10594, 1.13593, 1.16686, 1.19884, 1.2321, 1.26515, 1.29928, 1.33541, 1.37428, 1.41834,
         1.46688, 1.51807, 1.57054, 1.62338, 1.68926, 1.75889, 1.82774, 1.8883, 1.9466, 2.00624, 2.06775, 2.13303,
         2.20378, 2.27449, 2.34577, 2.41683, 2.48553, 2.57198, 2.66471, 2.75881, 2.8489, 2.94694, 3.04434, 3.1245,
         3.16859, 3.25471, 3.29073, 3.34875, 3.34953, 3.34953, 3.30087, 3.29388, 3.29388, 3.19434, 3.18406, 3.18406,
         3.08399, 3.06576, 3.01472, 2.92733, 2.84524, 2.79604, 2.73238, 2.71418, 2.69209, 2.66339, 2.61317, 2.57578,
         2.54094, 2.50078, 2.46734, 2.43939, 2.41322, 2.38529, 2.35786, 2.3314, 2.30682, 2.28438, 2.26325, 2.24307,
         2.22352, 2.20451, 2.18616, 2.16849, 2.15166, 2.13533, 2.11948, 2.10421, 2.08962, 2.07588, 2.06254, 2.04964,
         2.03717, 2.0252, 2.01387, 2.0028, 1.99173, 1.9803, 1.96854, 1.95677, 1.94495, 1.93305, 1.9212, 1.91007, 1.8989,
         1.8873, 1.87469, 1.8614, 1.84764, 1.83347, 1.81909, 1.80436, 1.78853, 1.77181, 1.75417, 1.73546, 1.71581,
         1.69511, 1.67321, 1.64931, 1.62519, 1.60081, 1.57576, 1.54988, 1.52304, 1.49514, 1.46609, 1.43577, 1.40409,
         1.37091, 1.33611, 1.29952, 1.26078, 1.22023, 1.17789, 1.13342, 1.08656, 1.03716, 0.985223, 0.930168, 0.871612,
         0.80954, 0.741669, 0.667795, 0.587407, 0.499598, 0.403295, 0.297105, 0.178859, 0.0455541, -0.107287, -0.285839,
         -0.502483, -0.782572, -0.865813, -1.14658, -1.58527, -1.7598, -2.00215, -2.06455, -2.73129, -2.69545, -2.36792,
         -2.20807, -2.20797, -2.18737, -1.86281, -1.34521, -1.33492, -1.40116, -1.41065, -1.3879, -1.25572, -1.30478,
         -1.32241, -1.39003, -1.49178, -1.43552, -1.38329, -1.43664, -1.51362, -1.59461, -1.67701, -1.76716, -1.84091,
         -1.88244, -1.89358, -1.8733, -1.82399, -1.70021, -1.46811, -1.03007, -0.423291, 0.244759, 0.969362, 1.36724,
         1.53653, 1.3834, 1.20333, 1.06754, 0.993543, 1.05545, 1.1387, 1.24848, 1.38811, 1.57057, 1.72799, 1.76807,
         2.11967, 2.40937, 2.70741, 2.99133, 3.28366, 3.63103, 3.98458, 4.27008, 4.07578, 4.53777, 4.96019, 5.00251,
         5.10659, 5.18107, 5.0869, 5.53071, 5.18961, 5.20548, 5.13167, 5.11054, 5.14139, 5.25975, 5.5054, 5.80105,
         6.11439, 6.41231, 6.78764, 6.79057, 7.13719, 6.85563, 6.56993, 6.99118, 7.03475, 7.07781, 7.1597, 7.25653,
         7.36241, 7.47567, 7.60106, 7.74082, 7.90177, 8.10511, 8.32287, 8.5358, 8.72921, 8.87321, 8.97888, 9.07053,
         9.15283, 9.22552, 9.39002, 9.44732, 9.36287, 9.41045, 9.45313, 9.51028, 9.57443, 9.64474, 9.7294, 9.81848,
         9.90795, 9.99601, 10.0707, 10.1371, 10.198, 10.2547, 10.3078, 10.3579, 10.4054, 10.4506, 10.4936, 10.5349,
         10.5746, 10.6129, 10.6499, 10.6874, 10.725, 10.7626, 10.8019, 10.8424, 10.8731, 10.8994, 10.9223, 10.9425,
         10.9605, 10.9764, 10.9906, 11.0031, 11.0141, 11.0238, 11.0323, 11.0396, 11.0458, 11.051, 11.0554, 11.0589,
         11.0617, 11.0638, 11.0652, 11.066, 11.0664, 11.0663, 11.0659, 11.0653, 11.0649, 11.0653, 11.065, 11.0638,
         11.0615, 11.057, 11.0513, 11.0449, 11.0379, 11.0302, 11.0221, 11.0136, 11.0047, 10.9956, 10.9867, 10.9808,
         10.9735, 10.9581, 10.9412, 10.9261, 10.9113, 10.8965, 10.8815, 10.8663, 10.8509, 10.8353, 10.8194, 10.8033,
         10.7869, 10.7702, 10.7533, 10.7369, 10.7209, 10.7041, 10.686, 10.6656, 10.6448, 10.6229, 10.5993, 10.5716,
         10.545, 10.5197, 10.4953, 10.4735, 10.4532, 10.4271, 10.3979, 10.3656, 10.3291, 10.2916, 10.2522, 10.2107,
         10.1665, 10.1208, 10.0722, 10.0198, 9.96207, 9.89777, 9.82802, 9.75132, 9.66632, 9.57146, 9.46316, 9.33863,
         9.19338, 9.0202, 8.80835, 8.5383, 8.17049, 7.60707, 6.45363, 2.06794, -0.106704, -0.104074, 3.02135, 7.2902,
         8.27349, 8.87167, 9.30474, 9.64429, 9.92299, 10.1586, 10.362, 10.5403, 10.6986, 10.8405, 10.9686, 11.085,
         11.1913, 11.289, 11.3791, 11.4629, 11.5429, 11.6171, 11.6843, 11.7455, 11.8017, 11.8537, 11.9018, 11.9465,
         11.9881, 12.026, 12.0324, 12.0629, 12.0918, 12.119, 12.1439, 12.1678, 12.189, 12.2101, 12.2288, 12.2467,
         12.2638, 12.2789, 12.2938, 12.307, 12.3194, 12.3309, 12.3417, 12.3514, 12.3605, 12.3688, 12.3762, 12.3831,
         12.3893, 12.395, 12.4, 12.4045, 12.4084, 12.4119, 12.4148, 12.4173, 12.4194, 12.421, 12.4223, 12.4232, 12.4238,
         12.424, 12.424, 12.4236, 12.4229, 12.422, 12.4209, 12.4195, 12.4179, 12.416, 12.414, 12.4118, 12.4094, 12.4069,
         12.4042, 12.4014, 12.3984, 12.3953, 12.3922, 12.3888, 12.3854, 12.382, 12.3783, 12.3747, 12.371, 12.3672,
         12.3633, 12.3594, 12.3554, 12.3515, 12.3474, 12.3434, 12.3393, 12.3352, 12.331, 12.3269, 12.3227, 12.3185,
         12.3144, 12.3102, 12.306, 12.3018, 12.2976, 12.2934, 12.2893, 12.2851, 12.281, 12.2769, 12.2728, 12.2687,
         12.2647, 12.2607, 12.2567, 12.2527, 12.2487, 12.2448, 12.2409, 12.237, 12.2332, 12.2294, 12.2257, 12.222,
         12.2183, 12.2146, 12.211, 12.2074, 12.2039, 12.2004, 12.1969, 12.1935, 12.1901, 12.1868, 12.1835, 12.1802,
         12.177, 12.1738, 12.1706, 12.1675, 12.1645, 12.1614, 12.1585, 12.1555, 12.1526, 12.1497, 12.1469, 12.1441,
         12.1414, 12.1386, 12.136, 12.1328, 12.1297, 12.1266, 12.1236, 12.1206, 12.1177, 12.1149, 12.1121, 12.1093,
         12.1066, 12.104, 12.1014, 12.0988, 12.0964, 12.0939, 12.0915, 12.0892, 12.0869, 12.0846, 12.0824, 12.0803,
         12.0781, 12.0761, 12.074, 12.072, 12.0701, 12.0682, 12.0663, 12.0645, 12.0627, 12.061, 12.0593, 12.0576,
         12.056, 12.0544, 12.0528, 12.0513, 12.0498, 12.0483, 12.0469, 12.0455, 12.0441, 12.0427, 12.0414, 12.0402,
         12.0389, 12.0377, 12.0365, 12.0353, 12.0342, 12.0331, 12.032, 12.0309, 12.0299, 12.0288, 12.0278, 12.0269,
         12.0259, 12.025, 12.0241, 12.0232, 12.0224, 12.0215, 12.0207, 12.0199, 12.0191, 12.0184, 12.0176, 12.0169,
         12.0162, 12.0155, 12.0152],
        [0.145925, 0.148961, 0.152059, 0.155223, 0.158452, 0.161748, 0.165113, 0.168547, 0.172054, 0.175582, 0.178809,
         0.182096, 0.185442, 0.188851, 0.192321, 0.195856, 0.199456, 0.203121, 0.206855, 0.210656, 0.214528, 0.218471,
         0.222486, 0.226575, 0.230739, 0.23498, 0.239298, 0.243696, 0.248175, 0.252736, 0.257381, 0.262112, 0.266929,
         0.271835, 0.276831, 0.281918, 0.2871, 0.292376, 0.29775, 0.303222, 0.308795, 0.31447, 0.32025, 0.326135,
         0.332129, 0.337611, 0.343158, 0.348796, 0.354527, 0.360352, 0.366272, 0.37229, 0.378407, 0.384624, 0.390943,
         0.397366, 0.403895, 0.410531, 0.417276, 0.424132, 0.4311, 0.438183, 0.445382, 0.4527, 0.460138, 0.467698,
         0.475382, 0.483193, 0.491132, 0.499201, 0.507403, 0.515739, 0.524213, 0.532826, 0.54158, 0.550478, 0.559523,
         0.568716, 0.578059, 0.587557, 0.59721, 0.607023, 0.616996, 0.627133, 0.637437, 0.64791, 0.658555, 0.669375,
         0.680373, 0.691552, 0.702914, 0.714322, 0.724938, 0.735712, 0.746646, 0.757743, 0.769004, 0.780433, 0.792032,
         0.803803, 0.815749, 0.827873, 0.840176, 0.852663, 0.865335, 0.878195, 0.891247, 0.904493, 0.917936, 0.931577,
         0.945422, 0.959473, 0.973733, 0.988205, 1.00289, 1.0178, 1.03292, 1.04827, 1.06385, 1.07966, 1.09571, 1.11199,
         1.12852, 1.14529, 1.16231, 1.17959, 1.19697, 1.21193, 1.22708, 1.24242, 1.25795, 1.27367, 1.28959, 1.30571,
         1.32203, 1.33855, 1.35528, 1.37222, 1.38937, 1.40673, 1.42432, 1.44212, 1.46014, 1.47839, 1.49687, 1.51558,
         1.53452, 1.5537, 1.57312, 1.59279, 1.61063, 1.62735, 1.64423, 1.66129, 1.67853, 1.69595, 1.71354, 1.73132,
         1.74929, 1.76744, 1.78578, 1.80431, 1.82303, 1.84402, 1.86712, 1.89052, 1.91288, 1.92912, 1.9455, 1.96202,
         1.97869, 1.98692, 1.98261, 1.97831, 1.97401, 1.96973, 1.96546, 1.96119, 1.95693, 1.93823, 1.91649, 1.895,
         1.87374, 1.85272, 1.83194, 1.78295, 1.72133, 1.65063, 1.55337, 1.46932, 1.40788, 1.27556, 1.22629, 1.13533,
         0.986677, 0.94477, 0.814767, 0.745742, 0.705354, 0.611967, 0.571897, 0.549754, 0.469489, 0.456586, 0.427164,
         0.370427, 0.350648, 0.31831, 0.296949, 0.291446, 0.278656, 0.258402, 0.250332, 0.242515, 0.228469, 0.218505,
         0.214617, 0.210799, 0.202866, 0.195155, 0.190772, 0.186486, 0.18455, 0.183367, 0.182192, 0.181024, 0.179863,
         0.178949, 0.179384, 0.17982, 0.180257, 0.180695, 0.182086, 0.183781, 0.185491, 0.187217, 0.188959, 0.190717,
         0.192492, 0.194283, 0.196091, 0.196681, 0.196973, 0.197266, 0.197559, 0.197852, 0.198146, 0.19844, 0.198735,
         0.19903, 0.198931, 0.19728, 0.195643, 0.194019, 0.192409, 0.190812, 0.189228, 0.187097, 0.184137, 0.181223,
         0.178356, 0.175534, 0.172757, 0.170024, 0.167334, 0.165041, 0.164522, 0.164004, 0.163489, 0.162974, 0.162462,
         0.161951, 0.161442, 0.160934, 0.160428, 0.159923, 0.15942, 0.158919, 0.158526, 0.158819, 0.159112, 0.159405,
         0.159699, 0.159993, 0.160289, 0.160584, 0.16088, 0.158664, 0.156244, 0.15386, 0.151513, 0.149201, 0.147144,
         0.145157, 0.143196, 0.141261, 0.139717, 0.138555, 0.137403, 0.136261, 0.135986, 0.135518, 0.142785, 0.146448,
         0.157885, 0.160274, 0.755467, 1.03535, 1.41929, 1.50928, 1.52981, 2.02454, 1.99775, 1.77907, 1.73052, 1.72876,
         1.90441, 1.96258, 1.99203, 2.05673, 2.06984, 2.13993, 2.4182, 2.60886, 2.73104, 2.85894, 3.01173, 3.19546,
         3.39039, 3.64687, 3.94736, 4.27261, 4.62466, 5.00571, 5.43219, 5.91258, 6.43546, 6.89618, 7.25149, 7.4223,
         7.29863, 6.91463, 6.50887, 6.20278, 6.18923, 6.32605, 6.51664, 6.71298, 6.91523, 7.12358, 7.33819, 7.55928,
         7.78704, 7.83278, 8.08663, 8.14048, 8.1947, 8.24928, 8.30421, 8.29579, 8.16648, 8.07253, 8.18816, 8.02324,
         7.86165, 7.70331, 7.54816, 7.39612, 7.2547, 7.24546, 6.96742, 7.01582, 7.06455, 7.17584, 7.34062, 7.50919,
         7.68162, 7.83236, 7.80502, 7.77777, 7.66375, 7.60012, 7.40672, 7.36095, 7.31546, 7.15929, 7.0201, 7.02133,
         7.02255, 7.02377, 7.02499, 7.02621, 7.03887, 7.05288, 7.06692, 7.08098, 7.05648, 6.91587, 6.77805, 6.64299,
         6.51061, 6.38212, 6.27735, 6.1743, 6.07295, 6.04529, 5.90933, 5.8471, 5.78553, 5.7246, 5.66431, 5.60467,
         5.54564, 5.48724, 5.41222, 5.31334, 5.21626, 5.12097, 5.02741, 4.93556, 4.84538, 4.75686, 4.66996, 4.58463,
         4.50087, 4.41864, 4.33791, 4.25866, 4.18086, 4.10447, 4.02949, 3.95587, 3.88143, 3.79391, 3.70835, 3.62473,
         3.54299, 3.4631, 3.385, 3.30867, 3.23406, 3.16113, 3.08985, 3.02017, 2.95207, 2.8855, 2.82043, 2.75683,
         2.69466, 2.6339, 2.5745, 2.51645, 2.4597, 2.40424, 2.35002, 2.29703, 2.24523, 2.1946, 2.14511, 2.09674,
         2.04702, 1.99566, 1.94558, 1.89676, 1.84917, 1.80277, 1.75754, 1.71344, 1.67044, 1.62853, 1.58767, 1.54783,
         1.50899, 1.47057, 1.42542, 1.38239, 1.34676, 1.31205, 1.27823, 1.24529, 1.21319, 1.18193, 1.15146, 1.12179,
         1.09287, 1.06466, 1.03711, 1.01027, 0.984124, 0.958655, 0.933525, 0.905954, 0.879195, 0.853228, 0.828028,
         0.802844, 0.777737, 0.753414, 0.735497, 0.718703, 0.702292, 0.686256, 0.665272, 0.639352, 0.614443, 0.590503,
         0.569538, 0.549676, 0.530506, 0.512005, 0.494149, 0.476915, 0.459769, 0.440497, 0.422032, 0.404342, 0.387393,
         0.371155, 0.355372, 0.338265, 0.321983, 0.306484, 0.291731, 0.277688, 0.264949, 0.253248, 0.242063, 0.231373,
         0.221154, 0.214869, 0.21468, 4.46654, 4.46202, 4.36019, 4.26015, 4.16239, 4.06689, 3.97354, 3.88233, 3.79323,
         3.7063, 3.62146, 3.53874, 3.45789, 3.37889, 3.30171, 3.2263, 3.15263, 3.08062, 3.01026, 2.94137, 2.87016,
         2.80005, 2.73108, 2.66378, 2.59815, 2.53413, 2.47172, 2.41082, 2.35138, 2.34119, 2.29521, 2.24797, 2.20034,
         2.1541, 2.10767, 2.06419, 2.0189, 1.97656, 1.934, 1.8913, 1.85132, 1.80993, 1.77109, 1.73223, 1.69472, 1.65705,
         1.62057, 1.58424, 1.54907, 1.51499, 1.4811, 1.44823, 1.4155, 1.38383, 1.35233, 1.32186, 1.29158, 1.26231,
         1.23324, 1.20514, 1.17798, 1.15102, 1.1243, 1.09848, 1.07291, 1.04819, 1.02432, 1.00012, 0.977287, 0.954199,
         0.931879, 0.910333, 0.889051, 0.86804, 0.847753, 0.827722, 0.808395, 0.788961, 0.770559, 0.752067, 0.734236,
         0.717008, 0.699726, 0.683049, 0.666932, 0.650806, 0.635238, 0.620227, 0.605206, 0.590712, 0.576463, 0.562495,
         0.549014, 0.535807, 0.522834, 0.510106, 0.497863, 0.485646, 0.473872, 0.462327, 0.451024, 0.440154, 0.429323,
         0.418873, 0.408534, 0.398525, 0.388758, 0.379214, 0.369874, 0.360784, 0.351961, 0.343281, 0.334769, 0.326469,
         0.318471, 0.310563, 0.302844, 0.295316, 0.287973, 0.280811, 0.273831, 0.26702, 0.260383, 0.253915, 0.247543,
         0.241401, 0.23535, 0.229456, 0.223661, 0.218075, 0.212586, 0.207239, 0.202038, 0.196975, 0.192004, 0.187167,
         0.18246, 0.177843, 0.173351, 0.168946, 0.164665, 0.160508, 0.156429, 0.152468, 0.148585, 0.144811, 0.141122,
         0.137533, 0.134022, 0.130587, 0.127254, 0.124018, 0.120181, 0.11646, 0.11285, 0.109348, 0.105952, 0.102658,
         0.0994624, 0.0963636, 0.0933582, 0.0904435, 0.0876169, 0.0848758, 0.0822176, 0.07964, 0.0771405, 0.0747169,
         0.0723669, 0.0700883, 0.0678791, 0.0657371, 0.0636604, 0.0616471, 0.0596953, 0.057803, 0.0559687, 0.0541905,
         0.0524668, 0.0507959, 0.0491762, 0.0476063, 0.0460846, 0.0446098, 0.0431803, 0.0417948, 0.0404521, 0.0391507,
         0.0378896, 0.0366674, 0.035483, 0.0343353, 0.0332231, 0.0321453, 0.031101, 0.0300891, 0.0291087, 0.0281616,
         0.0272417, 0.0263512, 0.0254891, 0.0246546, 0.0238467, 0.0230647, 0.0223077, 0.0215749, 0.0208656, 0.020179,
         0.0195144, 0.0188712, 0.0182486, 0.017646, 0.0170628, 0.0164983, 0.015952, 0.0154233, 0.0149116, 0.0144165,
         0.0139373, 0.0134736, 0.0130248, 0.0125906, 0.0121704, 0.0119846]],
    'Al':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.0726, 0.0728, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.5595, 1.5597, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005,
         1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943,
         2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 2.34285, 2.32717, 2.31139, 2.29552, 2.27956, 2.2635, 2.24754, 2.23175, 2.21555, 2.19843, 2.18068, 2.16235,
         2.14342, 2.12388, 2.10371, 2.08287, 2.06135, 2.03911, 2.01612, 1.99237, 1.96797, 1.94295, 1.91682, 1.88912,
         1.86007, 1.82966, 1.79787, 1.76466, 1.73005, 1.69399, 1.65814, 1.62074, 1.57843, 1.53229, 1.48252, 1.42904,
         1.37159, 1.30972, 1.24315, 1.17229, 1.09675, 1.01559, 0.928103, 0.833427, 0.729805, 0.61672, 0.494009,
         0.359171, 0.206766, 0.0367838, -0.1501, -0.3634, -0.612251, -0.913185, -1.29772, -1.83916, -2.8264, -4.7187,
         -4.77865, -3.57738, -2.58986, -2.24498, -2.04974, -1.91658, -1.81173, -1.71207, -1.61278, -1.51695, -1.40821,
         -1.24639, -1.04412, -0.869623, -0.729715, -0.602517, -0.481649, -0.363849, -0.246485, -0.127798, -0.00572152,
         0.121587, 0.257648, 0.408417, 0.563135, 0.713525, 0.869599, 1.03257, 1.20465, 1.38785, 1.58511, 1.79993,
         2.03832, 2.31105, 2.65726, 3.0545, 3.37636, 3.65455, 3.91635, 4.16654, 4.40886, 4.64594, 4.87987, 5.11258,
         5.34618, 5.58438, 5.83549, 6.09089, 6.32655, 6.55613, 6.78302, 7.00948, 7.23759, 7.4698, 7.70942, 7.96219,
         8.24313, 8.57964, 8.88946, 9.11623, 9.32069, 9.50496, 9.67311, 9.82798, 9.97197, 10.1053, 10.2265, 10.3376,
         10.4388, 10.5299, 10.6083, 10.668, 10.7284, 10.8042, 10.8811, 10.9592, 11.038, 11.1176, 11.1983, 11.2808,
         11.3664, 11.463, 11.5725, 11.6747, 11.7511, 11.8159, 11.8724, 11.9222, 11.9664, 12.0058, 12.0408, 12.0718,
         12.0993, 12.1235, 12.1445, 12.1625, 12.1777, 12.19, 12.1992, 12.2049, 12.2045, 12.1998, 12.2008, 12.2048,
         12.2097, 12.2152, 12.221, 12.227, 12.2333, 12.2399, 12.247, 12.2549, 12.2652, 12.2773, 12.2849, 12.2892,
         12.292, 12.2937, 12.2943, 12.2945, 12.2942, 12.2939, 12.2928, 12.2896, 12.2852, 12.2801, 12.2748, 12.27,
         12.2653, 12.2592, 12.2522, 12.2437, 12.2344, 12.2243, 12.2138, 12.2034, 12.1929, 12.1814, 12.1674, 12.1491,
         12.1287, 12.1108, 12.0954, 12.082, 12.0674, 12.0514, 12.035, 12.0181, 12.0009, 11.9834, 11.9652, 11.9463,
         11.9269, 11.907, 11.8866, 11.8656, 11.8441, 11.822, 11.7992, 11.7759, 11.7519, 11.727, 11.7013, 11.6747,
         11.6472, 11.6184, 11.5888, 11.5591, 11.5278, 11.4947, 11.46, 11.4234, 11.3849, 11.344, 11.3007, 11.2544,
         11.2049, 11.1516, 11.0938, 11.031, 10.9622, 10.8865, 10.8021, 10.7069, 10.598, 10.4713, 10.3206, 10.1361,
         9.90068, 9.58044, 9.09216, 8.11537, 1.89396, 1.89589, 7.10441, 9.03572, 9.80337, 10.2995, 10.669, 10.9642,
         11.2121, 11.4254, 11.6086, 11.7695, 11.9117, 12.0391, 12.154, 12.2583, 12.3536, 12.4408, 12.5226, 12.6001,
         12.6695, 12.7334, 12.7923, 12.8467, 12.8969, 12.9433, 12.9861, 13.0257, 13.0622, 13.096, 13.1272, 13.156,
         13.1825, 13.2068, 13.2292, 13.2498, 13.2687, 13.2859, 13.3016, 13.3159, 13.3288, 13.3405, 13.351, 13.3604,
         13.3688, 13.3762, 13.3827, 13.3883, 13.3932, 13.3973, 13.4007, 13.4034, 13.4055, 13.407, 13.408, 13.4085,
         13.4085, 13.4081, 13.4072, 13.406, 13.4044, 13.4025, 13.4003, 13.3978, 13.395, 13.392, 13.3888, 13.3853,
         13.3817, 13.3779, 13.3739, 13.3698, 13.3656, 13.3612, 13.3568, 13.3522, 13.3476, 13.3429, 13.3381, 13.3332,
         13.3284, 13.3235, 13.3185, 13.3135, 13.3086, 13.3036, 13.2986, 13.2936, 13.2886, 13.2836, 13.2786, 13.2737,
         13.2687, 13.2638, 13.259, 13.2541, 13.2493, 13.2446, 13.2398, 13.2352, 13.2305, 13.2259, 13.2214, 13.2169,
         13.2124, 13.2081, 13.2037, 13.1994, 13.1952, 13.191, 13.1869, 13.1829, 13.1789, 13.1749, 13.1711, 13.1672,
         13.1635, 13.1598, 13.1561, 13.1526, 13.149, 13.1456, 13.1422, 13.1388, 13.1355, 13.1323, 13.1291, 13.126,
         13.1229, 13.1199, 13.117, 13.1141, 13.1112, 13.1084, 13.1057, 13.103, 13.1004, 13.0978, 13.0953, 13.0928,
         13.0903, 13.088, 13.0856, 13.0833, 13.0811, 13.0789, 13.0768, 13.0746, 13.0726, 13.0706, 13.0686, 13.0667,
         13.0648, 13.0629, 13.0611, 13.0593, 13.0576, 13.0559, 13.0542, 13.0526, 13.051, 13.0494, 13.0479, 13.0464,
         13.0449, 13.0435, 13.0421, 13.0407, 13.0394, 13.0381, 13.0368, 13.0356, 13.0343, 13.0331, 13.032, 13.0308,
         13.0297, 13.0287, 13.0276, 13.0266, 13.0256, 13.0246, 13.0236, 13.0227, 13.0218, 13.0209, 13.0198],
        [3.1199, 3.05822, 2.99776, 2.9385, 2.88041, 2.82347, 2.76766, 2.722, 2.69148, 2.66129, 2.63145, 2.60195,
         2.57277, 2.54392, 2.51539, 2.46668, 2.41373, 2.36192, 2.30898, 2.23405, 2.15356, 2.06069, 1.96756, 1.81305,
         1.35947, 0.902011, 0.609172, 0.439681, 0.372037, 0.326005, 0.285669, 0.247205, 0.21352, 0.196522, 0.181095,
         0.168385, 0.160808, 0.153573, 0.146663, 0.140063, 0.133164, 0.126575, 0.120312, 0.11436, 0.109752, 0.11101,
         0.112282, 0.113569, 0.11487, 0.116186, 0.117518, 0.118864, 0.120227, 0.122751, 0.126315, 0.129984, 0.133759,
         0.137643, 0.14164, 0.145495, 0.148244, 0.151045, 0.153898, 0.156806, 0.159768, 0.162787, 0.165863, 0.168996,
         0.172189, 0.175442, 0.178757, 0.182134, 0.185575, 0.189081, 0.192378, 0.194561, 0.196767, 0.198999, 0.201256,
         0.203539, 0.205847, 0.208182, 0.210544, 0.212932, 0.215347, 0.217789, 0.220259, 0.222758, 0.225068, 0.22647,
         0.22788, 0.229299, 0.230727, 0.232164, 0.23361, 0.235064, 0.236528, 0.238001, 0.235842, 0.232104, 0.228425,
         0.224805, 0.221242, 0.217735, 0.214284, 0.211759, 0.209829, 0.207917, 0.206022, 0.204145, 0.202284, 0.200441,
         0.200207, 0.200602, 0.200998, 0.201394, 0.208215, 0.215821, 0.223705, 0.231878, 0.239512, 0.247287, 0.255315,
         0.263603, 0.268298, 3.05391, 3.10106, 3.27808, 3.46521, 3.66301, 3.87212, 4.09316, 4.32681, 4.55877, 4.80227,
         5.05877, 5.32897, 5.54566, 5.6907, 5.83953, 5.99225, 6.14897, 6.30978, 6.4748, 6.64413, 6.8179, 6.9962,
         7.17918, 7.36022, 7.52866, 7.70096, 7.8772, 8.05748, 8.24188, 8.4305, 8.62344, 8.8208, 9.02267, 9.22916,
         9.44037, 9.49754, 9.51114, 9.52475, 9.5384, 9.55206, 9.56573, 9.57943, 9.59315, 9.60689, 9.62064, 9.63443,
         9.64822, 9.6231, 9.59689, 9.57075, 9.54468, 9.51868, 9.49275, 9.46689, 9.44111, 9.4154, 9.38975, 9.31472,
         9.13115, 8.95119, 8.77477, 8.60184, 8.43231, 8.26612, 8.10317, 7.93953, 7.7792, 7.6221, 7.46817, 7.31736,
         7.16959, 7.03532, 6.92993, 6.82611, 6.72384, 6.62312, 6.52389, 6.42616, 6.32988, 6.23505, 6.14164, 6.04964,
         5.94856, 5.80523, 5.66535, 5.52884, 5.39563, 5.26561, 5.13874, 5.01492, 4.89409, 4.77616, 4.66108, 4.54877,
         4.43917, 4.33221, 4.22782, 4.12595, 4.02654, 3.92952, 3.83484, 3.75388, 3.67818, 3.604, 3.53133, 3.46011,
         3.39034, 3.32197, 3.25498, 3.18934, 3.12502, 3.06201, 3.00026, 2.93296, 2.86424, 2.7973, 2.73189, 2.66798,
         2.60559, 2.54463, 2.4849, 2.4257, 2.36643, 2.30801, 2.25125, 2.19625, 2.14277, 2.09062, 2.03805, 1.98589,
         1.93406, 1.88338, 1.83389, 1.78571, 1.73879, 1.69298, 1.64704, 1.60038, 1.55377, 1.50856, 1.46882, 1.43328,
         1.39941, 1.3638, 1.32737, 1.29193, 1.25742, 1.22382, 1.191, 1.15872, 1.12705, 1.09624, 1.06625, 1.03708,
         1.0087, 0.981035, 0.954065, 0.927842, 0.902346, 0.877557, 0.853321, 0.829761, 0.806859, 0.784555, 0.762967,
         0.742081, 0.722661, 0.703173, 0.683588, 0.664537, 0.646018, 0.628015, 0.610519, 0.593506, 0.576965, 0.560888,
         0.545258, 0.530064, 0.515441, 0.50138, 0.487892, 0.474763, 0.461987, 0.449555, 0.437459, 0.425689, 0.414239,
         0.403093, 0.3921, 0.381187, 0.36968, 0.358399, 0.350553, 4.16629, 4.14105, 4.05144, 3.96379, 3.87809, 3.7942,
         3.71213, 3.63182, 3.54896, 3.46653, 3.38494, 3.30527, 3.22747, 3.15148, 3.07731, 3.00489, 2.93417, 2.86696,
         2.79699, 2.72803, 2.66035, 2.59405, 2.52881, 2.46498, 2.40235, 2.34101, 2.28095, 2.22204, 2.16445, 2.1081,
         2.05284, 1.99885, 1.94606, 1.89447, 1.844, 1.79474, 1.74651, 1.69945, 1.6535, 1.60862, 1.56481, 1.52204,
         1.48033, 1.43961, 1.39989, 1.36116, 1.32339, 1.28657, 1.25064, 1.21564, 1.18154, 1.14831, 1.11591, 1.08436,
         1.05363, 1.02369, 0.994542, 0.966167, 0.938535, 0.911645, 0.885448, 0.859966, 0.835163, 0.811033, 0.787559,
         0.764708, 0.742491, 0.720878, 0.699839, 0.679399, 0.659516, 0.640176, 0.621389, 0.603106, 0.585342, 0.56808,
         0.551279, 0.534968, 0.519116, 0.503715, 0.488726, 0.474187, 0.460062, 0.446336, 0.433003, 0.420026, 0.407459,
         0.395224, 0.383348, 0.371815, 0.360616, 0.349739, 0.339182, 0.328927, 0.318973, 0.309309, 0.299926, 0.290817,
         0.281974, 0.273391, 0.265058, 0.256972, 0.249121, 0.241506, 0.234114, 0.226938, 0.219978, 0.213218, 0.206663,
         0.200304, 0.194131, 0.18814, 0.182331, 0.176693, 0.171229, 0.165921, 0.16078, 0.155788, 0.150945, 0.146248,
         0.141693, 0.137274, 0.132988, 0.128831, 0.1248, 0.12089, 0.117099, 0.113422, 0.109856, 0.106398, 0.103045,
         0.0997941, 0.0966416, 0.0935848, 0.0906209, 0.0877473, 0.0849611, 0.0822598, 0.0796408, 0.0771018, 0.0746402,
         0.0722539, 0.0699405, 0.0676979, 0.065524, 0.0634165, 0.0613737, 0.0593935, 0.0574741, 0.0556136, 0.0538102,
         0.0520623, 0.0503681, 0.048726, 0.0471345, 0.045592, 0.044097, 0.0426482, 0.041244, 0.0398831, 0.0385533,
         0.0372771, 0.0360423, 0.0348475, 0.0336915, 0.0325731, 0.0314909, 0.030444, 0.0294311, 0.0284511, 0.027503,
         0.0265858, 0.0256985, 0.0248401, 0.0240097, 0.0232064, 0.0224293, 0.0216776, 0.0209505, 0.0202471, 0.0195668,
         0.0189087, 0.0182722, 0.0176565, 0.0170611, 0.0164852]],
    'Si':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.011010500000000001, 0.0111886, 0.0113696,
         0.0115535, 0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268,
         0.013135899999999999, 0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146972,
         0.014935, 0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.0183988, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258099999999998, 0.020585799999999998, 0.020918700000000002, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234052, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253602, 0.0257704, 0.0261872, 0.0266108, 0.0270412, 0.0274786, 0.027923, 0.0283747,
         0.0288336, 0.0293, 0.029773900000000002, 0.030255400000000002, 0.030744800000000003, 0.031242100000000002,
         0.0317474, 0.0322609, 0.0327827, 0.0333129, 0.0338517, 0.0343992, 0.034955599999999996, 0.035521000000000004,
         0.0360955, 0.0366793, 0.037272599999999996, 0.0378754, 0.038488, 0.039110599999999995, 0.039743099999999996,
         0.040386000000000005, 0.0410392, 0.0417029, 0.0423774, 0.0430629, 0.0437594, 0.0444671, 0.0451864, 0.0459172,
         0.0466599, 0.0474146, 0.0481815, 0.0489608, 0.0497527, 0.0505574, 0.0513751, 0.0522061, 0.0530505, 0.0539085,
         0.0547804, 0.0556665, 0.0565668, 0.0574817, 0.0584115, 0.0593562, 0.060316299999999996, 0.0612918,
         0.062283200000000004, 0.0632906, 0.0643142, 0.0653545, 0.0664115, 0.0674857, 0.0685772, 0.06968640000000001,
         0.0708135, 0.0719588, 0.0731227, 0.07430540000000001, 0.0755072, 0.07672849999999999, 0.0779695, 0.0792306,
         0.0805121, 0.0818143, 0.0831376, 0.0844823, 0.0858487, 0.0872373, 0.0886483, 0.0900821, 0.0915391, 0.0930197,
         0.09452419999999999, 0.096053, 0.0976066, 0.0991853, 0.0995, 0.099524, 0.09954900000000001, 0.099576, 0.099601,
         0.099626, 0.099649, 0.099676, 0.099699, 0.099726, 0.09974899999999999, 0.099775, 0.099826, 0.099851, 0.099875,
         0.099899, 0.099926, 0.099951, 0.09997400000000001, 0.1, 0.10003000000000001, 0.10012, 0.10018, 0.10022,
         0.10025, 0.10028000000000001, 0.1003, 0.10035, 0.10038, 0.10045, 0.10048, 0.1005, 0.10055, 0.1006, 0.10062,
         0.10068, 0.1007, 0.10075, 0.10077, 0.1008, 0.10085, 0.1009, 0.101, 0.10102, 0.10125, 0.10132, 0.10138, 0.1014,
         0.10145, 0.1015, 0.1016, 0.10163, 0.10165, 0.10175, 0.10182, 0.10188, 0.1019, 0.10195, 0.102, 0.10203, 0.10205,
         0.1021, 0.10215, 0.10218, 0.10225, 0.1023, 0.10235, 0.1024, 0.10245, 0.10253, 0.10255, 0.1026, 0.10265, 0.1027,
         0.10278, 0.10288, 0.10295, 0.103, 0.10312, 0.1032, 0.10328, 0.10332, 0.10335, 0.10343000000000001, 0.10345,
         0.10355, 0.1036, 0.10362, 0.1037, 0.1038, 0.10388, 0.104, 0.1041, 0.10422, 0.10428, 0.10443000000000001,
         0.10447, 0.1045, 0.10453, 0.10457, 0.10465, 0.10473, 0.10475, 0.10479999999999999, 0.10490000000000001,
         0.10493000000000001, 0.10495, 0.10503, 0.10515000000000001, 0.10518000000000001, 0.10525, 0.10532, 0.10535,
         0.10543000000000001, 0.1055, 0.10554999999999999, 0.1056, 0.10563, 0.10575, 0.10578, 0.10585, 0.10587, 0.10597,
         0.10603, 0.10607, 0.1061, 0.10623, 0.10626999999999999, 0.10632, 0.10640000000000001, 0.10643000000000001,
         0.10645, 0.10654999999999999, 0.10662, 0.10665000000000001, 0.1067, 0.10675, 0.10679999999999999, 0.10687,
         0.10692, 0.10697, 0.107, 0.10715000000000001, 0.10717, 0.1072, 0.10728, 0.10729999999999999, 0.10732, 0.10735,
         0.10740000000000001, 0.10742, 0.1075, 0.10753, 0.10754999999999999, 0.10758, 0.1076, 0.10762000000000001,
         0.10767, 0.10773, 0.10775, 0.10784999999999999, 0.10787999999999999, 0.10793000000000001, 0.10795, 0.10807,
         0.10822, 0.10828, 0.10842, 0.10845, 0.10851999999999999, 0.10857, 0.10859999999999999, 0.10873000000000001,
         0.10883, 0.10890000000000001, 0.109, 0.10903, 0.10906999999999999, 0.10912000000000001, 0.1092, 0.10925,
         0.10926999999999999, 0.10934999999999999, 0.10937999999999999, 0.10940000000000001, 0.10943000000000001,
         0.10945, 0.10953, 0.10955, 0.10956999999999999, 0.10959999999999999, 0.10962000000000001, 0.10967, 0.1098,
         0.10997, 0.11, 0.1105, 0.111, 0.1115, 0.1125, 0.114, 0.1145, 0.115, 0.1155, 0.117, 0.1175, 0.118, 0.1185,
         0.119, 0.1195, 0.12143300000000001, 0.1215, 0.122, 0.1235, 0.124, 0.1245, 0.125, 0.127, 0.1275, 0.1285, 0.1295,
         0.13, 0.1315, 0.133, 0.1335, 0.1345, 0.136, 0.1365, 0.137, 0.1375, 0.1395, 0.14, 0.1405, 0.1415, 0.142, 0.1425,
         0.143, 0.144, 0.145, 0.1455, 0.146, 0.1465, 0.147, 0.1475, 0.148, 0.1485, 0.1495, 0.15, 0.1505, 0.151, 0.1515,
         0.152, 0.1525, 0.1535, 0.1545, 0.155, 0.1555, 0.156, 0.1565, 0.1575, 0.158, 0.1585, 0.159, 0.16, 0.1625,
         0.1635, 0.1645, 0.1655, 0.1665, 0.167, 0.1675, 0.169, 0.17, 0.1715, 0.172, 0.1725, 0.173, 0.1735, 0.174,
         0.1745, 0.175, 0.176, 0.1765, 0.177, 0.178, 0.1785, 0.179, 0.1795, 0.17999, 0.182901, 0.185859, 0.188866,
         0.19191999999999998, 0.195025, 0.198179, 0.20138399999999998, 0.204641, 0.207951, 0.211315, 0.214733,
         0.21820599999999998, 0.22173500000000002, 0.225322, 0.228966, 0.23266900000000001, 0.23643199999999998,
         0.240257, 0.244143, 0.248091, 0.252104, 0.256182, 0.260325, 0.264536, 0.268814, 0.27316199999999996, 0.27758,
         0.28207, 0.286632, 0.29126799999999997, 0.295979, 0.300767, 0.305631, 0.310575, 0.315598, 0.320702, 0.32589,
         0.331161, 0.336517, 0.34196, 0.347491, 0.353111, 0.35882200000000003, 0.36462599999999995, 0.37052300000000005,
         0.376516, 0.382606, 0.388795, 0.395083, 0.401473, 0.40796699999999997, 0.414565, 0.42127, 0.428084, 0.435008,
         0.442044, 0.44919400000000004, 0.456459, 0.463842, 0.471344, 0.478968, 0.48671499999999995, 0.494587, 0.502587,
         0.510715, 0.518976, 0.52737, 0.5358999999999999, 0.544567, 0.553375, 0.562326, 0.5714210000000001, 0.580663,
         0.590055, 0.599599, 0.609297, 0.619151, 0.629166, 0.639342, 0.649683, 0.6601910000000001, 0.670869, 0.68172,
         0.692746, 0.703951, 0.715336, 0.7269059999999999, 0.738664, 0.750611, 0.762751, 0.775088, 0.787625,
         0.8003640000000001, 0.813309, 0.8264640000000001, 0.839831, 0.8534149999999999, 0.8672179999999999,
         0.8812450000000001, 0.895498, 0.909982, 0.9247000000000001, 0.9396559999999999, 0.954855, 0.970299, 0.985992,
         1.00194, 1.0181499999999999, 1.0346099999999998, 1.05135, 1.06835, 1.08563, 1.1031900000000001, 1.12103,
         1.13917, 1.15759, 1.17631, 1.1953399999999998, 1.2146700000000001, 1.2343199999999999, 1.25428, 1.27457,
         1.29519, 1.31613, 1.33742, 1.3590499999999999, 1.38104, 1.4033699999999998, 1.42607, 1.44914, 1.47258, 1.49639,
         1.5206, 1.54519, 1.5701800000000001, 1.59558, 1.62139, 1.6476099999999998, 1.67426, 1.7013399999999999,
         1.7288599999999998, 1.7568199999999998, 1.78524, 1.81411, 1.815, 1.8388, 1.839, 1.8389000000000002, 1.86,
         1.89008, 1.9206500000000002, 1.9517200000000001, 1.98329, 2.01537, 2.0479600000000002, 2.08109, 2.11475,
         2.1489499999999997, 2.18371, 2.21903, 2.2549200000000003, 2.29139, 2.3284499999999997, 2.36611, 2.40438,
         2.44327, 2.48279, 2.52295, 2.56375, 2.6052199999999996, 2.64736, 2.69018, 2.73369, 2.7779000000000003,
         2.8228299999999997, 2.86849, 2.9148899999999998, 2.9620300000000004, 3.00994, 3.05862, 3.1080900000000002,
         3.1583699999999997, 3.20945, 3.2613600000000003, 3.3141100000000003, 3.36771, 3.42218, 3.4775300000000002,
         3.53378, 3.5909400000000002, 3.64902, 3.70804, 3.7680100000000003, 3.82896, 3.8908899999999997,
         3.9538200000000003, 4.01777, 4.08275, 4.14879, 4.21589, 4.28408, 4.35337, 4.42378, 4.49533, 4.56804, 4.64193,
         4.71701, 4.7933, 4.87083, 4.94961, 5.02967, 5.111020000000001, 5.1936800000000005, 5.27769, 5.36305, 5.44979,
         5.53794, 5.62751, 5.7185299999999994, 5.81102, 5.90501, 6.000520000000001, 6.097569999999999, 6.1962, 6.29642,
         6.349, 6.432, 6.536029999999999, 6.64175, 6.74917, 6.85833, 6.96926, 7.08198, 7.19653, 7.312930000000001,
         7.43121, 7.551399999999999, 7.67354, 7.79765, 7.92377, 8.05194, 8.18217, 8.31451, 8.44899, 8.58564, 8.72451,
         8.865620000000002, 9.00902, 9.154729999999999, 9.3028, 9.45327, 9.60617, 9.76154, 9.91942, 10.0799,
         10.242899999999999, 10.4086, 10.5769, 10.748, 10.9218, 11.0985, 11.278, 11.4604, 11.6458, 11.834100000000001,
         12.0255, 12.22, 12.4177, 12.6185, 12.8226, 13.03, 13.2408, 13.4549, 13.672600000000001, 13.8937, 14.1184,
         14.3468, 14.5788, 14.8146, 15.054200000000002, 15.2977, 15.545200000000001, 15.7966, 16.0521,
         16.311700000000002, 16.5755, 16.8436, 17.1161, 17.3929, 17.6742, 17.960099999999997, 18.2506, 18.5458, 18.8457,
         19.1505, 19.4603, 19.775, 20.094900000000003, 20.419900000000002, 20.7502, 21.0858, 21.4268,
         21.773400000000002, 22.1256, 22.483400000000003, 22.847099999999998, 23.2166, 23.5921, 23.9737, 24.3615,
         24.7555, 25.155900000000003, 25.5628, 25.976200000000002, 26.3964, 26.8233, 27.2572, 27.698, 28.146, 28.6013,
         29.0639, 29.533900000000003, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.8338, 3.80691, 3.78097, 3.75582, 3.73048, 3.7055, 3.68147, 3.65905, 3.63764, 3.61703, 3.59711, 3.57779,
         3.559, 3.54071, 3.52286, 3.50545, 3.48848, 3.472, 3.45628, 3.44176, 3.42689, 3.4105, 3.39378, 3.37667, 3.35917,
         3.3413, 3.32304, 3.3044, 3.28549, 3.26615, 3.24599, 3.22476, 3.20267, 3.17964, 3.15558, 3.13042, 3.10325,
         3.07444, 3.04507, 3.01545, 2.98498, 2.95338, 2.9204, 2.88519, 2.84598, 2.80606, 2.76788, 2.73042, 2.69333,
         2.65696, 2.62418, 2.58874, 2.54971, 2.50917, 2.46935, 2.43129, 2.38275, 2.32504, 2.26322, 2.19828, 2.11635,
         2.01618, 1.9017, 1.77437, 1.64458, 1.50518, 1.34727, 1.17621, 0.995339, 0.794497, 0.568059, 0.306962,
         0.00161588, -0.366911, -0.841388, -1.52605, -2.88115, -3.50392, -3.56793, -3.65086, -3.74861, -3.84977,
         -3.95788, -4.07048, -4.2137, -4.33738, -4.47439, -4.57087, -4.65499, -4.76959, -4.79109, -4.78699, -4.76674,
         -4.73984, -4.72571, -4.69897, -4.67405, -4.6549, -4.60024, -4.60059, -4.62085, -4.6451, -4.70275, -4.73916,
         -4.82406, -4.87754, -4.89461, -4.89177, -4.87133, -4.80557, -4.71048, -4.63514, -4.54337, -4.48607, -4.33702,
         -4.23325, -4.07337, -3.81798, -3.56548, -3.15785, -3.08861, -2.521, -2.30405, -2.08534, -2.00971, -1.8127,
         -1.65152, -1.41105, -1.36359, -1.35292, -1.25455, -1.21389, -1.19458, -1.20985, -1.20581, -1.19801, -1.2271,
         -1.24904, -1.28103, -1.3099, -1.33991, -1.397, -1.42608, -1.46728, -1.50309, -1.52538, -1.50608, -1.48153,
         -1.42009, -1.36279, -1.3182, -1.29202, -1.29963, -1.32951, -1.34633, -1.36198, -1.32264, -1.27117, -1.25882,
         -1.242, -1.23327, -1.26147, -1.32267, -1.36022, -1.37658, -1.4269, -1.48061, -1.50969, -1.5363, -1.56167,
         -1.62193, -1.654, -1.72694, -1.75387, -1.76829, -1.78693, -1.80294, -1.83679, -1.8727, -1.88124, -1.90801,
         -1.98706, -2.00067, -2.00298, -2.0457, -2.11934, -2.13949, -2.17952, -2.21343, -2.23848, -2.28483, -2.32999,
         -2.35832, -2.38578, -2.39089, -2.44861, -2.45326, -2.48245, -2.48052, -2.42689, -2.39972, -2.3824, -2.37398,
         -2.38361, -2.37996, -2.37462, -2.36004, -2.36196, -2.36509, -2.33925, -2.33379, -2.33507, -2.32865, -2.32543,
         -2.311, -2.30275, -2.28031, -2.27262, -2.25035, -2.24976, -2.23267, -2.22431, -2.22372, -2.22218, -2.21789,
         -2.21747, -2.22568, -2.21201, -2.21196, -2.21439, -2.21478, -2.20227, -2.20862, -2.19987, -2.19745, -2.18227,
         -2.193, -2.17068, -2.18424, -2.18294, -2.19199, -2.15772, -2.13084, -2.1124, -2.08897, -2.08958, -2.07611,
         -2.06068, -2.05985, -2.02793, -2.03087, -2.01993, -1.99875, -1.99361, -1.99579, -2.00066, -2.00421, -1.99981,
         -1.98698, -2.00603, -2.0085, -2.01211, -2.02183, -2.01515, -2.04292, -2.03376, -2.03838, -2.03677, -2.03705,
         -2.02773, -2.05572, -2.05841, -2.08477, -2.08318, -2.07105, -2.02987, -1.94845, -1.92517, -1.96395, -1.98987,
         -1.9632, -1.77809, -1.61173, -1.45934, -1.28616, -1.13984, -0.959918, -0.578394, -0.573231, -0.405651,
         -0.0264126, 0.0779155, 0.171345, 0.293945, 0.572464, 0.671836, 0.827038, 0.995074, 1.11832, 1.53131, 2.07611,
         2.28741, 2.61972, 2.84736, 2.87943, 2.87745, 2.85152, 2.83348, 2.84307, 2.88384, 3.0031, 3.03093, 3.03358,
         3.03374, 3.03215, 3.099, 3.16288, 3.22259, 3.28049, 3.34172, 3.41479, 3.48151, 3.56199, 3.68256, 3.70254,
         3.68373, 3.69207, 3.76904, 3.949, 4.15147, 4.47402, 4.52214, 4.47788, 4.41664, 4.38177, 4.35929, 4.3902,
         4.36737, 4.42951, 4.48663, 4.57954, 4.84589, 5.05409, 5.27583, 5.50795, 5.73389, 5.79695, 5.86489, 6.35522,
         6.66644, 7.13398, 7.24279, 7.29281, 7.38343, 7.52303, 7.606, 7.64212, 7.66842, 7.68591, 7.67332, 7.68563,
         7.67511, 7.6974, 7.64095, 7.63925, 7.55398, 7.85149, 7.94847, 8.10574, 8.27005, 8.43202, 8.59128, 8.74251,
         8.88646, 9.0396, 9.19861, 9.36085, 9.53668, 9.72509, 9.90451, 10.0644, 10.2142, 10.3574, 10.4958, 10.6314,
         10.7716, 10.9063, 11.0283, 11.1426, 11.2509, 11.3543, 11.4535, 11.5489, 11.6411, 11.7306, 11.8181, 11.9057,
         11.9918, 12.0733, 12.1486, 12.2203, 12.2889, 12.3551, 12.4191, 12.4812, 12.542, 12.6018, 12.6614, 12.7222,
         12.7889, 12.8576, 12.9142, 12.9608, 13.0027, 13.0407, 13.0753, 13.1069, 13.136, 13.1628, 13.1876, 13.2107,
         13.2322, 13.2527, 13.2727, 13.2933, 13.3117, 13.326, 13.3375, 13.3472, 13.3552, 13.3617, 13.367, 13.3711,
         13.3742, 13.3764, 13.3779, 13.3789, 13.3797, 13.3815, 13.3832, 13.3823, 13.3786, 13.3731, 13.3663, 13.3582,
         13.3491, 13.339, 13.3278, 13.3158, 13.3006, 13.2845, 13.2706, 13.2578, 13.2453, 13.2332, 13.2215, 13.2102,
         13.1996, 13.1912, 13.1807, 13.1685, 13.1555, 13.1418, 13.1278, 13.1136, 13.1001, 13.0874, 13.0717, 13.0542,
         13.0353, 13.0154, 12.9946, 12.9729, 12.9502, 12.9266, 12.902, 12.8761, 12.8487, 12.8192, 12.7911, 12.7632,
         12.735, 12.7063, 12.6771, 12.647, 12.6159, 12.5837, 12.5503, 12.5156, 12.4792, 12.4409, 12.4006, 12.3579,
         12.3125, 12.264, 12.212, 12.1559, 12.095, 12.0284, 11.9546, 11.8721, 11.779, 11.6727, 11.5493, 11.4029,
         11.2243, 10.9982, 10.6935, 10.2377, 9.37942, 9.33435, 2.82013, 2.82204, 7.96957, 9.34866, 10.4859, 11.1017,
         11.5305, 11.8609, 12.1301, 12.3571, 12.5533, 12.7254, 12.8775, 13.0131, 13.135, 13.2452, 13.3453, 13.4369,
         13.5205, 13.5972, 13.6676, 13.7324, 13.7921, 13.8472, 13.8981, 13.9449, 13.9882, 14.0282, 14.0651, 14.0991,
         14.1305, 14.1594, 14.1859, 14.2104, 14.2329, 14.2535, 14.2723, 14.2894, 14.3051, 14.3194, 14.3322, 14.3438,
         14.3542, 14.3635, 14.3718, 14.3791, 14.3855, 14.391, 14.3957, 14.3997, 14.4029, 14.4055, 14.4075, 14.4089,
         14.4097, 14.4101, 14.41, 14.4094, 14.4085, 14.4071, 14.4054, 14.4034, 14.4011, 14.3984, 14.3956, 14.3925,
         14.3891, 14.3856, 14.3818, 14.3779, 14.3739, 14.3697, 14.3654, 14.3609, 14.3564, 14.3517, 14.347, 14.3422,
         14.3374, 14.3325, 14.33, 14.3259, 14.3209, 14.3159, 14.3109, 14.3059, 14.3008, 14.2958, 14.2907, 14.2857,
         14.2806, 14.2756, 14.2706, 14.2657, 14.2607, 14.2558, 14.251, 14.2461, 14.2414, 14.2366, 14.2319, 14.2273,
         14.2227, 14.2181, 14.2136, 14.2091, 14.2047, 14.2004, 14.1961, 14.1919, 14.1877, 14.1836, 14.1795, 14.1756,
         14.1716, 14.1677, 14.1639, 14.1602, 14.1565, 14.1528, 14.1492, 14.1457, 14.1423, 14.1389, 14.1355, 14.1322,
         14.129, 14.1258, 14.1227, 14.1197, 14.1167, 14.1137, 14.1108, 14.108, 14.1052, 14.1025, 14.0998, 14.0972,
         14.0946, 14.0921, 14.0896, 14.0872, 14.0848, 14.0825, 14.0802, 14.078, 14.0758, 14.0736, 14.0715, 14.0695,
         14.0675, 14.0655, 14.0636, 14.0617, 14.0598, 14.058, 14.0562, 14.0545, 14.0528, 14.0511, 14.0495, 14.0479,
         14.0463, 14.0448, 14.0433, 14.0419, 14.0405, 14.0391, 14.0377, 14.0364, 14.0351, 14.0338, 14.0326, 14.0314,
         14.0302, 14.0291, 14.0279, 14.0269],
        [3.94851, 3.95531, 3.96212, 3.96894, 3.97577, 3.98262, 3.98948, 3.99635, 4.00322, 4.01012, 4.01702, 4.02394,
         4.00019, 3.9593, 3.91883, 3.87876, 3.83911, 3.79987, 3.76102, 3.72257, 3.68452, 3.64513, 3.5502, 3.45774,
         3.36769, 3.27998, 3.19455, 3.11136, 3.03032, 2.9514, 2.83114, 2.69869, 2.57244, 2.4521, 2.33738, 2.22803,
         2.1238, 1.97554, 1.76138, 1.57043, 1.40019, 1.2484, 1.11306, 0.992396, 0.862336, 0.753564, 0.698871, 0.648148,
         0.602543, 0.561516, 0.523281, 0.496895, 0.478071, 0.459962, 0.442538, 0.425774, 0.413096, 0.403041, 0.393231,
         0.38366, 0.374321, 0.36521, 0.366288, 0.367374, 0.368463, 0.369555, 0.37065, 0.371749, 0.372851, 0.373956,
         0.375064, 0.376176, 0.378088, 0.381996, 0.385945, 0.389935, 0.393965, 0.398038, 0.402152, 0.406309, 0.410509,
         0.414753, 0.41904, 0.423372, 0.427748, 0.43217, 0.435537, 0.437136, 0.438741, 0.440351, 0.441968, 0.44359,
         0.445218, 0.446852, 0.448493, 0.450139, 0.451198, 0.451979, 0.452762, 0.453547, 0.454332, 0.455119, 0.455908,
         0.456698, 0.458301, 0.461948, 0.465624, 0.469328, 0.473062, 0.476826, 0.48062, 0.484444, 0.494947, 0.506504,
         0.518332, 0.530436, 0.542822, 0.554884, 0.558968, 0.563081, 0.567224, 0.571398, 0.566814, 0.552979, 0.539483,
         0.526316, 0.504782, 0.477417, 0.451535, 0.427364, 0.422623, 0.417936, 0.4133, 0.409326, 0.415946, 0.422674,
         0.42951, 0.436457, 0.444926, 0.456528, 0.468434, 0.48065, 0.495035, 0.517644, 0.522228, 0.517644, 0.517841,
         0.521284, 0.535297, 0.552022, 0.581748, 0.630001, 0.708784, 0.813415, 0.941569, 1.07721, 1.37513, 1.52203,
         1.65993, 1.77995, 1.87968, 1.97448, 2.05815, 2.13311, 2.20171, 2.41667, 2.49729, 2.58505, 2.62089, 2.67241,
         2.73072, 2.9136, 3.01959, 3.39622, 3.52655, 3.64732, 3.86847, 4.10668, 4.23678, 4.36464, 4.49509, 4.75764,
         4.85961, 4.94637, 5.0743, 5.12335, 5.13032, 5.12048, 5.15904, 5.19959, 5.20146, 5.18989, 5.13442, 5.02977,
         4.78618, 4.72648, 4.65861, 4.44125, 4.30165, 4.1862, 4.13288, 4.0885, 3.97606, 3.9301, 3.89784, 3.86731,
         3.80579, 3.78427, 3.76802, 3.74849, 3.74261, 3.76084, 3.79386, 3.87484, 3.89373, 3.90179, 3.88239, 3.83958,
         3.76416, 3.67993, 3.64539, 3.63286, 3.65919, 3.65521, 3.62578, 3.57767, 3.56029, 3.47903, 3.442, 3.37538,
         3.35329, 3.35242, 3.33036, 3.33205, 3.3394, 3.33472, 3.31576, 3.27368, 3.27417, 3.28606, 3.27978, 3.28791,
         3.28885, 3.29751, 3.30856, 3.30556, 3.31109, 3.30176, 3.33116, 3.33359, 3.34991, 3.36298, 3.39504, 3.40977,
         3.43515, 3.47153, 3.47688, 3.52378, 3.56457, 3.60198, 3.64781, 3.66569, 3.77644, 3.79743, 3.88408, 3.91584,
         4.01616, 4.04717, 4.06604, 4.06874, 4.11947, 4.15308, 4.16809, 4.21391, 4.22064, 4.23983, 4.28215, 4.30894,
         4.32546, 4.34622, 4.37918, 4.39528, 4.43789, 4.45074, 4.47446, 4.47193, 4.52075, 4.52195, 4.5356, 4.53468,
         4.54692, 4.54827, 4.55993, 4.56521, 4.58499, 4.60002, 4.60834, 4.62406, 4.6321, 4.62922, 4.64804, 4.66695,
         4.67472, 4.68717, 4.70239, 4.71832, 4.73505, 4.75539, 4.7966, 4.82955, 4.85593, 4.88059, 4.88346, 4.9132,
         4.91793, 4.93016, 4.92866, 4.94162, 4.96783, 4.97239, 4.97267, 4.95935, 4.97576, 4.98276, 4.99897, 4.98829,
         4.99135, 4.98316, 4.99342, 4.98967, 5.00593, 5.0158, 5.03141, 5.02656, 5.04483, 5.03873, 5.05325, 5.08673,
         5.1222, 5.13791, 5.28267, 5.45779, 5.61544, 5.85909, 6.1645, 6.33338, 6.51862, 6.72312, 7.40254, 7.59488,
         7.7718, 7.87553, 8.02234, 8.05843, 8.42371, 8.4366, 8.51447, 8.67192, 8.69958, 8.77704, 8.78726, 9.00076,
         9.04215, 9.19455, 9.33439, 9.43724, 9.68832, 9.80683, 9.78221, 9.60861, 9.24827, 9.17385, 9.11857, 9.03612,
         9.09883, 9.12631, 9.18357, 9.19764, 9.17508, 9.18522, 9.17393, 9.32209, 9.41818, 9.49844, 9.51997, 9.57995,
         9.60862, 9.66258, 9.6735, 9.71113, 9.71835, 9.69979, 9.74096, 9.8471, 10.0037, 10.118, 10.1431, 9.96424,
         9.69132, 9.64167, 9.63644, 9.66128, 9.73288, 9.79855, 9.87036, 9.99628, 9.99841, 10.1071, 10.5019, 10.6336,
         10.7324, 10.7656, 10.8239, 10.78, 10.9015, 10.952, 10.921, 10.7554, 10.5495, 10.5369, 10.4391, 10.4208,
         10.1923, 10.1249, 9.98038, 9.82584, 9.72546, 9.66145, 9.60542, 9.51565, 9.49283, 9.43704, 9.49765, 9.42072,
         9.34442, 9.2664, 9.17918, 9.09278, 9.00719, 8.92241, 8.8501, 8.78533, 8.72104, 8.65722, 8.59386, 8.52313,
         8.41115, 8.30065, 8.19159, 8.08397, 7.97776, 7.87295, 7.76952, 7.65024, 7.53005, 7.41174, 7.29529, 7.18067,
         7.06784, 6.9568, 6.8475, 6.73991, 6.63402, 6.52979, 6.42157, 6.31071, 6.20175, 6.09469, 5.98947, 5.88607,
         5.78445, 5.68459, 5.58645, 5.49, 5.39523, 5.30208, 5.21055, 5.10056, 4.98768, 4.87731, 4.76937, 4.66382,
         4.56061, 4.45967, 4.36098, 4.26447, 4.17009, 4.07781, 3.98756, 3.89931, 3.81302, 3.72727, 3.63809, 3.55105,
         3.46608, 3.38316, 3.30221, 3.2232, 3.14609, 3.07081, 2.99734, 2.92563, 2.85563, 2.7873, 2.72061, 2.65552,
         2.58813, 2.52006, 2.45378, 2.38925, 2.32641, 2.26522, 2.20565, 2.14764, 2.09115, 2.03616, 1.98261, 1.93392,
         1.88812, 1.84339, 1.79973, 1.7571, 1.71548, 1.67484, 1.63517, 1.59508, 1.55256, 1.51118, 1.47089, 1.43168,
         1.39352, 1.35637, 1.32021, 1.28196, 1.24308, 1.20538, 1.16882, 1.13337, 1.09899, 1.06561, 1.03318, 1.00174,
         0.971249, 0.941688, 0.913028, 0.887547, 0.864407, 0.841817, 0.819826, 0.798411, 0.777531, 0.757139, 0.737234,
         0.717856, 0.698989, 0.680609, 0.662552, 0.644954, 0.627806, 0.611117, 0.594814, 0.578892, 0.563357, 0.54824,
         0.533519, 0.518512, 0.503884, 0.489627, 0.475781, 0.462322, 0.44924, 0.436529, 0.42418, 0.412181, 0.399995,
         0.388066, 0.3764, 0.376049, 0.366843, 2.26608, 4.15773, 4.09222, 4.00184, 3.9134, 3.82687, 3.74224, 3.65896,
         3.57698, 3.49664, 3.41523, 3.33521, 3.25641, 3.17868, 3.10245, 3.02741, 2.95359, 2.88121, 2.80993, 2.74011,
         2.67152, 2.60424, 2.53844, 2.47374, 2.41045, 2.34854, 2.28769, 2.22827, 2.17014, 2.1132, 2.05756, 2.00307,
         1.94988, 1.89788, 1.84703, 1.79742, 1.7489, 1.70154, 1.65534, 1.61015, 1.56612, 1.52314, 1.48119, 1.44032,
         1.40039, 1.36149, 1.32359, 1.28658, 1.25056, 1.21543, 1.1812, 1.14788, 1.11537, 1.08375, 1.05295, 1.02294,
         0.993744, 0.965295, 0.937606, 0.910663, 0.884415, 0.858896, 0.834074, 0.809917, 0.786429, 0.763535, 0.741289,
         0.719672, 0.698635, 0.678189, 0.658294, 0.63895, 0.620147, 0.601873, 0.584116, 0.566843, 0.550055, 0.533751,
         0.517913, 0.509889, 0.497536, 0.482727, 0.468336, 0.454339, 0.440746, 0.42755, 0.414725, 0.402271, 0.390179,
         0.378427, 0.36702, 0.355946, 0.345189, 0.334747, 0.324605, 0.314762, 0.305207, 0.295929, 0.286926, 0.278183,
         0.269697, 0.261465, 0.253469, 0.245713, 0.238188, 0.23088, 0.22379, 0.216911, 0.210235, 0.203758, 0.197474,
         0.191376, 0.185461, 0.179721, 0.174154, 0.168752, 0.163513, 0.15843, 0.1535, 0.148717, 0.144079, 0.13958,
         0.135216, 0.130984, 0.126879, 0.122899, 0.119038, 0.115294, 0.111664, 0.108143, 0.10473, 0.101419, 0.0982093,
         0.0950968, 0.092079, 0.089153, 0.086316, 0.0835654, 0.0808987, 0.0783132, 0.0758067, 0.0733767, 0.071021,
         0.0687373, 0.0665234, 0.0643773, 0.062297, 0.0602804, 0.0583256, 0.0564308, 0.0545942, 0.0528124, 0.0510884,
         0.0494193, 0.0478034, 0.046239, 0.0447245, 0.0432583, 0.041839, 0.040465, 0.0391349, 0.0378475, 0.0366013,
         0.035395, 0.0342274, 0.0330973, 0.0320035, 0.0309448, 0.0299202, 0.0289286, 0.027969, 0.0270403, 0.0261415,
         0.0252718, 0.0244301, 0.0236157, 0.0228464]],
    'P':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.1349, 0.1351, 0.136714, 0.13892500000000002, 0.141172,
         0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742,
         0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.1454, 2.1456, 2.15943,
         2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 4.97805, 4.94245, 4.90915, 4.87753, 4.84809, 4.82071, 4.79531, 4.77233, 4.75285, 4.73345, 4.71416,
         4.69575, 4.67746, 4.65958, 4.64218, 4.62528, 4.60889, 4.59301, 4.57763, 4.56276, 4.54841, 4.53459, 4.52133,
         4.50872, 4.49696, 4.48618, 4.47517, 4.46431, 4.45372, 4.44348, 4.43366, 4.42433, 4.41557, 4.40751, 4.40035,
         4.39447, 4.39076, 4.39223, 4.38977, 4.38494, 4.37881, 4.3718, 4.36411, 4.35588, 4.34726, 4.33842, 4.32979,
         4.32275, 4.31322, 4.30156, 4.28832, 4.27373, 4.25786, 4.24072, 4.22231, 4.20263, 4.18164, 4.15933, 4.13568,
         4.11073, 4.08472, 4.05772, 4.02776, 3.99527, 3.96034, 3.92293, 3.88292, 3.84018, 3.79457, 3.7459, 3.69399,
         3.63867, 3.57976, 3.51745, 3.45338, 3.38116, 3.30117, 3.21387, 3.1187, 3.01492, 2.90159, 2.7776, 2.64162,
         2.49249, 2.32708, 2.14049, 1.92932, 1.68884, 1.41189, 1.08814, 0.701791, 0.227104, -0.382396, -1.22512,
         -2.58099, -6.42991, -9.75036, -9.7804, -3.80688, -2.11871, -1.197, -0.541382, -0.0141602, 0.444985, 0.87247,
         1.31326, 1.73013, 2.10106, 2.44414, 2.77746, 3.11313, 3.48135, 3.90962, 4.22455, 4.43798, 4.57084, 4.48835,
         4.43827, 4.56813, 4.81079, 5.17514, 5.79093, 6.36132, 6.81058, 7.18838, 7.5386, 7.89918, 8.2143, 8.48864,
         8.73923, 8.96913, 9.17702, 9.36814, 9.5575, 9.74455, 9.92636, 10.1032, 10.2756, 10.444, 10.6092, 10.7723,
         10.9346, 11.0992, 11.2799, 11.442, 11.5876, 11.7225, 11.8494, 11.9696, 12.084, 12.1932, 12.2978, 12.398,
         12.4944, 12.5873, 12.6769, 12.7636, 12.8477, 12.9295, 13.0092, 13.0874, 13.1645, 13.2415, 13.3212, 13.4025,
         13.4811, 13.5497, 13.612, 13.6701, 13.7248, 13.7766, 13.8263, 13.8765, 13.924, 13.9681, 14.008, 14.0439,
         14.0772, 14.1082, 14.1376, 14.1656, 14.1929, 14.2195, 14.2448, 14.2676, 14.2909, 14.3127, 14.3245, 14.3322,
         14.3394, 14.3476, 14.3561, 14.3652, 14.3764, 14.3889, 14.3997, 14.4026, 14.3978, 14.3872, 14.3787, 14.376,
         14.3752, 14.3721, 14.3676, 14.3622, 14.3564, 14.3508, 14.3448, 14.3367, 14.3271, 14.3164, 14.3048, 14.2922,
         14.279, 14.2654, 14.2514, 14.237, 14.2224, 14.2073, 14.1917, 14.1756, 14.1592, 14.1423, 14.1251, 14.1079,
         14.0905, 14.0724, 14.0535, 14.0341, 14.0142, 13.9939, 13.973, 13.9516, 13.9297, 13.9072, 13.8841, 13.8604,
         13.836, 13.811, 13.7854, 13.7591, 13.7319, 13.7039, 13.6748, 13.6447, 13.6134, 13.5807, 13.5465, 13.5108,
         13.4736, 13.4345, 13.3933, 13.3497, 13.3032, 13.2536, 13.2004, 13.143, 13.0806, 13.0118, 12.9355, 12.8501,
         12.7535, 12.6426, 12.5132, 12.3588, 12.1687, 11.9249, 11.5895, 11.0676, 9.95415, 3.54595, 3.54765, 9.60959,
         11.2187, 11.9423, 12.4219, 12.7826, 13.0719, 13.3127, 13.5186, 13.6976, 13.8553, 13.9957, 14.1216, 14.2352,
         14.3383, 14.4321, 14.5177, 14.5961, 14.6679, 14.734, 14.7947, 14.8506, 14.902, 14.9496, 14.9935, 15.0339,
         15.071, 15.1053, 15.1369, 15.166, 15.1927, 15.2172, 15.2397, 15.2603, 15.2791, 15.2962, 15.3118, 15.3259,
         15.3387, 15.3502, 15.3605, 15.3697, 15.3778, 15.385, 15.3912, 15.3966, 15.4011, 15.4049, 15.408, 15.4105,
         15.4123, 15.4135, 15.4142, 15.4144, 15.4141, 15.4134, 15.4123, 15.4108, 15.409, 15.4068, 15.4043, 15.4016,
         15.3985, 15.3953, 15.3918, 15.3882, 15.3843, 15.3803, 15.3761, 15.3718, 15.3674, 15.3628, 15.3582, 15.3534,
         15.3486, 15.3437, 15.3388, 15.3338, 15.3288, 15.3237, 15.3186, 15.3135, 15.3084, 15.3033, 15.2981, 15.293,
         15.2879, 15.2828, 15.2777, 15.2727, 15.2676, 15.2626, 15.2577, 15.2527, 15.2478, 15.243, 15.2382, 15.2334,
         15.2287, 15.224, 15.2194, 15.2148, 15.2103, 15.2059, 15.2015, 15.1971, 15.1928, 15.1886, 15.1844, 15.1803,
         15.1763, 15.1723, 15.1684, 15.1645, 15.1607, 15.1569, 15.1532, 15.1496, 15.146, 15.1425, 15.1391, 15.1357,
         15.1324, 15.1291, 15.1259, 15.1227, 15.1196, 15.1166, 15.1136, 15.1106, 15.1078, 15.1049, 15.1022, 15.0994,
         15.0968, 15.0942, 15.0916, 15.0891, 15.0866, 15.0842, 15.0818, 15.0795, 15.0772, 15.075, 15.0728, 15.0706,
         15.0685, 15.0665, 15.0645, 15.0625, 15.0606, 15.0587, 15.0568, 15.055, 15.0532, 15.0515, 15.0498, 15.0482,
         15.0465, 15.045, 15.0434, 15.0419, 15.0404, 15.039, 15.0377, 15.0359],
        [8.47738, 8.27092, 8.06949, 7.87297, 7.68123, 7.49416, 7.31165, 7.13359, 6.95985, 6.79035, 6.62498, 6.46364,
         6.30623, 6.14279, 5.96938, 5.80087, 5.63711, 5.47797, 5.32059, 5.10232, 4.893, 4.69227, 4.49977, 4.31517,
         4.13815, 3.96838, 3.80558, 3.64946, 3.49498, 3.33559, 3.18347, 3.03828, 2.89419, 2.69318, 2.50614, 2.31986,
         2.10076, 1.90237, 1.70008, 1.51572, 1.37184, 1.2432, 1.12494, 1.01574, 0.914288, 0.816119, 0.73159, 0.661629,
         0.597179, 0.537266, 0.483365, 0.438116, 0.397524, 0.362656, 0.334441, 0.308421, 0.282182, 0.257009, 0.236594,
         0.222772, 0.209917, 0.20646, 0.203059, 0.204255, 0.209753, 0.215399, 0.221196, 0.229708, 0.238708, 0.248061,
         0.258073, 0.268995, 0.28038, 0.292247, 0.304615, 0.316307, 0.325368, 0.334688, 0.343738, 0.352639, 0.361769,
         0.371136, 0.380746, 0.390605, 0.400718, 0.411094, 0.421739, 0.432658, 0.443861, 0.455354, 0.467145, 0.47924,
         0.49069, 0.501872, 0.513308, 0.525005, 0.536968, 0.549204, 0.561719, 0.574519, 0.58761, 0.601, 0.614695,
         0.628703, 0.639288, 0.644138, 0.649026, 0.65395, 0.658911, 0.663911, 0.668948, 0.674023, 0.679137, 0.68429,
         0.688005, 0.688515, 0.689024, 0.689535, 0.690045, 0.690556, 0.691067, 0.691579, 0.692091, 0.692603, 0.693116,
         0.693629, 0.694143, 0.694657, 0.693818, 0.69206, 0.690306, 0.688558, 0.686813, 0.685073, 0.683337, 0.681605,
         0.679879, 0.678156, 0.676438, 0.674723, 0.673014, 0.669023, 0.661918, 0.654888, 0.647932, 0.641051, 0.634243,
         0.627507, 0.620842, 0.614248, 0.607725, 0.59833, 0.588439, 0.578712, 0.569145, 0.559736, 0.550483, 0.541383,
         0.532433, 0.523631, 0.514975, 0.506462, 0.498089, 0.496701, 7.24821, 7.37624, 7.55281, 7.7336, 7.91872,
         8.10828, 8.30236, 8.5011, 8.7046, 8.80797, 8.91101, 9.01526, 9.12073, 9.22744, 9.33539, 9.32404, 9.22128,
         9.11966, 9.01915, 8.91977, 9.23234, 9.57278, 9.92577, 10.2918, 10.6365, 10.5513, 10.4668, 10.383, 10.2999,
         10.201, 10.061, 9.92281, 9.78655, 9.65218, 9.51964, 9.40594, 9.30022, 9.19568, 9.09233, 8.99012, 8.88907,
         8.78916, 8.69037, 8.5927, 8.49611, 8.40062, 8.29784, 8.16494, 8.03417, 7.9055, 7.77888, 7.65429, 7.53171,
         7.41108, 7.29238, 7.17559, 7.06067, 6.94758, 6.83631, 6.72682, 6.61909, 6.51308, 6.40876, 6.30612, 6.20512,
         6.10575, 6.00635, 5.90391, 5.79178, 5.67735, 5.56536, 5.4555, 5.34777, 5.2421, 5.13855, 5.0363, 4.93239,
         4.8279, 4.72416, 4.62251, 4.5232, 4.4261, 4.33116, 4.23809, 4.14664, 4.05603, 3.96511, 3.87511, 3.7872, 3.693,
         3.59832, 3.51289, 3.43156, 3.35339, 3.27701, 3.20235, 3.12899, 3.05264, 2.97138, 2.88794, 2.80681, 2.73538,
         2.67141, 2.61054, 2.5473, 2.48306, 2.42045, 2.35942, 2.29987, 2.24135, 2.18267, 2.1242, 2.06731, 2.01193,
         1.95803, 1.90579, 1.85517, 1.8061, 1.75835, 1.71185, 1.66658, 1.62225, 1.57906, 1.53698, 1.49604, 1.45621,
         1.41747, 1.37983, 1.34273, 1.30615, 1.27056, 1.23596, 1.20232, 1.16956, 1.1377, 1.10673, 1.07657, 1.04723,
         1.01867, 0.990996, 0.964146, 0.938107, 0.912775, 0.888128, 0.864145, 0.840814, 0.818112, 0.796024, 0.77453,
         0.753673, 0.733458, 0.714144, 0.695386, 0.677114, 0.659332, 0.642015, 0.625148, 0.608723, 0.592732, 0.577164,
         0.561479, 0.546048, 0.530917, 0.5162, 0.501889, 0.487977, 0.474448, 0.461296, 0.448513, 0.436361, 0.423895,
         0.411665, 0.3997, 0.392762, 4.22284, 4.18509, 4.09233, 4.00067, 3.91021, 3.821, 3.73293, 3.64605, 3.56055,
         3.4763, 3.39339, 3.31185, 3.23175, 3.15296, 3.07576, 2.99968, 2.92512, 2.85195, 2.78022, 2.70992, 2.64091,
         2.57341, 2.50731, 2.4427, 2.37924, 2.31715, 2.25649, 2.19715, 2.1391, 2.08237, 2.02691, 1.97273, 1.91981,
         1.86811, 1.81762, 1.76833, 1.72021, 1.67325, 1.62743, 1.58274, 1.53914, 1.49661, 1.45515, 1.41472, 1.37529,
         1.33687, 1.29943, 1.26295, 1.22742, 1.19278, 1.15906, 1.12621, 1.09423, 1.06306, 1.03274, 1.00323, 0.974505,
         0.946528, 0.91931, 0.892828, 0.867047, 0.841986, 0.817583, 0.793881, 0.770795, 0.748323, 0.726532, 0.705292,
         0.68467, 0.664605, 0.645071, 0.626122, 0.60768, 0.589768, 0.572384, 0.555427, 0.539, 0.523022, 0.507494,
         0.492406, 0.47775, 0.463515, 0.449684, 0.436244, 0.423194, 0.410515, 0.398208, 0.386248, 0.374638, 0.363359,
         0.352411, 0.34178, 0.331457, 0.321431, 0.3117, 0.302254, 0.293089, 0.284185, 0.275543, 0.267153, 0.25901,
         0.251106, 0.243435, 0.235989, 0.228764, 0.221751, 0.214946, 0.208342, 0.201934, 0.195715, 0.189681, 0.183827,
         0.178146, 0.172634, 0.167287, 0.162099, 0.157065, 0.152182, 0.147445, 0.142849, 0.138391, 0.134067, 0.129871,
         0.125802, 0.121855, 0.118027, 0.114313, 0.110711, 0.107218, 0.103829, 0.100543, 0.0973559, 0.0942647,
         0.0912668, 0.0883594, 0.0855399, 0.0828055, 0.0801538, 0.0775824, 0.0750886, 0.0726802, 0.0703366, 0.0680665,
         0.0658673, 0.0637371, 0.0616736, 0.059675, 0.0577392, 0.0558643, 0.0540484, 0.0522897, 0.0505865, 0.0489371,
         0.0473398, 0.045793, 0.0442953, 0.042845, 0.0414407, 0.040081, 0.0387645, 0.0374899, 0.0362558, 0.0350612,
         0.0339046, 0.0327849, 0.0317011]],
    'S':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.16240000000000002, 0.1626,
         0.163103, 0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442,
         0.188442, 0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084,
         0.214251, 0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595,
         0.247535, 0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989,
         0.290615, 0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418,
         0.335762, 0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004,
         0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186,
         0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957,
         0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4719, 2.4720999999999997, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 8.51351, 8.44725, 8.29906, 8.13067, 7.9894, 7.85582, 7.72619, 7.60201, 7.48047, 7.36315, 7.25066, 7.14165,
         7.03504, 6.92984, 6.8247, 6.72385, 6.62556, 6.52782, 6.4327, 6.33771, 6.24212, 6.14581, 6.0402, 5.94784,
         5.8605, 5.76832, 5.68774, 5.61473, 5.54671, 5.48225, 5.42013, 5.35746, 5.29561, 5.24242, 5.19491, 5.17182,
         5.14872, 5.12362, 5.10178, 5.07915, 5.05564, 5.03138, 5.01164, 5.00074, 4.99665, 4.9852, 4.96711, 4.95248,
         4.94227, 4.93805, 4.93294, 4.9276, 4.92457, 4.92255, 4.91853, 4.91463, 4.91341, 4.91433, 4.90801, 4.8954,
         4.88296, 4.87191, 4.8632, 4.85318, 4.84143, 4.82715, 4.81086, 4.79301, 4.77379, 4.75353, 4.73147, 4.7084,
         4.68254, 4.65429, 4.62388, 4.5916, 4.55828, 4.52523, 4.4846, 4.43814, 4.38622, 4.32764, 4.26493, 4.19746,
         4.12808, 4.05442, 3.9753, 3.88873, 3.79426, 3.69141, 3.57932, 3.45687, 3.32271, 3.17524, 3.01263, 2.83201,
         2.62925, 2.40036, 2.13977, 1.83971, 1.48907, 1.07131, 0.561128, -0.0843296, -0.950596, -2.24181, -4.70752,
         -13.8158, -13.8089, -8.29501, -3.08659, -1.18127, 0.0371599, 0.947915, 1.68407, 2.30886, 2.86291, 3.35538,
         3.8008, 4.21172, 4.58576, 4.92845, 5.23991, 5.52406, 5.78106, 5.99942, 6.20343, 6.40874, 6.62506, 6.84443,
         7.06465, 7.28532, 7.50644, 7.72837, 7.95161, 8.17701, 8.40565, 8.63866, 8.87785, 9.126, 9.38764, 9.67488,
         10.021, 10.3391, 10.6154, 10.8603, 11.081, 11.2862, 11.4789, 11.661, 11.8338, 11.9985, 12.1563, 12.3078,
         12.4535, 12.5942, 12.7303, 12.8624, 12.991, 13.1167, 13.2401, 13.3622, 13.4848, 13.612, 13.7405, 13.8645,
         13.9737, 14.0737, 14.1672, 14.2557, 14.3401, 14.4212, 14.5032, 14.5811, 14.6535, 14.7197, 14.78, 14.8363,
         14.889, 14.9384, 14.985, 15.029, 15.071, 15.1114, 15.151, 15.1921, 15.233, 15.267, 15.2959, 15.3223, 15.3471,
         15.3706, 15.3933, 15.4167, 15.4403, 15.4617, 15.4755, 15.4819, 15.4824, 15.4865, 15.4999, 15.5163, 15.5262,
         15.5315, 15.5341, 15.5345, 15.5329, 15.5299, 15.526, 15.5214, 15.5161, 15.5103, 15.5041, 15.4971, 15.4888,
         15.4795, 15.4693, 15.4585, 15.447, 15.4349, 15.4223, 15.4093, 15.3959, 15.3823, 15.3682, 15.3534, 15.3378,
         15.3216, 15.3049, 15.2877, 15.2701, 15.252, 15.2335, 15.2145, 15.1952, 15.1755, 15.1553, 15.1347, 15.1138,
         15.0925, 15.0709, 15.0488, 15.0263, 15.0034, 14.9798, 14.9556, 14.9308, 14.9051, 14.879, 14.8524, 14.8254,
         14.7976, 14.769, 14.7396, 14.7091, 14.6776, 14.6452, 14.6112, 14.5753, 14.5373, 14.4969, 14.4539, 14.408,
         14.3589, 14.3061, 14.2488, 14.187, 14.1192, 14.0437, 13.9591, 13.8633, 13.7531, 13.624, 13.4692, 13.2776,
         13.029, 12.682, 12.125, 10.7868, 4.79408, 4.79536, 11.2689, 12.5388, 13.181, 13.6189, 13.9525, 14.2218, 14.447,
         14.6397, 14.8077, 14.9558, 15.0876, 15.206, 15.3126, 15.4092, 15.4972, 15.5775, 15.6508, 15.718, 15.7798,
         15.8366, 15.8888, 15.9368, 15.981, 16.0217, 16.0592, 16.0937, 16.1254, 16.1546, 16.1814, 16.206, 16.2285,
         16.2492, 16.268, 16.2851, 16.3007, 16.3148, 16.3276, 16.3391, 16.3494, 16.3586, 16.3667, 16.3739, 16.3801,
         16.3855, 16.3901, 16.3939, 16.3971, 16.3995, 16.4014, 16.4027, 16.4034, 16.4037, 16.4035, 16.4028, 16.4018,
         16.4004, 16.3986, 16.3965, 16.3941, 16.3914, 16.3885, 16.3854, 16.382, 16.3784, 16.3746, 16.3707, 16.3667,
         16.3625, 16.3581, 16.3537, 16.3491, 16.3445, 16.3398, 16.3351, 16.3302, 16.3254, 16.3205, 16.3155, 16.3105,
         16.3055, 16.3005, 16.2955, 16.2905, 16.2855, 16.2805, 16.2755, 16.2705, 16.2656, 16.2607, 16.2558, 16.2509,
         16.2461, 16.2413, 16.2366, 16.2318, 16.2272, 16.2226, 16.218, 16.2135, 16.209, 16.2046, 16.2002, 16.1959,
         16.1917, 16.1875, 16.1833, 16.1792, 16.1752, 16.1712, 16.1673, 16.1634, 16.1596, 16.1559, 16.1522, 16.1486,
         16.145, 16.1415, 16.1381, 16.1347, 16.1314, 16.1281, 16.1249, 16.1217, 16.1186, 16.1155, 16.1125, 16.1096,
         16.1067, 16.1039, 16.1011, 16.0983, 16.0956, 16.093, 16.0904, 16.0878, 16.0853, 16.0829, 16.0805, 16.0781,
         16.0758, 16.0735, 16.0713, 16.0692, 16.067, 16.0649, 16.0629, 16.0609, 16.0589, 16.057, 16.0552, 16.0533,
         16.0515, 16.0498, 16.0481, 16.0464, 16.0447],
        [4.05213, 4.23511, 4.42637, 4.62625, 4.83517, 5.05351, 5.28172, 5.52024, 5.79892, 6.15554, 6.53409, 6.93593,
         7.22812, 7.48421, 7.74937, 8.02394, 8.1742, 8.32106, 8.47056, 8.62275, 8.77767, 8.93538, 9.09591, 9.21163,
         9.25783, 9.30427, 9.35094, 9.39784, 9.44462, 9.49048, 9.53657, 9.58288, 9.62942, 9.50147, 9.35391, 9.20865,
         9.06563, 8.92484, 8.78624, 8.64978, 8.48051, 8.31413, 8.15102, 7.99112, 7.7537, 7.52228, 7.29778, 7.07996,
         6.86866, 6.66366, 6.46478, 6.27183, 5.98866, 5.71188, 5.4479, 5.19886, 5.01355, 4.83485, 4.66253, 4.40278,
         4.1363, 3.88165, 3.6048, 3.34769, 3.10893, 2.85215, 2.6078, 2.38439, 2.09574, 1.83145, 1.66396, 1.51922,
         1.38707, 1.26987, 1.16348, 1.06627, 0.981115, 0.902758, 0.830572, 0.763654, 0.702128, 0.647333, 0.599198,
         0.554642, 0.514725, 0.478994, 0.445743, 0.418298, 0.393527, 0.380101, 0.378917, 0.377737, 0.384183, 0.401995,
         0.420633, 0.440135, 0.460541, 0.481893, 0.504235, 0.538194, 0.576927, 0.622344, 0.669662, 0.696659, 0.724745,
         0.752298, 0.775832, 0.800102, 0.82636, 0.858063, 0.890982, 0.910304, 0.925492, 0.943357, 0.967418, 0.992091,
         1.01502, 1.03213, 1.04954, 1.06724, 1.07944, 1.09081, 1.1023, 1.11391, 1.11708, 1.11624, 1.11682, 1.12301,
         1.12923, 1.1347, 1.13629, 1.13659, 1.13612, 1.13564, 1.13515, 1.13467, 1.13375, 1.13231, 1.13018, 1.12687,
         1.12357, 1.12027, 1.11697, 1.11367, 1.10632, 1.09492, 1.08385, 1.07289, 1.06302, 1.05583, 1.05069, 1.04662,
         1.04175, 1.03485, 1.02741, 1.01996, 1.01259, 1.00529, 0.998037, 0.990826, 0.98365, 0.976453, 0.968314,
         0.959853, 0.951466, 0.94315, 0.934907, 0.926742, 0.919198, 0.91264, 0.907303, 0.901995, 0.896719, 0.891477,
         0.887668, 10.5007, 10.497, 10.4779, 10.4589, 10.4399, 10.4209, 10.402, 10.3831, 10.3618, 10.3284, 10.2927,
         10.252, 10.1994, 10.1435, 10.0848, 10.0264, 9.96826, 9.91052, 9.90441, 9.90935, 9.92307, 9.93675, 9.9505,
         9.96431, 9.97806, 9.99183, 10.0056, 10.0195, 10.0334, 10.0472, 10.0611, 10.075, 10.0889, 10.1029, 10.0678,
         9.97128, 9.83735, 9.6998, 9.56415, 9.43052, 9.29874, 9.16871, 9.04043, 8.91401, 8.7895, 8.6666, 8.54541,
         8.42596, 8.30812, 8.19192, 8.07738, 7.96445, 7.85308, 7.74329, 7.63506, 7.52476, 7.4082, 7.27689, 7.1415,
         7.00886, 6.8786, 6.75076, 6.62527, 6.50207, 6.37999, 6.25453, 6.12761, 6.00121, 5.87733, 5.75601, 5.63719,
         5.52078, 5.40686, 5.2954, 5.18647, 5.08007, 4.97602, 4.87423, 4.76649, 4.65762, 4.5528, 4.45093, 4.3517,
         4.25473, 4.15991, 4.06689, 3.97208, 3.87388, 3.7745, 3.67766, 3.59184, 3.51441, 3.43951, 3.35698, 3.2702,
         3.18561, 3.10323, 3.02302, 2.945, 2.86954, 2.79646, 2.72524, 2.65581, 2.58813, 2.52161, 2.45613, 2.39175,
         2.32905, 2.26801, 2.2086, 2.1506, 2.0941, 2.03908, 1.98547, 1.93318, 1.88216, 1.83173, 1.78246, 1.73434,
         1.68751, 1.64194, 1.59758, 1.55445, 1.51246, 1.47158, 1.43186, 1.3932, 1.35557, 1.31901, 1.28354, 1.24914,
         1.21564, 1.18306, 1.15136, 1.1205, 1.09046, 1.06119, 1.03274, 1.00515, 0.978445, 0.953045, 0.928391, 0.90438,
         0.880984, 0.858192, 0.835993, 0.814372, 0.793309, 0.772787, 0.75209, 0.731711, 0.711709, 0.692248, 0.673319,
         0.654911, 0.63701, 0.619597, 0.602653, 0.586572, 0.570029, 0.5538, 0.537916, 0.522383, 0.507156, 0.49224,
         0.477643, 0.463355, 0.449353, 0.43564, 0.422216, 0.409077, 0.403647, 4.10969, 4.05625, 3.96452, 3.87387,
         3.78454, 3.69661, 3.60994, 3.52449, 3.44043, 3.3579, 3.27664, 3.19691, 3.11856, 3.04154, 2.9661, 2.89204,
         2.81947, 2.74818, 2.67844, 2.61019, 2.54323, 2.47766, 2.41352, 2.35074, 2.28932, 2.22927, 2.17055, 2.11314,
         2.05704, 2.00221, 1.94865, 1.89634, 1.84526, 1.79538, 1.7467, 1.69919, 1.65283, 1.6076, 1.56348, 1.52046,
         1.47849, 1.43757, 1.39767, 1.3588, 1.3209, 1.28397, 1.248, 1.21295, 1.17879, 1.14554, 1.11313, 1.08161,
         1.05088, 1.02099, 0.991891, 0.963576, 0.935981, 0.909174, 0.883064, 0.857636, 0.832928, 0.808893, 0.785501,
         0.762743, 0.74061, 0.719113, 0.698179, 0.677835, 0.658029, 0.638795, 0.620084, 0.601904, 0.584254, 0.567084,
         0.550385, 0.534162, 0.518394, 0.503077, 0.488186, 0.473719, 0.459664, 0.446005, 0.432739, 0.419853, 0.407331,
         0.395174, 0.383362, 0.37189, 0.360746, 0.349924, 0.339414, 0.329206, 0.319295, 0.30967, 0.300324, 0.291249,
         0.282438, 0.273883, 0.265578, 0.257514, 0.249686, 0.242086, 0.234709, 0.227547, 0.220595, 0.213847, 0.207297,
         0.200939, 0.194769, 0.188779, 0.182966, 0.177324, 0.171849, 0.166535, 0.161378, 0.156373, 0.151516, 0.146803,
         0.142229, 0.137791, 0.133484, 0.129305, 0.12525, 0.121315, 0.117497, 0.113792, 0.110197, 0.106709, 0.103325,
         0.100042, 0.0968557, 0.0937472, 0.0907512, 0.0878477, 0.0850338, 0.082307, 0.0796646, 0.0771043, 0.0746235,
         0.0722196, 0.0698907, 0.0676342, 0.0654482, 0.0633304, 0.0612789, 0.0592915, 0.0573665, 0.0555018, 0.0536957,
         0.0519464, 0.0502521, 0.0486112, 0.047022, 0.0454831, 0.0439928, 0.0425497, 0.0411523]],
    'Cl':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.1999, 0.2001, 0.200932, 0.20418199999999997, 0.207485, 0.21084,
         0.214251, 0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595,
         0.247535, 0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989,
         0.290615, 0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418,
         0.335762, 0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004,
         0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186,
         0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957,
         0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8223000000000003, 2.8225, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 9.94411, 9.99265, 10.0178, 10.0328, 10.0544, 10.1253, 10.1438, 10.0587, 9.92498, 9.76783, 9.59654,
         9.41675, 9.23839, 9.06224, 8.89042, 8.72973, 8.58277, 8.4051, 8.21396, 8.01658, 7.82891, 7.63232, 7.457,
         7.30842, 7.17379, 7.04043, 6.9137, 6.80125, 6.69754, 6.5976, 6.50635, 6.42237, 6.34452, 6.27232, 6.20586,
         6.14666, 6.09073, 6.03667, 5.9852, 5.93669, 5.89126, 5.84909, 5.81041, 5.77576, 5.74638, 5.72492, 5.70206,
         5.68014, 5.66026, 5.64307, 5.6292, 5.61957, 5.616, 5.62469, 5.63561, 5.64002, 5.64157, 5.64279, 5.64451,
         5.6476, 5.6537, 5.66715, 5.67395, 5.67739, 5.67907, 5.67961, 5.67939, 5.67883, 5.67884, 5.67918, 5.67685,
         5.67283, 5.66756, 5.66122, 5.65393, 5.64579, 5.63692, 5.62752, 5.61796, 5.60976, 5.60269, 5.5901, 5.57321,
         5.5534, 5.53084, 5.50558, 5.4776, 5.44686, 5.41327, 5.37671, 5.33706, 5.29416, 5.24787, 5.19815, 5.14586,
         5.08787, 5.02406, 4.95459, 4.87907, 4.79704, 4.70792, 4.61105, 4.50569, 4.39108, 4.26771, 4.13122, 3.97786,
         3.8066, 3.61506, 3.39989, 3.15662, 2.87929, 2.55971, 2.18624, 1.74165, 1.19875, 0.510952, -0.412386, -1.78902,
         -4.44567, -13.8452, -13.868, -7.26444, -2.86107, -1.11739, 0.0542504, 1.01005, 1.91454, 2.65192, 3.26308,
         3.80792, 4.30391, 4.76334, 5.19489, 5.60502, 5.99886, 6.38069, 6.75433, 7.12375, 7.49351, 7.86961, 8.27133,
         8.71665, 9.12886, 9.50259, 9.83486, 10.141, 10.4278, 10.6989, 10.9566, 11.2029, 11.439, 11.6664, 11.886,
         12.0989, 12.3058, 12.5076, 12.705, 12.8993, 13.0917, 13.2836, 13.4771, 13.6767, 13.9158, 14.118, 14.2829,
         14.4382, 14.5896, 14.7332, 14.8698, 14.9953, 15.1105, 15.2189, 15.3204, 15.4155, 15.505, 15.5907, 15.672,
         15.7471, 15.8171, 15.8828, 15.9446, 16.0019, 16.0553, 16.1056, 16.1518, 16.1943, 16.2344, 16.2713, 16.3051,
         16.3366, 16.3654, 16.3919, 16.4165, 16.439, 16.4592, 16.4779, 16.4946, 16.5093, 16.5227, 16.5343, 16.5439,
         16.552, 16.5589, 16.5647, 16.5692, 16.5724, 16.5742, 16.5751, 16.5749, 16.5738, 16.5712, 16.5678, 16.5641,
         16.5598, 16.5543, 16.5478, 16.5414, 16.5342, 16.5257, 16.516, 16.5061, 16.4962, 16.4853, 16.4738, 16.4618,
         16.4493, 16.4365, 16.4234, 16.4098, 16.3958, 16.3812, 16.3662, 16.3511, 16.3357, 16.3197, 16.3032, 16.2863,
         16.2692, 16.2516, 16.2336, 16.2152, 16.1964, 16.1774, 16.1578, 16.1378, 16.1173, 16.096, 16.0743, 16.0526,
         16.0307, 16.0086, 15.9862, 15.9633, 15.9401, 15.9163, 15.8922, 15.8675, 15.842, 15.8156, 15.7883, 15.76,
         15.7307, 15.7004, 15.6688, 15.64, 15.6045, 15.5631, 15.5215, 15.4784, 15.4329, 15.3845, 15.3326, 15.2766,
         15.2157, 15.1491, 15.0756, 14.9936, 14.901, 14.7952, 14.6719, 14.5253, 14.3455, 14.1156, 13.802, 13.3219,
         12.3484, 5.68102, 5.68236, 11.5499, 13.3286, 14.062, 14.5387, 14.894, 15.1772, 15.4119, 15.6117, 15.7849,
         15.9371, 16.0722, 16.193, 16.3018, 16.4002, 16.4896, 16.5711, 16.6454, 16.7135, 16.776, 16.8333, 16.8859,
         16.9343, 16.9789, 17.0199, 17.0575, 17.0922, 17.1241, 17.1534, 17.1802, 17.2048, 17.2274, 17.2481, 17.2669,
         17.284, 17.2996, 17.3137, 17.3264, 17.3378, 17.3481, 17.3572, 17.3653, 17.3724, 17.3786, 17.3839, 17.3884,
         17.3922, 17.3953, 17.3977, 17.3995, 17.4007, 17.4014, 17.4016, 17.4014, 17.4007, 17.3996, 17.3981, 17.3963,
         17.3942, 17.3917, 17.389, 17.3861, 17.3829, 17.3795, 17.3759, 17.3721, 17.3682, 17.3641, 17.3598, 17.3555,
         17.351, 17.3465, 17.3419, 17.3371, 17.3324, 17.3275, 17.3226, 17.3177, 17.3128, 17.3078, 17.3028, 17.2978,
         17.2928, 17.2877, 17.2827, 17.2777, 17.2727, 17.2678, 17.2628, 17.2579, 17.253, 17.2481, 17.2433, 17.2385,
         17.2338, 17.2291, 17.2244, 17.2198, 17.2152, 17.2107, 17.2062, 17.2018, 17.1975, 17.1932, 17.1889, 17.1847,
         17.1806, 17.1765, 17.1724, 17.1685, 17.1646, 17.1607, 17.1569, 17.1532, 17.1495, 17.1458, 17.1423, 17.1388,
         17.1353, 17.1319, 17.1286, 17.1253, 17.1221, 17.1189, 17.1157, 17.1127, 17.1097, 17.1067, 17.1038, 17.1009,
         17.0981, 17.0953, 17.0926, 17.09, 17.0874, 17.0848, 17.0823, 17.0799, 17.0775, 17.0751, 17.0728, 17.0705,
         17.0683, 17.0661, 17.064, 17.0619, 17.0599, 17.0579, 17.0559],
        [1.46938, 1.6922, 1.9488, 2.24432, 2.51303, 2.73153, 2.95549, 3.19416, 3.48881, 3.87618, 4.14416, 4.41407,
         4.70156, 4.91582, 5.13087, 5.35533, 5.57204, 5.78353, 6.00304, 6.2254, 6.42563, 6.63229, 6.84561, 7.06523,
         7.25268, 7.4451, 7.64264, 7.8275, 7.96238, 8.09958, 8.23914, 8.37683, 8.51461, 8.65466, 8.79701, 8.9417,
         9.08877, 9.23827, 9.39023, 9.54467, 9.70167, 9.86124, 9.92421, 9.89076, 9.85742, 9.8242, 9.79108, 9.75807,
         9.72518, 9.6924, 9.65973, 9.62716, 9.57623, 9.33842, 9.10653, 8.88038, 8.65986, 8.44481, 8.13178, 7.76956,
         7.42345, 7.09277, 6.77682, 6.47493, 6.1865, 5.91091, 5.58156, 5.20522, 4.85425, 4.52694, 4.22171, 3.93705,
         3.66007, 3.22012, 2.83305, 2.49251, 2.1929, 1.9293, 1.70061, 1.5012, 1.32517, 1.16979, 1.03262, 0.882572,
         0.7396, 0.619793, 0.530227, 0.460211, 0.406707, 0.403132, 0.39959, 0.394518, 0.388766, 0.403715, 0.419899,
         0.436731, 0.456765, 0.482148, 0.508941, 0.537223, 0.567077, 0.598591, 0.630882, 0.659237, 0.688866, 0.719826,
         0.752177, 0.785984, 0.821309, 0.858222, 0.896794, 0.937099, 0.974146, 1.00751, 1.04202, 1.07771, 1.11463,
         1.15281, 1.19229, 1.23313, 1.27537, 1.29388, 1.31261, 1.3316, 1.35088, 1.37042, 1.39026, 1.41038, 1.42454,
         1.43088, 1.43726, 1.44366, 1.45009, 1.45655, 1.46304, 1.46956, 1.47311, 1.47525, 1.47739, 1.47953, 1.48168,
         1.48383, 1.48598, 1.48814, 1.4903, 1.49246, 1.49462, 1.49039, 1.48328, 1.4762, 1.46915, 1.46214, 1.45516,
         1.44821, 1.4413, 1.43442, 1.42758, 1.42076, 1.41398, 1.40723, 1.40051, 1.39296, 1.3837, 1.37449, 1.36535,
         1.35626, 1.34724, 1.33827, 1.32937, 1.32053, 1.31174, 1.30301, 1.28921, 1.2752, 1.26134, 1.24763, 1.23407,
         1.22066, 1.20741, 1.19429, 1.18132, 1.16849, 1.1558, 1.14325, 1.13083, 1.11855, 1.1064, 1.09822, 10.4682,
         10.5209, 10.7273, 10.9378, 11.1524, 11.3712, 11.495, 11.5179, 11.5409, 11.5639, 11.5868, 11.6099, 11.633,
         11.6563, 11.6795, 11.7027, 11.726, 11.7494, 11.7728, 11.7962, 11.8197, 11.7925, 11.7015, 11.5712, 11.4367,
         11.3038, 11.1726, 11.0428, 10.9145, 10.7877, 10.6624, 10.5385, 10.4162, 10.2952, 10.1756, 10.0574, 9.94051,
         9.82514, 9.71102, 9.59816, 9.48652, 9.37632, 9.24352, 9.06027, 8.88851, 8.72306, 8.5607, 8.39399, 8.22747,
         8.05822, 7.89234, 7.72948, 7.56838, 7.41007, 7.25479, 7.10271, 6.95011, 6.7994, 6.65193, 6.50656, 6.36357,
         6.2227, 6.08451, 5.94889, 5.81481, 5.68384, 5.55569, 5.4292, 5.30562, 5.18474, 5.06583, 4.94954, 4.83576,
         4.72373, 4.61412, 4.50688, 4.40115, 4.2978, 4.19667, 4.09694, 3.99951, 3.90435, 3.81139, 3.72021, 3.63085,
         3.54315, 3.45748, 3.37378, 3.29172, 3.21132, 3.13255, 3.05628, 2.98154, 2.90833, 2.8361, 2.76591, 2.69771,
         2.62978, 2.56347, 2.49876, 2.43663, 2.37544, 2.31518, 2.25657, 2.19941, 2.14367, 2.08937, 2.03624, 1.98418,
         1.93325, 1.88364, 1.83532, 1.78817, 1.742, 1.6967, 1.65259, 1.60964, 1.56781, 1.52683, 1.4869, 1.44802,
         1.41017, 1.37324, 1.33716, 1.30207, 1.26789, 1.23458, 1.20298, 1.17234, 1.14255, 1.11352, 1.08522, 1.05765,
         1.03077, 1.00458, 0.979056, 0.953791, 0.92905, 0.904856, 0.881295, 0.858348, 0.836001, 0.814232, 0.79303,
         0.772376, 0.742744, 0.722827, 0.703634, 0.684894, 0.666586, 0.648702, 0.631215, 0.614141, 0.597456, 0.581146,
         0.5652, 0.549622, 0.534411, 0.519541, 0.505004, 0.490797, 0.476902, 0.463341, 0.450062, 0.437092, 0.424409,
         0.415937, 4.11507, 4.08546, 3.9916, 3.89901, 3.80795, 3.71842, 3.63008, 3.54327, 3.4579, 3.37405, 3.29165,
         3.21065, 3.13124, 3.05337, 2.97701, 2.90215, 2.82872, 2.75678, 2.68634, 2.61735, 2.54981, 2.48372, 2.41907,
         2.3558, 2.29396, 2.23348, 2.1744, 2.11664, 2.0602, 2.00508, 1.95125, 1.89871, 1.84738, 1.79729, 1.7484,
         1.70074, 1.65419, 1.60881, 1.56455, 1.52142, 1.47931, 1.43831, 1.39832, 1.35936, 1.32139, 1.28442, 1.24835,
         1.21326, 1.17905, 1.14578, 1.11333, 1.08177, 1.05104, 1.02114, 0.99199, 0.963658, 0.936072, 0.909242, 0.883124,
         0.857693, 0.832967, 0.808936, 0.785542, 0.762805, 0.740674, 0.719133, 0.698207, 0.677863, 0.658099, 0.638867,
         0.620175, 0.601998, 0.584334, 0.567166, 0.55047, 0.534254, 0.518495, 0.503175, 0.488293, 0.473831, 0.459779,
         0.446128, 0.432865, 0.419979, 0.407462, 0.395303, 0.383492, 0.37202, 0.360877, 0.350055, 0.339544, 0.329336,
         0.319422, 0.309795, 0.300447, 0.291369, 0.282554, 0.273995, 0.265684, 0.257615, 0.24978, 0.242174, 0.23479,
         0.22762, 0.22066, 0.213904, 0.207345, 0.200977, 0.194796, 0.188797, 0.182973, 0.17732, 0.171833, 0.166507,
         0.161337, 0.15632, 0.15145, 0.146723, 0.142136, 0.137683, 0.133362, 0.129168, 0.125098, 0.121156, 0.117324,
         0.113609, 0.110007, 0.106515, 0.103129, 0.0998466, 0.0966649, 0.0935805, 0.0905909, 0.087693, 0.0848845,
         0.0821624, 0.0795244, 0.0769679, 0.0744905, 0.07209, 0.0697638, 0.06751, 0.0653262, 0.0632106, 0.0611608,
         0.0591751, 0.0572516, 0.0553882, 0.0535833]],
    'Ar':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0157, 0.0159, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988,
         0.0193061, 0.0196184, 0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003,
         0.0283747, 0.0288337, 0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002,
         0.0317475, 0.0322609, 0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211,
         0.0360956, 0.0366794, 0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994,
         0.0417031, 0.0423776, 0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004,
         0.04665999999999999, 0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576,
         0.051375300000000006, 0.0522062, 0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482,
         0.058411700000000004, 0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908,
         0.0643145, 0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138,
         0.07195910000000001, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.24830000000000002, 0.2485, 0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957,
         0.281437, 0.285989, 0.290615, 0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983,
         0.325158, 0.330418, 0.335762, 0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748,
         0.38792200000000004, 0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124,
         0.434032, 0.441052, 0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894,
         0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065,
         0.5701390000000001, 0.579361, 0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755,
         0.637908, 0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008,
         0.748928, 0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502,
         0.865274, 0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586,
         1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155,
         1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.2058, 3.206, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, 7.16821, 7.66932, 8.2734, 8.81707, 9.21762, 9.58113, 9.92024, 10.2556, 10.6109, 10.9293,
         11.1937, 11.4568, 11.751, 12.2163, 12.5658, 12.6642, 12.804, 12.8512, 12.6252, 12.2858, 11.906, 11.5048,
         11.1027, 10.6932, 10.309, 9.95151, 9.59508, 9.27243, 8.98249, 8.7143, 8.48849, 8.28327, 8.09455, 7.92147,
         7.75016, 7.58985, 7.44897, 7.31746, 7.19018, 7.06923, 6.95878, 6.85645, 6.76046, 6.66879, 6.58314, 6.50575,
         6.43529, 6.37198, 6.31643, 6.2718, 6.23924, 6.20776, 6.17389, 6.14316, 6.11609, 6.09323, 6.08226, 6.07497,
         6.0624, 6.05142, 6.04256, 6.03653, 6.03851, 6.0456, 6.04912, 6.04944, 6.04895, 6.04836, 6.04807, 6.04839,
         6.04957, 6.05193, 6.05584, 6.06176, 6.07318, 6.08987, 6.10379, 6.11193, 6.11769, 6.12192, 6.12506, 6.12741,
         6.12922, 6.13075, 6.13235, 6.13454, 6.13837, 6.148, 6.16044, 6.16324, 6.1571, 6.14634, 6.13128, 6.11218,
         6.08908, 6.06191, 6.02858, 5.99005, 5.95064, 5.91085, 5.86902, 5.82462, 5.77726, 5.72664, 5.67245, 5.6144,
         5.55217, 5.48546, 5.41393, 5.33729, 5.25537, 5.1688, 5.07676, 4.974, 4.85905, 4.73316, 4.59581, 4.44851, 4.286,
         4.09797, 3.88473, 3.64426, 3.37229, 3.0629, 2.70742, 2.29824, 1.82289, 1.25779, 0.569782, -0.296219, -1.44089,
         -3.08671, -5.87741, -14.4571, -25.6896, -25.6342, -7.08366, -2.40344, 0.166927, 1.91869, 3.24484, 4.33175,
         5.26029, 6.03813, 6.64307, 7.11879, 7.33982, 7.50143, 7.86258, 8.23435, 8.62413, 9.0301, 9.45508, 9.90596,
         10.4258, 11.0469, 11.641, 12.0564, 12.3689, 12.6364, 12.914, 13.1707, 13.4117, 13.6365, 13.8435, 14.0357,
         14.2135, 14.3773, 14.5262, 14.655, 14.7656, 14.8826, 15.0071, 15.1301, 15.2514, 15.3706, 15.4874, 15.602,
         15.7147, 15.8258, 15.9359, 16.0459, 16.1633, 16.2826, 16.3899, 16.4946, 16.5968, 16.6841, 16.7596, 16.8307,
         16.8983, 16.963, 17.0256, 17.0871, 17.1496, 17.2072, 17.253, 17.2871, 17.3113, 17.3398, 17.38, 17.4241,
         17.4608, 17.493, 17.5228, 17.5514, 17.5813, 17.6101, 17.6318, 17.6481, 17.6607, 17.67, 17.6761, 17.6804,
         17.6839, 17.6866, 17.6884, 17.6898, 17.6906, 17.6894, 17.6866, 17.6823, 17.6768, 17.6705, 17.6641, 17.6578,
         17.6497, 17.64, 17.6292, 17.6175, 17.605, 17.5919, 17.5781, 17.5637, 17.5491, 17.5341, 17.5191, 17.5035,
         17.4869, 17.4695, 17.4513, 17.4325, 17.4131, 17.3932, 17.3728, 17.3518, 17.3298, 17.3071, 17.2841, 17.262,
         17.2402, 17.2184, 17.1965, 17.1745, 17.1524, 17.1301, 17.1078, 17.0853, 17.0622, 17.0386, 17.0145, 16.9898,
         16.9646, 16.9389, 16.9126, 16.8855, 16.8579, 16.8299, 16.8006, 16.7703, 16.7389, 16.7062, 16.6721, 16.6364,
         16.599, 16.5597, 16.5182, 16.4743, 16.4275, 16.3775, 16.3237, 16.2657, 16.2025, 16.1334, 16.057, 15.9718,
         15.8756, 15.7656, 15.6374, 15.4846, 15.2971, 15.0567, 14.7273, 14.2181, 13.1521, 6.24201, 6.24309, 12.6536,
         14.3229, 15.0526, 15.5322, 15.8911, 16.1776, 16.4157, 16.6183, 16.7938, 16.948, 17.0849, 17.2072, 17.3173,
         17.4169, 17.5072, 17.5894, 17.6644, 17.733, 17.7959, 17.8535, 17.9064, 17.955, 17.9997, 18.0407, 18.0784,
         18.1131, 18.1449, 18.1741, 18.2008, 18.2253, 18.2476, 18.2681, 18.2866, 18.3035, 18.3189, 18.3327, 18.3451,
         18.3563, 18.3663, 18.3751, 18.3829, 18.3897, 18.3955, 18.4005, 18.4047, 18.4082, 18.411, 18.413, 18.4145,
         18.4155, 18.4158, 18.4158, 18.4152, 18.4142, 18.4128, 18.411, 18.4089, 18.4065, 18.4037, 18.4007, 18.3975,
         18.3941, 18.3904, 18.3865, 18.3825, 18.3783, 18.3739, 18.3695, 18.3649, 18.3602, 18.3554, 18.3505, 18.3456,
         18.3406, 18.3355, 18.3304, 18.3253, 18.3201, 18.3149, 18.3097, 18.3045, 18.2993, 18.2941, 18.2889, 18.2837,
         18.2786, 18.2734, 18.2683, 18.2632, 18.2581, 18.2531, 18.2481, 18.2432, 18.2382, 18.2334, 18.2286, 18.2238,
         18.2191, 18.2144, 18.2098, 18.2053, 18.2007, 18.1963, 18.1919, 18.1876, 18.1833, 18.1791, 18.1749, 18.1708,
         18.1668, 18.1628, 18.1589, 18.155, 18.1512, 18.1474, 18.1437, 18.1401, 18.1365, 18.133, 18.1295, 18.1261,
         18.1227, 18.1194, 18.1162, 18.113, 18.1099, 18.1068, 18.1038, 18.1008, 18.0979, 18.0951, 18.0923, 18.0895,
         18.0868, 18.0842, 18.0816, 18.0791, 18.0766, 18.0742, 18.0718],
        [9.49375e-16, 9.64731e-16, 9.80335e-16, 9.96191e-16, 1.0123e-15, 1.02868e-15, 1.04531e-15, 1.06222e-15,
         1.0794e-15, 1.09686e-15, 1.1146e-15, 1.13263e-15, 1.15095e-15, 1.16956e-15, 1.18848e-15, 1.2077e-15,
         1.22724e-15, 1.24709e-15, 1.26726e-15, 1.28776e-15, 1.30858e-15, 1.32975e-15, 1.35126e-15, 1.37311e-15,
         1.39532e-15, 1.41789e-15, 1.44082e-15, 1.46413e-15, 1.48781e-15, 1.49052e-15, 7.3778, 7.40169, 7.65097,
         7.90865, 8.175, 8.45033, 8.71866, 8.99489, 9.27988, 9.5739, 9.87722, 10.0769, 10.2212, 10.3675, 10.5159,
         10.6665, 10.8167, 10.9668, 11.1189, 11.2731, 11.4295, 11.588, 11.7097, 11.8098, 11.9107, 12.0125, 12.1152,
         12.2187, 12.3231, 12.4285, 12.5068, 12.5003, 12.4939, 12.4875, 12.4811, 12.4746, 12.4276, 12.2749, 12.1241,
         11.9752, 11.828, 11.6127, 11.2069, 10.8152, 10.4373, 10.0726, 9.72056, 9.33987, 8.90509, 8.49054, 8.09529,
         7.71845, 7.34539, 6.53408, 5.81238, 5.17039, 4.33445, 3.54127, 2.89324, 2.36379, 1.93122, 1.57782, 1.29078,
         1.08938, 0.919409, 0.791494, 0.726839, 0.667465, 0.649193, 0.640955, 0.632821, 0.631336, 0.630701, 0.63024,
         0.648426, 0.667137, 0.686388, 0.706194, 0.733531, 0.765241, 0.798322, 0.832833, 0.868956, 0.911925, 0.95702,
         1.00435, 1.05401, 1.10613, 1.16083, 1.20753, 1.2456, 1.28488, 1.32538, 1.36717, 1.41027, 1.45474, 1.4859,
         1.51689, 1.54853, 1.58083, 1.61381, 1.64747, 1.6729, 1.69023, 1.70773, 1.72541, 1.74328, 1.76133, 1.77957,
         1.798, 1.81661, 1.83542, 1.85443, 1.87363, 1.88746, 1.88943, 1.89139, 1.89336, 1.89533, 1.8973, 1.89927,
         1.90125, 1.90322, 1.9052, 1.90718, 1.90917, 1.91115, 1.89697, 1.87609, 1.85544, 1.83502, 1.81482, 1.79485,
         1.77509, 1.75556, 1.73624, 1.72085, 1.71079, 1.70079, 1.69085, 1.68096, 1.67114, 1.66137, 1.65166, 1.642,
         1.6324, 1.62286, 1.61338, 1.60394, 1.59457, 1.58525, 1.57121, 1.55385, 1.53667, 1.51969, 1.50289, 1.48628,
         1.45771, 1.42787, 1.39864, 1.37, 1.34195, 1.31448, 1.28885, 1.26755, 1.2466, 1.226, 1.20574, 1.18581, 1.16544,
         1.14206, 1.11916, 1.09671, 1.09244, 17.629, 17.2582, 16.7805, 16.3161, 15.8748, 15.5141, 15.1615, 14.816,
         14.4164, 14.0275, 13.6491, 13.2901, 13.3049, 13.3197, 13.3345, 13.3493, 13.3642, 13.379, 13.3939, 13.4088,
         13.3775, 13.0326, 12.6966, 12.376, 12.1308, 11.8904, 11.6549, 11.4239, 11.1939, 10.9685, 10.7477, 10.5313,
         10.3192, 10.1114, 9.90786, 9.73331, 9.57749, 9.42417, 9.2733, 9.12484, 8.97876, 8.83502, 8.69358, 8.5544,
         8.41746, 8.28271, 8.15012, 8.01964, 7.87579, 7.72696, 7.58076, 7.42279, 7.26194, 7.10867, 6.96006, 6.81547,
         6.67401, 6.53542, 6.3992, 6.26039, 6.11657, 5.97087, 5.8285, 5.70225, 5.58839, 5.4789, 5.36137, 5.23948,
         5.12039, 5.00401, 4.8901, 4.77704, 4.66057, 4.54207, 4.42661, 4.31405, 4.20431, 4.09843, 3.99624, 3.89751,
         3.80119, 3.70726, 3.61567, 3.52431, 3.43478, 3.34712, 3.26168, 3.17849, 3.0975, 3.01914, 2.94133, 2.86399,
         2.78871, 2.71542, 2.64404, 2.57458, 2.50691, 2.44096, 2.37684, 2.31438, 2.25354, 2.19371, 2.13496, 2.07717,
         2.02085, 1.96606, 1.91276, 1.86093, 1.81053, 1.76153, 1.71377, 1.66758, 1.62309, 1.58151, 1.54126, 1.50205,
         1.46378, 1.42649, 1.39017, 1.35477, 1.32027, 1.28665, 1.25347, 1.22101, 1.18927, 1.15836, 1.12826, 1.09895,
         1.07039, 1.04257, 1.01548, 0.989487, 0.96346, 0.938054, 0.913249, 0.889031, 0.865379, 0.842275, 0.819728,
         0.797721, 0.77621, 0.755213, 0.734715, 0.714694, 0.695152, 0.67605, 0.657392, 0.639191, 0.621397, 0.604026,
         0.587067, 0.570498, 0.554313, 0.538497, 0.523033, 0.507955, 0.493219, 0.478818, 0.464732, 0.450984, 0.442589,
         4.24427, 4.20735, 4.10923, 4.01218, 3.91705, 3.82343, 3.73159, 3.6411, 3.55206, 3.46483, 3.37927, 3.29525,
         3.21288, 3.13212, 3.05299, 2.97543, 2.89946, 2.82509, 2.7523, 2.68108, 2.61138, 2.54318, 2.47653, 2.41134,
         2.34763, 2.28537, 2.22455, 2.16515, 2.10711, 2.05046, 1.99516, 1.94116, 1.88845, 1.83704, 1.7869, 1.738,
         1.69026, 1.64375, 1.59839, 1.55414, 1.51105, 1.46904, 1.42808, 1.3882, 1.34935, 1.31151, 1.27461, 1.23868,
         1.2037, 1.16969, 1.13651, 1.10426, 1.07281, 1.04224, 1.01248, 0.98354, 0.955338, 0.92789, 0.901226, 0.87528,
         0.850058, 0.825508, 0.801583, 0.77835, 0.755755, 0.733792, 0.712424, 0.691653, 0.671457, 0.651829, 0.632741,
         0.614198, 0.596163, 0.578635, 0.561599, 0.545041, 0.52895, 0.513313, 0.498118, 0.483353, 0.469007, 0.455068,
         0.441525, 0.428368, 0.415586, 0.403169, 0.391107, 0.37939, 0.368008, 0.356953, 0.346216, 0.335787, 0.325658,
         0.31582, 0.306267, 0.296989, 0.287979, 0.279229, 0.270732, 0.262482, 0.25447, 0.246691, 0.239137, 0.231803,
         0.224681, 0.217767, 0.211054, 0.204536, 0.198208, 0.192065, 0.1861, 0.18031, 0.174688, 0.169231, 0.163932,
         0.158795, 0.153805, 0.148966, 0.144273, 0.139723, 0.135309, 0.131031, 0.126882, 0.122859, 0.118959, 0.115178,
         0.111513, 0.10796, 0.104516, 0.101178, 0.0979421, 0.0948062, 0.0917669, 0.0888216, 0.0859672, 0.0832013,
         0.0805211, 0.0779241, 0.0754079, 0.0729699, 0.070608]],
    'K':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.2945, 0.29469999999999996, 0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983,
         0.325158, 0.330418, 0.335762, 0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748,
         0.38792200000000004, 0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124,
         0.434032, 0.441052, 0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894,
         0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065,
         0.5701390000000001, 0.579361, 0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755,
         0.637908, 0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008,
         0.748928, 0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502,
         0.865274, 0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586,
         1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155,
         1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.6083000000000003, 3.6085, 3.66682, 3.72613,
         3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 2.17828, 2.89939, 3.60817, 4.33571, 5.11707, 6.03373, 6.83119, 7.59044, 8.35387, 9.18461, 10.1988,
         11.1641, 11.9451, 12.6035, 13.1354, 13.6803, 14.0504, 14.2223, 14.2816, 14.2982, 14.3079, 14.2245, 14.0687,
         13.8619, 13.6892, 13.5444, 13.4567, 13.3321, 13.2702, 12.9741, 12.6173, 12.2824, 11.9613, 11.6417, 11.3082,
         10.9768, 10.6439, 10.3154, 10.0364, 9.78031, 9.52988, 9.30251, 9.08725, 8.88646, 8.70392, 8.53101, 8.36576,
         8.21156, 8.0711, 7.95287, 7.85046, 7.75086, 7.65588, 7.56768, 7.49048, 7.42753, 7.37201, 7.32952, 7.29481,
         7.26818, 7.25548, 7.23965, 7.22539, 7.21927, 7.21605, 7.21683, 7.22962, 7.23996, 7.24975, 7.26385, 7.28835,
         7.32647, 7.34617, 7.35113, 7.35863, 7.36896, 7.38203, 7.40104, 7.42005, 7.43219, 7.44, 7.44795, 7.45588,
         7.4635, 7.47092, 7.47826, 7.48564, 7.49328, 7.50143, 7.51077, 7.52417, 7.53841, 7.54694, 7.55225, 7.55533,
         7.55656, 7.55614, 7.55417, 7.55074, 7.54589, 7.53966, 7.53209, 7.52324, 7.51323, 7.50233, 7.49164, 7.48139,
         7.46576, 7.44542, 7.42167, 7.3946, 7.36422, 7.33048, 7.29328, 7.2525, 7.20801, 7.15973, 7.10773, 7.05416,
         6.99268, 6.92322, 6.84662, 6.76249, 6.67029, 6.56932, 6.45876, 6.33761, 6.20474, 6.05931, 5.899, 5.71985,
         5.51965, 5.29526, 5.04239, 4.75543, 4.42684, 4.0463, 3.59913, 3.06355, 2.40521, 1.56542, 0.431087, -1.26306,
         -4.44727, -20.3956, -20.3757, -11.6988, -2.52151, 0.43101, 2.28661, 3.65714, 4.77056, 5.67861, 6.3833, 6.97894,
         7.55127, 8.09103, 8.59859, 9.07834, 9.53481, 9.97229, 10.395, 10.8073, 11.2153, 11.6332, 12.0738, 12.4681,
         12.8177, 13.1462, 13.4581, 13.7573, 14.0477, 14.3341, 14.645, 14.9211, 15.1597, 15.3801, 15.585, 15.7769,
         15.9574, 16.128, 16.2904, 16.4479, 16.5981, 16.7364, 16.8636, 16.9827, 17.0945, 17.1996, 17.2986, 17.3921,
         17.4804, 17.5642, 17.6437, 17.7194, 17.7918, 17.8615, 17.9291, 17.9954, 18.0704, 18.141, 18.1966, 18.2431,
         18.283, 18.3173, 18.3467, 18.3715, 18.3921, 18.4085, 18.4208, 18.4287, 18.4316, 18.4291, 18.4042, 18.3888,
         18.3893, 18.3943, 18.4029, 18.4148, 18.43, 18.4482, 18.4883, 18.514, 18.5248, 18.5338, 18.5404, 18.545,
         18.5478, 18.5491, 18.5492, 18.5481, 18.5462, 18.5434, 18.5401, 18.5365, 18.5339, 18.5294, 18.5225, 18.5143,
         18.505, 18.4949, 18.484, 18.4724, 18.4602, 18.4473, 18.434, 18.4201, 18.4059, 18.3912, 18.3761, 18.3607,
         18.345, 18.3291, 18.313, 18.297, 18.2816, 18.2652, 18.2472, 18.2285, 18.2091, 18.1892, 18.1687, 18.1476,
         18.126, 18.1039, 18.0813, 18.0581, 18.0344, 18.0101, 17.9852, 17.9596, 17.9335, 17.9066, 17.8791, 17.851,
         17.8216, 17.791, 17.7592, 17.726, 17.6915, 17.6553, 17.6175, 17.5778, 17.5359, 17.4916, 17.4445, 17.3944,
         17.3406, 17.2827, 17.2199, 17.1511, 17.0755, 16.9919, 16.8983, 16.7918, 16.6688, 16.5236, 16.3475, 16.1255,
         15.8296, 15.3954, 14.6156, 6.76821, 6.76945, 14.8853, 15.8359, 16.4059, 16.8151, 17.1335, 17.3929, 17.6105,
         17.7967, 17.9585, 18.1006, 18.2265, 18.3388, 18.4395, 18.5302, 18.6121, 18.6865, 18.7541, 18.8156, 18.8717,
         18.923, 18.9699, 19.0128, 19.0521, 19.0881, 19.1212, 19.1516, 19.1793, 19.2046, 19.2275, 19.2485, 19.2675,
         19.2848, 19.3006, 19.3148, 19.3277, 19.3393, 19.3498, 19.3593, 19.3677, 19.3753, 19.3821, 19.3881, 19.3936,
         19.3987, 19.4041, 19.4094, 19.4131, 19.415, 19.4159, 19.4158, 19.4151, 19.4136, 19.4115, 19.4087, 19.4052,
         19.401, 19.3966, 19.3921, 19.3872, 19.3818, 19.3746, 19.3633, 19.3598, 19.3678, 19.3646, 19.3619, 19.3588,
         19.3553, 19.3515, 19.3475, 19.3432, 19.3389, 19.3344, 19.3298, 19.3251, 19.3203, 19.3154, 19.3106, 19.3056,
         19.3007, 19.2957, 19.2907, 19.2857, 19.2807, 19.2756, 19.2706, 19.2657, 19.2607, 19.2557, 19.2508, 19.2459,
         19.2411, 19.2362, 19.2314, 19.2267, 19.222, 19.2173, 19.2127, 19.2081, 19.2036, 19.1991, 19.1947, 19.1903,
         19.186, 19.1817, 19.1775, 19.1733, 19.1692, 19.1652, 19.1611, 19.1572, 19.1533, 19.1494, 19.1457, 19.1419,
         19.1382, 19.1346, 19.1311, 19.1276, 19.1241, 19.1208, 19.1174, 19.1142, 19.1109, 19.1078, 19.1047, 19.1017,
         19.0987, 19.0957, 19.0929, 19.09, 19.0873],
        [0.0342643, 0.0352921, 0.0363507, 0.037441, 0.0385641, 0.0397209, 0.0409123, 0.0421395, 0.0434035, 0.0447054,
         0.0458918, 0.0467761, 0.0476775, 0.0485962, 0.0495326, 0.0505034, 0.0515183, 0.0525536, 0.0536097, 0.0547076,
         0.055861, 0.0570387, 0.0582413, 0.0594692, 0.0608386, 0.0623585, 0.0639162, 0.0655129, 0.0667297, 0.0698655,
         0.0778034, 0.0927407, 0.101038, 0.100077, 0.0991247, 0.097203, 0.101597, 0.125934, 0.169815, 0.232685,
         0.316999, 0.445772, 0.695715, 1.36743, 4.67523, 5.53876, 6.01936, 6.54165, 7.10926, 7.72612, 8.21083, 8.6597,
         9.13312, 9.63242, 10.159, 10.7136, 11.2607, 11.8358, 12.4402, 13.0756, 13.6526, 13.9461, 14.2459, 14.5521,
         14.8649, 15.1844, 15.4706, 15.5477, 15.6251, 15.7029, 15.7812, 15.8598, 15.8136, 15.6376, 15.4635, 15.2914,
         15.1212, 14.9437, 14.2499, 13.5883, 12.7896, 12.0324, 11.2669, 10.2831, 9.38513, 8.58297, 7.85498, 7.15591,
         6.45992, 5.83162, 5.3053, 4.85617, 4.44507, 4.02366, 3.58281, 3.08053, 2.51309, 2.14018, 1.81928, 1.5449,
         1.2883, 1.07234, 0.896454, 0.757394, 0.680178, 0.632986, 0.595014, 0.567394, 0.563239, 0.559115, 0.580718,
         0.603395, 0.63256, 0.665632, 0.717531, 0.775782, 0.845525, 0.900273, 0.956547, 1.01634, 1.08251, 1.15442,
         1.22789, 1.30013, 1.37551, 1.44167, 1.511, 1.5708, 1.62391, 1.67882, 1.73393, 1.78266, 1.83276, 1.87923,
         1.91557, 1.95261, 1.99038, 2.02887, 2.04612, 2.04724, 2.05287, 2.06874, 2.08473, 2.10085, 2.11708, 2.11875,
         2.11934, 2.12303, 2.12778, 2.13254, 2.13731, 2.1421, 2.14689, 2.15169, 2.15651, 2.16134, 2.16617, 2.17102,
         2.16638, 2.15912, 2.15189, 2.14468, 2.1375, 2.13034, 2.12321, 2.1161, 2.10901, 2.10195, 2.09491, 2.08789,
         2.0809, 2.07393, 2.06698, 2.05512, 2.04042, 2.02582, 2.01133, 1.99694, 1.98265, 1.96847, 1.95439, 1.9404,
         1.92652, 1.91274, 1.89906, 1.8835, 1.86442, 1.84554, 1.82685, 1.80835, 1.79004, 1.77191, 1.75396, 1.7362,
         1.71862, 1.70121, 1.6821, 1.66224, 1.64263, 1.62324, 1.60408, 1.58514, 1.56643, 1.54794, 1.52967, 1.51162,
         1.49378, 1.47615, 1.45872, 1.44151, 1.42449, 1.41056, 15.1908, 15.1664, 14.9798, 14.7956, 14.6136, 14.4338,
         14.2533, 14.0256, 13.8016, 13.6815, 13.5912, 13.5014, 13.4122, 13.3237, 13.2357, 13.1483, 13.0614, 12.9752,
         12.8895, 12.8044, 12.668, 12.4871, 12.3088, 12.1331, 11.9598, 11.7891, 11.6208, 11.4549, 11.2717, 11.0479,
         10.8286, 10.6137, 10.403, 10.1965, 9.99408, 9.79571, 9.60126, 9.41067, 9.21457, 9.01953, 8.82863, 8.64175,
         8.45884, 8.27979, 8.10455, 7.93301, 7.76509, 7.60074, 7.43986, 7.28238, 7.12825, 6.97737, 6.82968, 6.68513,
         6.54362, 6.38391, 6.22354, 6.06719, 5.91477, 5.76619, 5.62133, 5.48011, 5.34244, 5.20823, 5.07739, 4.94984,
         4.82549, 4.70427, 4.59328, 4.51185, 4.43187, 4.3533, 4.27613, 4.20032, 4.12586, 4.05272, 3.97264, 3.87209,
         3.7787, 3.68757, 3.59863, 3.51184, 3.42714, 3.34449, 3.26383, 3.18511, 3.10829, 3.03333, 2.96017, 2.88878,
         2.81779, 2.74598, 2.676, 2.60781, 2.54135, 2.47659, 2.41347, 2.35197, 2.29203, 2.23362, 2.17669, 2.12122,
         2.06717, 2.01449, 1.96315, 1.91312, 1.86437, 1.81685, 1.77055, 1.72543, 1.68055, 1.63522, 1.5911, 1.54818,
         1.50641, 1.46577, 1.42623, 1.38775, 1.35032, 1.31389, 1.27844, 1.24395, 1.21039, 1.17774, 1.14597, 1.11505,
         1.08497, 1.0557, 1.02722, 0.999227, 0.971618, 0.944773, 0.918669, 0.893287, 0.868606, 0.844607, 0.821271,
         0.798579, 0.776515, 0.75506, 0.734198, 0.713912, 0.694188, 0.675007, 0.656357, 0.638223, 0.621143, 0.604654,
         0.588601, 0.572976, 0.557765, 0.542959, 0.528544, 0.514513, 0.500854, 0.487557, 0.474616, 0.462049, 4.4054,
         4.28666, 4.17104, 4.05853, 3.94907, 3.84255, 3.73891, 3.63805, 3.53994, 3.44445, 3.35155, 3.26115, 3.17319,
         3.0876, 3.00431, 2.92328, 2.84443, 2.76771, 2.69306, 2.62042, 2.54974, 2.48097, 2.41405, 2.34893, 2.28558,
         2.22393, 2.1637, 2.1049, 2.0477, 1.99206, 1.93793, 1.88526, 1.83403, 1.78419, 1.73571, 1.68854, 1.64266,
         1.59802, 1.55459, 1.51235, 1.47125, 1.43127, 1.39237, 1.35453, 1.31772, 1.28192, 1.24556, 1.20849, 1.17252,
         1.13763, 1.10377, 1.07092, 1.03905, 1.00813, 0.978123, 0.949014, 0.921145, 0.894684, 0.868973, 0.843999,
         0.819666, 0.796023, 0.773049, 0.768755, 0.746466, 0.724791, 0.703714, 0.68322, 0.663294, 0.643921, 0.625088,
         0.606779, 0.588981, 0.571681, 0.554865, 0.53852, 0.522634, 0.507196, 0.492191, 0.47761, 0.46344, 0.449671,
         0.436292, 0.423291, 0.410659, 0.398386, 0.386461, 0.374876, 0.363621, 0.352686, 0.342063, 0.331743, 0.321718,
         0.31198, 0.30252, 0.293331, 0.284406, 0.275736, 0.267315, 0.259135, 0.251191, 0.243474, 0.23598, 0.228701,
         0.221631, 0.214765, 0.208096, 0.201622, 0.195337, 0.189239, 0.183324, 0.177585, 0.172019, 0.16662, 0.161384,
         0.156305, 0.151379, 0.146603, 0.141971, 0.13748, 0.133125, 0.128903, 0.124809, 0.12084, 0.116993, 0.113263,
         0.109648, 0.106144, 0.102747, 0.0994554, 0.096265, 0.0931731, 0.0901768]],
    'Ca':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.3461, 0.3463, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748,
         0.38792200000000004, 0.394197, 0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124,
         0.434032, 0.441052, 0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894,
         0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065,
         0.5701390000000001, 0.579361, 0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755,
         0.637908, 0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008,
         0.748928, 0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502,
         0.865274, 0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586,
         1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155,
         1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.0384, 4.0386, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -9.81985, -13.0943, -19.4672, -16.1536, -13.2939, -10.9389, -9.11316, -7.05417, -5.09631, -3.39714,
         -1.71411, 0.166864, 1.8679, 3.60786, 5.61642, 7.39788, 9.20752, 10.9363, 12.9679, 14.637, 15.5985, 16.219,
         16.624, 16.8847, 17.0628, 17.1584, 17.1064, 16.9704, 16.7803, 16.5539, 16.3046, 16.0429, 15.7789, 15.536,
         15.372, 15.0786, 14.7242, 14.3556, 13.9877, 13.6194, 13.2532, 12.8928, 12.5365, 12.1858, 11.8664, 11.5595,
         11.244, 10.9612, 10.69, 10.4391, 10.2103, 9.98744, 9.78272, 9.59673, 9.42721, 9.2791, 9.15684, 9.04395,
         8.93687, 8.84042, 8.76073, 8.68187, 8.60637, 8.53698, 8.47454, 8.42135, 8.38243, 8.34265, 8.30463, 8.27133,
         8.24374, 8.2233, 8.21278, 8.22206, 8.22931, 8.23148, 8.23251, 8.23508, 8.24044, 8.25097, 8.26937, 8.28438,
         8.29816, 8.31345, 8.33124, 8.35359, 8.38916, 8.42091, 8.4436, 8.46205, 8.47682, 8.48499, 8.49735, 8.51262,
         8.52985, 8.54891, 8.56995, 8.5934, 8.61994, 8.6516, 8.69855, 8.73543, 8.76472, 8.79176, 8.81743, 8.8425,
         8.86779, 8.89443, 8.9249, 8.96945, 9.00182, 9.02207, 9.03418, 9.04043, 9.04135, 9.03703, 9.02924, 9.01779,
         9.00247, 8.98314, 8.95956, 8.93127, 8.89581, 8.85518, 8.8152, 8.77382, 8.72999, 8.68336, 8.63404, 8.5841,
         8.52827, 8.46348, 8.39038, 8.30987, 8.22485, 8.13039, 8.01918, 7.89229, 7.74878, 7.58446, 7.40314, 7.20557,
         6.98745, 6.74326, 6.46735, 6.15239, 5.78847, 5.36165, 4.85004, 4.22442, 3.43116, 2.36577, 0.788583, -2.11054,
         -18.3346, -18.3167, -11.4294, -0.749394, 2.18437, 3.99194, 5.30882, 6.34355, 7.18918, 7.88686, 8.45186,
         8.93036, 9.4102, 9.89672, 10.373, 10.8436, 11.3148, 11.7985, 12.3388, 12.869, 13.366, 13.7886, 14.163, 14.5041,
         14.8192, 15.1124, 15.3869, 15.6464, 15.8915, 16.1236, 16.3426, 16.5539, 16.7552, 16.9376, 17.108, 17.2695,
         17.4232, 17.5705, 17.712, 17.853, 17.9895, 18.1185, 18.2318, 18.3214, 18.3985, 18.4838, 18.5811, 18.6864,
         18.7798, 18.8601, 18.9342, 19.0043, 19.0708, 19.1339, 19.1905, 19.2408, 19.2865, 19.328, 19.3658, 19.4004,
         19.4324, 19.4622, 19.4897, 19.5152, 19.5387, 19.5602, 19.58, 19.5985, 19.6156, 19.6331, 19.6485, 19.6611,
         19.671, 19.6784, 19.6839, 19.6878, 19.6902, 19.6912, 19.6911, 19.6899, 19.6876, 19.6844, 19.6802, 19.6753,
         19.6697, 19.6635, 19.6567, 19.6495, 19.6418, 19.6338, 19.6256, 19.6176, 19.6099, 19.6036, 19.5959, 19.5853,
         19.5732, 19.5599, 19.5457, 19.5307, 19.5152, 19.4991, 19.4825, 19.4654, 19.4477, 19.4294, 19.4106, 19.3913,
         19.3716, 19.3514, 19.3309, 19.3098, 19.2885, 19.267, 19.245, 19.2226, 19.1997, 19.1764, 19.1527, 19.1285,
         19.1038, 19.0786, 19.0529, 19.0266, 18.9997, 18.9721, 18.9438, 18.9148, 18.8849, 18.854, 18.8222, 18.7892,
         18.755, 18.7194, 18.6823, 18.6435, 18.6026, 18.5596, 18.5141, 18.4657, 18.414, 18.3585, 18.2984, 18.233,
         18.1612, 18.0817, 17.9925, 17.8914, 17.7746, 17.6369, 17.4703, 17.2609, 16.9825, 16.576, 15.8521, 11.1907,
         8.35517, 8.35607, 16.0437, 16.9411, 17.4778, 17.8639, 18.1653, 18.4118, 18.6196, 18.7983, 18.9543, 19.092,
         19.2145, 19.3243, 19.4233, 19.5127, 19.594, 19.668, 19.7354, 19.7971, 19.8535, 19.9052, 19.9526, 19.9961,
         20.036, 20.0726, 20.1061, 20.1369, 20.1651, 20.1908, 20.2144, 20.236, 20.2556, 20.2734, 20.2896, 20.3042,
         20.3174, 20.3293, 20.3399, 20.3494, 20.3578, 20.3651, 20.3715, 20.3771, 20.3818, 20.3857, 20.3889, 20.3915,
         20.3935, 20.3948, 20.3956, 20.3959, 20.3957, 20.3951, 20.3941, 20.3927, 20.3909, 20.3888, 20.3865, 20.3839,
         20.381, 20.3778, 20.3745, 20.3709, 20.3672, 20.3633, 20.3592, 20.3551, 20.3507, 20.3463, 20.3418, 20.3372,
         20.3325, 20.3278, 20.323, 20.3181, 20.3132, 20.3083, 20.3034, 20.2984, 20.2934, 20.2884, 20.2834, 20.2784,
         20.2734, 20.2684, 20.2635, 20.2585, 20.2536, 20.2487, 20.2438, 20.239, 20.2342, 20.2294, 20.2247, 20.22,
         20.2153, 20.2107, 20.2061, 20.2016, 20.1971, 20.1926, 20.1883, 20.184, 20.1797, 20.1754, 20.1712, 20.1671,
         20.163, 20.159, 20.155, 20.1511, 20.1472, 20.1434, 20.1397, 20.136, 20.1324, 20.1288, 20.1253, 20.1218,
         20.1184, 20.115, 20.1118, 20.1085, 20.1054, 20.1026, 20.0981],
        [0.0428047, 0.045269, 0.047875, 0.0506311, 0.0535459, 0.0566284, 0.0598885, 0.0633362, 0.0663412, 0.0692222,
         0.0722284, 0.0753652, 0.0786381, 0.0812905, 0.0837847, 0.0863555, 0.0890052, 0.0915234, 0.0937972, 0.0961275,
         0.0985158, 0.100963, 0.103551, 0.106682, 0.109908, 0.113231, 0.116655, 0.120178, 0.123377, 0.126661, 0.130033,
         0.133493, 0.137047, 0.140739, 0.144546, 0.148456, 0.152472, 0.156196, 0.159707, 0.163297, 0.166967, 0.170969,
         0.176222, 0.181636, 0.187217, 0.19297, 0.198638, 0.204419, 0.210369, 0.216493, 0.222794, 0.229765, 0.236992,
         0.244446, 0.252134, 0.260064, 0.27013, 0.281711, 0.293788, 0.306383, 0.319519, 0.331878, 0.344558, 0.370025,
         0.41399, 0.482245, 0.57634, 0.795476, 1.15137, 9.48002, 13.6832, 15.8974, 17.4478, 18.818, 20.1634, 20.7429,
         21.3391, 21.9524, 22.3549, 22.554, 22.7549, 22.7044, 22.3977, 21.9303, 21.3439, 20.7272, 18.8602, 17.1613,
         15.6155, 14.2089, 12.929, 11.7644, 10.5988, 9.52074, 8.5524, 7.68253, 6.90115, 6.19922, 5.5687, 5.00232,
         4.49352, 3.95561, 3.38987, 2.90505, 2.48957, 2.1331, 1.81772, 1.54896, 1.31994, 1.12478, 0.979792, 0.864375,
         0.762549, 0.688384, 0.65139, 0.625921, 0.622006, 0.632067, 0.646203, 0.689684, 0.736089, 0.79735, 0.865022,
         0.935019, 0.992043, 1.05255, 1.11674, 1.17782, 1.23344, 1.29168, 1.35268, 1.41655, 1.48345, 1.54587, 1.60273,
         1.66167, 1.72278, 1.78614, 1.85183, 1.91994, 1.98514, 2.02511, 2.06588, 2.10748, 2.14991, 2.1932, 2.23736,
         2.27478, 2.30697, 2.3396, 2.3727, 2.40627, 2.44032, 2.47286, 2.48265, 2.49246, 2.50232, 2.51222, 2.5257,
         2.54638, 2.56723, 2.58825, 2.60945, 2.63081, 2.65235, 2.67407, 2.69597, 2.70908, 2.70734, 2.70561, 2.70387,
         2.70214, 2.70041, 2.69868, 2.69695, 2.69523, 2.68714, 2.65286, 2.61901, 2.5856, 2.55261, 2.52004, 2.4886,
         2.45854, 2.42885, 2.39951, 2.37052, 2.34189, 2.3136, 2.28566, 2.26502, 2.24761, 2.23033, 2.21318, 2.19616,
         2.17928, 2.16253, 2.13639, 2.11017, 2.08427, 2.05869, 2.03343, 1.99907, 1.96241, 1.92642, 1.8911, 1.85642,
         1.8334, 1.81133, 1.78953, 1.76799, 1.7467, 1.72565, 1.70485, 1.6843, 1.66427, 1.64761, 1.63111, 1.61477,
         1.5986, 1.58259, 1.56848, 14.7778, 14.763, 14.5644, 14.3685, 14.1752, 13.9845, 13.7963, 13.6107, 13.431,
         13.2614, 13.2006, 13.1824, 13.1643, 13.1463, 13.1283, 13.1103, 13.0921, 13.0547, 12.9209, 12.7214, 12.4894,
         12.2616, 12.0382, 11.8189, 11.6034, 11.3918, 11.1837, 10.978, 10.7734, 10.5715, 10.3733, 10.1692, 9.965,
         9.76824, 9.57651, 9.38927, 9.20588, 9.02611, 8.84923, 8.668, 8.47907, 8.28687, 8.0989, 7.93432, 7.78757,
         7.64623, 7.48881, 7.32197, 7.15885, 6.99956, 6.84384, 6.69039, 6.53689, 6.38407, 6.23484, 6.08911, 5.94678,
         5.80823, 5.67337, 5.54207, 5.41383, 5.28854, 5.16613, 5.04619, 4.92895, 4.81435, 4.70236, 4.59264, 4.48513,
         4.37666, 4.26994, 4.16493, 4.06252, 3.96262, 3.86515, 3.77011, 3.67743, 3.58707, 3.49887, 3.41282, 3.32887,
         3.24704, 3.16725, 3.08942, 3.01351, 2.93946, 2.86723, 2.79677, 2.72802, 2.66095, 2.59555, 2.53114, 2.46739,
         2.40126, 2.33638, 2.27327, 2.2118, 2.15203, 2.09397, 2.0374, 1.98233, 1.9287, 1.87622, 1.82508, 1.77527,
         1.7268, 1.67964, 1.63377, 1.58915, 1.54576, 1.50354, 1.46286, 1.42285, 1.38393, 1.34608, 1.30926, 1.27345,
         1.23863, 1.20478, 1.17188, 1.13988, 1.10878, 1.07855, 1.04917, 1.0206, 0.992854, 0.965882, 0.939678, 0.914199,
         0.889467, 0.865431, 0.842065, 0.819391, 0.79734, 0.775935, 0.755129, 0.734931, 0.715317, 0.69628, 0.677776,
         0.659801, 0.642368, 0.625422, 0.608977, 0.593003, 0.577487, 0.562452, 0.547825, 0.533643, 0.519879, 0.506491,
         0.493516, 0.480935, 0.468705, 0.456802, 0.456616, 4.14301, 4.04411, 3.94571, 3.84925, 3.75455, 3.66168,
         3.57061, 3.48133, 3.39388, 3.30818, 3.22426, 3.14211, 3.06169, 2.98298, 2.90601, 2.83071, 2.7571, 2.68509,
         2.61472, 2.54597, 2.47878, 2.41316, 2.34907, 2.28651, 2.22539, 2.16573, 2.10752, 2.0507, 1.99527, 1.94124,
         1.88847, 1.83703, 1.78686, 1.73794, 1.69029, 1.64379, 1.5985, 1.55433, 1.51134, 1.46942, 1.42857, 1.38881,
         1.35008, 1.31232, 1.27556, 1.23981, 1.20498, 1.17103, 1.13797, 1.10581, 1.07458, 1.04409, 1.01443, 0.985622,
         0.957533, 0.930181, 0.90364, 0.877781, 0.852624, 0.828151, 0.804344, 0.781188, 0.758665, 0.73676, 0.715455,
         0.694737, 0.674589, 0.654996, 0.635945, 0.617421, 0.59941, 0.581898, 0.564874, 0.548322, 0.532231, 0.516589,
         0.501383, 0.486602, 0.472235, 0.458269, 0.444694, 0.431501, 0.418677, 0.406214, 0.394101, 0.382329, 0.370888,
         0.359769, 0.348963, 0.338462, 0.328258, 0.318341, 0.308705, 0.29934, 0.29024, 0.281398, 0.272806, 0.264456,
         0.256343, 0.24846, 0.240866, 0.233426, 0.226205, 0.219196, 0.212394, 0.205792, 0.199386, 0.193171, 0.187139,
         0.181288, 0.175611, 0.170104, 0.164761, 0.15958, 0.154553, 0.149679, 0.144951, 0.140366, 0.13592, 0.131609,
         0.127429, 0.123376, 0.119447, 0.115638, 0.111945, 0.108365]],
    'Sc':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.011010500000000001, 0.0111886, 0.0113696,
         0.0115535, 0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268,
         0.013135899999999999, 0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146972,
         0.014935, 0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.0183988, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258099999999998, 0.020585799999999998, 0.020918700000000002, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234052, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253602, 0.0257704, 0.0261872, 0.0266108, 0.0270412, 0.0274786, 0.027600000000000003,
         0.027800000000000002, 0.028, 0.0282, 0.028399999999999998, 0.0286, 0.029, 0.0292, 0.0294, 0.0298755, 0.03,
         0.030199999999999998, 0.0304, 0.030600000000000002, 0.031, 0.0315014, 0.0318, 0.0322, 0.032720799999999994,
         0.03325, 0.0337878, 0.0338, 0.0342, 0.0344, 0.0346, 0.0351596, 0.0357283, 0.0363062, 0.0368934,
         0.037399999999999996, 0.0378, 0.0384114, 0.0390327, 0.039664000000000005, 0.0403055, 0.0409574, 0.0412, 0.0416,
         0.0422728, 0.0428, 0.0434, 0.044101999999999995, 0.0448153, 0.0455401, 0.0462767, 0.0464, 0.047, 0.0474,
         0.0481667, 0.0489457, 0.0497374, 0.0498, 0.05, 0.0504, 0.051, 0.0512, 0.0516, 0.0522, 0.053,
         0.053399999999999996, 0.054, 0.054873399999999996, 0.055200000000000006, 0.0554, 0.0562, 0.056600000000000004,
         0.057515500000000004, 0.0584457, 0.059391, 0.0603516, 0.0613278, 0.0623197, 0.0633277, 0.064352, 0.0653928,
         0.06645050000000001, 0.0675253, 0.06861740000000001, 0.0697272, 0.070855, 0.0720011, 0.0731656, 0.074349,
         0.0755516, 0.0767735, 0.0780153, 0.0792771, 0.0805594, 0.08186239999999999, 0.08318640000000001, 0.0845319,
         0.0858991, 0.0872885, 0.0887003, 0.0901349, 0.0915928, 0.09307420000000001, 0.0945796, 0.0961094, 0.0976639,
         0.0992435, 0.10084900000000001, 0.10248, 0.10413700000000001, 0.105822, 0.107533, 0.109273, 0.11104,
         0.11283599999999999, 0.114661, 0.11651600000000001, 0.1184, 0.12031499999999999, 0.122261, 0.124239, 0.126248,
         0.12829, 0.130365, 0.13247399999999998, 0.134616, 0.136793, 0.139006, 0.141254, 0.143539, 0.145861, 0.14822,
         0.150617, 0.153053, 0.155529, 0.15804400000000002, 0.160601, 0.163198, 0.16583799999999999, 0.16852, 0.171246,
         0.17401499999999998, 0.17683000000000001, 0.17969, 0.182596, 0.18555000000000002, 0.188551, 0.191601,
         0.19469999999999998, 0.197849, 0.201049, 0.2043, 0.20760499999999998, 0.21096299999999998, 0.214375, 0.217842,
         0.221366, 0.224946, 0.228584, 0.23228200000000002, 0.236039, 0.23985599999999999, 0.24373599999999998,
         0.247678, 0.251684, 0.255755, 0.25989100000000004, 0.264095, 0.268366, 0.272707, 0.277118, 0.2816, 0.286155,
         0.290783, 0.29548599999999997, 0.300265, 0.305122, 0.310057, 0.315072, 0.320168, 0.325347, 0.330609,
         0.33595600000000003, 0.34138999999999997, 0.346912, 0.35252300000000003, 0.358224, 0.36401799999999995,
         0.369906, 0.37588900000000003, 0.381969, 0.38695999999999997, 0.39161, 0.39385000000000003, 0.3951, 0.39611,
         0.39649, 0.39688, 0.39712000000000003, 0.39726, 0.39738, 0.39751, 0.39764, 0.39776999999999996, 0.39802,
         0.39826999999999996, 0.3984, 0.39854, 0.3986, 0.3988, 0.39891000000000004, 0.3993, 0.39943, 0.39956, 0.39968,
         0.39994999999999997, 0.40007, 0.4002, 0.40046, 0.40111, 0.40124, 0.40137, 0.4015, 0.40163, 0.40176, 0.40202,
         0.40214999999999995, 0.40227999999999997, 0.40241000000000005, 0.40255, 0.40267000000000003, 0.40281, 0.40293,
         0.4032, 0.40332999999999997, 0.40346, 0.40358999999999995, 0.40372, 0.40411, 0.40425, 0.40451, 0.40478, 0.4053,
         0.4057, 0.40584, 0.4061, 0.40637, 0.4065, 0.40676999999999996, 0.40731, 0.40743, 0.40757, 0.40797000000000005,
         0.40838, 0.40892, 0.41, 0.4141, 0.41520999999999997, 0.41605000000000003, 0.41745, 0.42014, 0.42286, 0.42592,
         0.42757, 0.434486, 0.43653, 0.43964, 0.44517, 0.45237, 0.45248, 0.45665, 0.464036, 0.46785000000000004,
         0.47502, 0.48241, 0.48907, 0.49394, 0.501929, 0.50604, 0.5102099999999999, 0.518462, 0.526848,
         0.5287000000000001, 0.5344, 0.53904, 0.547759, 0.5566180000000001, 0.5656209999999999, 0.56741, 0.57532,
         0.584625, 0.594081, 0.6036900000000001, 0.6134539999999999, 0.6233759999999999, 0.633459, 0.6437050000000001,
         0.654116, 0.6646960000000001, 0.675447, 0.686372, 0.697473, 0.708754, 0.7202179999999999, 0.7318669999999999,
         0.7437039999999999, 0.755733, 0.767956, 0.780377, 0.792999, 0.805825, 0.818859, 0.8321029999999999, 0.845562,
         0.8592380000000001, 0.873135, 0.887258, 0.901608, 0.916191, 0.93101, 0.946068, 0.9613700000000001, 0.976919,
         0.99272, 1.00878, 1.0246, 1.0375, 1.0542799999999999, 1.07133, 1.0886600000000002, 1.10627, 1.12416, 1.14234,
         1.16082, 1.1796, 1.19868, 1.21806, 1.23776, 1.25778, 1.2781300000000002, 1.2988, 1.31981, 1.34115, 1.36285,
         1.3848900000000002, 1.40729, 1.43005, 1.4531800000000001, 1.47668, 1.50057, 1.52484, 1.5495, 1.57456, 1.60003,
         1.6259100000000002, 1.65221, 1.67893, 1.7060899999999999, 1.73368, 1.76172, 1.79022, 1.8191700000000002,
         1.8485999999999998, 1.8785, 1.9088800000000001, 1.93975, 1.97113, 2.00301, 2.03541, 2.06833, 2.10178, 2.13578,
         2.1703200000000002, 2.20542, 2.2410900000000002, 2.27734, 2.31418, 2.35161, 2.38964, 2.42829,
         2.4675700000000003, 2.50748, 2.5480300000000002, 2.58925, 2.63113, 2.67368, 2.7169299999999996,
         2.7608699999999997, 2.80553, 2.8509, 2.8970100000000003, 2.94387, 2.9914899999999998, 3.03987, 3.08904, 3.139,
         3.1897699999999998, 3.2413600000000002, 3.29379, 3.34706, 3.4012, 3.45621, 3.5121100000000003, 3.56892,
         3.62664, 3.6853000000000002, 3.74491, 3.80548, 3.86703, 3.92958, 3.9931300000000003, 4.05772, 4.12335, 4.19004,
         4.25781, 4.3266800000000005, 4.39666, 4.467770000000001, 4.472, 4.4927, 4.4929, 4.53, 4.60327, 4.67772,
         4.75338, 4.83026, 4.908390000000001, 4.98778, 5.0684499999999995, 5.15043, 5.2337299999999995, 5.31839,
         5.4044099999999995, 5.49182, 5.580640000000001, 5.67091, 5.76263, 5.85583, 5.95055, 6.04679, 6.14459, 6.24398,
         6.34497, 6.44759, 6.55188, 6.657850000000001, 6.76554, 6.87496, 6.98616, 7.0991599999999995, 7.213979999999999,
         7.33066, 7.449229999999999, 7.56971, 7.69215, 7.816560000000001, 7.94299, 8.07146, 8.20201, 8.334670000000001,
         8.469479999999999, 8.606459999999998, 8.74567, 8.887120000000001, 9.03086, 9.17693, 9.32536, 9.47619, 9.62946,
         9.78521, 9.94347, 10.104299999999999, 10.267700000000001, 10.4338, 10.6026, 10.7741, 10.9483,
         11.125399999999999, 11.305299999999999, 11.4882, 11.674, 11.8628, 12.0547, 12.2497, 12.447799999999999,
         12.6491, 12.8537, 13.0616, 13.2729, 13.4876, 13.7057, 13.9274, 14.152700000000001, 14.3816, 14.6142, 14.8505,
         15.0907, 15.3348, 15.582799999999999, 15.8349, 16.091, 16.3513, 16.6157, 16.8845, 17.1576, 17.4351, 17.7171,
         18.0036, 18.2948, 18.590700000000002, 18.8914, 19.197, 19.5075, 19.823, 20.1436, 20.4694, 20.8005, 21.1369,
         21.4788, 21.8262, 22.1792, 22.538, 22.9025, 23.2729, 23.6493, 24.0318, 24.4205, 24.8155, 25.216900000000003,
         25.6248, 26.0392, 26.4604, 26.8884, 27.3233, 27.7652, 28.214299999999998, 28.6706, 29.1343, 29.6056, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, 0.89937,
         0.848332, 0.791683, 0.729132, 0.658398, 0.581335, 0.497486, 0.406542, 0.313088, 0.215305, 0.111336, 0.00032248,
         -0.119556, -0.254806, -0.403297, -0.559048, -0.727394, -0.911631, -1.11374, -1.33979, -1.59834, -1.90619,
         -2.29321, -2.43285, -2.66891, -2.99549, -3.33442, -3.54366, -3.62526, -3.90353, -4.13579, -4.30231, -4.63452,
         -4.6985, -4.76186, -4.82447, -4.86485, -5.02039, -5.31631, -5.63481, -6.09642, -6.7399, -7.29491, -7.71261,
         -7.72004, -7.90318, -7.92401, -7.78715, -7.75421, -7.79575, -7.53562, -6.99959, -6.21836, -5.40492, -4.11965,
         -2.81304, -1.32321, 0.481781, 2.45824, 3.26151, 4.59601, 6.84016, 8.47597, 10.3706, 12.3413, 13.9719, 15.2333,
         16.0176, 16.0353, 16.2952, 16.7303, 17.1377, 17.0441, 16.9166, 16.9648, 16.7561, 16.3154, 15.8083, 15.6698,
         15.3753, 14.9724, 14.4742, 14.2588, 13.912, 13.462, 13.3067, 13.2274, 12.7997, 12.6382, 12.2318, 11.8629,
         11.5048, 11.1461, 10.8084, 10.5089, 10.2277, 9.96625, 9.71833, 9.49115, 9.28739, 9.09879, 8.9274, 8.7735,
         8.62754, 8.48436, 8.35371, 8.23764, 8.13054, 8.03541, 7.951, 7.87591, 7.80976, 7.75324, 7.70749, 7.66842,
         7.63254, 7.60206, 7.57771, 7.56003, 7.54995, 7.54913, 7.56315, 7.58654, 7.61462, 7.65167, 7.68389, 7.70979,
         7.73569, 7.77231, 7.81098, 7.83247, 7.84334, 7.85125, 7.85717, 7.84807, 7.83308, 7.83368, 7.84721, 7.87015,
         7.90134, 7.94165, 7.99931, 8.07252, 8.13553, 8.18779, 8.23677, 8.27991, 8.32254, 8.3651, 8.4026, 8.43423,
         8.46268, 8.4871, 8.50846, 8.52928, 8.54966, 8.56727, 8.58349, 8.60238, 8.62434, 8.64981, 8.68445, 8.72142,
         8.74517, 8.76148, 8.77438, 8.78322, 8.78526, 8.78121, 8.77037, 8.75262, 8.73439, 8.71743, 8.69855, 8.67763,
         8.6545, 8.62916, 8.60157, 8.57643, 8.54861, 8.50952, 8.4634, 8.41233, 8.35413, 8.28579, 8.2092, 8.12409,
         8.02985, 7.92525, 7.80929, 7.68111, 7.53952, 7.38302, 7.20984, 7.01815, 6.80578, 6.56739, 6.29619, 5.98786,
         5.63516, 5.22818, 4.75314, 4.19047, 3.51117, 2.67009, 1.59201, 0.139439, -1.97461, -4.65793, -8.91462,
         -12.4165, -15.2881, -18.5583, -20.1676, -22.1838, -23.6779, -24.7037, -25.6556, -26.859, -28.1599, -29.5449,
         -32.2067, -34.3592, -35.0866, -35.9156, -36.3299, -38.9871, -39.7072, -40.6603, -40.7569, -39.9031, -39.6138,
         -41.4482, -38.86, -35.6422, -31.7259, -21.9442, -18.6597, -15.5524, -11.6945, -8.93154, -6.0573, -1.49167,
         -3.04821, -6.61048, -9.05651, -11.7359, -13.7147, -16.2954, -18.1669, -23.4101, -27.4945, -28.9051, -27.5744,
         -26.9969, -22.4281, -19.4555, -13.0656, -7.24613, 1.79225, 8.50274, 11.5356, 16.9583, 21.8667, 23.9548,
         26.1965, 29.4965, 31.3117, 31.5578, 25.4728, 22.8004, 21.7185, 20.1051, 17.4785, 15.8801, 14.8234, 13.3988,
         11.6365, 10.5904, 9.87551, 9.63341, 9.33972, 9.59574, 10.1274, 10.7509, 10.6168, 10.6113, 10.3793, 10.2892,
         10.6506, 11.3795, 11.8785, 11.71, 11.4016, 11.4074, 11.9539, 12.6256, 13.6776, 14.0914, 14.1248, 14.188, 14.24,
         14.5323, 15.1121, 15.6605, 15.747, 15.9575, 16.0117, 16.2074, 16.5298, 16.858, 17.1187, 17.3055, 17.4301,
         17.6188, 17.8476, 18.0402, 18.2104, 18.3636, 18.5016, 18.6338, 18.7655, 18.8939, 19.0194, 19.1447, 19.265,
         19.3771, 19.4855, 19.5913, 19.6969, 19.8088, 19.9158, 20.0005, 20.0726, 20.1509, 20.2316, 20.299, 20.3502,
         20.3897, 20.4259, 20.4641, 20.5022, 20.5403, 20.5703, 20.6051, 20.6359, 20.6641, 20.6901, 20.7171, 20.742,
         20.7614, 20.7777, 20.7925, 20.805, 20.8143, 20.8212, 20.826, 20.8289, 20.8302, 20.83, 20.8284, 20.8255,
         20.8215, 20.8163, 20.8101, 20.803, 20.795, 20.7862, 20.7767, 20.7664, 20.7555, 20.7441, 20.732, 20.7195,
         20.7065, 20.6932, 20.6795, 20.6656, 20.6516, 20.638, 20.6246, 20.6097, 20.5934, 20.5763, 20.5586, 20.5403,
         20.5215, 20.5022, 20.4824, 20.4623, 20.4417, 20.4207, 20.3993, 20.3776, 20.3554, 20.3329, 20.31, 20.2867,
         20.2629, 20.2388, 20.2142, 20.1891, 20.1636, 20.1375, 20.111, 20.0841, 20.057, 20.0289, 19.9989, 19.9678,
         19.9354, 19.9016, 19.8665, 19.8297, 19.7913, 19.7509, 19.7084, 19.6635, 19.6159, 19.5651, 19.5107, 19.4522,
         19.3887, 19.3194, 19.243, 19.1582, 19.0626, 18.9524, 18.8235, 18.6692, 18.4784, 18.2306, 17.8833, 17.3182,
         15.8638, 15.6584, 9.61866, 9.61954, 16.417, 17.7259, 18.3611, 18.7881, 19.1104, 19.3688, 19.5839, 19.7674,
         19.9268, 20.0672, 20.1924, 20.3049, 20.4071, 20.501, 20.5896, 20.6698, 20.7399, 20.8035, 20.8612, 20.9138,
         20.9618, 21.0058, 21.046, 21.083, 21.1169, 21.1481, 21.1769, 21.2034, 21.228, 21.2508, 21.2726, 21.2935,
         21.3122, 21.328, 21.3419, 21.3542, 21.3649, 21.3744, 21.3827, 21.3899, 21.396, 21.4013, 21.4058, 21.4095,
         21.4125, 21.4149, 21.4167, 21.4181, 21.4194, 21.4202, 21.4201, 21.4195, 21.4184, 21.4168, 21.4149, 21.4126,
         21.41, 21.407, 21.4038, 21.4003, 21.3965, 21.3926, 21.3884, 21.384, 21.3795, 21.3749, 21.3701, 21.3652,
         21.3601, 21.355, 21.3498, 21.3445, 21.3392, 21.3338, 21.3284, 21.3229, 21.3174, 21.3119, 21.3064, 21.3009,
         21.2953, 21.2898, 21.2843, 21.2788, 21.2733, 21.2679, 21.2624, 21.2571, 21.2517, 21.2464, 21.2411, 21.2359,
         21.2307, 21.2256, 21.2205, 21.2155, 21.2106, 21.2057, 21.2008, 21.196, 21.1913, 21.1867, 21.1821, 21.1775,
         21.1731, 21.1687, 21.1643, 21.1601, 21.1558, 21.1517, 21.1476, 21.1436, 21.1397, 21.1358, 21.132, 21.1283,
         21.1246, 21.1223, 21.1168],
        [1.06978, 1.07987, 1.09005, 1.10033, 1.11071, 1.12118, 1.13176, 1.14243, 1.15321, 1.16408, 1.17506, 1.18614,
         1.19368, 1.19917, 1.20469, 1.21023, 1.2158, 1.22139, 1.22701, 1.23266, 1.23585, 1.23499, 1.23413, 1.23327,
         1.23242, 1.23156, 1.22451, 1.21522, 1.20599, 1.19684, 1.18776, 1.17136, 1.15466, 1.13821, 1.12091, 1.09962,
         1.07874, 1.05664, 1.03225, 1.00819, 0.984235, 0.960846, 0.938012, 0.915721, 0.89396, 0.872717, 0.855925,
         0.839631, 0.829103, 0.822591, 0.81613, 0.809721, 0.803361, 0.794611, 0.783977, 0.784953, 0.786442, 0.787936,
         0.789432, 0.79093, 0.789166, 0.783227, 0.77081, 0.758588, 0.755264, 0.760916, 0.793044, 0.952907, 1.29828,
         1.47576, 1.6665, 1.8132, 2.0764, 2.5756, 2.72349, 2.93857, 3.12546, 3.28692, 3.5306, 3.78133, 3.937, 4.29167,
         4.99336, 5.92893, 7.06518, 7.09303, 8.07985, 8.41744, 9.12771, 10.0604, 11.3901, 12.9223, 14.5227, 15.9084,
         16.8866, 17.9812, 19.076, 20.1121, 21.1043, 21.6159, 21.8072, 22.002, 21.7168, 21.499, 20.835, 19.6706,
         18.1629, 16.5033, 14.6015, 14.3024, 13.476, 12.6528, 10.8557, 9.30942, 7.96641, 7.86966, 7.09731, 6.61455,
         5.98113, 5.76828, 5.42948, 4.93898, 4.41989, 4.16149, 3.82949, 3.43955, 3.30561, 3.19726, 2.9297, 2.78746,
         2.53626, 2.31622, 2.12758, 1.971, 1.87275, 1.79287, 1.73338, 1.69148, 1.66375, 1.66258, 1.66784, 1.68113,
         1.70434, 1.72786, 1.75171, 1.78381, 1.82944, 1.87624, 1.92863, 1.98573, 2.04452, 2.10505, 2.16737, 2.23154,
         2.29625, 2.35445, 2.41413, 2.47532, 2.53805, 2.60238, 2.66834, 2.73597, 2.80529, 2.85712, 2.90991, 2.946,
         2.97151, 2.9959, 3.02049, 3.04528, 3.05057, 3.0458, 3.04587, 3.05196, 3.05806, 3.06416, 3.09312, 3.13948,
         3.18654, 3.23375, 3.28036, 3.32764, 3.3756, 3.39512, 3.39598, 3.39616, 3.3904, 3.38466, 3.37892, 3.36764,
         3.352, 3.33643, 3.32093, 3.30551, 3.29235, 3.28157, 3.27084, 3.26013, 3.2531, 3.24953, 3.24595, 3.24238,
         3.23881, 3.21131, 3.18027, 3.14954, 3.1191, 3.08462, 3.04964, 3.01504, 2.98085, 2.95292, 2.93083, 2.90891,
         2.88715, 2.86556, 2.84413, 2.82285, 2.80174, 2.78078, 2.74979, 2.71614, 2.68291, 2.64995, 2.61321, 2.57698,
         2.54126, 2.50603, 2.47089, 2.43554, 2.4007, 2.36636, 2.33251, 2.29914, 2.26625, 2.23383, 2.20146, 2.16494,
         2.12901, 2.09368, 2.05895, 2.02478, 1.99118, 1.95814, 1.92565, 1.8937, 1.86228, 1.83138, 1.80099, 1.77677,
         1.78582, 1.82566, 1.88861, 1.99488, 2.06025, 2.17286, 2.28686, 2.38826, 2.53571, 2.72434, 3.13268, 3.73662,
         5.39374, 8.12081, 9.49362, 10.6483, 11.1669, 13.0147, 15.6348, 22.1038, 24.6224, 27.0539, 29.0801, 32.0182,
         38.6551, 39.7823, 41.1456, 47.7781, 48.6681, 48.7739, 47.9833, 46.0636, 43.5546, 37.7465, 30.4954, 28.9314,
         27.9012, 27.2202, 27.1281, 27.3122, 27.8154, 29.9854, 31.3317, 39.0163, 41.6764, 45.0395, 54.6246, 57.4984,
         60.3531, 61.2929, 60.8044, 61.2892, 61.1066, 59.0111, 55.59, 53.5709, 48.3045, 40.4434, 39.075, 32.8216,
         30.174, 28.3614, 26.8602, 24.4422, 16.0585, 14.7193, 14.061, 13.6012, 13.2076, 13.2353, 13.2874, 13.3891,
         14.1229, 14.345, 14.4299, 13.6169, 12.9235, 12.9132, 12.9156, 13.4462, 13.7253, 13.7088, 13.1984, 12.7024,
         12.803, 13.7728, 14.2936, 14.382, 13.8796, 13.3948, 13.2911, 13.0296, 13.0287, 13.1435, 13.1547, 12.7886,
         12.7178, 12.2792, 12.0521, 11.9889, 11.9157, 11.668, 11.4255, 11.15, 10.9459, 10.8289, 10.6482, 10.4378,
         10.2315, 10.0293, 9.83457, 9.65646, 9.48157, 9.30986, 9.14125, 8.97373, 8.80227, 8.63407, 8.4691, 8.30728,
         8.14854, 7.98593, 7.80921, 7.62636, 7.45709, 7.29864, 7.13202, 6.95408, 6.78057, 6.61884, 6.46829, 6.32521,
         6.1853, 6.05255, 5.94508, 5.80707, 5.67227, 5.54059, 5.41197, 5.28634, 5.15821, 5.03221, 4.90929, 4.78936,
         4.67069, 4.55433, 4.44087, 4.33023, 4.22235, 4.11716, 4.01459, 3.91457, 3.81705, 3.72196, 3.62923, 3.53882,
         3.45065, 3.36469, 3.28087, 3.19913, 3.11943, 3.04172, 2.96594, 2.89205, 2.81999, 2.74974, 2.68124, 2.61444,
         2.54931, 2.4858, 2.42387, 2.3616, 2.29979, 2.23961, 2.181, 2.12392, 2.06833, 2.0142, 1.96149, 1.91016, 1.86017,
         1.81148, 1.76408, 1.71791, 1.67295, 1.62917, 1.58653, 1.54501, 1.50458, 1.4652, 1.42685, 1.38951, 1.35315,
         1.31773, 1.28325, 1.24966, 1.21696, 1.18467, 1.15202, 1.12028, 1.0894, 1.05938, 1.03019, 1.0018, 0.97419,
         0.947341, 0.921234, 0.895847, 0.87116, 0.847153, 0.823805, 0.801103, 0.779026, 0.757558, 0.736681, 0.71638,
         0.696636, 0.676555, 0.656887, 0.637792, 0.619252, 0.60125, 0.583771, 0.566801, 0.550324, 0.534326, 0.533398,
         0.528888, 4.10855, 4.05808, 3.96138, 3.86698, 3.77483, 3.68488, 3.59707, 3.51136, 3.42768, 3.346, 3.26627,
         3.18843, 3.11246, 3.03829, 2.96589, 2.8935, 2.81762, 2.74374, 2.67179, 2.60173, 2.5335, 2.46706, 2.40237,
         2.33938, 2.27803, 2.2183, 2.16012, 2.10348, 2.04832, 1.99461, 1.9423, 1.89137, 1.84092, 1.78939, 1.73931,
         1.69062, 1.6433, 1.59731, 1.55259, 1.50914, 1.46689, 1.42584, 1.38593, 1.34713, 1.30942, 1.27277, 1.23715,
         1.20252, 1.16886, 1.13614, 1.10358, 1.07186, 1.04099, 1.01093, 0.98168, 0.953215, 0.925517, 0.898568, 0.872351,
         0.846849, 0.822044, 0.79792, 0.77446, 0.751648, 0.729468, 0.707905, 0.686943, 0.666567, 0.646762, 0.627514,
         0.608809, 0.590633, 0.572971, 0.555812, 0.539141, 0.522946, 0.507215, 0.491935, 0.477094, 0.462681, 0.448684,
         0.435092, 0.421894, 0.40908, 0.396639, 0.38456, 0.372835, 0.361452, 0.350404, 0.33968, 0.329272, 0.31917,
         0.309367, 0.299854, 0.290623, 0.281666, 0.272975, 0.264543, 0.256362, 0.248426, 0.240727, 0.233258, 0.226014,
         0.218987, 0.212171, 0.20556, 0.199149, 0.192932, 0.186902, 0.181055, 0.175385, 0.169887, 0.164557, 0.159388,
         0.154377, 0.149519, 0.144809, 0.140242, 0.135816, 0.132267]],
    'Ti':                                                                           [
        [0.01, 0.010142799999999999, 0.010306800000000001, 0.0104735, 0.010642899999999999, 0.0108151, 0.01099,
         0.0111677, 0.0113484, 0.0115319, 0.0117184, 0.011908, 0.0121006, 0.0122963, 0.0124952, 0.0126973, 0.0129026,
         0.0131113, 0.013323399999999999, 0.0135389, 0.0137579, 0.013980399999999999, 0.0142065, 0.0144363, 0.0146698,
         0.0149071, 0.015148199999999999, 0.015393200000000001, 0.015642200000000002, 0.0158952, 0.0161523,
         0.016413499999999998, 0.016679, 0.016948699999999997, 0.0172229, 0.0175014, 0.0177845, 0.0180722, 0.0183645,
         0.0186615, 0.0189633, 0.0192701, 0.0195817, 0.0198985, 0.0202203, 0.0205473, 0.0208797, 0.0212174, 0.0215606,
         0.021909300000000003, 0.0222637, 0.0226237, 0.0229897, 0.0233615, 0.0237394, 0.0241233, 0.0245135, 0.02491,
         0.0253129, 0.0257223, 0.0261383, 0.0265611, 0.0269907, 0.027427299999999998, 0.0278709, 0.028321699999999998,
         0.0287797, 0.0292452, 0.0297183, 0.030198899999999997, 0.0306874, 0.0311837, 0.0316881, 0.0320289, 0.0324566,
         0.03289, 0.0333175, 0.0338564, 0.034404000000000004, 0.0349604, 0.0355259, 0.036100499999999994, 0.0366844,
         0.037277700000000004, 0.037880699999999996, 0.038493400000000004, 0.039116, 0.0397486, 0.040391500000000004,
         0.0410448, 0.0417087, 0.0423833, 0.043068800000000004, 0.0437654, 0.0444733, 0.0451926, 0.0459236,
         0.046666400000000004, 0.0474211, 0.0481881, 0.048967500000000004, 0.0497596, 0.0505644, 0.051382199999999996,
         0.0522133, 0.0530578, 0.053916, 0.054787999999999996, 0.0556742, 0.056574599999999996, 0.0574897, 0.0584195,
         0.059364400000000005, 0.0603246, 0.0613003, 0.0622918, 0.0632993, 0.0643231, 0.0653635, 0.0664207, 0.067495,
         0.06858669999999999, 0.069696, 0.0708233, 0.0719688, 0.0731328, 0.07431570000000001, 0.07551770000000001,
         0.07673909999999999, 0.0779803, 0.07924160000000001, 0.0805233, 0.0818257, 0.0831491, 0.084494,
         0.08586060000000001, 0.0872493, 0.0886605, 0.0900945, 0.0915517, 0.0930325, 0.0945372, 0.0960663,
         0.09762009999999999, 0.099199, 0.100803, 0.102434, 0.10409099999999999, 0.105774, 0.107485, 0.109224,
         0.11098999999999999, 0.112785, 0.11461, 0.116463, 0.118347, 0.12026099999999999, 0.12220600000000001, 0.124183,
         0.126191, 0.128232, 0.13030699999999998, 0.13241399999999998, 0.134556, 0.136732, 0.13894399999999998,
         0.141191, 0.143475, 0.14579499999999998, 0.14815299999999998, 0.15055000000000002, 0.152985, 0.155459,
         0.157973, 0.160529, 0.163125, 0.165763, 0.16844399999999998, 0.17116900000000002, 0.173937, 0.176751,
         0.17960900000000002, 0.18251499999999998, 0.18546700000000002, 0.188466, 0.191515, 0.194612, 0.19776, 0.200959,
         0.204209, 0.207512, 0.210868, 0.214279, 0.217745, 0.221266, 0.224845, 0.228482, 0.232177, 0.235933, 0.239749,
         0.243626, 0.247567, 0.251571, 0.25564, 0.259775, 0.26397699999999996, 0.268246, 0.27258499999999997, 0.276994,
         0.281474, 0.286026, 0.290653, 0.295354, 0.300131, 0.304985, 0.309918, 0.31493099999999996, 0.320025, 0.325201,
         0.330461, 0.335805, 0.341237, 0.34675599999999995, 0.352365, 0.35806400000000005, 0.36385500000000004, 0.36974,
         0.37572000000000005, 0.38179700000000005, 0.387973, 0.394248, 0.400625, 0.40710399999999997,
         0.41368900000000003, 0.42038, 0.427179, 0.434089, 0.44111, 0.44824400000000003, 0.4537, 0.45389999999999997,
         0.455494, 0.46286099999999997, 0.470348, 0.47795499999999996, 0.48568599999999995, 0.493541, 0.501524,
         0.509636, 0.517879, 0.526255, 0.5347670000000001, 0.543416, 0.552206, 0.561137, 0.570213, 0.5794360000000001,
         0.588808, 0.5983310000000001, 0.608009, 0.6178429999999999, 0.6278360000000001, 0.6379900000000001, 0.648309,
         0.6587949999999999, 0.669451, 0.680279, 0.6912820000000001, 0.702463, 0.7138239999999999, 0.72537,
         0.7371019999999999, 0.749024, 0.761139, 0.7734500000000001, 0.78596, 0.798672, 0.81159, 0.824717, 0.838056,
         0.851611, 0.865385, 0.879382, 0.893605, 0.908058, 0.922746, 0.93767, 0.952836, 0.968248, 0.983908, 0.999822,
         1.01599, 1.03243, 1.0491300000000001, 1.06609, 1.08334, 1.10086, 1.11866, 1.13676, 1.15514, 1.17383, 1.19281,
         1.2121099999999998, 1.23171, 1.25163, 1.2718800000000001, 1.29245, 1.31335, 1.3346, 1.3561800000000002,
         1.3781199999999998, 1.4004100000000002, 1.42306, 1.44607, 1.46946, 1.49323, 1.5173800000000002, 1.54193,
         1.56686, 1.5922100000000001, 1.61796, 1.64413, 1.67072, 1.69774, 1.7252, 1.75311, 1.78146, 1.81028,
         1.8395599999999999, 1.86931, 1.89954, 1.93027, 1.96149, 1.99321, 2.0, 2.026, 2.052, 2.079, 2.106, 2.134, 2.161,
         2.19, 2.218, 2.247, 2.277, 2.306, 2.337, 2.367, 2.398, 2.429, 2.461, 2.493, 2.526, 2.559, 2.592, 2.626, 2.66,
         2.695, 2.73, 2.766, 2.802, 2.839, 2.876, 2.914, 2.952, 2.99, 3.029, 3.069, 3.109, 3.15, 3.191, 3.232, 3.275,
         3.317, 3.361, 3.405, 3.449, 3.494, 3.54, 3.586, 3.633, 3.68, 3.729, 3.777, 3.827, 3.877, 3.927, 3.979, 4.031,
         4.083, 4.137, 4.191, 4.245, 4.301, 4.357, 4.414, 4.472, 4.53, 4.589, 4.649, 4.71, 4.771, 4.834, 4.897, 4.961,
         4.9663, 4.9665, 5.026, 5.091, 5.158, 5.225, 5.294, 5.363, 5.433, 5.504, 5.576, 5.649, 5.722, 5.797, 5.873,
         5.95, 6.027, 6.106, 6.186, 6.267, 6.349, 6.432, 6.516, 6.601, 6.687, 6.774, 6.863, 6.952, 7.043, 7.135, 7.229,
         7.323, 7.419, 7.516, 7.614, 7.713, 7.814, 7.916, 8.019, 8.124, 8.23, 8.338, 8.447, 8.557, 8.669, 8.782, 8.897,
         9.013, 9.131, 9.25, 9.371, 9.494, 9.618, 9.743, 9.90058, 10.0607, 10.2234, 10.3888, 10.556799999999999,
         10.7276, 10.9011, 11.077399999999999, 11.2566, 11.438600000000001, 11.6236, 11.8117, 12.0027, 12.1968, 12.3941,
         12.5946, 12.7983, 13.0053, 13.2156, 13.4294, 13.646600000000001, 13.867299999999998, 14.0916, 14.3195, 14.5511,
         14.7865, 15.0256, 15.2687, 15.515600000000001, 15.7666, 16.0216, 16.2807, 16.5441, 16.8116, 17.083599999999997,
         17.359900000000003, 17.6406, 17.926, 18.2159, 18.5105, 18.809900000000003, 19.1142, 19.423299999999998,
         19.7375, 20.0567, 20.3811, 20.7108, 21.0457, 21.3861, 21.732, 22.0835, 22.4407, 22.8037, 23.1725, 23.5473,
         23.9282, 24.3152, 24.7085, 25.1081, 25.514200000000002, 25.9269, 26.3462, 26.7724, 27.2054, 27.645400000000002,
         28.092599999999997, 28.5469, 29.0087, 29.4779, 29.9546, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, 3.13334, 3.1603,
         3.17754, 3.19999, 3.21535, 3.21428, 3.1813, 3.12196, 3.04848, 2.96542, 2.87785, 2.80351, 2.7315, 2.65865,
         2.58363, 2.50574, 2.4237, 2.33752, 2.24465, 2.13967, 2.02387, 1.89655, 1.7556, 1.59958, 1.42675, 1.23438,
         1.01964, 0.77687, 0.498063, 0.17083, -0.227176, -0.749109, -1.29137, -2.00326, -2.44702, -2.62289, -2.53127,
         -2.4487, -2.78137, -3.26598, -3.77984, -4.23879, -4.71674, -5.10633, -5.31214, -5.21145, -5.08363, -4.78742,
         -3.58289, -2.09192, -0.752391, 0.146311, 1.31706, 2.52777, 3.66719, 4.81243, 6.12984, 7.49442, 8.81349,
         10.3751, 12.0345, 13.5884, 14.8286, 15.7053, 16.3493, 16.7801, 16.9514, 17.039, 16.9905, 16.7282, 16.062,
         15.5128, 15.0276, 14.6303, 14.3962, 14.0865, 13.7613, 13.4364, 13.1153, 12.7939, 12.4933, 12.2386, 12.0378,
         11.8356, 11.6426, 11.4512, 11.2844, 11.1426, 11.0144, 10.8918, 10.7751, 10.6692, 10.5763, 10.5026, 10.4412,
         10.3902, 10.3504, 10.3264, 10.3034, 10.2827, 10.2636, 10.2443, 10.2275, 10.2132, 10.2013, 10.192, 10.1859,
         10.1817, 10.1785, 10.1756, 10.1741, 10.1736, 10.174, 10.1749, 10.1759, 10.1759, 10.1694, 10.1681, 10.1737,
         10.1842, 10.1999, 10.2206, 10.2464, 10.2789, 10.324, 10.3612, 10.3955, 10.429, 10.4627, 10.497, 10.5324,
         10.569, 10.6089, 10.6563, 10.7061, 10.7567, 10.8044, 10.8451, 10.8827, 10.9183, 10.9511, 10.9819, 11.0126,
         11.0446, 11.0808, 11.1194, 11.1603, 11.2082, 11.2461, 11.2771, 11.3042, 11.3296, 11.3549, 11.3769, 11.3931,
         11.3992, 11.3961, 11.3882, 11.3777, 11.3673, 11.3577, 11.3478, 11.3381, 11.3286, 11.3123, 11.2916, 11.2666,
         11.2371, 11.2034, 11.1651, 11.1219, 11.0736, 11.0202, 10.9613, 10.897, 10.8259, 10.7475, 10.6614, 10.5671,
         10.4638, 10.351, 10.2284, 10.0975, 9.94867, 9.77937, 9.58573, 9.36153, 9.10532, 8.80539, 8.47157, 8.09059,
         7.64272, 7.10525, 6.44314, 5.59477, 4.43993, 2.69019, -0.736873, -18.2714, -18.25, -5.60849, 2.11285, 4.97994,
         6.80646, 8.15251, 9.21552, 10.0886, 10.8223, 11.4461, 11.977, 12.4251, 12.8242, 12.8911, 12.8719, 13.0216,
         13.722, 14.6717, 15.3636, 15.8267, 16.2526, 16.6409, 17.0025, 17.3345, 17.6343, 17.8817, 18.1022, 18.3224,
         18.5692, 18.8143, 19.0335, 19.224, 19.4031, 19.5708, 19.7301, 19.8803, 20.0195, 20.1482, 20.2691, 20.3828,
         20.4903, 20.5915, 20.6863, 20.7751, 20.8592, 20.9403, 21.0175, 21.0881, 21.1528, 21.2116, 21.266, 21.316,
         21.3645, 21.4113, 21.4537, 21.4905, 21.5243, 21.5553, 21.5835, 21.6091, 21.6326, 21.654, 21.6736, 21.6918,
         21.7093, 21.7252, 21.7385, 21.7485, 21.7569, 21.7637, 21.7689, 21.7729, 21.7758, 21.778, 21.7799, 21.7815,
         21.7819, 21.7793, 21.775, 21.7695, 21.7628, 21.7551, 21.7465, 21.7374, 21.7277, 21.7176, 21.7063, 21.694,
         21.6809, 21.6671, 21.6527, 21.6377, 21.6222, 21.6061, 21.6027, 21.5897, 21.577, 21.5633, 21.5495, 21.5351,
         21.5211, 21.5059, 21.4912, 21.476, 21.4601, 21.4448, 21.4284, 21.4124, 21.396, 21.3795, 21.3625, 21.3455,
         21.3279, 21.3103, 21.2927, 21.2746, 21.2565, 21.2378, 21.219, 21.1997, 21.1804, 21.1605, 21.1405, 21.1199,
         21.0992, 21.0783, 21.0569, 21.0347, 21.0123, 20.9892, 20.9659, 20.9422, 20.9172, 20.8924, 20.866, 20.8391,
         20.8118, 20.7833, 20.7536, 20.7231, 20.6911, 20.6582, 20.6228, 20.587, 20.5483, 20.508, 20.466, 20.4202,
         20.372, 20.321, 20.2648, 20.2046, 20.1399, 20.0672, 19.9876, 19.8981, 19.796, 19.68, 19.5433, 19.3779, 19.1704,
         18.9007, 18.5046, 17.826, 15.0049, 10.4892, 10.49, 17.819, 18.7095, 19.2403, 19.6148, 19.9118, 20.1521, 20.356,
         20.5326, 20.6881, 20.8265, 20.9492, 21.0618, 21.1643, 21.2579, 21.3428, 21.4219, 21.495, 21.5625, 21.6251,
         21.6832, 21.7371, 21.7872, 21.8339, 21.8774, 21.9184, 21.9561, 21.9916, 22.0248, 22.0559, 22.0847, 22.1117,
         22.1368, 22.1601, 22.1818, 22.2021, 22.221, 22.2384, 22.2548, 22.2698, 22.2839, 22.2967, 22.3085, 22.3195,
         22.3294, 22.3386, 22.347, 22.3546, 22.3614, 22.3676, 22.3732, 22.3781, 22.3824, 22.387, 22.3908, 22.3939,
         22.3962, 22.398, 22.3991, 22.3997, 22.3998, 22.3993, 22.3985, 22.3972, 22.3955, 22.3934, 22.3911, 22.3884,
         22.3854, 22.3822, 22.3787, 22.375, 22.3711, 22.367, 22.3628, 22.3584, 22.3538, 22.3492, 22.3444, 22.3395,
         22.3345, 22.3295, 22.3244, 22.3192, 22.314, 22.3088, 22.3035, 22.2982, 22.2929, 22.2875, 22.2822, 22.2769,
         22.2715, 22.2662, 22.2609, 22.2557, 22.2504, 22.2452, 22.24, 22.2349, 22.2298, 22.2247, 22.2197, 22.2148,
         22.2098, 22.205, 22.2002, 22.1954, 22.1907, 22.186, 22.1815, 22.1769, 22.1725, 22.1681, 22.1637, 22.1594,
         22.1552, 22.151, 22.147, 22.1429, 22.139, 22.1352, 22.1294, 22.1294],
        [1.51668, 1.54246, 1.57217, 1.60245, 1.63331, 1.66477, 1.70636, 1.75257, 1.80003, 1.84878, 1.89885, 1.95027,
         2.00309, 2.05733, 2.11278, 2.16186, 2.21207, 2.26345, 2.31602, 2.36981, 2.42485, 2.46758, 2.47959, 2.49166,
         2.50379, 2.51598, 2.52823, 2.54054, 2.55291, 2.56534, 2.57783, 2.59038, 2.60299, 2.59544, 2.58059, 2.56582,
         2.55113, 2.53653, 2.52201, 2.50758, 2.45238, 2.39274, 2.33455, 2.27777, 2.22238, 2.13794, 2.04611, 1.95823,
         1.87411, 1.79362, 1.74355, 1.72343, 1.70354, 1.68389, 1.66446, 1.64526, 1.62628, 1.60751, 1.5871, 1.56026,
         1.53387, 1.50793, 1.48243, 1.45736, 1.43271, 1.409, 1.38833, 1.36796, 1.3479, 1.32812, 1.30864, 1.28944,
         1.27053, 1.25807, 1.74955, 2.39063, 3.11958, 3.58041, 3.98257, 4.15024, 4.37954, 4.98216, 5.66771, 6.45804,
         7.60504, 8.94882, 10.1261, 11.4582, 12.9593, 14.6466, 15.5206, 16.097, 16.6949, 17.315, 17.6464, 17.9318,
         18.2218, 18.5165, 18.4909, 18.4654, 18.4399, 17.8046, 16.7626, 15.7816, 14.4915, 13.0599, 11.7698, 10.4382,
         9.25736, 8.21006, 6.92755, 5.84541, 5.40826, 5.08121, 4.77394, 4.46928, 4.07607, 3.71746, 3.50393, 3.32084,
         3.14733, 3.06314, 2.99445, 2.92729, 2.86163, 2.79745, 2.77929, 2.77917, 2.77906, 2.77894, 2.77882, 2.78337,
         2.81617, 2.84935, 2.88293, 2.9169, 2.95127, 2.98605, 3.02124, 3.03534, 3.04885, 3.06243, 3.07607, 3.08977,
         3.10353, 3.11735, 3.13123, 3.14517, 3.15695, 3.16846, 3.18001, 3.1916, 3.20323, 3.21491, 3.22663, 3.23839,
         3.25019, 3.26204, 3.2906, 3.3202, 3.35007, 3.3802, 3.41061, 3.44129, 3.47225, 3.49262, 3.50281, 3.51303,
         3.52327, 3.53356, 3.54387, 3.55421, 3.56458, 3.57498, 3.58541, 3.59587, 3.58665, 3.5726, 3.5586, 3.54465,
         3.53076, 3.51693, 3.50386, 3.49418, 3.48453, 3.47491, 3.46532, 3.45575, 3.42941, 3.39522, 3.36137, 3.32785,
         3.29468, 3.26183, 3.21578, 3.17017, 3.1252, 3.08087, 3.03718, 3.00642, 2.97771, 2.94927, 2.9211, 2.8932,
         2.86043, 2.82426, 2.78854, 2.75327, 2.71845, 2.68321, 2.64829, 2.61382, 2.5798, 2.54623, 2.51308, 2.48015,
         2.44688, 2.41405, 2.38166, 2.34971, 2.31819, 2.28709, 2.25641, 2.22613, 2.18373, 2.13716, 2.09159, 2.04699,
         2.00334, 1.96429, 1.93874, 1.91089, 1.88244, 1.85443, 1.82682, 1.79962, 1.77282, 1.74643, 1.72044, 1.7011,
         15.6413, 15.5779, 15.2909, 15.0092, 14.7327, 14.4612, 14.1947, 13.9333, 13.6767, 13.4246, 13.1769, 12.9342,
         12.6961, 12.4623, 12.6322, 12.9946, 13.3675, 13.3523, 13.0965, 12.8455, 12.5994, 12.3573, 12.1119, 11.8601,
         11.6063, 11.3574, 11.139, 10.9433, 10.754, 10.542, 10.317, 10.0969, 9.88138, 9.67034, 9.46305, 9.2575, 9.05428,
         8.85554, 8.66112, 8.47097, 8.28427, 8.10092, 7.92099, 7.74498, 7.5729, 7.40469, 7.2351, 7.06818, 6.90407,
         6.74378, 6.58736, 6.43471, 6.2868, 6.14009, 5.9945, 5.85239, 5.71366, 5.57824, 5.44597, 5.31687, 5.19086,
         5.06778, 4.94763, 4.83034, 4.71464, 4.60049, 4.48767, 4.37762, 4.27023, 4.16544, 4.06326, 3.96358, 3.86632,
         3.77151, 3.67858, 3.58726, 3.49528, 3.40531, 3.31769, 3.23231, 3.14912, 3.06806, 2.98917, 2.91228, 2.83726,
         2.7633, 2.691, 2.62044, 2.55171, 2.48476, 2.41953, 2.35602, 2.29418, 2.23398, 2.22143, 2.1751, 2.1293, 2.08332,
         2.03884, 1.99426, 1.95267, 1.90952, 1.86921, 1.82888, 1.78854, 1.75086, 1.71192, 1.67552, 1.63914, 1.60399,
         1.56893, 1.53502, 1.50126, 1.46865, 1.43711, 1.40572, 1.37541, 1.34522, 1.31608, 1.28712, 1.25912, 1.23134,
         1.20453, 1.17788, 1.15217, 1.12734, 1.10269, 1.07829, 1.05472, 1.03136, 1.00881, 0.987029, 0.964954, 0.944161,
         0.923078, 0.902742, 0.883098, 0.863657, 0.844503, 0.825983, 0.807714, 0.790032, 0.772257, 0.755473, 0.738526,
         0.722198, 0.70645, 0.690593, 0.675269, 0.660477, 0.645682, 0.631321, 0.617483, 0.603661, 0.590258, 0.577091,
         0.564173, 0.551702, 0.539415, 0.52735, 0.515511, 0.504077, 0.492674, 0.481658, 0.470848, 0.469969, 4.03619,
         3.96727, 3.89424, 3.82074, 3.749, 3.67692, 3.60667, 3.53724, 3.46858, 3.40073, 3.33376, 3.26852, 3.20335,
         3.13912, 3.07577, 3.01417, 2.95275, 2.89229, 2.83284, 2.77436, 2.71682, 2.66032, 2.60484, 2.55038, 2.49687,
         2.44372, 2.39221, 2.34116, 2.29107, 2.24148, 2.1934, 2.14578, 2.09919, 2.05355, 2.00892, 1.96482, 1.92167,
         1.87954, 1.83788, 1.79717, 1.75702, 1.71781, 1.67954, 1.64186, 1.60502, 1.56885, 1.53343, 1.49866, 1.46474,
         1.43145, 1.39861, 1.36666, 1.33555, 1.29776, 1.26095, 1.22509, 1.19016, 1.15615, 1.12303, 1.09079, 1.0594,
         1.02885, 0.999118, 0.970181, 0.942025, 0.91463, 0.887979, 0.862055, 0.836839, 0.812316, 0.788467, 0.765277,
         0.742729, 0.720808, 0.699498, 0.678783, 0.658649, 0.639081, 0.620064, 0.601584, 0.583628, 0.566181, 0.549232,
         0.532765, 0.51677, 0.501233, 0.486143, 0.471486, 0.457253, 0.443431, 0.430009, 0.416977, 0.404324, 0.392039,
         0.380113, 0.368536, 0.357298, 0.34639, 0.335802, 0.325526, 0.315553, 0.305875, 0.296483, 0.28737, 0.278527,
         0.269947, 0.261622, 0.253545, 0.24571, 0.238109, 0.230735, 0.223582, 0.216644, 0.209915, 0.203388, 0.197058,
         0.190919, 0.184965, 0.179191, 0.173592, 0.168163, 0.162899, 0.157795, 0.157321]],
    'V':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.512,
         0.5122000000000001, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.465, 5.465199999999999, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644,
         5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 5.34593, 5.25702, 5.17173, 5.07046, 4.96377, 4.86692, 4.76006, 4.64394, 4.53278, 4.4266, 4.31744, 4.20105,
         4.05589, 3.90249, 3.76549, 3.62047, 3.43543, 3.22796, 3.0396, 2.8462, 2.62105, 2.45167, 2.41724, 2.46188,
         2.61901, 2.88305, 3.1639, 3.489, 3.82533, 4.18153, 4.63608, 5.15312, 5.61764, 5.98795, 6.32329, 6.64216,
         6.95383, 7.2571, 7.56202, 7.90577, 8.26579, 8.54688, 8.77045, 8.96621, 9.15533, 9.32005, 9.43236, 9.5117,
         9.5578, 9.59663, 9.63381, 9.66939, 9.7103, 9.7474, 9.78008, 9.80759, 9.82938, 9.84564, 9.8538, 9.84883,
         9.81599, 9.7618, 9.72161, 9.70329, 9.69256, 9.68539, 9.67917, 9.67205, 9.65019, 9.62458, 9.61894, 9.62209,
         9.63112, 9.6446, 9.66165, 9.68165, 9.70413, 9.72866, 9.75481, 9.78221, 9.80685, 9.83196, 9.86498, 9.90322,
         9.94598, 9.99333, 10.0459, 10.1049, 10.1805, 10.2585, 10.3197, 10.3791, 10.4367, 10.493, 10.5487, 10.604,
         10.6596, 10.715, 10.7697, 10.8244, 10.8793, 10.9344, 10.9899, 11.0462, 11.1034, 11.1618, 11.2222, 11.285,
         11.3586, 11.4339, 11.4954, 11.5545, 11.6115, 11.667, 11.7216, 11.7757, 11.8302, 11.8867, 11.9496, 12.0096,
         12.0578, 12.1025, 12.1439, 12.1825, 12.2185, 12.2524, 12.2843, 12.3143, 12.3428, 12.37, 12.3967, 12.4245,
         12.4511, 12.4708, 12.4866, 12.4992, 12.5088, 12.5157, 12.52, 12.5217, 12.5211, 12.5183, 12.5138, 12.5093,
         12.5041, 12.4909, 12.4706, 12.4451, 12.4146, 12.379, 12.3383, 12.2925, 12.2412, 12.1844, 12.1218, 12.0537,
         11.9797, 11.8963, 11.8026, 11.6989, 11.5844, 11.4581, 11.3189, 11.1652, 10.9955, 10.8088, 10.6004, 10.3608,
         10.0876, 9.77452, 9.41175, 8.9864, 8.48336, 7.87842, 7.12309, 6.13361, 4.73516, 2.43847, -3.72361, -18.0914,
         -18.0749, 0.321069, 4.59015, 6.85921, 8.41194, 9.58295, 10.4908, 11.1288, 11.6369, 12.1773, 12.7201, 13.2814,
         13.8571, 14.4884, 15.1664, 15.829, 16.3808, 16.8128, 17.1886, 17.5478, 17.8961, 18.2364, 18.5471, 18.83,
         19.0941, 19.3418, 19.5762, 19.7987, 20.0049, 20.1955, 20.3743, 20.5431, 20.7027, 20.853, 20.9942, 21.1268,
         21.2524, 21.3737, 21.4894, 21.5953, 21.6937, 21.785, 21.8705, 21.9508, 22.0272, 22.1004, 22.1675, 22.2279,
         22.2836, 22.3351, 22.3827, 22.4268, 22.4676, 22.5054, 22.5407, 22.574, 22.6055, 22.6344, 22.6602, 22.6825,
         22.7024, 22.7199, 22.7355, 22.7493, 22.7615, 22.7726, 22.7829, 22.7928, 22.8013, 22.8058, 22.8084, 22.8095,
         22.809, 22.8072, 22.8044, 22.8006, 22.7961, 22.7912, 22.7847, 22.7769, 22.768, 22.7581, 22.7474, 22.7359,
         22.7237, 22.7108, 22.6976, 22.6847, 22.6708, 22.6562, 22.641, 22.6253, 22.6091, 22.5924, 22.5754, 22.5579,
         22.54, 22.5217, 22.5031, 22.4841, 22.4647, 22.445, 22.4249, 22.4045, 22.3838, 22.3627, 22.3413, 22.3195,
         22.2974, 22.2749, 22.2519, 22.2286, 22.2048, 22.1805, 22.1558, 22.1306, 22.1048, 22.0783, 22.0512, 22.0235,
         21.9949, 21.9655, 21.9352, 21.9038, 21.8714, 21.8377, 21.8026, 21.7659, 21.7275, 21.6872, 21.6447, 21.5997,
         21.5517, 21.5005, 21.4455, 21.3859, 21.321, 21.2497, 21.1706, 21.0819, 20.9811, 20.8645, 20.7269, 20.5597,
         20.3484, 20.0652, 19.6446, 18.8588, 11.4907, 11.4913, 16.8218, 19.3555, 20.1337, 20.6185, 20.9733, 21.2532,
         21.4838, 21.6793, 21.8483, 21.9965, 22.1277, 22.245, 22.3504, 22.4456, 22.5321, 22.6108, 22.6825, 22.7482,
         22.8083, 22.8634, 22.914, 22.9604, 23.0031, 23.0424, 23.0784, 23.1115, 23.1418, 23.1697, 23.1951, 23.2184,
         23.2397, 23.2591, 23.2767, 23.2927, 23.3072, 23.3202, 23.3319, 23.3423, 23.3517, 23.3599, 23.367, 23.3733,
         23.3786, 23.3831, 23.3868, 23.3898, 23.3921, 23.3938, 23.3949, 23.3954, 23.3954, 23.3949, 23.394, 23.3927,
         23.391, 23.3889, 23.3865, 23.3838, 23.3808, 23.3775, 23.374, 23.3703, 23.3664, 23.3623, 23.358, 23.3536,
         23.349, 23.3444, 23.3396, 23.3347, 23.3297, 23.3247, 23.3195, 23.3144, 23.3091, 23.3039, 23.2986, 23.2933,
         23.288, 23.2826, 23.2773, 23.272, 23.2666, 23.2613, 23.256, 23.2508, 23.2455, 23.2403, 23.2351, 23.23, 23.2249,
         23.2198, 23.2148, 23.2098, 23.2049, 23.2, 23.1952, 23.1904, 23.1857, 23.1811, 23.1765, 23.172, 23.1675,
         23.1631, 23.1588, 23.1551, 23.1485],
        [1.06459, 1.11805, 1.17419, 1.23315, 1.29507, 1.3601, 1.42839, 1.50012, 1.57258, 1.6378, 1.70572, 1.77646,
         1.85014, 1.92687, 1.99571, 2.05265, 2.11121, 2.17145, 2.23341, 2.29713, 2.36165, 2.42627, 2.49265, 2.55876,
         2.59175, 2.62517, 2.65901, 2.72656, 2.8079, 2.89168, 2.97795, 3.02748, 3.07315, 3.1195, 3.16654, 3.2143,
         3.26278, 3.27138, 3.25767, 3.24402, 3.23042, 3.21688, 3.2034, 3.18998, 3.16157, 3.09935, 3.03835, 2.97856,
         2.91994, 2.85252, 2.77514, 2.70011, 2.6322, 2.566, 2.50147, 2.4541, 2.41143, 2.3695, 2.32636, 2.28436, 2.24311,
         2.20261, 2.16284, 2.10127, 2.03232, 1.96563, 1.90113, 1.85597, 1.83279, 1.8099, 1.78835, 1.80095, 1.81365,
         1.82643, 1.85448, 1.90243, 1.95162, 2.00208, 2.05384, 2.1086, 2.20934, 2.31489, 2.42549, 2.54136, 2.72027,
         2.94825, 3.19535, 3.53118, 3.98741, 4.50259, 4.99383, 5.53762, 5.98055, 6.37082, 6.72872, 7.01991, 7.3237,
         7.59502, 7.76336, 7.74378, 7.72426, 7.70479, 7.68537, 7.65587, 7.61964, 7.58357, 7.54768, 7.38536, 7.18592,
         6.99185, 6.80303, 6.61931, 6.39919, 6.18624, 5.98039, 5.80479, 5.6576, 5.52309, 5.40679, 5.29293, 5.18148,
         5.07237, 4.96556, 4.861, 4.75864, 4.65361, 4.55006, 4.44882, 4.37791, 4.35426, 4.33074, 4.30734, 4.28407,
         4.26093, 4.2379, 4.21501, 4.21946, 4.23455, 4.24969, 4.26488, 4.28013, 4.29543, 4.31079, 4.32621, 4.34167,
         4.3572, 4.37277, 4.38841, 4.41221, 4.43993, 4.46783, 4.4959, 4.52415, 4.55258, 4.58118, 4.60766, 4.6058,
         4.60394, 4.60208, 4.60023, 4.59837, 4.59652, 4.59466, 4.59275, 4.58968, 4.58662, 4.58356, 4.5805, 4.57744,
         4.57438, 4.57133, 4.56828, 4.56523, 4.56218, 4.55914, 4.55609, 4.53222, 4.508, 4.48391, 4.45996, 4.43612,
         4.41242, 4.38884, 4.36539, 4.34207, 4.3146, 4.2724, 4.23059, 4.1892, 4.14821, 4.10762, 4.06744, 4.02764,
         3.98823, 3.94921, 3.91057, 3.87231, 3.83442, 3.79691, 3.75039, 3.70425, 3.65866, 3.61365, 3.56918, 3.52526,
         3.48188, 3.43904, 3.39672, 3.35492, 3.31365, 3.27287, 3.22483, 3.17394, 3.12385, 3.07454, 3.02602, 2.97826,
         2.93126, 2.885, 2.83947, 2.79466, 2.75056, 2.70715, 2.66177, 2.61498, 2.569, 2.52384, 2.47947, 2.43588,
         2.39306, 2.35099, 2.30966, 2.26906, 2.22163, 2.17464, 2.12864, 2.08362, 2.03955, 1.9977, 1.96436, 1.93158,
         1.89934, 1.86794, 1.84039, 1.81326, 1.78653, 1.77867, 15.8717, 15.6628, 15.36, 15.0633, 14.7722, 14.4866,
         14.1915, 13.9247, 13.8658, 13.861, 13.8909, 13.921, 13.9511, 13.9736, 13.9009, 13.6893, 13.3909, 13.0991,
         12.8422, 12.6122, 12.3914, 12.1551, 11.9101, 11.6697, 11.4339, 11.2027, 10.9754, 10.7472, 10.5194, 10.2965,
         10.0786, 9.86543, 9.6554, 9.44854, 9.24501, 9.04578, 8.85086, 8.66015, 8.46752, 8.27764, 8.09071, 7.90796,
         7.72935, 7.55481, 7.38414, 7.2146, 7.04604, 6.88141, 6.72063, 6.56361, 6.41028, 6.26051, 6.11422, 5.9714,
         5.83188, 5.6956, 5.56125, 5.42881, 5.29799, 5.17025, 5.04557, 4.92388, 4.80517, 4.68929, 4.57614, 4.46588,
         4.35772, 4.25132, 4.14452, 4.04004, 3.93824, 3.83887, 3.74202, 3.64769, 3.55565, 3.46595, 3.37856, 3.29215,
         3.20755, 3.12482, 3.0442, 2.96563, 2.88906, 2.81448, 2.74185, 2.67118, 2.60304, 2.53546, 2.46935, 2.40491,
         2.34206, 2.28078, 2.221, 2.16273, 2.10592, 2.05053, 1.99651, 1.94386, 1.89256, 1.84254, 1.79378, 1.74627,
         1.69998, 1.65485, 1.61086, 1.56802, 1.52627, 1.48559, 1.44595, 1.40731, 1.36968, 1.33303, 1.2973, 1.2625,
         1.22862, 1.19561, 1.16346, 1.13209, 1.10158, 1.07186, 1.04289, 1.01467, 0.987196, 0.960439, 0.934373, 0.90898,
         0.884244, 0.860151, 0.836701, 0.813824, 0.791591, 0.769884, 0.748762, 0.728215, 0.708158, 0.688645, 0.669615,
         0.65112, 0.633056, 0.615488, 0.598402, 0.581709, 0.565464, 0.549642, 0.534231, 0.51922, 0.504591, 0.490341,
         0.478268, 4.00981, 3.99813, 3.90769, 3.81866, 3.73073, 3.64405, 3.55863, 3.4745, 3.39162, 3.3101, 3.22992,
         3.15113, 3.07367, 2.99756, 2.92291, 2.84969, 2.77778, 2.70728, 2.63821, 2.57047, 2.50417, 2.43925, 2.37565,
         2.31346, 2.25257, 2.193, 2.13478, 2.07784, 2.02216, 1.96779, 1.91465, 1.86275, 1.81215, 1.76262, 1.71434,
         1.66719, 1.62121, 1.57638, 1.53265, 1.48997, 1.44835, 1.40777, 1.36822, 1.32967, 1.2921, 1.2555, 1.21984,
         1.18511, 1.15128, 1.11834, 1.08626, 1.05503, 1.02463, 0.995038, 0.96624, 0.938214, 0.910946, 0.884416,
         0.858606, 0.8335, 0.809081, 0.785334, 0.762239, 0.739784, 0.717951, 0.696726, 0.676092, 0.656036, 0.636542,
         0.617596, 0.599186, 0.581295, 0.563912, 0.547023, 0.530616, 0.514677, 0.499194, 0.484155, 0.469549, 0.455364,
         0.441589, 0.428212, 0.415224, 0.402612, 0.390369, 0.378481, 0.366942, 0.355741, 0.344868, 0.334315, 0.324072,
         0.314131, 0.304484, 0.295123, 0.286038, 0.277224, 0.268672, 0.260374, 0.252324, 0.244513, 0.236937, 0.229588,
         0.222459, 0.215544, 0.208837, 0.202332, 0.196023, 0.189905]],
    'Cr':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.574, 0.5742, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 5.9891000000000005, 5.9893, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 5.94228, 5.92909, 5.91066, 5.88584, 5.85426, 5.81498, 5.7668, 5.71465, 5.65654, 5.59119, 5.51781, 5.43535,
         5.34156, 5.23454, 5.11068, 4.95964, 4.78766, 4.61222, 4.41976, 4.20694, 3.97362, 3.73477, 3.45148, 3.15242,
         2.7975, 2.38498, 2.08271, 1.87212, 1.78945, 1.99022, 2.28007, 2.4918, 2.71114, 3.03331, 3.33199, 3.61502,
         3.9217, 4.31249, 4.66887, 5.00459, 5.34916, 5.74622, 6.19199, 6.56095, 6.89643, 7.246, 7.57809, 7.85549,
         8.09935, 8.32623, 8.5519, 8.762, 8.92629, 9.05755, 9.1524, 9.23368, 9.31173, 9.3771, 9.41811, 9.44981, 9.49426,
         9.5404, 9.58365, 9.61905, 9.63156, 9.65991, 9.69895, 9.74104, 9.78465, 9.82892, 9.8737, 9.916, 9.95535,
         9.99094, 10.0205, 10.0356, 10.0506, 10.0773, 10.1105, 10.1454, 10.1797, 10.2062, 10.2353, 10.2786, 10.3327,
         10.3946, 10.4646, 10.5453, 10.6527, 10.7479, 10.8324, 10.9144, 10.9957, 11.0781, 11.1672, 11.2537, 11.3329,
         11.4084, 11.4814, 11.5523, 11.621, 11.6855, 11.753, 11.8225, 11.8936, 11.9667, 12.0425, 12.1227, 12.2154,
         12.3185, 12.4014, 12.4721, 12.5352, 12.5919, 12.6427, 12.6869, 12.7182, 12.7453, 12.7813, 12.8212, 12.8632,
         12.9066, 12.9513, 12.9977, 13.0468, 13.1045, 13.1547, 13.1992, 13.2403, 13.2787, 13.3151, 13.3497, 13.3826,
         13.4142, 13.4455, 13.4751, 13.5024, 13.5281, 13.5526, 13.5762, 13.5998, 13.6254, 13.6546, 13.6753, 13.6883,
         13.6971, 13.7024, 13.7052, 13.7041, 13.699, 13.6904, 13.6788, 13.6649, 13.6502, 13.6403, 13.6177, 13.5822,
         13.5385, 13.4868, 13.4271, 13.3567, 13.2802, 13.1979, 13.1076, 13.008, 12.8961, 12.7722, 12.6426, 12.5059,
         12.3581, 12.1973, 12.0211, 11.8276, 11.6128, 11.3718, 11.0998, 10.791, 10.4372, 10.0234, 9.53189, 8.93605,
         8.19279, 7.22049, 5.84898, 3.6322, -1.71588, -19.0823, -19.0554, 0.236457, 5.4409, 8.01928, 9.72452, 10.9633,
         11.8856, 12.5022, 13.0405, 13.5209, 13.8513, 14.2408, 14.6876, 15.1652, 15.6739, 16.2705, 16.9638, 17.5409,
         18.0269, 18.4647, 18.8693, 19.2504, 19.6154, 19.9809, 20.3728, 20.7046, 20.9807, 21.2197, 21.421, 21.5985,
         21.7721, 21.9447, 22.1159, 22.2784, 22.4209, 22.5383, 22.6403, 22.7442, 22.847, 22.9426, 23.0314, 23.1142,
         23.1916, 23.2639, 23.3314, 23.3946, 23.4538, 23.5092, 23.5617, 23.6115, 23.6583, 23.7003, 23.7383, 23.7731,
         23.8049, 23.8341, 23.8609, 23.8859, 23.9094, 23.9323, 23.9549, 23.9742, 23.9892, 24.0007, 24.0097, 24.0164,
         24.0213, 24.0246, 24.0266, 24.0284, 24.0289, 24.0271, 24.0233, 24.0177, 24.0108, 24.0025, 23.9931, 23.9828,
         23.9712, 23.9602, 23.9489, 23.936, 23.9221, 23.9075, 23.8922, 23.8761, 23.8594, 23.8422, 23.8244, 23.8061,
         23.7873, 23.768, 23.7484, 23.7283, 23.7078, 23.687, 23.6658, 23.6443, 23.6225, 23.6003, 23.5779, 23.5551,
         23.5321, 23.5087, 23.4851, 23.4612, 23.437, 23.4125, 23.3876, 23.3625, 23.3369, 23.311, 23.2848, 23.258,
         23.2309, 23.2032, 23.175, 23.1462, 23.1168, 23.0868, 23.0559, 23.0242, 22.9916, 22.9579, 22.923, 22.8869,
         22.8493, 22.8101, 22.769, 22.7258, 22.6802, 22.6318, 22.5801, 22.5247, 22.4649, 22.3997, 22.3282, 22.2489,
         22.1598, 22.0584, 21.9407, 21.801, 21.6299, 21.4109, 21.1106, 20.6438, 19.643, 12.9181, 12.9188, 19.4157,
         20.8006, 21.4313, 21.8497, 22.1641, 22.4157, 22.6249, 22.8033, 22.958, 23.0941, 23.2149, 23.3229, 23.4201,
         23.508, 23.5878, 23.6604, 23.7267, 23.7872, 23.8426, 23.8935, 23.9401, 23.9829, 24.0222, 24.0582, 24.0913,
         24.1217, 24.1495, 24.175, 24.1982, 24.2194, 24.2388, 24.2564, 24.2724, 24.2868, 24.2999, 24.3116, 24.322,
         24.3313, 24.3396, 24.3468, 24.353, 24.3584, 24.363, 24.3668, 24.3698, 24.3722, 24.374, 24.3751, 24.3758,
         24.3759, 24.3755, 24.3748, 24.3735, 24.372, 24.37, 24.3678, 24.3652, 24.3623, 24.3592, 24.3559, 24.3523,
         24.3486, 24.3446, 24.3405, 24.3363, 24.3319, 24.3274, 24.3228, 24.318, 24.3132, 24.3084, 24.3034, 24.2984,
         24.2934, 24.2883, 24.2832, 24.278, 24.2729, 24.2677, 24.2626, 24.2574, 24.2522, 24.2471, 24.2419, 24.2368,
         24.2318, 24.2267, 24.2217, 24.2167, 24.2117, 24.2068, 24.202, 24.1971, 24.1924, 24.1876, 24.183, 24.1784,
         24.1738, 24.1694, 24.1656, 24.1584],
        [1.057, 1.10362, 1.15229, 1.20311, 1.25618, 1.31158, 1.36943, 1.42916, 1.48789, 1.54903, 1.61268, 1.67895,
         1.74794, 1.81977, 1.89455, 1.9724, 2.05236, 2.13557, 2.22215, 2.31224, 2.40598, 2.50733, 2.62058, 2.73896,
         2.86268, 2.99199, 3.0835, 3.16751, 3.25382, 3.34248, 3.43354, 3.5271, 3.59513, 3.66139, 3.72887, 3.7976,
         3.86759, 3.92324, 3.9592, 3.99549, 4.03212, 4.06908, 4.09684, 4.11996, 4.14321, 4.1666, 4.19012, 4.21377,
         4.22197, 4.21016, 4.19839, 4.18665, 4.17494, 4.16326, 4.09688, 4.02779, 3.95986, 3.89307, 3.82742, 3.76287,
         3.69941, 3.60958, 3.49735, 3.3886, 3.28324, 3.18115, 3.08224, 2.99004, 2.90494, 2.82226, 2.74194, 2.66391,
         2.58809, 2.51723, 2.45041, 2.38537, 2.32205, 2.26041, 2.19986, 2.14059, 2.08292, 2.02681, 1.9722, 1.95578,
         1.94496, 1.95116, 1.96248, 2.02151, 2.08911, 2.1752, 2.32257, 2.47993, 2.84366, 3.32968, 3.89876, 4.5651,
         5.31171, 5.65963, 6.03034, 6.42532, 6.79536, 7.05016, 7.31451, 7.58878, 7.82634, 7.96298, 8.102, 8.24346,
         8.38738, 8.39766, 8.36152, 8.32554, 8.2897, 8.15699, 8.02193, 7.88911, 7.75848, 7.63002, 7.45443, 7.27327,
         7.09652, 6.92522, 6.79165, 6.66065, 6.53218, 6.40618, 6.32254, 6.24629, 6.17096, 6.09654, 6.02301, 5.96361,
         5.92864, 5.89387, 5.85932, 5.82496, 5.79081, 5.75585, 5.71998, 5.68432, 5.64889, 5.61369, 5.57869, 5.57753,
         5.57754, 5.57756, 5.57757, 5.57758, 5.5776, 5.60496, 5.63469, 5.66458, 5.69462, 5.72483, 5.75519, 5.77467,
         5.76624, 5.75783, 5.74942, 5.74103, 5.73265, 5.72428, 5.69934, 5.67447, 5.64972, 5.62507, 5.60052, 5.57609,
         5.55414, 5.53664, 5.51919, 5.5018, 5.48446, 5.46718, 5.44995, 5.43278, 5.38959, 5.32982, 5.2707, 5.21224,
         5.15443, 5.09727, 5.04073, 4.98483, 4.94959, 4.92015, 4.89088, 4.86178, 4.83286, 4.80412, 4.77554, 4.74713,
         4.71436, 4.66923, 4.62453, 4.58026, 4.5364, 4.49297, 4.44996, 4.40736, 4.36517, 4.32337, 4.27973, 4.23643,
         4.19356, 4.15114, 4.10913, 4.06757, 4.02641, 3.97627, 3.91967, 3.86388, 3.80888, 3.75467, 3.70108, 3.64593,
         3.5916, 3.53808, 3.48536, 3.43342, 3.38225, 3.32358, 3.25457, 3.18699, 3.12082, 3.05602, 2.99257, 2.93128,
         2.87576, 2.8213, 2.76786, 2.71544, 2.66401, 2.62216, 2.58535, 2.54906, 2.51328, 2.478, 2.44321, 2.40891,
         2.37331, 2.33783, 2.30288, 2.26845, 2.23369, 2.197, 2.16092, 2.12543, 2.09052, 2.05073, 2.00951, 1.96911,
         1.92952, 1.91311, 16.9731, 16.698, 16.2158, 15.7475, 15.2927, 14.8511, 14.4222, 14.084, 13.8947, 13.7079,
         13.6002, 13.6681, 13.7363, 13.8049, 13.8739, 13.9432, 13.8818, 13.6463, 13.4147, 13.1871, 12.9633, 12.7434,
         12.5271, 12.3146, 12.075, 11.7601, 11.4535, 11.1548, 10.864, 10.6084, 10.3697, 10.1364, 9.90832, 9.66533,
         9.42121, 9.18323, 8.96464, 8.76097, 8.5591, 8.35889, 8.16331, 7.9723, 7.78577, 7.60367, 7.42578, 7.25203,
         7.08232, 6.91659, 6.75476, 6.59544, 6.4384, 6.28328, 6.13203, 5.98442, 5.84031, 5.6996, 5.56231, 5.42842,
         5.29766, 5.16918, 5.04252, 4.91365, 4.78734, 4.66424, 4.54428, 4.42741, 4.31358, 4.20273, 4.09471, 3.98944,
         3.88464, 3.78189, 3.68136, 3.58346, 3.48813, 3.39529, 3.30503, 3.21715, 3.13149, 3.04953, 2.96747, 2.88736,
         2.80927, 2.73328, 2.659, 2.5867, 2.51626, 2.44764, 2.38074, 2.31562, 2.25217, 2.1904, 2.13022, 2.07164,
         2.01462, 1.9591, 1.90508, 1.85248, 1.80129, 1.75148, 1.70302, 1.65585, 1.60998, 1.56538, 1.52199, 1.47977,
         1.43872, 1.39879, 1.35997, 1.32222, 1.28553, 1.24984, 1.21514, 1.18141, 1.14865, 1.11679, 1.08584, 1.05572,
         1.02652, 0.998083, 0.970477, 0.943626, 0.917573, 0.89224, 0.867643, 0.843758, 0.820552, 0.797991, 0.776062,
         0.754774, 0.734148, 0.714069, 0.694568, 0.675635, 0.657233, 0.639384, 0.622042, 0.605222, 0.588872, 0.573005,
         0.557598, 0.542637, 0.528113, 0.514006, 0.500319, 0.487031, 0.474127, 0.466827, 3.84485, 3.80769, 3.72069,
         3.63494, 3.55039, 3.46704, 3.38494, 3.30411, 3.22458, 3.14646, 3.0696, 2.99403, 2.91988, 2.84713, 2.77573,
         2.70561, 2.63695, 2.56957, 2.50359, 2.43897, 2.37572, 2.31377, 2.2532, 2.19383, 2.13579, 2.07909, 2.02361,
         1.96941, 1.91639, 1.86463, 1.81416, 1.76483, 1.71658, 1.66954, 1.62365, 1.57886, 1.53517, 1.49256, 1.451,
         1.41047, 1.37097, 1.33246, 1.29493, 1.25835, 1.22272, 1.188, 1.15419, 1.12126, 1.08919, 1.05796, 1.02756,
         0.997965, 0.96916, 0.941126, 0.913845, 0.8873, 0.861474, 0.83635, 0.811911, 0.788142, 0.765025, 0.742545,
         0.720686, 0.699433, 0.678772, 0.658686, 0.639163, 0.620187, 0.601744, 0.583822, 0.566407, 0.549485, 0.533044,
         0.517072, 0.501556, 0.486483, 0.471843, 0.457624, 0.443815, 0.430403, 0.417381, 0.404735, 0.392457, 0.380537,
         0.368964, 0.357729, 0.346822, 0.336236, 0.32596, 0.315987, 0.306308, 0.296914, 0.287798, 0.278952, 0.270369,
         0.26204, 0.25396, 0.246119, 0.238513, 0.231135, 0.223976, 0.217033]],
    'Mn':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.6386000000000001, 0.6387999999999999,
         0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928,
         0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274,
         0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229,
         1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147,
         1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.5389, 6.5391, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001,
         7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216,
         9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389,
         10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001,
         11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001,
         13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001,
         15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 6.5024, 6.52171, 6.53714, 6.54862, 6.55611, 6.55952, 6.5587, 6.55342, 6.54314, 6.52639, 6.50655, 6.48445,
         6.459, 6.42978, 6.39724, 6.36467, 6.32496, 6.26729, 6.19462, 6.10733, 6.00368, 5.88056, 5.73569, 5.56396,
         5.35416, 5.07923, 4.7717, 4.41786, 3.93173, 3.29552, 2.77858, 2.27583, 1.635, 1.15257, 2.00701, 3.2773,
         4.50051, 5.54117, 6.51927, 7.24311, 7.77471, 8.20129, 8.54735, 8.82762, 9.04566, 9.19693, 9.35392, 9.50102,
         9.63326, 9.74965, 9.84953, 9.92971, 9.99262, 10.0529, 10.1062, 10.149, 10.1789, 10.1882, 10.1626, 10.163,
         10.1765, 10.1918, 10.2061, 10.2159, 10.2108, 10.2151, 10.227, 10.2406, 10.2544, 10.2672, 10.2779, 10.2851,
         10.2872, 10.2798, 10.2462, 10.2127, 10.205, 10.2096, 10.2222, 10.2407, 10.264, 10.2914, 10.3222, 10.3557,
         10.3922, 10.4327, 10.477, 10.5246, 10.5756, 10.63, 10.688, 10.7501, 10.8173, 10.8934, 10.9691, 11.044, 11.12,
         11.1983, 11.2796, 11.365, 11.4562, 11.5578, 11.682, 11.7888, 11.8822, 11.9713, 12.0571, 12.1406, 12.2225,
         12.3032, 12.3832, 12.4631, 12.5456, 12.6252, 12.702, 12.7777, 12.8524, 12.9267, 13.0006, 13.0749, 13.1493,
         13.2229, 13.2958, 13.3688, 13.4421, 13.516, 13.5909, 13.6674, 13.7462, 13.8285, 13.9169, 14.0201, 14.1372,
         14.232, 14.3082, 14.3761, 14.4375, 14.4935, 14.545, 14.5924, 14.6364, 14.6775, 14.7164, 14.7552, 14.7921,
         14.8219, 14.8455, 14.8647, 14.8799, 14.8912, 14.899, 14.9032, 14.9039, 14.9012, 14.8952, 14.8859, 14.8731,
         14.8567, 14.8364, 14.8125, 14.7847, 14.7531, 14.7176, 14.6781, 14.6348, 14.588, 14.543, 14.4869, 14.4186,
         14.3412, 14.2546, 14.1583, 14.0517, 13.9336, 13.801, 13.6546, 13.4977, 13.3272, 13.1399, 12.9329, 12.7025,
         12.4439, 12.1526, 11.822, 11.4414, 10.995, 10.462, 9.811, 8.98789, 7.8916, 6.29719, 3.50844, -8.42761,
         -18.0574, -18.0426, 3.56736, 7.25819, 9.41955, 10.9601, 12.155, 13.1261, 13.9327, 14.6093, 15.0046, 15.2444,
         15.6958, 16.3817, 17.2721, 18.0296, 18.5918, 19.0745, 19.4896, 19.8572, 20.1883, 20.4999, 20.7973, 21.0774,
         21.3469, 21.6002, 21.8356, 22.0546, 22.2591, 22.4516, 22.635, 22.808, 22.9709, 23.1213, 23.2594, 23.3881,
         23.5081, 23.6204, 23.7256, 23.8242, 23.9168, 24.004, 24.0872, 24.166, 24.2403, 24.3087, 24.3709, 24.4285,
         24.482, 24.5316, 24.5777, 24.6208, 24.6616, 24.7002, 24.738, 24.7721, 24.8012, 24.8268, 24.8496, 24.87,
         24.8881, 24.9043, 24.9191, 24.9338, 24.947, 24.9573, 24.9644, 24.969, 24.9715, 24.9723, 24.9718, 24.97,
         24.9662, 24.9631, 24.9596, 24.9542, 24.9471, 24.9388, 24.9296, 24.9194, 24.9081, 24.896, 24.8831, 24.8693,
         24.8548, 24.8397, 24.8238, 24.8074, 24.7903, 24.7728, 24.7547, 24.7361, 24.717, 24.6975, 24.6776, 24.6573,
         24.6366, 24.6155, 24.5941, 24.5724, 24.5503, 24.5278, 24.505, 24.482, 24.4585, 24.4348, 24.4107, 24.3863,
         24.3616, 24.3364, 24.3109, 24.285, 24.2586, 24.2318, 24.2045, 24.1767, 24.1483, 24.1192, 24.0895, 24.059,
         24.0278, 23.9956, 23.9624, 23.9281, 23.8925, 23.8556, 23.8171, 23.7768, 23.7345, 23.69, 23.6428, 23.5925,
         23.5388, 23.481, 23.4182, 23.3496, 23.2739, 23.1894, 23.0938, 22.984, 22.8551, 22.6997, 22.5053, 22.2484,
         21.8761, 21.2225, 18.0825, 13.7573, 13.7578, 21.3097, 22.1537, 22.6533, 23.0114, 23.2908, 23.5195, 23.7123,
         23.8785, 24.0236, 24.1519, 24.2663, 24.369, 24.4617, 24.5456, 24.6219, 24.6915, 24.755, 24.8132, 24.8664,
         24.9152, 24.96, 25.0011, 25.0389, 25.0735, 25.1052, 25.1344, 25.1611, 25.1855, 25.2078, 25.2281, 25.2466,
         25.2634, 25.2786, 25.2924, 25.3048, 25.3158, 25.3257, 25.3345, 25.3422, 25.3489, 25.3547, 25.3597, 25.3638,
         25.3672, 25.3699, 25.3719, 25.3734, 25.3742, 25.3746, 25.3744, 25.3738, 25.3728, 25.3713, 25.3695, 25.3674,
         25.3649, 25.3622, 25.3591, 25.3559, 25.3524, 25.3486, 25.3447, 25.3407, 25.3364, 25.3321, 25.3276, 25.3229,
         25.3182, 25.3134, 25.3085, 25.3036, 25.2985, 25.2935, 25.2883, 25.2832, 25.278, 25.2728, 25.2676, 25.2624,
         25.2572, 25.252, 25.2468, 25.2416, 25.2364, 25.2313, 25.2262, 25.2211, 25.216, 25.211, 25.206, 25.2011,
         25.1962, 25.1915, 25.1875, 25.1795],
        [1.8899, 1.92644, 1.96368, 2.00165, 2.04035, 2.0798, 2.12001, 2.161, 2.20278, 2.24537, 2.28879, 2.33304,
         2.37676, 2.4213, 2.46667, 2.51289, 2.55998, 2.60796, 2.65683, 2.70662, 2.75734, 2.80901, 2.86165, 2.91527,
         2.96991, 3.02556, 3.08226, 3.14002, 3.19886, 3.2588, 3.31987, 3.38209, 3.44217, 3.48884, 3.53615, 3.58409,
         3.63268, 3.68194, 3.73186, 3.78246, 3.83374, 3.85544, 3.87253, 3.8897, 3.90694, 3.92427, 3.94166, 3.95914,
         3.97669, 3.99432, 4.01203, 4.0003, 3.97304, 3.94596, 3.91906, 3.89235, 3.86582, 3.83947, 3.8133, 3.78323,
         3.72987, 3.67726, 3.62539, 3.57425, 3.52383, 3.47413, 3.42513, 3.37693, 3.32983, 3.28339, 3.23759, 3.19243,
         3.14791, 3.104, 3.0607, 3.01801, 2.9769, 2.94108, 2.90568, 2.87072, 2.83618, 2.80205, 2.76833, 2.71646,
         2.66435, 2.61324, 2.56311, 2.51394, 2.46597, 2.4214, 2.37764, 2.33467, 2.30245, 2.33906, 2.37625, 2.41403,
         2.7447, 3.25644, 3.86359, 4.58393, 6.20992, 8.3674, 8.94377, 9.43837, 9.46, 9.3757, 9.05133, 8.73819, 8.43393,
         8.1393, 7.85497, 7.58057, 7.35293, 7.16484, 6.98157, 6.80299, 6.62897, 6.4594, 6.29418, 6.14892, 6.01221,
         5.87852, 5.74781, 5.62, 5.49504, 5.40548, 5.34635, 5.28786, 5.23001, 5.1728, 5.1162, 5.06786, 5.03821, 5.00872,
         4.9794, 4.95026, 4.92129, 4.89248, 4.86385, 4.83538, 4.80708, 4.77895, 4.80833, 4.84354, 4.87899, 4.91472,
         4.9507, 4.98695, 5.02345, 5.06023, 5.09728, 5.13662, 5.17671, 5.21712, 5.25785, 5.29889, 5.34025, 5.38194,
         5.42395, 5.46629, 5.5066, 5.53684, 5.56727, 5.59785, 5.6286, 5.65952, 5.69061, 5.72187, 5.75331, 5.76483,
         5.75371, 5.74262, 5.73156, 5.72051, 5.70948, 5.69848, 5.6875, 5.67653, 5.66559, 5.65301, 5.63644, 5.61993,
         5.60345, 5.58703, 5.57066, 5.55434, 5.53806, 5.52017, 5.50172, 5.48333, 5.465, 5.44674, 5.42853, 5.41039,
         5.3923, 5.37429, 5.35632, 5.33842, 5.32057, 5.26706, 5.19443, 5.1228, 5.05216, 4.98249, 4.91378, 4.84602,
         4.7792, 4.71329, 4.6483, 4.5842, 4.52098, 4.45086, 4.37922, 4.30873, 4.23938, 4.17114, 4.104, 4.03795, 3.97296,
         3.90901, 3.84609, 3.78419, 3.72328, 3.66298, 3.6035, 3.54499, 3.48742, 3.4308, 3.37508, 3.32028, 3.26636,
         3.21332, 3.16114, 3.10587, 3.04259, 2.98059, 2.91986, 2.86037, 2.80209, 2.745, 2.68907, 2.63428, 2.586,
         2.54166, 2.49807, 2.45524, 2.41314, 2.37176, 2.33115, 2.29292, 2.25534, 2.21646, 2.17739, 2.13934, 2.10212,
         2.06565, 2.02981, 1.9946, 1.95999, 1.92599, 1.92371, 16.5984, 16.3194, 16.0192, 15.7245, 15.4352, 15.1512,
         14.8725, 14.587, 14.2976, 13.967, 13.9671, 14.2068, 14.4506, 14.3998, 14.105, 13.7795, 13.4617, 13.1513,
         12.861, 12.5903, 12.3369, 12.0887, 11.8456, 11.6073, 11.3636, 11.1225, 10.8843, 10.6513, 10.4227, 10.1985,
         9.97462, 9.75224, 9.5312, 9.31505, 9.10383, 8.89743, 8.69577, 8.49864, 8.30594, 8.11769, 7.9337, 7.75385,
         7.57626, 7.40089, 7.22735, 7.05785, 6.89231, 6.73065, 6.57273, 6.41852, 6.26798, 6.12099, 5.97676, 5.83489,
         5.69216, 5.55236, 5.41601, 5.28314, 5.15347, 5.02684, 4.90343, 4.7831, 4.66575, 4.54758, 4.43117, 4.31685,
         4.20548, 4.09702, 3.99146, 3.88854, 3.78823, 3.69045, 3.59707, 3.50268, 3.41037, 3.32011, 3.23221, 3.1464,
         3.06252, 2.9807, 2.90088, 2.82302, 2.74705, 2.673, 2.60077, 2.53038, 2.46175, 2.39486, 2.32969, 2.26618,
         2.20433, 2.14406, 2.08536, 2.0282, 1.97256, 1.91837, 1.86562, 1.81427, 1.76427, 1.71563, 1.66829, 1.62224,
         1.57744, 1.53385, 1.49147, 1.45022, 1.41011, 1.3711, 1.33316, 1.29628, 1.26044, 1.22557, 1.19169, 1.15878,
         1.12676, 1.09562, 1.0654, 1.03601, 1.00747, 0.979721, 0.952745, 0.926585, 0.901138, 0.876412, 0.852412,
         0.829086, 0.806453, 0.784456, 0.763123, 0.742345, 0.722213, 0.702659, 0.683674, 0.665236, 0.647339, 0.629964,
         0.613093, 0.596717, 0.580824, 0.565389, 0.550414, 0.535881, 0.521775, 0.508081, 0.494788, 0.481891, 0.481234,
         3.8759, 3.7917, 3.70472, 3.61897, 3.53438, 3.45107, 3.36899, 3.28831, 3.20892, 3.13076, 3.05404, 2.97871,
         2.90471, 2.83205, 2.76082, 2.69094, 2.62248, 2.55531, 2.48948, 2.42505, 2.36203, 2.30031, 2.23986, 2.18076,
         2.12295, 2.06653, 2.01123, 1.95725, 1.90452, 1.853, 1.80269, 1.75357, 1.70562, 1.65882, 1.61315, 1.56859,
         1.52512, 1.48273, 1.44138, 1.40108, 1.36178, 1.32349, 1.28616, 1.2498, 1.21436, 1.17985, 1.14623, 1.11349,
         1.08161, 1.05057, 1.02036, 0.990942, 0.962313, 0.934454, 0.907344, 0.880966, 0.855305, 0.830341, 0.80606,
         0.782444, 0.759478, 0.737146, 0.715431, 0.69432, 0.673796, 0.653846, 0.634455, 0.615608, 0.597292, 0.579493,
         0.562198, 0.545393, 0.529067, 0.513206, 0.497799, 0.482833, 0.468296, 0.454179, 0.440468, 0.427153, 0.414224,
         0.40167, 0.389481, 0.377647, 0.366158, 0.355006, 0.34418, 0.333671, 0.323471, 0.313572, 0.303965, 0.294641,
         0.285593, 0.276814, 0.268295, 0.260029]],
    'Fe':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.7067, 0.7069, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.1118999999999994, 7.112100000000001, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 4.56551, 4.59674, 4.62389, 4.64752, 4.66794, 4.68534, 4.69985, 4.71157, 4.72056, 4.72726, 4.73253,
         4.73284, 4.72873, 4.72057, 4.70833, 4.69185, 4.67095, 4.6454, 4.61496, 4.57945, 4.53898, 4.49519, 4.4417,
         4.37564, 4.29742, 4.20634, 4.1008, 3.97865, 3.83697, 3.67191, 3.47817, 3.24835, 2.97172, 2.63237, 2.19808,
         1.60564, 0.746053, -0.823081, -3.48492, -2.28294, -0.253217, 1.29776, 2.40276, 3.54172, 4.53869, 5.32958,
         6.03752, 6.55392, 6.93943, 7.23531, 7.45267, 7.58608, 7.58843, 7.59044, 7.64565, 7.70968, 7.76921, 7.81595,
         7.83798, 7.79781, 7.80545, 7.84188, 7.893, 7.95279, 8.01851, 8.0885, 8.16154, 8.23668, 8.31282, 8.3874,
         8.46471, 8.54659, 8.63178, 8.71938, 8.80911, 8.90086, 8.99454, 9.09017, 9.18782, 9.28776, 9.39101, 9.49649,
         9.60195, 9.70842, 9.8164, 9.92628, 10.0384, 10.1533, 10.2717, 10.3951, 10.528, 10.6739, 10.8068, 10.9332,
         11.0565, 11.1781, 11.2989, 11.4196, 11.5409, 11.6638, 11.7907, 11.9278, 12.0547, 12.1758, 12.2937, 12.4094,
         12.5237, 12.6369, 12.7495, 12.8619, 12.9745, 13.0877, 13.202, 13.3183, 13.4377, 13.5621, 13.6963, 13.8601,
         14.0038, 14.1251, 14.2321, 14.3296, 14.4192, 14.5017, 14.5772, 14.6454, 14.7045, 14.7449, 14.7884, 14.8416,
         14.9009, 14.9627, 15.0264, 15.0917, 15.1585, 15.2269, 15.2972, 15.3702, 15.4469, 15.5294, 15.641, 15.7338,
         15.8063, 15.871, 15.9298, 15.9839, 16.0341, 16.0811, 16.1256, 16.1683, 16.2101, 16.2525, 16.3098, 16.3581,
         16.3869, 16.4048, 16.4142, 16.416, 16.4107, 16.398, 16.3707, 16.3387, 16.317, 16.3037, 16.2822, 16.2534,
         16.2191, 16.1797, 16.1354, 16.0859, 16.0312, 15.9711, 15.9052, 15.8333, 15.755, 15.6698, 15.5777, 15.4771,
         15.3672, 15.2475, 15.1169, 14.9742, 14.8181, 14.6466, 14.4577, 14.2486, 14.0158, 13.7542, 13.4583, 13.1273,
         12.7523, 12.3194, 11.8093, 11.1915, 10.4155, 9.39778, 7.96562, 5.65397, -0.051255, -17.9878, -17.9717, 2.56129,
         7.51167, 10.0375, 11.7441, 13.018, 14.0079, 14.7737, 15.2522, 15.7357, 16.301, 16.9294, 17.6531, 18.4917,
         19.1933, 19.7329, 20.2084, 20.6272, 21.0059, 21.3544, 21.678, 21.9801, 22.2623, 22.5278, 22.7773, 23.0123,
         23.2295, 23.4294, 23.6157, 23.7895, 23.9522, 24.1046, 24.2478, 24.3825, 24.5096, 24.6313, 24.7468, 24.8564,
         24.9571, 25.0487, 25.1338, 25.2129, 25.2865, 25.3551, 25.4192, 25.4798, 25.5369, 25.592, 25.6426, 25.6872,
         25.7275, 25.7642, 25.7977, 25.8282, 25.8563, 25.8823, 25.9076, 25.9308, 25.9507, 25.9667, 25.9797, 25.9902,
         25.9985, 26.0049, 26.0098, 26.0124, 26.0153, 26.0175, 26.0174, 26.0155, 26.0122, 26.0074, 26.0014, 25.9942,
         25.986, 25.9766, 25.9662, 25.9549, 25.9428, 25.9299, 25.9162, 25.9018, 25.8866, 25.8709, 25.8546, 25.8377,
         25.8202, 25.8023, 25.7839, 25.765, 25.7457, 25.726, 25.7059, 25.6855, 25.6647, 25.6436, 25.6221, 25.6003,
         25.5782, 25.5559, 25.5332, 25.5102, 25.4869, 25.4632, 25.4393, 25.4151, 25.3905, 25.3655, 25.3402, 25.3145,
         25.2884, 25.2619, 25.2348, 25.2073, 25.1792, 25.1505, 25.1211, 25.091, 25.0601, 25.0283, 24.9955, 24.9617,
         24.9266, 24.8902, 24.8522, 24.8126, 24.771, 24.7271, 24.6808, 24.6315, 24.5789, 24.5222, 24.4609, 24.394,
         24.3204, 24.2384, 24.146, 24.0402, 23.9168, 23.7691, 23.5861, 23.3481, 23.0124, 22.4591, 20.9344, 14.7513,
         14.7518, 22.0197, 23.0311, 23.5788, 23.9595, 24.2518, 24.4888, 24.6873, 24.8575, 25.0058, 25.1364, 25.2527,
         25.3569, 25.4507, 25.5355, 25.6126, 25.6829, 25.7468, 25.8054, 25.859, 25.9081, 25.9532, 25.9946, 26.0325,
         26.0673, 26.0992, 26.1284, 26.1552, 26.1797, 26.202, 26.2224, 26.241, 26.2578, 26.273, 26.2868, 26.2992,
         26.3103, 26.3202, 26.3289, 26.3366, 26.3433, 26.3491, 26.354, 26.3582, 26.3616, 26.3642, 26.3663, 26.3677,
         26.3685, 26.3689, 26.3687, 26.3681, 26.367, 26.3655, 26.3637, 26.3616, 26.3591, 26.3563, 26.3533, 26.35,
         26.3465, 26.3428, 26.3389, 26.3348, 26.3305, 26.3261, 26.3216, 26.317, 26.3123, 26.3075, 26.3026, 26.2976,
         26.2926, 26.2875, 26.2824, 26.2772, 26.272, 26.2668, 26.2616, 26.2564, 26.2512, 26.246, 26.2408, 26.2356,
         26.2304, 26.2253, 26.2202, 26.2151, 26.21, 26.205, 26.2],
        [1.37852, 1.42961, 1.48259, 1.53754, 1.59453, 1.65362, 1.71491, 1.77847, 1.84438, 1.91274, 1.97402, 2.01044,
         2.04752, 2.08529, 2.12375, 2.16292, 2.20282, 2.24345, 2.28484, 2.32698, 2.3699, 2.41362, 2.45814, 2.50348,
         2.54966, 2.59669, 2.64458, 2.69337, 2.73188, 2.75688, 2.78211, 2.80756, 2.83325, 2.85918, 2.88534, 2.91174,
         2.93838, 2.96261, 2.97951, 2.9965, 3.01359, 3.03078, 3.04806, 3.06544, 3.08293, 3.10051, 3.11819, 3.13597,
         3.15386, 3.17184, 3.18993, 3.19901, 3.20529, 3.21159, 3.21789, 3.22421, 3.23054, 3.23689, 3.24324, 3.24961,
         3.25599, 3.26239, 3.26879, 3.27521, 3.28164, 3.28184, 3.26361, 3.24547, 3.22745, 3.20951, 3.19168, 3.17395,
         3.15632, 3.13878, 3.12135, 3.10401, 3.08676, 3.06821, 3.04783, 3.02759, 3.00747, 2.9875, 2.96765, 2.94794,
         2.92835, 2.90891, 2.88958, 2.87039, 2.85002, 2.82162, 2.79349, 2.76565, 2.73809, 2.71079, 2.68377, 2.65703,
         2.63054, 2.60433, 2.57837, 2.55267, 2.52664, 2.49588, 2.4655, 2.4995, 2.57469, 4.80517, 9.28509, 9.98238,
         10.4549, 10.7076, 10.9275, 10.685, 10.4478, 10.1122, 9.71669, 9.33663, 8.97142, 8.6205, 8.28332, 7.97015,
         7.86267, 7.75663, 7.65203, 7.54883, 7.44703, 7.3466, 7.28864, 7.30616, 7.32372, 7.34133, 7.35898, 7.37667,
         7.3944, 7.41218, 7.43, 7.44786, 7.46624, 7.49275, 7.51936, 7.54607, 7.57286, 7.59976, 7.62675, 7.65383,
         7.68101, 7.70829, 7.73567, 7.76314, 7.78722, 7.81049, 7.83383, 7.85724, 7.88073, 7.90428, 7.92791, 7.9516,
         7.97537, 7.99921, 8.00625, 7.99853, 7.99083, 7.98313, 7.97544, 7.96776, 7.96008, 7.95241, 7.94475, 7.9371,
         7.92106, 7.89217, 7.86339, 7.83471, 7.80615, 7.77768, 7.74932, 7.72106, 7.6929, 7.66485, 7.6369, 7.60905,
         7.5813, 7.55366, 7.52611, 7.49867, 7.46087, 7.36866, 7.2776, 7.18766, 7.09884, 7.01111, 6.92446, 6.83889,
         6.75437, 6.6709, 6.58963, 6.54414, 6.49896, 6.4541, 6.40954, 6.36529, 6.32135, 6.27771, 6.23437, 6.19133,
         6.14859, 6.10615, 6.06399, 6.01084, 5.92255, 5.83556, 5.74984, 5.66539, 5.58217, 5.50018, 5.4194, 5.33979,
         5.26136, 5.18408, 5.10794, 5.03291, 4.9238, 4.81616, 4.71086, 4.60787, 4.50713, 4.40859, 4.31221, 4.21793,
         4.1449, 4.07954, 4.00915, 3.92917, 3.8508, 3.77398, 3.6987, 3.62491, 3.5526, 3.48174, 3.41228, 3.34421, 3.2775,
         3.21212, 3.14804, 3.08503, 3.02269, 2.9616, 2.90175, 2.8431, 2.78564, 2.72935, 2.67418, 2.62014, 2.56719,
         2.5153, 2.46447, 2.41999, 2.37973, 2.34017, 2.30104, 2.25957, 2.21452, 2.16757, 2.12164, 2.08255, 2.04874,
         2.01713, 2.00516, 17.0241, 16.8005, 16.434, 16.0756, 15.7252, 15.3828, 15.048, 14.7261, 14.4327, 14.5066,
         14.5809, 14.6555, 14.7305, 14.5915, 14.2652, 13.9465, 13.6347, 13.3297, 13.0418, 12.763, 12.4928, 12.228,
         11.9685, 11.714, 11.4617, 11.2106, 10.9604, 10.7157, 10.4765, 10.2426, 10.0139, 9.79036, 9.57181, 9.35813,
         9.14919, 8.94492, 8.7424, 8.54142, 8.34135, 8.14613, 7.95544, 7.76913, 7.58714, 7.40943, 7.23595, 7.06656,
         6.90047, 6.73728, 6.57391, 6.41399, 6.25803, 6.10583, 5.95731, 5.81239, 5.67104, 5.53311, 5.39847, 5.26344,
         5.13051, 4.9999, 4.87266, 4.74866, 4.62785, 4.51012, 4.39537, 4.2835, 4.17638, 4.06827, 3.96272, 3.85956,
         3.75885, 3.66043, 3.56442, 3.47073, 3.37928, 3.28988, 3.20281, 3.11785, 3.03494, 2.95409, 2.87525, 2.79837,
         2.7234, 2.65034, 2.57909, 2.50966, 2.44201, 2.37611, 2.31186, 2.24928, 2.18831, 2.12895, 2.0711, 2.01476,
         1.9599, 1.9065, 1.85449, 1.80385, 1.75456, 1.70657, 1.65983, 1.61438, 1.57013, 1.52704, 1.48515, 1.44434,
         1.40465, 1.36603, 1.32847, 1.2919, 1.25636, 1.22173, 1.18809, 1.15533, 1.12346, 1.09249, 1.06239, 1.03305,
         1.00457, 0.976873, 0.949891, 0.923701, 0.898161, 0.873392, 0.849294, 0.825838, 0.803057, 0.780872, 0.759346,
         0.738385, 0.718011, 0.698203, 0.678946, 0.660221, 0.642017, 0.624321, 0.607117, 0.59039, 0.574125, 0.558319,
         0.542948, 0.528004, 0.513483, 0.499359, 0.485638, 0.48177, 3.85592, 3.79269, 3.70552, 3.61951, 3.53462,
         3.45114, 3.36893, 3.28802, 3.20844, 3.13021, 3.05334, 2.97792, 2.90374, 2.83104, 2.75967, 2.68982, 2.62115,
         2.55398, 2.48817, 2.42376, 2.36063, 2.29898, 2.23854, 2.17943, 2.12163, 2.06511, 2.00987, 1.95589, 1.90315,
         1.85164, 1.80133, 1.75222, 1.70428, 1.65749, 1.61183, 1.56728, 1.52383, 1.48146, 1.44014, 1.39985, 1.36058,
         1.32231, 1.28501, 1.24866, 1.21326, 1.17877, 1.14518, 1.11246, 1.08061, 1.0496, 1.01941, 0.990019, 0.961418,
         0.933585, 0.906501, 0.88015, 0.854515, 0.829578, 0.805322, 0.781732, 0.758791, 0.736483, 0.714793, 0.693706,
         0.673206, 0.653279, 0.63391, 0.615086, 0.596791, 0.579014, 0.561739, 0.544955, 0.528649, 0.512808, 0.49742,
         0.482472, 0.467954, 0.453854, 0.44016, 0.426862, 0.413949, 0.401411, 0.389237, 0.377418, 0.365944, 0.354805,
         0.343992, 0.333497, 0.32331, 0.313422, 0.303827]],
    'Co':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.778, 0.7782,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.7088,
         7.709, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.98251, 4.05081, 4.11438, 4.17442, 4.23178, 4.28723, 4.34162, 4.39819, 4.46159, 4.51057, 4.55107,
         4.58579, 4.61516, 4.63925, 4.65765, 4.6684, 4.67446, 4.6806, 4.68468, 4.68556, 4.68276, 4.67585, 4.66434,
         4.6478, 4.62611, 4.59855, 4.5644, 4.5228, 4.47271, 4.41279, 4.34177, 4.25782, 4.1582, 4.0387, 3.89204, 3.71361,
         3.50455, 3.23145, 2.92456, 2.57871, 2.12007, 1.50781, 0.481044, -0.1355, -0.34801, 0.174934, 1.78564, 3.05037,
         4.17887, 4.9412, 5.47262, 5.92047, 6.30138, 6.62307, 6.89114, 7.09757, 7.29107, 7.46632, 7.61756, 7.73533,
         7.78707, 7.84123, 7.9343, 8.04089, 8.15364, 8.26945, 8.38656, 8.5038, 8.62013, 8.73391, 8.84008, 8.94302,
         9.05732, 9.17802, 9.30336, 9.43302, 9.56727, 9.70715, 9.85558, 10.0244, 10.1821, 10.3289, 10.4696, 10.607,
         10.7419, 10.8751, 11.0068, 11.1375, 11.2674, 11.3967, 11.5256, 11.6533, 11.7689, 11.9243, 12.0791, 12.2209,
         12.3553, 12.4862, 12.6147, 12.7416, 12.8674, 12.9926, 13.1175, 13.243, 13.3705, 13.5036, 13.6377, 13.7723,
         13.8973, 14.0167, 14.1323, 14.2453, 14.3562, 14.4657, 14.5745, 14.6835, 14.7947, 14.9086, 15.0162, 15.1183,
         15.217, 15.3136, 15.4098, 15.506, 15.5988, 15.6864, 15.77, 15.851, 15.93, 16.0073, 16.084, 16.1614, 16.2354,
         16.3059, 16.3725, 16.4364, 16.4982, 16.5584, 16.6191, 16.6779, 16.7327, 16.7839, 16.8323, 16.8782, 16.9227,
         16.9655, 17.0068, 17.0446, 17.0793, 17.1115, 17.1425, 17.1715, 17.1982, 17.2218, 17.2424, 17.2606, 17.2774,
         17.2919, 17.3031, 17.3113, 17.317, 17.3207, 17.3215, 17.3194, 17.314, 17.3059, 17.2949, 17.2809, 17.2631,
         17.2417, 17.2172, 17.1889, 17.1565, 17.12, 17.08, 17.0355, 16.9852, 16.9291, 16.8673, 16.799, 16.7243, 16.6431,
         16.5558, 16.4622, 16.3607, 16.2478, 16.1236, 15.9881, 15.8401, 15.6779, 15.4994, 15.3028, 15.0847, 14.8396,
         14.5596, 14.2376, 13.8651, 13.4352, 12.9326, 12.3259, 11.5647, 10.5677, 9.16323, 6.88403, 1.20092, -16.6697,
         -16.6574, 3.90051, 8.67726, 11.1424, 12.829, 14.1115, 15.1447, 16.0019, 16.6975, 17.1236, 17.357, 17.8034,
         18.5118, 19.4683, 20.2571, 20.818, 21.3022, 21.7151, 22.092, 22.4506, 22.7802, 23.0822, 23.3617, 23.6214,
         23.8631, 24.0885, 24.2994, 24.4972, 24.683, 24.8598, 25.027, 25.1851, 25.3313, 25.4657, 25.591, 25.708,
         25.8174, 25.92, 26.0164, 26.1075, 26.1938, 26.2768, 26.3539, 26.4236, 26.4877, 26.5469, 26.6019, 26.653,
         26.7009, 26.7462, 26.7908, 26.8324, 26.8694, 26.901, 26.9286, 26.9528, 26.9741, 26.9926, 27.0089, 27.0223,
         27.0361, 27.0488, 27.0585, 27.0657, 27.0705, 27.0737, 27.0751, 27.0748, 27.0729, 27.0695, 27.0647, 27.0586,
         27.0513, 27.0429, 27.0333, 27.0227, 27.0112, 26.9987, 26.9854, 26.9713, 26.9564, 26.9409, 26.9247, 26.9078,
         26.8904, 26.8724, 26.8539, 26.8349, 26.8155, 26.7956, 26.7753, 26.7546, 26.7336, 26.7122, 26.6904, 26.6684,
         26.646, 26.6233, 26.6004, 26.5771, 26.5535, 26.5297, 26.5055, 26.481, 26.4563, 26.4312, 26.4058, 26.38,
         26.3539, 26.3273, 26.3004, 26.273, 26.2451, 26.2166, 26.1876, 26.158, 26.1276, 26.0965, 26.0646, 26.0317,
         25.9978, 25.9627, 25.9263, 25.8884, 25.8489, 25.8075, 25.7639, 25.7179, 25.6691, 25.617, 25.561, 25.5005,
         25.4345, 25.3619, 25.2813, 25.1905, 25.0868, 24.9658, 24.8212, 24.6425, 24.4103, 24.0838, 23.5486, 22.1136,
         15.8795, 15.8799, 23.0649, 24.0784, 24.6213, 24.9974, 25.2857, 25.519, 25.7143, 25.8816, 26.0272, 26.1555,
         26.2696, 26.3717, 26.4637, 26.5469, 26.6223, 26.6909, 26.7536, 26.8109, 26.8633, 26.9113, 26.9553, 26.9956,
         27.0326, 27.0665, 27.0976, 27.126, 27.152, 27.1758, 27.1975, 27.2173, 27.2353, 27.2516, 27.2664, 27.2797,
         27.2916, 27.3023, 27.3118, 27.3203, 27.3276, 27.3341, 27.3396, 27.3443, 27.3482, 27.3513, 27.3538, 27.3557,
         27.3569, 27.3576, 27.3578, 27.3575, 27.3568, 27.3556, 27.3541, 27.3522, 27.35, 27.3474, 27.3446, 27.3416,
         27.3382, 27.3347, 27.331, 27.3271, 27.323, 27.3188, 27.3144, 27.3099, 27.3053, 27.3006, 27.2958, 27.2909,
         27.286, 27.281, 27.276, 27.2709, 27.2658, 27.2607, 27.2555, 27.2504, 27.2452, 27.2401, 27.2349, 27.2298,
         27.2248, 27.2208, 27.2113],
        [1.42071, 1.45925, 1.49884, 1.53949, 1.58125, 1.62415, 1.6682, 1.71345, 1.75993, 1.80767, 1.85671, 1.90707,
         1.94682, 1.986, 2.02596, 2.06674, 2.10833, 2.15076, 2.19404, 2.23819, 2.28323, 2.32918, 2.37605, 2.42371,
         2.47199, 2.52123, 2.57146, 2.62268, 2.67492, 2.72821, 2.78255, 2.83798, 2.89452, 2.95217, 3.00203, 3.04455,
         3.08768, 3.13142, 3.17578, 3.22076, 3.26639, 3.31266, 3.35958, 3.407, 3.45166, 3.4969, 3.54274, 3.58917,
         3.63622, 3.68388, 3.73217, 3.78109, 3.83065, 3.88086, 3.93173, 3.98327, 4.02721, 4.06435, 4.10183, 4.13966,
         4.17784, 4.21637, 4.25526, 4.2945, 4.33411, 4.36366, 4.35857, 4.35348, 4.3484, 4.34333, 4.33826, 4.3332,
         4.32814, 4.32308, 4.31804, 4.302, 4.2771, 4.25234, 4.22773, 4.20326, 4.17893, 4.15473, 4.13069, 4.11592,
         4.10181, 4.08775, 4.07374, 4.05977, 4.04586, 4.03199, 4.01853, 4.00528, 3.99206, 3.97889, 3.96576, 3.95268,
         3.93968, 3.92725, 3.91487, 3.90252, 3.89021, 3.87794, 3.8793, 3.88547, 3.89869, 3.99062, 4.08473, 4.21666,
         4.40344, 5.0465, 6.26867, 7.78683, 9.67273, 10.6537, 11.0491, 10.944, 10.695, 10.4722, 10.2757, 10.0828,
         9.89349, 9.70777, 9.54202, 9.40958, 9.27899, 9.1502, 9.02321, 8.89986, 8.89839, 8.89692, 8.89545, 8.89397,
         8.89251, 8.89103, 8.88957, 8.8881, 8.88663, 8.88516, 8.90185, 8.92456, 8.94731, 8.97014, 8.99301, 9.01595,
         9.03894, 9.06199, 9.07617, 9.05984, 9.04353, 9.02726, 9.01102, 8.99479, 8.9786, 8.96245, 8.94633, 8.93022,
         8.91415, 8.89811, 8.8821, 8.8766, 8.88791, 8.85118, 8.81453, 8.77804, 8.74172, 8.70559, 8.66963, 8.63379,
         8.59804, 8.5624, 8.5271, 8.49188, 8.45677, 8.40911, 8.356, 8.29584, 8.23602, 8.17663, 8.11767, 8.05921,
         8.00118, 7.94357, 7.88632, 7.82754, 7.76516, 7.69306, 7.62172, 7.5511, 7.481, 7.41066, 7.33987, 7.26183,
         7.18423, 7.10747, 7.03172, 6.9567, 6.88236, 6.80889, 6.73346, 6.6555, 6.57587, 6.4969, 6.41891, 6.34175,
         6.26551, 6.19016, 6.1107, 6.0307, 5.95119, 5.87252, 5.79487, 5.71831, 5.64128, 5.56394, 5.48605, 5.40904,
         5.33316, 5.25852, 5.18298, 5.10762, 5.03229, 4.95793, 4.88464, 4.81243, 4.73913, 4.66642, 4.59458, 4.52385,
         4.45374, 4.38367, 4.31398, 4.2451, 4.17733, 4.10964, 4.04263, 3.9759, 3.91023, 3.84546, 3.7809, 3.71717,
         3.65438, 3.59262, 3.53009, 3.46797, 3.40695, 3.34701, 3.28828, 3.23115, 3.17612, 3.12257, 3.06998, 3.01558,
         2.96112, 2.90927, 2.85882, 2.80954, 2.76106, 2.71346, 2.66656, 2.61848, 2.56838, 2.51737, 2.46741, 2.42381,
         2.38506, 2.34779, 2.30698, 2.26406, 2.22189, 2.18051, 2.13989, 2.10004, 2.08534, 16.7554, 16.5665, 16.2618,
         15.9628, 15.6692, 15.3809, 15.0988, 14.7991, 14.485, 14.165, 14.1281, 14.3979, 14.6728, 14.6303, 14.2814,
         13.9412, 13.6122, 13.2943, 13.0136, 12.734, 12.4548, 12.1819, 11.9149, 11.6539, 11.3984, 11.1486, 10.9043,
         10.6653, 10.4315, 10.2029, 9.97641, 9.75168, 9.52808, 9.30975, 9.0964, 8.88787, 8.68415, 8.48511, 8.29065,
         8.10059, 7.91422, 7.73112, 7.54775, 7.36808, 7.19261, 7.02142, 6.8543, 6.69118, 6.53201, 6.37659, 6.2248,
         6.07119, 5.91959, 5.77049, 5.62517, 5.48347, 5.34528, 5.21058, 5.07932, 4.95148, 4.82906, 4.70487, 4.58352,
         4.46456, 4.34837, 4.23509, 4.12425, 4.01592, 3.91018, 3.80684, 3.70609, 3.60755, 3.51169, 3.41789, 3.32645,
         3.23728, 3.15031, 3.06547, 2.98278, 2.90213, 2.82354, 2.74695, 2.67229, 2.59956, 2.52868, 2.45962, 2.39238,
         2.32686, 2.26306, 2.20096, 2.14049, 2.0816, 2.02426, 1.96845, 1.91417, 1.86131, 1.80987, 1.75983, 1.71112,
         1.66373, 1.61763, 1.57278, 1.52914, 1.48672, 1.44546, 1.40533, 1.36631, 1.32838, 1.29145, 1.2556, 1.22069,
         1.18682, 1.15383, 1.12178, 1.09064, 1.06035, 1.03091, 1.00235, 0.974532, 0.947518, 0.921275, 0.895781,
         0.871002, 0.846905, 0.823513, 0.80073, 0.778663, 0.757205, 0.736352, 0.716096, 0.69642, 0.677309, 0.658738,
         0.640705, 0.623185, 0.60617, 0.589643, 0.573591, 0.557998, 0.542853, 0.528143, 0.513866, 0.499994, 0.48651,
         0.482403, 3.79398, 3.73339, 3.64708, 3.56198, 3.4781, 3.39547, 3.31428, 3.23428, 3.15569, 3.07841, 3.00255,
         2.92811, 2.85496, 2.78322, 2.71287, 2.64382, 2.57631, 2.51007, 2.44521, 2.38169, 2.31952, 2.25869, 2.19918,
         2.14098, 2.08407, 2.02844, 1.97408, 1.92096, 1.86907, 1.81839, 1.76891, 1.7206, 1.67345, 1.62744, 1.58255,
         1.53876, 1.49604, 1.45439, 1.41378, 1.37419, 1.3356, 1.29799, 1.26134, 1.22564, 1.19085, 1.15697, 1.12398,
         1.09185, 1.06056, 1.03011, 1.00046, 0.971604, 0.943521, 0.916193, 0.889602, 0.863733, 0.838566, 0.814087,
         0.790277, 0.767122, 0.744605, 0.72271, 0.701422, 0.680726, 0.660608, 0.641052, 0.622045, 0.603573, 0.585621,
         0.568177, 0.551227, 0.534759, 0.518759, 0.503217, 0.488119, 0.473454, 0.45921, 0.445376, 0.431942, 0.418896,
         0.406228, 0.393927, 0.381985, 0.37039, 0.359134, 0.348207]],
    'Ni':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.8526, 0.8528, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.3327, 8.3329, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 4.07489, 4.11878, 4.15559, 4.18799, 4.21844, 4.24569, 4.26954, 4.28991, 4.30665, 4.31936, 4.32706,
         4.33038, 4.33103, 4.32965, 4.32479, 4.3155, 4.3002, 4.27468, 4.24425, 4.2183, 4.19406, 4.16743, 4.13541,
         4.09414, 4.0477, 4.00654, 3.96885, 3.93122, 3.89203, 3.85034, 3.79831, 3.73782, 3.68007, 3.62828, 3.57767,
         3.52588, 3.47153, 3.4142, 3.35497, 3.29249, 3.22528, 3.1525, 3.0782, 2.98535, 2.86335, 2.70077, 2.45011,
         2.18829, 1.90363, 1.52278, 1.0005, 0.7129, 0.694467, 1.10772, 1.75751, 2.26228, 2.71469, 3.15797, 3.49643,
         3.81415, 4.14091, 4.46124, 4.75594, 5.03118, 5.3015, 5.58627, 5.88145, 6.12735, 6.34846, 6.55119, 6.73894,
         6.90617, 7.04896, 7.19681, 7.35361, 7.51027, 7.66641, 7.82189, 7.97682, 8.1316, 8.28712, 8.44647, 8.60494,
         8.75933, 8.90703, 9.0524, 9.19571, 9.33813, 9.48087, 9.62523, 9.75819, 9.88397, 10.0028, 10.1138, 10.2099,
         10.2682, 10.3327, 10.4316, 10.5474, 10.6757, 10.8152, 10.9657, 11.1282, 11.3049, 11.4992, 11.7511, 12.0042,
         12.2017, 12.3889, 12.5688, 12.7435, 12.9142, 13.0823, 13.2484, 13.4134, 13.578, 13.7429, 13.9091, 14.0776,
         14.2497, 14.4351, 14.6388, 14.844, 15.0233, 15.1866, 15.34, 15.486, 15.6259, 15.7608, 15.8913, 16.0179,
         16.1412, 16.2616, 16.3794, 16.495, 16.6088, 16.7212, 16.8328, 16.944, 17.0559, 17.1684, 17.2961, 17.428,
         17.5535, 17.6582, 17.7522, 17.8383, 17.9182, 17.9926, 18.0622, 18.1275, 18.189, 18.2469, 18.3016, 18.3535,
         18.4028, 18.4502, 18.4964, 18.5455, 18.5909, 18.6295, 18.6603, 18.6861, 18.7075, 18.725, 18.7389, 18.7492,
         18.7562, 18.7599, 18.7606, 18.7582, 18.753, 18.7451, 18.7346, 18.7219, 18.7078, 18.6944, 18.6841, 18.6676,
         18.6345, 18.5923, 18.5425, 18.4853, 18.4207, 18.3488, 18.2691, 18.1812, 18.0845, 17.9775, 17.8558, 17.7261,
         17.5904, 17.4496, 17.2992, 17.1372, 16.9618, 16.7709, 16.5627, 16.3354, 16.0924, 15.8265, 15.4916, 15.0476,
         14.5541, 13.9833, 13.2954, 12.4407, 11.3146, 9.68933, 6.86521, -4.7785, -16.5847, -16.5694, 6.89208, 10.6978,
         12.9007, 14.4482, 15.6208, 16.5503, 17.2837, 17.7758, 18.0717, 18.1198, 19.1887, 20.4147, 21.0748, 21.6619,
         22.1779, 22.6378, 23.0529, 23.4306, 23.7764, 24.0946, 24.3887, 24.6617, 24.9164, 25.1548, 25.3771, 25.583,
         25.7736, 25.9511, 26.1167, 26.2716, 26.4168, 26.5534, 26.6824, 26.8062, 26.9235, 27.0337, 27.1321, 27.2219,
         27.3047, 27.3809, 27.4513, 27.5164, 27.5768, 27.634, 27.6875, 27.7356, 27.778, 27.8161, 27.8503, 27.8808,
         27.9082, 27.9323, 27.9538, 27.9735, 27.9917, 28.0074, 28.0198, 28.0301, 28.0381, 28.0443, 28.0487, 28.0512,
         28.052, 28.0512, 28.0492, 28.0457, 28.0409, 28.0351, 28.028, 28.0198, 28.0107, 28.0006, 27.9897, 27.978,
         27.9654, 27.9522, 27.9383, 27.9237, 27.9086, 27.8929, 27.8767, 27.86, 27.8428, 27.8251, 27.8071, 27.7887,
         27.7699, 27.7507, 27.7313, 27.7115, 27.6914, 27.671, 27.6503, 27.6293, 27.6081, 27.5866, 27.5648, 27.5427,
         27.5203, 27.4977, 27.4748, 27.4516, 27.4281, 27.4043, 27.3801, 27.3555, 27.3305, 27.3052, 27.2794, 27.2531,
         27.2262, 27.1988, 27.1708, 27.1421, 27.1127, 27.0824, 27.0512, 27.019, 26.9857, 26.9511, 26.9152, 26.8777,
         26.8384, 26.7972, 26.7536, 26.7075, 26.6584, 26.6058, 26.5492, 26.4878, 26.4206, 26.3466, 26.2639, 26.1706,
         26.0635, 25.9382, 25.7876, 25.6001, 25.3543, 25.003, 24.4098, 22.3857, 16.7028, 16.7033, 24.2527, 25.1541,
         25.6675, 26.0303, 26.3112, 26.5399, 26.7321, 26.8971, 27.041, 27.1679, 27.2808, 27.382, 27.4733, 27.5558,
         27.6307, 27.6989, 27.7611, 27.818, 27.87, 27.9176, 27.9613, 28.0013, 28.038, 28.0716, 28.1024, 28.1306,
         28.1564, 28.18, 28.2014, 28.221, 28.2388, 28.2549, 28.2694, 28.2826, 28.2943, 28.3048, 28.3141, 28.3224,
         28.3296, 28.3358, 28.3412, 28.3457, 28.3494, 28.3524, 28.3547, 28.3564, 28.3575, 28.3581, 28.3581, 28.3577,
         28.3568, 28.3555, 28.3539, 28.3518, 28.3495, 28.3468, 28.3439, 28.3407, 28.3373, 28.3336, 28.3298, 28.3257,
         28.3216, 28.3172, 28.3127, 28.3081, 28.3034, 28.2986, 28.2937, 28.2888, 28.2838, 28.2787, 28.2736, 28.2684,
         28.2632, 28.2581, 28.2529, 28.248, 28.2436, 28.2337],
        [1.37727, 1.38064, 1.38401, 1.3874, 1.39079, 1.39419, 1.39982, 1.44104, 1.48347, 1.52716, 1.57212, 1.61841,
         1.66663, 1.71662, 1.7681, 1.82113, 1.87575, 1.93142, 1.98842, 2.0471, 2.10752, 2.16971, 2.23204, 2.28582,
         2.34091, 2.39732, 2.45509, 2.51425, 2.5714, 2.62103, 2.67162, 2.72318, 2.77574, 2.82931, 2.88392, 2.93007,
         2.9711, 3.01271, 3.05491, 3.09769, 3.14107, 3.1147, 3.09192, 3.0999, 3.1079, 3.11592, 3.12491, 3.16974,
         3.21521, 3.26133, 3.34677, 3.44429, 3.54465, 3.64793, 3.75422, 3.80593, 3.83313, 3.86051, 3.88809, 3.91587,
         3.90685, 3.88468, 3.86263, 3.8407, 3.81412, 3.77863, 3.74347, 3.70864, 3.67413, 3.63994, 3.60945, 3.57991,
         3.55062, 3.52157, 3.49275, 3.46417, 3.43582, 3.40771, 3.38228, 3.36017, 3.33819, 3.31636, 3.29467, 3.27312,
         3.25172, 3.25034, 3.25005, 3.24976, 3.24947, 3.24918, 3.24888, 3.26499, 3.28972, 3.31464, 3.33976, 3.36506,
         3.39055, 3.41624, 3.44854, 3.50082, 3.55389, 3.60778, 3.66247, 3.718, 3.77753, 3.8391, 3.90168, 3.96528,
         4.02991, 4.09444, 4.14027, 4.18662, 4.23349, 4.30894, 4.47415, 4.64568, 4.82379, 5.3592, 6.16858, 7.10021,
         8.17252, 8.50016, 8.79611, 9.08103, 9.20206, 9.32471, 9.44899, 9.57493, 9.64899, 9.70549, 9.76232, 9.8195,
         9.87699, 9.86813, 9.84309, 9.81811, 9.7932, 9.76835, 9.74356, 9.73075, 9.74377, 9.75681, 9.76987, 9.78295,
         9.79605, 9.80915, 9.82228, 9.83543, 9.8486, 9.84981, 9.8482, 9.8466, 9.84499, 9.84339, 9.84179, 9.84019,
         9.82776, 9.81204, 9.79634, 9.78065, 9.76501, 9.74938, 9.73377, 9.79365, 9.86007, 9.92692, 9.99425, 10.062,
         10.1303, 10.199, 10.2681, 10.3378, 10.3978, 10.3668, 10.3359, 10.3051, 10.2744, 10.2438, 10.2133, 10.1829,
         10.1525, 10.1223, 10.0921, 10.0621, 10.0321, 10.0022, 9.97242, 9.94271, 9.91308, 9.82709, 9.73137, 9.63658,
         9.54272, 9.44977, 9.35773, 9.26659, 9.17632, 9.08694, 8.99844, 8.91079, 8.82399, 8.73804, 8.65294, 8.56865,
         8.4852, 8.40255, 8.3207, 8.23966, 8.1594, 8.06947, 7.94306, 7.81865, 7.69617, 7.57562, 7.45695, 7.34015,
         7.22517, 7.11199, 7.00059, 6.89094, 6.783, 6.67675, 6.57216, 6.46922, 6.36788, 6.26813, 6.15792, 6.04599,
         5.93609, 5.82819, 5.72225, 5.61823, 5.51611, 5.41584, 5.3174, 5.22074, 5.12584, 5.03267, 4.94119, 4.85137,
         4.76319, 4.67661, 4.5916, 4.50813, 4.41984, 4.3153, 4.21322, 4.11356, 4.01626, 3.92125, 3.8285, 3.73793,
         3.64952, 3.56319, 3.4789, 3.39661, 3.31626, 3.25118, 3.1909, 3.13174, 3.07368, 3.01669, 2.96076, 2.90587,
         2.85199, 2.79911, 2.74722, 2.66726, 2.54699, 2.43214, 2.40333, 2.3552, 2.31346, 2.27693, 2.24149, 2.20661,
         2.17229, 2.1385, 2.13581, 17.1612, 16.82, 16.4508, 16.0897, 15.7365, 15.3911, 15.0686, 14.7422, 14.4139,
         14.2733, 14.5442, 15.2836, 14.9622, 14.6335, 14.3064, 13.9864, 13.6735, 13.3675, 13.0684, 12.776, 12.4902,
         12.2108, 11.9376, 11.6705, 11.4073, 11.1477, 10.8913, 10.6408, 10.396, 10.1568, 9.92318, 9.69489, 9.47183,
         9.25396, 9.03977, 8.82853, 8.6141, 8.40382, 8.19876, 7.99863, 7.80334, 7.61278, 7.42691, 7.24564, 7.06889,
         6.89317, 6.72078, 6.55195, 6.38739, 6.22694, 6.07048, 5.91807, 5.76947, 5.62449, 5.48525, 5.34614, 5.21021,
         5.07749, 4.94801, 4.82139, 4.69811, 4.57759, 4.45991, 4.34528, 4.23335, 4.12431, 4.01774, 3.91381, 3.81264,
         3.71371, 3.61737, 3.52337, 3.43174, 3.34237, 3.25525, 3.17028, 3.08748, 3.00673, 2.92803, 2.85132, 2.77654,
         2.70362, 2.63256, 2.56329, 2.49582, 2.43004, 2.36592, 2.30341, 2.24255, 2.18319, 2.12538, 2.06903, 2.0141,
         1.9606, 1.90848, 1.85767, 1.80819, 1.75993, 1.71294, 1.66712, 1.62253, 1.57905, 1.53665, 1.4954, 1.45514,
         1.41597, 1.37776, 1.34054, 1.30428, 1.26897, 1.23452, 1.20094, 1.16828, 1.13642, 1.10536, 1.07511, 1.0456,
         1.01693, 0.988877, 0.961612, 0.935044, 0.90913, 0.883844, 0.859254, 0.83524, 0.811858, 0.789069, 0.766841,
         0.745185, 0.724075, 0.703492, 0.683436, 0.663872, 0.644803, 0.626209, 0.608093, 0.590415, 0.573185, 0.556386,
         0.540007, 0.524024, 0.508444, 0.493285, 0.490893, 3.83905, 3.76427, 3.67693, 3.59086, 3.50611, 3.42271,
         3.34062, 3.25979, 3.18038, 3.10241, 3.02575, 2.95068, 2.87686, 2.80444, 2.73343, 2.66382, 2.5956, 2.52878,
         2.46334, 2.39927, 2.33657, 2.27521, 2.21519, 2.1565, 2.09912, 2.04303, 1.98822, 1.93467, 1.88237, 1.83129,
         1.78141, 1.73273, 1.68521, 1.63884, 1.59361, 1.54948, 1.50644, 1.46447, 1.42356, 1.38367, 1.3448, 1.30691,
         1.26999, 1.23403, 1.19899, 1.16487, 1.13164, 1.09928, 1.06777, 1.0371, 1.00725, 0.978188, 0.949909, 0.922391,
         0.895616, 0.869567, 0.844228, 0.81958, 0.795607, 0.772295, 0.749624, 0.727581, 0.70615, 0.685315, 0.665061,
         0.645374, 0.626241, 0.607644, 0.589574, 0.572013, 0.554951, 0.538374, 0.522269, 0.506624, 0.491427, 0.476665,
         0.462328, 0.448404, 0.434882, 0.42175, 0.408999]],
    'Cu':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.9324, 0.9326, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832,
         1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319,
         1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304,
         1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005,
         1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943,
         2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 8.9788, 8.979, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242,
         9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998,
         10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136,
         12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089,
         15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371,
         17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002,
         20.0871, 20.412, 20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382,
         23.2076, 23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 1.5525, 1.65095, 1.75782, 1.88491, 2.05397, 2.22143, 2.35311, 2.47607, 2.60841, 2.72325, 2.80297, 2.86036,
         2.89811, 2.91457, 2.90141, 2.84272, 2.82023, 2.81008, 2.80357, 2.7965, 2.78488, 2.75809, 2.71601, 2.70061,
         2.69952, 2.70614, 2.71923, 2.73822, 2.76319, 2.7964, 2.8407, 2.87937, 2.91623, 2.95358, 2.99171, 3.03082,
         3.07096, 3.11182, 3.15229, 3.19626, 3.24312, 3.29248, 3.3445, 3.39947, 3.45809, 3.52267, 3.58913, 3.65483,
         3.72132, 3.78974, 3.86074, 3.93519, 4.01481, 4.10554, 4.1998, 4.2844, 4.36355, 4.44021, 4.51487, 4.58764,
         4.6581, 4.72419, 4.79179, 4.86006, 4.92776, 4.99337, 5.0529, 5.10538, 5.16992, 5.24128, 5.31708, 5.39635,
         5.47815, 5.56026, 5.64431, 5.73687, 5.83662, 5.94242, 6.05439, 6.17308, 6.29976, 6.43882, 6.57818, 6.72074,
         6.86839, 7.02241, 7.18406, 7.35528, 7.53972, 7.75079, 7.96258, 8.16451, 8.36282, 8.56273, 8.76607, 8.9745,
         9.18969, 9.41378, 9.64975, 9.90432, 10.2133, 10.5082, 10.77, 11.0196, 11.2631, 11.5037, 11.7441, 11.9864,
         12.2338, 12.4914, 12.7849, 13.0838, 13.3422, 13.5797, 13.8046, 14.0205, 14.23, 14.4352, 14.639, 14.8493,
         15.063, 15.2549, 15.4288, 15.5918, 15.7413, 15.8852, 16.0285, 16.1694, 16.3074, 16.4429, 16.5762, 16.7082,
         16.8443, 16.9763, 17.0989, 17.2157, 17.328, 17.4364, 17.5414, 17.6433, 17.7423, 17.8389, 17.9333, 18.026,
         18.1173, 18.2081, 18.306, 18.3963, 18.4777, 18.5545, 18.6275, 18.6971, 18.7639, 18.8279, 18.8896, 18.9493,
         19.0082, 19.0655, 19.1193, 19.1703, 19.2194, 19.2671, 19.3142, 19.3616, 19.4153, 19.4783, 19.5225, 19.5525,
         19.5728, 19.5846, 19.588, 19.5829, 19.5496, 19.5269, 19.5179, 19.5118, 19.5081, 19.5065, 19.5176, 19.5193,
         19.5094, 19.4943, 19.4746, 19.4507, 19.423, 19.3917, 19.3608, 19.326, 19.2803, 19.226, 19.1641, 19.0949,
         19.0192, 18.9384, 18.8451, 18.7389, 18.6199, 18.4873, 18.3346, 18.1634, 17.9871, 17.8009, 17.5999, 17.3802,
         17.1401, 16.8765, 16.5705, 16.2143, 15.7988, 15.3072, 14.727, 13.9964, 13.027, 11.6745, 9.63107, 5.28471,
         -18.0747, -18.0552, 2.42254, 9.96436, 13.1149, 15.1297, 16.5865, 17.6966, 18.4996, 19.0803, 19.6526, 20.2159,
         20.7495, 21.254, 21.7327, 22.19, 22.6303, 23.0589, 23.4828, 23.9199, 24.3712, 24.8206, 25.2016, 25.5284,
         25.8205, 26.0853, 26.3272, 26.5493, 26.7542, 26.9437, 27.1195, 27.283, 27.4346, 27.5749, 27.7052, 27.8263,
         27.9391, 28.0442, 28.1425, 28.2344, 28.323, 28.4058, 28.481, 28.5492, 28.6108, 28.6671, 28.7187, 28.7658,
         28.8086, 28.8468, 28.885, 28.9205, 28.9508, 28.9777, 29.0016, 29.0224, 29.0402, 29.0554, 29.0685, 29.079,
         29.0874, 29.0938, 29.0982, 29.1008, 29.1016, 29.1009, 29.0987, 29.095, 29.09, 29.0838, 29.0763, 29.0678,
         29.0582, 29.0477, 29.0362, 29.0238, 29.0107, 28.9968, 28.9822, 28.9669, 28.951, 28.9345, 28.9174, 28.8999,
         28.8818, 28.8633, 28.8444, 28.8251, 28.8053, 28.7852, 28.7648, 28.744, 28.723, 28.7016, 28.6799, 28.658,
         28.6357, 28.6132, 28.5903, 28.5673, 28.544, 28.5203, 28.4963, 28.4721, 28.4476, 28.4227, 28.3975, 28.3718,
         28.3459, 28.3195, 28.2926, 28.2652, 28.2374, 28.2089, 28.1798, 28.15, 28.1194, 28.088, 28.0556, 28.0223,
         27.9878, 27.952, 27.9147, 27.8759, 27.8352, 27.7924, 27.7473, 27.6995, 27.6485, 27.5939, 27.535, 27.471,
         27.4009, 27.3233, 27.2366, 27.1381, 27.0246, 26.8906, 26.7281, 26.5227, 26.2467, 25.8345, 25.0487, 17.5735,
         17.5739, 23.569, 25.6405, 26.3539, 26.8037, 27.134, 27.3949, 27.6099, 27.7922, 27.9495, 28.0873, 28.2092,
         28.3179, 28.4155, 28.5035, 28.5832, 28.6557, 28.7216, 28.7818, 28.8368, 28.8872, 28.9333, 28.9756, 29.0143,
         29.0497, 29.0822, 29.112, 29.1392, 29.1641, 29.1868, 29.2074, 29.2262, 29.2433, 29.2587, 29.2726, 29.2851,
         29.2963, 29.3063, 29.3151, 29.3229, 29.3296, 29.3354, 29.3404, 29.3445, 29.3479, 29.3505, 29.3526, 29.3539,
         29.3547, 29.355, 29.3548, 29.3541, 29.353, 29.3515, 29.3496, 29.3474, 29.3449, 29.342, 29.3389, 29.3356,
         29.332, 29.3282, 29.3242, 29.3201, 29.3157, 29.3113, 29.3067, 29.302, 29.2972, 29.2923, 29.2873, 29.2823,
         29.2772, 29.2721, 29.2669, 29.2617, 29.2564],
        [1.30088, 1.33374, 1.36743, 1.40197, 1.43738, 1.47369, 1.51091, 1.54908, 1.58821, 1.62833, 1.66946, 1.71163,
         1.75487, 1.7992, 1.84464, 1.89124, 1.93901, 1.98799, 2.03821, 2.0897, 2.14248, 2.1966, 2.25209, 2.30779,
         2.36382, 2.42121, 2.47999, 2.54019, 2.59824, 2.6552, 2.71341, 2.77289, 2.83368, 2.8958, 2.93918, 2.97486,
         3.01098, 3.04754, 3.08454, 3.10571, 3.12696, 3.14835, 3.16989, 3.19158, 3.20066, 3.19641, 3.19218, 3.18794,
         3.18372, 3.20429, 3.23365, 3.26327, 3.29317, 3.33041, 3.39669, 3.46428, 3.53322, 3.60353, 3.67524, 3.77578,
         3.89227, 4.01236, 4.13615, 4.26376, 4.3953, 4.53091, 4.62195, 4.708, 4.79565, 4.88494, 4.97588, 5.06606,
         5.0578, 5.04955, 5.04132, 5.03052, 4.9629, 4.89618, 4.83037, 4.76544, 4.70138, 4.63818, 4.62331, 4.6462,
         4.66919, 4.69231, 4.71553, 4.73888, 4.76233, 4.82518, 4.90395, 4.984, 5.06536, 5.14805, 5.23209, 5.31749,
         5.4043, 5.48239, 5.55441, 5.62737, 5.70128, 5.77617, 5.85204, 5.92891, 6.0068, 6.08718, 6.17057, 6.2551,
         6.34079, 6.42765, 6.5157, 6.60496, 6.6951, 6.7777, 6.86131, 6.94594, 7.03163, 7.11837, 7.20618, 7.29507,
         7.38506, 7.45157, 7.51585, 7.58068, 7.64608, 7.71204, 7.77857, 7.84568, 7.91545, 7.99051, 8.06628, 8.14276,
         8.21997, 8.29791, 8.39171, 8.49627, 8.60214, 8.70932, 8.81783, 8.9277, 9.03894, 9.16033, 9.28568, 9.41273,
         9.54153, 9.6721, 9.80444, 9.9386, 10.0698, 10.1951, 10.3219, 10.4503, 10.5803, 10.712, 10.8452, 10.9802,
         11.1146, 11.2038, 11.2938, 11.3845, 11.4759, 11.5681, 11.6609, 11.7546, 11.849, 11.9441, 12.04, 12.1294,
         12.129, 12.1285, 12.1281, 12.1277, 12.1273, 12.1269, 12.1264, 12.126, 12.1256, 12.1252, 12.0498, 11.9562,
         11.8633, 11.7711, 11.6797, 11.589, 11.4989, 11.4096, 11.321, 11.2039, 11.0754, 10.9484, 10.8229, 10.6988,
         10.5875, 10.4783, 10.3702, 10.2632, 10.1573, 10.0525, 9.94883, 9.84619, 9.73053, 9.61505, 9.50095, 9.38819,
         9.27677, 9.16669, 9.0579, 8.95041, 8.84419, 8.73923, 8.63551, 8.53304, 8.43177, 8.32868, 8.21445, 8.10177,
         7.99065, 7.88105, 7.77296, 7.66634, 7.56119, 7.45749, 7.35519, 7.25432, 7.15219, 7.05012, 6.94953, 6.85037,
         6.75262, 6.65627, 6.56129, 6.46767, 6.3598, 6.23335, 6.10942, 5.98794, 5.8689, 5.75221, 5.63784, 5.53428,
         5.46085, 5.38839, 5.31688, 5.24633, 5.17672, 5.10273, 5.01342, 4.92566, 4.83945, 4.75473, 4.67152, 4.58974,
         4.50941, 4.43048, 4.34393, 4.25521, 4.16831, 4.08318, 3.99979, 3.9181, 3.83581, 3.74932, 3.66477, 3.58213,
         3.50135, 3.4224, 3.3577, 3.30516, 3.25344, 3.20253, 3.15242, 3.1031, 3.04912, 2.98532, 2.92286, 2.8617,
         2.80183, 2.74321, 2.65809, 2.57208, 2.49603, 2.43609, 2.25909, 2.14991, 18.4786, 18.2953, 17.7508, 17.2224,
         16.7102, 16.2132, 15.7311, 15.2631, 14.9435, 14.7764, 14.6112, 14.4479, 14.2865, 14.1267, 13.9688, 13.8127,
         13.6583, 13.5056, 13.3547, 13.1591, 12.9133, 12.6075, 12.3091, 12.0178, 11.7333, 11.4555, 11.1844, 10.9196,
         10.6611, 10.4085, 10.1616, 9.91926, 9.68255, 9.45157, 9.22606, 9.0059, 8.79103, 8.58125, 8.37649, 8.17659,
         7.97676, 7.78017, 7.58711, 7.39897, 7.21555, 7.03672, 6.86213, 6.6919, 6.52606, 6.36699, 6.20664, 6.05001,
         5.89702, 5.74751, 5.60115, 5.45834, 5.31903, 5.18292, 5.04977, 4.9201, 4.79321, 4.66959, 4.54872, 4.43093,
         4.31615, 4.20392, 4.09434, 3.98775, 3.88362, 3.78207, 3.68302, 3.58644, 3.49224, 3.4004, 3.31086, 3.22358,
         3.13847, 3.05553, 2.97464, 2.89585, 2.81902, 2.74417, 2.67122, 2.60014, 2.53085, 2.46334, 2.39757, 2.33346,
         2.27105, 2.2102, 2.15092, 2.09321, 2.03696, 1.98216, 1.92878, 1.87677, 1.82613, 1.77679, 1.72877, 1.68197,
         1.63632, 1.59195, 1.5487, 1.50655, 1.46552, 1.42555, 1.38663, 1.34873, 1.31182, 1.27581, 1.24083, 1.2067,
         1.17344, 1.14113, 1.10956, 1.07891, 1.04895, 1.01985, 0.99153, 0.963866, 0.936946, 0.910741, 0.885194,
         0.860322, 0.836094, 0.812505, 0.789511, 0.767114, 0.745298, 0.724043, 0.703338, 0.683167, 0.663518, 0.644376,
         0.625722, 0.607548, 0.589836, 0.572588, 0.555773, 0.539391, 0.523425, 0.507876, 0.495545, 3.85305, 3.83652,
         3.74771, 3.66034, 3.57419, 3.48938, 3.40592, 3.32398, 3.24324, 3.16389, 3.08595, 3.00942, 2.9343, 2.86061,
         2.78833, 2.71747, 2.64802, 2.57999, 2.51335, 2.44811, 2.38424, 2.32175, 2.26061, 2.20082, 2.14236, 2.08521,
         2.02936, 1.97479, 1.92148, 1.86942, 1.81858, 1.76895, 1.72051, 1.67324, 1.62712, 1.58213, 1.53824, 1.49545,
         1.45372, 1.41304, 1.37339, 1.33475, 1.2971, 1.26041, 1.22467, 1.18985, 1.15595, 1.12294, 1.09079, 1.05949,
         1.02903, 0.999375, 0.970516, 0.942433, 0.915106, 0.888521, 0.862657, 0.8375, 0.813031, 0.789233, 0.766091,
         0.743588, 0.721709, 0.700438, 0.67976, 0.65966, 0.640123, 0.621136, 0.602683, 0.584752, 0.567329, 0.5504,
         0.533953, 0.517976, 0.502455, 0.487378, 0.472735]],
    'Zn':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.0217, 1.0219, 1.03229, 1.04899, 1.06596, 1.0832,
         1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319,
         1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304,
         1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005,
         1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943,
         2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888,
         3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738,
         4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.6585,
         9.658700000000001, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999,
         10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153,
         12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412,
         14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054,
         16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527,
         19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117,
         22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662,
         26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998,
         29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -0.776021, -0.773223, -0.768501, -0.761632, -0.752332, -0.740234, -0.724803, -0.705148, -0.679227,
         -0.641458, -0.610078, -0.580116, -0.549776, -0.51827, -0.485088, -0.449802, -0.412036, -0.371393, -0.327445,
         -0.279697, -0.227567, -0.17031, -0.106943, -0.0360293, 0.0445447, 0.142962, 0.279376, 0.395691, 0.494574,
         0.587305, 0.67651, 0.763621, 0.849518, 0.934855, 1.02011, 1.1057, 1.19198, 1.27933, 1.3681, 1.4587, 1.55164,
         1.64759, 1.74753, 1.85504, 1.98045, 2.09242, 2.19732, 2.29996, 2.40119, 2.5016, 2.60157, 2.70142, 2.80139,
         2.9017, 3.00257, 3.10427, 3.20713, 3.31207, 3.42206, 3.5313, 3.63643, 3.73952, 3.84104, 3.94093, 4.03877,
         4.13273, 4.2154, 4.30144, 4.39863, 4.50187, 4.60971, 4.72168, 4.83756, 4.95735, 5.08112, 5.20911, 5.34159,
         5.47905, 5.62221, 5.77232, 5.93214, 6.11215, 6.28638, 6.45467, 6.62137, 6.7892, 6.95957, 7.13395, 7.31437,
         7.50484, 7.71899, 7.97487, 8.17143, 8.32718, 8.44808, 8.5218, 8.46565, 8.38133, 8.4736, 8.69958, 9.17969,
         9.58846, 9.89741, 10.1781, 10.4431, 10.6986, 10.9483, 11.1947, 11.4399, 11.6854, 11.9331, 12.1849, 12.444,
         12.7177, 13.0284, 13.3103, 13.5693, 13.8214, 14.0695, 14.3163, 14.5642, 14.8169, 15.0804, 15.3763, 15.6953,
         15.9603, 16.181, 16.3781, 16.5425, 16.6996, 16.8612, 17.0205, 17.1762, 17.3281, 17.4762, 17.6206, 17.7616,
         17.8993, 18.0341, 18.1661, 18.2957, 18.4232, 18.549, 18.6737, 18.7983, 18.9256, 19.0576, 19.1795, 19.2922,
         19.4002, 19.5045, 19.6055, 19.7039, 19.8001, 19.8946, 19.9879, 20.0807, 20.1741, 20.2694, 20.3696, 20.4961,
         20.6004, 20.6813, 20.7527, 20.8164, 20.8739, 20.926, 20.9737, 21.0176, 21.0586, 21.0978, 21.1375, 21.1887,
         21.2241, 21.2422, 21.2519, 21.2541, 21.2495, 21.2387, 21.2218, 21.1988, 21.1695, 21.1327, 21.0828, 21.0327,
         20.9823, 20.9323, 20.8817, 20.8305, 20.7776, 20.7226, 20.6662, 20.6073, 20.5433, 20.4695, 20.3844, 20.2884,
         20.191, 20.0962, 19.9984, 19.8926, 19.7785, 19.6559, 19.5248, 19.3853, 19.2341, 19.0629, 18.8712, 18.6577,
         18.4196, 18.1529, 17.8525, 17.5114, 17.12, 16.6648, 16.1244, 15.4734, 14.6664, 13.6188, 12.1504, 9.77174,
         3.76919, -15.4199, -15.4118, 6.78343, 11.5047, 13.9824, 15.7067, 17.046, 18.1518, 19.1008, 19.9384, 20.6939,
         21.3889, 22.0414, 22.6773, 23.3018, 23.9032, 24.4216, 24.8733, 25.2792, 25.6482, 25.9862, 26.2971, 26.5843,
         26.8507, 27.0988, 27.3304, 27.5455, 27.7449, 27.9302, 28.1031, 28.2645, 28.4157, 28.5577, 28.6913, 28.821,
         28.9428, 29.0539, 29.1556, 29.2485, 29.3341, 29.413, 29.4859, 29.5532, 29.6146, 29.6757, 29.7333, 29.784,
         29.8299, 29.8714, 29.9092, 29.9429, 29.9731, 30.0002, 30.0241, 30.0449, 30.063, 30.0783, 30.0912, 30.1019,
         30.1103, 30.1165, 30.1208, 30.1233, 30.1241, 30.1231, 30.1207, 30.1168, 30.1116, 30.1051, 30.0973, 30.0885,
         30.0785, 30.0676, 30.0557, 30.0429, 30.0294, 30.015, 29.9999, 29.9841, 29.9678, 29.9507, 29.9332, 29.9151,
         29.8965, 29.8775, 29.858, 29.8381, 29.8178, 29.7971, 29.7761, 29.7547, 29.7331, 29.7111, 29.6888, 29.6662,
         29.6434, 29.6202, 29.5968, 29.5731, 29.5491, 29.5248, 29.5002, 29.4753, 29.4501, 29.4246, 29.3987, 29.3724,
         29.3456, 29.3185, 29.291, 29.2628, 29.2342, 29.2049, 29.175, 29.1443, 29.1129, 29.0806, 29.0473, 29.0129,
         28.9773, 28.9404, 28.9019, 28.8618, 28.8197, 28.7754, 28.7285, 28.6788, 28.6257, 28.5687, 28.507, 28.4398,
         28.3659, 28.2838, 28.1913, 28.0858, 27.9628, 27.8162, 27.6352, 27.401, 27.0735, 26.543, 25.1991, 18.4095,
         18.4099, 25.9194, 27.0089, 27.5766, 27.9665, 28.2638, 28.5036, 28.7037, 28.8747, 29.0231, 29.1537, 29.2695,
         29.373, 29.466, 29.55, 29.6261, 29.6952, 29.7582, 29.8156, 29.8681, 29.916, 29.9599, 30.0001, 30.0368, 30.0705,
         30.1012, 30.1293, 30.155, 30.1784, 30.1997, 30.2191, 30.2366, 30.2525, 30.2668, 30.2796, 30.2911, 30.3014,
         30.3104, 30.3184, 30.3253, 30.3313, 30.3364, 30.3406, 30.3441, 30.3469, 30.349, 30.3504, 30.3513, 30.3516,
         30.3514, 30.3507, 30.3496, 30.3481, 30.3463, 30.344, 30.3415, 30.3386, 30.3355, 30.3322, 30.3286, 30.3248,
         30.3207, 30.3166, 30.3122, 30.3078, 30.3032, 30.2984, 30.2936, 30.2887, 30.2839, 30.2805, 30.2686],
        [2.21675, 2.11915, 2.02585, 1.93665, 1.85138, 1.76986, 1.69194, 1.63293, 1.57784, 1.5246, 1.47317, 1.41678,
         1.3588, 1.3032, 1.29898, 1.30061, 1.30258, 1.31477, 1.32707, 1.33949, 1.35171, 1.36387, 1.37615, 1.38853,
         1.40102, 1.41363, 1.42635, 1.43918, 1.45213, 1.46519, 1.49662, 1.52989, 1.5639, 1.59867, 1.63422, 1.67055,
         1.70769, 1.74565, 1.78446, 1.82414, 1.86469, 1.90615, 1.94852, 1.99185, 2.04253, 2.09481, 2.14843, 2.20343,
         2.25983, 2.31768, 2.377, 2.43784, 2.50025, 2.56425, 2.62988, 2.6972, 2.76624, 2.83705, 2.90967, 2.98415,
         3.06053, 3.14002, 3.2216, 3.30531, 3.39119, 3.4793, 3.5697, 3.66245, 3.75761, 3.85525, 3.95541, 4.05818,
         4.16363, 4.27181, 4.3828, 4.49668, 4.60456, 4.70598, 4.80963, 4.91556, 5.02382, 5.13448, 5.24757, 5.36314,
         5.48127, 5.60199, 5.72538, 5.85148, 5.98036, 6.11208, 6.2467, 6.38429, 6.5249, 6.6485, 6.72805, 6.80854, 6.89,
         6.97243, 7.05586, 7.14028, 7.2257, 7.31215, 7.39964, 7.48817, 7.57775, 7.66842, 7.76017, 7.85301, 7.94696,
         8.04204, 8.13826, 8.22295, 8.29284, 8.36333, 8.43442, 8.5061, 8.5784, 8.65132, 8.72484, 8.799, 8.8738, 8.94922,
         9.02528, 9.102, 9.17936, 9.25724, 9.32497, 9.3932, 9.46193, 9.53116, 9.6009, 9.67114, 9.74191, 9.81362,
         9.91179, 10.0109, 10.1111, 10.2122, 10.3144, 10.4176, 10.5218, 10.627, 10.7333, 10.8407, 10.9491, 11.0587,
         11.1693, 11.281, 11.3867, 11.4667, 11.5474, 11.6286, 11.7104, 11.7927, 11.8757, 11.9592, 12.0433, 12.128,
         12.1589, 12.1318, 12.1048, 12.0779, 12.051, 12.0242, 12.2805, 12.6256, 12.9805, 13.273, 13.287, 13.301, 13.315,
         13.329, 13.343, 13.3571, 13.3712, 13.3853, 13.3993, 13.4135, 13.4276, 13.4417, 13.4559, 13.439, 13.3832,
         13.3275, 13.2721, 13.217, 13.1621, 13.1074, 13.0529, 12.9986, 12.9446, 12.8045, 12.6274, 12.4527, 12.2804,
         12.1105, 11.9778, 11.8471, 11.7177, 11.5898, 11.4633, 11.3382, 11.2144, 11.092, 10.9709, 10.8511, 10.7327,
         10.6155, 10.4996, 10.385, 10.2717, 10.1595, 10.0486, 9.92718, 9.79825, 9.67098, 9.54537, 9.4214, 9.29903,
         9.17825, 9.05904, 8.94138, 8.82525, 8.71063, 8.59749, 8.48582, 8.37561, 8.25075, 8.09404, 7.9403, 7.78948,
         7.64153, 7.49639, 7.354, 7.21433, 7.07729, 6.94287, 6.811, 6.68163, 6.54388, 6.38945, 6.23865, 6.09142,
         5.94765, 5.80729, 5.67023, 5.53642, 5.40575, 5.27817, 5.1536, 5.03197, 4.93231, 4.83383, 4.74119, 4.65153,
         4.56431, 4.47866, 4.39466, 4.312, 4.22781, 4.14084, 4.05279, 3.96658, 3.89183, 3.82593, 3.76353, 3.69825,
         3.63144, 3.56582, 3.50143, 3.43806, 3.37406, 3.30526, 3.23298, 3.16227, 3.09309, 3.02541, 2.95935, 2.89479,
         2.8317, 2.77006, 2.70974, 2.65071, 2.60046, 2.55306, 2.50819, 2.4641, 2.42102, 2.37892, 2.36407, 17.2327,
         17.1037, 16.9012, 16.7012, 16.5025, 16.3064, 16.1129, 15.9216, 15.7325, 15.5457, 15.3612, 15.1788, 14.9985,
         14.7734, 14.5006, 14.1709, 13.8488, 13.534, 13.2265, 12.9259, 12.6321, 12.3449, 12.0644, 11.7896, 11.5203,
         11.2544, 10.9942, 10.74, 10.4916, 10.249, 10.012, 9.78048, 9.55431, 9.33336, 9.11024, 8.89009, 8.67363,
         8.46234, 8.25614, 8.05493, 7.85868, 7.6673, 7.48068, 7.30176, 7.12066, 6.94307, 6.76946, 6.59974, 6.43388,
         6.27136, 6.11279, 5.95786, 5.80606, 5.65807, 5.51334, 5.37202, 5.23407, 5.09933, 4.96775, 4.83924, 4.71406,
         4.59161, 4.47218, 4.35568, 4.24205, 4.13114, 4.02294, 3.91741, 3.8145, 3.71411, 3.61621, 3.52074, 3.42769,
         3.33695, 3.24849, 3.16229, 3.07827, 2.99636, 2.91654, 2.83873, 2.76294, 2.68908, 2.61709, 2.54695, 2.47863,
         2.41202, 2.3472, 2.284, 2.22246, 2.16251, 2.10414, 2.04722, 1.99183, 1.93789, 1.8853, 1.83415, 1.78428,
         1.73575, 1.68848, 1.64246, 1.59766, 1.55398, 1.51146, 1.47005, 1.42974, 1.39045, 1.35225, 1.31507, 1.27882,
         1.2435, 1.20914, 1.17569, 1.14312, 1.11136, 1.08048, 1.05044, 1.02112, 0.9926, 0.964826, 0.937786, 0.91145,
         0.885808, 0.860833, 0.836517, 0.812835, 0.789772, 0.767321, 0.745456, 0.724156, 0.703408, 0.683209, 0.663533,
         0.644378, 0.625712, 0.607531, 0.589828, 0.572591, 0.555792, 0.539425, 0.523484, 0.50796, 0.50244, 3.89191,
         3.83265, 3.74123, 3.65173, 3.5637, 3.47717, 3.39214, 3.30863, 3.22663, 3.14617, 3.06723, 2.98982, 2.91394,
         2.83957, 2.76672, 2.69537, 2.62552, 2.55716, 2.49026, 2.42482, 2.36082, 2.29824, 2.23707, 2.1773, 2.11889,
         2.06184, 2.00612, 1.95172, 1.89861, 1.84677, 1.79618, 1.74682, 1.69867, 1.6517, 1.6059, 1.56124, 1.51771,
         1.47527, 1.43391, 1.39361, 1.35434, 1.31608, 1.27882, 1.24252, 1.20718, 1.17276, 1.13926, 1.10664, 1.07489,
         1.04398, 1.01391, 0.984646, 0.956173, 0.928472, 0.901523, 0.87531, 0.849815, 0.82502, 0.800908, 0.777463,
         0.754667, 0.732505, 0.71096, 0.690017, 0.66966, 0.649875, 0.630648, 0.611962, 0.593805, 0.576163, 0.559022,
         0.542369]],
    'Ga':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072,
         1.1165999999999998, 1.1168, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172,
         1.29229, 1.2989000000000002, 1.2991, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023,
         1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392,
         1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124,
         1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981,
         2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703,
         2.79146, 2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326,
         3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613,
         3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.367,
         10.3672, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559,
         11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497,
         13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 1.3271, 1.29434, 1.26276, 1.23223, 1.20263, 1.1737, 1.14626, 1.12028, 1.09579, 1.07289, 1.05177, 1.0327,
         1.016, 1.00218, 0.991934, 0.987219, 0.992342, 1.00331, 1.00729, 1.00928, 1.01098, 1.01317, 1.0164, 1.02117,
         1.02796, 1.0374, 1.05032, 1.06945, 1.10145, 1.12842, 1.15058, 1.17169, 1.19271, 1.21422, 1.23663, 1.26035,
         1.28574, 1.31348, 1.34493, 1.37899, 1.41287, 1.44803, 1.48515, 1.52477, 1.5674, 1.61373, 1.66466, 1.72239,
         1.79299, 1.87125, 1.9401, 2.00598, 2.07133, 2.13739, 2.20506, 2.27544, 2.35039, 2.43607, 2.52023, 2.59758,
         2.67119, 2.74299, 2.81326, 2.88199, 2.94853, 3.00986, 3.06677, 3.13203, 3.20293, 3.277, 3.35367, 3.43237,
         3.51169, 3.59012, 3.66777, 3.75804, 3.85869, 3.96758, 4.08488, 4.2112, 4.34745, 4.4952, 4.65675, 4.83802,
         5.06362, 5.29532, 5.5009, 5.69762, 5.8915, 6.08532, 6.28088, 6.47967, 6.68306, 6.8926, 7.11019, 7.33864,
         7.58301, 7.86035, 8.17319, 8.44711, 8.69366, 8.93038, 9.16028, 9.38539, 9.60708, 9.82645, 10.0444, 10.2616,
         10.479, 10.6974, 10.9179, 11.142, 11.3732, 11.6249, 11.866, 12.0934, 12.3126, 12.5271, 12.7383, 12.947,
         13.1537, 13.3592, 13.5637, 13.7677, 13.9716, 14.1758, 14.3808, 14.5871, 14.7952, 15.0059, 15.2202, 15.4398,
         15.6675, 15.912, 16.184, 16.4295, 16.6519, 16.8658, 17.0737, 17.2771, 17.4775, 17.6757, 17.873, 18.0706,
         18.2699, 18.4732, 18.6851, 18.9226, 19.1684, 19.3807, 19.5654, 19.7368, 19.8977, 20.05, 20.1949, 20.3335,
         20.4666, 20.595, 20.7193, 20.8404, 20.9593, 21.0771, 21.2069, 21.3269, 21.4304, 21.5248, 21.6123, 21.6937,
         21.7699, 21.8413, 21.9084, 21.9714, 22.0307, 22.0867, 22.1395, 22.1895, 22.237, 22.2824, 22.3264, 22.3696,
         22.4216, 22.4676, 22.5005, 22.526, 22.5456, 22.5604, 22.5708, 22.5771, 22.5798, 22.5792, 22.5755, 22.5693,
         22.5611, 22.5518, 22.5438, 22.5459, 22.5496, 22.5304, 22.489, 22.4349, 22.3697, 22.2939, 22.2079, 22.1117,
         22.0047, 21.8861, 21.7541, 21.6009, 21.4381, 21.2746, 21.1073, 20.9301, 20.7394, 20.5327, 20.3074, 20.0595,
         19.785, 19.4782, 19.1317, 18.7352, 18.2744, 17.7277, 17.0656, 16.2329, 15.1233, 13.4922, 10.5124, -10.6725,
         -10.6678, 1.56871, 11.7921, 14.6652, 16.4368, 17.7288, 18.7442, 19.57, 20.2418, 20.7413, 20.7723, 18.7899,
         18.8011, 21.9927, 23.1209, 23.9234, 24.5811, 25.1467, 25.6448, 26.0897, 26.4909, 26.8552, 27.1881, 27.4943,
         27.7766, 28.0376, 28.2797, 28.5048, 28.7148, 28.9117, 29.099, 29.2746, 29.4364, 29.5842, 29.7201, 29.8457,
         29.9619, 30.0697, 30.17, 30.262, 30.3509, 30.4352, 30.5116, 30.5812, 30.6452, 30.7036, 30.757, 30.8057,
         30.8499, 30.89, 30.9261, 30.9584, 30.9873, 31.013, 31.0356, 31.0552, 31.072, 31.0864, 31.0983, 31.1077,
         31.1152, 31.1205, 31.1238, 31.1255, 31.1254, 31.1237, 31.1205, 31.116, 31.1101, 31.1029, 31.0946, 31.0852,
         31.0748, 31.0634, 31.0512, 31.038, 31.0241, 31.0094, 30.9941, 30.9781, 30.9614, 30.9442, 30.9265, 30.9083,
         30.8896, 30.8704, 30.8508, 30.8309, 30.8106, 30.7898, 30.7688, 30.7475, 30.7258, 30.7038, 30.6815, 30.659,
         30.6362, 30.613, 30.5896, 30.566, 30.542, 30.5177, 30.4932, 30.4683, 30.4431, 30.4175, 30.3916, 30.3652,
         30.3385, 30.3113, 30.2836, 30.2554, 30.2266, 30.1972, 30.167, 30.1361, 30.1044, 30.0717, 30.038, 30.0031,
         29.967, 29.9294, 29.8902, 29.8492, 29.8061, 29.7606, 29.7124, 29.6611, 29.6061, 29.5468, 29.4824, 29.4118,
         29.3338, 29.2465, 29.1474, 29.0331, 28.8982, 28.7342, 28.5268, 28.2473, 27.8273, 27.0132, 19.4428, 19.4432,
         25.8007, 27.6942, 28.3901, 28.8326, 29.1586, 29.4164, 29.629, 29.8091, 29.9646, 30.1007, 30.221, 30.3283,
         30.4245, 30.5113, 30.5898, 30.6611, 30.7259, 30.7851, 30.8391, 30.8884, 30.9336, 30.975, 31.0128, 31.0475,
         31.0792, 31.1082, 31.1346, 31.1588, 31.1809, 31.2009, 31.2191, 31.2356, 31.2505, 31.2639, 31.2759, 31.2866,
         31.2961, 31.3045, 31.3119, 31.3182, 31.3237, 31.3283, 31.3321, 31.3352, 31.3376, 31.3393, 31.3404, 31.341,
         31.3411, 31.3407, 31.3398, 31.3385, 31.3368, 31.3348, 31.3324, 31.3297, 31.3268, 31.3236, 31.3201, 31.3164,
         31.3126, 31.3085, 31.3043, 31.3, 31.2956, 31.293, 31.2806],
        [2.98527, 2.98141, 2.97756, 2.9737, 2.96986, 2.96602, 2.95695, 2.90859, 2.86103, 2.81425, 2.76823, 2.66636,
         2.55394, 2.44626, 2.34311, 2.24432, 2.14969, 2.02163, 1.89458, 1.70752, 1.44713, 1.2411, 1.07107, 0.920747,
         0.773401, 0.650876, 0.599352, 0.551909, 0.50822, 0.472778, 0.439966, 0.43395, 0.432236, 0.430552, 0.442783,
         0.455362, 0.468298, 0.488631, 0.535543, 0.586959, 0.671684, 0.792094, 0.911933, 1.00319, 1.10359, 1.18802,
         1.25195, 1.31932, 1.34907, 1.35917, 1.36934, 1.37959, 1.38992, 1.38942, 1.38002, 1.37069, 1.36143, 1.36635,
         1.39605, 1.42639, 1.4574, 1.48908, 1.52145, 1.56001, 1.61325, 1.6683, 1.72524, 1.78411, 1.845, 1.90796,
         1.97307, 2.04041, 2.11039, 2.1833, 2.25873, 2.33677, 2.4175, 2.50102, 2.58742, 2.67682, 2.7693, 2.86497,
         2.96395, 3.06635, 3.15305, 3.23858, 3.32644, 3.41667, 3.50936, 3.60456, 3.70234, 3.80277, 3.90593, 4.01189,
         4.12072, 4.2265, 4.31941, 4.41435, 4.51138, 4.61054, 4.71189, 4.81545, 4.9213, 5.02947, 5.14003, 5.25301,
         5.36368, 5.47581, 5.59028, 5.70715, 5.82646, 5.94826, 6.07261, 6.19957, 6.32917, 6.46148, 6.57308, 6.68044,
         6.78956, 6.90045, 7.01316, 7.1277, 7.24412, 7.36243, 7.48088, 7.57994, 7.6803, 7.782, 7.88504, 7.98945,
         8.09524, 8.20243, 8.31104, 8.4342, 8.56433, 8.69646, 8.83063, 8.96688, 9.10522, 9.24571, 9.39145, 9.54948,
         9.71719, 9.88785, 10.0615, 10.2382, 10.418, 10.601, 10.7871, 10.9766, 11.1694, 11.3655, 11.4855, 11.6006,
         11.7168, 11.8342, 11.9527, 12.0725, 12.1934, 12.3156, 12.439, 12.5636, 12.6894, 12.8166, 12.945, 13.0064,
         13.0318, 13.0573, 13.0828, 13.1084, 13.134, 13.1597, 13.1854, 13.2112, 13.237, 13.2629, 13.2888, 13.3148,
         13.3408, 13.3669, 13.3872, 13.3696, 13.352, 13.3345, 13.317, 13.2995, 13.2821, 13.2646, 13.2472, 13.2298,
         13.2124, 13.1951, 13.1777, 13.1604, 13.1431, 13.1259, 13.1087, 13.0914, 13.0742, 13.0571, 13.0399, 12.986,
         12.9, 12.8147, 12.7299, 12.6457, 12.562, 12.4789, 12.3963, 12.3143, 12.2328, 12.1518, 12.0714, 11.9916,
         11.9122, 11.7685, 11.6058, 11.4453, 11.287, 11.131, 10.977, 10.8253, 10.6756, 10.528, 10.3824, 10.2388,
         10.0972, 9.95761, 9.81992, 9.68322, 9.52024, 9.35999, 9.20246, 9.04756, 8.89528, 8.74556, 8.59835, 8.45363,
         8.31134, 8.17145, 8.03391, 7.89869, 7.76574, 7.63503, 7.50653, 7.38018, 7.25597, 7.13384, 6.99252, 6.85265,
         6.71559, 6.58127, 6.44963, 6.32062, 6.1942, 6.07031, 5.94889, 5.8299, 5.7133, 5.59902, 5.48703, 5.37728,
         5.26972, 5.13025, 4.97901, 4.83223, 4.68978, 4.55152, 4.41734, 4.28711, 4.16073, 4.03807, 3.91903, 3.8035,
         3.69137, 3.60783, 3.53097, 3.45531, 3.38059, 3.30688, 3.23494, 3.1645, 3.09553, 3.02848, 2.96292, 2.89882,
         2.83615, 2.77532, 2.7163, 2.66264, 2.60963, 2.55721, 2.5058, 2.45541, 2.41128, 15.6268, 15.6115, 15.4531,
         15.2962, 15.141, 14.9873, 14.8352, 14.6846, 14.5368, 14.3906, 14.2458, 14.2001, 15.8852, 15.6365, 15.2738,
         14.9194, 14.5734, 14.2353, 13.9051, 13.5824, 13.2674, 12.9599, 12.6606, 12.3682, 12.0826, 11.8036, 11.5311,
         11.2649, 11.0048, 10.7507, 10.5025, 10.2521, 10.0052, 9.76228, 9.52519, 9.29382, 9.06803, 8.84787, 8.63307,
         8.42343, 8.2226, 8.01944, 7.8202, 7.62565, 7.43531, 7.24887, 7.06688, 6.8888, 6.71491, 6.54485, 6.37861,
         6.21644, 6.05785, 5.90315, 5.75194, 5.60422, 5.46015, 5.3195, 5.18207, 5.04796, 4.91733, 4.78938, 4.66502,
         4.54352, 4.425, 4.3094, 4.19667, 4.0867, 3.97946, 3.87493, 3.77296, 3.67355, 3.57666, 3.48218, 3.39009,
         3.30032, 3.21283, 3.12755, 3.0445, 2.96347, 2.88455, 2.80767, 2.73275, 2.65973, 2.58859, 2.51925, 2.45171,
         2.38597, 2.32185, 2.2594, 2.19861, 2.13936, 2.08162, 2.0254, 1.97063, 1.9173, 1.86534, 1.81472, 1.76543,
         1.71743, 1.6706, 1.62508, 1.58067, 1.5375, 1.49538, 1.45443, 1.41448, 1.37561, 1.33772, 1.30087, 1.26495,
         1.22995, 1.19587, 1.16263, 1.13029, 1.09881, 1.06813, 1.03825, 1.00914, 0.980786, 0.953177, 0.926276, 0.900071,
         0.874545, 0.849687, 0.825458, 0.801857, 0.778864, 0.756468, 0.734664, 0.71339, 0.692675, 0.672497, 0.652833,
         0.633681, 0.615009, 0.596807, 0.579077, 0.561816, 0.544992, 0.528583, 0.512592, 0.500533, 3.8548, 3.83433,
         3.74426, 3.65556, 3.56828, 3.48242, 3.398, 3.31505, 3.23357, 3.15356, 3.07503, 2.99799, 2.92244, 2.84837,
         2.77577, 2.70465, 2.63499, 2.56679, 2.50002, 2.4347, 2.37078, 2.30828, 2.24716, 2.18741, 2.12902, 2.07196,
         2.01623, 1.96179, 1.90863, 1.85674, 1.80608, 1.75665, 1.70841, 1.66136, 1.61546, 1.57069, 1.52704, 1.48449,
         1.44301, 1.40258, 1.36318, 1.3248, 1.2874, 1.25096, 1.21548, 1.18092, 1.14727, 1.11451, 1.08262, 1.05157,
         1.02135, 0.991945, 0.963326, 0.935481, 0.908389, 0.882035, 0.856398, 0.831463, 0.807212, 0.783629, 0.760696,
         0.738399, 0.716721, 0.695645, 0.675159, 0.655246, 0.635891, 0.617081]],
    'Ge':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.2169, 1.2170999999999998, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4145, 1.4147, 1.4228800000000001, 1.4458900000000001,
         1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289,
         1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124,
         2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519,
         2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.103, 11.103200000000001, 11.2736, 11.4559,
         11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497,
         13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 0.440124, 0.272233, 0.162958, 0.217163, 0.453769, 0.682046, 0.882264, 1.1372, 1.2815, 1.37051, 1.42861,
         1.46459, 1.47891, 1.47827, 1.46483, 1.43153, 1.36477, 1.30954, 1.26061, 1.20727, 1.14217, 1.07603, 1.00925,
         0.930394, 0.827077, 0.74599, 0.674834, 0.604867, 0.529002, 0.452626, 0.398433, 0.367368, 0.368932, 0.351783,
         0.326497, 0.299997, 0.273877, 0.246499, 0.218209, 0.188729, 0.155599, 0.124148, 0.0986014, 0.0772277,
         0.0597239, 0.0461093, 0.0361662, 0.03263, 0.0359316, 0.0470171, 0.0674639, 0.0998144, 0.148377, 0.23425,
         0.348107, 0.430821, 0.497067, 0.558261, 0.61658, 0.673491, 0.729977, 0.786845, 0.844725, 0.904338, 0.96654,
         1.03362, 1.10337, 1.1722, 1.24154, 1.31266, 1.38605, 1.46219, 1.54154, 1.62469, 1.7123, 1.80605, 1.9122,
         2.01653, 2.11982, 2.22529, 2.33371, 2.44578, 2.56195, 2.68284, 2.80893, 2.94092, 3.07946, 3.22554, 3.38036,
         3.54595, 3.72626, 3.93605, 4.14322, 4.34297, 4.54134, 4.74284, 4.94919, 5.16203, 5.38294, 5.61394, 5.85763,
         6.11865, 6.40872, 6.75914, 7.06766, 7.3536, 7.63003, 7.9017, 8.1713, 8.44065, 8.71121, 8.98432, 9.26121,
         9.54331, 9.83225, 10.1302, 10.4402, 10.7677, 11.127, 11.5612, 11.9347, 12.2704, 12.5866, 12.89, 13.1838,
         13.4704, 13.7513, 14.0278, 14.301, 14.5718, 14.8411, 15.1099, 15.3791, 15.6498, 15.9236, 16.2024, 16.489,
         16.7887, 17.1284, 17.5025, 17.8168, 18.0944, 18.3504, 18.5905, 18.8179, 19.0344, 19.2417, 19.4409, 19.6328,
         19.8182, 19.9977, 20.1721, 20.3417, 20.5073, 20.6694, 20.8287, 20.9862, 21.1439, 21.3099, 21.4642, 21.6066,
         21.7434, 21.8757, 22.0044, 22.1305, 22.2551, 22.3795, 22.5055, 22.6486, 22.7953, 22.9146, 23.0164, 23.1067,
         23.1881, 23.2619, 23.329, 23.3902, 23.4461, 23.4971, 23.5436, 23.586, 23.6248, 23.6604, 23.6934, 23.7248,
         23.7577, 23.7926, 23.8162, 23.8284, 23.8342, 23.8342, 23.829, 23.8189, 23.8043, 23.7854, 23.7622, 23.735,
         23.7038, 23.669, 23.6304, 23.5922, 23.5481, 23.495, 23.4351, 23.3689, 23.2965, 23.2177, 23.1325, 23.0406,
         22.9417, 22.8355, 22.7219, 22.6038, 22.4717, 22.3231, 22.1594, 21.9777, 21.7725, 21.5556, 21.3242, 21.072,
         20.7937, 20.4853, 20.1397, 19.7462, 19.2915, 18.7562, 18.1109, 17.3071, 16.2561, 14.7694, 12.3113, 5.36147,
         -12.3949, -12.3903, 10.4277, 14.5274, 16.7825, 18.3764, 19.6267, 20.6657, 21.5628, 22.3592, 23.0821, 23.5101,
         23.5159, 23.7522, 24.3891, 25.0164, 25.6447, 26.2152, 26.7087, 27.1411, 27.533, 27.8914, 28.2214, 28.5271,
         28.8116, 29.084, 29.3384, 29.5711, 29.7845, 29.9801, 30.1611, 30.3289, 30.4849, 30.6304, 30.7643, 30.8964,
         31.0213, 31.1339, 31.2378, 31.3336, 31.4223, 31.504, 31.5791, 31.6482, 31.7117, 31.7697, 31.8229, 31.8712,
         31.9148, 31.9543, 31.9898, 32.0217, 32.0501, 32.075, 32.0967, 32.1155, 32.1313, 32.1447, 32.1558, 32.1644,
         32.1707, 32.1749, 32.1772, 32.1777, 32.1764, 32.1735, 32.1691, 32.1633, 32.1561, 32.1476, 32.138, 32.1273,
         32.1155, 32.1027, 32.089, 32.0745, 32.0592, 32.0431, 32.0263, 32.0089, 31.9909, 31.9723, 31.9532, 31.9335,
         31.9134, 31.8929, 31.8719, 31.8505, 31.8288, 31.8067, 31.7843, 31.7616, 31.7385, 31.7152, 31.6916, 31.6677,
         31.6434, 31.619, 31.5943, 31.5693, 31.544, 31.5184, 31.4925, 31.4664, 31.4399, 31.413, 31.3857, 31.3581,
         31.3301, 31.3015, 31.2724, 31.2429, 31.2127, 31.1818, 31.1503, 31.1179, 31.0846, 31.0503, 31.015, 30.9784,
         30.9404, 30.9009, 30.8596, 30.8164, 30.7708, 30.7227, 30.6715, 30.6168, 30.5581, 30.4944, 30.4249, 30.3484,
         30.263, 30.1666, 30.056, 29.9265, 29.7705, 29.5756, 29.3184, 28.9463, 28.2956, 25.1168, 20.2986, 20.299,
         28.3851, 29.2238, 29.7193, 30.0738, 30.3497, 30.5748, 30.7642, 30.9268, 31.0685, 31.1934, 31.3045, 31.4039,
         31.4933, 31.574, 31.6472, 31.7137, 31.7743, 31.8295, 31.88, 31.926, 31.9682, 32.0067, 32.042, 32.0742, 32.1037,
         32.1306, 32.1551, 32.1774, 32.1977, 32.2161, 32.2328, 32.2478, 32.2613, 32.2734, 32.2842, 32.2938, 32.3022,
         32.3096, 32.316, 32.3214, 32.326, 32.3298, 32.3329, 32.3352, 32.3369, 32.338, 32.3385, 32.3385, 32.3381,
         32.3371, 32.3358, 32.334, 32.3319, 32.3295, 32.3268, 32.3238, 32.3205, 32.317, 32.3133, 32.3095, 32.3076,
         32.2946],
        [3.01183, 3.05548, 3.09976, 3.14468, 3.19025, 3.21825, 3.20755, 3.19689, 3.18626, 3.17568, 3.16687, 3.15816,
         3.14947, 3.1408, 3.13216, 3.11421, 3.01683, 2.9225, 2.83112, 2.7426, 2.65685, 2.57378, 2.4933, 2.41534,
         2.33982, 2.26666, 2.18698, 2.10697, 2.02987, 1.9556, 1.88405, 1.81511, 1.7487, 1.68472, 1.62308, 1.56369,
         1.50648, 1.45136, 1.39825, 1.34406, 1.28586, 1.23018, 1.1769, 1.12594, 1.07718, 1.03054, 0.982739, 0.923062,
         0.867009, 0.814359, 0.764906, 0.718458, 0.674829, 0.63385, 0.591594, 0.548427, 0.50841, 0.473964, 0.46103,
         0.44845, 0.444589, 0.450264, 0.456011, 0.461832, 0.483682, 0.538895, 0.698676, 0.905829, 1.1744, 1.52262,
         1.97406, 2.22141, 2.38416, 2.50492, 2.51621, 2.45219, 2.39089, 2.33813, 2.28654, 2.23706, 2.19667, 2.15701,
         2.11806, 2.09638, 2.10723, 2.11814, 2.1291, 2.14324, 2.17356, 2.20431, 2.23549, 2.29344, 2.37463, 2.45869,
         2.54573, 2.63585, 2.75745, 2.89179, 3.03269, 3.15118, 3.25097, 3.35393, 3.46014, 3.56893, 3.67975, 3.794,
         3.9118, 4.03326, 4.16976, 4.31092, 4.45687, 4.60775, 4.76374, 4.92594, 5.09471, 5.26925, 5.44978, 5.63649,
         5.8296, 6.02932, 6.24339, 6.38321, 6.50992, 6.63914, 6.77093, 6.90534, 7.04241, 7.1822, 7.32477, 7.47017,
         7.61845, 7.76968, 7.92391, 8.07343, 8.2249, 8.37922, 8.53643, 8.69659, 8.85976, 9.02599, 9.19533, 9.36786,
         9.54362, 9.71828, 9.88541, 10.0554, 10.2283, 10.4042, 10.5831, 10.7651, 10.9503, 11.1386, 11.3301, 11.525,
         11.7232, 11.9248, 12.1298, 12.3384, 12.5441, 12.7108, 12.8798, 13.051, 13.2244, 13.4002, 13.5784, 13.7589,
         13.9417, 14.1271, 14.3149, 14.5052, 14.6551, 14.7403, 14.826, 14.9123, 14.999, 15.0862, 15.1739, 15.2621,
         15.3509, 15.4401, 15.5299, 15.6202, 15.711, 15.8024, 15.8943, 15.9867, 16.0281, 15.9773, 15.9267, 15.8763,
         15.826, 15.7759, 15.7259, 15.6762, 15.6265, 15.5771, 15.5277, 15.4785, 15.4295, 15.3807, 15.332, 15.2834,
         15.235, 15.1868, 15.1387, 15.0908, 14.9669, 14.7856, 14.6064, 14.4295, 14.2547, 14.082, 13.9114, 13.7428,
         13.5764, 13.4119, 13.2494, 13.0889, 12.9303, 12.7737, 12.6189, 12.466, 12.315, 12.1658, 12.0184, 11.8645,
         11.6986, 11.5351, 11.3738, 11.2148, 11.058, 10.9034, 10.751, 10.6007, 10.4525, 10.3064, 10.1255, 9.92938,
         9.73703, 9.5484, 9.36343, 9.18205, 9.00417, 8.82973, 8.65869, 8.49095, 8.32647, 8.16517, 8.007, 7.85188,
         7.69978, 7.55061, 7.40434, 7.24878, 7.0875, 6.9298, 6.77561, 6.62486, 6.47746, 6.33334, 6.19242, 6.05464,
         5.91992, 5.78821, 5.65942, 5.5335, 5.41038, 5.29, 5.16382, 5.04011, 4.91936, 4.8015, 4.68647, 4.57419, 4.4646,
         4.35764, 4.25324, 4.15134, 4.05188, 3.95175, 3.84724, 3.74549, 3.64643, 3.54999, 3.4604, 3.3861, 3.31343,
         3.24258, 3.17352, 3.10813, 3.04357, 2.97979, 2.91735, 2.85623, 2.79642, 2.73776, 2.68034, 2.62413, 2.5691,
         2.51522, 2.50172, 16.7824, 16.6482, 16.4675, 16.2902, 16.1167, 15.9451, 15.7754, 15.6075, 15.4412, 15.2767,
         15.1736, 15.1726, 15.1143, 14.9533, 14.7768, 14.5762, 14.2699, 13.9552, 13.6474, 13.3465, 13.0523, 12.7644,
         12.483, 12.2078, 11.9387, 11.6634, 11.3904, 11.1208, 10.8575, 10.6004, 10.3494, 10.1046, 9.86546, 9.63179,
         9.40909, 9.18062, 8.95641, 8.7368, 8.5218, 8.31139, 8.10488, 7.90307, 7.70557, 7.51231, 7.32319, 7.13839,
         6.95735, 6.78052, 6.60779, 6.43898, 6.27408, 6.11297, 5.95529, 5.80156, 5.65125, 5.50473, 5.36177, 5.22209,
         5.08564, 4.95248, 4.82268, 4.69599, 4.5724, 4.45185, 4.33429, 4.21963, 4.10784, 3.99882, 3.89254, 3.78896,
         3.68797, 3.58952, 3.49358, 3.4001, 3.30901, 3.22022, 3.13369, 3.04945, 2.96733, 2.88735, 2.80945, 2.7335,
         2.6596, 2.58763, 2.51751, 2.44916, 2.38268, 2.31789, 2.25489, 2.1935, 2.13369, 2.07546, 2.01882, 1.96364,
         1.90987, 1.85762, 1.80674, 1.75713, 1.70888, 1.66195, 1.6162, 1.57174, 1.52841, 1.48627, 1.44521, 1.40529,
         1.36645, 1.32852, 1.29169, 1.2559, 1.22103, 1.18703, 1.15398, 1.12181, 1.09049, 1.06002, 1.03036, 1.0015,
         0.973404, 0.946056, 0.919435, 0.893531, 0.868318, 0.843783, 0.819886, 0.796635, 0.774005, 0.75197, 0.730529,
         0.709655, 0.689338, 0.669557, 0.650313, 0.631568, 0.613322, 0.59556, 0.578268, 0.561433, 0.545044, 0.529086,
         0.51355, 0.51279, 3.89712, 3.80828, 3.71689, 3.62704, 3.53874, 3.45199, 3.36682, 3.28322, 3.20119, 3.12074,
         3.04186, 2.96456, 2.88881, 2.81462, 2.74198, 2.67087, 2.60128, 2.5332, 2.46661, 2.40149, 2.33783, 2.27562,
         2.21482, 2.15542, 2.09741, 2.04076, 1.98544, 1.93145, 1.87875, 1.82733, 1.77716, 1.72823, 1.6805, 1.63396,
         1.58858, 1.54434, 1.50122, 1.4592, 1.41825, 1.37836, 1.33949, 1.30163, 1.26476, 1.22885, 1.19389, 1.15985,
         1.12672, 1.09446, 1.06307, 1.03252, 1.00279, 0.973864, 0.945722, 0.918345, 0.891714, 0.865812, 0.84062,
         0.816123, 0.7923, 0.769138, 0.746618, 0.724724, 0.703442]],
    'As':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.3235, 1.3237,
         1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304,
         1.51719, 1.5269000000000001, 1.5271, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499,
         1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795,
         2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611,
         2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         11.8666, 11.8668, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497,
         13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 6.5848, 6.50149, 6.42175, 6.3427, 6.26381, 6.18643, 6.10805, 6.01692, 5.91271, 5.80605, 5.70259, 5.59388,
         5.484, 5.36967, 5.24292, 5.11497, 4.97518, 4.82707, 4.64548, 4.50161, 4.38743, 4.31305, 4.2857, 4.33582,
         4.39229, 4.44656, 4.45697, 4.44758, 4.42836, 4.39149, 4.33769, 4.26228, 4.14655, 4.04859, 3.96047, 3.86962,
         3.7653, 3.6716, 3.58491, 3.50091, 3.41812, 3.33371, 3.25526, 3.18186, 3.11345, 3.05149, 3.0001, 2.95565,
         2.91053, 2.86898, 2.83353, 2.80821, 2.80285, 2.81237, 2.80932, 2.80338, 2.79878, 2.79918, 2.81233, 2.82603,
         2.83488, 2.84378, 2.85452, 2.8684, 2.88654, 2.91036, 2.94172, 2.98592, 3.05109, 3.10712, 3.15965, 3.21489,
         3.27457, 3.3407, 3.4159, 3.50767, 3.62493, 3.72675, 3.8201, 3.91329, 4.00796, 4.10573, 4.20869, 4.3186,
         4.42924, 4.54308, 4.66181, 4.78694, 4.92034, 5.06696, 5.23418, 5.39362, 5.54958, 5.70858, 5.87214, 6.04173,
         6.21878, 6.40509, 6.60296, 6.81677, 7.06119, 7.34059, 7.59109, 7.82849, 8.06178, 8.29471, 8.52977, 8.7698,
         9.02503, 9.27761, 9.52616, 9.77643, 10.0305, 10.2902, 10.5577, 10.8369, 11.1542, 11.4492, 11.7208, 11.9934,
         12.2903, 12.6107, 12.9626, 13.385, 13.8167, 14.2179, 14.5657, 14.8858, 15.188, 15.4764, 15.7541, 16.023,
         16.285, 16.5412, 16.7926, 17.0403, 17.2856, 17.5302, 17.7762, 18.0286, 18.3009, 18.5585, 18.796, 19.0174,
         19.2265, 19.4268, 19.6193, 19.8054, 19.9857, 20.1606, 20.3306, 20.4964, 20.6587, 20.8176, 20.9733, 21.1263,
         21.2774, 21.4268, 21.5749, 21.7232, 21.8737, 22.0309, 22.1945, 22.3552, 22.4965, 22.6253, 22.7456, 22.8592,
         22.968, 23.0726, 23.1759, 23.2745, 23.3679, 23.455, 23.5359, 23.6122, 23.6847, 23.7539, 23.8205, 23.8859,
         23.9495, 24.0101, 24.0653, 24.1184, 24.1686, 24.2101, 24.2453, 24.2768, 24.3057, 24.332, 24.3564, 24.3809,
         24.4047, 24.4239, 24.4306, 24.4238, 24.4056, 24.3908, 24.3872, 24.3863, 24.378, 24.364, 24.3461, 24.3249,
         24.3012, 24.274, 24.2402, 24.2004, 24.1553, 24.1051, 24.0495, 23.9884, 23.921, 23.8472, 23.7667, 23.6798,
         23.585, 23.4813, 23.3677, 23.2435, 23.1077, 22.9591, 22.797, 22.6193, 22.4225, 22.204, 21.9601, 21.6863,
         21.3764, 21.0221, 20.6118, 20.1289, 19.5479, 18.8281, 17.8969, 16.606, 14.5682, 9.9424, -10.3277, -10.3191,
         10.49, 15.5371, 17.9553, 19.5599, 20.7456, 21.6596, 22.3592, 22.8321, 22.7982, 20.2859, 20.2925, 23.7309,
         24.9157, 25.731, 26.3969, 26.9712, 27.4804, 27.9401, 28.3637, 28.7528, 29.1071, 29.4284, 29.7222, 29.9926,
         30.2427, 30.4745, 30.6901, 30.8892, 31.0814, 31.2636, 31.4305, 31.5841, 31.7266, 31.8585, 31.9808, 32.0942,
         32.1993, 32.2962, 32.3858, 32.4686, 32.5449, 32.6151, 32.6795, 32.7383, 32.792, 32.8407, 32.8851, 32.9253,
         32.9615, 32.9936, 33.0222, 33.0476, 33.0698, 33.0888, 33.105, 33.1187, 33.1298, 33.1386, 33.1451, 33.1496,
         33.1521, 33.1527, 33.1516, 33.1488, 33.1445, 33.1388, 33.1317, 33.1234, 33.1138, 33.1032, 33.0915, 33.0788,
         33.0652, 33.0507, 33.0355, 33.0195, 33.0028, 32.9854, 32.9674, 32.9488, 32.9297, 32.9101, 32.89, 32.8694,
         32.8484, 32.8271, 32.8054, 32.7833, 32.7609, 32.7381, 32.715, 32.6916, 32.668, 32.644, 32.6197, 32.5952,
         32.5703, 32.5452, 32.5198, 32.494, 32.468, 32.4416, 32.4149, 32.3877, 32.3602, 32.3323, 32.3039, 32.275,
         32.2455, 32.2154, 32.1847, 32.1533, 32.1211, 32.088, 32.0539, 32.0188, 31.9824, 31.9447, 31.9055, 31.8645,
         31.8216, 31.7765, 31.7289, 31.6782, 31.6242, 31.5662, 31.5034, 31.435, 31.3597, 31.276, 31.1816, 31.0736,
         30.9475, 30.7963, 30.6087, 30.3635, 30.0146, 29.4268, 27.5708, 21.2382, 21.2385, 29.2007, 30.1347, 30.6593,
         31.0279, 31.3121, 31.5428, 31.7361, 31.9017, 32.0458, 32.1726, 32.2852, 32.3859, 32.4764, 32.5581, 32.6321,
         32.6994, 32.7606, 32.8165, 32.8675, 32.914, 32.9566, 32.9956, 33.0312, 33.0638, 33.0936, 33.1207, 33.1455,
         33.1681, 33.1886, 33.2072, 33.2241, 33.2393, 33.253, 33.2652, 33.2762, 33.2859, 33.2945, 33.3019, 33.3084,
         33.314, 33.3187, 33.3225, 33.3257, 33.3281, 33.3298, 33.331, 33.3316, 33.3316, 33.3312, 33.3303, 33.329,
         33.3273, 33.3252, 33.3228, 33.3201, 33.3171, 33.3138, 33.3103],
        [4.62596, 4.67742, 4.72945, 4.78206, 4.83525, 4.88904, 4.94342, 4.99841, 5.05401, 5.11023, 5.16708, 5.22456,
         5.28267, 5.31932, 5.31541, 5.3115, 5.30759, 5.30369, 5.29978, 5.29589, 5.29199, 5.28751, 5.2808, 5.2741,
         5.26741, 5.26072, 5.25404, 5.24738, 5.24072, 5.23407, 5.22742, 5.15507, 5.06546, 4.97741, 4.8909, 4.80588,
         4.72235, 4.64026, 4.53714, 4.37679, 4.2221, 4.07288, 3.92893, 3.79007, 3.65612, 3.52329, 3.39393, 3.26932,
         3.14929, 3.03366, 2.88009, 2.71399, 2.55747, 2.40998, 2.27099, 2.14002, 2.01335, 1.89149, 1.77702, 1.66947,
         1.56843, 1.47351, 1.37723, 1.28202, 1.1934, 1.1109, 1.03411, 0.968319, 0.916166, 0.866823, 0.820138, 0.775967,
         0.734175, 0.68455, 0.635642, 0.590347, 0.567907, 0.546319, 0.527579, 0.51798, 0.508556, 0.508966, 0.517035,
         0.539057, 0.569786, 0.643758, 0.766203, 0.91194, 1.07785, 1.26123, 1.39611, 1.49928, 1.51243, 1.51714, 1.52187,
         1.52316, 1.51765, 1.51216, 1.50669, 1.52291, 1.57707, 1.63316, 1.69125, 1.76089, 1.84975, 1.94308, 2.04112,
         2.14411, 2.25553, 2.3775, 2.50606, 2.64157, 2.78441, 2.93498, 3.079, 3.22779, 3.38378, 3.5473, 3.71872,
         3.89844, 4.05153, 4.19949, 4.35284, 4.5118, 4.67657, 4.8461, 4.99971, 5.15819, 5.32169, 5.49038, 5.66441,
         5.84396, 6.0292, 6.22031, 6.41748, 6.60275, 6.77774, 6.95736, 7.14175, 7.33102, 7.5253, 7.72473, 7.92946,
         8.11231, 8.27853, 8.44815, 8.62126, 8.7979, 8.97817, 9.16212, 9.34518, 9.52799, 9.71439, 9.90442, 10.0982,
         10.2957, 10.4971, 10.6848, 10.8604, 11.0388, 11.2202, 11.4045, 11.5919, 11.7824, 11.976, 12.1727, 12.3728,
         12.5761, 12.7351, 12.8589, 12.984, 13.1103, 13.2378, 13.3666, 13.4965, 13.6241, 13.7343, 13.8454, 13.9574,
         14.0703, 14.1841, 14.2988, 14.4145, 14.5311, 14.5715, 14.6486, 14.7407, 14.8454, 14.9511, 15.0574, 15.1643,
         15.128, 15.0612, 14.9705, 14.8805, 14.791, 14.7019, 14.6134, 14.5256, 14.4384, 14.3515, 14.2651, 14.1791,
         14.0939, 14.0092, 13.9249, 13.841, 13.7377, 13.6104, 13.4683, 13.3255, 13.1846, 13.0448, 12.9066, 12.77,
         12.6346, 12.5006, 12.368, 12.2373, 12.1079, 11.9796, 11.8526, 11.727, 11.6029, 11.4798, 11.358, 11.2377,
         11.1186, 10.997, 10.8686, 10.7162, 10.556, 10.3978, 10.2422, 10.089, 9.93846, 9.78966, 9.64207, 9.49261,
         9.34204, 9.19197, 9.04395, 8.89855, 8.7556, 8.6151, 8.47678, 8.34005, 8.20331, 8.06476, 7.92655, 7.79076,
         7.65049, 7.50992, 7.37433, 7.24206, 7.1127, 6.98562, 6.86082, 6.73778, 6.61126, 6.47875, 6.34346, 6.21097,
         6.09532, 5.99258, 5.89425, 5.78824, 5.67781, 5.56959, 5.46339, 5.35912, 5.25587, 5.15157, 5.04684, 4.94425,
         4.84371, 4.7452, 4.64821, 4.55276, 4.45888, 4.36687, 4.27681, 4.18867, 4.10056, 4.01395, 3.92886, 3.84551,
         3.76402, 3.68437, 3.60698, 3.53036, 3.45446, 3.38029, 3.30767, 3.23656, 3.16708, 3.09908, 3.03254, 2.96728,
         2.90349, 2.84117, 2.78039, 2.7211, 2.66332, 2.60676, 2.57963, 16.4311, 16.2725, 15.9618, 15.6569, 15.3578,
         15.0644, 14.7768, 14.4951, 14.2193, 13.9488, 13.8426, 15.7546, 15.5518, 15.2164, 14.8881, 14.5669, 14.2527,
         13.9452, 13.6443, 13.35, 13.0487, 12.7497, 12.4541, 12.1653, 11.8833, 11.608, 11.3387, 11.0758, 10.8192,
         10.5744, 10.3223, 10.0742, 9.83089, 9.59263, 9.35857, 9.12957, 8.90515, 8.68526, 8.46975, 8.25918, 8.05289,
         7.851, 7.6535, 7.46014, 7.27115, 7.08633, 6.90567, 6.7295, 6.55696, 6.38852, 6.2236, 6.0632, 5.90606, 5.75282,
         5.60288, 5.45711, 5.31436, 5.17522, 5.03945, 4.90699, 4.77772, 4.65164, 4.52871, 4.40881, 4.29189, 4.17785,
         4.06672, 3.95841, 3.85275, 3.74982, 3.64949, 3.55169, 3.45642, 3.36358, 3.27315, 3.18503, 3.09915, 3.01551,
         2.93405, 2.85471, 2.77744, 2.70218, 2.62882, 2.55745, 2.48796, 2.42027, 2.3544, 2.29024, 2.22777, 2.16689,
         2.10769, 2.05008, 1.99396, 1.93929, 1.88612, 1.83437, 1.78399, 1.73491, 1.68727, 1.6408, 1.59559, 1.5516,
         1.50872, 1.46703, 1.42647, 1.38698, 1.34861, 1.31117, 1.27479, 1.23936, 1.2049, 1.17136, 1.13871, 1.10695,
         1.07604, 1.04595, 1.01667, 0.988193, 0.960474, 0.933474, 0.907218, 0.881665, 0.856803, 0.8326, 0.809046,
         0.786113, 0.763808, 0.742093, 0.720972, 0.700403, 0.680383, 0.660898, 0.641932, 0.623472, 0.605504, 0.588014,
         0.570989, 0.554417, 0.538285, 0.52258, 0.519571, 3.89295, 3.81789, 3.72654, 3.63671, 3.5484, 3.46164, 3.37642,
         3.29277, 3.21069, 3.13016, 3.0512, 2.9738, 2.89796, 2.82366, 2.7509, 2.67966, 2.60995, 2.54173, 2.475, 2.40974,
         2.34594, 2.28358, 2.22263, 2.16308, 2.10492, 2.04811, 1.99264, 1.93849, 1.88564, 1.83407, 1.78375, 1.73466,
         1.68678, 1.64008, 1.59455, 1.55017, 1.5069, 1.46474, 1.42364, 1.38361, 1.3446, 1.30661, 1.2696, 1.23356,
         1.19847, 1.1643, 1.13104, 1.09866, 1.06715, 1.03648, 1.00664, 0.977596, 0.949343, 0.921857, 0.89512, 0.869114,
         0.843822, 0.819225, 0.795307]],
    'Se':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4338, 1.434, 1.4458900000000001, 1.46928, 1.49304, 1.51719,
         1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.6519000000000001, 1.6521, 1.67051, 1.69753, 1.72499, 1.75289,
         1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124,
         2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519,
         2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.6577, 12.6579, 12.8176, 13.025, 13.2356, 13.4497,
         13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 7.8121, 7.77264, 7.73078, 7.68731, 7.64329, 7.59476, 7.54326, 7.48954, 7.43389, 7.37649, 7.31752, 7.25709,
         7.19532, 7.13248, 7.06867, 7.00248, 6.93433, 6.86438, 6.79256, 6.71871, 6.64258, 6.56315, 6.4781, 6.39431,
         6.31141, 6.22705, 6.13977, 6.05017, 5.95778, 5.85925, 5.75263, 5.65006, 5.54687, 5.43915, 5.32589, 5.20726,
         5.07947, 4.93771, 4.77801, 4.58914, 4.33738, 3.96589, 3.76831, 3.9112, 4.02255, 4.1162, 4.16779, 4.10086,
         3.9854, 3.85329, 3.71941, 3.60305, 3.49493, 3.39162, 3.29206, 3.19656, 3.10795, 3.02786, 2.94133, 2.85209,
         2.76166, 2.67068, 2.57929, 2.48724, 2.39199, 2.29482, 2.20835, 2.1313, 2.06442, 2.01156, 1.9834, 1.98281,
         1.96942, 1.95483, 1.94508, 1.9441, 1.95559, 1.98647, 2.05687, 2.15896, 2.23502, 2.30298, 2.37114, 2.44374,
         2.52391, 2.61557, 2.725, 2.87341, 3.01602, 3.14924, 3.2813, 3.41817, 3.56279, 3.71854, 3.89005, 4.09069,
         4.32489, 4.53966, 4.7438, 4.95076, 5.16419, 5.38908, 5.64366, 5.89986, 6.14556, 6.39191, 6.64329, 6.9032,
         7.17585, 7.47221, 7.79913, 8.10884, 8.40802, 8.70975, 9.01757, 9.33525, 9.66739, 10.0225, 10.4583, 10.8558,
         11.2145, 11.5646, 11.9143, 12.2802, 12.6402, 12.9846, 13.3097, 13.624, 13.9308, 14.2323, 14.5299, 14.8248,
         15.1184, 15.4118, 15.7061, 16.0025, 16.303, 16.6102, 16.9286, 17.2691, 17.6616, 18.0279, 18.3558, 18.6547,
         18.9311, 19.1928, 19.4423, 19.6816, 19.912, 20.1346, 20.3505, 20.5602, 20.7641, 20.9634, 21.1585, 21.3494,
         21.537, 21.7223, 21.906, 22.0892, 22.2738, 22.4642, 22.6642, 22.8618, 23.0364, 23.1962, 23.3462, 23.4891,
         23.6255, 23.7567, 23.8874, 24.0123, 24.1307, 24.2415, 24.3458, 24.4452, 24.5401, 24.631, 24.7187, 24.8051,
         24.8893, 24.9704, 25.0465, 25.1209, 25.1928, 25.2558, 25.3117, 25.3632, 25.4116, 25.4572, 25.5009, 25.5453,
         25.5894, 25.6287, 25.6534, 25.6628, 25.6596, 25.6608, 25.6757, 25.6945, 25.7048, 25.7089, 25.7087, 25.7053,
         25.6994, 25.6906, 25.6759, 25.6561, 25.6319, 25.6037, 25.5715, 25.535, 25.4936, 25.4475, 25.3969, 25.3428,
         25.2832, 25.2169, 25.143, 25.0617, 24.9729, 24.8762, 24.7714, 24.6578, 24.5334, 24.3972, 24.2482, 24.0848,
         23.9053, 23.7075, 23.4885, 23.2446, 22.971, 22.6617, 22.3083, 21.8995, 21.4189, 20.8413, 20.1259, 19.2002,
         17.9159, 15.8838, 11.2425, -9.16067, -9.15379, 11.9859, 16.935, 19.3189, 20.8997, 22.0662, 22.9617, 23.6407,
         24.083, 23.92, 21.5003, 21.5059, 25.0654, 26.165, 26.9569, 27.6121, 28.1758, 28.6722, 29.1154, 29.5163,
         29.8817, 30.217, 30.5263, 30.8102, 31.0855, 31.344, 31.5785, 31.7954, 31.9963, 32.1827, 32.3557, 32.5165,
         32.6655, 32.804, 32.9325, 33.0515, 33.1616, 33.2639, 33.3582, 33.4453, 33.5257, 33.5997, 33.6677, 33.7299,
         33.7867, 33.8385, 33.8858, 33.9286, 33.9669, 34.0012, 34.0319, 34.0593, 34.0831, 34.1038, 34.1216, 34.1366,
         34.149, 34.1589, 34.1665, 34.1719, 34.1752, 34.1766, 34.1762, 34.1741, 34.1703, 34.1651, 34.1585, 34.1505,
         34.1412, 34.1308, 34.1194, 34.1068, 34.0933, 34.079, 34.0637, 34.0477, 34.031, 34.0136, 33.9955, 33.9768,
         33.9576, 33.9378, 33.9176, 33.8969, 33.8757, 33.8541, 33.8322, 33.8099, 33.7872, 33.7641, 33.7408, 33.7172,
         33.6933, 33.669, 33.6445, 33.6197, 33.5946, 33.5692, 33.5436, 33.5175, 33.4912, 33.4646, 33.4377, 33.4104,
         33.3826, 33.3545, 33.3259, 33.2968, 33.2672, 33.237, 33.2061, 33.1746, 33.1423, 33.1091, 33.075, 33.0399,
         33.0035, 32.9659, 32.9267, 32.8859, 32.8431, 32.7982, 32.7508, 32.7005, 32.6469, 32.5893, 32.5271, 32.4593,
         32.3848, 32.302, 32.2088, 32.1023, 31.9779, 31.8291, 31.6446, 31.4039, 31.0623, 30.4902, 28.7508, 22.3125,
         22.3128, 30.2182, 31.1582, 31.6814, 32.0478, 32.3297, 32.5582, 32.7495, 32.9132, 33.0555, 33.1806, 33.2917,
         33.3909, 33.48, 33.5605, 33.6333, 33.6994, 33.7596, 33.8144, 33.8645, 33.9102, 33.952, 33.9901, 34.025,
         34.0569, 34.0861, 34.1126, 34.1369, 34.1589, 34.1789, 34.1971, 34.2135, 34.2284, 34.2417, 34.2536, 34.2643,
         34.2737, 34.282, 34.2893, 34.2955, 34.3009, 34.3054, 34.3091, 34.3121, 34.3144, 34.3161, 34.3172, 34.3177,
         34.3177, 34.3172, 34.3163, 34.3149, 34.3132, 34.3111, 34.3087],
        [5.20241, 5.36005, 5.52247, 5.63017, 5.66221, 5.69443, 5.71762, 5.72709, 5.73659, 5.7461, 5.75558, 5.74367,
         5.73179, 5.71993, 5.70809, 5.69116, 5.66798, 5.64489, 5.6219, 5.59899, 5.57619, 5.55347, 5.53085, 5.50832,
         5.48588, 5.46416, 5.47179, 5.47945, 5.4871, 5.49477, 5.50245, 5.51014, 5.48519, 5.4583, 5.43154, 5.40491,
         5.3784, 5.35997, 5.3438, 5.32768, 5.31161, 5.29558, 5.27674, 5.22931, 5.1823, 5.13572, 5.08955, 5.0438,
         4.97976, 4.85658, 4.73645, 4.6193, 4.5012, 4.28248, 4.07439, 3.87642, 3.68806, 3.50886, 3.33836, 3.17615,
         3.02182, 2.87499, 2.7353, 2.60239, 2.47594, 2.35563, 2.24117, 2.13227, 2.02867, 1.93009, 1.83631, 1.74503,
         1.65666, 1.57276, 1.49311, 1.4175, 1.34571, 1.27756, 1.21287, 1.15144, 1.09313, 1.03679, 0.982849, 0.931714,
         0.883238, 0.837286, 0.793723, 0.752427, 0.71328, 0.67828, 0.651254, 0.625303, 0.600387, 0.57663, 0.556066,
         0.536235, 0.517111, 0.507983, 0.504227, 0.500499, 0.496798, 0.496344, 0.4965, 0.496658, 0.499383, 0.503749,
         0.516424, 0.531435, 0.71186, 1.14783, 1.4796, 1.60918, 1.64922, 1.65907, 1.5587, 1.58412, 1.60996, 1.70211,
         1.80064, 1.907, 2.02051, 2.14079, 2.26823, 2.40325, 2.53434, 2.66485, 2.80208, 2.94638, 3.0981, 3.25764,
         3.4254, 3.60179, 3.79869, 4.01211, 4.23751, 4.47559, 4.72704, 4.99261, 5.23688, 5.4715, 5.71661, 5.97271,
         6.24029, 6.51984, 6.81193, 7.1171, 7.37029, 7.60472, 7.8466, 8.09618, 8.35369, 8.6194, 8.89355, 9.17644,
         9.45712, 9.6921, 9.93291, 10.1797, 10.4327, 10.6919, 10.9575, 11.2298, 11.5088, 11.7464, 11.9622, 12.1819,
         12.4056, 12.6335, 12.8656, 13.1013, 13.2929, 13.4874, 13.6847, 13.8849, 14.088, 14.2941, 14.5032, 14.6762,
         14.825, 14.9753, 15.1271, 15.2805, 15.4355, 15.592, 15.7501, 15.8792, 15.9185, 15.9579, 15.9973, 16.0369,
         16.0751, 16.0661, 16.0491, 16.0256, 16.002, 15.9785, 15.9551, 15.9315, 15.9081, 15.8849, 15.8615, 15.8381,
         15.8146, 15.7914, 15.7682, 15.7453, 15.7222, 15.6548, 15.5322, 15.3759, 15.2162, 15.058, 14.9015, 14.7465,
         14.5932, 14.4416, 14.2917, 14.1433, 13.9963, 13.8508, 13.7073, 13.5647, 13.4235, 13.2841, 13.1463, 13.0098,
         12.8746, 12.7407, 12.6049, 12.4637, 12.2932, 12.1128, 11.9347, 11.7599, 11.5878, 11.4175, 11.2501, 11.0842,
         10.915, 10.7448, 10.5754, 10.4089, 10.2448, 10.0832, 9.92421, 9.768, 9.61373, 9.45967, 9.30428, 9.14959,
         8.99757, 8.83996, 8.68154, 8.52741, 8.3767, 8.22908, 8.08404, 7.94153, 7.80096, 7.656, 7.5035, 7.34742, 7.1946,
         7.06113, 6.94248, 6.82881, 6.7056, 6.57686, 6.4505, 6.32662, 6.20507, 6.08515, 5.96488, 5.8448, 5.72708,
         5.61178, 5.49887, 5.38761, 5.27801, 5.17013, 5.06442, 4.96093, 4.85961, 4.75681, 4.65526, 4.55507, 4.45706,
         4.36118, 4.2674, 4.17564, 4.08507, 3.99563, 3.90798, 3.82225, 3.7384, 3.65645, 3.57632, 3.49798, 3.42124,
         3.34624, 3.27298, 3.20135, 3.13149, 3.06339, 2.99669, 2.93141, 2.86751, 2.80518, 2.74413, 2.68425, 2.65616,
         16.4055, 16.2342, 15.9067, 15.5857, 15.274, 14.9689, 14.6699, 14.3768, 14.0897, 13.8082, 13.7244, 15.6001,
         15.3744, 15.0534, 14.7391, 14.4185, 14.1004, 13.7862, 13.479, 13.1787, 12.8849, 12.598, 12.3174, 12.0429,
         11.7824, 11.5096, 11.2412, 10.9772, 10.7179, 10.4632, 10.2132, 9.96774, 9.72676, 9.49082, 9.25902, 9.03199,
         8.80949, 8.59185, 8.37818, 8.16932, 7.96484, 7.76451, 7.56869, 7.37695, 7.18953, 7.0065, 6.82741, 6.65222,
         6.48092, 6.31378, 6.15069, 5.99126, 5.83532, 5.68325, 5.53479, 5.38979, 5.24833, 5.11032, 4.97558, 4.84418,
         4.71598, 4.59096, 4.46898, 4.35005, 4.23413, 4.12106, 4.01086, 3.90339, 3.79871, 3.69664, 3.59721, 3.50029,
         3.40589, 3.3139, 3.22426, 3.13699, 3.05195, 2.96915, 2.88846, 2.80987, 2.7334, 2.65895, 2.5864, 2.51575,
         2.44699, 2.38004, 2.3149, 2.25139, 2.18962, 2.12952, 2.07105, 2.01411, 1.95872, 1.90474, 1.85226, 1.80112,
         1.75142, 1.70309, 1.65594, 1.61012, 1.5656, 1.52219, 1.48005, 1.43895, 1.39897, 1.36011, 1.32229, 1.2855,
         1.2497, 1.21487, 1.18098, 1.14801, 1.11595, 1.08475, 1.05439, 1.02486, 0.996119, 0.968173, 0.940974, 0.914524,
         0.888791, 0.863753, 0.839401, 0.815708, 0.792654, 0.770227, 0.748408, 0.72718, 0.706528, 0.686435, 0.666886,
         0.647866, 0.629361, 0.611357, 0.593839, 0.576795, 0.56021, 0.544073, 0.528371, 0.525017, 3.85811, 3.78519,
         3.6939, 3.6042, 3.51608, 3.42956, 3.34463, 3.26132, 3.1796, 3.09948, 3.02096, 2.94403, 2.86868, 2.7949,
         2.72267, 2.65199, 2.58283, 2.5152, 2.44905, 2.38439, 2.32119, 2.25943, 2.19909, 2.14015, 2.08259, 2.0264,
         1.97154, 1.91799, 1.86574, 1.81476, 1.76502, 1.71652, 1.66921, 1.62308, 1.57811, 1.53428, 1.49155, 1.44992,
         1.40935, 1.36982, 1.33132, 1.29382, 1.25729, 1.22173, 1.18709, 1.15338, 1.12055, 1.0886, 1.0575, 1.02724,
         0.99779, 0.969135, 0.941255, 0.914132, 0.887748]],
    'Br':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.5497999999999998, 1.55, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.7819, 1.7821, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795,
         2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611,
         2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.473600000000001,
         13.473799999999999, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 10.3082, 10.317, 10.3222, 10.3268, 10.3374, 10.3725, 10.3733, 10.3417, 10.2919, 10.2304, 10.1602, 10.0832,
         10.0011, 9.91476, 9.82528, 9.73335, 9.63964, 9.54522, 9.45197, 9.35472, 9.2539, 9.15104, 9.04651, 8.93986,
         8.82982, 8.72291, 8.61713, 8.51107, 8.40366, 8.2961, 8.18957, 8.08253, 7.97365, 7.85998, 7.74794, 7.63802,
         7.52717, 7.4112, 7.29633, 7.18307, 7.06722, 6.95124, 6.83022, 6.71055, 6.58978, 6.46503, 6.3341, 6.19362,
         6.03782, 5.87086, 5.68301, 5.44005, 5.01881, 4.70397, 4.78236, 4.94458, 5.10409, 5.28662, 5.17992, 5.00758,
         4.87591, 4.7365, 4.58138, 4.44235, 4.31084, 4.17885, 4.04002, 3.90447, 3.77359, 3.64515, 3.51865, 3.39434,
         3.27238, 3.15339, 3.03751, 2.9252, 2.82119, 2.72718, 2.64538, 2.58033, 2.53929, 2.54628, 2.60514, 2.63093,
         2.6382, 2.64529, 2.65608, 2.67457, 2.70524, 2.75992, 2.83661, 2.90459, 2.97084, 3.04474, 3.1299, 3.23125,
         3.35636, 3.53026, 3.73627, 3.91159, 4.06866, 4.22427, 4.38223, 4.54667, 4.72856, 4.91473, 5.09557, 5.27781,
         5.46392, 5.65508, 5.84792, 6.04807, 6.2717, 6.51812, 6.78961, 7.09257, 7.44074, 7.88928, 8.33263, 8.73032,
         9.10381, 9.47423, 9.84936, 10.2387, 10.6965, 11.1175, 11.4972, 11.863, 12.2205, 12.5732, 12.9238, 13.2751,
         13.6305, 13.9997, 14.3663, 14.7286, 15.0923, 15.4627, 15.8465, 16.2576, 16.7337, 17.1778, 17.5746, 17.9352,
         18.2686, 18.5842, 18.8852, 19.1737, 19.4517, 19.7208, 19.9815, 20.2349, 20.4822, 20.7237, 20.9603, 21.193,
         21.4222, 21.6486, 21.873, 22.0977, 22.3249, 22.5591, 22.8086, 23.0567, 23.2741, 23.4736, 23.6612, 23.8391,
         24.0092, 24.173, 24.3351, 24.4908, 24.6393, 24.7788, 24.9102, 25.0356, 25.156, 25.2719, 25.384, 25.4946,
         25.602, 25.7057, 25.8038, 25.9004, 25.9943, 26.0778, 26.1535, 26.2247, 26.2927, 26.3579, 26.4211, 26.4854,
         26.5496, 26.6088, 26.6523, 26.6794, 26.693, 26.7124, 26.7481, 26.789, 26.8194, 26.8425, 26.8608, 26.8758,
         26.8886, 26.8985, 26.9017, 26.8992, 26.892, 26.8802, 26.8642, 26.8443, 26.8208, 26.7936, 26.7627, 26.7284,
         26.6901, 26.6474, 26.6, 26.5481, 26.4921, 26.4323, 26.3662, 26.2927, 26.211, 26.1212, 26.023, 25.916, 25.7995,
         25.6727, 25.5345, 25.3836, 25.2186, 25.0377, 24.8383, 24.6174, 24.3707, 24.0935, 23.7797, 23.4205, 23.0039,
         22.5125, 21.9194, 21.1806, 20.2158, 18.8585, 16.6528, 10.8963, -8.00939, -8.00155, 14.3906, 18.5751, 20.7653,
         22.2477, 23.3454, 24.1806, 24.7915, 25.1151, 23.4156, 22.0893, 22.0949, 26.4421, 27.4629, 28.2262, 28.8609,
         29.4112, 29.8997, 30.3367, 30.7417, 31.1155, 31.4551, 31.7653, 32.0507, 32.3138, 32.5565, 32.7811, 32.9891,
         33.1818, 33.3601, 33.5253, 33.6783, 33.8199, 33.9512, 34.0727, 34.1848, 34.2884, 34.3844, 34.4724, 34.5536,
         34.6279, 34.6961, 34.7588, 34.8156, 34.8674, 34.9143, 34.9566, 34.9945, 35.0286, 35.059, 35.0856, 35.1088,
         35.1289, 35.1461, 35.1603, 35.172, 35.1812, 35.188, 35.1927, 35.1953, 35.1959, 35.1948, 35.1919, 35.1874,
         35.1815, 35.1741, 35.1654, 35.1555, 35.1444, 35.1323, 35.1191, 35.1049, 35.09, 35.0742, 35.0576, 35.0402,
         35.0222, 35.0037, 34.9845, 34.9647, 34.9444, 34.9237, 34.9025, 34.8809, 34.8589, 34.8366, 34.8139, 34.7908,
         34.7673, 34.7437, 34.7197, 34.6954, 34.6708, 34.646, 34.6209, 34.5955, 34.5699, 34.5439, 34.5177, 34.4911,
         34.4642, 34.437, 34.4094, 34.3815, 34.3531, 34.3243, 34.295, 34.2652, 34.2348, 34.2037, 34.172, 34.1395,
         34.1061, 34.0718, 34.0364, 33.9998, 33.962, 33.9226, 33.8815, 33.8385, 33.7932, 33.7455, 33.6948, 33.6408,
         33.5827, 33.52, 33.4516, 33.3763, 33.2925, 33.1981, 33.0899, 32.9635, 32.8116, 32.6225, 32.374, 32.0171,
         31.402, 29.0525, 23.2529, 23.2532, 31.3642, 32.2279, 32.7278, 33.0826, 33.3575, 33.5811, 33.7688, 33.9297,
         34.0697, 34.1929, 34.3023, 34.4001, 34.488, 34.5672, 34.639, 34.7042, 34.7635, 34.8175, 34.8668, 34.9118,
         34.9529, 34.9905, 35.0248, 35.0562, 35.0848, 35.1109, 35.1347, 35.1563, 35.1759, 35.1937, 35.2098, 35.2243,
         35.2373, 35.2489, 35.2593, 35.2684, 35.2765, 35.2835, 35.2896, 35.2947, 35.299, 35.3026, 35.3054, 35.3075,
         35.309, 35.31, 35.3104, 35.3105, 35.313, 35.2999],
        [5.16199, 5.31855, 5.47986, 5.64606, 5.8173, 5.99373, 6.17552, 6.36281, 6.5558, 6.75463, 6.95949, 7.17057,
         7.38804, 7.58343, 7.77469, 7.97079, 8.15805, 8.33656, 8.51899, 8.7054, 8.85695, 9.00806, 9.16174, 9.31805,
         9.47702, 9.54582, 9.60017, 9.65483, 9.70981, 9.76508, 9.82068, 9.87659, 9.93283, 9.98937, 9.99258, 9.97751,
         9.96245, 9.94743, 9.93243, 9.91745, 9.90249, 9.82616, 9.72846, 9.63175, 9.53599, 9.44119, 9.34434, 9.13918,
         8.93851, 8.74225, 8.55031, 8.36258, 8.17896, 7.99939, 7.82375, 7.65197, 7.48396, 7.31964, 7.15499, 6.84731,
         6.55286, 6.27107, 6.0014, 5.74332, 5.49634, 5.25999, 5.03379, 4.81733, 4.61018, 4.41193, 4.2222, 4.04064,
         3.84576, 3.60661, 3.38232, 3.17199, 2.97474, 2.78975, 2.61626, 2.45357, 2.30099, 2.1579, 2.0237, 1.89786,
         1.77983, 1.6675, 1.55775, 1.45522, 1.35945, 1.26997, 1.18639, 1.11133, 1.04371, 0.980199, 0.920558, 0.864544,
         0.815397, 0.769296, 0.725801, 0.684766, 0.647698, 0.621275, 0.595928, 0.571616, 0.549811, 0.538688, 0.52779,
         0.519232, 0.513192, 0.510186, 0.512216, 0.514254, 0.516291, 0.518279, 0.520274, 0.526423, 0.537133, 0.54806,
         0.558161, 0.654814, 1.0561, 1.53791, 1.80131, 1.85264, 1.90543, 1.59532, 1.6274, 1.67037, 1.71446, 1.79608,
         1.89596, 2.0014, 2.11271, 2.2327, 2.37166, 2.51927, 2.67606, 2.84262, 3.01954, 3.20747, 3.4071, 3.61915,
         3.84635, 4.08996, 4.34901, 4.62445, 4.91735, 5.22879, 5.55997, 5.82589, 6.06508, 6.31409, 6.57333, 6.84321,
         7.12417, 7.41667, 7.72117, 7.99945, 8.27373, 8.55742, 8.85084, 9.15431, 9.4682, 9.79285, 10.1286, 10.3839,
         10.6203, 10.862, 11.1093, 11.3621, 11.6208, 11.8853, 12.1279, 12.3736, 12.6242, 12.8799, 13.1408, 13.407,
         13.6943, 13.9949, 14.3021, 14.6161, 14.937, 15.2649, 15.5943, 15.7401, 15.8873, 16.0359, 16.1858, 16.3371,
         16.4899, 16.6195, 16.6621, 16.7047, 16.7475, 16.7904, 16.8334, 16.8765, 16.9197, 16.963, 17.0041, 17.0202,
         17.0363, 17.0523, 17.0685, 17.0848, 17.1008, 17.0615, 16.953, 16.8014, 16.6453, 16.4908, 16.3374, 16.1853,
         16.0347, 15.8857, 15.7381, 15.5915, 15.4466, 15.303, 15.1606, 15.0198, 14.8803, 14.7419, 14.6046, 14.4687,
         14.3345, 14.2009, 14.0653, 13.9238, 13.7416, 13.5455, 13.3527, 13.162, 12.974, 12.7887, 12.6061, 12.425,
         12.2407, 12.0545, 11.8687, 11.6857, 11.5059, 11.3289, 11.1544, 10.983, 10.8134, 10.6437, 10.473, 10.3033,
         10.1366, 9.96328, 9.78887, 9.61983, 9.45455, 9.29263, 9.13351, 8.97713, 8.8228, 8.66345, 8.49574, 8.32399,
         8.15581, 8.00884, 7.8781, 7.7525, 7.6143, 7.46864, 7.32583, 7.18574, 7.04823, 6.91233, 6.77544, 6.63833,
         6.5039, 6.37222, 6.24321, 6.11717, 5.99398, 5.87352, 5.75539, 5.63967, 5.52634, 5.41402, 5.30367, 5.19529,
         5.08921, 4.98481, 4.88204, 4.7773, 4.67393, 4.57191, 4.47206, 4.3744, 4.2789, 4.18557, 4.09423, 4.00483,
         3.91747, 3.83198, 3.74829, 3.66604, 3.58518, 3.50559, 3.42786, 3.35181, 3.27736, 3.2047, 3.13364, 3.06414,
         2.99614, 2.93108, 2.86962, 2.81872, 2.77001, 2.75434, 16.3564, 16.1344, 15.8069, 15.486, 15.1717, 14.8636,
         14.5619, 14.2664, 13.9766, 13.6927, 13.6862, 15.7617, 15.4199, 15.0753, 14.7383, 14.4087, 14.0865, 13.7716,
         13.4637, 13.1705, 12.8665, 12.5672, 12.2728, 11.9839, 11.6995, 11.4205, 11.1469, 10.8783, 10.6147, 10.3561,
         10.1027, 9.85422, 9.61099, 9.37299, 9.13942, 8.91091, 8.68762, 8.46894, 8.2547, 8.0456, 7.84066, 7.64096,
         7.4452, 7.25383, 7.06723, 6.88467, 6.70639, 6.53229, 6.36274, 6.19664, 6.0346, 5.87652, 5.72225, 5.57163,
         5.42476, 5.28146, 5.14165, 5.00538, 4.8724, 4.74275, 4.61636, 4.49313, 4.37301, 4.25594, 4.14184, 4.03063,
         3.92231, 3.81666, 3.7138, 3.61361, 3.51593, 3.42088, 3.32825, 3.238, 3.15011, 3.06455, 2.98128, 2.90015,
         2.8211, 2.74416, 2.66931, 2.59642, 2.5255, 2.45641, 2.38918, 2.32373, 2.25999, 2.19793, 2.13764, 2.07891,
         2.02176, 1.96608, 1.91204, 1.85931, 1.80808, 1.75823, 1.70968, 1.66245, 1.61655, 1.57178, 1.52832, 1.48603,
         1.44482, 1.40479, 1.36582, 1.3279, 1.29101, 1.25513, 1.22022, 1.18625, 1.15322, 1.12107, 1.0898, 1.05937,
         1.02978, 1.00099, 0.972971, 0.945717, 0.91921, 0.893416, 0.868322, 0.843909, 0.820157, 0.79705, 0.774568,
         0.752695, 0.731414, 0.71071, 0.690565, 0.670965, 0.651895, 0.633339, 0.615284, 0.597716, 0.580621, 0.563987,
         0.5478, 0.532049, 0.530333, 3.86204, 3.77868, 3.687, 3.59694, 3.50852, 3.42173, 3.33658, 3.25306, 3.17118,
         3.09092, 3.01229, 2.93528, 2.85986, 2.78604, 2.71379, 2.64311, 2.57397, 2.50636, 2.44026, 2.37565, 2.31251,
         2.25083, 2.19058, 2.13174, 2.07429, 2.0182, 1.96345, 1.91003, 1.85791, 1.80706, 1.75746, 1.70909, 1.66192,
         1.61594, 1.57111, 1.52742, 1.48484, 1.44335, 1.40293, 1.36355, 1.3252, 1.28784, 1.25146, 1.21604, 1.18155,
         1.14797, 1.11529, 1.08348, 1.05252, 1.02239, 0.993072]],
    'Kr':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014, 0.014199999999999999, 0.0142331, 0.0144633, 0.0146973, 0.014935,
         0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551,
         0.0175342, 0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503,
         0.0223053, 0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002,
         0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337,
         0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609,
         0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794,
         0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0937, 0.09390000000000001, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576,
         0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219,
         0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172,
         0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742,
         0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.6783, 1.6785, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005,
         1.8393199999999998, 1.86907, 1.8993, 1.9209, 1.9210999999999998, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795,
         2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611,
         2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3255, 14.325700000000001, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 10.8394, 11.0262, 11.1588, 11.2578, 11.3317, 11.3863, 11.4255, 11.4529, 11.4714, 11.4885, 11.5152,
         11.521, 11.4951, 11.4528, 11.3986, 11.3354, 11.2649, 11.1887, 11.1078, 11.0234, 10.9362, 10.8474, 10.7597,
         10.6689, 10.5721, 10.4721, 10.37, 10.2662, 10.1611, 10.055, 9.94785, 9.83975, 9.73071, 9.61786, 9.50454,
         9.39488, 9.28617, 9.17754, 9.0683, 8.95776, 8.84475, 8.72502, 8.6068, 8.49511, 8.38327, 8.26621, 8.14684,
         8.03206, 7.91946, 7.80632, 7.69072, 7.57325, 7.4543, 7.32952, 7.20083, 7.07047, 6.93454, 6.79191, 6.64226,
         6.48352, 6.31207, 6.12486, 5.92098, 5.69417, 5.43659, 5.13991, 4.78512, 4.33656, 3.72833, 2.70469, 0.289705,
         -0.957579, 1.05818, 8.54865, 9.28653, 7.55698, 7.6477, 7.79766, 7.86211, 7.45947, 6.7934, 6.39007, 5.82447,
         5.21766, 4.77435, 4.41724, 4.1006, 3.81458, 3.55724, 3.33856, 3.15294, 2.98237, 2.83666, 2.76626, 2.73919,
         2.69105, 2.65291, 2.63849, 2.67067, 2.7884, 2.90982, 2.98108, 3.06023, 3.15101, 3.26068, 3.43776, 3.64212,
         3.80711, 3.97342, 4.14864, 4.33952, 4.59171, 4.86869, 5.10268, 5.32626, 5.54767, 5.77214, 6.00366, 6.24921,
         6.51217, 6.77744, 7.04232, 7.31834, 7.61031, 7.93279, 8.28447, 8.62423, 8.95157, 9.28463, 9.62716, 9.9837,
         10.3767, 10.7988, 11.2124, 11.617, 12.0297, 12.459, 12.9563, 13.5018, 13.9959, 14.4236, 14.8207, 15.1968,
         15.5569, 15.9042, 16.241, 16.5689, 16.8893, 17.2032, 17.5117, 17.8155, 18.1153, 18.412, 18.7061, 18.9984,
         19.2895, 19.5802, 19.8713, 20.1638, 20.4589, 20.7582, 21.0638, 21.3793, 21.7112, 22.0815, 22.495, 22.8621,
         23.1645, 23.4456, 23.7081, 23.9559, 24.1912, 24.4158, 24.6312, 24.8384, 25.0385, 25.2324, 25.4208, 25.6048,
         25.7853, 25.9639, 26.1428, 26.328, 26.5275, 26.7112, 26.8628, 27.0027, 27.1319, 27.2521, 27.3644, 27.4695,
         27.5681, 27.6606, 27.7476, 27.8292, 27.9059, 27.9778, 28.0448, 28.1059, 28.1626, 28.2198, 28.276, 28.3308,
         28.3845, 28.4379, 28.492, 28.5508, 28.6142, 28.668, 28.7136, 28.7575, 28.8231, 28.8857, 28.8974, 28.8929,
         28.858, 28.8088, 28.7774, 28.7441, 28.7084, 28.6686, 28.6237, 28.5774, 28.5313, 28.4827, 28.4308, 28.3741,
         28.3117, 28.2444, 28.1719, 28.0937, 28.0094, 27.9187, 27.8211, 27.7161, 27.6032, 27.4815, 27.3493, 27.2048,
         27.046, 26.8719, 26.6802, 26.4683, 26.2325, 25.9685, 25.6705, 25.3302, 24.9372, 24.4731, 23.9095, 23.2068,
         22.2886, 20.9931, 18.8648, 13.0823, -4.63584, -4.62919, 17.027, 20.8321, 22.8532, 24.225, 25.2396, 26.0064,
         26.5511, 26.7802, 24.2882, 24.2985, 26.9138, 28.3254, 29.1554, 29.818, 30.3918, 30.8934, 31.3415, 31.7464,
         32.115, 32.452, 32.7615, 33.0465, 33.3097, 33.5529, 33.7781, 33.9866, 34.1801, 34.3593, 34.5255, 34.6797,
         34.823, 34.9555, 35.078, 35.1916, 35.2968, 35.3941, 35.4833, 35.5657, 35.6416, 35.7112, 35.7749, 35.8329,
         35.8856, 35.9335, 35.9771, 36.0161, 36.0511, 36.0822, 36.1096, 36.1336, 36.1544, 36.1722, 36.1871, 36.1993,
         36.209, 36.2163, 36.2214, 36.2243, 36.2253, 36.2244, 36.2218, 36.2175, 36.2117, 36.2045, 36.1959, 36.186,
         36.175, 36.1628, 36.1496, 36.1355, 36.1204, 36.1046, 36.0878, 36.0704, 36.0523, 36.0335, 36.0142, 35.9943,
         35.9739, 35.953, 35.9317, 35.9099, 35.8877, 35.8652, 35.8423, 35.8191, 35.7956, 35.7717, 35.7476, 35.7232,
         35.6986, 35.6737, 35.6485, 35.623, 35.5973, 35.5713, 35.5451, 35.5186, 35.4917, 35.4646, 35.4371, 35.4093,
         35.381, 35.3524, 35.3233, 35.2938, 35.2636, 35.2329, 35.2015, 35.1694, 35.1365, 35.1027, 35.0679, 35.0319,
         34.9947, 34.956, 34.9157, 34.8735, 34.8292, 34.7824, 34.7329, 34.68, 34.6231, 34.5617, 34.4947, 34.4209,
         34.3387, 34.2459, 34.1393, 34.0141, 33.8631, 33.6737, 33.4217, 33.0515, 32.3765, 24.668, 24.6682, 29.8148,
         32.7062, 33.437, 33.8836, 34.2071, 34.4605, 34.6679, 34.8428, 34.9931, 35.1241, 35.2397, 35.3423, 35.4342,
         35.5168, 35.5913, 35.6589, 35.7202, 35.7759, 35.8268, 35.8731, 35.9154, 35.9541, 35.9894, 36.0216, 36.051,
         36.0779, 36.1023, 36.1246, 36.1448, 36.1632, 36.1798, 36.1947, 36.2082, 36.2203, 36.2311, 36.2406, 36.2491,
         36.2565, 36.2629, 36.2684, 36.273, 36.2769, 36.2801, 36.2826, 36.2846, 36.2891, 36.2768],
        [1.99153e-15, 2.02374e-15, 2.05647e-15, 2.08974e-15, 2.12354e-15, 2.15788e-15, 2.19278e-15, 2.22825e-15,
         2.26429e-15, 2.30091e-15, 2.33813e-15, 2.37595e-15, 2.41438e-15, 2.45343e-15, 2.49311e-15, 2.53343e-15,
         2.57441e-15, 2.61605e-15, 2.65836e-15, 2.70136e-15, 2.74505e-15, 2.78814e-15, 6.40385, 6.46967, 6.94182,
         7.44844, 7.89396, 8.34952, 8.79845, 9.10398, 9.42012, 9.74725, 10.0254, 10.2012, 10.3801, 10.5621, 10.6206,
         10.6327, 10.6448, 10.6624, 10.7073, 10.7525, 10.7979, 10.8398, 10.8691, 10.8984, 10.9277, 10.9496, 10.9467,
         10.9439, 10.941, 10.9382, 10.9049, 10.8149, 10.7257, 10.6372, 10.542, 10.3024, 10.0683, 9.83943, 9.61581,
         9.39726, 9.18368, 8.97496, 8.76542, 8.53924, 8.31891, 8.10425, 7.78196, 7.41784, 7.07074, 6.7399, 6.42453,
         6.12392, 5.83737, 5.56424, 5.30389, 5.05571, 4.81209, 4.53378, 4.27156, 4.02451, 3.79174, 3.57244, 3.36583,
         3.17116, 2.98775, 2.81495, 2.65214, 2.49875, 2.35423, 2.20946, 2.07338, 1.94569, 1.82585, 1.7134, 1.60787,
         1.50884, 1.41592, 1.32871, 1.24688, 1.17008, 1.10368, 1.04268, 0.985056, 0.930615, 0.879182, 0.830593,
         0.784687, 0.744512, 0.717395, 0.691267, 0.666091, 0.641831, 0.626536, 0.617524, 0.608641, 0.599885, 0.59154,
         0.586506, 0.581515, 0.576566, 0.576809, 0.577702, 0.578596, 0.581373, 0.585022, 0.588694, 0.59239, 0.599113,
         0.608538, 0.618111, 0.631125, 0.647678, 0.664665, 0.682097, 0.700901, 0.726307, 0.921521, 5.96658, 10.5187,
         13.6057, 7.23264, 6.71549, 5.61185, 4.68955, 3.91886, 2.90898, 2.62988, 2.37755, 2.14943, 2.29029, 2.5072,
         2.74464, 3.00458, 3.28914, 3.60064, 3.94164, 4.28982, 4.65401, 5.04912, 5.47778, 5.85185, 6.21786, 6.60676,
         7.01999, 7.45906, 7.87309, 8.19678, 8.53379, 8.88464, 9.24992, 9.63023, 10.0262, 10.3457, 10.6549, 10.9734,
         11.3014, 11.6392, 11.9871, 12.2584, 12.5063, 12.7593, 13.0173, 13.2806, 13.5491, 13.8231, 14.0862, 14.3388,
         14.5959, 14.8577, 15.1241, 15.3953, 15.6229, 15.8259, 16.0315, 16.2397, 16.4507, 16.6644, 16.8809, 17.0634,
         17.2027, 17.3431, 17.4848, 17.6275, 17.7714, 17.8289, 17.7655, 17.7023, 17.6394, 17.5766, 17.5141, 17.4518,
         17.3898, 17.3279, 17.2663, 17.2049, 17.1437, 17.0827, 17.022, 16.9614, 16.9011, 16.841, 16.7811, 16.7214,
         16.6619, 16.6027, 16.5436, 16.4848, 16.4261, 16.3677, 16.3095, 16.2515, 16.1096, 15.8945, 15.6822, 15.4728,
         15.2661, 15.0623, 14.8611, 14.6626, 14.4668, 14.2736, 14.083, 13.8949, 13.7093, 13.5263, 13.3456, 13.1674,
         12.9916, 12.818, 12.6261, 12.4012, 12.1802, 11.9632, 11.75, 11.5407, 11.3351, 11.1331, 10.9348, 10.7399,
         10.5486, 10.3606, 10.176, 9.99473, 9.81665, 9.64174, 9.47575, 9.31367, 9.15437, 8.99778, 8.84388, 8.6926,
         8.54392, 8.39778, 8.23913, 8.0741, 7.91237, 7.75389, 7.59857, 7.38934, 7.18259, 6.98164, 6.7863, 6.62975,
         6.48274, 6.33898, 6.19842, 6.06097, 5.92976, 5.80528, 5.68331, 5.56282, 5.4435, 5.32525, 5.20963, 5.09652,
         4.98588, 4.8775, 4.7715, 4.66785, 4.56656, 4.4674, 4.37029, 4.2745, 4.17976, 4.08583, 3.9942, 3.9046, 3.81693,
         3.73116, 3.64734, 3.56549, 3.48534, 3.4065, 3.32874, 3.24928, 3.17129, 3.09524, 3.02097, 2.94847, 2.87773,
         2.80869, 2.78898, 15.6136, 15.3883, 15.0732, 14.7646, 14.4623, 14.1664, 13.8762, 13.592, 13.3139, 13.1213,
         14.9155, 14.8244, 14.5131, 14.2083, 13.916, 13.6174, 13.3218, 13.0295, 12.7411, 12.4559, 12.1748, 11.8976,
         11.6247, 11.3558, 11.0912, 10.8307, 10.5747, 10.323, 10.0756, 9.83282, 9.5946, 9.36072, 9.13092, 8.90593,
         8.68546, 8.46952, 8.25728, 8.04995, 7.8469, 7.64801, 7.45348, 7.26281, 7.07654, 6.89435, 6.71681, 6.54248,
         6.37239, 6.20619, 6.04386, 5.88526, 5.73038, 5.57916, 5.4316, 5.28752, 5.1469, 5.00974, 4.87588, 4.74538,
         4.61805, 4.49384, 4.37277, 4.2548, 4.13972, 4.02756, 3.91828, 3.81176, 3.70796, 3.60688, 3.5084, 3.41247,
         3.31899, 3.228, 3.13937, 3.05306, 2.96911, 2.88729, 2.80768, 2.7302, 2.65474, 2.58136, 2.50992, 2.44042,
         2.37272, 2.30688, 2.24288, 2.18063, 2.12003, 2.06099, 2.0037, 1.94791, 1.89369, 1.84086, 1.78961, 1.73966,
         1.69116, 1.64394, 1.59812, 1.55357, 1.51016, 1.46798, 1.42699, 1.38714, 1.34841, 1.31076, 1.27415, 1.23858,
         1.204, 1.17038, 1.13772, 1.10596, 1.07511, 1.04512, 1.01597, 0.987623, 0.960095, 0.933343, 0.907347, 0.882083,
         0.857534, 0.833678, 0.810496, 0.78797, 0.766083, 0.744814, 0.724147, 0.704066, 0.684553, 0.665594, 0.647172,
         0.629272, 0.61188, 0.59498, 0.578561, 0.562606, 0.547104, 0.532041, 0.518379, 3.71186, 3.70575, 3.61611,
         3.52804, 3.44154, 3.35662, 3.27328, 3.19153, 3.11136, 3.03277, 2.95576, 2.8803, 2.80641, 2.73407, 2.66326,
         2.59397, 2.52618, 2.45989, 2.39507, 2.33171, 2.26978, 2.20927, 2.15016, 2.09242, 2.03604, 1.981, 1.92727,
         1.87484, 1.82367, 1.77375, 1.72506, 1.67757, 1.63126, 1.58611, 1.54209, 1.49919, 1.45737, 1.41663, 1.37693,
         1.33825, 1.30058, 1.26388, 1.22815, 1.19335, 1.15948, 1.12649, 1.09439, 1.06314]],
    'Rb':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.8043, 1.8045, 1.81005,
         1.8393199999999998, 1.8638, 1.864, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.065, 2.0652,
         2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611,
         2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001,
         5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915,
         6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461,
         7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999,
         9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.1996, 15.1998, 15.291799999999999,
         15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435,
         18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 13.0655, 13.6343, 14.1644, 14.6787, 15.2658, 16.0401, 16.4451, 16.6505, 16.7498, 16.7722, 16.7367,
         16.6564, 16.5409, 16.3974, 16.2315, 16.0477, 15.8489, 15.6362, 15.4056, 15.1759, 14.9581, 14.746, 14.5368,
         14.3302, 14.1263, 13.9249, 13.7264, 13.5308, 13.3382, 13.1488, 12.9628, 12.7805, 12.6031, 12.4304, 12.2554,
         12.0804, 11.9066, 11.7342, 11.5629, 11.3924, 11.221, 11.0428, 10.8677, 10.7075, 10.555, 10.407, 10.2619,
         10.1182, 9.97388, 9.82197, 9.67225, 9.53431, 9.40176, 9.27079, 9.14135, 9.01567, 8.89149, 8.76606, 8.6403,
         8.51619, 8.39057, 8.26585, 8.13956, 8.01101, 7.88388, 7.75719, 7.62983, 7.49986, 7.36527, 7.22519, 7.07858,
         6.9201, 6.75599, 6.58566, 6.40438, 6.19894, 5.98093, 5.75257, 5.48986, 5.19676, 4.8869, 4.51152, 4.21037,
         4.36298, 4.65202, 4.75819, 4.39079, 3.94565, 3.62949, 3.36364, 3.10166, 2.8425, 2.60752, 2.40451, 2.26196,
         2.14884, 2.04269, 1.983, 1.95945, 1.93517, 1.95321, 1.97937, 1.99933, 2.02702, 2.09596, 2.1831, 2.26421,
         2.34471, 2.4409, 2.56045, 2.72589, 2.92074, 3.12733, 3.38713, 3.67567, 3.96717, 4.31301, 4.6897, 5.04039,
         5.36986, 5.70947, 6.04802, 6.38746, 6.73667, 7.1022, 7.49079, 7.913, 8.38822, 9.00708, 9.63664, 10.1463,
         10.5526, 10.8904, 11.2292, 11.5939, 11.9673, 12.3476, 12.7356, 13.1336, 13.5457, 13.9826, 14.458, 14.9247,
         15.3598, 15.7953, 16.2355, 16.6871, 17.1613, 17.6935, 18.2749, 18.7838, 19.2141, 19.6151, 19.9905, 20.3441,
         20.6766, 20.9803, 21.2635, 21.5671, 21.8864, 22.2173, 22.5675, 22.9378, 23.3133, 23.6436, 23.9421, 24.2245,
         24.4937, 24.7524, 25.0043, 25.2513, 25.4931, 25.724, 25.9407, 26.147, 26.3446, 26.5357, 26.7214, 26.9028,
         27.0825, 27.2601, 27.4337, 27.5954, 27.7532, 27.9064, 28.0388, 28.1613, 28.2799, 28.3943, 28.5052, 28.6138,
         28.7228, 28.8315, 28.9355, 29.0213, 29.0831, 29.1278, 29.1887, 29.2612, 29.3471, 29.4192, 29.4819, 29.5398,
         29.5945, 29.6473, 29.6989, 29.7419, 29.7782, 29.8098, 29.8375, 29.8618, 29.8826, 29.8983, 29.9096, 29.9175,
         29.9228, 29.9249, 29.922, 29.9142, 29.9019, 29.8852, 29.8647, 29.8414, 29.8173, 29.7881, 29.7539, 29.7154,
         29.6725, 29.6254, 29.5738, 29.5177, 29.457, 29.3915, 29.3217, 29.2469, 29.1664, 29.0768, 28.9781, 28.8706,
         28.7535, 28.6262, 28.4875, 28.3361, 28.171, 27.9912, 27.7927, 27.571, 27.316, 27.0247, 26.69, 26.3007, 25.8405,
         25.2835, 24.5866, 23.6678, 22.3359, 19.9255, 4.47116, 4.47535, 15.7986, 20.1284, 14.3771, 14.3918, 19.8218,
         23.4852, 25.1074, 26.2065, 26.9961, 27.5089, 27.2104, 25.3302, 25.3402, 28.6552, 29.664, 30.4102, 31.0317,
         31.5718, 32.0512, 32.482, 32.8724, 33.2287, 33.5552, 33.855, 34.1313, 34.3867, 34.6226, 34.8413, 35.0438,
         35.2314, 35.4053, 35.5667, 35.7162, 35.8548, 35.9832, 36.1022, 36.2121, 36.3139, 36.4074, 36.4943, 36.5738,
         36.647, 36.7138, 36.7752, 36.8312, 36.882, 36.928, 36.9696, 37.0069, 37.0402, 37.0697, 37.0957, 37.1184,
         37.1379, 37.1545, 37.1683, 37.1795, 37.1882, 37.1945, 37.1988, 37.2009, 37.2011, 37.1995, 37.1962, 37.1914,
         37.185, 37.1772, 37.1682, 37.1579, 37.1464, 37.1338, 37.1203, 37.1058, 37.0905, 37.0743, 37.0573, 37.0396,
         37.0213, 37.0024, 36.9828, 36.9627, 36.9421, 36.9211, 36.8995, 36.8777, 36.8553, 36.8327, 36.8096, 36.7862,
         36.7626, 36.7387, 36.7144, 36.6898, 36.6649, 36.6398, 36.6145, 36.5888, 36.5629, 36.5367, 36.5102, 36.4834,
         36.4563, 36.4288, 36.4009, 36.3727, 36.344, 36.3149, 36.2852, 36.255, 36.2242, 36.1927, 36.1604, 36.1273,
         36.0933, 36.0583, 36.0221, 35.9846, 35.9455, 35.9049, 35.8622, 35.8174, 35.7701, 35.7198, 35.666, 35.6082,
         35.5455, 35.477, 35.4013, 35.3167, 35.2206, 35.1097, 34.9786, 34.8187, 34.6151, 34.3376, 33.9105, 33.0208,
         25.7196, 25.7199, 32.6205, 33.9981, 34.6009, 34.9964, 35.2915, 35.5265, 35.721, 35.8862, 36.0289, 36.1539,
         36.2644, 36.3629, 36.4512, 36.5308, 36.6027, 36.6679, 36.7272, 36.7813, 36.8305, 36.8755, 36.9165, 36.9541,
         36.9884, 37.0197, 37.0483, 37.0744, 37.0982, 37.1199, 37.1396, 37.1574, 37.1736, 37.1881, 37.2012, 37.213,
         37.2235, 37.2327, 37.2409, 37.2481, 37.2543, 37.2597, 37.2645, 37.2718, 37.2605],
        [0.0696833, 0.0710428, 0.0725292, 0.0744146, 0.076349, 0.0783337, 0.08037, 0.0829975, 0.085993, 0.0890967,
         0.0923123, 0.095644, 0.099207, 0.103755, 0.108511, 0.113485, 0.118687, 0.125355, 0.132968, 0.141044, 0.150192,
         0.160776, 0.172105, 0.184233, 0.199124, 0.21876, 0.414294, 0.889737, 1.91082, 4.10371, 8.81322, 9.74157,
         10.263, 10.8124, 11.3911, 12.0009, 12.6432, 13.2106, 13.6342, 14.0713, 14.5225, 14.9881, 15.4687, 15.9304,
         16.3239, 16.7272, 17.1404, 17.5637, 17.9976, 18.4422, 18.8977, 19.3645, 19.7441, 19.9536, 20.1653, 20.3793,
         20.5955, 20.814, 21.0349, 21.2581, 20.9385, 20.6113, 20.2892, 19.9721, 19.6179, 18.8853, 18.1801, 17.5013,
         16.8478, 16.2187, 15.6131, 15.0301, 14.2168, 13.1815, 12.2216, 11.3316, 10.5064, 9.74125, 9.03186, 8.37413,
         7.7643, 7.19888, 6.67464, 6.18858, 5.73789, 5.32174, 4.9664, 4.63479, 4.32532, 4.03651, 3.76699, 3.51546,
         3.28074, 3.06168, 2.85725, 2.66646, 2.48842, 2.32227, 2.16721, 2.0225, 1.88159, 1.74799, 1.62386, 1.50856,
         1.40144, 1.30193, 1.20948, 1.1236, 1.04381, 0.99202, 0.946484, 0.903038, 0.861585, 0.822035, 0.784302,
         0.748301, 0.713951, 0.702303, 0.69377, 0.68534, 0.677013, 0.673057, 0.670594, 0.668139, 0.665693, 0.667955,
         0.671485, 0.676306, 0.683734, 0.691245, 0.703644, 0.718507, 0.733684, 0.749181, 0.762427, 0.775589, 0.788978,
         0.802598, 0.817667, 0.840922, 0.864837, 0.889432, 0.914728, 0.965974, 1.0216, 1.08341, 1.19999, 1.35034,
         1.61097, 2.10889, 2.61845, 2.77437, 2.54704, 2.25945, 2.46738, 2.72927, 2.98313, 3.26059, 3.58013, 3.94302,
         4.34268, 4.78285, 5.1794, 5.5988, 6.05217, 6.47463, 6.89553, 7.34379, 7.73205, 8.1378, 8.56484, 9.01429,
         9.41778, 9.82508, 10.25, 10.6933, 11.1557, 11.6382, 12.0874, 12.5423, 13.0143, 13.4378, 13.858, 14.2914,
         14.6314, 14.9385, 15.252, 15.5657, 15.8651, 16.1703, 16.4813, 16.7983, 17.1214, 17.4507, 17.7864, 18.1285,
         18.1769, 18.1785, 18.1802, 18.2109, 18.3272, 18.4443, 18.5621, 18.6807, 18.8, 18.92, 19.0409, 19.1625, 19.2504,
         19.2836, 19.3168, 19.3501, 19.3835, 19.4169, 19.4504, 19.4839, 19.3816, 19.1986, 19.0172, 18.8376, 18.6596,
         18.4834, 18.3088, 18.1358, 18.0096, 17.8997, 17.7908, 17.6823, 17.566, 17.4319, 17.2334, 17.0118, 16.7935,
         16.5778, 16.3648, 16.1544, 15.9467, 15.7395, 15.5245, 15.3058, 15.0864, 14.8695, 14.6563, 14.4462, 14.2389,
         14.0344, 13.8312, 13.6255, 13.4129, 13.1986, 12.9874, 12.767, 12.5456, 12.335, 12.1293, 11.928, 11.7304,
         11.536, 11.3441, 11.1464, 10.9388, 10.7266, 10.5184, 10.3368, 10.1753, 10.0199, 9.84877, 9.66818, 9.49079,
         9.31666, 9.14561, 8.97615, 8.80413, 8.63078, 8.46096, 8.29442, 8.13111, 7.96977, 7.81015, 7.65243, 7.49794,
         7.34652, 7.19811, 7.04944, 6.90302, 6.75894, 6.61784, 6.48002, 6.34543, 6.21593, 6.08696, 5.95837, 5.83239,
         5.70906, 5.58831, 5.47018, 5.3545, 5.24123, 5.1304, 5.02195, 4.91584, 4.81004, 4.70463, 4.59924, 4.49628,
         4.39564, 4.29725, 4.20103, 4.10688, 4.01473, 3.92486, 3.83577, 3.74682, 3.65225, 3.55898, 3.46804, 3.37944,
         3.29312, 3.20902, 3.12708, 3.04723, 2.96942, 2.889, 2.80978, 2.74784, 11.5981, 11.5078, 11.047, 10.6813,
         14.889, 14.837, 14.5339, 14.237, 13.9462, 13.6613, 13.3855, 13.1122, 13.0547, 14.7486, 14.5089, 14.2077,
         13.9092, 13.6132, 13.3199, 13.0301, 12.7435, 12.4606, 12.1813, 11.9056, 11.634, 11.3665, 11.103, 10.8435,
         10.5885, 10.3374, 10.0908, 9.84833, 9.61038, 9.37689, 9.14757, 8.92274, 8.70231, 8.48616, 8.27444, 8.06675,
         7.86361, 7.66477, 7.4699, 7.27916, 7.09288, 6.91044, 6.73207, 6.55772, 6.3873, 6.22078, 6.05806, 5.89908,
         5.74385, 5.59227, 5.44433, 5.29984, 5.15888, 5.02129, 4.88707, 4.75612, 4.62845, 4.50384, 4.38241, 4.26401,
         4.1486, 4.03608, 3.92644, 3.81954, 3.71546, 3.61397, 3.51519, 3.41889, 3.32518, 3.23389, 3.14492, 3.05839,
         2.97409, 2.89202, 2.81217, 2.73438, 2.65871, 2.58503, 2.51341, 2.44369, 2.37584, 2.30986, 2.24561, 2.18316,
         2.12231, 2.0632, 2.00574, 1.94981, 1.89537, 1.8425, 1.7911, 1.74111, 1.69249, 1.64523, 1.59926, 1.55456,
         1.51113, 1.46891, 1.42785, 1.38795, 1.34918, 1.31147, 1.27485, 1.23924, 1.20463, 1.171, 1.13833, 1.10655,
         1.07569, 1.0457, 1.01656, 0.988242, 0.960729, 0.933996, 0.908023, 0.882786, 0.858268, 0.834447, 0.811303,
         0.788819, 0.766974, 0.745753, 0.725136, 0.705108, 0.685651, 0.666749, 0.648388, 0.63055, 0.613223, 0.59639,
         0.580039, 0.564155, 0.548725, 0.533737, 0.524605, 3.68556, 3.65214, 3.5647, 3.47872, 3.39422, 3.31121, 3.22968,
         3.14966, 3.07115, 2.99414, 2.91862, 2.84461, 2.77209, 2.70105, 2.63149, 2.5634, 2.49675, 2.43155, 2.36777,
         2.3054, 2.24442, 2.18482, 2.12658, 2.06967, 2.01409, 1.95981, 1.90681, 1.85507, 1.80457, 1.75529, 1.70721,
         1.6603, 1.61456, 1.56994, 1.52644, 1.48403, 1.4427, 1.40241, 1.36314, 1.32489, 1.28762, 1.25131, 1.21595,
         1.18152]],
    'Sr':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.9395, 1.9397, 1.96124, 1.99296, 2.0067, 2.0069, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.2161999999999997, 2.2164, 2.22985, 2.26592, 2.3025700000000002, 2.33981,
         2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703,
         2.79146, 2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326,
         3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613,
         3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.1045, 16.1047, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386,
         18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 5.58141, 6.6073, 7.63084, 8.7709, 9.69125, 10.4429, 11.0918, 11.6698, 12.195, 12.6843, 13.1613, 13.6862,
         14.1362, 14.4427, 14.6643, 14.8303, 14.9522, 15.0386, 15.0958, 15.1291, 15.1431, 15.1421, 15.1304, 15.116,
         15.1154, 15.1207, 15.0583, 14.962, 14.8447, 14.7127, 14.5698, 14.4189, 14.2619, 14.1006, 13.9359, 13.7683,
         13.5982, 13.4305, 13.2643, 13.0991, 12.935, 12.772, 12.6102, 12.4493, 12.2889, 12.1294, 11.9724, 11.8166,
         11.6612, 11.5054, 11.3472, 11.1805, 11.0136, 10.8617, 10.7174, 10.5746, 10.4313, 10.282, 10.1443, 10.0094,
         9.87887, 9.75628, 9.63849, 9.52258, 9.40891, 9.29799, 9.18864, 9.0796, 8.9687, 8.85941, 8.75147, 8.64363,
         8.53538, 8.42636, 8.31675, 8.20536, 8.09019, 7.97126, 7.84816, 7.7203, 7.58691, 7.44686, 7.29903, 7.14368,
         6.97897, 6.80222, 6.60827, 6.39577, 6.16448, 5.91059, 5.62348, 5.29974, 4.90059, 4.60439, 4.56325, 4.37806,
         4.07743, 3.71998, 3.34108, 2.97861, 2.6165, 2.32405, 2.12973, 1.93804, 1.77018, 1.69456, 1.72149, 1.72234,
         1.72733, 1.82247, 1.89822, 1.97473, 2.08111, 2.27211, 2.49029, 2.68376, 2.87596, 3.11275, 3.36572, 3.60571,
         3.85244, 4.11125, 4.38289, 4.68302, 5.07149, 5.46285, 5.8139, 6.15796, 6.50922, 6.89036, 7.26412, 7.63325,
         8.0063, 8.38948, 8.78673, 9.201, 9.64337, 10.1235, 10.6582, 11.3146, 11.9672, 12.5906, 13.2334, 14.0056,
         14.6405, 15.1737, 15.6327, 16.0272, 16.4314, 16.8373, 17.2385, 17.6346, 18.0262, 18.4138, 18.7988, 19.1826,
         19.5664, 19.9521, 20.3424, 20.7408, 21.1555, 21.6053, 22.0816, 22.5518, 22.9583, 23.3271, 23.6718, 23.9986,
         24.3106, 24.6107, 24.9071, 25.1924, 25.4653, 25.7235, 25.9699, 26.2072, 26.4361, 26.658, 26.8746, 27.0894,
         27.3017, 27.5082, 27.7025, 27.8907, 28.0731, 28.2444, 28.4049, 28.5581, 28.7055, 28.8485, 28.9883, 29.1294,
         29.2702, 29.4042, 29.5167, 29.6073, 29.68, 29.7612, 29.8662, 29.9787, 30.0751, 30.1603, 30.2386, 30.3123,
         30.3828, 30.4496, 30.5085, 30.561, 30.6083, 30.6515, 30.6907, 30.726, 30.7571, 30.7843, 30.8085, 30.8312,
         30.8504, 30.8648, 30.8736, 30.8779, 30.8781, 30.8742, 30.8688, 30.8616, 30.849, 30.8313, 30.8094, 30.7835,
         30.7536, 30.7197, 30.6822, 30.6408, 30.5954, 30.547, 30.4951, 30.4385, 30.3746, 30.3037, 30.2258, 30.141,
         30.0489, 29.9491, 29.841, 29.7237, 29.5963, 29.4578, 29.3069, 29.1421, 28.9615, 28.7625, 28.5422, 28.2964,
         28.0198, 27.7056, 27.3422, 26.9184, 26.4154, 25.8, 25.0138, 23.9363, 22.2438, 18.0503, 5.2801, 5.28403,
         20.0566, 21.0943, 15.2358, 15.2501, 22.8854, 25.2033, 26.5585, 27.4987, 28.1344, 28.3227, 25.5952, 25.6051,
         28.767, 30.1929, 31.0805, 31.7865, 32.3848, 32.9074, 33.3715, 33.7884, 34.1654, 34.5082, 34.8211, 35.1081,
         35.3718, 35.6143, 35.8373, 36.0434, 36.2339, 36.4097, 36.5718, 36.7218, 36.8604, 36.9884, 37.1064, 37.2152,
         37.3154, 37.4079, 37.4929, 37.5709, 37.6422, 37.7072, 37.7668, 37.821, 37.8701, 37.9145, 37.9544, 37.9901,
         38.0218, 38.0499, 38.0746, 38.0959, 38.1142, 38.1297, 38.1424, 38.1527, 38.1605, 38.166, 38.1696, 38.1711,
         38.1707, 38.1687, 38.165, 38.1598, 38.1532, 38.1452, 38.136, 38.1256, 38.1141, 38.1017, 38.0882, 38.0738,
         38.0586, 38.0426, 38.0259, 38.0085, 37.9905, 37.9719, 37.9527, 37.933, 37.9129, 37.8923, 37.8712, 37.8497,
         37.8279, 37.8056, 37.7831, 37.7602, 37.737, 37.7135, 37.6897, 37.6655, 37.6411, 37.6165, 37.5916, 37.5663,
         37.5407, 37.5148, 37.4886, 37.4621, 37.4352, 37.4079, 37.3803, 37.3522, 37.3236, 37.2945, 37.2648, 37.2345,
         37.2036, 37.1719, 37.1394, 37.1059, 37.0715, 37.0359, 36.999, 36.9607, 36.9208, 36.8791, 36.8352, 36.789,
         36.7399, 36.6877, 36.6316, 36.5711, 36.5053, 36.4329, 36.3526, 36.2622, 36.1589, 36.0385, 35.8946, 35.7164,
         35.4841, 35.1551, 34.6058, 32.9628, 26.4571, 26.4573, 34.32, 35.2344, 35.7413, 36.0956, 36.3681, 36.5889,
         36.7737, 36.9318, 37.0692, 37.19, 37.2972, 37.393, 37.479, 37.5566, 37.6268, 37.6906, 37.7486, 37.8014,
         37.8496, 37.8936, 37.9338, 37.9705, 38.004, 38.0346, 38.0625, 38.088, 38.1112, 38.1323, 38.1514, 38.1687,
         38.1843, 38.1984, 38.211, 38.2223, 38.2324, 38.2413, 38.2494, 38.2602, 38.2499],
        [0.171262, 0.174896, 0.178608, 0.182398, 0.186269, 0.190614, 0.195136, 0.199766, 0.204505, 0.209357, 0.214324,
         0.21941, 0.225385, 0.231522, 0.237827, 0.244303, 0.250955, 0.258014, 0.266925, 0.276144, 0.285681, 0.295547,
         0.305755, 0.31641, 0.329067, 0.34223, 0.35592, 0.370157, 0.384964, 0.400363, 0.416922, 0.434177, 0.452147,
         0.47086, 0.490347, 0.510641, 0.532703, 0.560547, 0.589847, 0.620679, 0.653122, 0.687261, 0.723863, 0.769653,
         0.818341, 0.870107, 0.925148, 0.983672, 1.06431, 1.16788, 1.28153, 2.58184, 5.67161, 12.3368, 13.4118, 14.5585,
         15.7782, 16.8964, 17.7614, 18.6706, 19.2298, 19.7747, 20.335, 20.456, 20.3882, 20.3207, 20.0875, 19.7809,
         19.479, 19.1817, 18.7445, 18.0643, 17.4087, 16.7769, 16.1681, 15.5813, 15.0159, 14.4709, 13.9292, 13.1751,
         12.4618, 11.7872, 11.1491, 10.5455, 9.97465, 9.43467, 8.92392, 8.44081, 7.98386, 7.55165, 7.14284, 6.75616,
         6.3163, 5.87774, 5.46965, 5.08988, 4.73648, 4.40762, 4.10159, 3.81682, 3.55181, 3.3052, 3.07572, 2.86507,
         2.67044, 2.48903, 2.31994, 2.16233, 2.01544, 1.87852, 1.75091, 1.63196, 1.5233, 1.42235, 1.3281, 1.2401,
         1.15792, 1.08119, 1.00955, 0.969212, 0.93467, 0.901357, 0.869234, 0.842044, 0.823873, 0.817443, 0.811064,
         0.816739, 0.823115, 0.829541, 0.836017, 0.845842, 0.855911, 0.866099, 0.876409, 0.887895, 0.903027, 0.918415,
         0.934067, 0.949985, 0.966175, 0.982639, 0.997154, 1.01132, 1.02569, 1.04026, 1.05505, 1.07004, 1.08524, 1.1019,
         1.11954, 1.13746, 1.15567, 1.17417, 1.20264, 1.23546, 1.28442, 1.33915, 1.44541, 1.57652, 1.99485, 2.21466,
         2.28553, 2.41905, 2.57557, 2.86818, 3.20328, 3.62092, 4.1255, 4.62736, 5.13125, 5.68999, 6.30959, 6.83708,
         7.3391, 7.87796, 8.4178, 8.89448, 9.39816, 9.93035, 10.4927, 10.9233, 11.3608, 11.8157, 12.2889, 12.6906,
         13.0968, 13.5161, 13.9288, 14.3528, 14.7898, 15.24, 15.554, 15.8709, 16.1942, 16.5241, 16.8511, 17.1427,
         17.4393, 17.741, 18.048, 18.3602, 18.6789, 19.0088, 19.3444, 19.686, 20.0229, 20.1598, 20.2977, 20.4364,
         20.4847, 20.3331, 20.1826, 20.0332, 19.9267, 19.8652, 19.8038, 19.7428, 19.6821, 19.6215, 19.561, 19.5008,
         19.4408, 19.3808, 19.3209, 19.2612, 19.2016, 19.1424, 19.0674, 18.9573, 18.7584, 18.5266, 18.2977, 18.0717,
         17.8485, 17.6276, 17.4097, 17.1928, 16.9694, 16.7419, 16.5139, 16.2899, 16.0682, 15.8493, 15.6334, 15.4206,
         15.2094, 14.9961, 14.7755, 14.5532, 14.3345, 14.1104, 13.8856, 13.664, 13.4465, 13.2328, 13.0226, 12.8156,
         12.611, 12.3991, 12.1753, 11.9455, 11.7201, 11.5229, 11.3473, 11.1775, 10.9875, 10.7852, 10.5865, 10.3916,
         10.2002, 10.0109, 9.82093, 9.63106, 9.4448, 9.26218, 9.08311, 8.90671, 8.73301, 8.56208, 8.39438, 8.22998,
         8.0688, 7.90588, 7.74494, 7.58616, 7.43076, 7.2786, 7.12964, 6.98536, 6.84129, 6.69726, 6.55634, 6.41842,
         6.28342, 6.1511, 6.02166, 5.89509, 5.77091, 5.64946, 5.53074, 5.41229, 5.29437, 5.17661, 5.06127, 4.94853,
         4.83838, 4.7307, 4.62544, 4.52258, 4.4219, 4.32351, 4.22743, 4.13383, 4.04241, 3.95307, 3.8658, 3.78045,
         3.69695, 3.6152, 3.53527, 3.45713, 3.38438, 3.31443, 3.24684, 3.18064, 3.11578, 3.05223, 2.98998, 2.97123,
         11.764, 11.4624, 11.0379, 10.8609, 15.132, 14.9479, 14.6279, 14.3148, 14.0082, 13.7083, 13.4144, 13.2361,
         15.2077, 15.0779, 14.739, 14.4054, 14.0767, 13.7529, 13.4348, 13.1219, 12.8145, 12.5121, 12.2152, 11.9238,
         11.6383, 11.3575, 11.0821, 10.8123, 10.5483, 10.289, 10.035, 9.78634, 9.54315, 9.30473, 9.07165, 8.84328,
         8.62019, 8.40194, 8.18871, 7.98001, 7.77603, 7.57647, 7.38193, 7.19179, 7.00602, 6.82458, 6.64742, 6.4744,
         6.30553, 6.14074, 5.97991, 5.82298, 5.66985, 5.52048, 5.3748, 5.2327, 5.09411, 4.95892, 4.8272, 4.69872,
         4.57351, 4.45143, 4.33245, 4.21654, 4.10354, 3.99345, 3.88617, 3.78168, 3.67982, 3.58062, 3.48401, 3.38985,
         3.29825, 3.20894, 3.12199, 3.03733, 2.95494, 2.87467, 2.79654, 2.72044, 2.64635, 2.57425, 2.50402, 2.43567,
         2.36917, 2.30441, 2.24132, 2.18004, 2.12035, 2.06216, 2.00563, 1.95054, 1.89697, 1.8449, 1.79419, 1.74478,
         1.69672, 1.64997, 1.60447, 1.5602, 1.51713, 1.4752, 1.43441, 1.39472, 1.35611, 1.31853, 1.28195, 1.24638,
         1.21176, 1.17808, 1.1453, 1.11341, 1.08238, 1.05219, 1.02281, 0.994222, 0.966406, 0.939339, 0.913002, 0.887374,
         0.862436, 0.838169, 0.814555, 0.791575, 0.769214, 0.747453, 0.726275, 0.705667, 0.68561, 0.666091, 0.647094,
         0.628606, 0.610611, 0.593098, 0.576052, 0.559459, 0.54331, 0.539702, 3.75733, 3.68752, 3.59899, 3.51194,
         3.42639, 3.34234, 3.25981, 3.1788, 3.09932, 3.02136, 2.94492, 2.87, 2.7966, 2.72469, 2.65429, 2.58537, 2.51793,
         2.45194, 2.3874, 2.32429, 2.26259, 2.20229, 2.14336, 2.0858, 2.02957, 1.97466, 1.92105, 1.86873, 1.81766,
         1.76782, 1.7192, 1.67178, 1.62553, 1.58043, 1.53645, 1.49359, 1.45181, 1.41109, 1.37142, 1.33276]],
    'Y':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.0799000000000003, 2.0801, 2.09124, 2.12506,
         2.1554, 2.1555999999999997, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981,
         2.3724000000000003, 2.3726, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793,
         2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355,
         3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682,
         3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.0383, 17.0385, 17.1094,
         17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871,
         20.412, 20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076,
         23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -5.81131, -4.33537, -2.91511, -1.09221, 0.362823, 1.73328, 3.19011, 4.75193, 6.09217, 7.42152, 8.94012,
         10.263, 11.2402, 12.0398, 12.7167, 13.3002, 13.8095, 14.259, 14.6605, 15.0245, 15.362, 15.6867, 16.0259,
         16.4604, 16.7656, 16.9142, 16.9731, 16.9764, 16.9383, 16.8684, 16.7738, 16.6598, 16.5309, 16.3904, 16.2413,
         16.0863, 15.9287, 15.7749, 15.6115, 15.4366, 15.2555, 15.0712, 14.885, 14.6976, 14.509, 14.3187, 14.124,
         13.9138, 13.7254, 13.5542, 13.393, 13.2381, 13.0874, 12.9395, 12.7928, 12.6433, 12.4902, 12.3483, 12.2124,
         12.0764, 11.9309, 11.7946, 11.6706, 11.5522, 11.437, 11.3231, 11.2069, 11.0864, 10.9755, 10.8698, 10.7671,
         10.6664, 10.5667, 10.4668, 10.3651, 10.2665, 10.1698, 10.0739, 9.97899, 9.88635, 9.7916, 9.6932, 9.59148,
         9.48646, 9.37724, 9.26462, 9.14829, 9.02732, 8.90084, 8.7675, 8.62502, 8.47683, 8.32065, 8.15178, 7.97311,
         7.78327, 7.57191, 7.34255, 7.10432, 6.83081, 6.55359, 6.32371, 6.11114, 5.87024, 5.54845, 5.16028, 4.75829,
         4.34515, 3.8674, 3.45308, 3.13702, 2.85995, 2.62273, 2.50523, 2.46748, 2.45511, 2.53544, 2.82368, 3.07377,
         3.31658, 3.59031, 4.00603, 4.32951, 4.59975, 4.85185, 5.10083, 5.35835, 5.64865, 5.94021, 6.22556, 6.51712,
         6.83829, 7.19041, 7.51985, 7.83364, 8.14976, 8.48081, 8.81499, 9.14971, 9.4926, 9.84803, 10.2212, 10.6383,
         11.0614, 11.4812, 11.9151, 12.3785, 12.9082, 13.4052, 13.8835, 14.3605, 14.8441, 15.3409, 15.8581, 16.4535,
         17.0262, 17.5702, 18.1182, 18.6803, 19.2673, 19.9808, 20.6426, 21.2373, 21.8245, 22.4716, 23.1403, 23.6932,
         24.1712, 24.6012, 24.9932, 25.3528, 25.6829, 25.969, 26.2407, 26.515, 26.783, 27.0431, 27.295, 27.5391, 27.776,
         28.0067, 28.235, 28.4544, 28.6635, 28.8639, 29.0573, 29.2445, 29.4262, 29.6032, 29.7762, 29.9462, 30.1143,
         30.2823, 30.4512, 30.6555, 30.8356, 30.981, 31.1121, 31.2316, 31.3413, 31.4425, 31.5361, 31.6228, 31.7032,
         31.7778, 31.847, 31.9115, 31.9714, 32.0273, 32.0795, 32.1282, 32.174, 32.2176, 32.2594, 32.308, 32.3539,
         32.3856, 32.4079, 32.4233, 32.4328, 32.4369, 32.436, 32.4302, 32.4193, 32.4014, 32.3815, 32.3608, 32.3375,
         32.3113, 32.2822, 32.2499, 32.2146, 32.1759, 32.134, 32.0885, 32.0395, 31.9867, 31.93, 31.8692, 31.8041,
         31.7342, 31.6594, 31.5792, 31.4931, 31.4004, 31.2998, 31.1896, 31.074, 30.9531, 30.8238, 30.6848, 30.5345,
         30.3711, 30.1924, 29.9958, 29.7781, 29.535, 29.2608, 28.9523, 28.5942, 28.1623, 27.6327, 26.9634, 26.0698,
         24.7492, 22.2099, 7.98032, 7.98382, 20.3061, 23.2493, 18.1013, 18.1127, 22.3519, 25.97, 27.4629, 28.5215,
         29.3144, 29.7635, 27.7086, 27.7169, 29.5078, 31.085, 31.9055, 32.5559, 33.1126, 33.6054, 34.0506, 34.459,
         34.8386, 35.1952, 35.5539, 35.9049, 36.2085, 36.4707, 36.7046, 36.9155, 37.1066, 37.2803, 37.4384, 37.5824,
         37.713, 37.83, 37.9362, 38.0358, 38.1294, 38.2163, 38.2969, 38.3718, 38.4416, 38.5081, 38.5712, 38.6261,
         38.6717, 38.7106, 38.7425, 38.7635, 38.7817, 38.8043, 38.8269, 38.8487, 38.8695, 38.8892, 38.908, 38.9261,
         38.9442, 38.9643, 38.9854, 39.0006, 39.0096, 39.0157, 39.0192, 39.0205, 39.0199, 39.0175, 39.0136, 39.0082,
         39.0016, 38.9938, 38.9849, 38.9751, 38.9643, 38.9528, 38.9405, 38.9277, 38.9143, 38.9, 38.8851, 38.8697,
         38.8539, 38.8376, 38.821, 38.8041, 38.7871, 38.7699, 38.7529, 38.7361, 38.7215, 38.7081, 38.6912, 38.6714,
         38.6499, 38.6271, 38.6031, 38.5783, 38.5525, 38.5258, 38.4983, 38.4699, 38.4398, 38.4085, 38.3778, 38.3476,
         38.3173, 38.2867, 38.2558, 38.2243, 38.1923, 38.1596, 38.126, 38.0916, 38.0562, 38.0196, 37.9818, 37.9424,
         37.9014, 37.8585, 37.8134, 37.7657, 37.7151, 37.6611, 37.6031, 37.5402, 37.4716, 37.3959, 37.3113, 37.2156,
         37.1053, 36.9754, 36.8176, 36.618, 36.3486, 35.9421, 35.1423, 27.4822, 27.4824, 34.1839, 35.8664, 36.515,
         36.9304, 37.2372, 37.4801, 37.6803, 37.8499, 37.9963, 38.1243, 38.2374, 38.3381, 38.4284, 38.5096, 38.5831,
         38.6497, 38.7102, 38.7653, 38.8155, 38.8614, 38.9032, 38.9415, 38.9765, 39.0084, 39.0375, 39.0641, 39.0883,
         39.1104, 39.1304, 39.1486, 39.165, 39.1798, 39.1931, 39.205, 39.2156, 39.225],
        [1.91773, 1.94593, 1.97456, 2.0036, 2.03307, 2.06298, 2.08995, 2.09147, 2.09299, 2.09452, 2.09604, 2.09757,
         2.0991, 2.0738, 2.04269, 2.01204, 1.98186, 1.95212, 1.92283, 1.89326, 1.82864, 1.76622, 1.70594, 1.64771,
         1.58943, 1.53225, 1.47713, 1.42399, 1.37276, 1.32265, 1.27374, 1.22665, 1.18129, 1.13761, 1.10152, 1.07044,
         1.04024, 1.01089, 0.982368, 0.954653, 0.942543, 0.937272, 0.932031, 0.92682, 0.921637, 0.922103, 0.936428,
         0.950975, 0.965748, 0.98773, 1.02598, 1.06571, 1.10698, 1.15127, 1.23259, 1.31966, 1.41288, 1.51268, 1.65754,
         1.93279, 2.25377, 2.62804, 3.3006, 4.83125, 7.07175, 10.3513, 14.3124, 15.2941, 16.3432, 17.4642, 18.2054,
         18.5804, 18.9631, 19.3538, 19.3689, 19.2585, 19.1487, 18.9752, 18.1654, 17.3902, 16.648, 15.9376, 15.2574,
         14.6063, 13.983, 13.3863, 12.815, 12.2681, 11.7446, 11.2434, 10.7039, 9.92317, 9.19944, 8.52848, 7.90646,
         7.32981, 6.79521, 6.29961, 5.84014, 5.41421, 5.01931, 4.65324, 4.31385, 3.99923, 3.70474, 3.41263, 3.14356,
         2.89569, 2.66738, 2.45706, 2.26333, 2.08488, 1.92049, 1.76906, 1.64162, 1.55336, 1.46983, 1.3908, 1.31602,
         1.24525, 1.1783, 1.11494, 1.05499, 1.01148, 0.976329, 0.942397, 0.909647, 0.881537, 0.877539, 0.87356,
         0.869598, 0.865655, 0.86173, 0.857822, 0.864246, 0.878229, 0.892439, 0.906879, 0.921552, 0.936463, 0.951615,
         0.970106, 0.991478, 1.01332, 1.03565, 1.05846, 1.08108, 1.09817, 1.11553, 1.13316, 1.15107, 1.1695, 1.18957,
         1.20998, 1.23074, 1.25186, 1.27334, 1.29756, 1.32478, 1.35258, 1.38153, 1.41935, 1.4582, 1.49812, 1.56207,
         1.63525, 1.72469, 1.86657, 2.0542, 2.19636, 2.29515, 2.38907, 2.55826, 2.80212, 3.08702, 3.47201, 3.98833,
         4.57353, 5.16459, 5.83202, 6.58572, 7.24273, 7.94585, 8.71724, 9.41805, 9.97403, 10.5119, 11.0702, 11.5651,
         11.9037, 12.2521, 12.6108, 12.9799, 13.3599, 13.7484, 14.0861, 14.4322, 14.7867, 15.1499, 15.4625, 15.751,
         16.0449, 16.3443, 16.6485, 16.9372, 17.2309, 17.5297, 17.8337, 18.1429, 18.4547, 18.7182, 18.9854, 19.2565,
         19.5314, 19.7745, 19.9436, 20.114, 20.2859, 20.4593, 20.6342, 20.8106, 20.9667, 21.0384, 21.1104, 21.1827,
         21.2551, 21.3279, 21.3658, 21.2475, 21.1299, 21.013, 20.8967, 20.6341, 20.2882, 19.9481, 19.6137, 19.2849,
         18.9617, 18.6438, 18.3313, 18.0647, 17.8055, 17.55, 17.2982, 17.05, 16.8053, 16.5642, 16.3265, 16.0923,
         15.8501, 15.6116, 15.3766, 15.1453, 14.9174, 14.6929, 14.4718, 14.254, 14.0395, 13.8282, 13.6202, 13.4152,
         13.2036, 12.9426, 12.6867, 12.4359, 12.19, 11.949, 11.7128, 11.4812, 11.2542, 11.0317, 10.8136, 10.6, 10.3907,
         10.1856, 9.98451, 9.78739, 9.59417, 9.40476, 9.21909, 9.03709, 8.85868, 8.66626, 8.47165, 8.28141, 8.09544,
         7.91365, 7.73593, 7.56222, 7.3924, 7.22179, 7.06587, 6.9133, 6.76403, 6.61799, 6.4751, 6.33529, 6.1985,
         6.06467, 5.93372, 5.80561, 5.68025, 5.55761, 5.43761, 5.32021, 5.20534, 5.09295, 4.98299, 4.87539, 4.77013,
         4.66713, 4.56636, 4.46777, 4.37444, 4.28732, 4.20193, 4.11824, 4.03622, 3.95583, 3.87704, 3.79982, 3.72414,
         3.64997, 3.57727, 3.50602, 3.43619, 3.35901, 3.27801, 3.19896, 3.12181, 3.04653, 2.97306, 2.90137, 2.85492,
         11.1239, 10.9941, 10.613, 10.2874, 14.0289, 14.0069, 13.8098, 13.6156, 13.424, 13.1476, 12.8233, 12.5501,
         14.1143, 14.0784, 13.8104, 13.5475, 13.2896, 13.0367, 12.7885, 12.5451, 12.3063, 12.072, 11.8422, 11.6168,
         11.3588, 11.067, 10.7827, 10.5058, 10.2359, 9.97297, 9.71678, 9.46718, 9.224, 8.98707, 8.75619, 8.5369,
         8.32518, 8.11869, 7.91736, 7.72099, 7.5295, 7.34276, 7.16064, 6.97781, 6.79509, 6.61716, 6.44388, 6.27517,
         6.11086, 5.96692, 5.82638, 5.68915, 5.55515, 5.42429, 5.29653, 5.17178, 5.04996, 4.93102, 4.81486, 4.69328,
         4.57003, 4.45001, 4.33313, 4.21934, 4.10853, 4.00062, 3.89556, 3.79325, 3.69363, 3.59663, 3.50217, 3.4102,
         3.32064, 3.23343, 3.14852, 3.06583, 2.98531, 2.90651, 2.82978, 2.75509, 2.68236, 2.61155, 2.54261, 2.47549,
         2.41015, 2.34653, 2.28459, 2.22428, 2.16557, 2.10841, 2.04884, 1.98689, 1.92681, 1.86854, 1.81204, 1.75725,
         1.70412, 1.65258, 1.60262, 1.55415, 1.50716, 1.46159, 1.41895, 1.37929, 1.34073, 1.30324, 1.26678, 1.23133,
         1.19687, 1.16336, 1.13079, 1.09912, 1.06833, 1.03839, 1.00929, 0.981004, 0.953504, 0.926771, 0.900784,
         0.875521, 0.850965, 0.827094, 0.80389, 0.781334, 0.759408, 0.738096, 0.717378, 0.697241, 0.677666, 0.658639,
         0.640144, 0.622165, 0.60469, 0.587703, 0.57119, 0.555139, 0.543547, 3.73384, 3.71062, 3.62228, 3.53536,
         3.44989, 3.36588, 3.28334, 3.20228, 3.12271, 3.04464, 2.96805, 2.89296, 2.81936, 2.74724, 2.67659, 2.60741,
         2.53969, 2.47341, 2.40857, 2.34514, 2.28312, 2.22248, 2.16321, 2.1053, 2.04872, 1.99345, 1.93948, 1.88679,
         1.83536, 1.78516, 1.73617, 1.68839, 1.64177, 1.59631, 1.55197, 1.50875, 1.46662]],
    'Zr':                                                                           [
        [0.001, 0.00101486, 0.00102994, 0.00104524, 0.00106077, 0.00107653, 0.00109252, 0.00110875,
         0.0011252299999999999, 0.00114195, 0.0011589100000000002, 0.0011761299999999998, 0.0011936, 0.00121134,
         0.0012293400000000002, 0.0012476, 0.00126614, 0.00128495, 0.00130404, 0.00132341, 0.00134308,
         0.0013630299999999999, 0.00138328, 0.00140383, 0.00142469, 0.00144586, 0.0014673400000000001, 0.00148914,
         0.0015112699999999999, 0.00153372, 0.00155651, 0.00157963, 0.0016030999999999999, 0.00162692, 0.00165109,
         0.00167562, 0.00170052, 0.0017257800000000001, 0.00175142, 0.00177744, 0.0018038499999999999, 0.00183065,
         0.00185785, 0.0018854599999999998, 0.00191347, 0.0019418999999999999, 0.00197075, 0.0020000300000000003,
         0.00202974, 0.0020599, 0.0020905100000000003, 0.00212157, 0.0021530900000000003, 0.0021850800000000003,
         0.00221754, 0.00225049, 0.00228392, 0.00231786, 0.00235229, 0.0023872399999999997, 0.00242271, 0.00245871,
         0.0024952399999999997, 0.00253231, 0.00256993, 0.00260812, 0.00264687, 0.0026861899999999998,
         0.0027261000000000004, 0.0027666, 0.00280771, 0.0028494199999999996, 0.00289176, 0.00293472, 0.00297833,
         0.00302258, 0.00306748, 0.00311306, 0.0031593100000000002, 0.00320625, 0.00325389, 0.00330223,
         0.0033512900000000003, 0.00340108, 0.0034516200000000003, 0.0035028999999999998, 0.0035549400000000004,
         0.00360776, 0.0036613600000000002, 0.00371576, 0.0037709700000000002, 0.0038269899999999997, 0.00388385,
         0.00394156, 0.00400012, 0.0040595499999999994, 0.00411986, 0.00418107, 0.00424319, 0.00430624, 0.00437022,
         0.0044351500000000006, 0.0045010399999999996, 0.0045679100000000005, 0.00463578, 0.004704659999999999,
         0.00477456, 0.00484549, 0.00491749, 0.00499055, 0.005064689999999999, 0.00513994, 0.00521631,
         0.0052938099999999995, 0.00537246, 0.00545228, 0.00553329, 0.0056155, 0.00569893, 0.0057836, 0.00586953,
         0.00595674, 0.0060452399999999995, 0.00613506, 0.00622621, 0.00631871, 0.00641259, 0.00650787,
         0.006604560000000001, 0.00670268, 0.00680227, 0.00690333, 0.0070059, 0.00710999, 0.007215620000000001,
         0.00732283, 0.00743163, 0.00754204, 0.0076541, 0.007767820000000001, 0.00788323, 0.00800035, 0.00811922,
         0.00823985, 0.00836227, 0.008486510000000001, 0.0086126, 0.00874056, 0.008870419999999999, 0.00900221,
         0.00913596, 0.009271699999999999, 0.00940945, 0.00954925, 0.00969113, 0.00983512, 0.009981239999999999,
         0.0101295, 0.01028, 0.0104328, 0.0105878, 0.0107451, 0.0109047, 0.0110667, 0.0112312, 0.011398,
         0.011567399999999999, 0.0117392, 0.0119136, 0.0120907, 0.012270300000000001, 0.012452600000000001, 0.0126376,
         0.0128254, 0.0130159, 0.0132093, 0.0134056, 0.013604699999999999, 0.0138069, 0.014012, 0.0142202, 0.0144315,
         0.0146459, 0.0148635, 0.0150843, 0.015308400000000002, 0.0155359, 0.0157667, 0.016000900000000002,
         0.016238700000000002, 0.016479900000000002, 0.016724799999999998, 0.016973299999999997, 0.017225400000000002,
         0.0174814, 0.0177411, 0.0180047, 0.018272200000000002, 0.0185437, 0.018819199999999998, 0.0190988, 0.0193825,
         0.0196705, 0.019962800000000003, 0.0202594, 0.020560400000000003, 0.0208658, 0.021175799999999998, 0.0214905,
         0.0218098, 0.022133800000000002, 0.0224626, 0.022796399999999998, 0.023135100000000002, 0.0234788, 0.0238276,
         0.0241817, 0.0245409, 0.0249056, 0.025275600000000002, 0.0256511, 0.0260322, 0.026419, 0.0268115,
         0.027209900000000002, 0.0276141, 0.0280244, 0.0284408, 0.028863299999999998, 0.0292922, 0.0297274, 0.030169,
         0.0306173, 0.031072199999999998, 0.0315338, 0.0320023, 0.0324778, 0.0329603, 0.03345, 0.033947000000000005,
         0.0344514, 0.0349632, 0.0354827, 0.036009900000000004, 0.0365449, 0.0370879, 0.0376389, 0.0381981, 0.0387656,
         0.0393416, 0.0399261, 0.0405193, 0.0411213, 0.0417323, 0.0423523, 0.0429816, 0.0436202, 0.0442682, 0.0449259,
         0.0455934, 0.0462708, 0.0469583, 0.047656, 0.048364, 0.0490826, 0.049811799999999996, 0.050551900000000004,
         0.051302999999999994, 0.0520652, 0.0528388, 0.053623800000000006, 0.0544205, 0.0552291, 0.0560496, 0.0568824,
         0.0577275, 0.0585852, 0.0594556, 0.060339, 0.061235399999999995, 0.062145200000000005, 0.0630686, 0.0640056,
         0.06495659999999999, 0.0659216, 0.0669011, 0.067895, 0.0689038, 0.06992749999999999, 0.0709665, 0.0720208,
         0.0730909, 0.0741768, 0.0752789, 0.0763973, 0.0775324, 0.0786843, 0.07985339999999999, 0.0810398,
         0.08224379999999999, 0.0834658, 0.0847058, 0.0859644, 0.0872416, 0.0885377, 0.0898532, 0.0911882, 0.092543,
         0.0939179, 0.0953133, 0.0967294, 0.0981666, 0.09962510000000001, 0.101105, 0.102607, 0.104132, 0.105679,
         0.107249, 0.10884300000000001, 0.11045999999999999, 0.11210099999999999, 0.113766, 0.11545699999999999,
         0.117172, 0.11891299999999999, 0.12068000000000001, 0.122473, 0.124292, 0.126139, 0.12801300000000002,
         0.129915, 0.131845, 0.133804, 0.135792, 0.13781000000000002, 0.139857, 0.141935, 0.144044, 0.146184, 0.148356,
         0.15056, 0.152797, 0.155067, 0.157371, 0.159709, 0.162082, 0.16449, 0.166934, 0.16941399999999998, 0.171931,
         0.174486, 0.176293, 0.17877600000000002, 0.18143199999999998, 0.184128, 0.186863, 0.18963999999999998,
         0.192457, 0.19531700000000002, 0.198219, 0.20116399999999998, 0.204152, 0.207186, 0.210264, 0.213388, 0.216558,
         0.219776, 0.223041, 0.226355, 0.22971799999999998, 0.233131, 0.236595, 0.24011000000000002, 0.243677, 0.247298,
         0.25097200000000003, 0.254701, 0.258485, 0.262325, 0.266223, 0.270178, 0.274192, 0.278266, 0.2824, 0.286596,
         0.290854, 0.295175, 0.29956099999999997, 0.304012, 0.308529, 0.313112, 0.317764, 0.322486, 0.327277, 0.332139,
         0.337074, 0.342082, 0.347165, 0.352323, 0.357557, 0.36287, 0.368261, 0.373732, 0.37928500000000004,
         0.38492000000000004, 0.390639, 0.396443, 0.40233300000000005, 0.408311, 0.414377, 0.420534, 0.426782, 0.433123,
         0.439558, 0.44608800000000004, 0.452716, 0.459442, 0.46626799999999996, 0.473196, 0.480226, 0.487361, 0.494602,
         0.501951, 0.509409, 0.516977, 0.5246580000000001, 0.532453, 0.5403640000000001, 0.5483920000000001,
         0.5565399999999999, 0.564809, 0.5732, 0.581717, 0.5903590000000001, 0.599131, 0.608032, 0.617066,
         0.6262340000000001, 0.635538, 0.644981, 0.6545639999999999, 0.664289, 0.674158, 0.684174, 0.6943400000000001,
         0.704656, 0.715125, 0.72575, 0.736533, 0.747476, 0.7585810000000001, 0.769852, 0.7812899999999999, 0.792898,
         0.804678, 0.816634, 0.828767, 0.84108, 0.853576, 0.8662580000000001, 0.879129, 0.89219, 0.905446, 0.918898,
         0.932551, 0.946406, 0.960467, 0.974737, 0.9892190000000001, 1.00392, 1.0188300000000001, 1.03397,
         1.0493299999999999, 1.06492, 1.08074, 1.0968, 1.1131, 1.1296300000000001, 1.14642, 1.16345, 1.18074, 1.19828,
         1.2160799999999998, 1.23415, 1.25249, 1.2711, 1.2899800000000001, 1.30915, 1.3286, 1.3483399999999999,
         1.3683699999999999, 1.3887, 1.40933, 1.43027, 1.45152, 1.47309, 1.4949700000000001, 1.51718, 1.53973, 1.5626,
         1.58582, 1.60938, 1.63329, 1.65756, 1.68218, 1.7071800000000001, 1.73254, 1.75828, 1.78441, 1.81092, 1.83782,
         1.8651300000000002, 1.8928399999999999, 1.92096, 1.9495, 1.97847, 2.0, 2.026, 2.052, 2.079, 2.106, 2.134,
         2.161, 2.19, 2.218, 2.2222, 2.2224, 2.247, 2.277, 2.306, 2.3066, 2.3068, 2.337, 2.367, 2.398, 2.429, 2.461,
         2.493, 2.526, 2.5315, 2.5317, 2.559, 2.592, 2.626, 2.66, 2.695, 2.73, 2.766, 2.802, 2.839, 2.876, 2.914, 2.952,
         2.99, 3.029, 3.069, 3.109, 3.15, 3.191, 3.232, 3.275, 3.317, 3.361, 3.405, 3.449, 3.494, 3.54, 3.586, 3.633,
         3.68, 3.729, 3.777, 3.827, 3.877, 3.927, 3.979, 4.031, 4.083, 4.137, 4.191, 4.245, 4.301, 4.357, 4.414, 4.472,
         4.53, 4.589, 4.649, 4.71, 4.771, 4.834, 4.897, 4.961, 5.026, 5.091, 5.158, 5.225, 5.294, 5.363, 5.433, 5.504,
         5.576, 5.649, 5.722, 5.797, 5.873, 5.95, 6.027, 6.106, 6.186, 6.267, 6.349, 6.432, 6.516, 6.601, 6.687, 6.774,
         6.863, 6.952, 7.043, 7.135, 7.229, 7.323, 7.419, 7.516, 7.614, 7.713, 7.814, 7.916, 8.019, 8.124, 8.23, 8.338,
         8.447, 8.557, 8.669, 8.782, 8.897, 9.013, 9.131, 9.25, 9.371, 9.494, 9.618, 9.743, 9.88776, 10.0347, 10.1838,
         10.3351, 10.4886, 10.6444, 10.8026, 10.9631, 11.126, 11.2913, 11.459, 11.629299999999999, 11.802100000000001,
         11.9774, 12.1554, 12.336, 12.519200000000001, 12.705200000000001, 12.894, 13.085600000000001, 13.28, 13.4773,
         13.6775, 13.880799999999999, 14.087, 14.296299999999999, 14.508700000000001, 14.7243, 14.943, 15.165, 15.3903,
         15.619, 15.8511, 16.0866, 16.3256, 16.568099999999998, 16.8143, 17.0641, 17.3176, 17.574900000000003, 17.8361,
         17.9958, 17.996, 18.1011, 18.37, 18.6429, 18.919900000000002, 19.201, 19.4863, 19.7758, 20.069599999999998,
         20.3678, 20.6704, 20.9775, 21.2892, 21.6055, 21.9265, 22.252299999999998, 22.582900000000002,
         22.918400000000002, 23.2589, 23.6045, 23.9552, 24.3111, 24.6723, 25.0389, 25.4109, 25.788400000000003,
         26.171599999999998, 26.5604, 26.955, 27.3555, 27.7619, 28.174400000000002, 28.593, 29.017799999999998,
         29.448900000000002, 29.8865, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 5.13449, 5.04369, 4.94569, 4.84027, 4.72704, 4.60555, 4.47513, 4.33493, 4.18381, 4.01783, 3.8353,
         3.64323, 3.44648, 3.23745, 3.01219, 2.76652, 2.49525, 2.19097, 1.83983, 1.43303, 0.972209, 0.364745, -0.386541,
         -1.60492, -2.60944, -2.25008, -1.82408, -1.78224, -1.6823, -1.634, -1.65964, -1.72277, -1.81695, -1.99296,
         -2.25309, -2.48291, -2.54597, -2.48688, -2.26951, -1.83832, -1.01169, 0.423102, 1.79749, 2.81072, 3.8958,
         5.0031, 5.94484, 6.84816, 7.7777, 8.74361, 9.62356, 10.444, 11.2798, 12.2055, 13.0802, 13.7828, 14.4574,
         15.2493, 16.0678, 16.6049, 16.9531, 17.1914, 17.3495, 17.4469, 17.4954, 17.5055, 17.4839, 17.4373, 17.3705,
         17.2891, 17.1997, 17.11, 16.9988, 16.8565, 16.7017, 16.5377, 16.3667, 16.1908, 16.0113, 15.8296, 15.6461,
         15.4618, 15.2768, 15.0914, 14.9053, 14.718, 14.5289, 14.3201, 14.1099, 13.9386, 13.776, 13.6205, 13.4695,
         13.3206, 13.1688, 13.0138, 12.8705, 12.7362, 12.6016, 12.4697, 12.3519, 12.2408, 12.1345, 12.0318, 11.9318,
         11.8335, 11.7362, 11.6389, 11.5404, 11.4352, 11.3301, 11.235, 11.1413, 11.047, 10.9508, 10.8561, 10.768,
         10.6833, 10.6013, 10.5223, 10.4463, 10.3713, 10.2953, 10.2224, 10.15, 10.0717, 9.99084, 9.90751, 9.82167,
         9.73316, 9.64177, 9.54709, 9.44884, 9.34712, 9.24188, 9.1325, 9.01852, 8.89942, 8.77469, 8.64371, 8.50583,
         8.36112, 8.20802, 8.04308, 7.86515, 7.67268, 7.46327, 7.23352, 6.97833, 6.68915, 6.34986, 6.00044, 5.65958,
         5.41425, 4.95997, 4.41834, 3.94975, 3.5744, 3.16811, 2.39094, 1.56844, 1.02749, 0.858427, 1.18531, 1.66911,
         2.02039, 2.19169, 2.25393, 2.27307, 2.339, 2.44787, 2.63874, 3.10756, 3.84401, 4.45142, 4.83647, 5.19179,
         5.57293, 5.96969, 6.46719, 6.97004, 7.38425, 7.82181, 8.24696, 8.59223, 8.86235, 9.0262, 9.18296, 9.44285,
         9.82569, 10.2237, 10.4895, 10.5885, 10.6254, 10.9148, 11.4772, 12.4309, 13.5853, 14.4317, 15.0593, 15.5972,
         16.0519, 16.3925, 16.665, 17.0041, 17.4043, 17.8283, 18.3099, 18.8145, 19.2856, 19.7483, 20.214, 20.6882,
         21.2379, 21.7996, 22.2707, 22.7014, 23.099, 23.4707, 23.8342, 24.1977, 24.5575, 24.9149, 25.2715, 25.6303,
         25.9954, 26.374, 26.8175, 27.2459, 27.5804, 27.8913, 28.1798, 28.4499, 28.7043, 28.9447, 29.1727, 29.3892,
         29.5949, 29.7888, 29.9733, 30.1537, 30.3294, 30.4996, 30.6648, 30.8252, 30.9813, 31.1336, 31.2826, 31.4291,
         31.5745, 31.7222, 31.8741, 32.0165, 32.1452, 32.2688, 32.3887, 32.5067, 32.6274, 32.7616, 32.8907, 32.9872,
         33.0679, 33.1358, 33.1919, 33.2321, 33.2632, 33.3005, 33.3398, 33.3787, 33.4177, 33.4585, 33.5104, 33.5535,
         33.5689, 33.5673, 33.552, 33.5465, 33.5529, 33.5661, 33.5829, 33.5943, 33.6136, 33.6355, 33.639, 33.6279,
         33.612, 33.5824, 33.5253, 33.4456, 33.3621, 33.2941, 33.2288, 33.1634, 33.0967, 33.028, 32.957, 32.8829,
         32.8051, 32.7225, 32.635, 32.5423, 32.4437, 32.3389, 32.2274, 32.1083, 31.9809, 31.8444, 31.6974, 31.5377,
         31.3636, 31.1733, 30.964, 30.7327, 30.4751, 30.1857, 29.8567, 29.5841, 29.2165, 28.7953, 28.2813, 27.6587,
         26.8395, 25.7634, 23.9117, 18.3423, 8.2188, 8.22078, 22.7924, 24.1749, 20.5713, 18.0745, 18.0818, 26.3744,
         27.9197, 28.9696, 29.7293, 30.2895, 30.6012, 30.0697, 27.7869, 27.7908, 31.5603, 32.5026, 33.2011, 33.7723,
         34.276, 34.718, 35.1224, 35.4854, 35.8228, 36.1297, 36.4171, 36.6799, 36.9216, 37.1499, 37.3655, 37.5641,
         37.752, 37.9259, 38.0866, 38.2424, 38.3834, 38.5197, 38.6463, 38.7638, 38.8746, 38.9794, 39.0764, 39.1678,
         39.2527, 39.3343, 39.408, 39.4787, 39.5438, 39.6038, 39.6611, 39.7137, 39.7618, 39.8075, 39.8492, 39.8872,
         39.923, 39.9554, 39.9851, 40.0123, 40.0367, 40.0588, 40.0787, 40.0965, 40.1121, 40.1259, 40.1377, 40.1478,
         40.1562, 40.163, 40.1684, 40.1722, 40.1746, 40.1758, 40.1758, 40.1745, 40.1722, 40.1688, 40.1644, 40.1589,
         40.1526, 40.1455, 40.1377, 40.1289, 40.1195, 40.1094, 40.0986, 40.0871, 40.0751, 40.0626, 40.0496, 40.036,
         40.0219, 40.0076, 39.9926, 39.9773, 39.9615, 39.9456, 39.9291, 39.9125, 39.8955, 39.8782, 39.8606, 39.8428,
         39.8249, 39.8065, 39.7879, 39.769, 39.75, 39.7309, 39.7115, 39.6919, 39.672, 39.652, 39.6318, 39.6114, 39.5908,
         39.5699, 39.5489, 39.5278, 39.5034, 39.4788, 39.4539, 39.4286, 39.403, 39.3771, 39.3508, 39.324, 39.2969,
         39.2692, 39.241, 39.2123, 39.1829, 39.1529, 39.1221, 39.0905, 39.058, 39.0244, 38.9898, 38.9538, 38.9165,
         38.8775, 38.8368, 38.794, 38.7488, 38.701, 38.6501, 38.5956, 38.5368, 38.4729, 38.4029, 38.3255, 38.2389,
         38.1404, 38.0266, 37.8918, 37.7275, 37.518, 37.2322, 36.7916, 35.8632, 28.3833, 28.3835, 35.5338, 36.8921,
         37.4953, 37.8923, 38.1892, 38.4259, 38.6221, 38.789, 38.9335, 39.0604, 39.1728, 39.2733, 39.3636, 39.4452,
         39.5192, 39.5865, 39.648, 39.7041, 39.7556, 39.8028, 39.846, 39.8858, 39.9223, 39.9559, 39.9868, 40.0151,
         40.0411, 40.065, 40.0869, 40.1069, 40.1252, 40.1419, 40.1571, 40.1709, 40.1834, 40.1864],
        [0.187064, 0.190511, 0.194022, 0.197598, 0.201239, 0.204991, 0.208845, 0.21277, 0.21677, 0.220845, 0.224996,
         0.229225, 0.233534, 0.237924, 0.242397, 0.246953, 0.251595, 0.256324, 0.261558, 0.267735, 0.274057, 0.280529,
         0.287154, 0.293935, 0.300876, 0.307981, 0.315254, 0.322698, 0.330319, 0.338119, 0.346104, 0.354277, 0.362643,
         0.371106, 0.379747, 0.388588, 0.397635, 0.406892, 0.416365, 0.426059, 0.435978, 0.446129, 0.456515, 0.467144,
         0.47802, 0.489149, 0.500537, 0.511518, 0.522347, 0.533405, 0.544696, 0.556227, 0.568002, 0.580026, 0.592304,
         0.604843, 0.617647, 0.630721, 0.644073, 0.657707, 0.67163, 0.684788, 0.696838, 0.7091, 0.721578, 0.734275,
         0.747196, 0.760345, 0.773724, 0.78734, 0.801194, 0.815293, 0.829639, 0.844238, 0.859094, 0.874211, 0.889595,
         0.905249, 0.921178, 0.937388, 0.953884, 0.970668, 0.987749, 1.00329, 1.0182, 1.03333, 1.04868, 1.06426,
         1.08007, 1.09612, 1.11241, 1.12893, 1.14571, 1.16273, 1.18, 1.19754, 1.21533, 1.23338, 1.25171, 1.27031,
         1.28918, 1.32117, 1.35964, 1.39922, 1.43995, 1.48188, 1.52502, 1.56941, 1.61511, 1.66212, 1.71215, 1.76908,
         1.82792, 1.8887, 1.95151, 2.01641, 2.08347, 2.15275, 2.22434, 2.29831, 2.37474, 2.45371, 2.53531, 2.61962,
         2.69698, 2.75883, 2.82209, 2.88681, 2.95302, 3.02074, 3.09001, 3.16087, 3.23336, 3.30751, 3.38336, 3.46095,
         3.54032, 3.62151, 3.69522, 3.76019, 3.82631, 3.89359, 3.96206, 4.03172, 4.10262, 4.17475, 4.23941, 4.28244,
         4.3259, 4.36981, 4.41416, 4.45896, 4.50421, 4.54993, 4.59611, 4.64276, 4.68362, 4.72345, 4.76363, 4.80414,
         4.845, 4.8862, 4.92776, 4.96966, 5.00525, 5.02611, 5.04706, 5.06809, 5.08921, 5.11042, 5.10947, 5.10224,
         5.09504, 5.08783, 5.08064, 5.07346, 5.06629, 5.05021, 4.97147, 4.89396, 4.81765, 4.74254, 4.6686, 4.5958,
         4.49013, 4.31258, 4.14205, 3.97826, 3.82094, 3.66985, 3.52474, 3.38536, 3.25149, 3.12292, 2.99943, 2.88082,
         2.7669, 2.65749, 2.55241, 2.45147, 2.35453, 2.26143, 2.17201, 2.08612, 2.00363, 1.9244, 1.8483, 1.77521,
         1.70501, 1.63759, 1.57706, 1.53539, 1.49483, 1.45534, 1.4169, 1.37946, 1.34302, 1.30754, 1.273, 1.26328,
         1.26113, 1.25899, 1.38976, 1.68359, 3.22237, 4.58631, 5.05101, 5.56277, 6.03228, 6.3968, 6.78335, 7.19325,
         7.62792, 8.08886, 8.65881, 9.53423, 10.4982, 11.5596, 12.7283, 14.0152, 15.4322, 16.4497, 16.7706, 17.0977,
         17.4313, 17.4699, 17.4896, 17.5094, 17.5292, 17.4024, 17.2006, 17.0011, 16.804, 16.5349, 16.0378, 15.5555,
         15.0878, 14.6342, 13.9075, 12.999, 12.1498, 11.3561, 10.6143, 9.92088, 9.27279, 8.66704, 8.10086, 7.57166,
         7.07704, 6.61472, 6.18261, 5.76349, 5.34567, 4.95814, 4.59871, 4.26534, 3.95613, 3.66934, 3.40334, 3.15662,
         2.92778, 2.71554, 2.51868, 2.33609, 2.16674, 2.00967, 1.86398, 1.72885, 1.64583, 1.57267, 1.50277, 1.43598,
         1.37215, 1.31116, 1.25288, 1.21307, 1.18447, 1.15654, 1.12928, 1.12188, 1.11494, 1.10804, 1.10119, 1.09437,
         1.08739, 1.08046, 1.07357, 1.06672, 1.05992, 1.05467, 1.06483, 1.07509, 1.08545, 1.09591, 1.10842, 1.13213,
         1.15635, 1.18109, 1.20636, 1.23217, 1.25742, 1.27867, 1.30028, 1.32225, 1.33782, 1.35198, 1.36628, 1.38074,
         1.39535, 1.41011, 1.42503, 1.44011, 1.45561, 1.47207, 1.48871, 1.50554, 1.52256, 1.53977, 1.55718, 1.57478,
         1.59258, 1.61059, 1.6268, 1.64154, 1.65641, 1.67141, 1.68655, 1.70182, 1.71724, 1.73279, 1.74848, 1.75953,
         2.15126, 2.18213, 2.21345, 2.4895, 2.84521, 3.20582, 3.46668, 3.74876, 4.56748, 5.65136, 6.99245, 8.07342,
         8.88459, 9.29434, 9.72296, 10.1714, 10.7262, 11.3758, 12.0646, 12.8901, 13.8079, 14.3512, 14.6251, 14.9043,
         15.2519, 15.6166, 15.99, 16.3646, 16.5783, 16.7947, 17.014, 17.1245, 17.2159, 17.3077, 17.4106, 17.7415,
         18.0788, 18.4224, 18.6037, 18.7493, 18.896, 19.4502, 20.161, 20.8977, 21.6613, 21.6984, 21.539, 21.3808,
         21.2237, 21.0678, 20.9131, 20.9336, 21.0207, 21.1081, 21.1959, 21.284, 21.3021, 21.2919, 21.2818, 21.2716,
         21.2615, 21.2514, 21.1108, 20.928, 20.7467, 20.5671, 20.398, 20.2504, 20.1038, 19.9583, 19.8138, 19.6705,
         19.5281, 19.3867, 19.2464, 19.0898, 18.8048, 18.524, 18.2474, 17.975, 17.7066, 17.4423, 17.1819, 16.9253,
         16.6726, 16.4237, 16.1785, 15.9434, 15.7134, 15.4868, 15.2635, 15.0433, 14.8264, 14.6125, 14.4018, 14.1941,
         13.9894, 13.7876, 13.5888, 13.3806, 13.1621, 12.9472, 12.7358, 12.5279, 12.3234, 12.1222, 11.9233, 11.6746,
         11.4312, 11.1927, 10.9593, 10.7307, 10.5069, 10.309, 10.1191, 9.93277, 9.74983, 9.57024, 9.39397, 9.21395,
         9.00815, 8.80695, 8.61024, 8.44279, 8.29281, 8.1455, 8.00081, 7.84548, 7.69067, 7.53892, 7.36979, 7.18601,
         7.00681, 6.82832, 6.63951, 6.45593, 6.2839, 6.15791, 6.0344, 5.91333, 5.79462, 5.67831, 5.56448, 5.45263,
         5.34284, 5.23417, 5.12763, 5.02317, 4.92083, 4.82057, 4.72255, 4.62643, 4.53214, 4.43993, 4.3495, 4.25969,
         4.17149, 4.08485, 3.99998, 3.91687, 3.83555, 3.75591, 3.67792, 3.60153, 3.54648, 3.48326, 3.41986, 3.35592,
         3.29381, 3.23128, 3.17275, 3.11164, 3.05439, 3.04595, 11.4966, 11.2807, 11.0261, 10.7885, 10.7837, 14.8502,
         14.5865, 14.3325, 14.0783, 13.8316, 13.5849, 13.3454, 13.1064, 13.0672, 14.925, 14.7028, 14.4418, 14.1792,
         13.9227, 13.6654, 13.4144, 13.1625, 12.9171, 12.6716, 12.4327, 12.1933, 11.9606, 11.7347, 11.5082, 11.283,
         11.0634, 10.8453, 10.6329, 10.4262, 10.2163, 10.0165, 9.81349, 9.61716, 9.42589, 9.23527, 9.04757, 8.86427,
         8.68352, 8.50785, 8.33009, 8.16137, 7.99097, 7.82582, 7.66572, 7.50438, 7.34806, 7.19651, 7.04414, 6.89658,
         6.75353, 6.60989, 6.47085, 6.33379, 6.19877, 6.06812, 5.93942, 5.81278, 5.6881, 5.56751, 5.44694, 5.33034,
         5.21576, 5.10322, 4.99429, 4.88568, 4.78059, 4.67604, 4.57491, 4.47573, 4.37838, 4.28298, 4.18952, 4.09901,
         4.00922, 3.92134, 3.83524, 3.75199, 3.66946, 3.58865, 3.5097, 3.43229, 3.35668, 3.28284, 3.21047, 3.1398,
         3.0708, 3.00253, 2.93656, 2.87148, 2.80783, 2.74514, 2.68447, 2.62477, 2.56637, 2.50937, 2.45388, 2.39911,
         2.34582, 2.29376, 2.24243, 2.19247, 2.14333, 2.09553, 2.0488, 2.00288, 1.95817, 1.91429, 1.87153, 1.82952,
         1.78863, 1.74847, 1.70908, 1.67074, 1.63344, 1.59183, 1.55125, 1.51169, 1.47312, 1.43551, 1.39885, 1.3631,
         1.32825, 1.29428, 1.26116, 1.22887, 1.19739, 1.1667, 1.13678, 1.10762, 1.07918, 1.05147, 1.02444, 0.998102,
         0.972422, 0.947387, 0.922981, 0.899189, 0.875995, 0.853384, 0.831341, 0.809851, 0.788901, 0.768477, 0.748566,
         0.729155, 0.71023, 0.69178, 0.673793, 0.656256, 0.639158, 0.622488, 0.606236, 0.59039, 0.574939, 0.559875,
         0.55096, 3.75925, 3.72566, 3.64188, 3.55948, 3.47847, 3.39885, 3.32063, 3.2438, 3.16835, 3.09429, 3.02161,
         2.9503, 2.88036, 2.81177, 2.74453, 2.67862, 2.61403, 2.55075, 2.48877, 2.42807, 2.36864, 2.31046, 2.25351,
         2.19778, 2.14326, 2.08992, 2.03775, 1.98672, 1.93684, 1.88806, 1.84039, 1.79379, 1.74825, 1.70376, 1.66029,
         1.61783, 1.60707]],
    'Nb':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3704, 2.3706, 2.3776599999999997, 2.41611, 2.45519, 2.4646,
         2.4648000000000003, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.6976, 2.6978, 2.7033, 2.74703,
         2.79146, 2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326,
         3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613,
         3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005,
         4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384, 18.9855,
         18.9857, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997,
         21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352,
         24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873,
         28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.65589, 3.28421, 2.94113, 2.58333, 2.15063, 1.77528, 1.44276, 1.13375, 0.845374, 0.57492, 0.312846,
         0.030906, -0.116685, -0.107686, 0.146301, 0.570445, 1.20021, 2.35458, 3.52583, 4.78554, 5.88594, 6.78429,
         7.57706, 8.31831, 9.03042, 9.73071, 10.4357, 11.1732, 12.0028, 12.9126, 13.6599, 14.3473, 15.0367, 15.8417,
         16.5048, 16.9841, 17.3605, 17.694, 17.9449, 18.1179, 18.2359, 18.3131, 18.3575, 18.3756, 18.3729, 18.355,
         18.3297, 18.3166, 18.2548, 18.1655, 18.0587, 17.9394, 17.8108, 17.6756, 17.536, 17.3953, 17.2616, 17.1216,
         16.9629, 16.7949, 16.6212, 16.4427, 16.2576, 16.0707, 15.8902, 15.7116, 15.5328, 15.3504, 15.1543, 14.9611,
         14.7885, 14.6243, 14.4625, 14.2959, 14.1335, 13.9637, 13.7936, 13.6424, 13.4997, 13.3678, 13.2437, 13.123,
         13.0075, 12.8987, 12.7956, 12.6984, 12.6072, 12.5154, 12.4237, 12.3329, 12.243, 12.154, 12.0657, 11.9784,
         11.8938, 11.8089, 11.7208, 11.6305, 11.5384, 11.4443, 11.3483, 11.2507, 11.1544, 11.0523, 10.9427, 10.827,
         10.705, 10.5773, 10.4406, 10.2929, 10.1329, 9.95887, 9.76589, 9.55397, 9.32097, 9.05806, 8.78371, 8.48045,
         8.13659, 7.77283, 7.38003, 6.96546, 6.52531, 5.98241, 5.4033, 4.82148, 4.31803, 3.91986, 3.73787, 3.80764,
         3.83946, 3.91127, 4.21271, 4.56163, 5.03425, 5.61515, 6.09081, 6.56845, 7.02385, 7.44485, 7.85801, 8.30906,
         8.77446, 9.2128, 9.63811, 10.075, 10.5708, 11.0473, 11.5107, 11.9935, 12.5784, 13.1951, 13.6628, 13.9951,
         14.2543, 14.5586, 14.906, 15.2672, 15.6413, 16.0291, 16.4333, 16.8592, 17.3206, 17.8734, 18.371, 18.8265,
         19.2638, 19.6917, 20.1153, 20.5395, 20.9707, 21.428, 21.8985, 22.3359, 22.7438, 23.1399, 23.5281, 23.9115,
         24.2929, 24.6755, 25.0637, 25.461, 25.9374, 26.3759, 26.7474, 27.0915, 27.4151, 27.7223, 28.0158, 28.2974,
         28.5686, 28.8307, 29.0846, 29.3312, 29.5715, 29.8061, 30.0359, 30.2618, 30.485, 30.7068, 30.9299, 31.1654,
         31.3946, 31.6082, 31.8099, 32.0061, 32.1994, 32.3926, 32.5905, 32.8033, 33.0668, 33.2802, 33.4278, 33.5442,
         33.6361, 33.7036, 33.7564, 33.8143, 33.8779, 33.9396, 33.9992, 34.0568, 34.1117, 34.1629, 34.2066, 34.2439,
         34.2759, 34.3031, 34.326, 34.3447, 34.3598, 34.3712, 34.3792, 34.3846, 34.3875, 34.3872, 34.3813, 34.3703,
         34.355, 34.3357, 34.3126, 34.286, 34.2562, 34.2235, 34.1891, 34.1534, 34.1106, 34.0584, 33.9977, 33.9299,
         33.8552, 33.7733, 33.6838, 33.5864, 33.4796, 33.3641, 33.2402, 33.1066, 32.9623, 32.8057, 32.6348, 32.4475,
         32.2412, 32.0125, 31.7556, 31.4665, 31.1387, 30.761, 30.3175, 29.784, 29.1199, 28.2479, 26.9916, 24.7379,
         9.50284, 9.50482, 20.7176, 25.0802, 24.7669, 19.2062, 19.2131, 27.4023, 29.2837, 30.4376, 31.2162, 31.6238,
         28.8304, 28.8341, 31.2653, 33.1711, 34.1005, 34.821, 35.4269, 35.9539, 36.4204, 36.8385, 37.2161, 37.5592,
         37.8722, 38.1588, 38.4218, 38.6637, 38.8865, 39.092, 39.282, 39.4572, 39.6185, 39.7674, 39.9053, 40.0329,
         40.1502, 40.2582, 40.3577, 40.4492, 40.5333, 40.6103, 40.6808, 40.7452, 40.8037, 40.8569, 40.905, 40.9484,
         40.9873, 41.022, 41.0527, 41.0798, 41.1033, 41.1236, 41.1408, 41.1551, 41.1667, 41.1757, 41.1823, 41.1868,
         41.1891, 41.1895, 41.1879, 41.1847, 41.1798, 41.1734, 41.1655, 41.1563, 41.1459, 41.1342, 41.1215, 41.1078,
         41.0931, 41.0776, 41.0612, 41.044, 41.0261, 41.0074, 40.9882, 40.9684, 40.948, 40.9271, 40.9058, 40.884,
         40.8617, 40.839, 40.816, 40.7925, 40.7687, 40.7447, 40.7203, 40.6956, 40.6706, 40.6453, 40.6197, 40.5938,
         40.5676, 40.5411, 40.5143, 40.4871, 40.4596, 40.4317, 40.4035, 40.3748, 40.3457, 40.3161, 40.2859, 40.2552,
         40.2239, 40.1918, 40.159, 40.1253, 40.0906, 40.0549, 40.018, 39.9797, 39.9399, 39.8983, 39.8548, 39.809,
         39.7605, 39.7091, 39.654, 39.5948, 39.5305, 39.4602, 39.3824, 39.2953, 39.1963, 39.0816, 38.9456, 38.7789,
         38.5651, 38.2701, 37.8046, 36.7415, 29.3743, 29.3745, 36.9155, 38.0837, 38.651, 39.0322, 39.3196, 39.5496,
         39.7404, 39.9026, 40.0429, 40.1657, 40.2742, 40.3709, 40.4574, 40.5353, 40.6056, 40.6693, 40.7271, 40.7797,
         40.8275, 40.8711, 40.9108, 40.947, 40.9801, 41.0102, 41.0376, 41.0627, 41.0858, 41.1116, 41.1094],
        [2.56685, 2.66209, 2.76087, 2.86331, 2.96956, 3.07974, 3.19401, 3.31252, 3.42326, 3.512, 3.60305, 3.69645,
         3.79228, 3.89059, 3.99145, 4.09492, 4.19732, 4.29578, 4.39654, 4.49967, 4.60521, 4.71323, 4.82379, 4.92204,
         4.9954, 5.06985, 5.14542, 5.22211, 5.29994, 5.36144, 5.40803, 5.45502, 5.50243, 5.55024, 5.52629, 5.49985,
         5.47353, 5.44735, 5.42129, 5.35934, 5.22402, 5.09212, 4.96355, 4.83823, 4.71607, 4.57132, 4.42631, 4.2859,
         4.14994, 4.0183, 3.89083, 3.78365, 3.68358, 3.58615, 3.49131, 3.39896, 3.32114, 3.26923, 3.21814, 3.16785,
         3.11835, 3.09552, 3.08913, 3.08276, 3.0764, 3.08935, 3.16044, 3.23316, 3.35858, 3.56089, 3.77537, 4.06135,
         4.47181, 4.92376, 5.42138, 5.96928, 6.57256, 7.23682, 8.04643, 9.01917, 10.1095, 11.3037, 12.4075, 13.6192,
         14.7266, 15.3002, 15.6547, 15.742, 15.7278, 15.7135, 15.6993, 15.685, 15.6708, 15.6566, 15.6424, 15.6283,
         15.3674, 15.0138, 14.6684, 14.3309, 13.9371, 13.2171, 12.5343, 11.8868, 11.259, 10.5992, 9.97803, 9.39326,
         8.84278, 8.32454, 7.83669, 7.37744, 6.94508, 6.53806, 6.12911, 5.71452, 5.32795, 4.96755, 4.63153, 4.31822,
         4.02612, 3.75377, 3.49985, 3.2631, 3.01378, 2.78071, 2.56567, 2.36726, 2.18419, 2.01528, 1.87098, 1.73976,
         1.61773, 1.50427, 1.39877, 1.30066, 1.24613, 1.1989, 1.15346, 1.10975, 1.07194, 1.04477, 1.01829, 1.02779,
         1.04439, 1.06431, 1.08972, 1.11574, 1.14238, 1.17622, 1.21118, 1.24718, 1.28425, 1.31759, 1.34875, 1.38065,
         1.41329, 1.44671, 1.48092, 1.51594, 1.55179, 1.58849, 1.6201, 1.6517, 1.68392, 1.71676, 1.75025, 1.78439,
         1.81919, 1.85352, 1.88106, 1.90901, 1.93737, 1.96616, 1.99521, 2.02065, 2.04629, 2.07219, 2.09843, 2.12499,
         2.16023, 2.19828, 2.25268, 2.32435, 2.3983, 2.50013, 2.64962, 2.80911, 3.03219, 3.2636, 3.51267, 3.99318,
         4.57096, 5.33099, 6.21889, 7.25768, 8.17174, 8.98427, 9.87761, 10.8251, 11.5923, 12.4139, 12.9857, 13.4529,
         13.937, 14.3084, 14.6892, 15.0802, 15.4815, 15.7975, 16.1001, 16.4085, 16.7228, 17.0174, 17.2581, 17.5022,
         17.7497, 18.0007, 18.0465, 17.9948, 17.9432, 18.0412, 18.1968, 18.3538, 18.5122, 18.6719, 18.833, 18.9955,
         19.1594, 19.3247, 19.4494, 19.4552, 19.461, 19.4669, 19.4727, 19.4786, 19.4844, 19.4903, 19.4961, 19.436,
         19.3486, 19.2615, 19.1749, 19.0886, 19.0027, 18.9172, 18.8321, 18.7474, 18.663, 18.5671, 18.3448, 18.1252,
         17.9082, 17.6938, 17.482, 17.2727, 17.0659, 16.8616, 16.6597, 16.4602, 16.2632, 16.0685, 15.8761, 15.686,
         15.4982, 15.3127, 15.1294, 14.9483, 14.7693, 14.557, 14.3442, 14.1345, 13.9279, 13.7243, 13.5236, 13.326,
         13.1311, 12.8911, 12.5746, 12.2659, 11.9647, 11.6805, 11.4059, 11.1668, 10.9462, 10.7294, 10.5171, 10.3084,
         10.1034, 9.89893, 9.69527, 9.49228, 9.29351, 9.09891, 8.9084, 8.72189, 8.53934, 8.36071, 8.18562, 8.0142,
         7.84637, 7.68037, 7.51584, 7.35234, 7.19247, 7.0361, 6.88313, 6.73349, 6.58711, 6.4439, 6.30366, 6.16506,
         6.0274, 5.8832, 5.74116, 5.60259, 5.46757, 5.33575, 5.20694, 5.08124, 4.95865, 4.83916, 4.7247, 4.61365,
         4.50565, 4.40039, 4.2976, 4.19716, 4.09906, 4.00326, 3.90969, 3.81809, 3.7313, 3.64707, 3.56538, 3.48606,
         3.40925, 3.33475, 3.2625, 3.19248, 3.12463, 3.07077, 11.3846, 11.3328, 11.057, 10.7876, 10.7244, 14.7781,
         14.5323, 14.2136, 13.9019, 13.5973, 13.299, 13.0452, 14.87, 14.8276, 14.4982, 14.1751, 13.8565, 13.5426,
         13.233, 12.9281, 12.628, 12.3327, 12.0423, 11.7569, 11.4767, 11.2013, 10.9311, 10.666, 10.406, 10.1508, 9.9002,
         9.65484, 9.41477, 9.17987, 8.94941, 8.7236, 8.50283, 8.28684, 8.07553, 7.86887, 7.66678, 7.46921, 7.27619,
         7.08744, 6.90311, 6.72304, 6.54715, 6.37543, 6.20773, 6.04409, 5.88433, 5.72842, 5.57623, 5.42782, 5.28304,
         5.14184, 5.00413, 4.8699, 4.73899, 4.61144, 4.48701, 4.36576, 4.24757, 4.13246, 4.02024, 3.91095, 3.80448,
         3.70072, 3.59976, 3.50134, 3.40554, 3.31225, 3.2214, 3.13295, 3.0468, 2.96296, 2.88131, 2.802, 2.72467,
         2.64944, 2.57624, 2.50498, 2.4356, 2.36808, 2.30247, 2.23858, 2.17642, 2.11602, 2.0573, 2.00004, 1.9444,
         1.89027, 1.83763, 1.78644, 1.73664, 1.68821, 1.64112, 1.59532, 1.55078, 1.50747, 1.46535, 1.42439, 1.38457,
         1.34585, 1.3082, 1.27159, 1.236, 1.20139, 1.16775, 1.13504, 1.10323, 1.07231, 1.04225, 1.01303, 0.984615,
         0.956994, 0.930141, 0.904036, 0.878656, 0.853984, 0.829999, 0.806682, 0.784015, 0.761978, 0.740555, 0.719728,
         0.699482, 0.679799, 0.660665, 0.642062, 0.623977, 0.606396, 0.589303, 0.572686, 0.55653, 0.548862, 3.74502,
         3.69724, 3.6061, 3.51666, 3.42892, 3.34287, 3.25853, 3.17587, 3.09489, 3.01558, 2.93793, 2.86193, 2.78755,
         2.7148, 2.64364, 2.57406, 2.50604, 2.43957, 2.37462, 2.31116, 2.24919, 2.18867, 2.12958, 2.0719, 2.01561,
         1.96069, 1.9071, 1.85482, 1.80384, 1.75412]],
    'Mo':                                                                           [
        [0.01, 0.0101447, 0.0103088, 0.0104756, 0.010645, 0.010817199999999999, 0.010992100000000001, 0.0111699,
         0.0113506, 0.0115342, 0.0117207, 0.011910299999999999, 0.0121029, 0.012298700000000001, 0.012497600000000001,
         0.0126997, 0.0129052, 0.0131139, 0.0132, 0.0134, 0.013616699999999999, 0.013800000000000002, 0.014,
         0.014199999999999999, 0.0144, 0.0146, 0.0148361, 0.0150761, 0.01532, 0.0154, 0.0156, 0.0158, 0.0160556,
         0.016315200000000002, 0.0165791, 0.0168473, 0.0171198, 0.017396699999999998, 0.0174, 0.0176, 0.0178847,
         0.0181739, 0.0184, 0.018600000000000002, 0.0189008, 0.019, 0.0192, 0.0195105, 0.0198261, 0.0201468, 0.0204726,
         0.020803799999999997, 0.0211403, 0.0214822, 0.0218, 0.022, 0.0223558, 0.022717400000000002, 0.023, 0.0232,
         0.023575199999999998, 0.0238, 0.024, 0.024388200000000002, 0.024399999999999998, 0.0246, 0.0249979, 0.025,
         0.0254, 0.025810800000000002, 0.0262283, 0.0266525, 0.0270836, 0.0275217, 0.0279668, 0.0284191, 0.0288788,
         0.0293459, 0.0298205, 0.0303028, 0.030793, 0.031291, 0.0317971, 0.0323114, 0.032834, 0.033365099999999995,
         0.0339048, 0.0344531, 0.0350104, 0.0355766, 0.0361521, 0.0367368, 0.037331, 0.037934800000000005,
         0.038548400000000003, 0.0391718, 0.0398054, 0.0404492, 0.041103499999999994, 0.0417683, 0.0424439, 0.0431304,
         0.0438279, 0.0445368, 0.0452572, 0.045989199999999994, 0.046733, 0.0474889, 0.048257, 0.049037500000000005,
         0.049830599999999996, 0.050636600000000004, 0.0514556, 0.0522879, 0.0531336, 0.053993, 0.0548663, 0.0557537,
         0.056655500000000004, 0.057571800000000006, 0.058503, 0.0594492, 0.0604108, 0.0605, 0.06075, 0.061, 0.06125,
         0.0615, 0.06175, 0.062, 0.06225, 0.0625, 0.06275, 0.063, 0.06325, 0.0635, 0.06375, 0.064, 0.06425, 0.0645,
         0.06475, 0.065, 0.06525, 0.0655, 0.06575, 0.065999, 0.06625, 0.06675, 0.0675, 0.06775, 0.068, 0.0685, 0.06875,
         0.069, 0.06925, 0.0695, 0.06975, 0.07, 0.07025, 0.0705, 0.07075, 0.071, 0.07125, 0.0715, 0.07175, 0.072,
         0.07225, 0.0725, 0.07275, 0.07325, 0.0735, 0.07375, 0.074, 0.07425, 0.0745, 0.075, 0.076, 0.077, 0.07725,
         0.0775, 0.0785, 0.07875, 0.0795, 0.08, 0.081, 0.08175, 0.082, 0.08225, 0.08275, 0.0840884, 0.08425, 0.085,
         0.08525, 0.086, 0.0865, 0.08675, 0.087, 0.08725, 0.0875, 0.0889152, 0.08925, 0.09000100000000001, 0.091001,
         0.09125, 0.0915, 0.09175, 0.09225, 0.0925, 0.09275, 0.09325, 0.09375, 0.094, 0.09425, 0.095, 0.0955, 0.096,
         0.097, 0.09725, 0.09775, 0.099331, 0.0995, 0.1, 0.101, 0.1015, 0.102, 0.1025, 0.103, 0.1035, 0.104, 0.1045,
         0.105, 0.1055, 0.106, 0.1065, 0.107, 0.1075, 0.108, 0.1085, 0.109, 0.1095, 0.111271, 0.1115, 0.112, 0.1125,
         0.1135, 0.114, 0.1145, 0.1155, 0.116, 0.1165, 0.117, 0.118, 0.1185, 0.119, 0.1195, 0.12, 0.1215, 0.122, 0.123,
         0.124, 0.125, 0.126, 0.128, 0.129, 0.13, 0.131, 0.132, 0.134, 0.135, 0.136, 0.138, 0.139, 0.14, 0.141, 0.142,
         0.143, 0.144, 0.146, 0.147, 0.148, 0.149, 0.151, 0.152, 0.153, 0.154, 0.156, 0.158523, 0.16, 0.161, 0.162,
         0.163, 0.165636, 0.167, 0.168, 0.169, 0.17, 0.172, 0.173, 0.175, 0.176, 0.178847, 0.179, 0.181, 0.182, 0.183,
         0.184, 0.185, 0.186, 0.187, 0.188, 0.19, 0.191, 0.192, 0.193, 0.195, 0.197, 0.2, 0.201, 0.203, 0.204, 0.205,
         0.206, 0.209332, 0.212, 0.215, 0.216, 0.218, 0.22, 0.222, 0.223, 0.225, 0.226, 0.227, 0.228, 0.229, 0.23,
         0.231, 0.232, 0.233, 0.234, 0.235, 0.236, 0.237, 0.24, 0.241, 0.242, 0.243, 0.244, 0.245, 0.246, 0.249979,
         0.251, 0.253, 0.255, 0.258, 0.26, 0.262, 0.263, 0.266, 0.267, 0.269, 0.273351, 0.274, 0.276, 0.278, 0.281,
         0.283, 0.28757699999999997, 0.29222899999999996, 0.295, 0.299, 0.3, 0.301, 0.303, 0.304, 0.305, 0.307, 0.309,
         0.31, 0.314, 0.319, 0.323, 0.324, 0.327, 0.331, 0.335, 0.336, 0.338, 0.343, 0.344, 0.34956400000000004, 0.35,
         0.354, 0.359726, 0.363, 0.367, 0.37, 0.37075, 0.37101, 0.3715, 0.37175, 0.37225, 0.37275, 0.3735, 0.37525,
         0.376, 0.37625, 0.3765, 0.37851, 0.37875, 0.3795, 0.37974, 0.38025, 0.38049, 0.38099, 0.383, 0.3835, 0.38376,
         0.386, 0.3865, 0.38674000000000003, 0.38775, 0.38825, 0.38875, 0.3895, 0.39, 0.39125, 0.39175, 0.39225,
         0.39275, 0.393, 0.39325, 0.39349, 0.39375, 0.39399, 0.39426, 0.3945, 0.39475, 0.39525, 0.3955, 0.39576,
         0.39675, 0.397, 0.39725, 0.39775, 0.399, 0.40026, 0.40149, 0.40176, 0.40225, 0.40274, 0.40325, 0.4035, 0.40375,
         0.404, 0.40475, 0.405, 0.4055, 0.40625, 0.4065, 0.4075, 0.4085, 0.40926, 0.40951, 0.41026, 0.41126,
         0.41176999999999997, 0.41249, 0.41299, 0.41325, 0.4145, 0.41475, 0.415, 0.41675, 0.41774, 0.418, 0.41975, 0.42,
         0.4205, 0.42075, 0.421, 0.4215, 0.42275, 0.423, 0.42325, 0.4235, 0.424, 0.4245, 0.42475, 0.42501, 0.42575,
         0.427, 0.42725, 0.42925, 0.4295, 0.43026, 0.4315, 0.43175, 0.432, 0.43225, 0.4325, 0.43275, 0.433, 0.43425,
         0.435, 0.43525, 0.436, 0.4375, 0.43775, 0.43925, 0.445, 0.448, 0.449, 0.45, 0.451, 0.453, 0.454, 0.455, 0.456,
         0.458, 0.46, 0.461, 0.462, 0.467, 0.468, 0.469, 0.47, 0.471, 0.472, 0.475, 0.476, 0.478, 0.479, 0.48, 0.484,
         0.485, 0.486, 0.487, 0.488, 0.489, 0.49, 0.493, 0.496, 0.497, 0.498, 0.499, 0.501, 0.502, 0.503, 0.504, 0.505,
         0.506, 0.507, 0.508, 0.509, 0.51, 0.511, 0.513, 0.515, 0.516, 0.517, 0.518, 0.519, 0.521, 0.522, 0.523, 0.524,
         0.525, 0.526, 0.527, 0.528, 0.529, 0.53, 0.531, 0.532, 0.533, 0.534, 0.535, 0.536, 0.537, 0.538, 0.539, 0.54,
         0.541, 0.542, 0.54301, 0.544, 0.545, 0.546, 0.549, 0.55, 0.551, 0.554, 0.555, 0.556, 0.557, 0.558, 0.559, 0.56,
         0.562, 0.56299, 0.564, 0.565, 0.566, 0.567, 0.56901, 0.57, 0.572, 0.58, 0.582, 0.584, 0.586, 0.58999, 0.599533,
         0.6, 0.602, 0.604, 0.61, 0.612, 0.614, 0.62, 0.63001, 0.64, 0.648, 0.652, 0.656, 0.65799, 0.662, 0.664,
         0.67474, 0.684, 0.694, 0.702, 0.70399, 0.71, 0.712, 0.714, 0.722, 0.724, 0.72801, 0.7397849999999999, 0.744,
         0.748, 0.75, 0.758, 0.768, 0.77, 0.772, 0.774, 0.776, 0.788551, 0.8013049999999999, 0.802, 0.806, 0.81599,
         0.829188, 0.83001, 0.832, 0.83401, 0.836, 0.838, 0.84, 0.8535860000000001, 0.862, 0.87199, 0.878, 0.88, 0.882,
         0.888, 0.896, 0.89799, 0.89999, 0.904, 0.906, 0.90799, 0.916, 0.918, 0.92001, 0.922, 0.924, 0.926, 0.92801,
         0.94302, 0.958272, 0.9737720000000001, 0.989522, 1.00553, 1.02179, 1.03832, 1.05511, 1.0721800000000001,
         1.08952, 1.10714, 1.1250499999999999, 1.14324, 1.16173, 1.18052, 1.19962, 1.21902, 1.23874, 1.25877, 1.27913,
         1.29982, 1.3208499999999999, 1.3422100000000001, 1.36392, 1.38598, 1.4084, 1.4311800000000001,
         1.4543199999999998, 1.4778499999999999, 1.50175, 1.52604, 1.55072, 1.5757999999999999, 1.6012899999999999,
         1.6271900000000001, 1.65351, 1.68025, 1.70743, 1.73505, 1.76311, 1.79163, 1.8206, 1.85005, 1.87997,
         1.9103800000000002, 1.94128, 1.97268, 2.00458, 2.03701, 2.06995, 2.10343, 2.13746, 2.1720300000000003, 2.20716,
         2.2428600000000003, 2.2791300000000003, 2.316, 2.35346, 2.39152, 2.4301999999999997, 2.46951, 2.493, 2.5201,
         2.5203, 2.526, 2.56686, 2.592, 2.625, 2.6252, 2.626, 2.6684699999999997, 2.71163, 2.75549, 2.8000599999999998,
         2.839, 2.8654, 2.8655999999999997, 2.876, 2.92252, 2.96979, 3.01782, 3.06663, 3.11623, 3.16663, 3.21785,
         3.2699000000000003, 3.32279, 3.3765300000000003, 3.43114, 3.48664, 3.5430300000000003, 3.60034, 3.65857,
         3.7177399999999996, 3.77788, 3.83898, 3.9010700000000003, 3.96417, 4.02829, 4.09344, 4.15965, 4.22693, 4.29529,
         4.36477, 4.435359999999999, 4.5071, 4.58, 4.6540799999999996, 4.72935, 4.80585, 4.88358, 4.9625699999999995,
         5.04283, 5.1244, 5.20728, 5.2915, 5.37709, 5.464060000000001, 5.55244, 5.64224, 5.7335, 5.826239999999999,
         5.92047, 6.016229999999999, 6.1135399999999995, 6.21242, 6.3129, 6.4150100000000005, 6.51876, 6.6242, 6.73134,
         6.84021, 6.95085, 7.06327, 7.17752, 7.293609999999999, 7.411569999999999, 7.5314499999999995, 7.65327, 7.77705,
         7.90284, 8.03066, 8.16055, 8.29254, 8.42667, 8.562959999999999, 8.701459999999999, 8.8422, 8.98522,
         9.130540000000002, 9.27822, 9.42829, 9.58079, 9.73575, 9.89322, 10.0532, 10.2158, 10.3811, 10.549, 10.7196,
         10.893, 11.0692, 11.2482, 11.4301, 11.615, 11.8029, 11.993799999999998, 12.1878, 12.3849, 12.5852,
         12.788799999999998, 12.9956, 13.2058, 13.4194, 13.6364, 13.857, 14.081100000000001, 14.3089,
         14.540299999999998, 14.7755, 15.0145, 15.257299999999999, 15.504100000000001, 15.7548, 16.009700000000002,
         16.2686, 16.5317, 16.7991, 17.0708, 17.347, 17.6275, 17.912599999999998, 18.2024, 18.4968, 18.795900000000003,
         19.0999, 19.408900000000003, 19.7228, 20.0003, 20.0005, 20.0418, 20.366, 20.695400000000003,
         21.030099999999997, 21.3702, 21.7159, 22.0671, 22.424, 22.7867, 23.1553, 23.529799999999998,
         23.910400000000003, 24.297099999999997, 24.690099999999997, 25.0894, 25.4952, 25.9076, 26.3266, 26.7525,
         27.185200000000002, 27.6248, 28.0717, 28.5257, 28.987099999999998, 29.4559, 29.932299999999998, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 5.20954, 5.55318, 5.83296, 6.08563, 6.32197, 6.54462, 6.75545, 6.94723, 7.13155, 7.2872, 7.54382,
         7.8279, 8.04828, 8.20198, 8.43173, 8.56012, 8.63892, 8.76673, 8.78171, 8.78027, 8.78793, 8.79451, 8.78192,
         8.80884, 8.78624, 8.74684, 8.69546, 8.64475, 8.5457, 8.40811, 8.23954, 8.04072, 7.80668, 7.51286, 7.19169,
         6.89336, 6.56777, 6.20519, 5.88145, 5.55201, 5.19658, 4.87012, 4.54167, 4.18396, 3.74406, 3.29256, 2.88452,
         2.41946, 1.90217, 1.13881, 0.839567, 0.90621, 1.21934, 1.69776, 2.33239, 3.23612, 4.28586, 5.06363, 5.77948,
         6.48792, 7.19499, 7.87006, 8.46744, 9.03299, 9.6104, 10.2425, 11.0167, 11.8614, 12.7958, 13.6213, 14.371,
         15.0518, 15.7585, 16.4484, 17.0968, 17.5301, 17.5934, 17.5035, 17.7292, 18.2686, 18.1376, 17.8324, 18.1266,
         18.2153, 17.989, 18.0257, 18.4266, 18.4777, 18.3478, 18.2808, 18.4281, 18.5036, 18.2522, 18.3596, 18.8347,
         18.6546, 18.5, 18.4072, 18.4753, 18.5795, 18.5986, 18.6938, 18.6816, 18.7209, 18.7338, 18.6469, 18.6046,
         18.5224, 18.4643, 18.4138, 18.3206, 18.262, 18.2365, 18.2674, 18.2076, 18.1556, 18.0556, 17.9327, 17.8709,
         17.8754, 17.8281, 17.7803, 17.7055, 17.6603, 17.5895, 17.5756, 17.5169, 17.4635, 17.4253, 17.3677, 17.256,
         17.1062, 17.058, 17.021, 16.8174, 16.7797, 16.6212, 16.5228, 16.3054, 16.1571, 16.0996, 16.0573, 15.949,
         15.6862, 15.6731, 15.5629, 15.5038, 15.3621, 15.2824, 15.2317, 15.2038, 15.1578, 15.1129, 14.918, 14.8743,
         14.7729, 14.633, 14.6058, 14.5715, 14.5459, 14.4792, 14.4526, 14.4185, 14.3567, 14.2939, 14.2675, 14.2329,
         14.1473, 14.0853, 14.0276, 13.9105, 13.8869, 13.8336, 13.6664, 13.6501, 13.6008, 13.5073, 13.4642, 13.4137,
         13.3678, 13.334, 13.2949, 13.2659, 13.2191, 13.1842, 13.1439, 13.1094, 13.0772, 13.0502, 13.0148, 12.9785,
         12.943, 12.9208, 12.8959, 12.7793, 12.7662, 12.7362, 12.7074, 12.6366, 12.6121, 12.5839, 12.5292, 12.5092,
         12.4882, 12.4604, 12.4148, 12.3923, 12.3743, 12.3491, 12.3459, 12.3049, 12.2813, 12.2215, 12.1743, 12.1186,
         12.0742, 12.0244, 11.985, 11.9253, 11.8877, 11.8578, 11.7785, 11.7325, 11.6977, 11.5999, 11.574, 11.5454,
         11.4971, 11.4468, 11.4225, 11.3836, 11.3231, 11.2794, 11.2535, 11.227, 11.1628, 11.143, 11.117, 11.0945,
         11.0431, 10.972, 10.9268, 10.8926, 10.853, 10.8308, 10.718, 10.6599, 10.6246, 10.5839, 10.5598, 10.4756,
         10.4475, 10.3556, 10.322, 10.1719, 10.1683, 10.0698, 10.0188, 9.96933, 9.92972, 9.88437, 9.80975, 9.72246,
         9.68785, 9.61924, 9.58679, 9.54296, 9.50024, 9.39084, 9.27785, 9.082, 9.04361, 8.90831, 8.84821, 8.77592,
         8.72659, 8.45788, 8.24425, 7.98959, 7.89337, 7.69638, 7.49359, 7.27084, 7.14371, 6.86336, 6.70448, 6.4818,
         6.35222, 6.27253, 6.10332, 5.95109, 5.8593, 5.7169, 5.57309, 5.42136, 5.2593, 5.04452, 4.37525, 4.20557,
         4.06726, 3.90798, 3.79931, 3.76288, 3.53058, 2.85098, 2.58414, 2.06339, 1.53475, 0.849635, 0.521002, 0.327261,
         0.26851, 0.505738, 0.655385, 0.949757, 1.7666, 1.89238, 2.34601, 2.78244, 3.24424, 3.4417, 3.80396, 4.13615,
         4.26561, 4.47204, 4.57044, 4.62717, 4.654, 4.84355, 5.02916, 5.11596, 5.33858, 5.56797, 6.24439, 7.1504,
         7.9101, 8.00512, 8.35758, 8.66712, 8.88587, 8.99214, 9.18687, 9.71865, 9.84114, 10.0345, 10.1391, 10.4157,
         10.9288, 11.118, 11.2489, 11.4698, 11.3516, 11.4256, 11.3382, 11.4461, 11.3854, 11.3917, 11.2591, 11.3698,
         11.2288, 11.3151, 11.1075, 11.3493, 11.1473, 11.2675, 11.0661, 11.1908, 11.0413, 10.9673, 11.2083, 11.175,
         10.9695, 11.2678, 11.0259, 11.0511, 10.8746, 10.7937, 10.658, 10.3974, 10.2224, 9.4967, 9.1917, 8.93474,
         8.75505, 8.86048, 9.07352, 9.53752, 10.2797, 11.099, 12.0065, 12.8543, 13.7004, 15.2607, 15.7808, 16.0475,
         16.4384, 16.5086, 16.4678, 16.3678, 15.7643, 15.2997, 14.8646, 14.8742, 14.7633, 14.7104, 14.6573, 14.7245,
         14.7302, 14.8888, 15.2009, 15.28, 15.3592, 15.4784, 15.4339, 15.5118, 15.2802, 15.1054, 15.0328, 14.9135,
         15.6923, 16.5296, 17.4799, 17.9989, 18.1358, 18.1087, 18.0748, 17.8969, 17.5739, 17.4, 17.4, 16.9477, 16.9069,
         16.9217, 16.9639, 16.9407, 17.0536, 17.4223, 17.4238, 17.4004, 17.4277, 17.4798, 17.4433, 17.5516, 17.5889,
         17.603, 17.573, 17.4421, 17.3136, 17.4238, 17.4152, 17.4743, 17.4426, 17.4802, 17.3989, 17.5354, 17.5645,
         17.7261, 17.5267, 17.602, 17.4814, 17.5626, 17.7647, 17.6928, 17.7848, 18.9619, 19.5261, 19.7144, 20.0331,
         20.1448, 20.4573, 20.5896, 20.5087, 20.5586, 20.6527, 20.8335, 20.9196, 20.8481, 21.0834, 21.1637, 21.0487,
         21.084, 21.3395, 21.246, 21.4243, 21.2596, 21.2229, 21.3836, 21.7389, 21.3354, 21.4065, 21.5577, 21.7189,
         21.6858, 21.7875, 21.94, 21.8289, 21.7731, 21.7953, 21.8504, 21.8056, 21.8116, 21.9441, 22.0512, 21.9656,
         22.1703, 22.2066, 22.1112, 22.1045, 22.3633, 22.4267, 22.5218, 22.5547, 22.6391, 22.8437, 23.1527, 23.1722,
         23.2851, 23.7379, 23.7485, 23.8158, 23.9382, 23.995, 24.1951, 24.3825, 24.6848, 24.7589, 24.4342, 24.7047,
         25.1194, 25.3965, 25.3568, 25.0291, 25.334, 25.8244, 25.6353, 25.4762, 25.4161, 25.5275, 25.7506, 26.1033,
         26.2364, 25.7176, 26.3475, 26.2056, 26.1179, 25.8764, 26.5224, 26.1842, 26.1415, 26.114, 26.305, 26.0379,
         26.0171, 26.1676, 26.3207, 26.2724, 26.5669, 26.3858, 26.5143, 26.2225, 26.4698, 26.3607, 27.8004, 27.297,
         27.0994, 26.8593, 26.9268, 27.7729, 27.8063, 27.8083, 27.9122, 28.3558, 28.4561, 28.5508, 28.7462, 28.9959,
         29.3335, 29.5941, 29.7534, 29.8586, 29.9756, 30.0292, 30.1725, 30.3659, 30.6818, 31.1216, 31.5017, 31.5075,
         31.5938, 31.7313, 31.8038, 31.7977, 31.8189, 31.7782, 32.1962, 32.2852, 32.3586, 32.4267, 32.6602, 32.9224,
         32.9728, 33.1045, 33.1149, 33.3038, 33.1497, 33.2778, 33.2851, 33.3566, 33.4467, 33.6977, 33.7753, 33.7563,
         33.8598, 33.8322, 33.9073, 33.8254, 34.1761, 34.3185, 34.4123, 34.4113, 34.4381, 34.4094, 34.4865, 34.5671,
         34.5753, 34.5542, 34.6758, 34.6621, 34.6577, 34.722, 34.739, 34.7284, 34.7648, 34.8015, 34.8841, 34.8136,
         34.985, 35.0337, 35.0353, 35.0575, 35.1742, 35.2741, 35.3513, 35.4177, 35.4762, 35.5284, 35.5749, 35.6164,
         35.6531, 35.6855, 35.7139, 35.7386, 35.7598, 35.7788, 35.7981, 35.8134, 35.8208, 35.8224, 35.8192, 35.8116,
         35.7999, 35.7844, 35.765, 35.7421, 35.7157, 35.6858, 35.6552, 35.6214, 35.5811, 35.5323, 35.4785, 35.4193,
         35.3546, 35.2843, 35.2081, 35.1257, 35.0367, 34.9408, 34.8373, 34.7256, 34.6051, 34.4754, 34.3341, 34.1794,
         34.0091, 33.8212, 33.6132, 33.3815, 33.1216, 32.827, 32.4891, 32.0953, 31.6267, 31.0529, 30.3197, 29.3147,
         27.7297, 26.0567, 11.7655, 11.766, 22.0106, 26.8215, 27.2955, 21.0984, 21.1046, 23.8802, 29.6895, 31.2204,
         32.2005, 32.8335, 33.0038, 30.3063, 30.3097, 33.0633, 34.6194, 35.4837, 36.1595, 36.7285, 37.2237, 37.6632,
         38.0588, 38.4199, 38.7534, 39.0586, 39.3346, 39.582, 39.8093, 40.0181, 40.2105, 40.3884, 40.5532, 40.7074,
         40.8546, 40.9913, 41.1149, 41.2262, 41.3274, 41.4199, 41.5045, 41.5819, 41.6528, 41.7177, 41.7772, 41.8317,
         41.8832, 41.9312, 41.9752, 42.0137, 42.0462, 42.0743, 42.0983, 42.1188, 42.1361, 42.1504, 42.1621, 42.1712,
         42.1781, 42.1829, 42.1858, 42.187, 42.187, 42.1859, 42.1843, 42.18, 42.1733, 42.1648, 42.1548, 42.1434,
         42.1308, 42.1171, 42.1024, 42.0868, 42.0703, 42.0531, 42.0352, 42.0166, 41.9974, 41.9777, 41.9575, 41.9368,
         41.9157, 41.8942, 41.8724, 41.8504, 41.8283, 41.8058, 41.7828, 41.7593, 41.7354, 41.7112, 41.6866, 41.6618,
         41.6366, 41.6111, 41.5853, 41.5592, 41.5328, 41.506, 41.4789, 41.4515, 41.4237, 41.3954, 41.3667, 41.3376,
         41.3079, 41.2777, 41.2469, 41.2154, 41.1832, 41.1501, 41.1162, 41.0812, 41.0451, 41.0077, 40.9689, 40.9284,
         40.8861, 40.8416, 40.7947, 40.745, 40.6919, 40.635, 40.5734, 40.5062, 40.4323, 40.3499, 40.2569, 40.15,
         40.0245, 39.8728, 39.682, 39.4272, 39.05, 38.3467, 30.4385, 30.4387, 36.53, 38.7994, 39.4951, 39.9268, 40.241,
         40.4875, 40.6894, 40.8595, 41.0056, 41.1328, 41.2449, 41.3443, 41.4331, 41.5127, 41.5845, 41.6494, 41.7082,
         41.7616, 41.8101, 41.8543, 41.8946, 41.9314, 41.9651, 41.9969, 42.044, 42.0207, 42.0368],
        [2.2382, 2.20464, 2.17288, 2.14408, 2.11566, 2.09307, 2.12057, 2.20711, 2.32651, 2.50051, 2.70468, 2.90608,
         3.10741, 3.30207, 3.47987, 3.65905, 3.8317, 3.99671, 4.06604, 4.14903, 4.28511, 4.40189, 4.48484, 4.61366,
         4.68521, 4.78024, 4.92749, 5.08904, 5.27782, 5.34063, 5.57004, 5.76754, 6.10461, 6.46138, 6.83899, 7.15482,
         7.4778, 7.81536, 7.81949, 8.00166, 8.15603, 8.31339, 8.43669, 8.46479, 8.37323, 8.34358, 8.31758, 8.20842,
         8.10068, 7.99436, 7.88943, 7.78587, 7.68369, 7.59194, 7.53526, 7.5141, 7.40221, 7.26913, 7.13196, 7.01413,
         6.72563, 6.56063, 6.40783, 6.04135, 6.03061, 5.88373, 5.56663, 5.56501, 5.36448, 5.10496, 4.858, 4.62299,
         4.39935, 4.15808, 3.90057, 3.659, 3.4324, 3.21983, 3.02042, 2.83337, 2.75214, 2.68998, 2.62922, 2.64651,
         2.70805, 2.77103, 2.88268, 3.0258, 3.17602, 3.3337, 3.52307, 3.85938, 4.22779, 4.63138, 5.07349, 5.83319,
         7.10494, 8.5742, 9.55601, 10.6502, 11.5398, 12.4914, 12.8588, 13.1002, 13.3462, 13.5968, 13.7169, 13.7968,
         13.8772, 13.958, 14.0873, 14.2381, 14.3904, 14.5444, 14.3024, 14.0002, 13.6925, 13.2537, 12.829, 12.4179,
         11.7007, 10.8716, 10.1012, 10.0331, 10.4822, 10.1299, 9.26469, 9.49797, 9.64907, 8.98189, 8.94557, 9.13384,
         9.12316, 8.47376, 8.36029, 8.40188, 8.19366, 8.2293, 7.44827, 8.52242, 7.64205, 7.30402, 7.22291, 7.09348,
         7.25067, 6.97852, 6.89767, 6.66086, 6.07085, 6.01022, 5.77271, 5.49419, 5.28664, 5.14681, 5.08478, 4.89222,
         4.84541, 4.73206, 4.7283, 4.59901, 4.41675, 4.35222, 4.17081, 4.11991, 4.13939, 4.04662, 3.97945, 3.86676,
         3.85273, 3.67929, 3.65415, 3.58906, 3.50218, 3.45713, 3.44584, 3.28343, 3.03419, 2.77284, 2.70452, 2.65231,
         2.41878, 2.3719, 2.21214, 2.12372, 1.95986, 1.86056, 1.82112, 1.79805, 1.73947, 1.61784, 1.60386, 1.55302,
         1.50288, 1.4639, 1.43164, 1.42941, 1.41247, 1.40706, 1.38653, 1.33199, 1.31953, 1.28227, 1.24929, 1.24483,
         1.23497, 1.23131, 1.20965, 1.20519, 1.19436, 1.18143, 1.17389, 1.1653, 1.16232, 1.14332, 1.14146, 1.13176,
         1.12572, 1.12807, 1.12304, 1.12836, 1.12892, 1.12422, 1.15054, 1.14034, 1.1431, 1.16962, 1.16396, 1.18771,
         1.17972, 1.18491, 1.19752, 1.20176, 1.21224, 1.22801, 1.22468, 1.23528, 1.23181, 1.25392, 1.26327, 1.26128,
         1.28224, 1.28495, 1.28415, 1.29673, 1.31002, 1.32977, 1.332, 1.36794, 1.37159, 1.38204, 1.38587, 1.41934,
         1.41969, 1.4362, 1.4451, 1.46173, 1.46901, 1.45494, 1.46036, 1.47359, 1.49514, 1.50402, 1.57421, 1.54527,
         1.56134, 1.59716, 1.60038, 1.62488, 1.6229, 1.65645, 1.67539, 1.71228, 1.72262, 1.70564, 1.76297, 1.76841,
         1.80146, 1.81816, 1.85414, 1.87819, 1.88871, 1.93743, 1.94694, 1.9676, 1.97101, 2.0033, 2.01755, 2.02584,
         2.02529, 2.04178, 2.03621, 2.06109, 2.07392, 2.06447, 2.10381, 2.09633, 2.12064, 2.11404, 2.13189, 2.11976,
         2.166, 2.1685, 2.15687, 2.18161, 2.18829, 2.21208, 2.19724, 2.19402, 2.2131, 2.29181, 2.32368, 2.33252,
         2.32884, 2.33938, 2.33286, 2.35548, 2.3696, 2.39941, 2.38219, 2.40118, 2.39285, 2.40659, 2.42222, 2.43463,
         2.46663, 2.45939, 2.48544, 2.48963, 2.51004, 2.50513, 2.51774, 2.53945, 2.53091, 2.75666, 2.73945, 2.74607,
         2.87667, 2.92282, 2.94456, 3.00377, 3.04436, 3.06937, 3.10966, 3.45913, 3.6668, 3.79756, 3.96827, 4.16674,
         4.33353, 4.34746, 4.68637, 4.77662, 5.17262, 5.67817, 6.69429, 7.52395, 8.37932, 8.88382, 10.2424, 10.6584,
         11.2767, 12.4461, 12.6289, 13.0767, 13.3229, 13.5314, 13.7116, 14.2016, 14.7091, 15.016, 15.6246, 15.6755,
         15.9323, 16.1742, 16.5721, 16.5, 16.9365, 17.2674, 17.4915, 17.9964, 18.4059, 18.619, 18.551, 18.5476, 18.5783,
         18.7654, 18.8612, 18.9689, 19.1728, 19.1283, 19.3149, 19.3295, 19.573, 19.6365, 19.6725, 19.85, 19.9127,
         19.6817, 19.808, 19.8121, 19.8704, 19.7893, 19.7811, 19.895, 19.954, 20.0178, 19.9865, 20.0771, 20.2438,
         20.3335, 20.2803, 20.4178, 20.4314, 20.5787, 20.5545, 20.8306, 20.7468, 20.9026, 21.0774, 21.1276, 21.2518,
         21.3268, 21.4446, 21.4598, 21.7481, 21.8427, 22.6379, 23.1876, 23.9613, 24.9822, 25.7464, 26.4119, 27.2561,
         27.881, 28.2816, 28.4996, 28.5772, 28.4991, 27.7574, 27.2312, 26.5823, 24.8287, 24.562, 24.1553, 23.6733,
         22.9672, 22.6893, 22.7178, 22.8054, 22.8388, 22.9924, 23.1447, 23.2805, 23.3142, 23.4613, 23.5612, 23.4695,
         23.4172, 23.3021, 23.3331, 23.1313, 23.0968, 23.3282, 23.3322, 24.0232, 25.2454, 25.365, 24.9184, 24.4975,
         24.1436, 23.1175, 23.053, 22.8142, 22.2709, 22.2505, 22.1681, 22.2657, 22.3594, 22.3668, 22.6746, 22.4645,
         22.6295, 22.6417, 22.467, 22.571, 22.4887, 22.5762, 22.4228, 22.5387, 22.4013, 22.284, 22.327, 22.2554,
         22.3439, 22.4117, 22.4161, 22.4748, 22.4494, 22.5176, 22.4695, 22.6994, 22.5192, 22.4917, 22.6457, 22.6283,
         22.7386, 22.7439, 22.9279, 22.8802, 23.1869, 23.6101, 23.5752, 23.5173, 23.6487, 23.1902, 23.0596, 22.8879,
         22.5607, 22.7236, 22.6792, 22.4982, 22.5345, 22.3737, 22.0015, 22.007, 21.8466, 22.1161, 22.1599, 21.7722,
         21.7492, 21.6441, 21.7667, 22.0842, 21.7527, 21.6603, 21.5557, 22.0567, 21.5591, 21.8482, 21.6097, 21.7143,
         21.4763, 21.6375, 21.612, 21.6793, 21.6512, 21.8728, 22.0572, 21.8156, 22.0221, 22.0888, 22.0449, 21.8619,
         22.3984, 22.236, 22.4006, 22.3023, 22.3475, 22.5697, 22.9394, 22.6833, 22.752, 22.7036, 22.9384, 22.5718,
         22.8523, 22.6965, 22.7614, 22.9786, 22.7099, 23.0106, 22.2907, 22.4065, 22.9888, 22.6245, 22.5419, 22.1008,
         21.8848, 22.9132, 21.9605, 21.8652, 21.6171, 21.9564, 21.8132, 22.1452, 21.7086, 21.5559, 20.5629, 21.6065,
         21.4023, 20.961, 21.239, 20.9745, 20.6909, 20.7764, 21.055, 20.5763, 20.8668, 20.5696, 21.1556, 20.8232,
         21.1332, 20.8293, 20.8519, 20.744, 20.7968, 20.8888, 21.2869, 20.0625, 20.137, 19.856, 20.1404, 20.4121,
         20.5036, 20.5081, 20.3636, 20.423, 20.274, 20.1466, 20.1158, 19.8317, 19.6391, 19.4223, 19.2809, 19.1561,
         19.1121, 19.0081, 18.97, 18.8819, 18.7183, 18.5804, 18.379, 18.1283, 18.0031, 17.8055, 17.8329, 17.6779,
         17.4101, 17.4732, 17.316, 17.0953, 17.0178, 16.9561, 16.9551, 16.7376, 16.4707, 16.4692, 16.3664, 16.3366,
         16.1628, 15.8333, 15.5105, 15.4933, 15.4087, 15.3219, 15.0785, 15.0636, 15.0663, 14.973, 14.9468, 14.854,
         14.8614, 14.546, 14.3564, 14.0749, 13.9611, 13.9046, 13.9121, 13.7253, 13.6432, 13.5638, 13.581, 13.4919,
         13.4643, 13.3575, 13.2798, 13.2132, 13.2203, 13.1541, 13.2271, 13.0496, 13.0382, 12.7263, 12.4218, 12.1651,
         12.0039, 11.8198, 11.5762, 11.3376, 11.1038, 10.8749, 10.6508, 10.4312, 10.2161, 10.0055, 9.79928, 9.59728,
         9.39943, 9.20566, 9.01589, 8.83002, 8.64029, 8.45265, 8.26907, 8.08949, 7.9138, 7.74193, 7.57379, 7.40931,
         7.24839, 7.09097, 6.93697, 6.78632, 6.63329, 6.48153, 6.33325, 6.18836, 6.04679, 5.90844, 5.77327, 5.64119,
         5.51213, 5.38602, 5.2628, 5.1424, 5.02475, 4.90979, 4.79747, 4.68573, 4.57558, 4.46803, 4.36299, 4.26044,
         4.16029, 4.06249, 3.96699, 3.87374, 3.78268, 3.69376, 3.60694, 3.52215, 3.43935, 3.35851, 3.31169, 3.25903,
         11.204, 11.1674, 10.9111, 10.7583, 10.5632, 14.4992, 14.4931, 14.1719, 13.8578, 13.5507, 13.2504, 12.9972,
         12.8302, 14.5823, 14.5069, 14.1777, 13.8559, 13.5414, 13.2341, 12.9337, 12.6402, 12.3533, 12.0729, 11.7969,
         11.5112, 11.2324, 10.9604, 10.695, 10.436, 10.1832, 9.93663, 9.69597, 9.46115, 9.23203, 9.00145, 8.77184,
         8.54808, 8.33001, 8.11752, 7.91045, 7.70867, 7.51203, 7.32039, 7.13365, 6.95168, 6.77435, 6.60155, 6.42872,
         6.25797, 6.09175, 5.92995, 5.77245, 5.61913, 5.46987, 5.32459, 5.18316, 5.0455, 4.91149, 4.78102, 4.65404,
         4.53042, 4.41009, 4.29296, 4.17736, 4.06303, 3.95183, 3.84368, 3.73849, 3.63618, 3.53667, 3.43987, 3.34573,
         3.25417, 3.16511, 3.07849, 2.99424, 2.91229, 2.83259, 2.75507, 2.67967, 2.60633, 2.535, 2.46562, 2.39814,
         2.33251, 2.26868, 2.20595, 2.14481, 2.08536, 2.02756, 1.97136, 1.91663, 1.8634, 1.81163, 1.76127, 1.71229,
         1.66464, 1.6183, 1.57323, 1.52939, 1.48676, 1.4453, 1.40498, 1.36577, 1.32764, 1.29056, 1.25451, 1.21945,
         1.18536, 1.15221, 1.11997, 1.08863, 1.05816, 1.02852, 0.999713, 0.9717, 0.944462, 0.91798, 0.892231, 0.867197,
         0.842856, 0.81919, 0.79618, 0.773808, 0.752056, 0.730907, 0.710344, 0.690352, 0.670913, 0.652013, 0.633637,
         0.615769, 0.598396, 0.581504, 0.565079, 0.551156, 3.7149, 3.70285, 3.61058, 3.52009, 3.43139, 3.34446, 3.2593,
         3.1759, 3.09425, 3.01432, 2.93611, 2.8596, 2.78477, 2.71161, 2.64008, 2.57017, 2.50187, 2.43514, 2.36996,
         2.30632, 2.24418, 2.18352, 2.12432, 2.06655, 2.01019, 1.95521, 1.90158, 1.89415]],
    'Tc':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.6768, 2.677, 2.7033, 2.74703, 2.79146, 2.7931, 2.7933000000000003,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.0424, 3.0425999999999997, 3.07355,
         3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682,
         3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.0439, 21.0441, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382,
         23.2076, 23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 7.37166, 7.43509, 7.48267, 7.49547, 7.48578, 7.46206, 7.41243, 7.3352, 7.23723, 7.08784, 6.87034, 6.61076,
         6.2912, 5.94067, 5.51899, 5.09533, 4.58341, 4.18756, 3.85, 3.52904, 3.18421, 2.9213, 2.7825, 2.81406, 3.15931,
         3.57313, 4.11858, 4.67136, 5.35619, 6.10311, 6.84115, 7.72059, 8.53817, 9.36473, 10.3179, 11.3579, 12.1996,
         12.9725, 13.7587, 14.72, 15.382, 15.7699, 16.079, 16.373, 16.6473, 16.8862, 17.0869, 17.2599, 17.4121, 17.5505,
         17.6871, 17.8566, 17.9548, 18.008, 18.0407, 18.088, 18.0544, 17.9623, 17.8236, 17.7002, 17.5808, 17.4518,
         17.2983, 17.1776, 17.0829, 17.0235, 16.9418, 16.8264, 16.6882, 16.5482, 16.4067, 16.2646, 16.1165, 15.9571,
         15.7841, 15.6045, 15.4315, 15.2549, 15.0546, 14.8707, 14.6982, 14.5376, 14.3801, 14.2249, 14.0799, 13.9359,
         13.8044, 13.68, 13.5563, 13.4387, 13.328, 13.2213, 13.1149, 13.0121, 12.9165, 12.8263, 12.7415, 12.6648,
         12.5929, 12.5184, 12.4431, 12.3683, 12.2939, 12.2204, 12.1481, 12.0781, 12.0151, 11.9537, 11.8853, 11.8136,
         11.7411, 11.6743, 11.5967, 11.5091, 11.4135, 11.3103, 11.1999, 11.0817, 10.9557, 10.8223, 10.6781, 10.5201,
         10.3473, 10.1584, 9.95073, 9.72317, 9.47149, 9.18736, 8.86388, 8.50599, 8.06419, 7.60929, 7.1467, 6.6198,
         6.05436, 5.4705, 4.70238, 3.87048, 3.08638, 2.42175, 1.92526, 1.74073, 1.78665, 2.10913, 2.46263, 2.86646,
         3.37108, 3.87091, 4.54441, 5.19136, 5.95551, 6.63523, 7.24587, 7.84397, 8.44774, 9.09472, 9.90055, 10.6174,
         11.2407, 11.8406, 12.4293, 13.024, 13.6347, 14.2715, 15.0272, 15.7847, 16.4398, 17.0414, 17.5885, 18.0684,
         18.6886, 19.5037, 20.1795, 20.7707, 21.3262, 21.8514, 22.3522, 22.8295, 23.2798, 23.6778, 24.0509, 24.4514,
         24.9815, 25.6947, 26.518, 27.2204, 27.7809, 28.2829, 28.7466, 29.1808, 29.5917, 29.9881, 30.3714, 30.7344,
         31.0588, 31.3427, 31.5923, 31.8512, 32.1444, 32.4463, 32.7185, 32.9702, 33.2089, 33.4378, 33.6602, 33.8749,
         34.0751, 34.2637, 34.4433, 34.616, 34.7824, 34.9422, 35.0929, 35.2364, 35.3747, 35.5128, 35.6445, 35.767,
         35.8789, 35.983, 36.0816, 36.1768, 36.2652, 36.346, 36.4173, 36.4809, 36.538, 36.5893, 36.635, 36.6756,
         36.7115, 36.7429, 36.7699, 36.7927, 36.8116, 36.8267, 36.8386, 36.8472, 36.8526, 36.8549, 36.8542, 36.8505,
         36.8444, 36.8361, 36.8264, 36.8155, 36.7998, 36.778, 36.7505, 36.7187, 36.6827, 36.6427, 36.5983, 36.5498,
         36.4984, 36.4425, 36.3807, 36.3129, 36.2387, 36.1582, 36.0715, 35.9779, 35.8765, 35.7666, 35.6501, 35.5241,
         35.3858, 35.2346, 35.0688, 34.8864, 34.6844, 34.4595, 34.2072, 33.9212, 33.5934, 33.2118, 32.7585, 32.2052,
         31.502, 30.5482, 29.0794, 25.7283, 12.8319, 12.8336, 26.6708, 28.4483, 25.6981, 22.1757, 22.1803, 30.6058,
         32.1711, 33.1956, 33.9061, 34.1676, 32.2661, 32.27, 35.1555, 36.1763, 36.9158, 37.5266, 38.0531, 38.5172,
         38.931, 39.3038, 39.6418, 39.9493, 40.2303, 40.4876, 40.7241, 40.9421, 41.1421, 41.3263, 41.4964, 41.6533,
         41.798, 41.9315, 42.0546, 42.1681, 42.2725, 42.3686, 42.4568, 42.5378, 42.6119, 42.6797, 42.7415, 42.7978,
         42.8488, 42.8948, 42.9363, 42.9734, 43.0065, 43.0358, 43.0616, 43.0839, 43.1031, 43.1194, 43.1329, 43.1437,
         43.1521, 43.1582, 43.1621, 43.164, 43.1641, 43.1623, 43.1589, 43.1539, 43.1474, 43.1395, 43.1304, 43.1201,
         43.1086, 43.0961, 43.0827, 43.0683, 43.053, 43.037, 43.0201, 43.0026, 42.9844, 42.9657, 42.9464, 42.9265,
         42.9061, 42.8853, 42.8639, 42.8422, 42.8201, 42.7977, 42.7749, 42.7517, 42.7282, 42.7044, 42.6803, 42.6559,
         42.6312, 42.6062, 42.5808, 42.5552, 42.5293, 42.503, 42.4764, 42.4494, 42.4221, 42.3943, 42.3661, 42.3375,
         42.3083, 42.2786, 42.2483, 42.2173, 42.1856, 42.1531, 42.1196, 42.0852, 42.0496, 42.0128, 41.9745, 41.9347,
         41.893, 41.8492, 41.8029, 41.7539, 41.7017, 41.6456, 41.5849, 41.5188, 41.446, 41.365, 41.2735, 41.1685,
         41.0452, 40.8965, 40.7097, 40.461, 40.0945, 39.4202, 31.5802, 31.5804, 37.3416, 39.8013, 40.4975, 40.9262,
         41.2375, 41.4815, 41.6813, 41.8496, 41.9943, 42.1203, 42.2314, 42.33, 42.4181, 42.4972, 42.5686, 42.6331,
         42.6917, 42.7449, 42.7933, 42.8375, 42.8782, 42.9209, 42.9302],
        [1.1689, 1.2263, 1.28651, 1.34968, 1.41595, 1.48547, 1.55841, 1.63493, 1.7152, 1.7906, 1.85821, 1.92837,
         2.00119, 2.07675, 2.15643, 2.24083, 2.32854, 2.41967, 2.51072, 2.59715, 2.68656, 2.77904, 2.87471, 2.97073,
         3.0668, 3.16598, 3.26836, 3.37406, 3.46886, 3.54805, 3.62904, 3.71188, 3.79661, 3.88292, 3.96908, 4.05715,
         4.14718, 4.2392, 4.33326, 4.42942, 4.5277, 4.58174, 4.63623, 4.69149, 4.74862, 4.80646, 4.86499, 4.92424,
         4.98421, 5.04491, 5.10635, 5.16504, 5.19243, 5.21996, 5.24765, 5.27548, 5.30345, 5.30974, 5.2995, 5.28929,
         5.27909, 5.26892, 5.25876, 5.22652, 5.1654, 5.105, 5.04531, 4.98631, 4.92525, 4.81345, 4.70419, 4.59741,
         4.48968, 4.36859, 4.25077, 4.12859, 3.99, 3.86322, 3.78904, 3.73288, 3.75422, 3.83128, 3.97773, 4.26742,
         4.68469, 5.14275, 5.6456, 6.22739, 6.99385, 7.85463, 8.82136, 9.80863, 10.586, 11.3361, 12.0004, 12.7037,
         13.1431, 13.5966, 13.9698, 14.1836, 14.4007, 14.6211, 14.4911, 14.2552, 14.0231, 13.7948, 13.4012, 12.6585,
         11.9812, 11.4817, 11.0031, 10.5443, 10.0809, 9.63785, 9.21431, 8.80939, 8.42224, 8.05212, 7.65887, 7.21569,
         6.79817, 6.4048, 5.99628, 5.56111, 5.15754, 4.82222, 4.53199, 4.25922, 4.00287, 3.78562, 3.60675, 3.43634,
         3.26444, 3.02963, 2.81171, 2.61612, 2.43998, 2.27569, 2.12247, 1.96821, 1.82456, 1.6914, 1.58592, 1.49249,
         1.40456, 1.33154, 1.30103, 1.27522, 1.26046, 1.24587, 1.24819, 1.25535, 1.27065, 1.29476, 1.31933, 1.34512,
         1.38077, 1.41738, 1.45495, 1.49352, 1.54153, 1.59194, 1.644, 1.69776, 1.75328, 1.79879, 1.84304, 1.88838,
         1.93426, 1.98095, 2.02877, 2.07774, 2.1279, 2.17926, 2.2175, 2.25297, 2.28901, 2.32562, 2.35799, 2.37664,
         2.39544, 2.41439, 2.43358, 2.45303, 2.47264, 2.49239, 2.51232, 2.52681, 2.54117, 2.55562, 2.57015, 2.58566,
         2.60238, 2.61921, 2.63637, 2.66524, 2.70937, 2.76557, 2.91946, 3.08193, 3.25343, 3.53883, 3.83335, 4.1908,
         4.73985, 5.62785, 6.68223, 7.92684, 9.37968, 10.6247, 11.9587, 12.93, 13.9802, 14.9, 15.7829, 16.6537, 17.3545,
         18.0167, 18.493, 18.9772, 19.4489, 19.9324, 20.428, 20.8365, 21.0751, 21.3163, 21.5604, 21.8145, 22.0754,
         22.3394, 22.6065, 22.8768, 22.937, 22.9562, 22.9755, 22.9948, 23.0874, 23.3023, 23.3851, 23.2504, 23.1337,
         23.0176, 22.9022, 22.7873, 22.6726, 22.559, 22.4631, 22.4272, 22.5047, 22.6391, 22.774, 22.6037, 22.288,
         21.9535, 21.6284, 21.3108, 20.9975, 20.6889, 20.3837, 20.0701, 19.7407, 19.4033, 19.0713, 18.784, 18.5308,
         18.2862, 18.008, 17.7091, 17.4161, 17.1277, 16.8439, 16.5626, 16.2787, 15.9937, 15.7137, 15.4387, 15.1684,
         14.9002, 14.6336, 14.3691, 14.1094, 13.8543, 13.6038, 13.3446, 13.087, 12.8314, 12.5809, 12.3345, 12.0919,
         11.8464, 11.6034, 11.3628, 11.1272, 10.8965, 10.6705, 10.4491, 10.2323, 10.0201, 9.81229, 9.60876, 9.40949,
         9.21458, 9.02398, 8.83764, 8.65498, 8.47613, 8.30103, 8.12948, 7.96152, 7.79715, 7.63613, 7.47744, 7.32056,
         7.16085, 7.00379, 6.85016, 6.70009, 6.55328, 6.40959, 6.26893, 6.13145, 5.99714, 5.86328, 5.73151, 5.60197,
         5.47539, 5.35178, 5.23118, 5.1129, 4.99737, 4.88481, 4.77624, 4.66695, 4.55979, 4.45478, 4.35192, 4.25115,
         4.15241, 4.05568, 3.96096, 3.86811, 3.77722, 3.68816, 3.60095, 3.51552, 3.43186, 3.34994, 3.26969, 3.1911,
         3.16127, 11.0693, 10.9097, 10.6527, 10.4016, 10.3925, 14.3074, 14.0749, 13.8366, 13.6029, 13.3728, 13.1468,
         13.0652, 14.3922, 14.1871, 13.868, 13.5539, 13.2442, 12.9395, 12.6397, 12.3443, 12.0547, 11.7696, 11.4895,
         11.2147, 10.9448, 10.6805, 10.4208, 10.1656, 9.9161, 9.67151, 9.43192, 9.19719, 8.96736, 8.74243, 8.52225,
         8.30675, 8.09594, 7.88983, 7.68828, 7.4912, 7.2986, 7.11047, 6.9266, 6.74687, 6.57146, 6.40008, 6.23282,
         6.06949, 5.9101, 5.7545, 5.60265, 5.45455, 5.30998, 5.16904, 5.0315, 4.89738, 4.76666, 4.63916, 4.51495,
         4.39381, 4.27569, 4.16057, 4.0484, 3.93912, 3.83261, 3.72891, 3.62786, 3.52934, 3.43356, 3.34007, 3.24908,
         3.16052, 3.07424, 2.99023, 2.90849, 2.82887, 2.75144, 2.67584, 2.60243, 2.53091, 2.46127, 2.39355, 2.32769,
         2.2636, 2.20111, 2.14033, 2.08123, 2.02369, 1.96771, 1.91324, 1.86024, 1.80868, 1.75851, 1.7097, 1.66222,
         1.61603, 1.57109, 1.52737, 1.48485, 1.44348, 1.40324, 1.3641, 1.32603, 1.28899, 1.25297, 1.21793, 1.18385,
         1.1507, 1.11846, 1.08709, 1.05659, 1.02692, 0.998065, 0.969997, 0.942699, 0.916146, 0.89032, 0.865201,
         0.840769, 0.817006, 0.793892, 0.771411, 0.749543, 0.728274, 0.707585, 0.687461, 0.667887, 0.648847, 0.630327,
         0.61231, 0.594786, 0.577738, 0.561154, 0.546632, 3.65633, 3.64736, 3.5582, 3.47064, 3.38468, 3.30033, 3.21759,
         3.13646, 3.05694, 2.97901, 2.90268, 2.82793, 2.75475, 2.68313, 2.61305, 2.5445, 2.47747, 2.41193, 2.34787,
         2.28527, 2.2241, 2.16436, 2.10602, 2.04905]],
    'Ru':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.011010500000000001, 0.0111886, 0.0113696,
         0.0115535, 0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268,
         0.013135899999999999, 0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146972,
         0.014935, 0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.0183988, 0.018696400000000002, 0.0189988, 0.0193061,
         0.0196184, 0.0199357, 0.020258099999999998, 0.020585799999999998, 0.020918700000000002, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234052, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253602, 0.0257704, 0.0261872, 0.0266108, 0.0270412, 0.0274786, 0.027923, 0.0283747,
         0.0288336, 0.0293, 0.029773900000000002, 0.030255400000000002, 0.030744800000000003, 0.031242100000000002,
         0.0317474, 0.0322609, 0.0327827, 0.0333129, 0.0338517, 0.0343992, 0.034955599999999996, 0.035521000000000004,
         0.0360955, 0.0366793, 0.037272599999999996, 0.0378754, 0.038488, 0.039110599999999995, 0.039743099999999996,
         0.0400039, 0.0405878, 0.040997900000000004, 0.041304099999999996, 0.0415802, 0.0422527, 0.042836,
         0.043176099999999995, 0.0437675, 0.0442033, 0.0446702, 0.0452616, 0.0457285, 0.046102, 0.0467245,
         0.047129199999999996, 0.0476272, 0.048156399999999995, 0.0489353, 0.0489968, 0.0494948, 0.050055100000000005,
         0.0505175, 0.0509325, 0.051756300000000005, 0.052593400000000005, 0.0534441, 0.0543085, 0.055186900000000004,
         0.056079500000000004, 0.0569865, 0.0579082, 0.0588448, 0.0597966, 0.06076380000000001, 0.0617466, 0.0627453,
         0.0637601, 0.0647914, 0.06583939999999999, 0.0669043, 0.0679864, 0.069086, 0.0702034, 0.0713389, 0.0724927,
         0.0736652, 0.0748567, 0.0760675, 0.0772978, 0.078548, 0.0798185, 0.0811095, 0.0824214, 0.0837545, 0.0851091,
         0.0864857, 0.0878845, 0.089306, 0.0907504, 0.0922183, 0.0937098, 0.09522549999999999, 0.0967657, 0.0983308,
         0.0999212, 0.101537, 0.10318000000000001, 0.104849, 0.106544, 0.108268, 0.110019, 0.11179800000000001,
         0.113606, 0.115444, 0.11731100000000001, 0.11920900000000001, 0.121137, 0.123096, 0.125087, 0.12711, 0.129166,
         0.13125499999999998, 0.133378, 0.135535, 0.13772800000000002, 0.13995500000000002, 0.14221899999999998,
         0.144519, 0.146857, 0.149232, 0.15164599999999998, 0.154098, 0.156591, 0.159124, 0.161697, 0.164313, 0.16697,
         0.169671, 0.17241499999999998, 0.175204, 0.178038, 0.180917, 0.18384299999999998, 0.186817, 0.189838, 0.192909,
         0.196029, 0.1992, 0.202422, 0.205696, 0.209023, 0.21240299999999998, 0.215839, 0.21933000000000002,
         0.22287700000000002, 0.226482, 0.23014500000000002, 0.233868, 0.23765, 0.241494, 0.2454, 0.249369, 0.253403,
         0.257501, 0.261666, 0.265898, 0.270199, 0.274569, 0.27901, 0.280127, 0.28236700000000003, 0.284663, 0.285868,
         0.288049, 0.29028699999999996, 0.291722, 0.29373, 0.295739, 0.297919, 0.30010000000000003, 0.30210899999999996,
         0.304017, 0.305858, 0.30702999999999997, 0.30870299999999995, 0.31063999999999997, 0.313621, 0.315895,
         0.317966, 0.319684, 0.321502, 0.32301799999999997, 0.324584, 0.32564499999999996, 0.326655, 0.327618, 0.328075,
         0.328729, 0.32958499999999996, 0.330765, 0.331621, 0.33201400000000003, 0.332572, 0.333219, 0.334031,
         0.33461900000000006, 0.335159, 0.335964, 0.336994, 0.338292, 0.33913499999999996, 0.34082, 0.34375, 0.34612,
         0.347906, 0.353011, 0.358721, 0.36452300000000004, 0.370419, 0.37641, 0.382498, 0.38868400000000003, 0.394971,
         0.40135899999999997, 0.407851, 0.414448, 0.421151, 0.42796300000000004, 0.43488499999999997, 0.441919,
         0.44906599999999997, 0.45010300000000003, 0.454761, 0.456563, 0.457438, 0.45847000000000004, 0.45914, 0.459984,
         0.460764, 0.461169, 0.46162400000000003, 0.461884, 0.46214299999999997, 0.462445, 0.462843, 0.46313, 0.463703,
         0.46442, 0.465009, 0.46632999999999997, 0.467949, 0.469861, 0.472766, 0.474874, 0.477036, 0.47927, 0.481341,
         0.48213799999999996, 0.48280599999999996, 0.483323, 0.483861, 0.484271, 0.484637, 0.48500299999999996,
         0.485757, 0.486274, 0.48694099999999996, 0.487307, 0.488858, 0.490603, 0.492116, 0.493944, 0.495284, 0.498811,
         0.502679, 0.507991, 0.516207, 0.5179969999999999, 0.524839, 0.5309729999999999, 0.5392089999999999,
         0.5460280000000001, 0.55486, 0.555036, 0.563914, 0.570863, 0.5800960000000001, 0.5894790000000001, 0.599013,
         0.608702, 0.6185470000000001, 0.628552, 0.638718, 0.649049, 0.6595460000000001, 0.6702140000000001,
         0.6810539999999999, 0.6920700000000001, 0.7032630000000001, 0.714638, 0.726197, 0.737943, 0.749878, 0.762007,
         0.774332, 0.786856, 0.7995829999999999, 0.812515, 0.8256570000000001, 0.839011, 0.852582, 0.866371, 0.880384,
         0.894624, 0.9090940000000001, 0.923797, 0.938739, 0.953922, 0.969351, 0.98503, 1.00096, 1.01715,
         1.0335999999999999, 1.05032, 1.06731, 1.08457, 1.10211, 1.1199400000000002, 1.13805, 1.15646, 1.17517,
         1.1941700000000002, 1.21349, 1.23312, 1.2530599999999998, 1.2733299999999999, 1.28, 1.294, 1.3149300000000002,
         1.3362, 1.35781, 1.37977, 1.4020899999999998, 1.42477, 1.44781, 1.47123, 1.49502, 1.5192, 1.54378, 1.56874,
         1.59412, 1.6199000000000001, 1.6461, 1.67273, 1.69978, 1.72727, 1.75521, 1.7835999999999999,
         1.8124500000000001, 1.84176, 1.87155, 1.9018199999999998, 1.93258, 1.9638399999999998, 1.9956099999999999, 2.0,
         2.026, 2.052, 2.079, 2.106, 2.134, 2.161, 2.19, 2.218, 2.247, 2.277, 2.306, 2.337, 2.367, 2.398, 2.429, 2.461,
         2.493, 2.526, 2.559, 2.592, 2.626, 2.66, 2.695, 2.73, 2.766, 2.802, 2.8378, 2.838, 2.839, 2.876, 2.914, 2.952,
         2.9668, 2.967, 2.99, 3.029, 3.069, 3.109, 3.15, 3.191, 3.2239, 3.2241, 3.232, 3.275, 3.317, 3.361, 3.405,
         3.449, 3.494, 3.54, 3.586, 3.633, 3.68, 3.729, 3.777, 3.827, 3.877, 3.927, 3.979, 4.031, 4.083, 4.137, 4.191,
         4.245, 4.301, 4.357, 4.414, 4.472, 4.53, 4.589, 4.649, 4.71, 4.771, 4.834, 4.897, 4.961, 5.026, 5.091, 5.158,
         5.225, 5.294, 5.363, 5.433, 5.504, 5.576, 5.649, 5.722, 5.797, 5.873, 5.95, 6.027, 6.106, 6.186, 6.267, 6.349,
         6.432, 6.516, 6.601, 6.687, 6.774, 6.863, 6.952, 7.043, 7.135, 7.229, 7.323, 7.419, 7.516, 7.614, 7.713, 7.814,
         7.916, 8.019, 8.124, 8.23, 8.338, 8.447, 8.557, 8.669, 8.782, 8.897, 9.013, 9.131, 9.25, 9.371, 9.494, 9.618,
         9.743, 9.90058, 10.0607, 10.2234, 10.3888, 10.556799999999999, 10.7276, 10.9011, 11.077399999999999, 11.2566,
         11.438600000000001, 11.6236, 11.8117, 12.0027, 12.1968, 12.3941, 12.5946, 12.7983, 13.0053, 13.2156, 13.4294,
         13.646600000000001, 13.867299999999998, 14.0916, 14.3195, 14.5511, 14.7865, 15.0256, 15.2687,
         15.515600000000001, 15.7666, 16.0216, 16.2807, 16.5441, 16.8116, 17.083599999999997, 17.359900000000003,
         17.6406, 17.926, 18.2159, 18.5105, 18.809900000000003, 19.1142, 19.423299999999998, 19.7375, 20.0567, 20.3811,
         20.7108, 21.0457, 21.3861, 21.732, 22.0835, 22.117099999999997, 22.1173, 22.4407, 22.8037, 23.1725, 23.5473,
         23.9282, 24.3152, 24.7085, 25.1081, 25.514200000000002, 25.9269, 26.3462, 26.7724, 27.2054, 27.645400000000002,
         28.092599999999997, 28.5469, 29.0087, 29.4779, 29.9546, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, 2.3629, 2.49084,
         2.62131, 2.75833, 2.90708, 3.08159, 3.27035, 3.45778, 3.63272, 3.79793, 3.96566, 4.13697, 4.32583, 4.52598,
         4.72418, 4.91526, 5.11788, 5.33916, 5.60852, 5.89743, 6.15535, 6.34183, 6.52375, 6.69375, 6.85038, 6.97284,
         7.07484, 7.16284, 7.2449, 7.3145, 7.36925, 7.38966, 7.38578, 7.3603, 7.3139, 7.24664, 7.1579, 7.0457, 6.90896,
         6.74541, 6.55929, 6.33624, 6.05924, 5.71726, 5.2988, 4.77529, 4.51009, 3.74893, 3.09986, 2.51648, 2.07541,
         1.03443, 0.0438102, -0.109399, 0.133196, 0.522509, 1.00796, 1.61535, 2.0414, 2.27325, 2.66297, 3.01234,
         3.55272, 4.19227, 5.14469, 5.21749, 5.76233, 6.35466, 6.77962, 7.10901, 7.73272, 8.40526, 9.13482, 9.90814,
         10.7066, 11.5058, 12.3596, 13.1896, 13.8834, 14.5501, 15.2, 15.8288, 16.3893, 16.9381, 17.5455, 18.0522,
         18.4956, 18.8747, 19.2359, 19.5928, 19.7895, 19.9779, 20.1806, 20.3003, 20.3711, 20.3955, 20.3849, 20.3501,
         20.2957, 20.2033, 20.0859, 19.9475, 19.771, 19.5593, 19.3009, 19.0197, 18.7281, 18.4381, 18.151, 17.8654,
         17.5808, 17.305, 17.0389, 16.7857, 16.5445, 16.319, 16.1201, 15.9351, 15.758, 15.5859, 15.4169, 15.251,
         15.0841, 14.9267, 14.7775, 14.6318, 14.4966, 14.3705, 14.2507, 14.1355, 14.0246, 13.9179, 13.8157, 13.7173,
         13.6223, 13.5299, 13.4396, 13.3512, 13.2645, 13.1805, 13.0993, 13.0214, 12.9439, 12.8688, 12.7976, 12.7254,
         12.6531, 12.5811, 12.5068, 12.4298, 12.3493, 12.267, 12.1803, 12.0865, 11.9894, 11.8867, 11.7757, 11.6593,
         11.5358, 11.4025, 11.2687, 11.1247, 10.9611, 10.7792, 10.578, 10.3542, 10.0998, 9.81356, 9.49247, 9.12986,
         8.71904, 8.2514, 7.68885, 7.02524, 6.26695, 5.05363, 4.67657, 3.83931, 3.17574, 2.9719, 2.76904, 2.68129,
         2.6389, 2.57283, 2.49192, 2.37608, 2.25763, 2.11591, 1.89825, 1.46381, 1.04877, 0.582941, 0.312513, 0.015336,
         -0.37949, -0.860916, -1.09405, -1.03542, -0.745226, -0.213251, 0.373235, 1.00627, 1.71792, 2.05591, 2.52905,
         2.98806, 3.37681, 3.53215, 3.63947, 3.84285, 4.04774, 4.14435, 4.13706, 4.1472, 4.30532, 4.36993, 4.70381,
         5.1416, 5.81363, 5.96299, 6.27693, 6.3815, 6.87593, 7.37113, 8.90402, 10.2289, 11.3747, 12.1589, 12.8099,
         13.4008, 13.9916, 14.5865, 15.1614, 15.6872, 16.1458, 16.5737, 16.9481, 17.0735, 17.0299, 16.4396, 15.9125,
         15.5793, 15.2264, 14.862, 14.3134, 13.594, 13.6805, 14.301, 15.195, 16.2855, 17.6141, 19.2924, 20.2369,
         21.2806, 21.4706, 21.2445, 20.5503, 19.5913, 19.1203, 19.3925, 19.958, 20.2419, 20.3658, 20.2135, 20.0283,
         19.7489, 19.5698, 19.7073, 20.2124, 20.826, 21.4332, 22.4436, 22.6594, 22.4477, 22.4348, 21.9339, 21.7517,
         21.6933, 21.7267, 21.8706, 22.6499, 23.3413, 23.8484, 24.6347, 24.8998, 25.6189, 25.733, 25.6128, 25.7636,
         26.1025, 26.086, 26.3948, 26.6856, 27.12, 27.5882, 28.1658, 28.6311, 28.8097, 28.9909, 29.3573, 29.6254,
         30.0185, 30.7512, 31.3689, 31.7196, 32.0565, 32.344, 32.5802, 32.8048, 33.0277, 33.2753, 33.5458, 33.8201,
         34.0868, 34.3266, 34.5498, 34.7568, 34.9481, 35.1238, 35.2798, 35.4432, 35.6058, 35.7648, 35.9224, 36.0817,
         36.2486, 36.4498, 36.65, 36.8189, 36.9643, 37.0969, 37.2212, 37.3309, 37.4291, 37.518, 37.5988, 37.6724,
         37.7393, 37.8, 37.8551, 37.9053, 37.9511, 37.9936, 38.0071, 38.0321, 38.0562, 38.083, 38.1073, 38.1284,
         38.1466, 38.1629, 38.1791, 38.1959, 38.2134, 38.2248, 38.2232, 38.2142, 38.1992, 38.1787, 38.1532, 38.1229,
         38.0879, 38.0487, 38.0055, 37.9569, 37.9031, 37.844, 37.7795, 37.7095, 37.6341, 37.5531, 37.4655, 37.453,
         37.3771, 37.2985, 37.2127, 37.1226, 37.0245, 36.9253, 36.8132, 36.6993, 36.5748, 36.4386, 36.2989, 36.1401,
         35.9758, 35.7937, 35.5975, 35.3777, 35.1374, 34.8641, 34.5592, 34.2152, 33.8082, 33.33, 32.7328, 31.9715,
         30.8865, 29.0699, 14.534, 14.5358, 20.4074, 28.8893, 30.0681, 29.6453, 24.0181, 24.0261, 30.9932, 32.793,
         33.8596, 34.597, 35.1153, 35.3291, 33.0448, 33.0512, 35.1847, 36.5959, 37.3264, 37.9226, 38.4225, 38.8569,
         39.2504, 39.6103, 39.9351, 40.2358, 40.51, 40.7718, 41.0066, 41.2312, 41.438, 41.6291, 41.8122, 41.9809,
         42.1374, 42.2879, 42.4269, 42.5556, 42.6791, 42.7935, 42.9012, 43.0027, 43.0965, 43.1848, 43.2677, 43.3456,
         43.4175, 43.4859, 43.5489, 43.6077, 43.6626, 43.713, 43.7606, 43.804, 43.8449, 43.882, 43.9162, 43.9476,
         43.9763, 44.0024, 44.0257, 44.0471, 44.0662, 44.0832, 44.0981, 44.1112, 44.1225, 44.1319, 44.1398, 44.146,
         44.1508, 44.1542, 44.1562, 44.1569, 44.1565, 44.155, 44.1523, 44.1486, 44.1438, 44.1382, 44.1316, 44.1242,
         44.1161, 44.1072, 44.0976, 44.0873, 44.0763, 44.0647, 44.0526, 44.0398, 44.0267, 44.013, 43.9987, 43.9842,
         43.9692, 43.9538, 43.9379, 43.9218, 43.9053, 43.8885, 43.8714, 43.8541, 43.8323, 43.81, 43.7873, 43.7643,
         43.741, 43.7173, 43.6933, 43.6689, 43.6443, 43.6194, 43.5941, 43.5686, 43.5427, 43.5165, 43.49, 43.4631,
         43.4358, 43.4082, 43.3801, 43.3516, 43.3226, 43.293, 43.2629, 43.2321, 43.2007, 43.1684, 43.1353, 43.1013,
         43.0661, 43.0298, 42.9921, 42.9529, 42.9119, 42.8689, 42.8236, 42.7757, 42.7247, 42.6701, 42.6111, 42.547,
         42.4767, 42.3986, 42.3107, 42.2102, 42.093, 41.9524, 41.7776, 41.5481, 41.2183, 40.6482, 38.3598, 32.7242,
         32.7244, 40.6444, 41.4237, 41.877, 42.1991, 42.4487, 42.6518, 42.8222, 42.9681, 43.095, 43.2066, 43.3056,
         43.3941, 43.4735, 43.5451, 43.6099, 43.6688, 43.7229, 43.7818, 43.7882, 43.8005],
        [1.51919, 1.51438, 1.51486, 1.54335, 1.57238, 1.60195, 1.63207, 1.66277, 1.7032, 1.79614, 1.89247, 1.98441,
         2.08083, 2.18192, 2.28793, 2.39908, 2.515, 2.63274, 2.75599, 2.885, 3.02006, 3.16144, 3.29139, 3.42241,
         3.55864, 3.70029, 3.84758, 4.00073, 4.15722, 4.31627, 4.4814, 4.65285, 4.83086, 5.01568, 5.19592, 5.35976,
         5.52876, 5.70309, 5.88292, 6.06842, 6.21828, 6.34963, 6.48374, 6.6207, 6.76054, 6.90334, 7.04915, 7.16466,
         7.24279, 7.32177, 7.40161, 7.48233, 7.56392, 7.64641, 7.70866, 7.75957, 7.81082, 7.8624, 7.91433, 7.9666,
         7.89954, 7.79586, 7.69354, 7.59257, 7.48282, 7.3369, 7.19383, 7.05354, 6.91599, 6.78113, 6.64215, 6.46927,
         6.30089, 6.13689, 5.97716, 5.82159, 5.6702, 5.52305, 5.37973, 5.2409, 5.10755, 4.97761, 4.84148, 4.70041,
         4.567, 4.44643, 4.32904, 4.28209, 4.22575, 4.30523, 4.49992, 4.78132, 5.72479, 6.67715, 8.15369, 9.55299,
         10.4363, 11.1473, 11.891, 12.28, 12.5972, 13.252, 13.755, 14.279, 14.7104, 15.1279, 15.161, 15.3039, 15.4646,
         15.4955, 15.5677, 15.7628, 15.9726, 16.1596, 16.3146, 16.3764, 16.3781, 16.2964, 16.0509, 15.7804, 15.5144,
         15.2529, 14.8624, 14.4808, 14.1247, 13.6724, 13.1695, 12.6291, 12.0929, 11.5755, 10.9582, 10.3641, 9.83749,
         9.23769, 8.66331, 8.08614, 7.54503, 7.00414, 6.50205, 6.00102, 5.52507, 5.05894, 4.63197, 4.16623, 3.74588,
         3.3712, 3.03461, 2.75449, 2.50261, 2.29916, 2.12066, 1.96186, 1.84575, 1.74552, 1.6802, 1.62616, 1.60282,
         1.57981, 1.55958, 1.5423, 1.52521, 1.51411, 1.51162, 1.51075, 1.52941, 1.54831, 1.57598, 1.61162, 1.64805,
         1.68597, 1.72502, 1.76498, 1.80831, 1.85286, 1.89785, 1.9439, 1.99032, 2.03743, 2.08566, 2.13556, 2.18696,
         2.23959, 2.29108, 2.34246, 2.395, 2.44694, 2.49184, 2.53756, 2.58412, 2.62164, 2.65944, 2.69777, 2.7328,
         2.76406, 2.79568, 2.82763, 2.85543, 2.8835, 2.91185, 2.93785, 2.96321, 2.98879, 3.00412, 3.00949, 3.01488,
         3.02025, 3.01552, 3.0108, 3.00609, 3.00771, 3.01087, 3.01404, 3.02803, 3.05031, 3.07276, 3.18222, 3.31193,
         3.34504, 3.70931, 4.55103, 4.98352, 5.73799, 6.33963, 6.68778, 7.08751, 7.45976, 7.83054, 8.17208, 8.43491,
         8.59801, 8.72817, 8.95085, 9.64287, 10.4103, 11.3558, 12.1082, 13.0428, 14.2048, 15.5096, 16.5866, 17.7435,
         18.4082, 18.9221, 19.2741, 19.3612, 19.3772, 19.2992, 19.1205, 19.152, 19.2381, 19.2212, 19.2414, 19.006,
         19.2072, 19.1687, 19.4731, 19.4147, 20.0161, 20.277, 19.8728, 19.8174, 20.0917, 20.1724, 20.5395, 21.7551,
         22.4191, 22.7504, 22.6231, 22.5184, 22.4773, 22.5009, 22.5821, 22.637, 22.6702, 22.6728, 22.6856, 22.7193,
         22.6869, 22.6005, 22.5881, 22.5302, 22.7228, 23.0754, 23.4356, 23.8105, 24.6061, 25.7847, 27.2723, 28.7102,
         29.7042, 30.1211, 30.2884, 30.0248, 29.3505, 27.6533, 26.1224, 25.2324, 24.0668, 23.8488, 24.0654, 25.1411,
         24.9505, 24.8039, 24.6544, 24.5504, 24.6233, 24.8271, 25.2792, 26.0415, 26.5884, 26.7566, 26.7201, 26.1002,
         25.3397, 24.6597, 24.5417, 24.3745, 24.3408, 24.458, 24.6422, 24.8047, 25.2181, 24.6396, 24.3034, 24.1655,
         24.1358, 23.3068, 22.5336, 22.2545, 22.2445, 22.0578, 22.0541, 21.9969, 21.9518, 21.861, 21.7588, 21.644,
         21.1982, 20.775, 20.7371, 20.633, 20.4475, 20.6008, 20.4904, 20.1154, 19.7472, 19.3843, 19.0279, 18.6918,
         18.4396, 18.1909, 17.9669, 17.7473, 17.5018, 17.2193, 16.9413, 16.6613, 16.3821, 16.1076, 15.8378, 15.5874,
         15.3511, 15.1183, 14.8891, 14.6696, 14.4573, 14.2481, 14.042, 13.7924, 13.5183, 13.2498, 12.9865, 12.7215,
         12.458, 12.1999, 11.9471, 11.6996, 11.4573, 11.2199, 10.9876, 10.7602, 10.5376, 10.3197, 10.1062, 10.0377,
         9.88852, 9.68467, 9.48502, 9.28951, 9.09781, 8.91018, 8.72657, 8.54657, 8.36737, 8.18884, 7.99777, 7.81051,
         7.6277, 7.44914, 7.27474, 7.10439, 6.93783, 6.77527, 6.61664, 6.46022, 6.30712, 6.15732, 6.01092, 5.868,
         5.72849, 5.5926, 5.45976, 5.32974, 5.31216, 5.21187, 5.11315, 5.01414, 4.91804, 4.82181, 4.73203, 4.63873,
         4.55164, 4.4644, 4.37721, 4.2957, 4.21143, 4.13268, 4.05398, 3.97798, 3.90211, 3.82884, 3.75581, 3.68532,
         3.61717, 3.54938, 3.4839, 3.41879, 3.35592, 3.29347, 3.23316, 3.17502, 10.9156, 10.91, 10.7061, 10.5038,
         10.3076, 10.2328, 14.0216, 13.8674, 13.6125, 13.3596, 13.114, 12.87, 12.6336, 12.4492, 14.0287, 13.9822,
         13.7332, 13.4966, 13.2534, 13.0155, 12.7836, 12.5517, 12.3207, 12.095, 11.8695, 11.6509, 11.4281, 11.215,
         10.9995, 10.7893, 10.5851, 10.3774, 10.1761, 9.98077, 9.78257, 9.59024, 9.40323, 9.21477, 9.03168, 8.85074,
         8.67187, 8.49817, 8.32667, 8.15726, 7.99029, 7.82814, 7.66573, 7.50828, 7.35307, 7.20036, 7.05221, 6.90405,
         6.76068, 6.61751, 6.47872, 6.34234, 6.20841, 6.07681, 5.94754, 5.8225, 5.69789, 5.57581, 5.45612, 5.34012,
         5.22503, 5.11207, 5.00153, 4.89327, 4.7873, 4.68345, 4.58187, 4.48239, 4.38515, 4.28897, 4.1958, 4.10372,
         4.01371, 3.9249, 3.83909, 3.75416, 3.67146, 3.59058, 3.51147, 3.43377, 3.35766, 3.28347, 3.21055, 3.13917,
         3.06922, 3.00079, 2.93402, 2.86851, 2.80465, 2.7418, 2.68056, 2.62047, 2.56197, 2.50455, 2.44803, 2.39314,
         2.33957, 2.27472, 2.21162, 2.15023, 2.09049, 2.03237, 1.97583, 1.92083, 1.86732, 1.81527, 1.76465, 1.71541,
         1.66751, 1.62094, 1.57563, 1.53158, 1.48874, 1.44708, 1.40656, 1.36717, 1.32886, 1.29162, 1.25541, 1.22019,
         1.18596, 1.15268, 1.12032, 1.08886, 1.05827, 1.02854, 0.999633, 0.971532, 0.944215, 0.917659, 0.891843,
         0.866748, 0.842354, 0.81864, 0.795588, 0.773181, 0.751399, 0.730226, 0.709644, 0.689638, 0.670191, 0.651287,
         0.632911, 0.615049, 0.597686, 0.580808, 0.564402, 0.548453, 0.546968, 3.59436, 3.51506, 3.42946, 3.34537,
         3.26281, 3.18177, 3.10227, 3.0243, 2.94786, 2.87294, 2.79954, 2.72765, 2.65725, 2.58835, 2.52092, 2.45496,
         2.39044, 2.32736, 2.26568, 2.20541, 2.1998]],
    'Rh':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.0037, 3.0039000000000002, 3.02463, 3.07355, 3.12326, 3.146, 3.1462, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.4118000000000004, 3.412, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682,
         3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.2198,
         23.22, 23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 4.70534, 4.90676, 5.09755, 5.28621, 5.4829, 5.71977, 5.94722, 6.09107, 6.18463, 6.24108, 6.25941, 6.22758,
         6.19669, 6.15184, 6.08461, 5.98379, 5.84548, 5.68807, 5.47854, 5.20762, 4.96732, 4.68621, 4.33155, 4.04527,
         3.73775, 3.46975, 3.30893, 3.23882, 3.22355, 3.22567, 3.25853, 3.33232, 3.45444, 3.64368, 3.9316, 4.23391,
         4.58169, 5.02262, 5.65139, 6.26532, 6.83131, 7.41151, 8.03415, 8.75145, 9.59027, 10.3563, 11.1122, 11.9314,
         12.9363, 13.9383, 14.7331, 15.4356, 16.0881, 16.7147, 17.3417, 18.007, 18.6141, 19.2168, 19.8821, 20.8097,
         21.3726, 21.6948, 21.8777, 21.9707, 21.9994, 21.9867, 21.9557, 21.8537, 21.7029, 21.5223, 21.3191, 21.098,
         20.8618, 20.6069, 20.3512, 20.105, 19.8643, 19.6264, 19.3919, 19.1643, 18.9469, 18.7094, 18.4583, 18.1987,
         17.923, 17.6442, 17.3783, 17.1048, 16.8137, 16.5569, 16.3114, 16.0806, 15.8707, 15.6696, 15.4605, 15.2679,
         15.0927, 14.9268, 14.7674, 14.6112, 14.4476, 14.2973, 14.1595, 14.0298, 13.9078, 13.7945, 13.6854, 13.5814,
         13.483, 13.3912, 13.3072, 13.234, 13.1881, 13.1431, 13.0837, 13.019, 12.9519, 12.8835, 12.8147, 12.7467,
         12.6841, 12.6161, 12.5434, 12.4684, 12.3917, 12.314, 12.2367, 12.1661, 12.0911, 12.0053, 11.9121, 11.8207,
         11.7185, 11.5944, 11.4492, 11.2864, 11.1086, 10.9182, 10.7022, 10.4528, 10.1665, 9.83651, 9.44174, 9.00533,
         8.51429, 7.94682, 7.24429, 6.40671, 5.36277, 4.2432, 3.04666, 2.21694, 1.85085, 1.69962, 1.73459, 2.1771,
         2.80549, 3.74771, 4.5928, 5.4372, 6.35355, 7.17439, 7.83964, 8.47001, 9.12111, 9.81859, 10.6382, 11.424,
         12.2421, 12.9902, 13.6668, 14.325, 14.9671, 15.6012, 16.2286, 16.863, 17.5299, 18.2364, 19.1154, 19.9685,
         20.6976, 21.3753, 22.041, 22.6711, 23.2599, 23.7926, 24.3221, 24.865, 25.4331, 26.0274, 26.6579, 27.3664,
         28.1409, 28.9159, 29.5498, 30.0802, 30.5409, 30.9912, 31.4645, 31.9351, 32.3631, 32.7591, 33.133, 33.4909,
         33.8377, 34.1717, 34.482, 34.7728, 35.0485, 35.3126, 35.566, 35.8083, 36.0367, 36.2535, 36.4614, 36.6651,
         36.8595, 37.0427, 37.2136, 37.3754, 37.5307, 37.6826, 37.8247, 37.9555, 38.0737, 38.1816, 38.2809, 38.3724,
         38.4569, 38.5347, 38.6064, 38.6722, 38.7326, 38.7876, 38.8376, 38.8829, 38.9244, 38.9621, 38.996, 39.0265,
         39.0538, 39.0779, 39.0993, 39.1187, 39.1373, 39.1557, 39.1686, 39.1742, 39.1737, 39.1687, 39.1597, 39.1468,
         39.1303, 39.1105, 39.0898, 39.0654, 39.0353, 38.9998, 38.9589, 38.9131, 38.8627, 38.8079, 38.7484, 38.6833,
         38.6169, 38.5457, 38.4669, 38.3815, 38.2888, 38.1884, 38.0799, 37.9622, 37.8346, 37.6958, 37.5444, 37.3788,
         37.197, 36.9962, 36.7732, 36.5237, 36.2419, 35.9202, 35.5474, 35.1074, 34.5743, 33.9039, 33.0094, 31.676,
         28.9958, 14.733, 14.7337, 28.1608, 30.7488, 30.8088, 24.6198, 24.6245, 32.0599, 34.0375, 35.125, 35.7872,
         35.9073, 32.7294, 32.7321, 36.5794, 37.8695, 38.7086, 39.3773, 39.9425, 40.4344, 40.8701, 41.26, 41.6115,
         41.9299, 42.2195, 42.4845, 42.7267, 42.9489, 43.1532, 43.3409, 43.5136, 43.6726, 43.819, 43.9538, 44.0778,
         44.1918, 44.2966, 44.3929, 44.4811, 44.5619, 44.6357, 44.703, 44.7644, 44.82, 44.8703, 44.9156, 44.9563,
         44.9926, 45.0248, 45.0532, 45.0779, 45.0993, 45.1175, 45.1328, 45.1452, 45.1551, 45.1625, 45.1676, 45.1705,
         45.1714, 45.1704, 45.1677, 45.1632, 45.1573, 45.1499, 45.1412, 45.1311, 45.1198, 45.1075, 45.0941, 45.0797,
         45.0644, 45.0484, 45.0316, 45.014, 44.9956, 44.9766, 44.9571, 44.937, 44.9163, 44.8952, 44.8737, 44.8517,
         44.8293, 44.8065, 44.7833, 44.7598, 44.736, 44.7118, 44.6873, 44.6625, 44.6374, 44.612, 44.5864, 44.5604,
         44.534, 44.5074, 44.4805, 44.4531, 44.4254, 44.3974, 44.3689, 44.3399, 44.3104, 44.2804, 44.2498, 44.2186,
         44.1866, 44.1539, 44.1202, 44.0856, 44.0499, 44.0129, 43.9746, 43.9347, 43.893, 43.8492, 43.8031, 43.7543,
         43.7023, 43.6466, 43.5864, 43.521, 43.4491, 43.3692, 43.2792, 43.1763, 43.0559, 42.9113, 42.7309, 42.4931,
         42.1488, 41.5423, 38.2348, 33.4904, 33.4905, 41.6618, 42.42, 42.8696, 43.1911, 43.4411, 43.6448, 43.8158,
         43.9624, 44.0899, 44.202, 44.3015, 44.3903, 44.4701, 44.5424, 44.6144, 44.6452],
        [1.17537, 1.24044, 1.30912, 1.3816, 1.4581, 1.53883, 1.62403, 1.71394, 1.80884, 1.90899, 2.00042, 2.09375,
         2.19144, 2.29369, 2.4007, 2.51271, 2.62995, 2.75265, 2.88108, 3.01551, 3.15235, 3.28289, 3.41884, 3.56042,
         3.70786, 3.86141, 4.02132, 4.18785, 4.36127, 4.52458, 4.66392, 4.80756, 4.95562, 5.10824, 5.26556, 5.42772,
         5.59488, 5.76719, 5.94481, 6.12789, 6.31661, 6.49918, 6.66358, 6.83213, 7.00494, 7.18213, 7.36379, 7.55005,
         7.74103, 7.93683, 8.09281, 8.23857, 8.38711, 8.53836, 8.69235, 8.8491, 9.00869, 9.17115, 9.28547, 9.35804,
         9.43118, 9.50487, 9.52837, 9.51188, 9.49541, 9.47898, 9.46258, 9.4131, 9.3574, 9.30204, 9.247, 9.19228,
         9.13789, 8.93847, 8.73686, 8.53981, 8.34719, 8.15893, 7.99834, 7.86634, 7.73651, 7.60883, 7.48325, 7.38742,
         7.30257, 7.21869, 7.23081, 7.28432, 7.33823, 7.51913, 7.77047, 8.0337, 8.49636, 8.98568, 9.50317, 9.96912,
         10.4563, 10.9673, 11.5033, 12.0655, 12.6551, 13.225, 13.7757, 14.3492, 14.9467, 15.5181, 15.8599, 16.2092,
         16.5663, 16.9311, 17.3041, 17.5205, 17.6548, 17.7902, 17.9266, 18.0641, 17.7449, 17.3938, 17.0496, 16.7123,
         16.3816, 16.0575, 15.6833, 15.2606, 14.8493, 14.449, 13.8376, 12.8289, 11.8937, 11.0267, 10.2228, 9.47763,
         8.78672, 8.11257, 7.46249, 6.86448, 6.31442, 5.8084, 5.34296, 4.91481, 4.52097, 4.1874, 3.87926, 3.5938,
         3.32935, 3.08435, 2.85738, 2.62759, 2.40272, 2.1971, 2.00908, 1.83715, 1.71, 1.59796, 1.49325, 1.43689,
         1.41034, 1.38428, 1.3916, 1.39953, 1.40751, 1.42143, 1.46169, 1.50309, 1.54566, 1.58944, 1.63446, 1.68696,
         1.75697, 1.82989, 1.90583, 1.98492, 2.06556, 2.14647, 2.23055, 2.31793, 2.40873, 2.50309, 2.60114, 2.70303,
         2.76147, 2.81991, 2.87959, 2.94053, 3.00276, 3.06631, 3.1312, 3.19331, 3.24985, 3.30739, 3.36595, 3.42555,
         3.4862, 3.54793, 3.61075, 3.65164, 3.6921, 3.73301, 3.77438, 3.78814, 3.7993, 3.81049, 3.82461, 3.84037,
         3.85619, 3.85408, 3.85196, 3.84985, 3.84774, 3.86052, 3.89716, 3.94893, 4.00866, 4.1111, 4.27135, 4.63441,
         5.34224, 6.31104, 8.05634, 9.54134, 11.1689, 12.7512, 14.4137, 15.8486, 17.0674, 17.9578, 18.7673, 19.4919,
         19.9322, 20.3823, 20.893, 21.4226, 21.9657, 22.4405, 22.8025, 23.116, 23.3204, 23.5265, 23.7329, 23.9349,
         24.1385, 24.344, 24.5677, 24.8033, 25.0412, 25.2814, 25.2284, 25.1592, 25.0903, 25.0159, 24.9115, 24.7988,
         24.6911, 24.6442, 24.6133, 24.5928, 24.5733, 24.5531, 24.5237, 24.3859, 24.0889, 23.6912, 23.2991, 22.9575,
         22.6541, 22.3598, 22.0278, 21.6724, 21.3222, 20.9779, 20.639, 20.3015, 19.9576, 19.6096, 19.2675, 18.9313,
         18.6011, 18.273, 17.9466, 17.6226, 17.3044, 16.9919, 16.685, 16.372, 16.0618, 15.7549, 15.4539, 15.1573,
         14.8649, 14.5653, 14.2689, 13.9758, 13.6886, 13.4074, 13.132, 12.8622, 12.598, 12.3392, 12.0857, 11.8374,
         11.5943, 11.3564, 11.1238, 10.8965, 10.6737, 10.4556, 10.242, 10.0325, 9.82741, 9.62653, 9.42979, 9.23574,
         9.04366, 8.84678, 8.65307, 8.46373, 8.27858, 8.0974, 7.92001, 7.74668, 7.57712, 7.41119, 7.24435, 7.07977,
         6.91787, 6.75946, 6.60472, 6.45372, 6.30611, 6.16183, 6.02076, 5.88555, 5.74787, 5.6129, 5.48022, 5.34989,
         5.2223, 5.09695, 4.97401, 4.85347, 4.73513, 4.61907, 4.50526, 4.39365, 4.28412, 4.17669, 4.07135, 3.96804,
         3.86678, 3.76736, 3.6699, 3.57434, 3.4806, 3.38869, 3.29847, 3.21011, 3.16103, 11.1098, 10.9941, 10.729,
         10.4714, 10.357, 14.2279, 14.0392, 13.699, 13.3669, 13.0426, 12.7262, 12.5687, 14.5451, 14.3814, 14.0524,
         13.7287, 13.4097, 13.0962, 12.7884, 12.486, 12.1887, 11.8969, 11.6099, 11.3291, 11.0535, 10.7828, 10.518,
         10.2582, 10.0037, 9.75445, 9.51041, 9.27164, 9.03778, 8.80902, 8.58531, 8.36644, 8.15253, 7.9433, 7.73887,
         7.53908, 7.344, 7.1533, 6.96707, 6.78518, 6.60763, 6.43436, 6.26516, 6.10007, 5.93892, 5.78179, 5.62841,
         5.47883, 5.33298, 5.1907, 5.05201, 4.91679, 4.7849, 4.65638, 4.53119, 4.4091, 4.29011, 4.17426, 4.06138,
         3.95138, 3.84422, 3.7397, 3.63812, 3.53903, 3.44265, 3.3487, 3.25735, 3.16834, 3.08161, 2.99718, 2.91501,
         2.83505, 2.75725, 2.68147, 2.60772, 2.53606, 2.46622, 2.39825, 2.33211, 2.26775, 2.20513, 2.1442, 2.08492,
         2.02724, 1.97112, 1.91653, 1.86342, 1.81175, 1.76149, 1.7126, 1.66504, 1.61878, 1.57378, 1.53001, 1.48744,
         1.44603, 1.40575, 1.36658, 1.32848, 1.29142, 1.25539, 1.22033, 1.18624, 1.15309, 1.12085, 1.08949, 1.05899,
         1.02933, 1.00048, 0.972425, 0.945141, 0.918606, 0.8928, 0.867702, 0.843293, 0.819554, 0.796466, 0.774012,
         0.752173, 0.730933, 0.710275, 0.690183, 0.670641, 0.651635, 0.633147, 0.615166, 0.597677, 0.580664, 0.564117,
         0.563583, 3.66324, 3.57592, 3.48779, 3.40131, 3.31648, 3.2333, 3.15178, 3.07189, 2.99363, 2.917, 2.84197,
         2.76854, 2.69669, 2.6264, 2.55767, 2.49046, 2.42477]],
    'Pd':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1732, 3.1734, 3.1737800000000003, 3.22511, 3.27727,
         3.3301999999999996, 3.3304, 3.38415, 3.43888, 3.4945, 3.55102, 3.6041999999999996, 3.6044, 3.60846, 3.66682,
         3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.3502, 24.3504, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 1.54728, 1.68191, 1.80849, 1.92773, 2.04259, 2.15374, 2.26086, 2.36175, 2.4539, 2.55068, 2.65431, 2.75947,
         2.86507, 2.96999, 3.06759, 3.15221, 3.25131, 3.36839, 3.4969, 3.63564, 3.78429, 3.94343, 4.11395, 4.29793,
         4.49925, 4.73652, 4.98501, 5.21655, 5.43655, 5.65494, 5.87331, 6.09288, 6.31409, 6.53706, 6.76072, 6.97936,
         7.19439, 7.42998, 7.69204, 7.97198, 8.27205, 8.59953, 8.95274, 9.31093, 9.67671, 10.06, 10.465, 10.8979,
         11.3689, 11.9115, 12.5064, 13.0495, 13.5961, 14.1718, 14.8297, 15.4959, 16.0761, 16.6625, 17.3141, 17.9868,
         18.5638, 19.1489, 19.8604, 20.6699, 21.3079, 21.7471, 22.0123, 22.1785, 22.274, 22.316, 22.3177, 22.2892,
         22.2542, 22.2132, 22.1152, 21.9737, 21.8074, 21.6238, 21.429, 21.2277, 21.0284, 20.8437, 20.6693, 20.4177,
         20.1303, 19.8166, 19.5046, 19.2058, 18.9069, 18.5989, 18.2778, 17.9801, 17.6774, 17.3804, 17.084, 16.805,
         16.5328, 16.285, 16.0365, 15.8119, 15.6137, 15.4329, 15.2666, 15.1153, 14.9777, 14.8474, 14.7271, 14.6188,
         14.5317, 14.4757, 14.3999, 14.3202, 14.2412, 14.164, 14.0904, 14.0224, 13.9533, 13.8854, 13.8199, 13.7575,
         13.6998, 13.6503, 13.6103, 13.5608, 13.5081, 13.4542, 13.4004, 13.3478, 13.3003, 13.2669, 13.2217, 13.1651,
         13.1029, 13.036, 12.9685, 12.9117, 12.8371, 12.7418, 12.6358, 12.5155, 12.3687, 12.1968, 11.9988, 11.7768,
         11.5255, 11.2344, 10.9093, 10.5229, 10.092, 9.63853, 9.11353, 8.54787, 7.92781, 7.19761, 6.26083, 5.13398,
         3.94907, 2.88486, 2.01484, 2.0777, 2.23414, 2.81952, 3.48331, 4.43753, 5.45854, 6.52308, 7.46246, 8.23898,
         8.99365, 9.70207, 10.3764, 11.0414, 11.7178, 12.5083, 13.2552, 13.9364, 14.6063, 15.2777, 15.9716, 16.6705,
         17.3791, 18.1157, 18.923, 19.8177, 20.6488, 21.4066, 22.1528, 22.96, 23.771, 24.4911, 25.1519, 25.7721,
         26.3405, 26.9051, 27.4954, 28.1418, 28.8295, 29.4775, 30.0909, 30.7639, 31.4196, 31.9759, 32.4762, 32.92,
         33.3473, 33.7918, 34.2082, 34.5821, 34.9332, 35.2658, 35.5817, 35.8817, 36.1664, 36.4372, 36.6961, 36.948,
         37.1902, 37.4192, 37.6386, 37.8511, 38.0578, 38.2687, 38.4705, 38.6446, 38.8044, 38.949, 39.0822, 39.2049,
         39.3183, 39.4232, 39.5202, 39.6098, 39.6924, 39.7681, 39.8375, 39.9012, 39.9596, 40.0131, 40.0619, 40.1062,
         40.1461, 40.1818, 40.2136, 40.2416, 40.2661, 40.2872, 40.305, 40.3184, 40.3284, 40.3352, 40.3387, 40.3394,
         40.3374, 40.3335, 40.3288, 40.3238, 40.3114, 40.2932, 40.2696, 40.2417, 40.2097, 40.1739, 40.1341, 40.0902,
         40.0435, 39.9975, 39.9435, 39.8833, 39.8174, 39.7458, 39.6676, 39.5825, 39.4902, 39.3898, 39.2808, 39.1622,
         39.0332, 38.8921, 38.7377, 38.568, 38.3809, 38.1732, 37.9412, 37.6801, 37.3833, 37.0413, 36.6409, 36.1614,
         35.5691, 34.8015, 33.7207, 31.8949, 16.3951, 16.3958, 20.253, 31.576, 32.5883, 26.0278, 26.032, 34.5501,
         35.9648, 36.8336, 37.3079, 34.7592, 34.7614, 36.7045, 38.6802, 39.5432, 40.2126, 40.7757, 41.2672, 41.7024,
         42.0935, 42.4474, 42.7695, 43.0634, 43.3333, 43.5813, 43.8097, 44.0202, 44.2144, 44.394, 44.5598, 44.713,
         44.8547, 44.9855, 45.1063, 45.2178, 45.3205, 45.415, 45.5019, 45.5817, 45.6548, 45.7217, 45.7826, 45.838,
         45.8881, 45.9333, 45.9741, 46.0104, 46.0427, 46.0712, 46.096, 46.1175, 46.1357, 46.1511, 46.1636, 46.1734,
         46.1808, 46.1858, 46.1886, 46.1893, 46.1881, 46.1851, 46.1803, 46.1741, 46.1662, 46.157, 46.1465, 46.1348,
         46.1219, 46.1079, 46.0929, 46.0769, 46.0601, 46.0426, 46.0242, 46.005, 45.9853, 45.9649, 45.9439, 45.9224,
         45.9004, 45.8779, 45.8549, 45.8315, 45.8078, 45.7836, 45.7591, 45.7342, 45.7091, 45.6835, 45.6577, 45.6316,
         45.6051, 45.5784, 45.5513, 45.5239, 45.4962, 45.4682, 45.4397, 45.4109, 45.3817, 45.3521, 45.3219, 45.2913,
         45.26, 45.2282, 45.1957, 45.1624, 45.1282, 45.0931, 45.057, 45.0196, 44.9809, 44.9407, 44.8988, 44.8548,
         44.8086, 44.7597, 44.7077, 44.652, 44.592, 44.5268, 44.4553, 44.3758, 44.2865, 44.1842, 44.0647, 43.9211,
         43.7419, 43.5051, 43.161, 42.5497, 34.6455, 34.6456, 37.4012, 42.737, 43.4626, 43.8977, 44.2104, 44.4542,
         44.6531, 44.8204, 44.9638, 45.0887, 45.1986, 45.2962, 45.3833, 45.4616],
        [1.15058, 1.2095, 1.27144, 1.33655, 1.40499, 1.47694, 1.54695, 1.61473, 1.68548, 1.75934, 1.83643, 1.91689,
         2.00089, 2.08948, 2.18421, 2.28325, 2.38677, 2.49498, 2.6081, 2.72635, 2.84283, 2.96107, 3.08423, 3.21251,
         3.34613, 3.48531, 3.61751, 3.73784, 3.86218, 3.99066, 4.12341, 4.26057, 4.4023, 4.54875, 4.69059, 4.83211,
         4.9779, 5.12808, 5.2828, 5.44219, 5.60638, 5.75266, 5.8894, 6.02939, 6.1727, 6.31942, 6.46962, 6.6234, 6.76795,
         6.90829, 7.05155, 7.19776, 7.34702, 7.49937, 7.65487, 7.80737, 7.94154, 8.07801, 8.21683, 8.35803, 8.50167,
         8.64777, 8.77838, 8.88318, 8.98924, 9.09656, 9.20517, 9.31507, 9.41939, 9.51027, 9.60203, 9.69467, 9.78821,
         9.88265, 9.97801, 10.0842, 10.2026, 10.3223, 10.4435, 10.5661, 10.6901, 10.8156, 10.9541, 11.1255, 11.2995,
         11.4763, 11.6559, 11.8382, 12.0234, 12.2116, 12.4026, 12.5966, 12.7937, 12.933, 13.0611, 13.1905, 13.3211,
         13.4531, 13.5863, 13.7209, 13.8568, 13.994, 14.1326, 14.2972, 14.4824, 14.67, 14.8601, 15.0526, 15.2476,
         15.4188, 15.5794, 15.7417, 15.9057, 16.0714, 16.2388, 16.4079, 16.5788, 16.6155, 16.635, 16.6546, 16.6743,
         16.6679, 16.5029, 16.3395, 16.1777, 16.0175, 15.7013, 15.384, 15.0731, 14.7684, 14.2592, 13.445, 12.6117,
         11.7998, 11.0402, 10.3295, 9.6645, 9.04232, 8.46021, 7.91556, 7.37038, 6.81841, 6.30776, 5.83537, 5.39834,
         4.99406, 4.62004, 4.27404, 3.95395, 3.57216, 3.20927, 2.88323, 2.59807, 2.37804, 2.17665, 1.99231, 1.82358,
         1.70309, 1.60183, 1.5163, 1.46311, 1.43291, 1.42282, 1.44663, 1.47786, 1.52489, 1.60388, 1.68697, 1.77342,
         1.86419, 1.95962, 2.0516, 2.14652, 2.24584, 2.34976, 2.45848, 2.54546, 2.61446, 2.68532, 2.75811, 2.83287,
         2.90965, 2.98517, 3.05947, 3.13562, 3.21367, 3.29366, 3.37565, 3.45967, 3.52937, 3.59298, 3.65772, 3.72364,
         3.79075, 3.85907, 3.92861, 3.99075, 4.0315, 4.07267, 4.11368, 4.15465, 4.19602, 4.23068, 4.23599, 4.2413,
         4.24663, 4.23541, 4.2207, 4.20605, 4.19311, 4.18333, 4.17356, 4.16914, 4.17285, 4.17656, 4.24602, 4.32807,
         4.41976, 4.59013, 4.76707, 4.9711, 5.20196, 5.81284, 6.76628, 8.08133, 9.8867, 11.9362, 13.5957, 15.3743,
         16.7201, 18.1839, 19.0507, 19.8902, 20.3621, 20.8451, 21.3314, 21.752, 22.1809, 22.6182, 23.0642, 23.4911,
         23.7729, 24.0582, 24.3469, 24.6391, 24.9323, 25.1937, 25.4578, 25.7247, 25.9943, 26.1282, 26.1468, 26.1654,
         26.184, 26.2026, 26.0913, 25.9169, 25.7437, 25.5717, 25.4008, 25.3047, 25.2167, 25.1291, 24.9808, 24.7535,
         24.5283, 24.3052, 23.9481, 23.553, 23.1645, 22.7823, 22.445, 22.0922, 21.7092, 21.3311, 20.9601, 20.5959,
         20.2361, 19.8809, 19.5302, 19.1859, 18.8475, 18.5151, 18.1814, 17.852, 17.5271, 17.2081, 16.8916, 16.5776,
         16.2403, 15.906, 15.5747, 15.2502, 14.9324, 14.6212, 14.3168, 14.0186, 13.7266, 13.4406, 13.1606, 12.8863,
         12.6181, 12.3559, 12.0994, 11.8483, 11.6026, 11.3619, 11.126, 10.8951, 10.669, 10.4475, 10.2304, 10.0175,
         9.80804, 9.60281, 9.40189, 9.20504, 9.01229, 8.82359, 8.63894, 8.4582, 8.28132, 8.10126, 7.92277, 7.74642,
         7.5742, 7.40586, 7.24131, 7.08028, 6.92281, 6.76886, 6.62217, 6.47064, 6.32088, 6.17393, 6.02983, 5.88782,
         5.7479, 5.61058, 5.47561, 5.34289, 5.21235, 5.08409, 4.95804, 4.83414, 4.7123, 4.59257, 4.47494, 4.35936,
         4.24569, 4.13399, 4.02424, 3.91646, 3.81048, 3.70628, 3.60401, 3.50349, 3.40473, 3.30764, 3.21438, 10.9859,
         10.9839, 10.7176, 10.4575, 10.2043, 14.0589, 13.724, 13.3964, 13.0763, 12.7644, 12.482, 14.0806, 14.0598,
         13.7658, 13.4765, 13.1884, 12.9036, 12.622, 12.3439, 12.069, 11.7972, 11.529, 11.2648, 11.0052, 10.7482,
         10.4957, 10.2475, 10.0034, 9.76322, 9.52728, 9.29577, 9.06847, 8.84528, 8.62641, 8.41177, 8.20146, 7.99517,
         7.79324, 7.59548, 7.40188, 7.21234, 7.02677, 6.84535, 6.66786, 6.49442, 6.32485, 6.159, 5.99712, 5.83885,
         5.68428, 5.53335, 5.38604, 5.24231, 5.10187, 4.96486, 4.83124, 4.70079, 4.57368, 4.44963, 4.32883, 4.21098,
         4.096, 3.98408, 3.87492, 3.76863, 3.66501, 3.56415, 3.46582, 3.37009, 3.27674, 3.18607, 3.09768, 3.01168,
         2.92782, 2.84634, 2.76702, 2.68981, 2.61468, 2.54158, 2.47046, 2.40127, 2.33397, 2.26851, 2.20485, 2.14293,
         2.08272, 2.02417, 1.96724, 1.91189, 1.85808, 1.80577, 1.75493, 1.7055, 1.65746, 1.61077, 1.56539, 1.52129,
         1.47844, 1.4368, 1.39634, 1.35703, 1.31884, 1.28174, 1.24569, 1.21067, 1.17666, 1.14361, 1.11152, 1.08035,
         1.05007, 1.02067, 0.992113, 0.96438, 0.937448, 0.911296, 0.8859, 0.86124, 0.837296, 0.814046, 0.791473,
         0.769556, 0.748277, 0.727617, 0.707561, 0.688089, 0.669186, 0.650836, 0.633022, 0.61573, 0.598944, 0.58265,
         0.56687, 3.61141, 3.61104, 3.52351, 3.43753, 3.35311, 3.27026, 3.18896, 3.10924, 3.03108, 2.95447, 2.87941,
         2.80589, 2.73391, 2.66344, 2.59448]],
    'Ag':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491, 0.907943, 0.922628,
         0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852,
         1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601,
         1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173,
         1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998,
         1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985,
         2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949, 2.53526,
         2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003, 2.8824899999999998,
         2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028, 3.351, 3.3512,
         3.38415, 3.43888, 3.4945, 3.5236, 3.5238, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8057,
         3.8059000000000003, 3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999,
         4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.513900000000003, 25.5141, 25.5529, 25.9662, 26.3861,
         26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225,
         30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -1.81922, -1.72868, -1.62587, -1.50683, -1.36942, -1.23794, -1.10469, -0.96578, -0.819277, -0.660791,
         -0.480585, -0.289667, -0.115068, 0.0544224, 0.222635, 0.391268, 0.561365, 0.733759, 0.909163, 1.08835, 1.27236,
         1.46409, 1.66062, 1.85709, 2.05539, 2.25726, 2.46333, 2.67431, 2.89086, 3.11409, 3.34752, 3.58781, 3.8294,
         4.07512, 4.32632, 4.584, 4.84891, 5.12192, 5.40394, 5.69619, 6.00013, 6.31814, 6.65965, 7.02554, 7.38425,
         7.743, 8.10773, 8.48132, 8.86597, 9.26387, 9.67727, 10.1095, 10.5644, 11.0481, 11.5723, 12.188, 12.7928,
         13.3763, 13.9659, 14.6042, 15.2716, 15.9027, 16.5022, 17.1136, 17.738, 18.3594, 18.9875, 19.6399, 20.4515,
         21.2684, 21.9898, 22.6998, 23.6518, 24.6488, 25.3798, 26.1748, 26.617, 26.6486, 26.4945, 26.2218, 25.8908,
         25.5212, 25.0855, 24.5909, 24.0706, 23.5321, 22.9483, 22.3497, 21.8285, 21.3696, 20.9391, 20.5186, 20.1081,
         19.7224, 19.3282, 18.9417, 18.5939, 18.2518, 17.9193, 17.6017, 17.3166, 17.03, 16.7386, 16.4735, 16.2253,
         15.9759, 15.7193, 15.5017, 15.3307, 15.1938, 15.096, 15.0271, 14.9482, 14.8947, 14.8627, 14.8146, 14.7762,
         14.7499, 14.7181, 14.6829, 14.6452, 14.6015, 14.5557, 14.509, 14.4622, 14.4159, 14.3705, 14.3266, 14.2852,
         14.2474, 14.2232, 14.2123, 14.1768, 14.1347, 14.0882, 14.0396, 13.9916, 13.9328, 13.8683, 13.8013, 13.7407,
         13.6733, 13.5744, 13.4568, 13.3227, 13.1727, 13.014, 12.8412, 12.6115, 12.333, 12.0432, 11.7364, 11.2984,
         10.7574, 10.1946, 9.55395, 8.84431, 8.04906, 7.15775, 6.09691, 4.70109, 3.3944, 2.22553, 1.5557, 1.60279,
         1.87385, 2.55047, 3.76452, 4.89407, 5.9464, 6.91953, 7.85548, 8.74241, 9.68918, 10.6742, 11.6983, 12.6891,
         13.5625, 14.3886, 15.2012, 16.0277, 16.8194, 17.6, 18.3874, 19.2024, 20.1066, 21.0903, 21.9318, 22.6965,
         23.4171, 24.108, 24.7766, 25.4254, 26.0594, 26.6836, 27.302, 27.9192, 28.5409, 29.1756, 29.8411, 30.6134,
         31.3386, 31.9433, 32.4292, 32.9405, 33.5328, 34.1735, 34.6808, 35.0357, 35.396, 35.8062, 36.3619, 36.8862,
         37.2638, 37.538, 37.7337, 37.9488, 38.202, 38.4445, 38.6732, 38.8941, 39.1139, 39.3218, 39.5138, 39.6909,
         39.8538, 40.0057, 40.1474, 40.2799, 40.4042, 40.5204, 40.6291, 40.7309, 40.8257, 40.9144, 40.9974, 41.0752,
         41.1485, 41.2173, 41.2821, 41.3431, 41.4009, 41.456, 41.5107, 41.5644, 41.6226, 41.6749, 41.71, 41.7373,
         41.758, 41.7731, 41.7832, 41.7887, 41.7901, 41.7888, 41.7847, 41.7746, 41.7586, 41.7374, 41.712, 41.6823,
         41.6482, 41.6103, 41.5679, 41.5225, 41.4755, 41.4228, 41.3651, 41.3027, 41.2356, 41.1637, 41.0868, 41.0046,
         40.9166, 40.8226, 40.7221, 40.6147, 40.4997, 40.3763, 40.2437, 40.1008, 39.9462, 39.7784, 39.5953, 39.3945,
         39.1727, 38.9257, 38.6479, 38.3318, 37.9662, 37.5349, 37.0115, 36.3499, 35.4564, 34.0841, 30.9467, 18.161,
         18.1618, 31.9201, 33.815, 33.8391, 27.6385, 27.6422, 34.6661, 36.6213, 37.6552, 38.2768, 38.076, 35.7476,
         35.7534, 39.3005, 40.3636, 41.1148, 41.7267, 42.2492, 42.7075, 43.1144, 43.4794, 43.8101, 44.1104, 44.384,
         44.6343, 44.8638, 45.0746, 45.2684, 45.4468, 45.611, 45.7624, 45.9017, 46.0301, 46.1482, 46.2569, 46.3569,
         46.4485, 46.5325, 46.6094, 46.6798, 46.7438, 46.802, 46.8547, 46.9023, 46.9451, 46.9834, 47.0175, 47.0476,
         47.0741, 47.0971, 47.1167, 47.1332, 47.1469, 47.1578, 47.1663, 47.1724, 47.1763, 47.1779, 47.1777, 47.1755,
         47.1718, 47.1663, 47.1593, 47.1509, 47.1413, 47.1303, 47.1181, 47.105, 47.091, 47.0758, 47.0597, 47.043,
         47.0254, 47.0071, 46.9881, 46.9685, 46.9483, 46.9276, 46.9064, 46.8847, 46.8626, 46.8401, 46.8171, 46.7938,
         46.7702, 46.7462, 46.7218, 46.6972, 46.6723, 46.647, 46.6215, 46.5957, 46.5696, 46.5431, 46.5164, 46.4894,
         46.462, 46.4342, 46.4061, 46.3776, 46.3486, 46.3192, 46.2892, 46.2587, 46.2276, 46.1957, 46.1632, 46.1297,
         46.0954, 46.0599, 46.0233, 45.9853, 45.9458, 45.9046, 45.8614, 45.8159, 45.7677, 45.7164, 45.6615, 45.6022,
         45.5377, 45.4668, 45.388, 45.2991, 45.1973, 45.078, 44.9342, 44.7539, 44.5141, 44.1612, 43.5138, 35.7672,
         35.7674, 41.4593, 43.8729, 44.546, 44.9598, 45.2599, 45.4949, 45.6872, 45.8492, 45.9888, 46.118, 46.1929],
        [1.18566, 1.22941, 1.27478, 1.32182, 1.38215, 1.45541, 1.53256, 1.61379, 1.69933, 1.78755, 1.87996, 1.97715,
         2.07936, 2.18686, 2.29992, 2.41824, 2.53197, 2.65105, 2.77572, 2.90627, 3.04294, 3.18605, 3.33589, 3.47681,
         3.60644, 3.74092, 3.8804, 4.02509, 4.17517, 4.29713, 4.41441, 4.53488, 4.65865, 4.78579, 4.90106, 4.98937,
         5.07926, 5.17077, 5.29055, 5.45984, 5.63455, 5.81485, 6.00091, 6.19293, 6.42631, 6.67287, 6.9289, 7.19476,
         7.47081, 7.6977, 7.91341, 8.13517, 8.36313, 8.5975, 8.81679, 8.8726, 8.92877, 8.9853, 9.04218, 9.09949,
         9.21817, 9.33838, 9.46018, 9.58355, 9.70853, 9.84446, 10.0304, 10.2199, 10.413, 10.6097, 10.8101, 10.9964,
         11.1767, 11.36, 11.5464, 11.7358, 11.9283, 12.1239, 12.28, 12.4307, 12.5832, 12.7376, 12.8939, 13.0521,
         13.2123, 13.3744, 13.5385, 13.7046, 13.8728, 14.0329, 14.1936, 14.3561, 14.5206, 14.6868, 14.855, 15.0252,
         15.1972, 15.3713, 15.5375, 15.7033, 15.8707, 16.04, 16.2111, 16.384, 16.5588, 16.7354, 16.9139, 17.0943,
         17.2766, 17.4609, 17.623, 17.7648, 17.9077, 18.0518, 18.1971, 18.3435, 18.4911, 18.64, 18.7903, 18.9419,
         19.0946, 19.2486, 19.3916, 19.3995, 19.4073, 19.4152, 19.4231, 19.3269, 19.1837, 19.0416, 18.9006, 18.7252,
         18.533, 18.3428, 18.1546, 17.9682, 17.5449, 17.0948, 16.6562, 16.2288, 15.3958, 14.3678, 13.3588, 11.8096,
         10.4401, 9.2294, 8.15907, 7.2129, 6.3532, 5.54204, 4.83444, 4.21718, 3.67872, 3.20904, 2.8708, 2.65218,
         2.45021, 2.26363, 2.09125, 1.95934, 1.8448, 1.73695, 1.68905, 1.64838, 1.62622, 1.61766, 1.64747, 1.67547,
         1.70176, 1.76394, 1.84444, 1.92861, 2.01662, 2.15015, 2.3206, 2.50385, 2.68031, 2.86721, 3.00223, 3.14361,
         3.29165, 3.39185, 3.49172, 3.59453, 3.68459, 3.75705, 3.82883, 3.89043, 3.95302, 4.01661, 4.08124, 4.1469,
         4.21361, 4.2814, 4.35028, 4.42028, 4.49139, 4.56365, 4.61085, 4.64794, 4.68533, 4.72301, 4.761, 4.79115,
         4.81758, 4.84415, 4.87086, 4.89747, 4.88211, 4.86682, 4.85156, 4.83621, 4.82077, 4.80537, 4.75691, 4.70031,
         4.6585, 4.63031, 4.56246, 4.47942, 4.45994, 4.52242, 4.58117, 4.72932, 4.94624, 5.19718, 5.58879, 6.30297,
         7.40671, 9.23062, 11.3138, 13.451, 15.5235, 17.4481, 18.9749, 20.2222, 21.0287, 21.8673, 22.5317, 23.2092,
         23.9071, 24.4322, 24.9566, 25.2194, 25.474, 25.7312, 25.9911, 26.2212, 26.4202, 26.6207, 26.8227, 27.0262,
         27.2313, 27.2392, 27.1301, 27.0214, 26.9132, 26.8054, 26.6944, 26.5824, 26.4708, 26.3597, 26.2491, 26.1389,
         26.0293, 25.92, 25.8113, 25.7029, 25.3172, 24.93, 24.605, 24.3539, 24.1054, 23.7375, 23.2537, 22.7837, 22.5089,
         22.2374, 21.9692, 21.4603, 20.927, 20.407, 19.9845, 19.6336, 19.2806, 18.919, 18.5649, 18.2156, 17.871,
         17.5164, 17.1648, 16.8161, 16.4746, 16.14, 15.8122, 15.4912, 15.1767, 14.8685, 14.5665, 14.2706, 13.9807,
         13.6972, 13.4198, 13.1483, 12.8825, 12.6221, 12.3669, 12.1169, 11.8719, 11.6319, 11.3967, 11.1634, 10.9306,
         10.685, 10.4425, 10.2055, 9.97405, 9.7478, 9.52656, 9.31021, 9.09884, 8.89242, 8.68657, 8.48395, 8.2847,
         8.09055, 7.90089, 7.71539, 7.53446, 7.35786, 7.18545, 7.01915, 6.85339, 6.69071, 6.53174, 6.37653, 6.22489,
         6.07701, 5.9323, 5.79105, 5.65313, 5.51848, 5.38707, 5.25884, 5.1337, 5.01163, 4.89256, 4.77642, 4.66311,
         4.55267, 4.44501, 4.33998, 4.23759, 4.13785, 4.04062, 3.94587, 3.85353, 3.76361, 3.67596, 3.59056, 3.50738,
         3.42637, 3.34743, 3.31742, 10.826, 10.6678, 10.4135, 10.1657, 10.0399, 13.7502, 13.5923, 13.2689, 12.9532,
         12.6444, 12.3435, 12.2496, 14.0388, 13.8258, 13.5182, 13.2155, 12.9155, 12.6208, 12.3301, 12.0439, 11.7626,
         11.4863, 11.2136, 10.946, 10.6833, 10.4251, 10.1717, 9.92324, 9.67948, 9.44039, 9.20601, 8.97641, 8.75149,
         8.53119, 8.31557, 8.10442, 7.89794, 7.69578, 7.49817, 7.30492, 7.11596, 6.93126, 6.75079, 6.57444, 6.40224,
         6.23409, 6.06975, 5.90945, 5.7529, 5.60018, 5.45094, 5.30552, 5.16361, 5.02523, 4.89031, 4.75869, 4.63026,
         4.5051, 4.38327, 4.26427, 4.14847, 4.03554, 3.92563, 3.81844, 3.71407, 3.61232, 3.51332, 3.41702, 3.32309,
         3.23157, 3.14262, 3.05603, 2.97157, 2.88946, 2.80955, 2.73178, 2.65609, 2.58245, 2.51078, 2.44106, 2.37322,
         2.30723, 2.24304, 2.18059, 2.11985, 2.06077, 2.00331, 1.94743, 1.89309, 1.84024, 1.78885, 1.73889, 1.6903,
         1.64307, 1.59714, 1.55249, 1.50908, 1.46688, 1.42586, 1.38599, 1.34723, 1.30955, 1.27293, 1.23733, 1.20274,
         1.16911, 1.13643, 1.10467, 1.0738, 1.04381, 1.01465, 0.986325, 0.958794, 0.932041, 0.906044, 0.88078, 0.856231,
         0.832377, 0.809197, 0.786673, 0.764788, 0.743521, 0.722858, 0.70278, 0.68327, 0.664314, 0.645895, 0.627998,
         0.610608, 0.593712, 0.577294, 0.562829, 3.56169, 3.5533, 3.46583, 3.38, 3.29582, 3.21329, 3.1324, 3.05314,
         2.9755, 2.89948, 2.82506, 2.75222]],
    'Cd':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.4051, 0.4053, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052,
         0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478,
         0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.5374, 3.5376, 3.55102, 3.60846, 3.66682, 3.72613, 3.7269, 3.7271, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.0179, 4.0181, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.7111, 26.711299999999998,
         26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225,
         30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 1.92132, 1.9587, 2.00347, 2.05887, 2.13188, 2.22995, 2.30955, 2.38386, 2.4575, 2.53262, 2.61077, 2.69354,
         2.78329, 2.88673, 2.9981, 3.10092, 3.20155, 3.30326, 3.4071, 3.5139, 3.62436, 3.73938, 3.85954, 3.98448,
         4.11523, 4.2528, 4.39831, 4.55323, 4.71968, 4.90458, 5.12536, 5.33801, 5.53753, 5.73522, 5.93432, 6.13673,
         6.34396, 6.55752, 6.77962, 7.01556, 7.25391, 7.496, 7.74478, 8.00243, 8.27088, 8.55256, 8.85083, 9.17288,
         9.53797, 9.95094, 10.317, 10.6651, 11.0074, 11.3503, 11.7005, 12.063, 12.4157, 12.7672, 13.1222, 13.4842,
         13.858, 14.2558, 14.6616, 15.0612, 15.4642, 15.8791, 16.3126, 16.7804, 17.3388, 17.851, 18.3398, 18.8475,
         19.4316, 20.0338, 20.5494, 21.0436, 21.5688, 22.2626, 22.7938, 23.1195, 23.3209, 23.453, 23.5384, 23.6002,
         23.6927, 23.7887, 23.7072, 23.5298, 23.2935, 23.0109, 22.6816, 22.2585, 21.929, 21.6526, 21.4053, 21.1833,
         21.0226, 20.8329, 20.5504, 20.1828, 19.8503, 19.5098, 19.1967, 18.9087, 18.6126, 18.3385, 18.0729, 17.7711,
         17.5124, 17.2849, 17.0891, 16.921, 16.791, 16.6867, 16.575, 16.4641, 16.3579, 16.2576, 16.1642, 16.0787,
         16.003, 15.9445, 15.8913, 15.8354, 15.7794, 15.7269, 15.679, 15.6375, 15.6054, 15.5936, 15.5913, 15.5744,
         15.5467, 15.5156, 15.4826, 15.4491, 15.4169, 15.3884, 15.3902, 15.3677, 15.3205, 15.2616, 15.192, 15.1123,
         15.0227, 14.9234, 14.8146, 14.699, 14.5684, 14.4194, 14.2517, 14.0649, 13.857, 13.6247, 13.365, 13.0786,
         12.7606, 12.4025, 11.993, 11.498, 10.9667, 10.3913, 9.74172, 8.98721, 8.68686, 8.62236, 7.79045, 6.36909,
         5.18791, 4.09315, 3.05345, 2.10524, 1.27547, 0.664412, 0.351553, 0.60195, 2.21338, 4.9157, 7.88153, 10.146,
         11.8344, 13.4846, 14.934, 16.0908, 17.0042, 17.7134, 18.1179, 18.6004, 19.2047, 19.8241, 20.456, 21.1062,
         21.7794, 22.4329, 23.0654, 23.694, 24.3233, 24.9584, 25.6242, 26.3133, 26.9713, 27.6117, 28.2499, 28.8935,
         29.5995, 30.2999, 30.9503, 31.5858, 32.2274, 32.9195, 33.6579, 34.2929, 34.8168, 35.2937, 35.7447, 36.1738,
         36.5842, 36.9847, 37.3674, 37.7296, 38.0705, 38.397, 38.7153, 39.0343, 39.3302, 39.5983, 39.8394, 40.0597,
         40.2627, 40.4507, 40.6249, 40.7866, 40.9366, 41.0758, 41.2048, 41.3242, 41.4343, 41.536, 41.6305, 41.718,
         41.7984, 41.872, 41.939, 41.9995, 42.0533, 42.1, 42.1378, 42.1666, 42.1947, 42.2253, 42.2571, 42.2882, 42.3185,
         42.3476, 42.3759, 42.4036, 42.4379, 42.4701, 42.4943, 42.5113, 42.5211, 42.5262, 42.5272, 42.5247, 42.5191,
         42.5084, 42.5055, 42.501, 42.4867, 42.4672, 42.4425, 42.4127, 42.3777, 42.3374, 42.2914, 42.2393, 42.1813,
         42.1168, 42.0453, 41.9667, 41.8803, 41.7852, 41.6811, 41.567, 41.442, 41.3048, 41.154, 40.988, 40.8048,
         40.6017, 40.3752, 40.1214, 39.8348, 39.5076, 39.1292, 38.6842, 38.1488, 37.4821, 36.6063, 35.3409, 33.0285,
         17.0228, 17.0232, 29.8592, 33.8701, 34.7193, 30.673, 28.0714, 28.0766, 36.571, 37.941, 38.7346, 39.2115,
         35.8107, 35.8164, 39.2057, 40.7582, 41.6577, 42.3572, 42.9426, 43.4487, 43.8935, 44.2898, 44.6459, 44.9676,
         45.2595, 45.5254, 45.7682, 45.9904, 46.1939, 46.3807, 46.5522, 46.7098, 46.8545, 46.9874, 47.1097, 47.2218,
         47.3246, 47.4188, 47.5049, 47.5836, 47.6555, 47.7208, 47.78, 47.8335, 47.8819, 47.9252, 47.964, 47.9985,
         48.0288, 48.0553, 48.0783, 48.0981, 48.1148, 48.1284, 48.1392, 48.1476, 48.1536, 48.1573, 48.1589, 48.1585,
         48.1561, 48.1523, 48.1468, 48.1397, 48.131, 48.1213, 48.1104, 48.098, 48.0847, 48.0707, 48.0555, 48.0392,
         48.0222, 48.0045, 47.9861, 47.9671, 47.9474, 47.9271, 47.9063, 47.8851, 47.8633, 47.8411, 47.8185, 47.7955,
         47.7721, 47.7483, 47.7242, 47.6998, 47.6751, 47.65, 47.6247, 47.599, 47.5731, 47.5468, 47.5202, 47.4933,
         47.4661, 47.4384, 47.4105, 47.3821, 47.3533, 47.324, 47.2942, 47.2639, 47.233, 47.2014, 47.1691, 47.136,
         47.102, 47.067, 47.0308, 46.9934, 46.9546, 46.9142, 46.872, 46.8276, 46.7808, 46.7313, 46.6784, 46.6217,
         46.5604, 46.4936, 46.42, 46.338, 46.2453, 46.1387, 46.0133, 45.8615, 45.6697, 45.4117, 45.024, 44.2697,
         36.4239, 36.424, 43.2295, 44.9251, 45.5586, 45.9614, 46.2575, 46.4909, 46.6827, 46.8446],
        [0.400039, 0.418419, 0.437644, 0.457752, 0.493615, 0.536851, 0.592578, 0.663282, 0.74242, 0.861255, 0.993746,
         1.04408, 1.09696, 1.15252, 1.2109, 1.27223, 1.317, 1.35518, 1.39447, 1.4349, 1.46675, 1.49503, 1.52386,
         1.55324, 1.58319, 1.61386, 1.65189, 1.69082, 1.73068, 1.77146, 1.81322, 1.85595, 1.89969, 1.94447, 1.9903,
         2.0372, 2.08522, 2.13437, 2.18467, 2.23616, 2.30335, 2.383, 2.46541, 2.55067, 2.63888, 2.73013, 2.82455,
         2.93634, 3.06457, 3.19841, 3.33808, 3.48385, 3.63599, 3.79478, 3.9605, 4.10362, 4.24965, 4.40088, 4.55749,
         4.71967, 4.88762, 5.06155, 5.21645, 5.37271, 5.53366, 5.69942, 5.87016, 6.046, 6.22712, 6.41366, 6.60579,
         6.80368, 6.97608, 7.13371, 7.29491, 7.45974, 7.6283, 7.80067, 7.97693, 8.15718, 8.3415, 8.5037, 8.66572,
         8.83082, 8.99907, 9.17052, 9.34524, 9.52329, 9.70474, 9.88864, 10.0757, 10.2662, 10.4604, 10.6583, 10.8599,
         11.0653, 11.2746, 11.4757, 11.6323, 11.791, 11.9518, 12.1149, 12.2802, 12.4478, 12.6176, 12.7898, 12.9599,
         13.1213, 13.2847, 13.4501, 13.6176, 13.7872, 13.9589, 14.1327, 14.3087, 14.4869, 14.5893, 14.648, 14.7069,
         14.766, 14.8254, 14.885, 14.9281, 14.9596, 14.9911, 15.0227, 15.0544, 15.0861, 15.1179, 15.1063, 15.0932,
         15.0801, 15.0671, 15.054, 15.041, 14.9809, 14.8342, 14.689, 14.5451, 14.4027, 14.0815, 13.7289, 13.3852,
         13.0501, 12.6636, 11.8623, 11.1116, 10.4085, 9.74983, 9.13287, 8.55495, 8.01359, 7.33221, 6.62555, 5.98701,
         5.40999, 4.88859, 4.41745, 4.05148, 3.82757, 3.61604, 3.4162, 3.22739, 3.04903, 2.74069, 2.45221, 2.22983,
         2.09547, 1.97671, 1.93078, 1.88592, 1.85429, 1.85193, 1.84957, 1.8725, 1.96692, 2.07018, 2.1871, 2.31063,
         2.44113, 2.53742, 2.62155, 2.70847, 2.79827, 2.89105, 2.98691, 3.08594, 3.18826, 3.29397, 3.37628, 3.45963,
         3.54503, 3.63255, 3.72222, 3.8141, 3.90825, 4.00473, 4.06298, 4.11172, 4.16105, 4.21097, 4.26148, 4.3126,
         4.36434, 4.4167, 4.45524, 4.45725, 4.45925, 4.46126, 4.46327, 4.46528, 4.46729, 4.46931, 4.47132, 4.47314,
         4.46266, 4.45221, 4.44178, 4.43137, 4.42099, 4.41063, 4.4044, 4.40091, 4.39743, 4.39396, 4.39048, 4.39609,
         4.47478, 4.55488, 4.63641, 4.7194, 4.77842, 4.32288, 4.52168, 5.34514, 6.31858, 7.46926, 8.82954, 10.4375,
         12.3383, 14.57, 17.1909, 20.2831, 23.6835, 26.0154, 26.9206, 27.0075, 27.0947, 27.1821, 26.8391, 26.4624,
         26.091, 25.7248, 25.5428, 25.6342, 25.7259, 25.8179, 25.9103, 26.0029, 26.0606, 26.0875, 26.1144, 26.1413,
         26.1683, 26.1952, 26.2222, 26.2, 26.1349, 26.07, 26.0052, 25.9406, 25.8762, 25.7016, 25.5118, 25.3234, 25.1364,
         24.9507, 24.6144, 24.1751, 23.7519, 23.3468, 22.9583, 22.5762, 22.2003, 21.8306, 21.4466, 21.0642, 20.6841,
         20.3109, 19.9399, 19.5709, 19.167, 18.7666, 18.3698, 17.9813, 17.6012, 17.2292, 16.8649, 16.5083, 16.1592,
         15.8176, 15.4831, 15.1557, 14.8357, 14.5231, 14.2179, 13.9188, 13.626, 13.3394, 13.0589, 12.7843, 12.5155,
         12.2524, 11.9969, 11.7499, 11.5219, 11.3002, 11.0828, 10.8697, 10.6606, 10.4554, 10.2544, 10.0571, 9.86351,
         9.66015, 9.4564, 9.2535, 9.05474, 8.86031, 8.67031, 8.48435, 8.30235, 8.12413, 7.95651, 7.77577, 7.59693,
         7.42037, 7.24551, 7.07294, 6.90212, 6.73347, 6.56637, 6.40135, 6.23853, 6.07751, 5.91851, 5.76148, 5.60617,
         5.45285, 5.30151, 5.15212, 5.00438, 4.85853, 4.71465, 4.57268, 4.43238, 4.29386, 4.15725, 4.02248, 3.88941,
         3.75791, 3.62831, 3.50057, 3.37448, 3.24981, 3.12696, 3.00594, 2.88655, 2.79895, 11.0389, 10.9769, 10.7176,
         10.4648, 10.218, 10.2148, 14.0187, 13.668, 13.3205, 12.9812, 12.6508, 12.425, 14.4626, 14.3611, 14.0258,
         13.6966, 13.373, 13.0563, 12.7442, 12.4379, 12.1378, 11.843, 11.5539, 11.2705, 10.9927, 10.7205, 10.4537,
         10.1926, 9.93705, 9.68676, 9.44205, 9.20244, 8.96818, 8.73917, 8.51506, 8.29613, 8.08211, 7.87307, 7.66898,
         7.46934, 7.27449, 7.08413, 6.89861, 6.71713, 6.54022, 6.36756, 6.19912, 6.03463, 5.8743, 5.71804, 5.56564,
         5.41673, 5.27177, 5.13036, 4.99278, 4.85838, 4.72739, 4.59991, 4.47548, 4.35458, 4.23661, 4.12167, 4.00959,
         3.90067, 3.79455, 3.691, 3.59015, 3.49233, 3.39687, 3.30356, 3.21306, 3.12496, 3.03921, 2.95573, 2.87448,
         2.7954, 2.71844, 2.64354, 2.57066, 2.49973, 2.43072, 2.36357, 2.29823, 2.23466, 2.17281, 2.11264, 2.0541,
         1.99716, 1.94176, 1.88787, 1.83545, 1.78447, 1.73487, 1.68663, 1.63971, 1.59407, 1.54968, 1.50651, 1.46452,
         1.42369, 1.38397, 1.34535, 1.30778, 1.27125, 1.23572, 1.20117, 1.16757, 1.13489, 1.10311, 1.07221, 1.04216,
         1.01293, 0.984506, 0.956865, 0.929983, 0.903842, 0.878419, 0.853696, 0.829651, 0.806268, 0.783528, 0.761412,
         0.739903, 0.718984, 0.69864, 0.678853, 0.65961, 0.640893, 0.622689, 0.604983, 0.587761, 0.574954, 3.65393,
         3.63215, 3.54155, 3.45277, 3.36578, 3.28058, 3.19715, 3.11548, 3.03556]],
    'In':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052,
         0.44380000000000003, 0.444, 0.448186, 0.455435, 0.46280200000000005, 0.47028699999999996, 0.477894,
         0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065,
         0.5701390000000001, 0.579361, 0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755,
         0.637908, 0.648226, 0.658711, 0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008,
         0.748928, 0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502,
         0.865274, 0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586,
         1.03229, 1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155,
         1.25147, 1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.73, 3.7302, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.9379, 3.9381, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646,
         4.2374, 4.2376000000000005, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003,
         4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 27.939799999999998, 27.94, 28.135099999999998, 28.5902, 29.052599999999998,
         29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -1.51987, -1.54706, -1.58334, -1.64752, -1.74136, -1.83332, -1.89419, -1.93995, -1.96255, -1.94319,
         -1.90687, -1.8974, -1.89168, -1.88415, -1.87242, -1.85346, -1.82528, -1.78472, -1.71506, -1.62506, -1.54115,
         -1.45722, -1.36657, -1.26484, -1.14874, -1.01435, -0.82735, -0.617621, -0.436164, -0.250289, -0.055007,
         0.157037, 0.408463, 0.668244, 0.903882, 1.14556, 1.39512, 1.65814, 1.93838, 2.22861, 2.52847, 2.84821, 3.19594,
         3.59613, 4.07115, 4.51316, 4.87293, 5.20917, 5.47784, 5.71312, 6.01602, 6.39303, 6.96027, 7.55437, 7.89693,
         8.099, 8.25154, 8.51743, 8.6878, 8.85727, 9.27382, 9.89802, 10.8442, 12.0436, 13.2334, 14.4128, 15.9636,
         17.6504, 18.9234, 20.0231, 21.04, 22.0277, 23.0747, 24.3349, 25.5304, 26.2006, 26.6544, 26.9621, 27.163,
         27.2812, 27.3359, 27.3408, 27.3287, 27.2772, 27.1511, 26.9928, 26.8092, 26.6063, 26.3905, 26.1664, 25.9399,
         25.7178, 25.5129, 25.3659, 25.2858, 25.0639, 24.6395, 24.15, 23.603, 23.0693, 22.578, 22.0825, 21.593, 21.129,
         20.7009, 20.3192, 19.9783, 19.664, 19.3783, 19.1071, 18.8516, 18.6169, 18.3966, 18.1872, 17.9882, 17.8035,
         17.6302, 17.4678, 17.3171, 17.1771, 17.0445, 16.9205, 16.8059, 16.7019, 16.6106, 16.5397, 16.4849, 16.4229,
         16.3626, 16.3079, 16.2606, 16.2224, 16.2096, 16.2092, 16.1923, 16.1785, 16.1693, 16.1677, 16.1855, 16.2257,
         16.2643, 16.2791, 16.2866, 16.2914, 16.2977, 16.3144, 16.3509, 16.3676, 16.3456, 16.3086, 16.258, 16.1986,
         16.129, 16.0338, 15.9148, 15.7748, 15.6134, 15.4305, 15.2236, 14.9827, 14.7037, 14.3835, 14.0088, 13.5727,
         13.0832, 12.5374, 11.8846, 11.1169, 10.2736, 9.47596, 10.6734, 10.5639, 6.68163, 3.96074, 2.52924, 2.21022,
         1.97589, 2.71371, 4.8266, 6.67054, 8.3, 9.80035, 11.4742, 12.97, 14.3294, 15.6461, 16.6175, 17.4461, 18.123,
         18.6809, 19.2051, 19.7052, 20.2164, 20.6751, 20.6129, 20.1002, 19.8932, 20.3338, 21.4247, 23.184, 25.0064,
         26.2436, 27.365, 28.385, 29.1658, 29.7932, 30.1958, 30.5723, 31.1509, 31.7727, 32.5186, 33.2978, 33.9336,
         34.5536, 35.2118, 35.8707, 36.4108, 36.9053, 37.3634, 37.7949, 38.2053, 38.6003, 38.9878, 39.3699, 39.7347,
         40.0516, 40.341, 40.6079, 40.8556, 41.086, 41.3008, 41.5014, 41.6887, 41.8637, 42.0276, 42.181, 42.3243,
         42.4582, 42.5833, 42.7002, 42.8094, 42.9113, 43.0062, 43.0945, 43.1765, 43.2525, 43.3231, 43.3883, 43.4485,
         43.5038, 43.5544, 43.6006, 43.6427, 43.6811, 43.716, 43.7477, 43.7788, 43.8079, 43.8295, 43.846, 43.857,
         43.8638, 43.8668, 43.8662, 43.862, 43.8541, 43.8453, 43.8364, 43.8207, 43.801, 43.7774, 43.7497, 43.7185,
         43.6831, 43.6436, 43.6001, 43.5521, 43.4998, 43.4429, 43.3812, 43.3143, 43.242, 43.1641, 43.08, 42.9892,
         42.8913, 42.7855, 42.671, 42.5469, 42.4121, 42.2651, 42.1043, 41.9276, 41.7323, 41.515, 41.2712, 40.9951,
         40.6781, 40.3084, 39.8676, 39.3256, 38.6274, 37.6541, 36.0539, 29.5173, 21.0532, 21.055, 35.5004, 36.729,
         36.4537, 30.3105, 30.316, 37.5132, 39.2653, 40.1923, 40.7033, 39.079, 37.9036, 37.9089, 41.9828, 42.9091,
         43.6018, 44.1731, 44.6635, 45.0929, 45.4743, 45.8161, 46.1245, 46.404, 46.6582, 46.8902, 47.1024, 47.2967,
         47.4747, 47.638, 47.7881, 47.9259, 48.0522, 48.1683, 48.2747, 48.3723, 48.4615, 48.5431, 48.6177, 48.6855,
         48.7471, 48.803, 48.8535, 48.8989, 48.9397, 48.9759, 49.008, 49.0362, 49.0609, 49.0822, 49.1003, 49.1154,
         49.1277, 49.1374, 49.1446, 49.1497, 49.1525, 49.1532, 49.1522, 49.1493, 49.1447, 49.1386, 49.1312, 49.1224,
         49.1124, 49.1009, 49.0885, 49.0753, 49.061, 49.0458, 49.0298, 49.013, 48.9955, 48.9773, 48.9585, 48.9391,
         48.9191, 48.8987, 48.8777, 48.8563, 48.8345, 48.8123, 48.7898, 48.7668, 48.7436, 48.72, 48.6961, 48.6719,
         48.6474, 48.6226, 48.5976, 48.5722, 48.5465, 48.5206, 48.4943, 48.4677, 48.4408, 48.4135, 48.3858, 48.3577,
         48.3292, 48.3002, 48.2706, 48.2405, 48.2097, 48.1782, 48.1459, 48.1128, 48.0786, 48.0434, 48.0069, 47.9691,
         47.9297, 47.8884, 47.8451, 47.7994, 47.7509, 47.6992, 47.6437, 47.5835, 47.5179, 47.4455, 47.3646, 47.273,
         47.1672, 47.0422, 46.8897, 46.6953, 46.4295, 46.0168, 45.1261, 37.8125, 37.8127, 44.9797, 46.1704, 46.7166,
         47.0865, 47.3215],
        [2.16244, 2.07002, 1.98155, 1.89686, 1.81579, 1.72844, 1.54985, 1.35731, 0.993252, 0.742018, 0.65818, 0.612667,
         0.573696, 0.537374, 0.509773, 0.491373, 0.473638, 0.456589, 0.44037, 0.424728, 0.414034, 0.404843, 0.396113,
         0.388198, 0.38598, 0.387391, 0.396152, 0.410419, 0.431951, 0.455912, 0.489651, 0.691634, 1.08283, 1.49226,
         1.78423, 1.92144, 1.94167, 1.95766, 1.966, 1.95605, 1.92465, 1.90352, 1.88557, 1.82853, 1.76749, 1.75409,
         1.74106, 1.72812, 1.73515, 1.77156, 1.80874, 1.86471, 1.95371, 2.04696, 2.14466, 2.25579, 2.37578, 2.50216,
         2.63526, 2.76576, 2.93943, 3.13348, 3.34034, 3.50223, 3.66764, 3.84087, 4.06669, 4.32792, 4.56695, 4.75454,
         4.94983, 5.16036, 5.42475, 5.70269, 5.99488, 6.30145, 6.62114, 6.87184, 7.13204, 7.40209, 7.68236, 7.97325,
         8.27515, 8.58848, 8.91368, 9.25118, 9.57113, 9.8802, 10.1993, 10.5286, 10.8686, 11.2196, 11.5819, 11.9559,
         12.2735, 12.5863, 12.9071, 13.2361, 13.5734, 13.9094, 14.1975, 14.4915, 14.7916, 15.098, 15.4106, 15.7207,
         16.0272, 16.3396, 16.6582, 16.9829, 17.314, 17.5669, 17.7093, 17.8528, 17.9975, 18.1434, 18.3801, 18.7146,
         19.0551, 19.4018, 19.4426, 19.4471, 19.4661, 19.781, 20.1009, 20.4261, 21.0189, 21.7901, 22.5897, 23.4186,
         24.0119, 24.3235, 24.6392, 24.9589, 24.661, 24.09, 23.5323, 22.9874, 22.4552, 21.9352, 21.4124, 20.0346,
         18.7454, 17.5392, 16.4105, 15.3546, 14.3665, 13.4421, 12.5771, 11.7675, 10.9499, 10.1891, 9.48115, 8.82241,
         8.20945, 7.63905, 7.1083, 6.61442, 6.15485, 5.72721, 5.32929, 4.7905, 4.1082, 3.5231, 3.02132, 2.63553,
         2.37563, 2.15004, 1.97681, 1.86588, 1.81419, 1.81256, 1.84702, 1.888, 1.94576, 2.00529, 2.06792, 2.14723,
         2.22959, 2.31511, 2.40391, 2.50249, 2.60565, 2.71306, 2.8249, 2.94135, 3.05935, 3.18022, 3.30587, 3.43648,
         3.57226, 3.7134, 3.86012, 3.98186, 4.10237, 4.22653, 4.35445, 4.48624, 4.62201, 4.7619, 4.872, 4.9795, 5.08938,
         5.20168, 5.31645, 5.43376, 5.53876, 5.59146, 5.64465, 5.69836, 5.75257, 5.80731, 5.86256, 5.88879, 5.8707,
         5.85266, 5.83467, 5.81675, 5.79887, 5.76451, 5.7234, 5.68258, 5.64204, 5.6018, 5.56184, 5.51516, 5.46471,
         5.41473, 5.3652, 5.31613, 5.2797, 5.27535, 5.27101, 5.26666, 5.31364, 5.41613, 5.52059, 5.56157, 3.58563,
         4.49251, 6.60583, 9.71329, 12.5187, 15.3206, 18.7498, 20.8571, 22.3283, 23.2112, 24.1291, 24.7386, 24.9583,
         25.18, 25.0704, 24.8845, 24.6999, 24.5167, 24.3966, 24.3595, 24.3223, 24.2853, 24.1094, 23.7562, 23.9302,
         25.1601, 26.4532, 27.8128, 28.8952, 28.6033, 28.3143, 28.0282, 27.5828, 27.0982, 26.6222, 26.2179, 26.1563,
         26.0949, 26.0337, 25.9725, 25.6803, 25.3864, 25.0957, 24.8084, 24.4025, 23.9705, 23.546, 23.1322, 22.7266,
         22.3289, 21.9382, 21.5485, 21.1599, 20.7214, 20.2914, 19.8702, 19.4578, 19.0539, 18.6584, 18.2712, 17.8919,
         17.5204, 17.1569, 16.8008, 16.4521, 16.1105, 15.776, 15.4486, 15.1281, 14.8142, 14.5067, 14.2056, 13.9107,
         13.6219, 13.3392, 13.0623, 12.7911, 12.5254, 12.265, 12.01, 11.7604, 11.5159, 11.2766, 11.0421, 10.8125,
         10.5876, 10.3619, 10.1389, 9.91898, 9.70402, 9.49377, 9.28813, 9.08683, 8.8899, 8.69729, 8.51216, 8.32445,
         8.13978, 7.95855, 7.7805, 7.60617, 7.43484, 7.26657, 7.10168, 6.93958, 6.78093, 6.62507, 6.47223, 6.32231,
         6.17519, 6.0309, 5.88943, 5.75061, 5.61447, 5.481, 5.35007, 5.2217, 5.09578, 4.97234, 4.85124, 4.73253,
         4.61615, 4.50194, 4.39002, 4.28029, 4.1727, 4.06717, 3.96369, 3.8623, 3.76282, 3.66533, 3.56968, 3.47592,
         3.38402, 3.37816, 10.6791, 10.4378, 10.185, 9.93807, 9.83012, 13.5004, 13.3113, 12.9752, 12.6475, 12.3288,
         12.0185, 12.0143, 13.8395, 13.5217, 13.2059, 12.8955, 12.5906, 12.291, 11.9967, 11.7078, 11.4243, 11.1464,
         10.8737, 10.6064, 10.3445, 10.0879, 9.83652, 9.59033, 9.34942, 9.11368, 8.88285, 8.65718, 8.43646, 8.22062,
         8.00956, 7.8033, 7.6018, 7.40489, 7.21256, 7.0247, 6.8412, 6.66207, 6.48721, 6.31649, 6.14986, 5.98724, 5.8287,
         5.67408, 5.52315, 5.37591, 5.23241, 5.09244, 4.95604, 4.82305, 4.69338, 4.56687, 4.44387, 4.32375, 4.20679,
         4.09286, 3.98194, 3.8739, 3.76859, 3.66588, 3.56601, 3.46895, 3.37423, 3.28199, 3.19219, 3.10476, 3.01965,
         2.9368, 2.85615, 2.77765, 2.70125, 2.62689, 2.55452, 2.4841, 2.41557, 2.34889, 2.284, 2.22087, 2.15945,
         2.09969, 2.04155, 1.98498, 1.92996, 1.87643, 1.82436, 1.77371, 1.72444, 1.67652, 1.6299, 1.58457, 1.54047,
         1.49758, 1.45587, 1.4153, 1.37585, 1.33747, 1.30016, 1.26386, 1.22857, 1.19424, 1.16086, 1.1284, 1.09683,
         1.06613, 1.03628, 1.00725, 0.979015, 0.95156, 0.92486, 0.898896, 0.873646, 0.849092, 0.825214, 0.801993,
         0.779411, 0.757449, 0.736093, 0.715322, 0.695124, 0.675479, 0.656375, 0.637795, 0.619724, 0.60215, 0.585057,
         0.568432, 0.559235, 3.51485, 3.47697, 3.39119, 3.30702, 3.22447, 3.14355]],
    'Sn':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.4848, 0.485, 0.48562299999999997, 0.493478, 0.501459,
         0.50957, 0.517812, 0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.9286999999999996, 3.9289, 3.97311, 4.03738, 4.10268, 4.156, 4.1562, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.464600000000001, 4.4648, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.2, 29.200200000000002,
         29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, -0.617521, -0.530603, -0.493238, -0.504236, -0.579138, -0.740259, -0.891436, -1.04661, -1.23597, -1.49552,
         -1.6989, -1.88562, -2.07385, -2.2842, -2.47739, -2.65929, -2.83839, -3.02366, -3.23022, -3.43246, -3.6105,
         -3.77494, -3.92842, -4.07153, -4.20419, -4.32668, -4.44102, -4.53474, -4.60691, -4.65499, -4.67411, -4.65234,
         -4.56273, -4.4383, -4.31588, -4.17074, -3.98944, -3.74917, -3.39804, -3.04284, -2.68217, -2.27866, -1.80131,
         -1.1627, -0.460873, 0.129707, 0.670513, 1.20275, 1.73961, 2.29963, 2.86725, 3.4334, 4.00987, 4.6072, 5.23614,
         5.92357, 6.64032, 7.35628, 8.09902, 8.91923, 9.76309, 10.5832, 11.4212, 12.3556, 13.2865, 14.1304, 14.9303,
         15.7199, 16.5145, 17.3428, 18.3032, 19.1538, 19.9274, 20.6797, 21.4286, 22.1926, 22.9954, 23.8941, 25.1183,
         26.3331, 27.0621, 27.549, 27.8883, 28.1232, 28.2816, 28.3843, 28.4516, 28.5212, 28.6342, 28.583, 28.4188,
         28.2007, 27.9444, 27.6604, 27.3575, 27.0417, 26.7199, 26.399, 26.0924, 25.8509, 25.5731, 25.1581, 24.6499,
         24.0595, 23.4721, 22.9265, 22.3905, 21.8667, 21.3828, 20.948, 20.5514, 20.1926, 19.8502, 19.5147, 19.229,
         18.9866, 18.8102, 18.6334, 18.4567, 18.2923, 18.1414, 18.0055, 17.8878, 17.8, 17.7252, 17.6481, 17.5727,
         17.5048, 17.4462, 17.3993, 17.3679, 17.3628, 17.3941, 17.4057, 17.4007, 17.3938, 17.3872, 17.383, 17.3833,
         17.3935, 17.416, 17.431, 17.4409, 17.4531, 17.4733, 17.5238, 17.548, 17.5522, 17.5453, 17.5306, 17.5113,
         17.4967, 17.4742, 17.4281, 17.3609, 17.2779, 17.1797, 17.0666, 16.9412, 16.8043, 16.6377, 16.4418, 16.2164,
         15.9588, 15.6587, 15.3143, 14.9415, 14.5275, 14.0569, 13.5023, 12.8642, 12.1419, 11.2473, 10.2553, 9.09164,
         7.97502, 7.87726, 7.37798, 4.9725, 3.21411, 1.78526, 0.935425, 2.94277, 5.10761, 7.30398, 9.17847, 10.754,
         12.5226, 13.9927, 15.2416, 16.4342, 17.6582, 18.6768, 19.5244, 20.2437, 20.8447, 21.3958, 21.8923, 22.355,
         22.7845, 22.419, 21.8164, 21.9609, 22.798, 24.5054, 25.9928, 27.2082, 28.3562, 29.3355, 30.2241, 31.0892,
         31.921, 32.6694, 33.3558, 33.9932, 34.5632, 35.1278, 35.7312, 36.3806, 37.0694, 38.0719, 39.154, 39.3529,
         39.5068, 39.8687, 40.2083, 40.526, 40.8244, 41.1048, 41.3681, 41.6155, 41.8479, 42.066, 42.2707, 42.4628,
         42.6431, 42.8122, 42.9705, 43.1196, 43.2597, 43.391, 43.514, 43.6292, 43.7368, 43.8371, 43.9303, 44.0166,
         44.096, 44.1704, 44.2408, 44.3072, 44.3693, 44.4276, 44.4818, 44.5325, 44.5803, 44.6287, 44.6734, 44.7115,
         44.7435, 44.7697, 44.7916, 44.8093, 44.823, 44.8332, 44.8388, 44.847, 44.8534, 44.8532, 44.8487, 44.8402,
         44.8278, 44.8112, 44.7909, 44.767, 44.7388, 44.7066, 44.6703, 44.6298, 44.585, 44.5355, 44.4813, 44.4221,
         44.3577, 44.2877, 44.2119, 44.1297, 44.0409, 43.9447, 43.8405, 43.7274, 43.6047, 43.4712, 43.3255, 43.1659,
         42.9905, 42.7967, 42.5811, 42.3396, 42.0664, 41.7538, 41.3906, 40.9597, 40.4342, 39.7661, 38.8555, 37.4303,
         33.8781, 21.367, 21.3687, 35.7824, 37.5436, 37.8216, 31.1452, 31.148, 37.0202, 39.7808, 40.9163, 41.5729,
         41.5607, 39.1491, 39.1509, 42.6724, 43.6361, 44.3357, 44.9116, 45.4069, 45.8429, 46.2318, 46.5818, 46.8989,
         47.1876, 47.4516, 47.6934, 47.9153, 48.1194, 48.3075, 48.4807, 48.6403, 48.7875, 48.9233, 49.0484, 49.1635,
         49.2695, 49.367, 49.4566, 49.5386, 49.6136, 49.6823, 49.7448, 49.8015, 49.8529, 49.8993, 49.941, 49.9782,
         50.0113, 50.0404, 50.0658, 50.0879, 50.1065, 50.1223, 50.1352, 50.1453, 50.153, 50.1582, 50.1612, 50.1622,
         50.1611, 50.1583, 50.1537, 50.1474, 50.1396, 50.1306, 50.1202, 50.1086, 50.0957, 50.0818, 50.0669, 50.051,
         50.0342, 50.0167, 49.9983, 49.9792, 49.9595, 49.9391, 49.9182, 49.8967, 49.8746, 49.8522, 49.8292, 49.8058,
         49.7821, 49.7579, 49.7334, 49.7086, 49.6834, 49.6579, 49.632, 49.6059, 49.5794, 49.5527, 49.5256, 49.4982,
         49.4704, 49.4423, 49.4138, 49.385, 49.3557, 49.3259, 49.2957, 49.2649, 49.2335, 49.2015, 49.1688, 49.1353,
         49.1009, 49.0654, 49.0289, 48.9911, 48.952, 48.9111, 48.8685, 48.8237, 48.7764, 48.7263, 48.6728, 48.6153,
         48.5531, 48.485, 48.4098, 48.3257, 48.23, 48.1191, 47.9872, 47.8249, 47.615, 47.3212, 46.8413, 45.5641,
         38.6877, 38.6878, 46.4003, 47.3136],
        [3.97344, 3.94095, 3.90871, 3.87675, 3.84504, 3.81359, 3.7824, 3.75146, 3.72078, 3.64688, 3.57189, 3.49845,
         3.42652, 3.30574, 3.15089, 3.0033, 2.86262, 2.72511, 2.48316, 2.2627, 2.06181, 1.89987, 1.75449, 1.62024,
         1.49626, 1.38177, 1.27604, 1.18242, 1.10196, 1.02698, 0.957105, 0.89297, 0.849459, 0.808068, 0.768695,
         0.736073, 0.710695, 0.686194, 0.662536, 0.64628, 0.633782, 0.621526, 0.609507, 0.602556, 0.600727, 0.598903,
         0.598391, 0.611967, 0.625852, 0.640967, 0.671939, 0.704407, 0.759304, 0.855339, 1.1389, 1.85247, 3.05677,
         3.71424, 4.00664, 4.16638, 4.33249, 4.50523, 4.64204, 4.7165, 4.79216, 4.86903, 4.94188, 4.84384, 4.74774,
         4.65354, 4.53693, 4.42302, 4.35143, 4.35427, 4.35711, 4.35995, 4.43789, 4.57867, 4.72392, 4.87378, 5.04642,
         5.25911, 5.48077, 5.71177, 5.95251, 6.2053, 6.52769, 6.86683, 7.22358, 7.59887, 7.99366, 8.40895, 8.84582,
         9.30963, 9.80363, 10.3239, 10.8717, 11.4486, 12.0561, 12.6958, 13.2701, 13.8664, 14.4895, 15.1406, 15.821,
         16.4976, 17.0915, 17.7067, 18.3441, 19.0045, 19.6886, 20.0565, 20.4, 20.7493, 21.1046, 21.466, 21.8321,
         22.1597, 22.4921, 22.8296, 23.1721, 23.5197, 23.8726, 24.1389, 24.4043, 24.6726, 24.9438, 25.0654, 25.1833,
         25.3018, 25.4208, 25.2904, 25.1553, 25.0209, 24.8872, 24.7543, 24.622, 24.4095, 24.0449, 23.6857, 23.3319,
         22.9834, 22.64, 22.3018, 21.9687, 21.6405, 20.5085, 19.2823, 18.1295, 17.0456, 16.0265, 15.0683, 14.1673,
         13.3203, 12.5239, 11.6421, 10.7199, 9.87078, 9.08886, 8.36888, 7.70596, 7.09555, 6.53348, 6.01594, 5.53939,
         5.1006, 4.69656, 4.10482, 3.55493, 3.07869, 2.66626, 2.45191, 2.26918, 2.149, 2.06322, 2.08757, 2.12123,
         2.19082, 2.27062, 2.35332, 2.47643, 2.63391, 2.80141, 2.9584, 3.0823, 3.21138, 3.34587, 3.486, 3.63199,
         3.78409, 3.94257, 4.06524, 4.18812, 4.31471, 4.44513, 4.57949, 4.71791, 4.86052, 5.00743, 5.11627, 5.19413,
         5.27318, 5.35343, 5.4349, 5.51761, 5.60158, 5.68683, 5.75534, 5.81259, 5.87041, 5.9288, 5.98777, 6.03117,
         6.03085, 6.03053, 6.0302, 6.02988, 6.02956, 6.02923, 5.99582, 5.95607, 5.91657, 5.87733, 5.83836, 5.79964,
         5.76118, 5.71383, 5.65477, 5.59631, 5.53847, 5.48122, 5.42457, 5.38633, 5.36289, 5.33955, 5.31631, 5.29318,
         5.32243, 5.36541, 5.45708, 5.64796, 5.84552, 6.02804, 5.61713, 5.73466, 7.42813, 9.62162, 12.4628, 16.1431,
         20.5203, 22.2248, 23.8532, 24.6222, 25.416, 25.9913, 26.1106, 26.2303, 26.3507, 26.3487, 26.1323, 25.9177,
         25.7049, 25.5233, 25.3932, 25.2638, 25.135, 24.8825, 24.4398, 25.1689, 26.5068, 27.9157, 28.7472, 28.7866,
         28.826, 28.6369, 28.3879, 28.1411, 27.8964, 27.5869, 27.2397, 26.8968, 26.5583, 26.2241, 25.9951, 25.7818,
         25.5701, 25.3603, 25.1521, 24.3413, 23.2912, 22.8698, 22.4083, 21.9512, 21.4987, 21.0554, 20.6212, 20.1961,
         19.7796, 19.3717, 18.9723, 18.581, 18.1979, 17.8228, 17.4556, 17.0964, 16.7452, 16.401, 16.0639, 15.7338,
         15.4103, 15.0936, 14.7834, 14.4796, 14.1825, 13.8921, 13.6104, 13.3349, 13.0649, 12.8004, 12.5411, 12.2869,
         12.0383, 11.7946, 11.5556, 11.3146, 11.0762, 10.8411, 10.6111, 10.386, 10.1654, 9.9496, 9.73846, 9.53185,
         9.33397, 9.13169, 8.93205, 8.73611, 8.5432, 8.35387, 8.16753, 7.98494, 7.80508, 7.62824, 7.45474, 7.28406,
         7.11654, 6.9517, 6.78984, 6.63078, 6.47454, 6.32104, 6.17018, 6.02202, 5.87647, 5.73352, 5.59303, 5.45502,
         5.31947, 5.18631, 5.05555, 4.92704, 4.80082, 4.67688, 4.55512, 4.43544, 4.31794, 4.20252, 4.08922, 3.97787,
         3.86841, 3.76105, 3.65559, 3.55191, 3.45004, 3.35003, 3.32065, 10.8165, 10.6258, 10.3581, 10.0972, 9.89191,
         13.588, 13.5233, 13.1917, 12.869, 12.555, 12.2471, 12.1656, 13.7097, 13.4942, 13.2039, 12.9168, 12.6326,
         12.3519, 12.0747, 11.801, 11.5311, 11.2652, 11.0033, 10.7455, 10.4916, 10.242, 9.99683, 9.75571, 9.51892,
         9.28642, 9.05831, 8.83453, 8.61505, 8.39981, 8.18894, 7.98243, 7.78004, 7.58182, 7.38798, 7.19822, 7.01252,
         6.83093, 6.65333, 6.47986, 6.31012, 6.14438, 5.98237, 5.82412, 5.66971, 5.51872, 5.37147, 5.22782, 5.08748,
         4.9507, 4.81718, 4.68692, 4.56, 4.43604, 4.31531, 4.19766, 4.0829, 3.97106, 3.86235, 3.75621, 3.65281, 3.55209,
         3.45399, 3.35846, 3.26544, 3.17486, 3.08668, 3.00085, 2.9173, 2.83598, 2.75684, 2.67984, 2.60491, 2.53201,
         2.46109, 2.3921, 2.32499, 2.25973, 2.19625, 2.13452, 2.07449, 2.01612, 1.95937, 1.9042, 1.85056, 1.79842,
         1.74774, 1.69848, 1.6506, 1.60406, 1.55884, 1.51489, 1.47218, 1.43069, 1.39037, 1.35119, 1.31313, 1.27616,
         1.24024, 1.20535, 1.17145, 1.13853, 1.10655, 1.07549, 1.04532, 1.01602, 0.987571, 0.959938, 0.933104, 0.907047,
         0.881743, 0.857173, 0.833315, 0.81015, 0.787658, 0.76582, 0.744618, 0.724034, 0.70405, 0.684648, 0.665814,
         0.647529, 0.62978, 0.612549, 0.595823, 0.579586, 0.574557, 3.54851, 3.48783, 3.40099]],
    'Sb':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.5281, 0.5283, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.1321, 4.1323, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.3803, 4.3805,
         4.44537, 4.517270000000001, 4.59033, 4.66458, 4.6982, 4.6983999999999995, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001,
         5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 3.11232, 2.91467, 2.69318, 2.44794, 2.15345, 1.81575, 1.35756, 0.735966, 0.770183, 1.27244, 1.55994,
         1.81873, 1.78895, 1.71294, 1.58647, 1.39552, 1.14676, 0.816139, 0.44683, 0.0408244, -0.354905, -0.721592,
         -1.05425, -1.39748, -1.73562, -2.00062, -2.26444, -2.50699, -2.66702, -2.63556, -2.76076, -2.8535, -2.87141,
         -2.84324, -2.87755, -2.94937, -3.08385, -3.14115, -3.10333, -2.99901, -2.92468, -2.8438, -2.73144, -2.6098,
         -2.48184, -2.35449, -2.14611, -1.81911, -1.37197, -0.944269, -0.491782, 0.0452285, 0.77979, 1.45834, 2.08365,
         2.71545, 3.3755, 4.09686, 4.83237, 5.59229, 6.39113, 7.24912, 8.19351, 9.29709, 10.4496, 11.6471, 13.0396,
         14.5129, 15.8818, 17.2457, 18.9441, 20.1893, 20.5647, 21.6919, 22.7399, 23.6561, 24.529, 25.4136, 26.379,
         27.6863, 28.7748, 29.5455, 29.9169, 30.0612, 30.0748, 30.035, 29.9706, 29.9619, 29.6502, 29.1148, 28.4629,
         27.7589, 27.0307, 26.2933, 25.5291, 24.7569, 23.9711, 23.33, 22.7896, 22.2892, 21.8044, 21.3099, 20.8024,
         20.3549, 19.9568, 19.6117, 19.3104, 19.0445, 18.8131, 18.6214, 18.493, 18.3824, 18.272, 18.1583, 18.0451,
         17.941, 17.8489, 17.7783, 17.7132, 17.6525, 17.59, 17.5298, 17.4746, 17.4298, 17.3887, 17.3469, 17.3015,
         17.2554, 17.2094, 17.164, 17.1194, 17.0759, 17.0334, 16.9921, 16.9523, 16.914, 16.8776, 16.8438, 16.8137,
         16.7906, 16.7838, 16.7691, 16.7421, 16.705, 16.6592, 16.6067, 16.548, 16.4829, 16.4114, 16.3333, 16.2483,
         16.156, 16.0558, 15.9474, 15.83, 15.703, 15.5655, 15.4168, 15.2561, 15.0826, 14.8962, 14.6983, 14.4904,
         14.2592, 13.9832, 13.6652, 13.304, 12.8949, 12.4314, 11.9043, 11.3037, 10.6104, 9.80154, 8.84525, 7.696,
         6.28402, 4.49258, 2.10701, -1.33553, -7.17167, -24.6468, -58.0467, -57.9911, -10.2272, 0.00993204, 5.68486,
         9.65438, 12.6811, 15.1372, 17.2058, 18.986, 20.5435, 21.9195, 23.1583, 24.2681, 25.2546, 26.1016, 26.7845,
         27.3469, 27.8631, 28.3423, 28.7764, 29.1553, 29.4679, 29.6966, 29.7412, 29.6111, 29.3095, 29.2974, 29.6297,
         30.1441, 31.0027, 32.0514, 33.2219, 34.1736, 34.8706, 35.4734, 35.9247, 36.3469, 36.7995, 37.2921, 37.8463,
         38.4406, 39.1722, 39.8409, 40.3666, 40.8285, 41.2421, 41.6191, 41.9653, 42.2852, 42.582, 42.8582, 43.1157,
         43.3563, 43.5811, 43.7915, 43.9888, 44.1743, 44.3492, 44.5141, 44.6693, 44.8157, 44.9542, 45.0852, 45.2103,
         45.3301, 45.4472, 45.5555, 45.6518, 45.7397, 45.8203, 45.8941, 45.9621, 46.0248, 46.0829, 46.1381, 46.1889,
         46.2335, 46.2712, 46.3032, 46.3304, 46.3532, 46.3716, 46.3864, 46.396, 46.406, 46.4146, 46.4177, 46.4161,
         46.4106, 46.4018, 46.3892, 46.373, 46.353, 46.3297, 46.303, 46.2724, 46.2385, 46.2005, 46.1587, 46.1131,
         46.0635, 46.0098, 45.9518, 45.8892, 45.8218, 45.7495, 45.6718, 45.5882, 45.4986, 45.4021, 45.2985, 45.1867,
         45.0661, 44.9355, 44.7938, 44.6395, 44.4705, 44.2846, 44.079, 43.8496, 43.5912, 43.2971, 42.957, 42.5562,
         42.0709, 41.4596, 40.6392, 39.3939, 36.7362, 23.9024, 23.9039, 37.0855, 39.1169, 39.6096, 37.5446, 33.0068,
         33.011, 40.9183, 42.1683, 42.8546, 43.026, 40.1599, 40.1643, 43.7255, 44.8387, 45.5823, 46.1761, 46.6772,
         47.112, 47.4956, 47.8376, 48.1446, 48.4219, 48.6734, 48.9023, 49.1111, 49.3017, 49.4761, 49.6359, 49.7823,
         49.9164, 50.0394, 50.152, 50.2551, 50.3495, 50.4356, 50.5144, 50.586, 50.6511, 50.7102, 50.7636, 50.8118,
         50.8551, 50.8936, 50.9279, 50.9583, 50.9849, 51.0079, 51.0275, 51.0442, 51.0581, 51.069, 51.0775, 51.0836,
         51.0876, 51.0894, 51.0893, 51.0875, 51.084, 51.0788, 51.0723, 51.0643, 51.055, 51.0445, 51.0329, 51.0202,
         51.0066, 50.992, 50.9766, 50.9604, 50.9434, 50.9258, 50.9075, 50.8886, 50.8692, 50.8492, 50.8287, 50.8078,
         50.7865, 50.7647, 50.7426, 50.7201, 50.6973, 50.6741, 50.6506, 50.6268, 50.6027, 50.5783, 50.5536, 50.5287,
         50.5034, 50.4778, 50.4519, 50.4257, 50.3992, 50.3723, 50.345, 50.3173, 50.2891, 50.2605, 50.2314, 50.2017,
         50.1714, 50.1404, 50.1086, 50.076, 50.0424, 50.0078, 49.972, 49.9348, 49.8962, 49.8558, 49.8134, 49.7688,
         49.7215, 49.6712, 49.6173, 49.5592, 49.4959, 49.4263, 49.3491, 49.2621, 49.1625, 49.046, 48.906, 48.7313,
         48.5005, 48.1654, 47.5711],
        [9.95091, 10.0681, 9.92927, 9.42377, 8.92685, 8.35287, 7.84004, 7.4678, 7.10503, 6.73907, 6.40578, 6.13726,
         5.87998, 5.66684, 5.46446, 5.25911, 5.02274, 4.80646, 4.66469, 4.51586, 4.35766, 4.205, 4.06056, 3.93297,
         3.80939, 3.62391, 3.43609, 3.23897, 3.06763, 2.91292, 2.7618, 2.61527, 2.47518, 2.33906, 2.21043, 2.09822,
         1.99221, 1.88825, 1.78917, 1.69529, 1.61194, 1.53594, 1.47, 1.39159, 1.31536, 1.24508, 1.19852, 1.1537,
         1.11056, 1.06114, 0.992411, 0.932795, 0.901114, 0.870507, 0.826812, 0.771225, 0.746881, 0.722726, 0.680521,
         0.65155, 0.632894, 0.614773, 0.592995, 0.570475, 0.550972, 0.536739, 0.536378, 0.536018, 0.539936, 0.55031,
         0.568891, 0.609553, 0.681588, 0.810752, 1.00978, 2.16656, 2.62215, 2.68626, 2.64591, 2.42602, 2.32507, 2.22857,
         2.14272, 2.07332, 2.05692, 2.07505, 2.22673, 2.42288, 2.69851, 2.995, 3.31311, 3.72083, 4.15517, 4.60258,
         5.11024, 5.73693, 6.16547, 6.63601, 7.14244, 7.68753, 8.12142, 8.54249, 8.98539, 9.49949, 10.1154, 10.7713,
         11.3445, 11.9112, 12.5062, 13.1234, 13.7389, 14.3834, 15.0838, 15.8667, 16.6902, 17.4104, 18.1038, 18.8248,
         19.5746, 20.2752, 20.7754, 21.2879, 21.813, 22.3511, 22.8834, 23.3753, 23.8735, 24.3803, 24.8978, 25.4264,
         25.9435, 26.271, 26.6026, 26.8722, 26.9077, 26.7069, 26.5036, 26.1428, 25.0337, 24.3959, 24.1491, 23.4454,
         22.7621, 22.0987, 21.4524, 20.8238, 20.1695, 18.6095, 17.0947, 15.5205, 14.0914, 12.7939, 11.6157, 10.4575,
         9.30487, 7.92116, 6.74314, 5.74124, 4.89736, 4.18751, 3.58683, 3.07449, 2.71807, 2.49281, 2.40463, 2.31957,
         2.23751, 2.15837, 2.10893, 2.11239, 2.19888, 2.31069, 2.44492, 2.58697, 2.73727, 2.8963, 3.06457, 3.21825,
         3.34443, 3.43047, 3.51727, 3.60679, 3.70138, 3.79901, 3.89594, 3.97422, 4.0474, 4.11634, 4.18643, 4.25772,
         4.33022, 4.38731, 4.44154, 4.49357, 4.54615, 4.59937, 4.65326, 4.70774, 4.76285, 4.81859, 4.87502, 4.93209,
         4.98981, 5.04825, 5.10738, 5.16719, 5.22768, 5.27517, 5.30568, 5.32524, 5.34329, 5.3614, 5.3796, 5.39784,
         5.4161, 5.43449, 5.45293, 5.47142, 5.48995, 5.50855, 5.52726, 5.54599, 5.56477, 5.58363, 5.6026, 5.62162,
         5.64068, 5.65983, 5.67652, 5.68764, 5.67224, 5.64638, 5.62063, 5.59499, 5.56947, 5.54417, 5.5189, 5.49311,
         5.4644, 5.43372, 5.40207, 5.37055, 5.33922, 5.3081, 5.27718, 5.24644, 5.21587, 5.18548, 5.17863, 40.4663,
         39.7857, 38.8962, 38.0259, 37.175, 36.3487, 35.5788, 34.8346, 34.1121, 33.4051, 32.7122, 32.0313, 31.3408,
         30.6303, 29.9134, 29.2143, 28.6102, 28.08, 27.5863, 27.1086, 26.6443, 26.1881, 25.7396, 25.3105, 25.0125,
         25.1554, 25.6701, 26.1947, 26.7304, 27.2772, 27.5181, 27.4078, 26.9858, 26.5715, 26.164, 25.763, 25.5229,
         25.3245, 25.162, 25.0006, 24.8111, 24.5919, 24.1034, 23.6181, 23.1379, 22.6673, 22.2063, 21.7546, 21.3122,
         20.8787, 20.4541, 20.0381, 19.6306, 19.2314, 18.8408, 18.4587, 18.0848, 17.7188, 17.36, 17.0084, 16.664,
         16.3266, 15.9959, 15.6722, 15.3534, 15.0386, 14.721, 14.4089, 14.1035, 13.8043, 13.5115, 13.2251, 12.9447,
         12.6702, 12.4016, 12.1337, 11.8698, 11.6103, 11.3568, 11.1087, 10.8659, 10.6284, 10.3962, 10.1692, 9.95145,
         9.73074, 9.51375, 9.30114, 9.09249, 8.8883, 8.68723, 8.49054, 8.29714, 8.1081, 7.92205, 7.73973, 7.56087,
         7.38506, 7.21297, 7.04407, 6.87843, 6.71593, 6.55647, 6.40002, 6.24657, 6.09612, 5.94841, 5.80354, 5.66146,
         5.52205, 5.38534, 5.25113, 5.11949, 4.99039, 4.86368, 4.73933, 4.61737, 4.49774, 4.3804, 4.26514, 4.15211,
         4.04124, 3.93245, 3.82567, 3.72091, 3.61811, 3.51726, 3.41825, 3.3214, 3.27915, 10.3431, 10.2034, 9.9549,
         9.71245, 9.47607, 9.45719, 13.0236, 12.718, 12.3926, 12.0757, 11.7667, 11.631, 13.3768, 13.2023, 12.8907,
         12.5846, 12.2838, 11.9886, 11.6989, 11.4149, 11.1361, 10.8629, 10.5952, 10.3328, 10.0759, 9.82416, 9.5778,
         9.33672, 9.10089, 8.87002, 8.64429, 8.42356, 8.2077, 7.99676, 7.79056, 7.58921, 7.39245, 7.20018, 7.01252,
         6.8292, 6.65031, 6.47568, 6.30508, 6.13881, 5.97654, 5.81823, 5.6637, 5.51302, 5.36603, 5.22294, 5.08311,
         4.94687, 4.81417, 4.68483, 4.55874, 4.43583, 4.31615, 4.19954, 4.08576, 3.97516, 3.8673, 3.76223, 3.65991,
         3.56025, 3.4632, 3.36871, 3.27669, 3.18711, 3.09989, 3.01499, 2.93234, 2.85188, 2.77357, 2.69735, 2.62317,
         2.55098, 2.48072, 2.41235, 2.34582, 2.28108, 2.2181, 2.15681, 2.09718, 2.03916, 1.98272, 1.92781, 1.87439,
         1.82243, 1.77188, 1.72271, 1.67487, 1.62835, 1.58309, 1.53907, 1.49625, 1.45461, 1.4141, 1.3747, 1.33639,
         1.29912, 1.26287, 1.22762, 1.19334, 1.15999, 1.12756, 1.09603, 1.06535, 1.03552, 1.00651, 0.978292, 0.950852,
         0.924163, 0.898208, 0.872965, 0.848415, 0.824537, 0.801315, 0.77873, 0.756764, 0.7354, 0.71462, 0.69441,
         0.674753, 0.655634, 0.637037, 0.618949, 0.601355, 0.584241, 0.567594]],
    'Te':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.5729, 0.5731, 0.579361,
         0.5887319999999999, 0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.3413, 4.3415, 4.37462, 4.44537,
         4.517270000000001, 4.59033, 4.6118999999999994, 4.612100000000001, 4.66458, 4.74003, 4.8166899999999995,
         4.8946000000000005, 4.939100000000001, 4.9393, 4.97377, 5.05421, 5.13596, 5.21903, 5.303439999999999, 5.38922,
         5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 4.66549, 4.51435, 4.37442, 4.23907, 4.09926, 3.95604, 3.80382, 3.63674, 3.46693, 3.29761, 3.12308, 2.9421,
         2.75495, 2.55765, 2.34757, 2.12557, 1.88656, 1.62431, 1.33139, 0.993601, 0.583056, 0.0143339, -0.929514,
         -1.92937, -0.626741, 0.121031, 0.202208, -0.0384846, -0.434534, -1.1665, -1.71905, -2.07132, -2.42488,
         -2.77063, -3.11558, -3.46176, -3.79519, -4.00432, -4.16388, -4.37055, -4.59082, -4.82099, -5.06818, -5.29783,
         -5.44403, -5.44933, -5.35417, -5.3399, -5.37272, -5.34097, -5.23072, -4.98193, -4.63444, -4.33613, -4.03957,
         -3.70316, -3.29868, -2.75174, -2.24552, -1.74216, -1.22224, -0.590245, 0.22084, 1.07313, 1.95946, 2.95256,
         4.04183, 5.34082, 6.765, 8.11641, 9.47543, 10.934, 12.6284, 14.4792, 16.1942, 17.9369, 19.8977, 22.1452,
         24.0618, 25.9762, 28.5945, 30.2059, 31.1504, 31.8342, 32.3748, 32.9718, 33.5739, 33.5231, 33.069, 32.4406,
         31.6745, 30.8947, 30.1341, 29.3754, 28.6234, 27.8788, 27.144, 26.4146, 25.6791, 24.9069, 24.226, 23.578,
         22.8673, 22.2811, 21.7876, 21.3333, 20.8875, 20.4837, 20.1167, 19.7704, 19.4298, 19.0971, 18.7943, 18.5077,
         18.2378, 17.9924, 17.7687, 17.5641, 17.3793, 17.2212, 17.0783, 16.9417, 16.8142, 16.6998, 16.6011, 16.5255,
         16.4843, 16.4354, 16.3813, 16.333, 16.2926, 16.2631, 16.2532, 16.2667, 16.2704, 16.2716, 16.2763, 16.2881,
         16.3124, 16.369, 16.4173, 16.4493, 16.4719, 16.4908, 16.5075, 16.5236, 16.5401, 16.5584, 16.5802, 16.6084,
         16.6672, 16.7215, 16.7469, 16.757, 16.7567, 16.7481, 16.7328, 16.7126, 16.6896, 16.667, 16.6929, 16.6825,
         16.6085, 16.4966, 16.351, 16.1716, 15.9554, 15.6874, 15.3957, 15.0843, 14.7445, 14.3667, 13.9434, 13.4659,
         12.923, 12.3007, 11.5506, 10.7071, 9.75004, 8.61606, 7.19534, 5.40571, 3.1572, -0.0113654, -5.232, -18.5842,
         -52.3115, -52.2341, -8.43237, 1.87282, 7.39573, 11.1658, 13.9686, 16.1006, 17.6092, 18.9882, 20.3429, 21.5864,
         22.7433, 23.8722, 24.8919, 25.7608, 26.4947, 27.1146, 27.581, 27.8845, 28.1829, 28.4565, 28.2572, 28.2393,
         28.6851, 29.39, 30.7858, 31.9964, 32.839, 33.614, 34.3351, 34.9868, 35.5695, 36.0543, 36.5342, 37.1002,
         37.7876, 38.5881, 39.3056, 39.9085, 40.427, 40.8939, 41.3203, 41.7132, 42.0773, 42.4162, 42.7323, 43.0281,
         43.3055, 43.5656, 43.8099, 44.0399, 44.2573, 44.4628, 44.6572, 44.8414, 45.0163, 45.1828, 45.3416, 45.4945,
         45.6439, 45.7907, 45.9264, 46.0481, 46.1584, 46.2599, 46.3538, 46.4409, 46.5222, 46.5981, 46.675, 46.7465,
         46.8082, 46.8607, 46.9045, 46.9417, 46.9728, 46.9986, 47.0195, 47.0339, 47.0514, 47.0659, 47.072, 47.0728,
         47.069, 47.0609, 47.048, 47.0307, 47.009, 46.9835, 46.9542, 46.9204, 46.883, 46.8413, 46.7959, 46.7465,
         46.6929, 46.6353, 46.5736, 46.5075, 46.4371, 46.3622, 46.2825, 46.1977, 46.1077, 46.0121, 45.9106, 45.8026,
         45.6875, 45.5649, 45.4338, 45.2934, 45.1426, 44.98, 44.804, 44.6127, 44.4033, 44.1728, 43.917, 43.6303,
         43.3051, 42.9306, 42.4907, 41.9598, 41.2938, 40.4045, 39.0689, 36.3202, 21.2235, 21.2252, 36.0199, 38.6748,
         39.4443, 38.6508, 32.3643, 32.3691, 40.4554, 42.0405, 42.9005, 43.2781, 40.4125, 40.4171, 43.7779, 45.0467,
         45.8702, 46.5284, 47.0861, 47.5719, 48.002, 48.3871, 48.7342, 49.0489, 49.3354, 49.597, 49.8365, 50.056,
         50.2576, 50.443, 50.6134, 50.77, 50.9142, 51.0469, 51.1689, 51.2812, 51.384, 51.4782, 51.5645, 51.6434,
         51.7154, 51.7809, 51.8401, 51.8938, 51.9423, 51.9856, 52.0244, 52.0589, 52.0889, 52.1152, 52.1381, 52.1575,
         52.1738, 52.187, 52.1975, 52.2054, 52.2108, 52.2139, 52.2148, 52.2136, 52.2106, 52.2058, 52.1994, 52.1914,
         52.182, 52.1712, 52.1591, 52.1459, 52.1316, 52.1162, 52.0998, 52.0826, 52.0645, 52.0457, 52.0261, 52.0059,
         51.985, 51.9635, 51.9415, 51.9189, 51.8959, 51.8724, 51.8485, 51.8242, 51.7995, 51.7745, 51.7491, 51.7233,
         51.6973, 51.6709, 51.6441, 51.6171, 51.5898, 51.5621, 51.5341, 51.5058, 51.4771, 51.448, 51.4185, 51.3886,
         51.3582, 51.3272, 51.2958, 51.2637, 51.2309, 51.1974, 51.1631, 51.1278, 51.0915, 51.0539, 51.0151, 50.9748,
         50.9327, 50.8886, 50.8422, 50.7932, 50.7411, 50.6853, 50.625, 50.5595, 50.4875, 50.4074, 50.3169, 50.2129,
         50.0908, 49.9444, 49.7483],
        [9.70237, 9.72653, 9.75076, 9.77506, 9.7994, 9.77638, 9.72308, 9.67008, 9.61736, 9.54395, 9.46085, 9.37848,
         9.2915, 9.1914, 9.09238, 8.99443, 8.9049, 8.81998, 8.73588, 8.65256, 8.3212, 7.97096, 7.65865, 7.37439,
         7.07333, 6.76248, 6.46529, 6.20847, 5.96465, 5.75268, 5.61163, 5.47404, 5.33982, 5.19298, 5.01356, 4.84034,
         4.6731, 4.51347, 4.36101, 4.21371, 4.07139, 3.93243, 3.7903, 3.65331, 3.44444, 3.21816, 3.02493, 2.84787,
         2.71658, 2.59134, 2.45805, 2.32492, 2.14513, 1.97252, 1.88535, 1.80203, 1.71319, 1.60315, 1.49563, 1.38815,
         1.29731, 1.23174, 1.1694, 1.10701, 1.04796, 0.977697, 0.90184, 0.844635, 0.819874, 0.795837, 0.769363,
         0.740463, 0.711461, 0.679349, 0.651564, 0.642369, 0.633303, 0.624365, 0.620165, 0.616361, 0.612579, 0.612202,
         0.613164, 0.614129, 0.615267, 0.617596, 0.619936, 0.627144, 0.639935, 0.819245, 1.82459, 3.56658, 3.2462,
         2.84244, 2.52394, 2.29379, 2.3039, 2.65964, 3.04134, 3.37898, 3.74833, 4.14647, 4.5869, 5.11915, 5.73446,
         6.19007, 6.67913, 7.20044, 7.75616, 8.3548, 9.07518, 9.86977, 10.7339, 11.4165, 12.0916, 12.8499, 13.6901,
         14.5851, 15.5387, 16.3146, 17.0857, 17.8933, 18.7391, 19.6248, 20.4734, 21.2461, 22.048, 22.924, 23.8649,
         24.8127, 25.6337, 26.4817, 27.3386, 28.1851, 29.0579, 29.5799, 30.0536, 30.5348, 31.0238, 31.5207, 31.6132,
         31.5762, 31.5391, 31.5022, 30.9673, 30.1064, 29.2695, 27.8425, 25.5986, 23.5356, 21.6388, 19.8949, 18.2915,
         16.1379, 13.9535, 12.0647, 10.4316, 9.03391, 7.90432, 6.91598, 6.05125, 5.29464, 4.63261, 4.05337, 3.54654,
         3.1031, 2.77197, 2.54912, 2.34418, 2.22832, 2.23271, 2.23711, 2.24152, 2.25635, 2.30549, 2.35571, 2.40703,
         2.45946, 2.54273, 2.64275, 2.7467, 2.87381, 3.01015, 3.15297, 3.30256, 3.45926, 3.62338, 3.76835, 3.91758,
         4.07273, 4.23402, 4.40169, 4.57601, 4.73, 4.86332, 5.00038, 5.14132, 5.28623, 5.43521, 5.5884, 5.72257,
         5.83748, 5.95471, 6.07429, 6.19626, 6.32069, 6.4426, 6.50829, 6.57465, 6.64169, 6.70941, 6.77782, 6.84693,
         6.91674, 6.98727, 7.05852, 7.13049, 7.20319, 7.2167, 7.22331, 7.22993, 7.23657, 7.2432, 7.24984, 7.25649,
         7.26314, 7.2698, 7.27196, 7.16808, 7.06571, 6.96479, 6.8653, 6.76725, 6.67059, 6.57686, 6.52987, 6.48322,
         6.43691, 6.39093, 6.34527, 6.29995, 6.25495, 6.21026, 6.17379, 6.19347, 6.21321, 6.23302, 6.25289, 6.37474,
         6.57361, 6.77867, 7.25851, 8.01168, 8.25338, 40.32, 39.562, 38.4686, 37.4054, 36.3717, 35.3665, 34.3891,
         33.6322, 33.1867, 32.7472, 32.3134, 31.8854, 31.4631, 30.8824, 30.2964, 29.7216, 29.1576, 28.6044, 28.1608,
         27.8626, 27.5675, 27.2803, 27.8616, 28.4553, 29.0617, 29.4727, 29.1527, 28.8362, 28.5232, 28.1796, 27.82,
         27.465, 27.1145, 26.9431, 26.8099, 26.6442, 26.4217, 25.9082, 25.3964, 24.8883, 24.3903, 23.9023, 23.424,
         22.9555, 22.4962, 22.046, 21.6051, 21.1729, 20.7492, 20.3347, 19.929, 19.5319, 19.1427, 18.7613, 18.3876,
         18.0214, 17.6624, 17.3105, 16.9656, 16.6252, 16.2879, 15.9423, 15.602, 15.2691, 14.9432, 14.6242, 14.3119,
         14.0063, 13.7073, 13.4147, 13.1176, 12.8234, 12.5328, 12.2487, 11.971, 11.6995, 11.4343, 11.1752, 10.922,
         10.68, 10.4326, 10.19, 9.95209, 9.71947, 9.49115, 9.26714, 9.04814, 8.83346, 8.62396, 8.41836, 8.21687,
         8.02045, 7.82754, 7.63953, 7.45519, 7.27509, 7.09909, 6.92695, 6.7587, 6.59429, 6.43359, 6.27661, 6.12319,
         5.97338, 5.82702, 5.68416, 5.54454, 5.40824, 5.27515, 5.1452, 5.01833, 4.89453, 4.77363, 4.65571, 4.54053,
         4.42815, 4.31851, 4.21152, 4.10716, 4.00531, 3.90593, 3.80893, 3.7144, 3.62216, 3.53212, 3.44428, 3.35866,
         3.31469, 11.3604, 11.2248, 10.9438, 10.67, 10.4029, 10.3262, 14.1634, 13.9109, 13.5604, 13.2188, 12.8855,
         12.7013, 14.4492, 14.3075, 13.9858, 13.6686, 13.3558, 13.0477, 12.7443, 12.4458, 12.1521, 11.8635, 11.5798,
         11.301, 11.0274, 10.7586, 10.495, 10.2364, 9.98292, 9.73437, 9.49083, 9.25244, 9.01886, 8.79031, 8.56648,
         8.34731, 8.13295, 7.92342, 7.71862, 7.51829, 7.3224, 7.13101, 6.94428, 6.76162, 6.58325, 6.40927, 6.23916,
         6.07317, 5.91143, 5.75344, 5.59935, 5.44897, 5.30225, 5.15935, 5.01995, 4.88385, 4.75128, 4.62211, 4.49623,
         4.37356, 4.25403, 4.13759, 4.02415, 3.91366, 3.80605, 3.70125, 3.59921, 3.49984, 3.40311, 3.30894, 3.21727,
         3.12804, 3.0412, 2.95669, 2.87445, 2.79443, 2.71657, 2.64082, 2.56713, 2.49544, 2.4257, 2.35788, 2.29191,
         2.22775, 2.16535, 2.10468, 2.04568, 1.9883, 1.93252, 1.87829, 1.82556, 1.7743, 1.72447, 1.67603, 1.62894,
         1.58317, 1.53868, 1.49544, 1.45342, 1.41257, 1.37288, 1.3343, 1.29681, 1.26038, 1.22498, 1.19058, 1.15716,
         1.12468, 1.09312, 1.06246, 1.03267, 1.00373, 0.975603, 0.948281, 0.921736, 0.895949, 0.870896, 0.846556,
         0.822911, 0.79994, 0.777626, 0.755948, 0.73489, 0.714433, 0.69456, 0.675257]],
    'I':                                                                            [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.6199, 0.6201, 0.627755, 0.637908, 0.648226, 0.658711,
         0.669365, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.557,
         4.5572, 4.59033, 4.66458, 4.74003, 4.8166899999999995, 4.852, 4.8522, 4.8946000000000005, 4.97377, 5.05421,
         5.13596, 5.188, 5.1882, 5.21903, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999,
         5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348,
         6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054,
         7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055,
         9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045,
         10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295,
         12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883,
         14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904,
         16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384,
         19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997,
         21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002,
         25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998,
         28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 8.6039, 8.48945, 8.37226, 8.2513, 8.12476, 7.99986, 7.87412, 7.74628, 7.61584, 7.48238, 7.34562, 7.20568,
         7.05951, 6.90638, 6.74544, 6.57312, 6.3874, 6.20463, 6.01751, 5.81973, 5.60378, 5.37609, 5.1458, 4.90062,
         4.62757, 4.33466, 4.00705, 3.60324, 3.0785, 2.35422, 1.7326, 1.2776, 1.29574, 3.17649, 5.89873, 5.93686,
         4.95233, 3.76698, 2.97006, 2.13977, 1.44322, 1.19607, 1.23617, 0.800734, -0.14758, -0.995416, -1.7389,
         -2.46034, -3.16539, -3.82932, -4.40672, -4.98989, -5.54052, -5.99773, -6.26717, -6.04553, -5.98907, -5.96129,
         -5.86799, -5.61508, -5.34793, -4.9939, -4.47498, -3.59753, -2.56194, -1.62484, -0.675598, 0.421517, 1.71087,
         2.98865, 4.35036, 5.98692, 7.741, 9.44366, 11.3136, 13.2351, 15.056, 17.0547, 18.9728, 20.6491, 22.214,
         23.8175, 25.7738, 27.8087, 29.027, 29.8169, 30.347, 30.692, 30.899, 30.9995, 31.0194, 30.9796, 30.9057,
         30.8581, 30.689, 30.4278, 30.1107, 29.758, 29.3817, 28.9896, 28.5894, 28.1879, 27.7972, 27.4579, 27.0954,
         26.62, 26.0686, 25.4568, 24.7464, 24.1357, 23.5918, 23.1039, 22.6237, 22.191, 21.7807, 21.3868, 21.0176,
         20.6681, 20.3584, 20.0769, 19.8169, 19.5761, 19.3522, 19.1441, 18.9508, 18.7722, 18.6083, 18.4606, 18.3375,
         18.2198, 18.108, 18.0073, 17.919, 17.8453, 17.7897, 17.7647, 17.764, 17.7565, 17.7464, 17.744, 17.7528,
         17.7777, 17.8472, 17.9205, 17.9794, 18.0464, 18.1297, 18.194, 18.2423, 18.286, 18.3282, 18.3717, 18.4219,
         18.5004, 18.5575, 18.591, 18.6087, 18.6154, 18.6124, 18.6009, 18.5816, 18.5557, 18.5253, 18.5011, 18.4584,
         18.3921, 18.3053, 18.2007, 18.0782, 17.9373, 17.7774, 17.5976, 17.4026, 17.1876, 16.9291, 16.6273, 16.2811,
         15.8858, 15.4349, 14.9191, 14.326, 13.6396, 12.8378, 11.8894, 10.7484, 9.3407, 7.55512, 5.18532, 1.76651,
         -4.05496, -21.9139, -56.487, -56.4286, -6.49421, 3.68249, 9.30876, 13.1979, 16.0906, 18.3507, 20.2378, 21.861,
         23.2741, 24.5079, 25.5853, 26.5221, 27.3222, 27.9945, 28.5448, 29.0214, 29.4208, 29.7105, 29.6802, 29.5116,
         29.2739, 29.3738, 29.8774, 30.6169, 32.0426, 33.5319, 34.7961, 35.8226, 36.6192, 37.3058, 37.8835, 38.4062,
         38.8978, 39.3726, 39.837, 40.283, 40.7121, 41.1257, 41.5258, 41.9141, 42.2934, 42.6661, 43.0512, 43.435,
         43.8164, 44.1595, 44.4581, 44.7336, 44.9897, 45.2288, 45.453, 45.6641, 45.8646, 46.0551, 46.2392, 46.4111,
         46.5673, 46.712, 46.8464, 46.9717, 47.0888, 47.1984, 47.3012, 47.3994, 47.4913, 47.5752, 47.6509, 47.7196,
         47.7816, 47.8377, 47.8886, 47.9346, 47.9745, 48.014, 48.0509, 48.0815, 48.1068, 48.1277, 48.1444, 48.1569,
         48.165, 48.1694, 48.1699, 48.1667, 48.1596, 48.1488, 48.1342, 48.1161, 48.0943, 48.0688, 48.0393, 48.0062,
         47.9695, 47.9288, 47.8842, 47.8354, 47.7823, 47.7248, 47.6626, 47.5956, 47.5234, 47.4457, 47.3622, 47.2723,
         47.1756, 47.0715, 46.9592, 46.8379, 46.7065, 46.5638, 46.4082, 46.2379, 46.0506, 45.8431, 45.6118, 45.3515,
         45.0551, 44.7128, 44.3099, 43.823, 43.2119, 42.3967, 41.1771, 38.7032, 24.5846, 24.5863, 38.2162, 40.7492,
         41.5098, 41.132, 34.839, 34.8434, 41.9824, 43.6261, 44.4398, 44.7661, 41.4945, 41.4989, 45.0657, 46.444,
         47.2785, 47.9296, 48.4736, 48.9426, 49.3542, 49.7198, 50.0472, 50.3423, 50.6095, 50.852, 51.0729, 51.2745,
         51.4587, 51.6272, 51.7814, 51.9226, 52.052, 52.1703, 52.2786, 52.3776, 52.4679, 52.5502, 52.6253, 52.6935,
         52.7553, 52.8112, 52.8613, 52.9063, 52.9468, 52.9826, 53.014, 53.0416, 53.0657, 53.0862, 53.1034, 53.1177,
         53.1292, 53.1381, 53.1444, 53.1484, 53.1502, 53.1501, 53.1481, 53.1443, 53.1389, 53.1319, 53.1235, 53.1138,
         53.1028, 53.0907, 53.0775, 53.0633, 53.0481, 53.0321, 53.0152, 52.9976, 52.9792, 52.9602, 52.9406, 52.9204,
         52.8997, 52.8785, 52.8568, 52.8346, 52.8121, 52.7892, 52.7658, 52.7422, 52.7182, 52.6939, 52.6692, 52.6443,
         52.6191, 52.5935, 52.5677, 52.5416, 52.5151, 52.4884, 52.4613, 52.4338, 52.406, 52.3778, 52.3492, 52.3201,
         52.2905, 52.2604, 52.2297, 52.1983, 52.1662, 52.1334, 52.0996, 52.0648, 52.0289, 51.9917, 51.9531, 51.9129,
         51.8708, 51.8266, 51.7799, 51.7304, 51.6775, 51.6205, 51.5588, 51.4913, 51.4167, 51.3331, 51.2379, 51.1274],
        [7.8167, 7.56781, 7.32685, 7.08081, 6.8332, 6.78435, 6.80888, 7.27334, 7.86775, 8.52786, 9.24335, 10.0092,
         10.7896, 11.0623, 11.3418, 11.4253, 11.3727, 11.3203, 11.2681, 11.2095, 11.1155, 11.0223, 10.93, 10.8383,
         10.7475, 10.6574, 10.4573, 10.1905, 9.93056, 9.67721, 9.43034, 9.18976, 8.95532, 8.72686, 8.50423, 8.28728,
         8.07586, 7.86984, 7.66907, 7.42175, 7.14799, 6.88433, 6.63039, 6.38583, 6.15028, 5.92343, 5.70494, 5.49451,
         5.29184, 5.09665, 4.90865, 4.68919, 4.44107, 4.20609, 3.98353, 3.77276, 3.57313, 3.38407, 3.20501, 3.03543,
         2.87482, 2.7227, 2.57864, 2.4422, 2.31298, 2.19332, 2.08206, 1.97645, 1.87619, 1.78101, 1.69067, 1.60815,
         1.53269, 1.46076, 1.39221, 1.32688, 1.26462, 1.20527, 1.14784, 1.09115, 1.03727, 0.986041, 0.937347, 0.903753,
         0.877899, 0.852786, 0.82839, 0.804693, 0.806253, 0.810089, 0.813942, 0.823425, 0.847795, 0.872888, 0.902866,
         0.977345, 1.3167, 2.00134, 3.04198, 4.62369, 7.02792, 4.83265, 2.81967, 1.64518, 1.34657, 1.36268, 1.43819,
         1.93061, 2.59163, 2.49683, 2.24931, 2.1923, 2.58873, 3.05686, 3.60962, 4.26232, 5.03308, 5.87252, 6.7879,
         7.84598, 9.06897, 10.4826, 11.8131, 12.8675, 14.016, 15.267, 16.5375, 17.8058, 19.1713, 20.6415, 22.2245,
         23.2596, 24.3108, 25.4095, 26.5578, 27.5394, 28.4517, 29.3941, 30.3677, 30.8583, 31.3227, 31.7941, 31.8194,
         31.794, 31.7686, 31.0869, 30.4158, 29.7593, 29.1169, 28.4884, 26.8173, 24.8686, 23.0614, 21.3857, 19.8317,
         18.3906, 17.0543, 15.8151, 14.6658, 13.6001, 12.5697, 11.4908, 10.5045, 9.60285, 8.77859, 8.02511, 7.33627,
         6.70659, 6.13095, 5.6047, 5.12362, 4.50919, 3.93609, 3.43468, 2.99581, 2.71715, 2.57603, 2.48845, 2.4294,
         2.38967, 2.39376, 2.39786, 2.44337, 2.50095, 2.59423, 2.70521, 2.82093, 2.94182, 3.06831, 3.20023, 3.33783,
         3.48134, 3.63102, 3.78714, 3.94997, 4.11247, 4.26871, 4.43088, 4.59922, 4.77395, 4.95531, 5.14357, 5.33898,
         5.49854, 5.64678, 5.79902, 5.95538, 6.11594, 6.28084, 6.45017, 6.55562, 6.66107, 6.76823, 6.84572, 6.90162,
         6.95797, 7.01478, 7.07206, 7.12981, 7.18802, 7.2374, 7.23201, 7.22663, 7.22125, 7.21587, 7.2105, 7.20513,
         7.19977, 7.19441, 7.18905, 7.18158, 7.13971, 7.09809, 7.05671, 7.01558, 6.97468, 6.93402, 6.8936, 6.85341,
         6.81346, 6.75741, 6.68752, 6.61836, 6.5499, 6.48216, 6.41513, 6.34833, 6.28195, 6.21627, 6.15128, 6.08696,
         6.02332, 5.96034, 5.91282, 5.87023, 5.82814, 5.78634, 5.74484, 5.73595, 41.0545, 40.1753, 39.054, 37.964,
         36.9043, 35.8732, 34.9667, 34.1577, 33.3985, 32.6604, 31.9415, 31.2364, 30.5481, 29.877, 29.234, 28.654,
         28.1256, 27.6085, 27.0998, 26.5996, 26.4824, 26.7842, 27.475, 28.1846, 28.913, 29.6607, 29.5134, 29.14,
         28.5769, 28.0236, 27.4875, 26.9684, 26.5169, 26.0924, 25.6951, 25.3041, 24.9191, 24.5398, 24.1663, 23.7984,
         23.436, 23.0794, 22.7281, 22.3822, 22.0112, 21.6137, 21.1837, 20.7624, 20.3494, 19.9446, 19.5476, 19.1587,
         18.7776, 18.404, 18.0362, 17.6733, 17.308, 16.9489, 16.5972, 16.2527, 15.9154, 15.5853, 15.2617, 14.9449,
         14.6348, 14.3258, 14.0217, 13.7229, 13.4301, 13.1435, 12.8632, 12.5888, 12.3204, 12.0579, 11.805, 11.5499,
         11.2994, 11.0536, 10.8127, 10.5763, 10.344, 10.1165, 9.89337, 9.6743, 9.4595, 9.24862, 9.04206, 8.83919,
         8.64043, 8.44526, 8.25386, 8.06607, 7.88234, 7.70179, 7.52474, 7.3511, 7.1807, 7.01362, 6.84971, 6.68903,
         6.53139, 6.37671, 6.22507, 6.07632, 5.9304, 5.78727, 5.6469, 5.5092, 5.37413, 5.24167, 5.11168, 4.98418,
         4.85918, 4.73645, 4.61609, 4.4981, 4.38229, 4.26868, 4.15724, 4.04789, 3.94061, 3.83546, 3.73217, 3.63082,
         3.53148, 3.47842, 10.8948, 10.7676, 10.4912, 10.2219, 9.9596, 9.84242, 13.4276, 13.2369, 12.8921, 12.5565,
         12.2295, 12.0285, 13.9623, 13.8381, 13.5072, 13.1822, 12.8636, 12.5511, 12.2445, 11.944, 11.6495, 11.361,
         11.0785, 10.8017, 10.5308, 10.2657, 10.0063, 9.75257, 9.50438, 9.26173, 9.02454, 8.79265, 8.56596, 8.34462,
         8.12824, 7.91697, 7.71078, 7.50938, 7.31274, 7.12084, 6.93336, 6.75046, 6.57225, 6.3983, 6.22836, 6.06286,
         5.90149, 5.7441, 5.59036, 5.44083, 5.29493, 5.15276, 5.01412, 4.87897, 4.74737, 4.61915, 4.49423, 4.37252,
         4.25397, 4.1385, 4.02603, 3.9165, 3.80983, 3.70596, 3.60482, 3.50635, 3.41047, 3.31714, 3.22627, 3.13782,
         3.05172, 2.96792, 2.88636, 2.80698, 2.72972, 2.65454, 2.58138, 2.51018, 2.4409, 2.37349, 2.30791, 2.24409,
         2.182, 2.1216, 2.06283, 2.00566, 1.95003, 1.89593, 1.84329, 1.79209, 1.74228, 1.69383, 1.6467, 1.60086,
         1.55626, 1.51289, 1.4707, 1.42967, 1.38975, 1.35093, 1.31317, 1.27645, 1.24073, 1.20598, 1.17219, 1.13932,
         1.10735, 1.07626, 1.04602, 1.0166, 0.987992, 0.960164, 0.933098, 0.906772, 0.881165, 0.856258, 0.832031,
         0.808466, 0.785544, 0.763247, 0.741559, 0.720461, 0.699939]],
    'Xe':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.012, 0.012199999999999999, 0.0123193, 0.0125186, 0.012721, 0.0129268,
         0.013135899999999999, 0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973,
         0.014935, 0.0151765, 0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805,
         0.0172551, 0.0175342, 0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988,
         0.0193061, 0.0196184, 0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009,
         0.0219503, 0.0223053, 0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594,
         0.024956600000000002, 0.0253603, 0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003,
         0.0283747, 0.0288337, 0.0293, 0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002,
         0.0317475, 0.0322609, 0.0327827, 0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211,
         0.0360956, 0.0366794, 0.0372727, 0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994,
         0.0417031, 0.0423776, 0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004,
         0.04665999999999999, 0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576,
         0.051375300000000006, 0.0522062, 0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482,
         0.058411700000000004, 0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908,
         0.0643145, 0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138,
         0.07195910000000001, 0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125,
         0.0818147, 0.083138, 0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825,
         0.09153950000000001, 0.0930201, 0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077,
         0.10576, 0.107471, 0.109209, 0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245,
         0.12219, 0.124166, 0.126175, 0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002,
         0.141172, 0.143456, 0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103,
         0.165742, 0.168422, 0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442,
         0.191489, 0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365,
         0.6762999999999999, 0.6765, 0.680191, 0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928,
         0.761042, 0.773351, 0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274,
         0.879269, 0.893491, 0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229,
         1.04899, 1.06596, 1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147,
         1.27172, 1.29229, 1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001,
         1.4458900000000001, 1.46928, 1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753,
         1.72499, 1.75289, 1.78124, 1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252,
         2.05795, 2.09124, 2.12506, 2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997,
         2.41611, 2.45519, 2.4949, 2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146,
         2.8366100000000003, 2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003,
         3.22511, 3.27727, 3.33028, 3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864,
         3.8476399999999997, 3.9098699999999997, 3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498,
         4.37462, 4.44537, 4.517270000000001, 4.59033, 4.66458, 4.74003, 4.787100000000001, 4.7873, 4.8166899999999995,
         4.8946000000000005, 4.97377, 5.05421, 5.1071, 5.1073, 5.13596, 5.21903, 5.303439999999999, 5.38922, 5.4527,
         5.4529, 5.47639, 5.564970000000001, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981,
         6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922,
         7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569,
         8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999,
         9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942,
         11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025,
         13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, 9.24787, 9.15401, 9.05665, 8.95659, 8.85495, 8.75252, 8.66863, 8.56578, 8.43921, 8.30286, 8.15845,
         8.00686, 7.84855, 7.68358, 7.50428, 7.32127, 7.14335, 6.96445, 6.77222, 6.57704, 6.39261, 6.21168, 6.02982,
         5.84214, 5.65382, 5.46429, 5.27081, 5.07147, 4.85931, 4.64081, 4.41909, 4.18957, 3.94228, 3.68733, 3.42626,
         3.15172, 2.85945, 2.55235, 2.2278, 1.87892, 1.49957, 1.0879, 0.635603, 0.128885, -0.469527, -1.17074, -2.01898,
         -3.32953, -4.78492, -6.07324, -4.99111, -3.14174, -2.75421, -3.3389, -4.96733, -6.42927, -7.44364, -8.36901,
         -9.20709, -9.88767, -10.2734, -10.5619, -10.5638, -10.3859, -10.1979, -9.86862, -8.89494, -7.87394, -6.97134,
         -5.91492, -4.32097, -2.54196, -0.817933, 1.0918, 3.61712, 6.04274, 8.20609, 10.4756, 13.1326, 15.6864, 18.0665,
         20.7633, 23.4217, 25.7865, 28.6833, 31.149, 32.7183, 33.9623, 35.1408, 36.4739, 37.1409, 37.2229, 37.0163,
         36.618, 36.0981, 35.4897, 34.827, 34.119, 33.3983, 32.6755, 31.9591, 31.2477, 30.5484, 29.8693, 29.1829,
         28.4795, 27.7506, 27.0554, 26.3968, 25.7007, 25.0692, 24.501, 23.9171, 23.3883, 22.9277, 22.4983, 22.0995,
         21.7114, 21.3291, 20.9806, 20.6692, 20.3805, 20.1117, 19.8625, 19.6316, 19.4184, 19.2267, 19.0517, 18.8896,
         18.7442, 18.6171, 18.5106, 18.446, 18.4112, 18.3738, 18.3395, 18.3173, 18.3114, 18.3514, 18.4216, 18.4756,
         18.5193, 18.5652, 18.6195, 18.6897, 18.8057, 18.9234, 19.008, 19.0713, 19.1248, 19.1713, 19.2124, 19.2493,
         19.2829, 19.3138, 19.3426, 19.3701, 19.3974, 19.4263, 19.4655, 19.5031, 19.5253, 19.5345, 19.5356, 19.5294,
         19.5164, 19.4972, 19.4722, 19.4422, 19.4082, 19.3783, 19.3645, 19.3252, 19.2438, 19.1344, 18.9992, 18.8383,
         18.6506, 18.4343, 18.1867, 17.9046, 17.5839, 17.2149, 16.7959, 16.3253, 15.7908, 15.1775, 14.4668, 13.6367,
         12.6493, 11.4392, 9.91544, 7.92458, 5.15405, 0.823389, -8.21883, -53.1265, -53.0765, -13.5912, 1.88287,
         8.50978, 12.8348, 16.0447, 18.5805, 20.6559, 22.3906, 23.846, 25.0739, 26.1402, 27.0729, 27.8731, 28.5435,
         29.0794, 29.4623, 29.6403, 29.3691, 28.8453, 28.8239, 29.3445, 30.2131, 31.8753, 33.5306, 34.5075, 35.3891,
         36.1745, 36.8886, 37.5503, 38.1725, 38.7608, 39.3204, 39.8555, 40.3704, 40.8685, 41.3542, 41.8336, 42.3199,
         42.8247, 43.3132, 43.748, 44.1298, 44.4783, 44.7999, 45.0988, 45.3774, 45.6376, 45.8813, 46.1096, 46.3237,
         46.525, 46.715, 46.8945, 47.0641, 47.224, 47.3755, 47.5192, 47.6555, 47.7891, 47.9166, 48.0323, 48.1391,
         48.2365, 48.3262, 48.4094, 48.4866, 48.5576, 48.6218, 48.6862, 48.7501, 48.8033, 48.8512, 48.8936, 48.9308,
         48.9633, 48.9913, 49.0146, 49.0333, 49.048, 49.0581, 49.0642, 49.0663, 49.0639, 49.058, 49.0477, 49.0335,
         49.0155, 48.9935, 48.9675, 48.9373, 48.9032, 48.8648, 48.8221, 48.7751, 48.7236, 48.6674, 48.6062, 48.54,
         48.4683, 48.3909, 48.3073, 48.2172, 48.12, 48.0151, 47.9017, 47.7789, 47.6459, 47.5013, 47.3434, 47.1705,
         46.9802, 46.7695, 46.5345, 46.27, 45.9693, 45.6222, 45.214, 44.7217, 44.1057, 43.2884, 42.0783, 39.6979,
         24.737, 24.7388, 38.5346, 41.4727, 42.3694, 42.2444, 35.5416, 35.5459, 42.2243, 44.2811, 45.2083, 45.604,
         42.4369, 42.4412, 45.7152, 47.251, 48.1223, 48.7967, 49.3585, 49.8423, 50.2667, 50.6436, 50.9812, 51.2854,
         51.5609, 51.8112, 52.039, 52.2471, 52.4372, 52.6112, 52.7706, 52.9165, 53.0501, 53.1725, 53.2846, 53.3871,
         53.4806, 53.566, 53.6438, 53.7145, 53.7786, 53.8364, 53.8887, 53.9356, 53.9776, 54.0148, 54.0477, 54.0765,
         54.1015, 54.1229, 54.1409, 54.1559, 54.1681, 54.1775, 54.1843, 54.1888, 54.191, 54.1911, 54.1892, 54.1856,
         54.1802, 54.1732, 54.1648, 54.1549, 54.1438, 54.1315, 54.118, 54.1035, 54.088, 54.0716, 54.0543, 54.0363,
         54.0175, 53.998, 53.9779, 53.9572, 53.936, 53.9142, 53.8919, 53.8692, 53.8461, 53.8225, 53.7986, 53.7743,
         53.7497, 53.7247, 53.6995, 53.6739, 53.648, 53.6218, 53.5952, 53.5684, 53.5413, 53.5138, 53.4861, 53.4579,
         53.4294, 53.4005, 53.3711, 53.3413, 53.311, 53.2801, 53.2486, 53.2165, 53.1836, 53.1499, 53.1153, 53.0796,
         53.0428, 53.0047, 52.9651, 52.9238, 52.8805, 52.835, 52.787, 52.7358, 52.6812, 52.6223, 52.5584, 52.4904,
         52.4028],
        [3.12014e-15, 3.17061e-15, 3.22189e-15, 3.274e-15, 3.32696e-15, 3.38077e-15, 3.43545e-15, 3.49102e-15,
         3.54748e-15, 3.60486e-15, 3.66316e-15, 3.72241e-15, 3.74417e-15, 3.07739e-05, 1.78551, 1.86163, 7.89998,
         9.28777, 10.1806, 10.845, 11.4783, 11.9987, 12.5503, 13.1464, 13.3356, 13.4705, 13.6068, 13.7445, 13.7867,
         13.6926, 13.5991, 13.5063, 13.4141, 13.2302, 12.9384, 12.653, 12.3738, 12.1009, 11.834, 11.5597, 11.262,
         10.972, 10.6895, 10.4142, 10.146, 9.88472, 9.63017, 9.38218, 9.14057, 8.90518, 8.65326, 8.24073, 7.84788,
         7.47375, 7.11745, 6.77814, 6.455, 6.14727, 5.85421, 5.57512, 5.30934, 5.05623, 4.81518, 4.58563, 4.35879,
         4.14242, 3.93679, 3.74136, 3.55564, 3.37914, 3.21139, 3.05198, 2.90047, 2.75649, 2.61117, 2.44432, 2.28813,
         2.14192, 2.00505, 1.87693, 1.75699, 1.64472, 1.53963, 1.45808, 1.38499, 1.31556, 1.24961, 1.20822, 1.1765,
         1.14562, 1.11554, 1.08702, 1.06731, 1.04795, 1.02894, 1.01028, 0.991962, 0.985351, 0.980027, 0.974732,
         0.970576, 0.97968, 0.98887, 0.998145, 1.01157, 1.02998, 1.04873, 1.06781, 1.09067, 1.11783, 1.14567, 1.1742,
         1.20343, 1.27189, 1.35847, 1.5484, 2.60003, 4.36594, 7.33114, 7.31205, 6.32607, 5.47306, 5.26332, 6.13015,
         7.13975, 8.3156, 9.68514, 11.2802, 12.9916, 14.7116, 16.6594, 18.4108, 20.2492, 22.2711, 24.3769, 25.9997,
         27.7306, 29.5766, 31.5456, 32.9879, 34.395, 35.8621, 37.0881, 37.6383, 38.1965, 38.7631, 39.104, 38.9448,
         38.7863, 38.6284, 37.6772, 36.6323, 35.6163, 33.2117, 30.9479, 28.8384, 26.8726, 24.7408, 21.9711, 19.5113,
         17.3269, 15.3871, 13.6645, 12.1347, 10.7762, 9.56974, 8.51687, 7.58211, 6.74997, 6.00916, 5.34963, 4.75853,
         4.20373, 3.71361, 3.30996, 3.00803, 2.73365, 2.50814, 2.4229, 2.34056, 2.29085, 2.32877, 2.36731, 2.42192,
         2.48194, 2.54345, 2.64107, 2.7693, 2.90375, 3.04473, 3.19362, 3.35046, 3.515, 3.68762, 3.86872, 4.05053,
         4.24019, 4.43874, 4.64658, 4.86416, 5.09193, 5.29354, 5.47387, 5.66034, 5.85316, 6.05255, 6.25872, 6.42272,
         6.54819, 6.67611, 6.80654, 6.93951, 7.07508, 7.21331, 7.2606, 7.29716, 7.33392, 7.37085, 7.40797, 7.44529,
         7.48278, 7.52047, 7.55835, 7.59641, 7.63467, 7.67313, 7.71177, 7.75061, 7.76071, 7.76418, 7.76765, 7.77112,
         7.7746, 7.77807, 7.78154, 7.78503, 7.7885, 7.79198, 7.79547, 7.78776, 7.7196, 7.65206, 7.5851, 7.51873,
         7.45294, 7.38772, 7.32308, 7.25901, 7.19549, 7.13252, 7.07011, 7.01671, 6.96779, 6.91921, 6.87097, 6.82307,
         6.7755, 6.72163, 6.65668, 6.59235, 6.52865, 6.46555, 6.40307, 6.34119, 6.30176, 40.0443, 39.7162, 38.7644,
         37.8355, 36.9287, 36.0437, 35.18, 34.3369, 33.514, 32.7108, 31.9493, 31.2468, 30.5598, 29.8878, 29.2306,
         28.5879, 27.9593, 27.3445, 26.7433, 27.122, 27.9663, 28.8369, 29.7346, 30.4358, 29.9975, 29.5656, 29.1399,
         28.7203, 28.3081, 27.9085, 27.5145, 27.1261, 26.743, 26.3655, 25.9932, 25.626, 25.2644, 24.9077, 24.556,
         24.1689, 23.7415, 23.2653, 22.7985, 22.3412, 21.8932, 21.454, 21.0235, 20.6017, 20.1883, 19.7834, 19.3868,
         18.9992, 18.6195, 18.2476, 17.8828, 17.5254, 17.1753, 16.8318, 16.4953, 16.1656, 15.8343, 15.507, 15.1843,
         14.868, 14.5584, 14.2557, 13.9588, 13.6681, 13.3835, 13.1109, 12.8333, 12.5599, 12.2914, 12.0278, 11.7689,
         11.5149, 11.2654, 11.0201, 10.7797, 10.5433, 10.3112, 10.0837, 9.85962, 9.64058, 9.42503, 9.21347, 9.0062,
         8.80231, 8.60254, 8.40617, 8.21365, 8.02469, 7.83922, 7.65729, 7.47879, 7.30363, 7.13165, 6.96295, 6.79748,
         6.63504, 6.47567, 6.3193, 6.1659, 6.01544, 5.86774, 5.72276, 5.58056, 5.4412, 5.30424, 5.16996, 5.0382, 4.9089,
         4.78203, 4.65756, 4.5355, 4.41575, 4.29816, 4.18271, 4.06953, 3.95854, 3.84952, 3.7426, 3.63771, 3.57457,
         11.23, 11.1152, 10.8198, 10.5324, 10.2525, 10.0749, 13.7396, 13.6172, 13.272, 12.9357, 12.6079, 12.3739,
         14.2726, 14.1809, 13.8442, 13.514, 13.1897, 12.8715, 12.5592, 12.253, 11.9527, 11.6584, 11.37, 11.0876,
         10.8106, 10.5397, 10.2746, 10.0151, 9.76125, 9.51281, 9.2699, 9.03234, 8.80037, 8.57347, 8.35171, 8.13507,
         7.92366, 7.71695, 7.51516, 7.3181, 7.12583, 6.93824, 6.75508, 6.57633, 6.40187, 6.23183, 6.06593, 5.90408,
         5.74633, 5.59257, 5.4427, 5.2965, 5.15401, 5.01514, 4.87979, 4.74792, 4.61942, 4.49423, 4.37228, 4.25349,
         4.13778, 4.02508, 3.91534, 3.80846, 3.70439, 3.60307, 3.50441, 3.40837, 3.31487, 3.22386, 3.13527, 3.04904,
         2.96511, 2.88344, 2.80395, 2.7266, 2.65133, 2.57808, 2.50682, 2.43748, 2.37001, 2.30437, 2.24052, 2.1784,
         2.11796, 2.05918, 2.00199, 1.94636, 1.89225, 1.83962, 1.78843, 1.73864, 1.69021, 1.64311, 1.5973, 1.55275,
         1.50942, 1.46727, 1.42629, 1.38643, 1.34767, 1.30998, 1.27332, 1.23767, 1.203, 1.16929, 1.1365, 1.10462,
         1.07361, 1.04346, 1.01414, 0.985625, 0.957896, 0.930929, 0.904706, 0.879202, 0.854402, 0.830283, 0.806827,
         0.784016]],
    'Cs':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.7265, 0.7267, 0.737008, 0.748928, 0.761042, 0.773351,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.0118, 5.012, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.3593, 5.3595, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.7142,
         5.7143999999999995, 5.74644, 5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.226439999999999,
         6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 12.6617, 12.6085, 12.5481, 12.4926, 12.44, 12.396, 12.3757, 12.3515, 12.2583, 12.1353, 12.0145, 11.8895,
         11.7594, 11.6244, 11.4846, 11.3401, 11.191, 11.0361, 10.8723, 10.7096, 10.5479, 10.3834, 10.2132, 10.0391,
         9.86795, 9.69529, 9.51862, 9.33379, 9.14415, 8.9566, 8.76513, 8.57129, 8.37109, 8.16028, 7.95248, 7.74148,
         7.52514, 7.30218, 7.06993, 6.82665, 6.57189, 6.29978, 6.00707, 5.70957, 5.40057, 5.0742, 4.7266, 4.35218,
         3.94035, 3.50225, 3.0317, 2.51696, 1.94558, 1.29762, 0.533614, -0.357045, -1.49468, -3.24563, -4.95726, -3.719,
         -4.13781, -5.36837, -6.80368, -8.07423, -9.23883, -10.286, -11.2161, -11.8243, -11.7699, -11.6737, -11.2789,
         -9.91843, -7.98196, -6.31012, -4.6155, -2.47873, 0.546025, 3.14912, 5.57355, 8.15483, 11.2353, 14.5234,
         17.5569, 20.7369, 24.2991, 28.2226, 31.7939, 34.2941, 36.1991, 37.7155, 39.053, 40.3599, 40.9448, 41.1769,
         41.0458, 40.7658, 40.2659, 39.581, 38.7677, 37.8558, 36.8901, 35.9047, 34.8971, 33.8709, 32.9803, 32.158,
         31.3883, 30.6523, 29.9134, 29.2027, 28.5437, 27.882, 27.3045, 26.7726, 26.2275, 25.7256, 25.2774, 24.8794,
         24.5306, 24.1959, 23.8552, 23.5401, 23.2313, 22.9354, 22.6597, 22.4061, 22.1754, 21.9646, 21.7737, 21.6024,
         21.449, 21.3154, 21.1979, 21.096, 21.0146, 20.9457, 20.8884, 20.8454, 20.8168, 20.7998, 20.7908, 20.794,
         20.8066, 20.8281, 20.8548, 20.8875, 20.9301, 20.9742, 21.0221, 21.0784, 21.1334, 21.1893, 21.2543, 21.3166,
         21.3765, 21.4426, 21.5057, 21.5653, 21.6252, 21.683, 21.7376, 21.7882, 21.8396, 21.889, 21.9288, 21.9642,
         21.9958, 22.0239, 22.0461, 22.0645, 22.116, 22.1252, 22.085, 22.0383, 21.9869, 21.9243, 21.85, 21.7633,
         21.6639, 21.5531, 21.428, 21.2839, 21.1132, 20.9172, 20.6937, 20.4376, 20.1426, 19.8048, 19.4177, 18.9737,
         18.4626, 17.8722, 17.1818, 16.3598, 15.3572, 14.1097, 12.5113, 10.3716, 7.25142, 1.78667, -19.3132, -44.1428,
         -44.1051, 1.69243, 9.66949, 14.284, 17.5447, 20.0496, 22.0606, 23.69, 25.0563, 26.2365, 27.2476, 28.1037,
         28.8116, 29.3411, 29.6849, 29.8885, 29.6445, 29.517, 29.79, 30.3994, 31.2384, 32.9409, 34.549, 35.5854,
         36.3974, 36.9666, 37.5261, 38.1425, 38.7507, 39.4146, 40.0574, 40.6102, 41.108, 41.5644, 41.9852, 42.3545,
         42.6929, 43.0382, 43.3837, 43.7236, 44.057, 44.3847, 44.7091, 45.0289, 45.3407, 45.6459, 45.9493, 46.2556,
         46.5774, 46.9337, 47.2497, 47.5078, 47.7435, 47.9613, 48.1674, 48.3598, 48.5359, 48.6952, 48.8406, 48.9744,
         49.0977, 49.2112, 49.3162, 49.4112, 49.5045, 49.593, 49.6719, 49.7422, 49.8052, 49.8617, 49.9117, 49.9558,
         49.9941, 50.0264, 50.0538, 50.0761, 50.0934, 50.1056, 50.1132, 50.1164, 50.1154, 50.1097, 50.0996, 50.0856,
         50.0676, 50.0454, 50.0192, 49.9889, 49.9546, 49.9162, 49.8737, 49.827, 49.7761, 49.7208, 49.661, 49.5964,
         49.5269, 49.4522, 49.372, 49.286, 49.1937, 49.0946, 48.9882, 48.8738, 48.7504, 48.6171, 48.4726, 48.3154,
         48.1436, 47.955, 47.7465, 47.5142, 47.2531, 46.9559, 46.6127, 46.2084, 45.7191, 45.1028, 44.2754, 43.0196,
         40.3216, 26.1858, 26.1877, 40.5758, 42.933, 43.7015, 43.545, 36.6044, 36.6083, 43.3943, 45.4612, 46.3919,
         46.8301, 44.0976, 44.1015, 47.149, 48.4385, 49.2361, 49.8667, 50.398, 50.859, 51.266, 51.6294, 51.9564,
         52.2522, 52.5209, 52.766, 52.9899, 53.195, 53.3829, 53.5554, 53.7138, 53.8593, 53.9928, 54.1155, 54.2281,
         54.3313, 54.4257, 54.5122, 54.5912, 54.6632, 54.7285, 54.7878, 54.8415, 54.8899, 54.933, 54.9717, 55.0059,
         55.0361, 55.0625, 55.0853, 55.1046, 55.1208, 55.134, 55.1445, 55.1524, 55.1578, 55.1609, 55.1619, 55.1608,
         55.1579, 55.1533, 55.1469, 55.1391, 55.1298, 55.1192, 55.1073, 55.0942, 55.0801, 55.0649, 55.0487, 55.0317,
         55.0139, 54.9952, 54.9759, 54.9559, 54.9352, 54.914, 54.8922, 54.8699, 54.8472, 54.8239, 54.8003, 54.7762,
         54.7518, 54.727, 54.7018, 54.6763, 54.6505, 54.6244, 54.5979, 54.5711, 54.544, 54.5166, 54.4888, 54.4607,
         54.4322, 54.4033, 54.374, 54.3443, 54.3141, 54.2834, 54.252, 54.2201, 54.1875, 54.1541, 54.1198, 54.0846,
         54.0483, 54.0108, 53.9719, 53.9314, 53.8892, 53.8449, 53.7983, 53.7489, 53.6962, 53.6397, 53.5787],
        [0.0429437, 0.04199, 0.0410574, 0.0401456, 0.039254, 0.0383822, 0.0418579, 0.0498688, 0.0629069, 0.0682259,
         0.0698775, 0.0810036, 0.106648, 0.151212, 0.230476, 0.366991, 0.528355, 0.818153, 1.024, 1.26872, 1.55155,
         1.87715, 2.37324, 2.9215, 3.66589, 4.75148, 6.96885, 8.91684, 10.5004, 11.2155, 11.9793, 12.6671, 13.3472,
         13.9057, 14.0264, 14.1482, 14.271, 14.3949, 14.5199, 14.3427, 14.1328, 13.9259, 13.7221, 13.4458, 13.1638,
         12.8878, 12.6141, 12.2232, 11.8445, 11.4775, 11.0553, 10.6269, 10.2151, 9.81922, 9.44774, 9.11072, 8.78571,
         8.4723, 8.06786, 7.5629, 7.08954, 6.74479, 6.4559, 6.1794, 5.91473, 5.65465, 5.39884, 5.1546, 4.92141, 4.70819,
         4.50744, 4.31525, 4.13125, 3.9551, 3.69912, 3.44456, 3.2373, 3.04858, 2.87087, 2.70351, 2.54592, 2.3975,
         2.25774, 2.12613, 2.00219, 1.88836, 1.79032, 1.69738, 1.60926, 1.52572, 1.45651, 1.39266, 1.33162, 1.27324,
         1.21743, 1.17795, 1.14149, 1.10795, 1.07846, 1.04975, 1.0314, 1.02037, 1.00945, 1.00071, 0.992083, 0.983527,
         0.977322, 0.971924, 0.966556, 0.975651, 0.992222, 1.00899, 1.02599, 1.04328, 1.06087, 1.08365, 1.12115,
         1.15994, 1.20007, 1.2416, 1.28456, 1.34315, 1.42961, 1.53626, 1.89574, 4.03416, 5.53633, 5.3292, 5.6066,
         6.49975, 7.81229, 9.38984, 11.2583, 13.4515, 16.0721, 18.735, 21.3926, 24.4273, 27.8924, 29.9593, 31.9914,
         34.1614, 36.4785, 38.1738, 39.2258, 40.3068, 41.4176, 42.5591, 42.7886, 42.8428, 42.897, 42.4777, 41.8125,
         39.1374, 36.4271, 33.8804, 31.3247, 28.9619, 26.2516, 23.4092, 20.7702, 18.3249, 16.1611, 14.0101, 12.1454,
         10.4602, 8.99985, 7.74341, 6.67657, 5.75697, 5.065, 4.53271, 4.05932, 3.64909, 3.28031, 2.9488, 2.72906,
         2.54023, 2.41181, 2.35284, 2.29531, 2.24818, 2.28677, 2.34777, 2.4212, 2.49692, 2.53716, 2.61356, 2.69082,
         2.77954, 2.8836, 3.01518, 3.15657, 3.30736, 3.46563, 3.63057, 3.80168, 3.97494, 4.15147, 4.32988, 4.50746,
         4.68555, 4.86103, 5.03213, 5.20297, 5.37346, 5.53261, 5.68956, 5.84707, 5.99112, 6.13181, 6.26754, 6.39575,
         6.51839, 6.63359, 6.74434, 6.84843, 6.94355, 7.03462, 7.12044, 7.1961, 7.26781, 7.33591, 7.39315, 7.44458,
         7.49296, 7.53641, 7.57213, 7.6052, 7.63714, 7.65692, 7.67186, 7.68692, 7.69656, 7.70399, 7.70723, 7.71053,
         7.7017, 7.63186, 7.58868, 7.55972, 7.53078, 7.50204, 7.47342, 7.44489, 7.41643, 7.38681, 7.35286, 7.31054,
         7.26427, 7.21831, 7.16823, 7.11603, 7.06148, 7.00682, 6.95222, 6.89799, 6.84424, 6.79051, 6.73162, 6.66508,
         6.59388, 6.52347, 6.4637, 6.4121, 6.36288, 6.30731, 6.24759, 6.24135, 36.6267, 35.8734, 35.034, 34.2143,
         33.4138, 32.6319, 31.8685, 31.1228, 30.45, 29.801, 29.1659, 28.5443, 27.936, 27.3406, 26.8236, 26.3937,
         25.9706, 26.5817, 27.2755, 27.9873, 28.7178, 29.4672, 28.9334, 28.3585, 27.7951, 27.3143, 27.0159, 26.7207,
         26.4288, 26.1401, 25.731, 25.296, 24.8684, 24.4481, 24.0348, 23.6285, 23.2687, 22.9399, 22.6158, 22.2962,
         21.9812, 21.6706, 21.3644, 21.055, 20.7468, 20.4431, 20.1439, 19.849, 19.5585, 19.2238, 18.8266, 18.4385,
         18.0585, 17.6864, 17.3218, 16.9544, 16.5912, 16.2329, 15.8826, 15.5398, 15.2042, 14.8759, 14.5548, 14.241,
         13.9396, 13.6336, 13.3331, 13.0379, 12.7488, 12.4651, 12.1869, 11.9145, 11.647, 11.385, 11.1288, 10.877,
         10.6306, 10.3889, 10.1526, 9.92095, 9.69413, 9.4715, 9.25397, 9.04112, 8.83255, 8.62823, 8.42832, 8.23261,
         8.04107, 7.85355, 7.67011, 7.4905, 7.31476, 7.14282, 6.97451, 6.80979, 6.64868, 6.49101, 6.33676, 6.18586,
         6.03824, 5.89376, 5.75255, 5.61427, 5.47904, 5.34672, 5.21726, 5.09063, 4.9668, 4.84569, 4.72718, 4.61127,
         4.4979, 4.38689, 4.27843, 4.17237, 4.06846, 3.9669, 3.86754, 3.77031, 3.67525, 3.63096, 11.1294, 10.9592,
         10.6406, 10.3315, 10.0313, 9.84, 13.572, 13.4535, 13.1154, 12.786, 12.4647, 12.2605, 13.9099, 13.7992, 13.4862,
         13.1777, 12.8739, 12.5747, 12.2802, 11.9907, 11.7061, 11.4262, 11.1512, 10.8813, 10.6164, 10.3565, 10.1016,
         9.85157, 9.60657, 9.36658, 9.1313, 8.90105, 8.67569, 8.45495, 8.2389, 8.02767, 7.82114, 7.61911, 7.42144,
         7.22849, 7.03987, 6.85567, 6.67543, 6.49972, 6.32808, 6.16049, 5.99698, 5.83732, 5.68151, 5.5295, 5.38122,
         5.23658, 5.09553, 4.95799, 4.8239, 4.69317, 4.56575, 4.44157, 4.32055, 4.20263, 4.08774, 3.97582, 3.8668,
         3.76061, 3.6572, 3.55649, 3.45843, 3.36296, 3.27001, 3.17953, 3.09145, 3.00572, 2.92229, 2.8411, 2.76209,
         2.68521, 2.6104, 2.53763, 2.46683, 2.39795, 2.33095, 2.26579, 2.20241, 2.14076, 2.08081, 2.02251, 1.96581,
         1.91068, 1.85708, 1.80496, 1.75429, 1.70502, 1.65713, 1.61057, 1.5653, 1.52131, 1.47854, 1.43697, 1.39656,
         1.35729, 1.31912, 1.28202, 1.24596, 1.21092, 1.17687, 1.14378, 1.11162, 1.08038, 1.05001, 1.0205, 0.991829,
         0.963968, 0.936897, 0.910593, 0.885035, 0.860201, 0.836073]],
    'Ba':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7801, 0.7803,
         0.7858590000000001, 0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.246899999999999, 5.2471000000000005, 5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.6235,
         5.6236999999999995, 5.654979999999999, 5.74644, 5.839390000000001, 5.9338299999999995, 5.9887,
         5.988899999999999, 6.02981, 6.12733, 6.226439999999999, 6.32715, 6.42948, 6.53348, 6.63915, 6.7465399999999995,
         6.85565, 6.96654, 7.07922, 7.19372, 7.31007, 7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879,
         8.17898, 8.31126, 8.44569, 8.58229, 8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958,
         9.60242, 9.757729999999999, 9.91555, 10.075899999999999, 10.2389, 10.4045, 10.572799999999999,
         10.743799999999998, 10.9176, 11.0942, 11.2736, 11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153,
         12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356, 13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412,
         14.5731, 14.8089, 15.048399999999999, 15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054,
         16.5691, 16.8371, 17.1094, 17.3861, 17.6674, 17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527,
         19.767400000000002, 20.0871, 20.412, 20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117,
         22.474700000000002, 22.8382, 23.2076, 23.583, 23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662,
         26.3861, 26.812900000000003, 27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998,
         29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, 16.4471, 16.4118, 16.361, 16.2972, 16.2223, 16.1385, 16.0473, 15.9507, 15.8511, 15.7525, 15.6642, 15.5952,
         15.4733, 15.326, 15.1632, 14.9892, 14.8063, 14.6162, 14.4192, 14.2124, 13.9867, 13.7788, 13.582, 13.3893,
         13.1988, 13.0094, 12.8201, 12.6304, 12.4395, 12.2468, 12.0515, 11.8526, 11.6481, 11.4328, 11.2181, 11.0025,
         10.775, 10.5511, 10.3328, 10.1173, 9.90343, 9.68751, 9.46682, 9.23752, 9.00202, 8.75803, 8.49452, 8.23364,
         7.97118, 7.70083, 7.41884, 7.11976, 6.81304, 6.49324, 6.15469, 5.79502, 5.41993, 5.02291, 4.59965, 4.14695,
         3.65522, 3.12021, 2.55199, 1.94112, 1.26884, 0.523413, -0.303533, -1.25651, -2.42703, -3.9115, -6.30092,
         -8.68491, -7.44126, -7.78417, -12.8572, -18.3425, -25.3014, -32.3295, -36.7988, -31.1338, -16.7618, -4.90253,
         2.58636, 7.60516, 11.1029, 14.0726, 24.3891, 33.0949, 38.4962, 41.6121, 43.2132, 44.2136, 44.9841, 45.2608,
         44.9648, 44.2934, 43.2137, 42.2342, 41.5073, 40.6208, 39.6145, 38.5811, 37.5278, 36.4787, 35.4563, 34.4445,
         33.4428, 32.4402, 31.5095, 30.6674, 29.8982, 29.1737, 28.4485, 27.7783, 27.1356, 26.5163, 25.9294, 25.4055,
         24.947, 24.531, 24.1441, 23.7817, 23.4388, 23.1069, 22.7953, 22.5081, 22.2424, 21.9976, 21.7713, 21.5604,
         21.3654, 21.1886, 21.0323, 20.9066, 20.7944, 20.6951, 20.6137, 20.5574, 20.5506, 20.5807, 20.5977, 20.6217,
         20.6661, 20.704, 20.7385, 20.7802, 20.8328, 20.9009, 21.0096, 21.1348, 21.2399, 21.3401, 21.4441, 21.5579,
         21.7159, 21.8753, 21.9984, 22.1041, 22.2001, 22.2901, 22.3825, 22.4646, 22.5363, 22.6023, 22.6634, 22.7205,
         22.7743, 22.8257, 22.8802, 22.9354, 22.9773, 23.0091, 23.0333, 23.0508, 23.062, 23.0674, 23.0676, 23.0634,
         23.0562, 23.0473, 23.0779, 23.0726, 23.0178, 22.9356, 22.8277, 22.6941, 22.534, 22.3455, 22.1161, 21.8618,
         21.5839, 21.2722, 20.9212, 20.5237, 20.0871, 19.5704, 18.9535, 18.224, 17.3616, 16.3003, 14.9607, 13.2144,
         10.7898, 6.99366, -1.23942, -36.0464, -36.0387, -2.48177, 7.54594, 12.2086, 15.3487, 17.7528, 19.721, 21.4009,
         22.8765, 24.2016, 25.4196, 26.5386, 27.5674, 28.5218, 29.4164, 30.2603, 31.0607, 31.8235, 32.5537, 33.2555,
         33.9328, 34.5928, 35.2364, 35.8555, 36.4535, 37.0349, 37.6023, 38.1582, 38.7048, 39.2445, 39.7803, 40.3155,
         40.8552, 41.4079, 41.9972, 42.6608, 43.2544, 43.7468, 44.2015, 44.6256, 45.0252, 45.4048, 45.7683, 46.1205,
         46.4742, 46.82, 47.1331, 47.4136, 47.6743, 47.9178, 48.1461, 48.3609, 48.5636, 48.7554, 48.9372, 49.1149,
         49.2814, 49.434, 49.5778, 49.7102, 49.8429, 49.9708, 50.0873, 50.1945, 50.2937, 50.3858, 50.4707, 50.5487,
         50.6202, 50.6853, 50.7445, 50.7978, 50.8451, 50.8876, 50.9246, 50.9561, 50.9825, 51.0045, 51.0214, 51.0334,
         51.0407, 51.0441, 51.0426, 51.0363, 51.0258, 51.0109, 50.9914, 50.9675, 50.939, 50.906, 50.8684, 50.8259,
         50.7786, 50.7262, 50.6686, 50.6055, 50.5367, 50.4618, 50.3805, 50.2923, 50.1967, 50.093, 49.9805, 49.8584,
         49.7255, 49.5806, 49.4221, 49.248, 49.0559, 48.8425, 48.6038, 48.3344, 48.0266, 47.6696, 47.2473, 46.7334,
         46.0814, 45.1951, 43.8132, 40.4393, 26.8164, 26.8174, 42.131, 44.1362, 44.8272, 44.634, 37.6496, 37.6535,
         44.4926, 46.5402, 47.439, 47.7822, 44.8521, 44.8558, 48.2474, 49.4817, 50.2716, 50.8992, 51.4293, 51.89,
         52.2971, 52.6609, 52.9885, 53.2853, 53.555, 53.8011, 54.0262, 54.2325, 54.4216, 54.5951, 54.7545, 54.9009,
         55.0356, 55.1592, 55.2725, 55.3764, 55.4717, 55.5589, 55.6383, 55.7107, 55.7766, 55.8363, 55.8901, 55.9385,
         55.9819, 56.0205, 56.0548, 56.0848, 56.111, 56.1335, 56.1526, 56.1684, 56.1813, 56.1913, 56.1986, 56.2035,
         56.206, 56.2064, 56.2047, 56.2011, 56.1957, 56.1887, 56.18, 56.1699, 56.1585, 56.1457, 56.1318, 56.1167,
         56.1007, 56.0836, 56.0656, 56.0468, 56.0273, 56.007, 55.986, 55.9643, 55.9421, 55.9193, 55.8961, 55.8723,
         55.8481, 55.8234, 55.7984, 55.7729, 55.7471, 55.721, 55.6945, 55.6677, 55.6406, 55.6131, 55.5853, 55.5573,
         55.5288, 55.5001, 55.471, 55.4415, 55.4117, 55.3814, 55.3507, 55.3195, 55.2877, 55.2554, 55.2224, 55.1887,
         55.1543, 55.1189, 55.0826, 55.0451, 55.0064, 54.9662, 54.9244, 54.8808, 54.8351, 54.7895, 54.7272],
        [0.102582, 0.107605, 0.112874, 0.118401, 0.124198, 0.13028, 0.136659, 0.14335, 0.150369, 0.157732, 0.165455,
         0.173557, 0.183338, 0.194288, 0.205891, 0.218187, 0.231218, 0.247615, 0.265218, 0.284072, 0.304267, 0.362677,
         0.420004, 0.474092, 0.533738, 0.599553, 0.666927, 0.73096, 0.693144, 0.654676, 0.627532, 0.743404, 1.51055,
         2.31632, 5.8272, 9.18758, 11.0651, 12.1706, 13.3866, 16.2715, 20.8311, 25.5391, 26.1763, 26.8294, 26.9725,
         26.6972, 26.1269, 24.8556, 23.6461, 22.4955, 21.4008, 20.3594, 19.3687, 18.4262, 17.5296, 16.6625, 15.8365,
         15.0515, 14.3054, 13.5963, 12.9224, 12.2818, 11.673, 11.0944, 10.5444, 10.0018, 9.47953, 8.98449, 8.51529,
         8.07059, 7.64914, 7.24967, 6.87108, 6.51225, 6.17216, 5.84984, 5.54435, 5.25481, 4.93304, 4.60153, 4.29229,
         4.00384, 3.73477, 3.48379, 3.24967, 3.03129, 2.82758, 2.65078, 2.50671, 2.37048, 2.24165, 2.11982, 2.00461,
         1.89566, 1.79264, 1.69521, 1.60308, 1.51596, 1.43357, 1.35565, 1.28517, 1.23309, 1.18311, 1.13822, 1.11996,
         1.10248, 1.09259, 1.08279, 1.07307, 1.06344, 1.05467, 1.05299, 1.05131, 1.05807, 1.08111, 1.10465, 1.12871,
         1.15329, 1.18423, 1.22252, 1.26205, 1.30286, 1.35385, 1.41089, 1.47033, 1.5354, 1.60409, 1.67585, 1.76771,
         1.87205, 1.98004, 2.08822, 2.20232, 2.32265, 2.40436, 2.47714, 2.62019, 2.67983, 4.95387, 9.15779, 3.46252,
         4.27233, 5.81709, 9.46539, 17.3378, 35.0848, 48.0307, 57.2602, 58.1327, 56.7582, 54.9013, 54.0482, 56.8675,
         59.2316, 54.9399, 49.1254, 43.206, 38.2524, 33.9584, 30.1464, 26.1964, 22.7133, 19.5972, 16.9951, 15.015,
         13.1863, 11.3566, 9.78092, 8.399, 7.20139, 6.17454, 5.29133, 4.5232, 3.88064, 3.32555, 3.00542, 2.7161,
         2.48691, 2.27878, 2.11933, 2.01565, 1.95126, 1.93172, 1.95618, 2.05346, 2.15559, 2.2589, 2.36442, 2.47486,
         2.59047, 2.71217, 2.8612, 3.01842, 3.18428, 3.35926, 3.53807, 3.72516, 3.92214, 4.12954, 4.3479, 4.57454,
         4.7889, 5.0133, 5.24822, 5.49414, 5.75159, 5.95964, 6.14489, 6.3359, 6.50912, 6.66816, 6.83109, 6.99799,
         7.16898, 7.34414, 7.52358, 7.64774, 7.75537, 7.86453, 7.97523, 8.08748, 8.20132, 8.23661, 8.25766, 8.27877,
         8.29992, 8.32114, 8.33827, 8.3454, 8.35254, 8.35969, 8.36685, 8.374, 8.38117, 8.38835, 8.39552, 8.3901,
         8.37524, 8.36041, 8.34559, 8.33081, 8.31606, 8.30132, 8.28662, 8.27194, 8.25728, 8.24266, 8.21598, 8.12164,
         8.02838, 7.93619, 7.84506, 7.75498, 7.66593, 7.5779, 7.49307, 7.42815, 7.3638, 7.30001, 7.23676, 7.17406,
         7.10649, 7.0158, 6.92626, 6.83786, 6.74705, 6.64215, 6.53888, 6.43722, 6.33714, 6.23862, 6.14162, 6.08973,
         32.0919, 32.0024, 31.801, 31.6009, 31.4021, 31.2046, 31.0083, 30.8132, 30.6193, 30.4267, 30.2353, 30.0149,
         29.793, 29.5728, 29.3541, 29.1371, 28.9217, 28.7079, 28.4957, 28.285, 28.0759, 27.8683, 27.6539, 27.4321,
         27.2122, 26.994, 26.7776, 26.5629, 26.3499, 26.1386, 25.9291, 25.7211, 25.5149, 25.3103, 25.1074, 24.814,
         24.3966, 23.9862, 23.5827, 23.186, 22.796, 22.4125, 22.0355, 21.6648, 21.3003, 20.9032, 20.4947, 20.0941,
         19.7014, 19.3164, 18.9389, 18.5687, 18.2059, 17.85, 17.5012, 17.158, 16.8133, 16.4754, 16.1444, 15.8199,
         15.5102, 15.1902, 14.8756, 14.5658, 14.2614, 13.9618, 13.6668, 13.377, 13.0919, 12.8117, 12.5365, 12.2656,
         11.9996, 11.7387, 11.4817, 11.2295, 10.9817, 10.7388, 10.4995, 10.265, 10.0347, 9.80897, 9.58613, 9.36838,
         9.15433, 8.94429, 8.73803, 8.53562, 8.33696, 8.14208, 7.95075, 7.76298, 7.57878, 7.39806, 7.22064, 7.04664,
         6.8759, 6.70833, 6.54405, 6.38282, 6.22461, 6.06941, 5.91715, 5.7678, 5.62134, 5.47759, 5.33659, 5.19832,
         5.06265, 4.92952, 4.79903, 4.67103, 4.54529, 4.42211, 4.30125, 4.18269, 4.06638, 3.95224, 3.8403, 3.73058,
         3.69486, 11.3018, 11.0891, 10.7771, 10.474, 10.1793, 9.99166, 13.7185, 13.5917, 13.2315, 12.8809, 12.5394,
         12.3476, 14.0776, 13.9432, 13.6314, 13.3239, 13.0205, 12.7216, 12.4269, 12.1367, 11.8513, 11.5704, 11.2943,
         11.0228, 10.7562, 10.4945, 10.2375, 9.98525, 9.73791, 9.49546, 9.25799, 9.02501, 8.79689, 8.57343, 8.35485,
         8.14094, 7.9314, 7.72653, 7.52636, 7.33034, 7.13886, 6.95164, 6.76883, 6.5902, 6.4158, 6.24546, 6.07915,
         5.91682, 5.75838, 5.60379, 5.45295, 5.30582, 5.16231, 5.02236, 4.88591, 4.75287, 4.6232, 4.49681, 4.37364,
         4.25362, 4.13669, 4.02278, 3.91182, 3.80376, 3.69851, 3.59604, 3.49626, 3.39912, 3.30456, 3.21252, 3.12293,
         3.03575, 2.95091, 2.86836, 2.78805, 2.70991, 2.63389, 2.55995, 2.48804, 2.41809, 2.35006, 2.28391, 2.21959,
         2.15704, 2.09623, 2.03711, 1.97964, 1.92377, 1.86946, 1.81667, 1.76536, 1.71549, 1.66703, 1.61993, 1.57417,
         1.5297, 1.48648, 1.4445, 1.40371, 1.36407, 1.32557, 1.28817, 1.25183, 1.21653, 1.18224, 1.14894, 1.11659,
         1.08517, 1.05465, 1.02501, 0.996231, 0.968276, 0.941128, 0.914765]],
    'La':                                                                           [
        [0.01, 0.0101152, 0.0102317, 0.0103496, 0.0104688, 0.010589399999999999, 0.0107114, 0.0108348, 0.0109596,
         0.011085900000000001, 0.011213599999999999, 0.0113428, 0.0114734, 0.0116056, 0.0117393, 0.0118745, 0.0120113,
         0.0121497, 0.0122897, 0.0124312, 0.012574400000000001, 0.012719300000000001, 0.0128658, 0.013014, 0.013164,
         0.0133156, 0.013469, 0.0136242, 0.013781100000000001, 0.0139399, 0.0141005, 0.0142629, 0.0144272,
         0.014593400000000001, 0.0147615, 0.0149316, 0.0151036, 0.015277599999999999, 0.0154536, 0.0156316, 0.0158117,
         0.0159938, 0.0161781, 0.0163644, 0.016552900000000002, 0.0167436, 0.0169365, 0.0171316, 0.017329,
         0.017528600000000002, 0.0177305, 0.0179348, 0.018141400000000002, 0.0183504, 0.018561800000000003, 0.0187756,
         0.018991900000000003, 0.0192107, 0.019431999999999998, 0.019655799999999998, 0.019882300000000002, 0.0201113,
         0.020343, 0.0205773, 0.0208144, 0.021054200000000002, 0.021296700000000002, 0.0215421, 0.0217902, 0.0220412,
         0.0222952, 0.022552, 0.0228118, 0.0230746, 0.023340399999999997, 0.0236093, 0.023881199999999998, 0.0241564,
         0.0244346, 0.0247161, 0.0250008, 0.025288900000000003, 0.0255802, 0.0258749, 0.0261729, 0.0264744, 0.0267794,
         0.0270879, 0.027399999999999997, 0.0277156, 0.0280349, 0.028357900000000002, 0.028684499999999998, 0.029015,
         0.0293492, 0.0296873, 0.0300293, 0.0303753, 0.0307252, 0.031079100000000002, 0.0314372, 0.031799299999999996,
         0.032165599999999996, 0.0325362, 0.032911, 0.0332901, 0.0336736, 0.0340616, 0.034453899999999996, 0.0348508,
         0.0352523, 0.0356584, 0.0360692, 0.036484699999999995, 0.036905, 0.0373302, 0.0377602, 0.0381952,
         0.038635199999999995, 0.0390803, 0.0395305, 0.0399859, 0.0404465, 0.0409124, 0.041383699999999995, 0.0418605,
         0.042342700000000004, 0.0428305, 0.0433239, 0.043823, 0.0443278, 0.0448385, 0.045355, 0.045877499999999995,
         0.046405999999999996, 0.046940600000000006, 0.0474813, 0.0480283, 0.0485816, 0.0491413, 0.0497074, 0.05028,
         0.0508592, 0.051445099999999994, 0.0520377, 0.0526372, 0.0532436, 0.053857, 0.0544774, 0.055104999999999994,
         0.0557398, 0.0563819, 0.057031399999999996, 0.0576884, 0.058353, 0.0590252, 0.059705100000000004, 0.0603929,
         0.0610887, 0.0617924, 0.0625042, 0.0632243, 0.0639526, 0.0646893, 0.06543460000000001, 0.06618840000000001,
         0.0669508, 0.0677221, 0.0685023, 0.06929139999999999, 0.0700896, 0.07089709999999999, 0.07171380000000001,
         0.0725399, 0.0733756, 0.0742209, 0.0750759, 0.0759407, 0.0768156, 0.0777005, 0.0785956, 0.079501, 0.0804168,
         0.08134319999999999, 0.0822803, 0.0832282, 0.0841869, 0.0851568, 0.0861378, 0.0871301, 0.0881338,
         0.08914910000000001, 0.09017610000000001, 0.0912149, 0.09226569999999999, 0.0933286, 0.09440370000000001,
         0.09549120000000001, 0.0965913, 0.097704, 0.0988296, 0.0999681, 0.10112, 0.102285, 0.103463, 0.104655, 0.10586,
         0.10708, 0.108313, 0.109561, 0.110753, 0.112008, 0.113298, 0.113476, 0.11448699999999999, 0.115135,
         0.11586199999999999, 0.11656699999999999, 0.11791, 0.119268, 0.120642, 0.122032, 0.123438, 0.12486, 0.126298,
         0.127753, 0.129225, 0.130713, 0.132219, 0.133742, 0.135283, 0.13684100000000002, 0.138418, 0.140012, 0.141625,
         0.143257, 0.144907, 0.14657599999999998, 0.14826499999999998, 0.14997300000000002, 0.151701, 0.153448,
         0.15521600000000002, 0.15700399999999998, 0.15881299999999998, 0.160642, 0.162493, 0.164365,
         0.16625800000000002, 0.168173, 0.17011099999999998, 0.17207, 0.17405299999999999, 0.176058,
         0.17808600000000002, 0.180137, 0.18221299999999999, 0.184312, 0.186435, 0.188583, 0.190755, 0.192953,
         0.19517500000000002, 0.19742400000000002, 0.19969800000000001, 0.20199899999999998, 0.20432599999999998,
         0.206679, 0.20906, 0.211469, 0.213905, 0.216369, 0.218862, 0.221383, 0.223933, 0.226513, 0.22912200000000002,
         0.231762, 0.234432, 0.237132, 0.239864, 0.242627, 0.245422, 0.248249, 0.251109, 0.254002, 0.256928,
         0.25988799999999995, 0.262882, 0.26591000000000004, 0.268973, 0.272072, 0.275206, 0.278377, 0.281583, 0.284827,
         0.28810800000000003, 0.29142700000000005, 0.294785, 0.298181, 0.301616, 0.30509, 0.308605, 0.31216000000000005,
         0.315756, 0.319393, 0.323073, 0.326794, 0.33055900000000005, 0.334367, 0.338219, 0.342115, 0.346056, 0.350043,
         0.354075, 0.358154, 0.36228, 0.366454, 0.37067500000000003, 0.374945, 0.37926499999999996, 0.38363400000000003,
         0.388053, 0.392523, 0.39704500000000004, 0.401619, 0.406246, 0.410926, 0.41566000000000003, 0.420448, 0.425291,
         0.430191, 0.435147, 0.44015899999999997, 0.44523, 0.45035899999999995, 0.45554700000000004, 0.460795, 0.466103,
         0.47147300000000003, 0.476904, 0.48239800000000005, 0.48795499999999997, 0.493576, 0.499262, 0.505014,
         0.510831, 0.516716, 0.5226689999999999, 0.5286900000000001, 0.5347799999999999, 0.540941, 0.547172, 0.553476,
         0.559852, 0.566301, 0.572825, 0.5794239999999999, 0.586099, 0.592851, 0.59968, 0.606589, 0.613576, 0.620645,
         0.627795, 0.635027, 0.642342, 0.6497419999999999, 0.657227, 0.664798, 0.672456, 0.680203, 0.688039,
         0.6959650000000001, 0.703982, 0.712092, 0.720296, 0.7285929999999999, 0.736987, 0.745477, 0.754064, 0.762751,
         0.7715380000000001, 0.7804260000000001, 0.789416, 0.7985099999999999, 0.8077089999999999, 0.817014, 0.826426,
         0.8359, 0.8361000000000001, 0.845576, 0.855317, 0.86517, 0.8751369999999999, 0.8852190000000001,
         0.8954160000000001, 0.905731, 0.916165, 0.9267190000000001, 0.937395, 0.948194, 0.959117, 0.9701660000000001,
         0.9813419999999999, 0.9926470000000001, 1.00408, 1.01565, 1.02735, 1.03918, 1.05116, 1.059, 1.067,
         1.0792899999999999, 1.09173, 1.1043, 1.11702, 1.12989, 1.14291, 1.15607, 1.1693900000000002,
         1.1828599999999998, 1.19649, 1.21027, 1.22421, 1.2383199999999999, 1.25258, 1.26701, 1.28161,
         1.2963699999999998, 1.31131, 1.32641, 1.34169, 1.35715, 1.37278, 1.3885999999999998, 1.40459, 1.42077, 1.43714,
         1.4537, 1.47044, 1.4873800000000001, 1.50452, 1.52185, 1.5393800000000002, 1.5571199999999998, 1.57505, 1.5932,
         1.61155, 1.6301199999999998, 1.6488900000000002, 1.66789, 1.6870999999999998, 1.70654, 1.7262,
         1.7460799999999999, 1.7662, 1.7865499999999999, 1.8071300000000001, 1.8279400000000001, 1.849,
         1.8702999999999999, 1.8918499999999998, 1.91364, 1.9356900000000001, 1.9579900000000001, 1.98054, 2.00336,
         2.02644, 2.04978, 2.07339, 2.09728, 2.12144, 2.14588, 2.1706, 2.1955999999999998, 2.2209, 2.24648, 2.27236,
         2.29854, 2.32502, 2.3518000000000003, 2.3788899999999997, 2.4063000000000003, 2.43402, 2.46206, 2.49042,
         2.51911, 2.54813, 2.57748, 2.60718, 2.63721, 2.66759, 2.6983200000000003, 2.7294099999999997, 2.76085, 2.79265,
         2.8248200000000003, 2.8573600000000003, 2.89028, 2.92358, 2.95726, 2.99132, 3.02578, 3.06064, 3.0959, 3.13156,
         3.16764, 3.20413, 3.24104, 3.2783800000000003, 3.31614, 3.3543499999999997, 3.3929899999999997, 3.43207,
         3.47161, 3.5116, 3.55206, 3.59298, 3.63437, 3.67624, 3.7185900000000003, 3.76142, 3.80475, 3.84858, 3.89292,
         3.93777, 3.98313, 4.02901, 4.07543, 4.12238, 4.1698699999999995, 4.217899999999999, 4.26649, 4.31564, 4.36536,
         4.415649999999999, 4.46651, 4.51797, 4.57001, 4.62266, 4.67591, 4.72978, 4.78427, 4.83938, 4.89513, 4.95152,
         5.00856, 5.066260000000001, 5.12462, 5.18366, 5.24337, 5.30378, 5.36488, 5.42668, 5.482600000000001, 5.4828,
         5.48919, 5.55243, 5.61639, 5.68109, 5.7465399999999995, 5.81274, 5.8797, 5.8905, 5.8907, 5.947430000000001,
         6.01595, 6.08525, 6.15535, 6.22626, 6.2661999999999995, 6.2664, 6.2979899999999995, 6.37054, 6.44393, 6.51816,
         6.59325, 6.6692, 6.746029999999999, 6.82374, 6.90235, 6.98187, 7.0623000000000005, 7.14366, 7.22595,
         7.309189999999999, 7.39339, 7.478560000000001, 7.56472, 7.65186, 7.74001, 7.82918, 7.91937, 8.0106, 8.10288,
         8.196219999999999, 8.29064, 8.386149999999999, 8.48276, 8.58048, 8.67933, 8.779309999999999, 8.880450000000002,
         8.98275, 9.086229999999999, 9.1909, 9.29678, 9.40388, 9.51221, 9.62179, 9.732629999999999, 9.84475, 9.95816,
         10.072899999999999, 10.1889, 10.306299999999998, 10.425, 10.5451, 10.6666, 10.7895, 10.913799999999998,
         11.0395, 11.1667, 11.2953, 11.4254, 11.557, 11.6902, 11.8249, 11.9611, 12.0989, 12.2382, 12.3792,
         12.521799999999999, 12.6661, 12.812, 12.9596, 13.1089, 13.2599, 13.412600000000001, 13.567200000000001,
         13.7234, 13.8815, 14.0415, 14.2032, 14.3668, 14.5323, 14.6997, 14.8691, 15.0404, 15.2136, 15.3889, 15.5662,
         15.7455, 15.9269, 16.1104, 16.296, 16.483700000000002, 16.673599999999997, 16.8657, 17.059900000000003,
         17.2565, 17.455299999999998, 17.656299999999998, 17.8598, 18.0655, 18.2736, 18.484099999999998, 18.6971,
         18.9124, 19.1303, 19.3507, 19.5736, 19.7991, 20.0272, 20.257900000000003, 20.4913, 20.7273, 20.966099999999997,
         21.2076, 21.451900000000002, 21.699099999999998, 21.949, 22.201900000000002, 22.4576, 22.7163, 22.978, 23.2427,
         23.5105, 23.781299999999998, 24.0553, 24.3324, 24.6127, 24.8963, 25.1831, 25.473200000000002,
         25.766599999999997, 26.0634, 26.3637, 26.6674, 26.9746, 27.2853, 27.599700000000002, 27.9176, 28.2392, 28.5645,
         28.8936, 29.2264, 29.5631, 29.9037, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan,
         nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, nan, -1.79121, -1.82933, -1.78838, -1.69795,
         -1.49715, -1.23425, -0.976246, -0.616646, -0.130074, 0.24802, 0.431907, 0.529037, 0.279724, -0.0506484,
         -0.019547, 0.22158, 0.800529, 1.47325, 2.01294, 2.63332, 3.42045, 4.21534, 4.88506, 5.56798, 6.27745, 7.03911,
         7.90654, 9.01263, 10.1694, 11.0831, 12.0748, 12.9204, 13.386, 13.7129, 13.8314, 13.8898, 14.0493, 14.1877,
         14.3097, 14.4124, 14.4938, 14.5494, 14.5654, 14.5784, 14.6175, 14.6541, 14.6882, 14.7188, 14.7455, 14.7683,
         14.7916, 14.8092, 14.813, 14.8095, 14.7986, 14.7798, 14.7522, 14.7103, 14.6525, 14.6043, 14.5741, 14.5479,
         14.5253, 14.5057, 14.4892, 14.4763, 14.4682, 14.4662, 14.4943, 14.5347, 14.5377, 14.5136, 14.4747, 14.4253,
         14.3682, 14.307, 14.2405, 14.1639, 14.081, 13.9939, 13.9112, 13.8285, 13.7271, 13.6068, 13.4735, 13.3284,
         13.1552, 12.9707, 12.811, 12.6598, 12.512, 12.3646, 12.2146, 12.0575, 11.8993, 11.7508, 11.6047, 11.4587,
         11.3111, 11.1604, 10.9981, 10.8343, 10.6834, 10.5331, 10.383, 10.2321, 10.0795, 9.9244, 9.76607, 9.60479,
         9.44027, 9.27146, 9.09773, 8.91835, 8.73255, 8.53933, 8.33733, 8.12352, 7.89592, 7.66401, 7.42985, 7.1872,
         6.93453, 6.67007, 6.38633, 6.0874, 5.78356, 5.46623, 5.13293, 4.78079, 4.40618, 4.00182, 3.56799, 3.11724,
         2.63966, 2.1283, 1.57223, 0.960925, 0.301845, -0.387288, -1.11681, -1.91023, -2.80789, -3.82402, -5.01836,
         -6.36189, -7.82554, -9.54043, -11.5661, -13.885, -16.6642, -19.946, -24.2469, -29.5441, -37.0213, -44.9382,
         -45.7486, -49.3629, -49.9598, -47.3043, -42.1393, -27.2761, -8.50698, 8.02545, 21.2467, 31.6587, 37.3297,
         40.1229, 41.7191, 43.2594, 44.3881, 45.1299, 45.7654, 46.4496, 47.0668, 47.3056, 47.283, 47.094, 46.5839,
         45.8404, 44.902, 43.9595, 43.1502, 42.3491, 41.5726, 40.8274, 40.0785, 39.2998, 38.522, 37.7494, 36.9886,
         36.2388, 35.4998, 34.7722, 34.0638, 33.37, 32.647, 31.9454, 31.3329, 30.7368, 30.1266, 29.5274, 28.9576,
         28.3677, 27.787, 27.281, 26.7856, 26.3126, 25.9028, 25.5325, 25.1946, 24.8823, 24.6018, 24.3445, 24.0956,
         23.8618, 23.6437, 23.4426, 23.2658, 23.1132, 22.9681, 22.823, 22.6847, 22.5553, 22.4357, 22.3271, 22.2363,
         22.1598, 22.0868, 22.0186, 21.9586, 21.9085, 21.8699, 21.8451, 21.8368, 21.8482, 21.9221, 22.0228, 22.0791,
         22.1165, 22.1449, 22.1679, 22.1873, 22.2044, 22.2196, 22.2333, 22.2413, 22.2498, 22.2662, 22.2853, 22.3074,
         22.3327, 22.3612, 22.3935, 22.4299, 22.4713, 22.5191, 22.5769, 22.6514, 22.7235, 22.7809, 22.8369, 22.8916,
         22.9461, 23.001, 23.0568, 23.1141, 23.1736, 23.2364, 23.3064, 23.3799, 23.4472, 23.513, 23.5789, 23.6457,
         23.7143, 23.7855, 23.8605, 23.9408, 24.0279, 24.1502, 24.2781, 24.3635, 24.441, 24.5111, 24.5758, 24.6369,
         24.6961, 24.7566, 24.8277, 24.8976, 24.9406, 24.9705, 24.9903, 25.0013, 25.0044, 25.0004, 24.99, 24.977,
         24.9634, 24.939, 24.8926, 24.8311, 24.7556, 24.6663, 24.5628, 24.4442, 24.3084, 24.1497, 23.9778, 23.8019,
         23.6117, 23.4059, 23.1824, 22.9394, 22.6748, 22.392, 22.0848, 21.7345, 21.3328, 20.8781, 20.3634, 19.7781,
         19.1079, 18.3328, 17.4245, 16.3412, 15.0173, 13.3421, 11.1062, 7.83621, 2.02817, -39.366, -39.3275, 3.47234,
         10.3823, 14.4949, 17.4289, 19.6953, 21.5227, 23.0326, 24.2955, 25.3533, 26.2268, 26.9104, 27.3099, 27.6532,
         28.18, 28.6977, 29.2096, 29.7097, 30.1943, 30.6601, 31.1008, 31.3559, 31.6145, 32.0374, 32.4701, 32.9068,
         33.3461, 33.7874, 34.2311, 34.6779, 35.129, 35.586, 36.0512, 36.5277, 37.032, 37.5634, 38.116, 38.6867,
         39.2229, 39.7018, 40.1532, 40.5854, 41.0028, 41.4084, 41.8048, 42.1944, 42.5793, 42.9621, 43.3464, 43.7413,
         44.1487, 44.5637, 44.9886, 45.3751, 45.7069, 46.0166, 46.307, 46.581, 46.8405, 47.0873, 47.3226, 47.5477,
         47.7633, 47.9705, 48.1734, 48.3689, 48.5534, 48.7293, 48.8959, 49.0547, 49.2066, 49.3519, 49.491, 49.6242,
         49.752, 49.8747, 49.9919, 50.1032, 50.2163, 50.3283, 50.4309, 50.5288, 50.6224, 50.7118, 50.7969, 50.8778,
         50.9549, 51.0287, 51.0989, 51.1652, 51.2281, 51.2878, 51.3443, 51.3976, 51.448, 51.4952, 51.5397, 51.5817,
         51.6206, 51.6568, 51.6903, 51.7209, 51.7488, 51.7743, 51.7971, 51.8176, 51.836, 51.8521, 51.8656, 51.8765,
         51.885, 51.8914, 51.8957, 51.8977, 51.897, 51.8941, 51.8889, 51.8815, 51.8717, 51.8597, 51.8453, 51.8286,
         51.8095, 51.7879, 51.7639, 51.7373, 51.7081, 51.6764, 51.642, 51.6048, 51.5648, 51.5219, 51.4758, 51.4265,
         51.3739, 51.3179, 51.2582, 51.1946, 51.1271, 51.0552, 50.9787, 50.8973, 50.8106, 50.7183, 50.6197, 50.5146,
         50.4021, 50.2816, 50.1523, 50.013, 49.8625, 49.6995, 49.5222, 49.3284, 49.1152, 48.8792, 48.6157, 48.3183,
         47.9783, 47.5827, 47.1117, 46.5317, 45.7795, 44.7103, 42.8343, 27.0888, 27.0898, 37.4945, 43.3637, 44.8324,
         45.561, 45.8678, 45.7152, 43.8244, 38.2201, 38.2218, 46.2361, 47.4804, 48.1929, 48.6023, 48.5792, 45.3502,
         45.3515, 48.93, 50.059, 50.7579, 51.3113, 51.7812, 52.1935, 52.5619, 52.8951, 53.199, 53.478, 53.7354, 53.9738,
         54.1952, 54.4013, 54.5934, 54.773, 54.941, 55.0983, 55.2458, 55.3843, 55.5142, 55.6361, 55.7508, 55.8585,
         55.9595, 56.0546, 56.1438, 56.2276, 56.3063, 56.3802, 56.4494, 56.5141, 56.5747, 56.6315, 56.6846, 56.7341,
         56.7802, 56.823, 56.863, 56.9001, 56.9343, 56.9659, 56.9951, 57.0218, 57.0463, 57.0686, 57.0888, 57.107,
         57.1234, 57.138, 57.1509, 57.1621, 57.1718, 57.18, 57.1868, 57.1922, 57.1964, 57.1993, 57.201, 57.2017,
         57.2012, 57.1998, 57.1974, 57.194, 57.1898, 57.1848, 57.1789, 57.1723, 57.165, 57.157, 57.1483, 57.139,
         57.1292, 57.1187, 57.1077, 57.0963, 57.0843, 57.0719, 57.059, 57.0457, 57.032, 57.018, 57.0036, 56.9888,
         56.9738, 56.9584, 56.9428, 56.9268, 56.9106, 56.8942, 56.8775, 56.8606, 56.8434, 56.8261, 56.8085, 56.7908,
         56.7728, 56.7547, 56.7364, 56.718, 56.6994, 56.6806, 56.6616, 56.6425, 56.6233, 56.6038, 56.5842, 56.5645,
         56.5446, 56.5245, 56.5043, 56.4839, 56.4633, 56.4425, 56.4215, 56.4003, 56.3789, 56.3573, 56.3354, 56.3132,
         56.2908, 56.2681, 56.2451, 56.2217, 56.1979, 56.1738, 56.1492, 56.1242, 56.0987, 56.0726, 56.0459, 56.0186,
         55.9906, 55.9617, 55.9321, 55.9014, 55.8697, 55.8606],
        [3.31251, 3.28769, 3.26306, 3.23861, 3.20975, 3.15961, 3.11024, 3.06165, 3.01382, 2.96673, 2.92038, 2.87476,
         2.82984, 2.78563, 2.74211, 2.69927, 2.6571, 2.61559, 2.57473, 2.5345, 2.49468, 2.45473, 2.41543, 2.37675,
         2.3387, 2.30125, 2.2644, 2.22815, 2.19247, 2.15736, 2.12423, 2.09175, 2.05976, 2.02827, 1.99726, 1.96672,
         1.93866, 1.91242, 1.88655, 1.86102, 1.8916, 1.93675, 2.05735, 2.46207, 3.03749, 3.71287, 4.15148, 4.64191,
         5.13971, 5.64097, 6.19112, 6.65981, 7.04893, 7.42772, 7.57896, 7.73329, 7.89076, 8.24573, 8.68806, 9.15412,
         9.64519, 10.1626, 10.5908, 11.0202, 11.467, 11.7186, 11.7619, 11.8053, 11.8489, 11.8926, 12.4793, 13.2697,
         14.1102, 14.9259, 15.3899, 15.8683, 16.3616, 16.7957, 16.9891, 17.1849, 17.3828, 17.5831, 17.7856, 17.9905,
         18.1907, 17.7873, 17.3928, 16.9264, 16.0693, 15.2556, 14.4831, 13.7682, 13.3122, 12.8713, 12.445, 12.0329,
         11.6343, 11.249, 10.8765, 10.533, 10.2506, 9.9759, 9.70852, 9.44831, 9.19507, 8.94862, 8.70878, 8.47487,
         8.23565, 8.00317, 7.77725, 7.55772, 7.34438, 7.13706, 6.9356, 6.76188, 6.61628, 6.4738, 6.3344, 6.19801,
         6.06455, 5.93396, 5.80619, 5.68116, 5.55883, 5.43913, 5.27407, 5.07588, 4.88514, 4.70156, 4.52489, 4.35485,
         4.1912, 4.02526, 3.86483, 3.71079, 3.5629, 3.4209, 3.26896, 3.10442, 2.94815, 2.79976, 2.65884, 2.525, 2.43539,
         2.36619, 2.29896, 2.23364, 2.17017, 2.10851, 2.04898, 2.01241, 1.97649, 1.94122, 1.90657, 1.87255, 1.83913,
         1.8075, 1.79808, 1.78871, 1.77938, 1.77011, 1.76088, 1.7517, 1.74257, 1.73422, 1.72671, 1.71923, 1.71178,
         1.70437, 1.69698, 1.68963, 1.68231, 1.67503, 1.66777, 1.66951, 1.68076, 1.69209, 1.70349, 1.71497, 1.72652,
         1.73815, 1.7633, 1.79171, 1.82059, 1.84993, 1.87974, 1.91003, 1.94081, 1.99241, 2.04882, 2.10681, 2.16645,
         2.22778, 2.29604, 2.41223, 2.53429, 2.66253, 2.77172, 2.87768, 2.98769, 3.11949, 3.37189, 3.64471, 3.93961,
         4.41751, 4.99634, 5.82789, 6.89302, 8.36599, 10.7418, 14.9287, 25.0456, 26.8825, 37.8416, 47.756, 58.5573,
         67.9072, 82.6575, 87.8669, 86.2709, 81.9631, 74.0773, 65.7944, 58.3796, 53.4598, 49.0215, 44.9516, 41.3467,
         38.2488, 35.383, 32.3397, 29.3206, 26.5832, 23.9028, 21.359, 19.086, 17.125, 15.5672, 14.1511, 12.8638,
         11.6937, 10.6223, 9.58051, 8.64088, 7.7934, 7.02905, 6.33966, 5.71788, 5.15709, 4.65817, 4.21324, 3.81083,
         3.44684, 3.20681, 2.98988, 2.7721, 2.58213, 2.4445, 2.33343, 2.22801, 2.24956, 2.2881, 2.32731, 2.42909,
         2.55385, 2.68501, 2.8182, 2.95552, 3.09954, 3.23215, 3.36604, 3.50549, 3.65071, 3.80196, 3.95946, 4.11094,
         4.24174, 4.3767, 4.51595, 4.65964, 4.80789, 4.96086, 5.1187, 5.2695, 5.41446, 5.56342, 5.71647, 5.87373,
         6.03532, 6.20136, 6.37195, 6.54725, 6.72736, 6.82763, 6.89093, 6.95482, 7.0193, 7.08438, 7.15007, 7.21636,
         7.28327, 7.35079, 7.41936, 7.49943, 7.58037, 7.66217, 7.74487, 7.82845, 7.91294, 7.99835, 8.08466, 8.17192,
         8.26011, 8.34926, 8.42743, 8.48174, 8.53638, 8.59139, 8.64675, 8.70247, 8.75854, 8.81498, 8.87178, 8.92895,
         8.98648, 9.04439, 9.08769, 9.12966, 9.17182, 9.21418, 9.25674, 9.29949, 9.34243, 9.38558, 9.42892, 9.47246,
         9.51621, 9.49897, 9.47657, 9.45422, 9.43193, 9.40968, 9.3875, 9.36537, 9.34328, 9.32125, 9.25677, 9.19158,
         9.12685, 9.06256, 8.99873, 8.93535, 8.87242, 8.80993, 8.74788, 8.68209, 8.59276, 8.50436, 8.41686, 8.33026,
         8.24456, 8.15973, 8.07578, 7.99269, 7.91461, 7.85428, 7.79441, 7.73499, 7.67602, 7.61751, 7.55945, 7.50182,
         7.44463, 7.37633, 7.29066, 7.20598, 7.12228, 7.03956, 6.95779, 6.87698, 6.7971, 6.71815, 6.64012, 6.563,
         6.48677, 6.41143, 6.33696, 6.26336, 6.19096, 35.2147, 34.5503, 33.8879, 33.2382, 32.601, 31.976, 31.3629,
         30.7616, 30.1718, 29.5934, 29.026, 28.4695, 28.0024, 27.9119, 27.8217, 27.7317, 27.6421, 27.5528, 27.4637,
         27.3749, 27.2864, 27.2292, 27.2225, 27.2124, 27.2024, 27.1924, 27.1824, 27.1725, 27.1625, 27.1526, 27.1427,
         27.1327, 27.1227, 27.1127, 27.1029, 27.0698, 26.9983, 26.8895, 26.6837, 26.4795, 26.2769, 26.0758, 25.876,
         25.6778, 25.4813, 25.2864, 25.0929, 24.9008, 24.7102, 24.5211, 24.3102, 24.0871, 23.813, 23.4888, 23.1691,
         22.854, 22.5432, 22.2363, 21.9337, 21.6352, 21.3408, 21.0504, 20.7639, 20.4815, 20.203, 19.9216, 19.6425,
         19.3656, 19.0919, 18.8222, 18.5564, 18.2943, 18.0357, 17.7809, 17.5298, 17.2821, 17.0377, 16.7977, 16.5666,
         16.3285, 16.0927, 15.86, 15.6302, 15.4029, 15.1781, 14.9561, 14.7368, 14.5206, 14.306, 14.0943, 13.8853,
         13.6788, 13.4748, 13.2733, 13.0743, 12.8775, 12.6837, 12.4917, 12.3019, 12.1146, 11.9292, 11.746, 11.5655,
         11.3871, 11.2107, 11.0371, 10.8654, 10.6956, 10.5275, 10.3616, 10.1981, 10.0366, 9.87704, 9.71885, 9.56306,
         9.40915, 9.25711, 9.10699, 8.95871, 8.81228, 8.66765, 8.5248, 8.38357, 8.24419, 8.10652, 7.97051, 7.83621,
         7.70361, 7.57264, 7.44329, 7.3155, 7.18921, 7.06457, 6.9414, 6.8198, 6.69974, 6.58115, 6.46401, 6.34831,
         6.23396, 6.12106, 6.00952, 5.89943, 5.7907, 5.68325, 5.57726, 5.47243, 5.36892, 5.26669, 5.1657, 5.06597,
         4.96749, 4.87027, 4.77422, 4.67933, 4.58572, 4.49306, 4.4016, 4.31124, 4.22199, 4.13387, 4.04688, 3.96095,
         3.87616, 3.79218, 3.71856, 11.5446, 11.5202, 11.2831, 11.051, 10.8237, 10.601, 10.383, 10.1694, 10.1356,
         13.9402, 13.7091, 13.4381, 13.1723, 12.9118, 12.6563, 12.5159, 14.3556, 14.2496, 14.011, 13.7754, 13.5425,
         13.3125, 13.0852, 12.8608, 12.6394, 12.4208, 12.2053, 11.9925, 11.7827, 11.5758, 11.3715, 11.1702, 10.9719,
         10.7764, 10.5838, 10.394, 10.207, 10.0228, 9.84142, 9.66284, 9.48685, 9.31375, 9.14331, 8.97552, 8.81044,
         8.648, 8.48801, 8.3306, 8.17581, 8.02363, 7.874, 7.72681, 7.58198, 7.43954, 7.29968, 7.16213, 7.02685, 6.89391,
         6.76325, 6.63484, 6.50865, 6.38465, 6.26282, 6.14312, 6.02553, 5.91002, 5.79656, 5.68511, 5.57566, 5.46816,
         5.3626, 5.25894, 5.15716, 5.05723, 4.95911, 4.86279, 4.76823, 4.67541, 4.5843, 4.49487, 4.40709, 4.32095,
         4.2364, 4.15344, 4.07202, 3.99213, 3.91374, 3.83683, 3.76136, 3.68733, 3.61469, 3.54343, 3.47353, 3.40496,
         3.3377, 3.27172, 3.207, 3.14353, 3.08128, 3.02022, 2.96034, 2.90162, 2.84404, 2.78756, 2.73219, 2.67788,
         2.62464, 2.57243, 2.52124, 2.47104, 2.42183, 2.37358, 2.32628, 2.2799, 2.23444, 2.18986, 2.14617, 2.10333,
         2.06134, 2.02018, 1.97983, 1.94027, 1.9015, 1.8635, 1.82625, 1.78974, 1.75395, 1.71888, 1.6845, 1.6508,
         1.61778, 1.58541, 1.55369, 1.5226, 1.49213, 1.46227, 1.433, 1.40432, 1.37622, 1.34867, 1.32168, 1.29523,
         1.2693, 1.2439, 1.219, 1.19461, 1.1707, 1.14727, 1.12432, 1.10182, 1.07978, 1.05818, 1.03701, 1.01627,
         1.01052]],
    'Ce':                                                                           [
        [0.01, 0.0101617, 0.0103261, 0.0104931, 0.0106628, 0.0108353, 0.0110106, 0.0111886, 0.0113696, 0.0115535,
         0.0117404, 0.011930300000000001, 0.0121232, 0.0123193, 0.0125186, 0.012721, 0.0129268, 0.013135899999999999,
         0.0133483, 0.0135642, 0.0137836, 0.014006600000000001, 0.0142331, 0.0144633, 0.0146973, 0.014935, 0.0151765,
         0.015422, 0.0156714, 0.0159249, 0.016182500000000002, 0.0164442, 0.0167102, 0.0169805, 0.0172551, 0.0175342,
         0.017817799999999998, 0.018106, 0.018398900000000003, 0.018696400000000002, 0.0189988, 0.0193061, 0.0196184,
         0.0199357, 0.020258199999999997, 0.020585799999999998, 0.0209188, 0.0212571, 0.0216009, 0.0219503, 0.0223053,
         0.0226661, 0.0230327, 0.0234053, 0.0237838, 0.024168500000000002, 0.0245594, 0.024956600000000002, 0.0253603,
         0.0257705, 0.0261873, 0.0266109, 0.0270413, 0.0274786, 0.027923100000000003, 0.0283747, 0.0288337, 0.0293,
         0.029773900000000002, 0.0302555, 0.030744900000000002, 0.031242100000000002, 0.0317475, 0.0322609, 0.0327827,
         0.033313, 0.033851799999999994, 0.034399299999999994, 0.0349557, 0.0355211, 0.0360956, 0.0366794, 0.0372727,
         0.0378755, 0.0384882, 0.0391107, 0.0397432, 0.0403861, 0.041039299999999994, 0.0417031, 0.0423776,
         0.043063000000000004, 0.0437595, 0.0444673, 0.045186500000000004, 0.045917400000000004, 0.04665999999999999,
         0.047414700000000004, 0.048181600000000005, 0.0489609, 0.0497528, 0.0505576, 0.051375300000000006, 0.0522062,
         0.0530506, 0.053908700000000004, 0.0547806, 0.0556667, 0.056567, 0.057482, 0.058411700000000004,
         0.059356400000000004, 0.060316499999999995, 0.061292099999999995, 0.0622834, 0.0632908, 0.0643145,
         0.06535469999999999, 0.06641179999999999, 0.0674859, 0.0685775, 0.0696867, 0.0708138, 0.07195910000000001,
         0.07312300000000001, 0.0743057, 0.0755076, 0.0767289, 0.0779699, 0.079231, 0.0805125, 0.0818147, 0.083138,
         0.0844827, 0.08584910000000001, 0.0872377, 0.08864870000000001, 0.0900825, 0.09153950000000001, 0.0930201,
         0.0945246, 0.0960535, 0.0976071, 0.0991858, 0.10079, 0.10242, 0.104077, 0.10576, 0.107471, 0.109209,
         0.11097499999999999, 0.11277, 0.11459399999999999, 0.116448, 0.118331, 0.120245, 0.12219, 0.124166, 0.126175,
         0.128215, 0.130289, 0.132397, 0.13453800000000002, 0.136714, 0.13892500000000002, 0.141172, 0.143456,
         0.14577600000000002, 0.148134, 0.15053, 0.152964, 0.155439, 0.157953, 0.160507, 0.163103, 0.165742, 0.168422,
         0.171146, 0.173915, 0.176727, 0.17958600000000002, 0.18249100000000001, 0.185442, 0.188442, 0.191489,
         0.19458699999999998, 0.19773400000000002, 0.200932, 0.20418199999999997, 0.207485, 0.21084, 0.214251,
         0.21771600000000002, 0.221237, 0.22481600000000002, 0.228452, 0.232147, 0.235902, 0.239717, 0.243595, 0.247535,
         0.251538, 0.255607, 0.259741, 0.263942, 0.26821100000000003, 0.272549, 0.276957, 0.281437, 0.285989, 0.290615,
         0.295315, 0.30009199999999997, 0.30494499999999997, 0.309878, 0.31489, 0.319983, 0.325158, 0.330418, 0.335762,
         0.341192, 0.346711, 0.352319, 0.358017, 0.363808, 0.369692, 0.375672, 0.381748, 0.38792200000000004, 0.394197,
         0.40057299999999996, 0.407052, 0.413635, 0.42032600000000003, 0.427124, 0.434032, 0.441052, 0.448186, 0.455435,
         0.46280200000000005, 0.47028699999999996, 0.477894, 0.48562299999999997, 0.493478, 0.501459, 0.50957, 0.517812,
         0.526187, 0.534698, 0.543346, 0.552134, 0.561065, 0.5701390000000001, 0.579361, 0.5887319999999999,
         0.5982540000000001, 0.60793, 0.6177630000000001, 0.627755, 0.637908, 0.648226, 0.658711, 0.669365, 0.680191,
         0.691193, 0.702372, 0.713733, 0.7252770000000001, 0.737008, 0.748928, 0.761042, 0.773351, 0.7858590000000001,
         0.79857, 0.811486, 0.824611, 0.8379489999999999, 0.851502, 0.865274, 0.879269, 0.8837, 0.8839, 0.893491,
         0.907943, 0.922628, 0.937551, 0.952715, 0.968124, 0.983783, 0.999695, 1.01586, 1.03229, 1.04899, 1.06596,
         1.0832, 1.10072, 1.11852, 1.13661, 1.155, 1.17368, 1.19266, 1.21195, 1.23155, 1.25147, 1.27172, 1.29229,
         1.31319, 1.33443, 1.35601, 1.3779400000000002, 1.40023, 1.4228800000000001, 1.4458900000000001, 1.46928,
         1.49304, 1.51719, 1.54173, 1.56667, 1.59201, 1.61776, 1.64392, 1.67051, 1.69753, 1.72499, 1.75289, 1.78124,
         1.81005, 1.8393199999999998, 1.86907, 1.8993, 1.93002, 1.96124, 1.99296, 2.0252, 2.05795, 2.09124, 2.12506,
         2.15943, 2.19436, 2.22985, 2.26592, 2.3025700000000002, 2.33981, 2.3776599999999997, 2.41611, 2.45519, 2.4949,
         2.53526, 2.5762600000000004, 2.61793, 2.66027, 2.7033, 2.74703, 2.79146, 2.8366100000000003,
         2.8824899999999998, 2.92911, 2.97648, 3.02463, 3.07355, 3.12326, 3.1737800000000003, 3.22511, 3.27727, 3.33028,
         3.38415, 3.43888, 3.4945, 3.55102, 3.60846, 3.66682, 3.72613, 3.7864, 3.8476399999999997, 3.9098699999999997,
         3.97311, 4.03738, 4.10268, 4.169029999999999, 4.23646, 4.30498, 4.37462, 4.44537, 4.517270000000001, 4.59033,
         4.66458, 4.74003, 4.8166899999999995, 4.8946000000000005, 4.97377, 5.05421, 5.13596, 5.21903,
         5.303439999999999, 5.38922, 5.47639, 5.564970000000001, 5.654979999999999, 5.7233, 5.7235, 5.74644,
         5.839390000000001, 5.9338299999999995, 6.02981, 6.12733, 6.1641, 6.1643, 6.226439999999999, 6.32715, 6.42948,
         6.53348, 6.5487, 6.5489, 6.63915, 6.7465399999999995, 6.85565, 6.96654, 7.07922, 7.19372, 7.31007,
         7.428310000000001, 7.54845, 7.67054, 7.79461, 7.92068, 8.04879, 8.17898, 8.31126, 8.44569, 8.58229,
         8.721110000000001, 8.86216, 9.0055, 9.151159999999999, 9.29917, 9.44958, 9.60242, 9.757729999999999, 9.91555,
         10.075899999999999, 10.2389, 10.4045, 10.572799999999999, 10.743799999999998, 10.9176, 11.0942, 11.2736,
         11.4559, 11.641200000000001, 11.8295, 12.0208, 12.2153, 12.412799999999999, 12.6136, 12.8176, 13.025, 13.2356,
         13.4497, 13.667200000000001, 13.8883, 14.1129, 14.3412, 14.5731, 14.8089, 15.048399999999999,
         15.291799999999999, 15.539100000000001, 15.7904, 16.0458, 16.3054, 16.5691, 16.8371, 17.1094, 17.3861, 17.6674,
         17.9531, 18.2435, 18.5386, 18.8384, 19.143099999999997, 19.4527, 19.767400000000002, 20.0871, 20.412,
         20.742099999999997, 21.077599999999997, 21.4185, 21.765, 22.117, 22.474700000000002, 22.8382, 23.2076, 23.583,
         23.9644, 24.352, 24.745900000000002, 25.1462, 25.5529, 25.9662, 26.3861, 26.812900000000003,
         27.246599999999997, 27.6873, 28.135099999999998, 28.5902, 29.052599999999998, 29.5225, 30.0],
        [nan, nan, nan, nan, nan, nan, nan, nan, n