#ifndef __APTPACKAGE_H_2024_01_07
#define __APTPACKAGE_H_2024_01_07

#include <string>
// we would probably like to move this out of the header file, but C++ does not make this easy..
#include <apt-pkg/cachefile.h>
#include <apt-pkg/pkgrecords.h>

#include "ipackage.h"

namespace NApt
{

class AptPackage : public IPackage
{
    const std::string _name;
    const QString _emptyString;
    pkgCache* _pPkgCache;
    const pkgRecords& _recs;
    pkgCache::PkgIterator _package;
    pkgCache::VerIterator _installedVersion;
    pkgCache::VerIterator _availableVersion;
    pkgCache::DescIterator _description;
    pkgRecords::Parser& parser() const;

    const pkgCache::VerIterator& versionIter() const {
        return _availableVersion.end() ? _installedVersion : _availableVersion;
    };

    pkgCache::PkgIterator findPkgIter(const std::string& name);
    pkgCache::VerIterator availableVersionIter() const;

public:
    AptPackage(AptPackage& package);
    AptPackage(const std::string& name, pkgCache* pPkgCache, const pkgRecords& records);
    AptPackage(pkgCache::PkgIterator pkgIter, pkgCache* pPkgCache, const pkgRecords& records);

    void logAll() const;

    virtual QString name() const;
    virtual QString essential() const;
    virtual QString priority() const;
    virtual QString section() const;
    virtual QString installedSize() const;
    virtual QString maintainer() const;
    virtual QString architecture() const;
    virtual QString source() const;
    virtual QString version() const;
    virtual QString replaces() const;
    virtual QString breaks() const;
    virtual QString provides() const;
    virtual QString preDepends() const;
    virtual QString depends() const;
    virtual QString recommends() const;
    virtual QString suggests() const;
    virtual QString conflicts() const;
    virtual QString filename() const;
    virtual QString size() const;
    virtual QString md5sum() const;
    virtual QString conffiles() const;
    virtual QString description() const;
    virtual InstalledState installedState() const;
    virtual QString installedVersion() const;
    virtual QString shortDescription() const;
    virtual QString homepage() const;

    virtual uint getInstalledSize() const;
    virtual uint getSize() const;

    /** Returns true if the package appears to be valid, i.e. having at least a description. */
    bool isValid() const;
};

}
#endif // __APTPACKAGE_H_2024_01_07
