/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.picking.BasePickingNode;

public abstract class BasePrimitivePicker
extends BasePickingNode {
    protected static final int LAST_PRIMITIVE_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    protected static final String PRIMITIVE_PROTO_MSG = "Proto does not describe a primitive object type";
    protected static final String PRIMITIVE_NODE_MSG = "Node does not describe a primitive object type";
    private static final String PICK_GEOM_MSG = "The pickGeometry type is invalid for PrimitivePicker. It must be one of Box, Cone, Cylinder or Sphere";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private static HashMap validPrimitiveTypes;
    private int pickingType = 0;

    public BasePrimitivePicker() {
        super("PrimitivePicker", PICK_GEOM_MSG);
        this.validGeometryNodeNames.add("Box");
        this.validGeometryNodeNames.add("Cone");
        this.validGeometryNodeNames.add("Cylinder");
        this.validGeometryNodeNames.add("Sphere");
        this.hasChanged = new boolean[9];
    }

    public BasePrimitivePicker(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLPickingSensorNodeType)vRMLNodeType);
    }

    public int getPickingType() {
        return this.pickingType;
    }

    public void setPickingGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        String string = vRMLNodeType.getVRMLNodeName();
        Integer n = (Integer)validPrimitiveTypes.get(string);
        if (n == null) {
            if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
                this.pickingType = 0;
                throw new InvalidFieldValueException(PRIMITIVE_NODE_MSG);
            }
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            string = vRMLNodeType2.getVRMLNodeName();
            n = (Integer)validPrimitiveTypes.get(string);
            if (n == null) {
                if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
                    this.pickingType = 0;
                    throw new InvalidFieldValueException(PRIMITIVE_NODE_MSG);
                }
            } else {
                this.pickingType = n;
            }
        } else {
            this.pickingType = n;
        }
        super.setPickingGeometry(vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    static {
        nodeFields = new int[]{4, 3, 0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BasePrimitivePicker.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePrimitivePicker.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "pickingGeometry");
        BasePrimitivePicker.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFNode", "pickTarget");
        BasePrimitivePicker.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BasePrimitivePicker.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "pickedGeometry");
        BasePrimitivePicker.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BasePrimitivePicker.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "intersectionType");
        BasePrimitivePicker.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFString", "sortOrder");
        BasePrimitivePicker.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "objectType");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("pickingGeometry", n);
        fieldMap.put("set_pickingGeometry", n);
        fieldMap.put("pickingGeometry_changed", n);
        n = new Integer(4);
        fieldMap.put("pickTarget", n);
        fieldMap.put("set_pickTarget", n);
        fieldMap.put("pickTarget_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(8);
        fieldMap.put("objectType", n);
        fieldMap.put("set_objectType", n);
        fieldMap.put("objectType_changed", n);
        fieldMap.put("sortOrder", new Integer(7));
        fieldMap.put("intersectionType", new Integer(5));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("pickedGeometry", new Integer(6));
        validPrimitiveTypes = new HashMap();
        validPrimitiveTypes.put("Box", new Integer(4));
        validPrimitiveTypes.put("Cone", new Integer(5));
        validPrimitiveTypes.put("Cylinder", new Integer(6));
        validPrimitiveTypes.put("Sphere", new Integer(3));
    }
}

