/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jaxp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLReader;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.web3d.x3d.jaxp.X3DErrorHandler;
import org.web3d.x3d.jaxp.X3DSAVAdapter;
import org.xml.sax.SAXException;

public class XMLReader
implements VRMLReader {
    private static final String CONFORMANCE_PROP = "conformance";
    private static final String NAMESPACE_PROP = "useNamespaces";
    private static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    private static final String WEAK_CONFORMANCE = "weak";
    private static final String STRICT_CONFORMANCE = "strict";
    private HashMap properties = new HashMap();
    private ErrorReporter errorReporter;
    private boolean ignoreHeader;
    private SAXParserFactory parserFactory;
    private X3DSAVAdapter adapter;
    private X3DEntityResolver resolver;
    private X3DErrorHandler errorHandler;

    public XMLReader() throws org.web3d.vrml.parser.FactoryConfigurationError {
        this.properties.put(CONFORMANCE_PROP, WEAK_CONFORMANCE);
        this.properties.put(NAMESPACE_PROP, Boolean.FALSE);
        this.ignoreHeader = false;
        try {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new org.web3d.vrml.parser.FactoryConfigurationError("No SAX parser defined");
        }
        this.adapter = new X3DSAVAdapter();
        this.errorHandler = new X3DErrorHandler();
        this.resolver = new X3DEntityResolver();
    }

    public void parse(InputSource inputSource) throws IOException, VRMLException {
        Object object;
        String string = (String)this.properties.get(CONFORMANCE_PROP);
        boolean bl = string.equals(WEAK_CONFORMANCE);
        Boolean bl2 = (Boolean)this.properties.get(NAMESPACE_PROP);
        this.parserFactory.setValidating(!bl);
        this.parserFactory.setNamespaceAware(bl2);
        org.xml.sax.XMLReader xMLReader = null;
        try {
            object = this.parserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
            xMLReader.setContentHandler(this.adapter);
            xMLReader.setProperty(LEXICAL_HANDLER_PROP, this.adapter);
            xMLReader.setErrorHandler(this.errorHandler);
            xMLReader.setEntityResolver(this.resolver);
        }
        catch (Exception exception) {
            throw new IOException("Unable to configure factory as required");
        }
        object = new org.xml.sax.InputSource();
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            ((org.xml.sax.InputSource)object).setCharacterStream(reader);
        } else {
            ((org.xml.sax.InputSource)object).setByteStream(inputSource.getByteStream());
        }
        ((org.xml.sax.InputSource)object).setEncoding(inputSource.getEncoding());
        try {
            xMLReader.parse((org.xml.sax.InputSource)object);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (exception != null) {
                exception.printStackTrace(printWriter);
            } else {
                sAXException.printStackTrace(printWriter);
            }
            StringBuffer stringBuffer = new StringBuffer("SAX Error: ");
            stringBuffer.append(sAXException.toString());
            stringBuffer.append(stringWriter.toString());
            throw new VRMLException(stringBuffer.toString());
        }
    }

    public Object getProperty(String string) throws SAVNotSupportedException {
        if (!this.properties.containsKey(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) throws SAVNotSupportedException {
        if (!this.properties.containsKey(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        if (object == null) {
            throw new SAVNotSupportedException("Null values not supported");
        }
        this.properties.put(string, object);
    }

    public void setHeaderIgnore(boolean bl) {
        this.ignoreHeader = bl;
    }

    public ErrorReporter getErrorHandler() {
        return this.errorReporter;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorReporter = errorHandler;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.errorHandler.setErrorReporter(errorReporter);
    }

    public ContentHandler getContentHandler() {
        return this.adapter.getContentHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.adapter.setContentHandler(contentHandler);
    }

    public ScriptHandler getScriptHandler() {
        return this.adapter.getScriptHandler();
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.adapter.setScriptHandler(scriptHandler);
    }

    public ProtoHandler getProtoHandler() {
        return this.adapter.getProtoHandler();
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.adapter.setProtoHandler(protoHandler);
    }

    public RouteHandler getRouteHandler() {
        return this.adapter.getRouteHandler();
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.adapter.setRouteHandler(routeHandler);
    }
}

