/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtVarMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Init utility for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtVarMetaData::Init()
{
    centering = AVT_UNKNOWN_CENT;
    hasUnits = false;
    hasDataExtents = false;
    minDataExtents = 0;
    maxDataExtents = 0;

    avtVarMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Copy utility for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtVarMetaData::Copy(const avtVarMetaData &obj)
{
    centering = obj.centering;
    hasUnits = obj.hasUnits;
    units = obj.units;
    hasDataExtents = obj.hasDataExtents;
    minDataExtents = obj.minDataExtents;
    maxDataExtents = obj.maxDataExtents;
    matRestricted = obj.matRestricted;

    avtVarMetaData::SelectAll();
}

// Type map format string
const char *avtVarMetaData::TypeMapFormatString = AVTVARMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtVarMetaData::TmfsStruct = {AVTVARMETADATA_TMFS};


// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Default constructor for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData::avtVarMetaData() : 
    avtBaseVarMetaData(avtVarMetaData::TmfsStruct)
{
    avtVarMetaData::Init();
}

// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData::avtVarMetaData(private_tmfs_t tmfs) : 
    avtBaseVarMetaData(tmfs)
{
    avtVarMetaData::Init();
}

// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Copy constructor for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData::avtVarMetaData(const avtVarMetaData &obj) : 
    avtBaseVarMetaData(obj,avtVarMetaData::TmfsStruct)
{
    avtVarMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtVarMetaData::avtVarMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData::avtVarMetaData(const avtVarMetaData &obj, private_tmfs_t tmfs) : 
    avtBaseVarMetaData(obj,tmfs)
{
    avtVarMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtVarMetaData::~avtVarMetaData
//
// Purpose: 
//   Destructor for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData::~avtVarMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtVarMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtVarMetaData& 
avtVarMetaData::operator = (const avtVarMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtBaseVarMetaData::operator=(obj);

    avtVarMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtVarMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVarMetaData::operator == (const avtVarMetaData &obj) const
{
    // Create the return value
    return ((centering == obj.centering) &&
            (hasUnits == obj.hasUnits) &&
            (units == obj.units) &&
            (hasDataExtents == obj.hasDataExtents) &&
            (minDataExtents == obj.minDataExtents) &&
            (maxDataExtents == obj.maxDataExtents) &&
            (matRestricted == obj.matRestricted) &&
            avtBaseVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtVarMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVarMetaData::operator != (const avtVarMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtVarMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtVarMetaData::TypeName() const
{
    return "avtVarMetaData";
}

// ****************************************************************************
// Method: avtVarMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtVarMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtVarMetaData *tmp = (const avtVarMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtVarMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtVarMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtVarMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtVarMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtVarMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtVarMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtVarMetaData(*this);
    else
        retval = new avtVarMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtVarMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtVarMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtBaseVarMetaData::SelectAll();
    Select(ID_centering,      (void *)&centering);
    Select(ID_hasUnits,       (void *)&hasUnits);
    Select(ID_units,          (void *)&units);
    Select(ID_hasDataExtents, (void *)&hasDataExtents);
    Select(ID_minDataExtents, (void *)&minDataExtents);
    Select(ID_maxDataExtents, (void *)&maxDataExtents);
    Select(ID_matRestricted,  (void *)&matRestricted);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtVarMetaData constructor
//
//  Arguments:
//      n           The name of the variable.
//      mn          The name of the mesh the var is defined on.
//      c           The centering of the variable.
//
//  Programmer: Hank Childs
//  Creation:   August 25, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:44:42 PST 2004
//    Added units.
//
//    Kathleen Bonnell, Thu Jul 22 12:10:19 PDT 2004 
//    Initialized treatAsASCII.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Jeremy Meredith, Fri Aug 25 17:16:38 EDT 2006
//    Added enumerated scalars.
//
//    Mark C. Miller, Wed Mar 26 10:11:46 PDT 2008
//    Added initialization for other enumerated scalar options
//    and hideFromGUI.
//
// ****************************************************************************

avtVarMetaData::avtVarMetaData(private_tmfs_t tmfs, std::string n, std::string mn,
    avtCentering c) : avtBaseVarMetaData(tmfs, n, mn)
{
    avtVarMetaData::Init();
    centering = c;
}

// ****************************************************************************
//  Method: avtVarMetaData constructor
//
//  Arguments:
//      n           The name of the variable.
//      mn          The name of the mesh the var is defined on.
//      c           The centering of the variable.
//      min         The minimum value of the variable.
//      max         The maximum value of the variable.
//
//  Programmer: Hank Childs
//  Creation:   August 25, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Initialized validVariable.
//
//    Brad Whitlock, Tue Jul 20 13:45:12 PST 2004
//    Added units.
//
//    Kathleen Bonnell, Thu Jul 22 12:10:19 PDT 2004 
//    Initialized treatAsASCII.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Jeremy Meredith, Fri Aug 25 17:16:38 EDT 2006
//    Added enumerated scalars.
//
//    Mark C. Miller, Wed Mar 26 10:11:46 PDT 2008
//    Added initialization for other enumerated scalar options
//    and hideFromGUI.
//
// ****************************************************************************

avtVarMetaData::avtVarMetaData(private_tmfs_t tmfs, std::string n, std::string mn,
    avtCentering c, double min, double max) : avtBaseVarMetaData(tmfs, n, mn)
{
    avtVarMetaData::Init();
    centering = c;
    double  extents[2] = { min, max };
    SetExtents(extents);
}

// ****************************************************************************
//  Method: avtVarMetaData::SetExtents
//
//  Purpose:
//      Sets the extents of the scalar variable.
//
//  Arguments:
//      extents     Extents as <min value, max value>.
//
//  Programmer: Hank Childs
//  Creation:   August 30, 2000
//
//  Modifications:
//
//    Hank Childs, Tue May  1 12:53:10 PDT 2001
//    Check for NULL extents.
//
// ****************************************************************************

void
avtVarMetaData::SetExtents(const double *extents)
{
    if (extents == NULL)
    {
        hasDataExtents = false;
    }
    else
    {
        hasDataExtents = true;
        minDataExtents = extents[0];
        maxDataExtents = extents[1];
    }
}

void
avtVarMetaData::UnsetExtents()
{
    hasDataExtents = false;
}

// ****************************************************************************
//  Method: avtVarMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    August 28, 2000
//
//  Modifications:
//    Hank Childs, Mon Dec  9 17:04:39 PST 2002
//    Print out validVariable.
//
//    Kathleen Bonnell, Thu Jul 22 12:10:19 PDT 2004 
//    Print out treatAsASCII.
//
//    Brad Whitlock, Tue Jul 20 13:47:04 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
//    Jeremy Meredith, Fri Aug 25 17:16:38 EDT 2006
//    Added enumerated scalars.
//
//    Mark C. Miller, Thu Oct 21 17:15:46 PDT 2010
//    Added mat-restricted information.
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}

void
avtVarMetaData::Print(ostream &out, int indent) const
{

    avtBaseVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Centering = ";
    switch (centering)
    {
      case AVT_NODECENT:
        out << "node centered.";
        break;

      case AVT_ZONECENT:
        out << "zone centered.";
        break;

      case AVT_UNKNOWN_CENT:
      default:
        out << "unknown centering.";
        break;
    }
    out << endl;

    if(hasUnits)
    {
        Indent(out, indent);
        out << "Units are: " << units.c_str() << endl;
    }

    if (hasDataExtents)
    {
        Indent(out, indent);
        out << "Extents are: (" << minDataExtents << ", " 
            << maxDataExtents << ")" << endl;
    }
    else
    {
        Indent(out, indent);
        out << "The extents are not set." << endl;
    }

    if (matRestricted.size())
    {
        Indent(out, indent);
        out << "Restricted to material indices: " << matRestricted[0];
        for (size_t i = 1; i < matRestricted.size(); i++)
        {
            out << ", " << matRestricted[i];
            if (i%20 == 0)
            {
                out << endl;
                Indent(out, indent);
            }
        }
        out << endl;
    }
}

