/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AxisLabels.h>
#include <DataNode.h>

// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Init utility for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AxisLabels::Init()
{
    visible = true;
    scaling = 0;

    AxisLabels::SelectAll();
}

// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Copy utility for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AxisLabels::Copy(const AxisLabels &obj)
{
    visible = obj.visible;
    font = obj.font;
    scaling = obj.scaling;

    AxisLabels::SelectAll();
}

// Type map format string
const char *AxisLabels::TypeMapFormatString = AXISLABELS_TMFS;
const AttributeGroup::private_tmfs_t AxisLabels::TmfsStruct = {AXISLABELS_TMFS};


// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Default constructor for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels::AxisLabels() : 
    AttributeSubject(AxisLabels::TypeMapFormatString)
{
    AxisLabels::Init();
}

// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Constructor for the derived classes of AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels::AxisLabels(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AxisLabels::Init();
}

// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Copy constructor for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels::AxisLabels(const AxisLabels &obj) : 
    AttributeSubject(AxisLabels::TypeMapFormatString)
{
    AxisLabels::Copy(obj);
}

// ****************************************************************************
// Method: AxisLabels::AxisLabels
//
// Purpose: 
//   Copy constructor for derived classes of the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels::AxisLabels(const AxisLabels &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AxisLabels::Copy(obj);
}

// ****************************************************************************
// Method: AxisLabels::~AxisLabels
//
// Purpose: 
//   Destructor for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels::~AxisLabels()
{
    // nothing here
}

// ****************************************************************************
// Method: AxisLabels::operator = 
//
// Purpose: 
//   Assignment operator for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisLabels& 
AxisLabels::operator = (const AxisLabels &obj)
{
    if (this == &obj) return *this;

    AxisLabels::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AxisLabels::operator == 
//
// Purpose: 
//   Comparison operator == for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisLabels::operator == (const AxisLabels &obj) const
{
    // Create the return value
    return ((visible == obj.visible) &&
            (font == obj.font) &&
            (scaling == obj.scaling));
}

// ****************************************************************************
// Method: AxisLabels::operator != 
//
// Purpose: 
//   Comparison operator != for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisLabels::operator != (const AxisLabels &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxisLabels::TypeName
//
// Purpose: 
//   Type name method for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AxisLabels::TypeName() const
{
    return "AxisLabels";
}

// ****************************************************************************
// Method: AxisLabels::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisLabels::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxisLabels *tmp = (const AxisLabels *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxisLabels::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisLabels::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxisLabels(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AxisLabels::NewInstance
//
// Purpose: 
//   NewInstance method for the AxisLabels class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisLabels::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxisLabels(*this);
    else
        retval = new AxisLabels;

    return retval;
}

// ****************************************************************************
// Method: AxisLabels::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisLabels::SelectAll()
{
    Select(ID_visible, (void *)&visible);
    Select(ID_font,    (void *)&font);
    Select(ID_scaling, (void *)&scaling);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisLabels::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisLabels::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxisLabels defaultObject;
    bool addToParent = false;
    // Create a node for AxisLabels.
    DataNode *node = new DataNode("AxisLabels");

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_font, &defaultObject))
    {
        DataNode *fontNode = new DataNode("font");
        if(font.CreateNode(fontNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(fontNode);
        }
        else
            delete fontNode;
    }

    if(completeSave || !FieldsEqual(ID_scaling, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", scaling));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxisLabels::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisLabels::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxisLabels");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("font")) != 0)
        font.SetFromNode(node);
    if((node = searchNode->GetNode("scaling")) != 0)
        SetScaling(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisLabels::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
AxisLabels::SetFont(const FontAttributes &font_)
{
    font = font_;
    Select(ID_font, (void *)&font);
}

void
AxisLabels::SetScaling(int scaling_)
{
    scaling = scaling_;
    Select(ID_scaling, (void *)&scaling);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AxisLabels::GetVisible() const
{
    return visible;
}

const FontAttributes &
AxisLabels::GetFont() const
{
    return font;
}

FontAttributes &
AxisLabels::GetFont()
{
    return font;
}

int
AxisLabels::GetScaling() const
{
    return scaling;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisLabels::SelectFont()
{
    Select(ID_font, (void *)&font);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisLabels::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisLabels::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_visible: return "visible";
    case ID_font:    return "font";
    case ID_scaling: return "scaling";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisLabels::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AxisLabels::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_visible: return FieldType_bool;
    case ID_font:    return FieldType_att;
    case ID_scaling: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxisLabels::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisLabels::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_visible: return "bool";
    case ID_font:    return "att";
    case ID_scaling: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisLabels::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisLabels::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxisLabels &obj = *((const AxisLabels*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_font:
        {  // new scope
        retval = (font == obj.font);
        }
        break;
    case ID_scaling:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

