/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             avtM3DC1Options.C                              //
// ************************************************************************* //

#include <avtM3DC1Options.h>

#include <DBOptionsAttributes.h>

#include <vector>
#include <string>

using namespace std;

// ****************************************************************************
//  Function: GetM3DC1ReadOptions
//
//  Purpose:
//      Creates the options for M3DC1 readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Dec 4 15:04:15 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetM3DC1ReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

//    rv->SetInt("Number of poloidal planes", 1);

    rv->SetEnum("Mesh refinement", 1);
    vector<string> refinement;
    refinement.push_back("1");
    refinement.push_back("2");
    refinement.push_back("3");
    refinement.push_back("4");
    refinement.push_back("5");
    refinement.push_back("6");
    refinement.push_back("7");
    refinement.push_back("8");
    refinement.push_back("9");
    refinement.push_back("10");
//    refinement.push_back("Variable");
    rv->SetEnumStrings("Mesh refinement", refinement);

    rv->SetEnum("Linear mesh data location", 0);
    vector<string> centering;
    centering.push_back("Node");
    centering.push_back("Element");
    rv->SetEnumStrings("Linear mesh data location", centering);
 
    rv->SetBool("Process Data Selections in the Reader", false);

    return rv;
}


// ****************************************************************************
//  Function: GetM3DC1WriteOptions
//
//  Purpose:
//      Creates the options for M3DC1 writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Fri Dec 4 15:04:15 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetM3DC1WriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
