MACRO(EXEC_RUN CMD opt OUT_FILE)
    IF(EXISTS ${TESTS_DIRECTORY}/${OUT_FILE})
      MESSAGE("Deleting existing ${TESTS_DIRECTORY}/${OUT_FILE}")
      FILE(REMOVE ${TESTS_DIRECTORY}/${OUT_FILE})
    ENDIF(EXISTS ${TESTS_DIRECTORY}/${OUT_FILE})
    
    STRING(REPLACE ";" " " OPTIONS "${${opt}}" )
    MESSAGE("Executing ${CMD} ${OPTIONS}")
    EXECUTE_PROCESS(COMMAND "${CMD}" ${${opt}}
		                RESULT_VARIABLE CMD_RESULT
		                OUTPUT_FILE "${TESTS_DIRECTORY}/${OUT_FILE}")
      
    IF(CMD_RESULT)
        MESSAGE(FATAL_ERROR "Error running ${CMD} ${OPTIONS}\nCMAKE RESULTS: ${CMD_RESULT}")
    ENDIF(CMD_RESULT)
    
    IF(EXISTS ${RESULTS_DIR}/${OUT_FILE})
      UNSET(CMD_RESULT)
      EXECUTE_PROCESS(COMMAND diff ${RESULTS_DIR}/${OUT_FILE} ${TESTS_DIRECTORY}/${OUT_FILE}
		                  RESULT_VARIABLE CMD_RESULT
		                  OUTPUT_FILE "${TESTS_DIRECTORY}/${OUT_FILE}.diff"
		   )
      IF(CMD_RESULT)
        MESSAGE(FATAL_ERROR "Difference found between ${RESULTS_DIR}/${OUT_FILE} and ${TESTS_DIRECTORY}/${OUT_FILE}")
      ELSE(CMD_RESULT)
				FILE(REMOVE "${TESTS_DIRECTORY}/${OUT_FILE}.diff")
      ENDIF(CMD_RESULT)
    ELSE(EXISTS ${RESULTS_DIR}/${OUT_FILE})
      MESSAGE(FATAL_ERROR "No output to compare with: missing ${RESULTS_DIR}/${OUT_FILE}")
    ENDIF(EXISTS ${RESULTS_DIR}/${OUT_FILE})    
ENDMACRO(EXEC_RUN)

SET(ARGUMENTS "")


IF(DEFINED OUTPUT_FORMAT)
	IF(NOT ${OUTPUT_FORMAT} STREQUAL "")
		FOREACH(val IN ITEMS ${OUTPUT_FORMAT})
			LIST(APPEND ARGUMENTS ${val})
		ENDFOREACH()
	ELSE(NOT ${OUTPUT_FORMAT} STREQUAL "")
		LIST(APPEND ARGUMENTS "-o 2")
	ENDIF(NOT ${OUTPUT_FORMAT} STREQUAL "")
ELSE(DEFINED OUTPUT_FORMAT)
	LIST(APPEND ARGUMENTS "-o 2")
ENDIF(DEFINED OUTPUT_FORMAT)


IF(DEFINED OPTIONS)
	IF(NOT ${OPTIONS} STREQUAL "")
		FOREACH(val IN ITEMS ${OPTIONS})
			LIST(APPEND ARGUMENTS ${val})
		ENDFOREACH()
	ENDIF(NOT ${OPTIONS} STREQUAL "")
ENDIF(DEFINED OPTIONS)

IF(NOT ${PRF}  STREQUAL "")
  LIST(APPEND ARGUMENTS "${PRF}")
ENDIF(NOT ${PRF} STREQUAL "")

LIST(APPEND ARGUMENTS "${SEQDB}")
MESSAGE(" Args: ${ARGUMENTS}")
exec_run(${EXECUTABLE3} ARGUMENTS ${OUT_FILE})
