Translations
============

Picard translations are handled by [Transifex](https://www.transifex.com).

_Please do not manually edit the PO files._

Required tools
--------------

* [Transifex client 1.x](https://developers.transifex.com/docs/cli)
* [Babel](https://babel.pocoo.org/)


Picard source tree strings
--------------------------

Their translations are handled at <https://www.transifex.com/musicbrainz/musicbrainz/picard/>

One can update `picard.pot` using:
```bash
$ python setup.py regen_pot_file
```

Transifex will _automatically_ pick `picard.pot` from [Picard git repository master branch](https://github.com/metabrainz/picard/tree/master) once per day.


Attributes and countries strings
--------------------------------

Their translations are handled at <https://www.transifex.com/musicbrainz/musicbrainz/attributes/> and <https://www.transifex.com/musicbrainz/musicbrainz/countries/>

`attributes.pot` and `countries.pot` are updated by [musicbrainz-server project](https://github.com/metabrainz/musicbrainz-server), outside the Picard project.

Picard maintainers can regenerate `picard/const/attributes.py` and `picard/const/countries.py`, which are using `attributes.pot` and `countries.pot` as base, using the command:
```bash
$ python setup.py update_constants
```
It will retrieve and parse latest `attributes.pot` and `countries.pot` to rebuild `picard/const/attributes.py` and `picard/const/countries.py`.


To fetch latest translations from Transifex
-------------------------------------------

Use the following command:

```bash
$ python setup.py pull_translations
```

It will fetch all po files from Transifex, but the most incomplete ones.

The minimum acceptable percentage of a translation in order to download it can be seen using:
```bash
$ python setup.py pull_translations --help
```
The percentage value is passed to the `tx pull` command.
