/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Mirco Müller <macslow@bangang.de>
 */

#ifndef __PGM_GL_TEXT_H__
#define __PGM_GL_TEXT_H__

#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include "pgmgldrawable.h"

G_BEGIN_DECLS

#define PGM_TYPE_GL_TEXT (pgm_gl_text_get_type())
#define PGM_GL_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GL_TEXT, PgmGlText))
#define PGM_GL_TEXT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GL_TEXT, PgmGlTextClass))
#define PGM_IS_GL_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GL_TEXT))
#define PGM_IS_GL_TEXT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GL_TEXT))
#define PGM_GL_TEXT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GL_TEXT, PgmGlTextClass))

typedef struct _PgmGlText      PgmGlText;
typedef struct _PgmGlTextClass PgmGlTextClass;

struct _PgmGlText {
  PgmGlDrawable parent;

  /* Pixmap buffer */
  guchar *buffer;

  /* Texture handling */
  PgmTexture *texture;

  /* Pango rendering */
  PangoContext         *pango_ctx;
  PangoFontDescription *desc;
  PangoLayout          *layout;

  /* Cairo backend */
  cairo_t              *cairo_ctx;
  cairo_surface_t      *surface;
  cairo_font_options_t *font_options;

  /* Pixmap size */
  guint width, height, size;

  /* Regeneration boolean */
  gboolean size_updated;

  /* Multi lines */
  gboolean multiline;

  /* Color */
  gfloat color[4];

  /* Outline conversions */
  gfloat outline_color[4];
  gfloat outline_width;

  /* Shadow */
  gboolean cast_shadow;
  gfloat shadow_color[4];
  gfloat shadow_offset;
  gfloat shadow_latitude_factor;
  gfloat shadow_longitude_factor;

  /* Vertex arrays */
  PgmGlFloat fg_color[4];
  PgmGlFloat coord[8];
  PgmGlFloat vertex[12];
};

struct _PgmGlTextClass {
  PgmGlDrawableClass parent_class;
};

GType          pgm_gl_text_get_type            (void) G_GNUC_CONST;

PgmGlDrawable *pgm_gl_text_new                 (PgmDrawable *drawable,
                                                PgmGlViewport *glviewport);

void           pgm_gl_text_register            (GTypeModule *module);

void           pgm_gl_text_set_label           (PgmGlText *gltext);
void           pgm_gl_text_set_markup          (PgmGlText *gltext);
void           pgm_gl_text_set_font_family     (PgmGlText *gltext);
void           pgm_gl_text_set_font_height     (PgmGlText *gltext);
void           pgm_gl_text_set_ellipsize       (PgmGlText *gltext);
void           pgm_gl_text_set_justify         (PgmGlText *gltext);
void           pgm_gl_text_set_alignment       (PgmGlText *gltext);
void           pgm_gl_text_set_wrap            (PgmGlText *gltext);
void           pgm_gl_text_set_gravity         (PgmGlText *gltext);
void           pgm_gl_text_set_stretch         (PgmGlText *gltext);
void           pgm_gl_text_set_style           (PgmGlText *gltext);
void           pgm_gl_text_set_variant         (PgmGlText *gltext);
void           pgm_gl_text_set_weight          (PgmGlText *gltext);
void           pgm_gl_text_set_multiline       (PgmGlText *gltext);
void           pgm_gl_text_set_line_spacing    (PgmGlText *gltext);
void           pgm_gl_text_set_color           (PgmGlText *gltext);
void           pgm_gl_text_set_outline_color   (PgmGlText *gltext);
void           pgm_gl_text_set_outline_width   (PgmGlText *gltext);
void           pgm_gl_text_set_cast_shadow     (PgmGlText *gltext);
void           pgm_gl_text_set_shadow_position (PgmGlText *gltext);
void           pgm_gl_text_set_shadow_color    (PgmGlText *gltext);

G_END_DECLS

#endif /* __PGM_GL_TEXT_H__ */
