/*
 *      base_io.hpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#ifndef BASE_IO
#define BASE_IO

# include <sstream>
# include <string>
# include <stdexcept>
# include <cstdlib>
# include <boost/algorithm/string.hpp>
# include <gnutls/gnutls.h>
# include <cstring>

# include <sys/socket.h>
# include <arpa/inet.h>
# include <netdb.h>
# include <errno.h>
# include <fcntl.h>
# include <signal.h>

class base_io {
    public:
    virtual ~base_io();

    virtual int start () = 0;
	std::string split_headers ();

    protected:
	base_io(const std::string&, const std::string&, const std::string&, int, bool);

    void send_request (const std::string&);
    virtual int recieve (int) = 0;
    virtual int procedure_string (std::string) = 0;
	virtual bool get_header (std::string&, unsigned) = 0;
	virtual void find_unred_mails(std::string) = 0;
	virtual void set_unred(int) = 0;

    int st; // the socket
	gnutls_session_t session; // for ssl
	gnutls_certificate_credentials_t xcred;

    sockaddr_in service;
    int result;
    std::string user, password;
	bool ssl;
};

#endif
