/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathIterator
implements Iterator {
    private static final FileFilter CLASS_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || ClassPathIterator.isClass(file);
        }
    };
    private static final FileFilter JAR_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return ClassPathIterator.hasExtension(ClassPathIterator.getName(file), ".jar");
        }
    };
    private final Iterator files;
    private Enumeration entries;
    private Map sources = new HashMap();
    private ZipFile zip;
    private Object next;

    public ClassPathIterator(String classPath) throws IOException {
        this(new File(System.getProperty("user.dir")), classPath);
    }

    public ClassPathIterator(File parent, String classPath) throws IOException {
        StringTokenizer st = new StringTokenizer(classPath, ":;");
        ArrayList<File> fileList = new ArrayList<File>();
        while (st.hasMoreTokens()) {
            String part = (String)st.nextElement();
            boolean wildcard = false;
            if (part.endsWith("/*")) {
                if ((part = part.substring(0, part.length() - 1)).indexOf(42) >= 0) {
                    throw new IllegalArgumentException("Multiple wildcards are not allowed: " + part);
                }
                wildcard = true;
            } else if (part.indexOf(42) >= 0) {
                throw new IllegalArgumentException("Incorrect wildcard usage: " + part);
            }
            File file = new File(part);
            if (!file.isAbsolute()) {
                file = new File(parent, part);
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("File " + file + " does not exist");
            }
            if (wildcard) {
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("File " + file + " + is not a directory");
                }
                fileList.addAll(ClassPathIterator.findFiles(file, JAR_FILTER, false, new ArrayList()));
                continue;
            }
            fileList.add(file);
        }
        this.files = fileList.iterator();
        this.advance();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void close() throws IOException {
        if (this.sources != null) {
            Iterator it = this.sources.values().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof ZipFile)) continue;
                ((ZipFile)obj).close();
            }
        }
    }

    public InputStream getInputStream(Object obj) throws IOException {
        if (obj instanceof ZipEntry) {
            return ((ZipFile)this.sources.get(obj)).getInputStream((ZipEntry)obj);
        }
        return new BufferedInputStream(new FileInputStream((File)obj));
    }

    public Object getSource(Object obj) {
        return this.sources.get(obj);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.next;
        try {
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return result;
    }

    private void advance() throws IOException {
        if (this.entries == null) {
            if (!this.files.hasNext()) {
                this.next = null;
                return;
            }
            this.zip = null;
            File file = (File)this.files.next();
            if (ClassPathIterator.hasExtension(ClassPathIterator.getName(file), ".jar")) {
                this.zip = new JarFile(file);
                this.entries = this.zip.entries();
            } else if (ClassPathIterator.hasExtension(ClassPathIterator.getName(file), ".zip")) {
                this.zip = new ZipFile(file);
                this.entries = this.zip.entries();
            } else if (file.isDirectory()) {
                List classes = ClassPathIterator.findFiles(file, CLASS_FILTER, true, new ArrayList());
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    this.sources.put(it.next(), file);
                }
                this.entries = Collections.enumeration(classes);
            } else {
                throw new IllegalArgumentException("Do not know how to handle " + file);
            }
        }
        boolean foundClass = false;
        while (this.entries.hasMoreElements()) {
            this.next = this.entries.nextElement();
            foundClass = ClassPathIterator.isClass(this.next);
            if (!foundClass) continue;
            if (this.zip == null) break;
            this.sources.put(this.next, this.zip);
            break;
        }
        if (!foundClass) {
            this.entries = null;
            this.advance();
        }
    }

    private static List findFiles(File dir, FileFilter filter, boolean recurse, List collect) {
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            if (recurse && files[i].isDirectory()) {
                ClassPathIterator.findFiles(files[i], filter, recurse, collect);
                continue;
            }
            collect.add(files[i]);
        }
        return collect;
    }

    private static boolean isClass(Object obj) {
        return ClassPathIterator.hasExtension(ClassPathIterator.getName(obj), ".class");
    }

    private static String getName(Object obj) {
        return obj instanceof ZipEntry ? ((ZipEntry)obj).getName() : ((File)obj).getName();
    }

    private static boolean hasExtension(String name, String ext) {
        if (name.length() < ext.length()) {
            return false;
        }
        String actual = name.substring(name.length() - ext.length());
        return actual.equals(ext) || actual.equals(ext.toUpperCase());
    }
}

