/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class SuperInvocationMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private boolean invokesSuperMethods;

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -73) {
            this.invokesSuperMethods = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.invokesSuperMethods) {
                SuperInvocationMarker.setInvokesSuperMethods(method);
            }
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.invokesSuperMethods = !clazz.equals(refConstant.referencedClass) && !refConstant.getName(clazz).equals("<init>");
    }

    private static void setInvokesSuperMethods(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setInvokesSuperMethods();
        }
    }

    public static boolean invokesSuperMethods(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.invokesSuperMethods();
    }
}

