#!/usr/bin/python
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: ConnectDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import Pmw

class ConnectDialog(Pmw.Dialog):

    def __init__(self, master, title="", class_=None):
        Pmw.Dialog.__init__(self, master=master, title=title,
            buttons=('Connect','Cancel'), defaultbutton='Connect')  
        
        connecttypes = [("xmlrpc", "Connect to XML-RPC Server"),
                        ("file", "Open File from Disk")]
        
        self.conn_type_var = StringVar()
        self.conn_type_var.set(connecttypes[0][0])
        self.conn_str_var = StringVar()

        self.interior().columnconfigure(0, weight=1)
        grp = Pmw.Group(self.interior(), tag_text = "Connection Type")
        grp.grid(sticky=W+E, padx=2, pady=2)
        
        for type in connecttypes:
            lbl = Radiobutton(grp.interior(), text=type[1],
                value = type[0], variable = self.conn_type_var,
                command = self.radio_change_event)
            lbl.grid(sticky=W, padx=2, pady=2)
        
        grp = Pmw.Group(self.interior(), tag_text = "Connection String")
        grp.grid(sticky=W+E, padx=2, pady=2)
        grp.interior().columnconfigure(0, weight=1)
        
        lbl = Entry(grp.interior(), textvariable = self.conn_str_var, width=24)
        lbl.grid(sticky=W+E, padx=2, pady=2)

        self.btnBrowse = Button(grp.interior(), text="Browse..", command=self.browse_event)
        self.btnBrowse.grid(row=0, column=1, padx=2, pady=2)
        self.btnBrowse.grid_remove()
        
    def getvalue(self):
        return (self.conn_type_var.get(), self.conn_str_var.get())

    def activate(self, type, defaultstrings): 
        self.defaultstrings = defaultstrings
        self.conn_type_var.set(type)
        self.conn_str_var.set(defaultstrings[type])
        if type == 'file': self.btnBrowse.grid()
        else: self.btnBrowse.grid_remove()
        Pmw.Dialog.activate(self)

    def radio_change_event(self):
        type = self.conn_type_var.get()
        self.conn_str_var.set(self.defaultstrings[type])
        if type == 'file': self.btnBrowse.grid()
        else: self.btnBrowse.grid_remove()

    def browse_event(self):
        import tkFileDialog, os
        try:
            dir =  os.basename(self.conn_str_var.get())
        except:
            dir = ""
        dlg = tkFileDialog.Open(filetypes=[("vCard","*.vcf")],
                                initialdir=dir, initialfile=self.conn_str_var.get())
        ret = dlg.show()
        if ret:
            self.conn_str_var.set(ret)

if __name__ == "__main__":
        # Unit Test:
        tk = Tk()
        dlg = ConnectDialog(tk, title="Connect")
        dlg.activate('xmlrpc', {"xmlrpc": "http://localhost:8810",
                                "file": "~/addressbook.vcf"})
        tk.destroy()
