# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import VMwareCloudSimpleClientConfiguration
from .operations import Operations
from .operations import DedicatedCloudNodesOperations
from .operations import DedicatedCloudServicesOperations
from .operations import SkusAvailabilityOperations
from .operations import PrivateCloudsOperations
from .operations import CustomizationPoliciesOperations
from .operations import ResourcePoolsOperations
from .operations import VirtualMachineTemplatesOperations
from .operations import VirtualNetworksOperations
from .operations import UsagesOperations
from .operations import VirtualMachinesOperations
from . import models


class VMwareCloudSimpleClient(SDKClient):
    """Description of the new service

    :ivar config: Configuration for client.
    :vartype config: VMwareCloudSimpleClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.vmwarecloudsimple.operations.Operations
    :ivar dedicated_cloud_nodes: DedicatedCloudNodes operations
    :vartype dedicated_cloud_nodes: azure.mgmt.vmwarecloudsimple.operations.DedicatedCloudNodesOperations
    :ivar dedicated_cloud_services: DedicatedCloudServices operations
    :vartype dedicated_cloud_services: azure.mgmt.vmwarecloudsimple.operations.DedicatedCloudServicesOperations
    :ivar skus_availability: SkusAvailability operations
    :vartype skus_availability: azure.mgmt.vmwarecloudsimple.operations.SkusAvailabilityOperations
    :ivar private_clouds: PrivateClouds operations
    :vartype private_clouds: azure.mgmt.vmwarecloudsimple.operations.PrivateCloudsOperations
    :ivar customization_policies: CustomizationPolicies operations
    :vartype customization_policies: azure.mgmt.vmwarecloudsimple.operations.CustomizationPoliciesOperations
    :ivar resource_pools: ResourcePools operations
    :vartype resource_pools: azure.mgmt.vmwarecloudsimple.operations.ResourcePoolsOperations
    :ivar virtual_machine_templates: VirtualMachineTemplates operations
    :vartype virtual_machine_templates: azure.mgmt.vmwarecloudsimple.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworks operations
    :vartype virtual_networks: azure.mgmt.vmwarecloudsimple.operations.VirtualNetworksOperations
    :ivar usages: Usages operations
    :vartype usages: azure.mgmt.vmwarecloudsimple.operations.UsagesOperations
    :ivar virtual_machines: VirtualMachines operations
    :vartype virtual_machines: azure.mgmt.vmwarecloudsimple.operations.VirtualMachinesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param referer: referer url
    :type referer: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, referer, base_url=None):

        self.config = VMwareCloudSimpleClientConfiguration(credentials, subscription_id, referer, base_url)
        super(VMwareCloudSimpleClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-04-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.dedicated_cloud_nodes = DedicatedCloudNodesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.dedicated_cloud_services = DedicatedCloudServicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.skus_availability = SkusAvailabilityOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_clouds = PrivateCloudsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.customization_policies = CustomizationPoliciesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self.config, self._serialize, self._deserialize)
