# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse

from .. import models


class EventsOperations(object):
    """EventsOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def get_by_type(
            self, app_id, event_type, timespan=None, filter=None, search=None, orderby=None, select=None, skip=None, top=None, format=None, count=None, apply=None, custom_headers=None, raw=False, **operation_config):
        """Execute OData query.

        Executes an OData query for events.

        :param app_id: ID of the application. This is Application ID from the
         API Access settings blade in the Azure portal.
        :type app_id: str
        :param event_type: The type of events to query; either a standard
         event type (`traces`, `customEvents`, `pageViews`, `requests`,
         `dependencies`, `exceptions`, `availabilityResults`) or `$all` to
         query across all event types. Possible values include: '$all',
         'traces', 'customEvents', 'pageViews', 'browserTimings', 'requests',
         'dependencies', 'exceptions', 'availabilityResults',
         'performanceCounters', 'customMetrics'
        :type event_type: str or ~azure.applicationinsights.models.EventType
        :param timespan: Optional. The timespan over which to retrieve events.
         This is an ISO8601 time period value.  This timespan is applied in
         addition to any that are specified in the Odata expression.
        :type timespan: str
        :param filter: An expression used to filter the returned events
        :type filter: str
        :param search: A free-text search expression to match for whether a
         particular event should be returned
        :type search: str
        :param orderby: A comma-separated list of properties with \\"asc\\"
         (the default) or \\"desc\\" to control the order of returned events
        :type orderby: str
        :param select: Limits the properties to just those requested on each
         returned event
        :type select: str
        :param skip: The number of items to skip over before returning events
        :type skip: int
        :param top: The number of events to return
        :type top: int
        :param format: Format for the returned events
        :type format: str
        :param count: Request a count of matching items included with the
         returned events
        :type count: bool
        :param apply: An expression used for aggregation over returned events
        :type apply: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: EventsResults or ClientRawResponse if raw=true
        :rtype: ~azure.applicationinsights.models.EventsResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.applicationinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_by_type.metadata['url']
        path_format_arguments = {
            'appId': self._serialize.url("app_id", app_id, 'str'),
            'eventType': self._serialize.url("event_type", event_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timespan is not None:
            query_parameters['timespan'] = self._serialize.query("timespan", timespan, 'str')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if search is not None:
            query_parameters['$search'] = self._serialize.query("search", search, 'str')
        if orderby is not None:
            query_parameters['$orderby'] = self._serialize.query("orderby", orderby, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if skip is not None:
            query_parameters['$skip'] = self._serialize.query("skip", skip, 'int')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int')
        if format is not None:
            query_parameters['$format'] = self._serialize.query("format", format, 'str')
        if count is not None:
            query_parameters['$count'] = self._serialize.query("count", count, 'bool')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventsResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_by_type.metadata = {'url': '/apps/{appId}/events/{eventType}'}

    def get(
            self, app_id, event_type, event_id, timespan=None, custom_headers=None, raw=False, **operation_config):
        """Get an event.

        Gets the data for a single event.

        :param app_id: ID of the application. This is Application ID from the
         API Access settings blade in the Azure portal.
        :type app_id: str
        :param event_type: The type of events to query; either a standard
         event type (`traces`, `customEvents`, `pageViews`, `requests`,
         `dependencies`, `exceptions`, `availabilityResults`) or `$all` to
         query across all event types. Possible values include: '$all',
         'traces', 'customEvents', 'pageViews', 'browserTimings', 'requests',
         'dependencies', 'exceptions', 'availabilityResults',
         'performanceCounters', 'customMetrics'
        :type event_type: str or ~azure.applicationinsights.models.EventType
        :param event_id: ID of event.
        :type event_id: str
        :param timespan: Optional. The timespan over which to retrieve events.
         This is an ISO8601 time period value.  This timespan is applied in
         addition to any that are specified in the Odata expression.
        :type timespan: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: EventsResults or ClientRawResponse if raw=true
        :rtype: ~azure.applicationinsights.models.EventsResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.applicationinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'appId': self._serialize.url("app_id", app_id, 'str'),
            'eventType': self._serialize.url("event_type", event_type, 'str'),
            'eventId': self._serialize.url("event_id", event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timespan is not None:
            query_parameters['timespan'] = self._serialize.query("timespan", timespan, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventsResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/apps/{appId}/events/{eventType}/{eventId}'}

    def get_odata_metadata(
            self, app_id, custom_headers=None, raw=False, **operation_config):
        """Get OData metadata.

        Gets OData EDMX metadata describing the event data model.

        :param app_id: ID of the application. This is Application ID from the
         API Access settings blade in the Azure portal.
        :type app_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.applicationinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_odata_metadata.metadata['url']
        path_format_arguments = {
            'appId': self._serialize.url("app_id", app_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/xml;charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_odata_metadata.metadata = {'url': '/apps/{appId}/events/$metadata'}
