# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AccessConnector(TrackedResource):
    """Information about azure databricks accessConnector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.databricks.models.IdentityData
    :ivar properties: Azure Databricks accessConnector properties.
    :vartype properties: ~azure.mgmt.databricks.models.AccessConnectorProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityData"},
        "properties": {"key": "properties", "type": "AccessConnectorProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityData"] = None,
        properties: Optional["_models.AccessConnectorProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.databricks.models.IdentityData
        :keyword properties: Azure Databricks accessConnector properties.
        :paramtype properties: ~azure.mgmt.databricks.models.AccessConnectorProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.properties = properties


class AccessConnectorListResult(_serialization.Model):
    """List of azure databricks accessConnector.

    :ivar value: The array of azure databricks accessConnector.
    :vartype value: list[~azure.mgmt.databricks.models.AccessConnector]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AccessConnector"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The array of azure databricks accessConnector.
        :paramtype value: list[~azure.mgmt.databricks.models.AccessConnector]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessConnectorProperties(_serialization.Model):
    """AccessConnectorProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status of the accessConnector. Known values are:
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.databricks.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class AccessConnectorUpdate(_serialization.Model):
    """An update to an azure databricks accessConnector.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.databricks.models.IdentityData
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "IdentityData"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, identity: Optional["_models.IdentityData"] = None, **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.databricks.models.IdentityData
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, *, address_prefixes: Optional[List[str]] = None, **kwargs):
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes


class CreatedBy(_serialization.Model):
    """Provides details of the entity that created/updated the workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar oid: The Object ID that created the workspace.
    :vartype oid: str
    :ivar puid: The Personal Object ID corresponding to the object ID above.
    :vartype puid: str
    :ivar application_id: The application ID of the application that initiated the creation of the
     workspace. For example, Azure Portal.
    :vartype application_id: str
    """

    _validation = {
        "oid": {"readonly": True},
        "puid": {"readonly": True},
        "application_id": {"readonly": True},
    }

    _attribute_map = {
        "oid": {"key": "oid", "type": "str"},
        "puid": {"key": "puid", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.oid = None
        self.puid = None
        self.application_id = None


class Encryption(_serialization.Model):
    """The object that contains details of encryption used on the workspace.

    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Default, Microsoft.Keyvault. Known values are: "Default" and "Microsoft.Keyvault".
    :vartype key_source: str or ~azure.mgmt.databricks.models.KeySource
    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    """

    _attribute_map = {
        "key_source": {"key": "keySource", "type": "str"},
        "key_name": {"key": "KeyName", "type": "str"},
        "key_version": {"key": "keyversion", "type": "str"},
        "key_vault_uri": {"key": "keyvaulturi", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "_models.KeySource"] = "Default",
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_source: The encryption keySource (provider). Possible values (case-insensitive):
         Default, Microsoft.Keyvault. Known values are: "Default" and "Microsoft.Keyvault".
        :paramtype key_source: str or ~azure.mgmt.databricks.models.KeySource
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.key_source = key_source
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri


class EncryptionEntitiesDefinition(_serialization.Model):
    """Encryption entities for databricks workspace resource.

    :ivar managed_services: Encryption properties for the databricks managed services.
    :vartype managed_services: ~azure.mgmt.databricks.models.EncryptionV2
    :ivar managed_disk: Encryption properties for the databricks managed disks.
    :vartype managed_disk: ~azure.mgmt.databricks.models.ManagedDiskEncryption
    """

    _attribute_map = {
        "managed_services": {"key": "managedServices", "type": "EncryptionV2"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskEncryption"},
    }

    def __init__(
        self,
        *,
        managed_services: Optional["_models.EncryptionV2"] = None,
        managed_disk: Optional["_models.ManagedDiskEncryption"] = None,
        **kwargs
    ):
        """
        :keyword managed_services: Encryption properties for the databricks managed services.
        :paramtype managed_services: ~azure.mgmt.databricks.models.EncryptionV2
        :keyword managed_disk: Encryption properties for the databricks managed disks.
        :paramtype managed_disk: ~azure.mgmt.databricks.models.ManagedDiskEncryption
        """
        super().__init__(**kwargs)
        self.managed_services = managed_services
        self.managed_disk = managed_disk


class EncryptionV2(_serialization.Model):
    """The object that contains details of encryption used on the workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Microsoft.Keyvault. Required. "Microsoft.Keyvault"
    :vartype key_source: str or ~azure.mgmt.databricks.models.EncryptionKeySource
    :ivar key_vault_properties: Key Vault input properties for encryption.
    :vartype key_vault_properties: ~azure.mgmt.databricks.models.EncryptionV2KeyVaultProperties
    """

    _validation = {
        "key_source": {"required": True},
    }

    _attribute_map = {
        "key_source": {"key": "keySource", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "EncryptionV2KeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "_models.EncryptionKeySource"],
        key_vault_properties: Optional["_models.EncryptionV2KeyVaultProperties"] = None,
        **kwargs
    ):
        """
        :keyword key_source: The encryption keySource (provider). Possible values (case-insensitive):
         Microsoft.Keyvault. Required. "Microsoft.Keyvault"
        :paramtype key_source: str or ~azure.mgmt.databricks.models.EncryptionKeySource
        :keyword key_vault_properties: Key Vault input properties for encryption.
        :paramtype key_vault_properties: ~azure.mgmt.databricks.models.EncryptionV2KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EncryptionV2KeyVaultProperties(_serialization.Model):
    """Key Vault input properties for encryption.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_uri: The Uri of KeyVault. Required.
    :vartype key_vault_uri: str
    :ivar key_name: The name of KeyVault key. Required.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key. Required.
    :vartype key_version: str
    """

    _validation = {
        "key_vault_uri": {"required": True},
        "key_name": {"required": True},
        "key_version": {"required": True},
    }

    _attribute_map = {
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
    }

    def __init__(self, *, key_vault_uri: str, key_name: str, key_version: str, **kwargs):
        """
        :keyword key_vault_uri: The Uri of KeyVault. Required.
        :paramtype key_vault_uri: str
        :keyword key_name: The name of KeyVault key. Required.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key. Required.
        :paramtype key_version: str
        """
        super().__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_name = key_name
        self.key_version = key_version


class EndpointDependency(_serialization.Model):
    """A domain name or IP address the Workspace is reaching at.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The Ports used when connecting to domainName.
    :vartype endpoint_details: list[~azure.mgmt.databricks.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The Ports used when connecting to domainName.
        :paramtype endpoint_details: list[~azure.mgmt.databricks.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """Connect information from the Workspace to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar latency: The time in milliseconds it takes for the connection to be created from the
     Workspace to this IpAddress at this Port.
    :vartype latency: float
    :ivar is_accessible: Whether it is possible to create a connection from the Workspace to this
     IpAddress at this Port.
    :vartype is_accessible: bool
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "latency": {"key": "latency", "type": "float"},
        "is_accessible": {"key": "isAccessible", "type": "bool"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessible: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword latency: The time in milliseconds it takes for the connection to be created from the
         Workspace to this IpAddress at this Port.
        :paramtype latency: float
        :keyword is_accessible: Whether it is possible to create a connection from the Workspace to
         this IpAddress at this Port.
        :paramtype is_accessible: bool
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessible = is_accessible


class ErrorDetail(_serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :ivar code: The error's code. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    :ivar target: Indicates which property in the request is responsible for the error.
    :vartype target: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, *, code: str, message: str, target: Optional[str] = None, **kwargs):
        """
        :keyword code: The error's code. Required.
        :paramtype code: str
        :keyword message: A human readable error message. Required.
        :paramtype message: str
        :keyword target: Indicates which property in the request is responsible for the error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorInfo(_serialization.Model):
    """The code and message for an error.

    All required parameters must be populated in order to send to Azure.

    :ivar code: A machine readable error code. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    :ivar details: error details.
    :vartype details: list[~azure.mgmt.databricks.models.ErrorDetail]
    :ivar innererror: Inner error details if they exist.
    :vartype innererror: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models.ErrorDetail"]] = None,
        innererror: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: A machine readable error code. Required.
        :paramtype code: str
        :keyword message: A human readable error message. Required.
        :paramtype message: str
        :keyword details: error details.
        :paramtype details: list[~azure.mgmt.databricks.models.ErrorDetail]
        :keyword innererror: Inner error details if they exist.
        :paramtype innererror: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.innererror = innererror


class ErrorResponse(_serialization.Model):
    """Contains details when the response code indicates an error.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The error details. Required.
    :vartype error: ~azure.mgmt.databricks.models.ErrorInfo
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorInfo"},
    }

    def __init__(self, *, error: "_models.ErrorInfo", **kwargs):
        """
        :keyword error: The error details. Required.
        :paramtype error: ~azure.mgmt.databricks.models.ErrorInfo
        """
        super().__init__(**kwargs)
        self.error = error


class GroupIdInformation(Resource):
    """The group information for creating a private endpoint on a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar properties: The group id properties. Required.
    :vartype properties: ~azure.mgmt.databricks.models.GroupIdInformationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "GroupIdInformationProperties"},
    }

    def __init__(self, *, properties: "_models.GroupIdInformationProperties", **kwargs):
        """
        :keyword properties: The group id properties. Required.
        :paramtype properties: ~azure.mgmt.databricks.models.GroupIdInformationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GroupIdInformationProperties(_serialization.Model):
    """The properties for a group information object.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword group_id: The group id.
        :paramtype group_id: str
        :keyword required_members: The required members for a specific group id.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The required DNS zones for a specific group id.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class IdentityData(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Required. Known values are: "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.databricks.models.IdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.IdentityType"], **kwargs):
        """
        :keyword type: The identity type. Required. Known values are: "None" and "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.databricks.models.IdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedDiskEncryption(_serialization.Model):
    """The object that contains details of encryption used on the workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Microsoft.Keyvault. Required. "Microsoft.Keyvault"
    :vartype key_source: str or ~azure.mgmt.databricks.models.EncryptionKeySource
    :ivar key_vault_properties: Key Vault input properties for encryption. Required.
    :vartype key_vault_properties:
     ~azure.mgmt.databricks.models.ManagedDiskEncryptionKeyVaultProperties
    :ivar rotation_to_latest_key_version_enabled: Indicate whether the latest key version should be
     automatically used for Managed Disk Encryption.
    :vartype rotation_to_latest_key_version_enabled: bool
    """

    _validation = {
        "key_source": {"required": True},
        "key_vault_properties": {"required": True},
    }

    _attribute_map = {
        "key_source": {"key": "keySource", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "ManagedDiskEncryptionKeyVaultProperties"},
        "rotation_to_latest_key_version_enabled": {"key": "rotationToLatestKeyVersionEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "_models.EncryptionKeySource"],
        key_vault_properties: "_models.ManagedDiskEncryptionKeyVaultProperties",
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword key_source: The encryption keySource (provider). Possible values (case-insensitive):
         Microsoft.Keyvault. Required. "Microsoft.Keyvault"
        :paramtype key_source: str or ~azure.mgmt.databricks.models.EncryptionKeySource
        :keyword key_vault_properties: Key Vault input properties for encryption. Required.
        :paramtype key_vault_properties:
         ~azure.mgmt.databricks.models.ManagedDiskEncryptionKeyVaultProperties
        :keyword rotation_to_latest_key_version_enabled: Indicate whether the latest key version should
         be automatically used for Managed Disk Encryption.
        :paramtype rotation_to_latest_key_version_enabled: bool
        """
        super().__init__(**kwargs)
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled


class ManagedDiskEncryptionKeyVaultProperties(_serialization.Model):
    """Key Vault input properties for encryption.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_uri: The URI of KeyVault. Required.
    :vartype key_vault_uri: str
    :ivar key_name: The name of KeyVault key. Required.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key. Required.
    :vartype key_version: str
    """

    _validation = {
        "key_vault_uri": {"required": True},
        "key_name": {"required": True},
        "key_version": {"required": True},
    }

    _attribute_map = {
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
    }

    def __init__(self, *, key_vault_uri: str, key_name: str, key_version: str, **kwargs):
        """
        :keyword key_vault_uri: The URI of KeyVault. Required.
        :paramtype key_vault_uri: str
        :keyword key_name: The name of KeyVault key. Required.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key. Required.
        :paramtype key_version: str
        """
        super().__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_name = key_name
        self.key_version = key_version


class ManagedIdentityConfiguration(_serialization.Model):
    """The Managed Identity details for storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The objectId of the Managed Identity that is linked to the Managed Storage
     account.
    :vartype principal_id: str
    :ivar tenant_id: The tenant Id where the Managed Identity is created.
    :vartype tenant_id: str
    :ivar type: The type of Identity created. It can be either SystemAssigned or UserAssigned.
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = None


class Operation(_serialization.Model):
    """REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.databricks.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.databricks.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.ResourceProvider.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.ResourceProvider.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list Resource Provider operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Resource Provider operations supported by the Resource Provider resource
     provider.
    :vartype value: list[~azure.mgmt.databricks.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of Resource Provider operations supported by the Resource Provider
         resource provider.
        :paramtype value: list[~azure.mgmt.databricks.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Egress endpoints which Workspace connects to for common purposes.

    :ivar category: The category of endpoints accessed by the Workspace, e.g. azure-storage,
     azure-mysql, etc.
    :vartype category: str
    :ivar endpoints: The endpoints that Workspace connect to.
    :vartype endpoints: list[~azure.mgmt.databricks.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs
    ):
        """
        :keyword category: The category of endpoints accessed by the Workspace, e.g. azure-storage,
         azure-mysql, etc.
        :paramtype category: str
        :keyword endpoints: The endpoints that Workspace connect to.
        :paramtype endpoints: list[~azure.mgmt.databricks.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class PrivateEndpoint(_serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(_serialization.Model):
    """The private endpoint connection of a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: The private endpoint connection properties. Required.
    :vartype properties: ~azure.mgmt.databricks.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, *, properties: "_models.PrivateEndpointConnectionProperties", **kwargs):
        """
        :keyword properties: The private endpoint connection properties. Required.
        :paramtype properties: ~azure.mgmt.databricks.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class PrivateEndpointConnectionProperties(_serialization.Model):
    """The properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar private_endpoint: Private endpoint.
    :vartype private_endpoint: ~azure.mgmt.databricks.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Private endpoint connection state. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.databricks.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.databricks.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "private_link_service_connection_state": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: Private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.databricks.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Private endpoint connection state. Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.databricks.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionsList(_serialization.Model):
    """List of private link connections.

    :ivar value: The list of returned private endpoint connection.
    :vartype value: list[~azure.mgmt.databricks.models.PrivateEndpointConnection]
    :ivar next_link: The URL to get the next set of endpoint connections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of returned private endpoint connection.
        :paramtype value: list[~azure.mgmt.databricks.models.PrivateEndpointConnection]
        :keyword next_link: The URL to get the next set of endpoint connections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResourcesList(_serialization.Model):
    """The available private link resources for a workspace.

    :ivar value: The list of available private link resources for a workspace.
    :vartype value: list[~azure.mgmt.databricks.models.GroupIdInformation]
    :ivar next_link: The URL to get the next set of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GroupIdInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GroupIdInformation"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of available private link resources for a workspace.
        :paramtype value: list[~azure.mgmt.databricks.models.GroupIdInformation]
        :keyword next_link: The URL to get the next set of private link resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.databricks.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
    :vartype description: str
    :ivar action_required: Actions required for a private endpoint connection.
    :vartype action_required: str
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "action_required": {"key": "actionRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: Optional[str] = None,
        action_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: The status of a private endpoint connection. Required. Known values are:
         "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.databricks.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the current state of a private endpoint connection.
        :paramtype description: str
        :keyword action_required: Actions required for a private endpoint connection.
        :paramtype action_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class Sku(_serialization.Model):
    """SKU for the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name. Required.
    :vartype name: str
    :ivar tier: The SKU tier.
    :vartype tier: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: str, tier: Optional[str] = None, **kwargs):
        """
        :keyword name: The SKU name. Required.
        :paramtype name: str
        :keyword tier: The SKU tier.
        :paramtype tier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.databricks.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.databricks.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.databricks.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.databricks.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VirtualNetworkPeering(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Peerings in a VirtualNetwork resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the virtual network peering resource.
    :vartype name: str
    :ivar id: Resource ID.
    :vartype id: str
    :ivar type: type of the virtual network peering resource.
    :vartype type: str
    :ivar allow_virtual_network_access: Whether the VMs in the local virtual network space would be
     able to access the VMs in remote virtual network space.
    :vartype allow_virtual_network_access: bool
    :ivar allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual
     network will be allowed/disallowed in remote virtual network.
    :vartype allow_forwarded_traffic: bool
    :ivar allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :vartype allow_gateway_transit: bool
    :ivar use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :vartype use_remote_gateways: bool
    :ivar databricks_virtual_network: The remote virtual network should be in the same region. See
     here to learn more
     (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
    :vartype databricks_virtual_network:
     ~azure.mgmt.databricks.models.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork
    :ivar databricks_address_space: The reference to the databricks virtual network address space.
    :vartype databricks_address_space: ~azure.mgmt.databricks.models.AddressSpace
    :ivar remote_virtual_network: The remote virtual network should be in the same region. See here
     to learn more
     (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     Required.
    :vartype remote_virtual_network:
     ~azure.mgmt.databricks.models.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork
    :ivar remote_address_space: The reference to the remote virtual network address space.
    :vartype remote_address_space: ~azure.mgmt.databricks.models.AddressSpace
    :ivar peering_state: The status of the virtual network peering. Known values are: "Initiated",
     "Connected", and "Disconnected".
    :vartype peering_state: str or ~azure.mgmt.databricks.models.PeeringState
    :ivar provisioning_state: The provisioning state of the virtual network peering resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.databricks.models.PeeringProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "remote_virtual_network": {"required": True},
        "peering_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allow_virtual_network_access": {"key": "properties.allowVirtualNetworkAccess", "type": "bool"},
        "allow_forwarded_traffic": {"key": "properties.allowForwardedTraffic", "type": "bool"},
        "allow_gateway_transit": {"key": "properties.allowGatewayTransit", "type": "bool"},
        "use_remote_gateways": {"key": "properties.useRemoteGateways", "type": "bool"},
        "databricks_virtual_network": {
            "key": "properties.databricksVirtualNetwork",
            "type": "VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork",
        },
        "databricks_address_space": {"key": "properties.databricksAddressSpace", "type": "AddressSpace"},
        "remote_virtual_network": {
            "key": "properties.remoteVirtualNetwork",
            "type": "VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork",
        },
        "remote_address_space": {"key": "properties.remoteAddressSpace", "type": "AddressSpace"},
        "peering_state": {"key": "properties.peeringState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        remote_virtual_network: "_models.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork",
        allow_virtual_network_access: Optional[bool] = None,
        allow_forwarded_traffic: Optional[bool] = None,
        allow_gateway_transit: Optional[bool] = None,
        use_remote_gateways: Optional[bool] = None,
        databricks_virtual_network: Optional[
            "_models.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork"
        ] = None,
        databricks_address_space: Optional["_models.AddressSpace"] = None,
        remote_address_space: Optional["_models.AddressSpace"] = None,
        **kwargs
    ):
        """
        :keyword allow_virtual_network_access: Whether the VMs in the local virtual network space would
         be able to access the VMs in remote virtual network space.
        :paramtype allow_virtual_network_access: bool
        :keyword allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local
         virtual network will be allowed/disallowed in remote virtual network.
        :paramtype allow_forwarded_traffic: bool
        :keyword allow_gateway_transit: If gateway links can be used in remote virtual networking to
         link to this virtual network.
        :paramtype allow_gateway_transit: bool
        :keyword use_remote_gateways: If remote gateways can be used on this virtual network. If the
         flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network
         will use gateways of remote virtual network for transit. Only one peering can have this flag
         set to true. This flag cannot be set if virtual network already has a gateway.
        :paramtype use_remote_gateways: bool
        :keyword databricks_virtual_network: The remote virtual network should be in the same region.
         See here to learn more
         (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
        :paramtype databricks_virtual_network:
         ~azure.mgmt.databricks.models.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork
        :keyword databricks_address_space: The reference to the databricks virtual network address
         space.
        :paramtype databricks_address_space: ~azure.mgmt.databricks.models.AddressSpace
        :keyword remote_virtual_network: The remote virtual network should be in the same region. See
         here to learn more
         (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
         Required.
        :paramtype remote_virtual_network:
         ~azure.mgmt.databricks.models.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork
        :keyword remote_address_space: The reference to the remote virtual network address space.
        :paramtype remote_address_space: ~azure.mgmt.databricks.models.AddressSpace
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.databricks_virtual_network = databricks_virtual_network
        self.databricks_address_space = databricks_address_space
        self.remote_virtual_network = remote_virtual_network
        self.remote_address_space = remote_address_space
        self.peering_state = None
        self.provisioning_state = None


class VirtualNetworkPeeringList(_serialization.Model):
    """Gets all virtual network peerings under a workspace.

    :ivar value: List of virtual network peerings on workspace.
    :vartype value: list[~azure.mgmt.databricks.models.VirtualNetworkPeering]
    :ivar next_link: URL to get the next set of virtual network peering list results if there are
     any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of virtual network peerings on workspace.
        :paramtype value: list[~azure.mgmt.databricks.models.VirtualNetworkPeering]
        :keyword next_link: URL to get the next set of virtual network peering list results if there
         are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork(_serialization.Model):
    """The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).

    :ivar id: The Id of the databricks virtual network.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The Id of the databricks virtual network.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork(_serialization.Model):
    """The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).

    :ivar id: The Id of the remote virtual network.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The Id of the remote virtual network.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Workspace(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Information about workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.databricks.models.Sku
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.databricks.models.SystemData
    :ivar managed_resource_group_id: The managed resource group Id. Required.
    :vartype managed_resource_group_id: str
    :ivar parameters: The workspace's custom parameters.
    :vartype parameters: ~azure.mgmt.databricks.models.WorkspaceCustomParameters
    :ivar provisioning_state: The workspace provisioning state. Known values are: "Accepted",
     "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled", "Failed",
     "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.databricks.models.ProvisioningState
    :ivar ui_definition_uri: The blob URI where the UI definition file is located.
    :vartype ui_definition_uri: str
    :ivar authorizations: The workspace provider authorizations.
    :vartype authorizations: list[~azure.mgmt.databricks.models.WorkspaceProviderAuthorization]
    :ivar created_by: Indicates the Object ID, PUID and Application ID of entity that created the
     workspace.
    :vartype created_by: ~azure.mgmt.databricks.models.CreatedBy
    :ivar updated_by: Indicates the Object ID, PUID and Application ID of entity that last updated
     the workspace.
    :vartype updated_by: ~azure.mgmt.databricks.models.CreatedBy
    :ivar created_date_time: Specifies the date and time when the workspace is created.
    :vartype created_date_time: ~datetime.datetime
    :ivar workspace_id: The unique identifier of the databricks workspace in databricks control
     plane.
    :vartype workspace_id: str
    :ivar workspace_url: The workspace URL which is of the format
     'adb-{workspaceId}.{random}.azuredatabricks.net'.
    :vartype workspace_url: str
    :ivar storage_account_identity: The details of Managed Identity of Storage Account.
    :vartype storage_account_identity: ~azure.mgmt.databricks.models.ManagedIdentityConfiguration
    :ivar managed_disk_identity: The details of Managed Identity of Disk Encryption Set used for
     Managed Disk Encryption.
    :vartype managed_disk_identity: ~azure.mgmt.databricks.models.ManagedIdentityConfiguration
    :ivar disk_encryption_set_id: The resource Id of the managed disk encryption set.
    :vartype disk_encryption_set_id: str
    :ivar encryption: Encryption properties for databricks workspace.
    :vartype encryption: ~azure.mgmt.databricks.models.WorkspacePropertiesEncryption
    :ivar private_endpoint_connections: Private endpoint connections created on the workspace.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.databricks.models.PrivateEndpointConnection]
    :ivar public_network_access: The network access type for accessing workspace. Set value to
     disabled to access workspace only via private link. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.databricks.models.PublicNetworkAccess
    :ivar required_nsg_rules: Gets or sets a value indicating whether data plane (clusters) to
     control plane communication happen over private endpoint. Supported values are 'AllRules' and
     'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only. Known values
     are: "AllRules", "NoAzureDatabricksRules", and "NoAzureServiceRules".
    :vartype required_nsg_rules: str or ~azure.mgmt.databricks.models.RequiredNsgRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "managed_resource_group_id": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_date_time": {"readonly": True},
        "workspace_id": {"readonly": True},
        "workspace_url": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "managed_resource_group_id": {"key": "properties.managedResourceGroupId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "WorkspaceCustomParameters"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "ui_definition_uri": {"key": "properties.uiDefinitionUri", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[WorkspaceProviderAuthorization]"},
        "created_by": {"key": "properties.createdBy", "type": "CreatedBy"},
        "updated_by": {"key": "properties.updatedBy", "type": "CreatedBy"},
        "created_date_time": {"key": "properties.createdDateTime", "type": "iso-8601"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
        "workspace_url": {"key": "properties.workspaceUrl", "type": "str"},
        "storage_account_identity": {
            "key": "properties.storageAccountIdentity",
            "type": "ManagedIdentityConfiguration",
        },
        "managed_disk_identity": {"key": "properties.managedDiskIdentity", "type": "ManagedIdentityConfiguration"},
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "WorkspacePropertiesEncryption"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "required_nsg_rules": {"key": "properties.requiredNsgRules", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        managed_resource_group_id: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        parameters: Optional["_models.WorkspaceCustomParameters"] = None,
        ui_definition_uri: Optional[str] = None,
        authorizations: Optional[List["_models.WorkspaceProviderAuthorization"]] = None,
        created_by: Optional["_models.CreatedBy"] = None,
        updated_by: Optional["_models.CreatedBy"] = None,
        storage_account_identity: Optional["_models.ManagedIdentityConfiguration"] = None,
        managed_disk_identity: Optional["_models.ManagedIdentityConfiguration"] = None,
        disk_encryption_set_id: Optional[str] = None,
        encryption: Optional["_models.WorkspacePropertiesEncryption"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        required_nsg_rules: Optional[Union[str, "_models.RequiredNsgRules"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.databricks.models.Sku
        :keyword managed_resource_group_id: The managed resource group Id. Required.
        :paramtype managed_resource_group_id: str
        :keyword parameters: The workspace's custom parameters.
        :paramtype parameters: ~azure.mgmt.databricks.models.WorkspaceCustomParameters
        :keyword ui_definition_uri: The blob URI where the UI definition file is located.
        :paramtype ui_definition_uri: str
        :keyword authorizations: The workspace provider authorizations.
        :paramtype authorizations: list[~azure.mgmt.databricks.models.WorkspaceProviderAuthorization]
        :keyword created_by: Indicates the Object ID, PUID and Application ID of entity that created
         the workspace.
        :paramtype created_by: ~azure.mgmt.databricks.models.CreatedBy
        :keyword updated_by: Indicates the Object ID, PUID and Application ID of entity that last
         updated the workspace.
        :paramtype updated_by: ~azure.mgmt.databricks.models.CreatedBy
        :keyword storage_account_identity: The details of Managed Identity of Storage Account.
        :paramtype storage_account_identity: ~azure.mgmt.databricks.models.ManagedIdentityConfiguration
        :keyword managed_disk_identity: The details of Managed Identity of Disk Encryption Set used for
         Managed Disk Encryption.
        :paramtype managed_disk_identity: ~azure.mgmt.databricks.models.ManagedIdentityConfiguration
        :keyword disk_encryption_set_id: The resource Id of the managed disk encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword encryption: Encryption properties for databricks workspace.
        :paramtype encryption: ~azure.mgmt.databricks.models.WorkspacePropertiesEncryption
        :keyword public_network_access: The network access type for accessing workspace. Set value to
         disabled to access workspace only via private link. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.databricks.models.PublicNetworkAccess
        :keyword required_nsg_rules: Gets or sets a value indicating whether data plane (clusters) to
         control plane communication happen over private endpoint. Supported values are 'AllRules' and
         'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only. Known values
         are: "AllRules", "NoAzureDatabricksRules", and "NoAzureServiceRules".
        :paramtype required_nsg_rules: str or ~azure.mgmt.databricks.models.RequiredNsgRules
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.system_data = None
        self.managed_resource_group_id = managed_resource_group_id
        self.parameters = parameters
        self.provisioning_state = None
        self.ui_definition_uri = ui_definition_uri
        self.authorizations = authorizations
        self.created_by = created_by
        self.updated_by = updated_by
        self.created_date_time = None
        self.workspace_id = None
        self.workspace_url = None
        self.storage_account_identity = storage_account_identity
        self.managed_disk_identity = managed_disk_identity
        self.disk_encryption_set_id = disk_encryption_set_id
        self.encryption = encryption
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.required_nsg_rules = required_nsg_rules


class WorkspaceCustomBooleanParameter(_serialization.Model):
    """The value which should be used for this field.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of variable that this is. Known values are: "Bool", "Object", and
     "String".
    :vartype type: str or ~azure.mgmt.databricks.models.CustomParameterType
    :ivar value: The value which should be used for this field. Required.
    :vartype value: bool
    """

    _validation = {
        "type": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "bool"},
    }

    def __init__(self, *, value: bool, **kwargs):
        """
        :keyword value: The value which should be used for this field. Required.
        :paramtype value: bool
        """
        super().__init__(**kwargs)
        self.type = None
        self.value = value


class WorkspaceCustomObjectParameter(_serialization.Model):
    """The value which should be used for this field.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of variable that this is. Known values are: "Bool", "Object", and
     "String".
    :vartype type: str or ~azure.mgmt.databricks.models.CustomParameterType
    :ivar value: The value which should be used for this field. Required.
    :vartype value: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: JSON, **kwargs):
        """
        :keyword value: The value which should be used for this field. Required.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.type = None
        self.value = value


class WorkspaceCustomParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Custom Parameters used for Cluster Creation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aml_workspace_id: The ID of a Azure Machine Learning workspace to link with Databricks
     workspace.
    :vartype aml_workspace_id: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar custom_virtual_network_id: The ID of a Virtual Network where this Databricks Cluster
     should be created.
    :vartype custom_virtual_network_id:
     ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar custom_public_subnet_name: The name of a Public Subnet within the Virtual Network.
    :vartype custom_public_subnet_name:
     ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar custom_private_subnet_name: The name of the Private Subnet within the Virtual Network.
    :vartype custom_private_subnet_name:
     ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar enable_no_public_ip: Should the Public IP be Disabled?.
    :vartype enable_no_public_ip: ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
    :ivar load_balancer_backend_pool_name: Name of the outbound Load Balancer Backend Pool for
     Secure Cluster Connectivity (No Public IP).
    :vartype load_balancer_backend_pool_name:
     ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar load_balancer_id: Resource URI of Outbound Load balancer for Secure Cluster Connectivity
     (No Public IP) workspace.
    :vartype load_balancer_id: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar nat_gateway_name: Name of the NAT gateway for Secure Cluster Connectivity (No Public IP)
     workspace subnets.
    :vartype nat_gateway_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar public_ip_name: Name of the Public IP for No Public IP workspace with managed vNet.
    :vartype public_ip_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar prepare_encryption: Prepare the workspace for encryption. Enables the Managed Identity
     for managed storage account.
    :vartype prepare_encryption: ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
    :ivar encryption: Contains the encryption details for Customer-Managed Key (CMK) enabled
     workspace.
    :vartype encryption: ~azure.mgmt.databricks.models.WorkspaceEncryptionParameter
    :ivar require_infrastructure_encryption: A boolean indicating whether or not the DBFS root file
     system will be enabled with secondary layer of encryption with platform managed keys for data
     at rest.
    :vartype require_infrastructure_encryption:
     ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
    :ivar storage_account_name: Default DBFS storage account name.
    :vartype storage_account_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar storage_account_sku_name: Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer
     https://aka.ms/storageskus for valid inputs.
    :vartype storage_account_sku_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar vnet_address_prefix: Address prefix for Managed virtual network. Default value for this
     input is 10.139.
    :vartype vnet_address_prefix: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
    :ivar resource_tags: Tags applied to resources under Managed resource group. These can be
     updated by updating tags at workspace level.
    :vartype resource_tags: ~azure.mgmt.databricks.models.WorkspaceCustomObjectParameter
    """

    _validation = {
        "resource_tags": {"readonly": True},
    }

    _attribute_map = {
        "aml_workspace_id": {"key": "amlWorkspaceId", "type": "WorkspaceCustomStringParameter"},
        "custom_virtual_network_id": {"key": "customVirtualNetworkId", "type": "WorkspaceCustomStringParameter"},
        "custom_public_subnet_name": {"key": "customPublicSubnetName", "type": "WorkspaceCustomStringParameter"},
        "custom_private_subnet_name": {"key": "customPrivateSubnetName", "type": "WorkspaceCustomStringParameter"},
        "enable_no_public_ip": {"key": "enableNoPublicIp", "type": "WorkspaceCustomBooleanParameter"},
        "load_balancer_backend_pool_name": {
            "key": "loadBalancerBackendPoolName",
            "type": "WorkspaceCustomStringParameter",
        },
        "load_balancer_id": {"key": "loadBalancerId", "type": "WorkspaceCustomStringParameter"},
        "nat_gateway_name": {"key": "natGatewayName", "type": "WorkspaceCustomStringParameter"},
        "public_ip_name": {"key": "publicIpName", "type": "WorkspaceCustomStringParameter"},
        "prepare_encryption": {"key": "prepareEncryption", "type": "WorkspaceCustomBooleanParameter"},
        "encryption": {"key": "encryption", "type": "WorkspaceEncryptionParameter"},
        "require_infrastructure_encryption": {
            "key": "requireInfrastructureEncryption",
            "type": "WorkspaceCustomBooleanParameter",
        },
        "storage_account_name": {"key": "storageAccountName", "type": "WorkspaceCustomStringParameter"},
        "storage_account_sku_name": {"key": "storageAccountSkuName", "type": "WorkspaceCustomStringParameter"},
        "vnet_address_prefix": {"key": "vnetAddressPrefix", "type": "WorkspaceCustomStringParameter"},
        "resource_tags": {"key": "resourceTags", "type": "WorkspaceCustomObjectParameter"},
    }

    def __init__(
        self,
        *,
        aml_workspace_id: Optional["_models.WorkspaceCustomStringParameter"] = None,
        custom_virtual_network_id: Optional["_models.WorkspaceCustomStringParameter"] = None,
        custom_public_subnet_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        custom_private_subnet_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        enable_no_public_ip: Optional["_models.WorkspaceCustomBooleanParameter"] = None,
        load_balancer_backend_pool_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        load_balancer_id: Optional["_models.WorkspaceCustomStringParameter"] = None,
        nat_gateway_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        public_ip_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        prepare_encryption: Optional["_models.WorkspaceCustomBooleanParameter"] = None,
        encryption: Optional["_models.WorkspaceEncryptionParameter"] = None,
        require_infrastructure_encryption: Optional["_models.WorkspaceCustomBooleanParameter"] = None,
        storage_account_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        storage_account_sku_name: Optional["_models.WorkspaceCustomStringParameter"] = None,
        vnet_address_prefix: Optional["_models.WorkspaceCustomStringParameter"] = None,
        **kwargs
    ):
        """
        :keyword aml_workspace_id: The ID of a Azure Machine Learning workspace to link with Databricks
         workspace.
        :paramtype aml_workspace_id: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword custom_virtual_network_id: The ID of a Virtual Network where this Databricks Cluster
         should be created.
        :paramtype custom_virtual_network_id:
         ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword custom_public_subnet_name: The name of a Public Subnet within the Virtual Network.
        :paramtype custom_public_subnet_name:
         ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword custom_private_subnet_name: The name of the Private Subnet within the Virtual Network.
        :paramtype custom_private_subnet_name:
         ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword enable_no_public_ip: Should the Public IP be Disabled?.
        :paramtype enable_no_public_ip: ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
        :keyword load_balancer_backend_pool_name: Name of the outbound Load Balancer Backend Pool for
         Secure Cluster Connectivity (No Public IP).
        :paramtype load_balancer_backend_pool_name:
         ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword load_balancer_id: Resource URI of Outbound Load balancer for Secure Cluster
         Connectivity (No Public IP) workspace.
        :paramtype load_balancer_id: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword nat_gateway_name: Name of the NAT gateway for Secure Cluster Connectivity (No Public
         IP) workspace subnets.
        :paramtype nat_gateway_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword public_ip_name: Name of the Public IP for No Public IP workspace with managed vNet.
        :paramtype public_ip_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword prepare_encryption: Prepare the workspace for encryption. Enables the Managed Identity
         for managed storage account.
        :paramtype prepare_encryption: ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
        :keyword encryption: Contains the encryption details for Customer-Managed Key (CMK) enabled
         workspace.
        :paramtype encryption: ~azure.mgmt.databricks.models.WorkspaceEncryptionParameter
        :keyword require_infrastructure_encryption: A boolean indicating whether or not the DBFS root
         file system will be enabled with secondary layer of encryption with platform managed keys for
         data at rest.
        :paramtype require_infrastructure_encryption:
         ~azure.mgmt.databricks.models.WorkspaceCustomBooleanParameter
        :keyword storage_account_name: Default DBFS storage account name.
        :paramtype storage_account_name: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword storage_account_sku_name: Storage account SKU name, ex: Standard_GRS, Standard_LRS.
         Refer https://aka.ms/storageskus for valid inputs.
        :paramtype storage_account_sku_name:
         ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        :keyword vnet_address_prefix: Address prefix for Managed virtual network. Default value for
         this input is 10.139.
        :paramtype vnet_address_prefix: ~azure.mgmt.databricks.models.WorkspaceCustomStringParameter
        """
        super().__init__(**kwargs)
        self.aml_workspace_id = aml_workspace_id
        self.custom_virtual_network_id = custom_virtual_network_id
        self.custom_public_subnet_name = custom_public_subnet_name
        self.custom_private_subnet_name = custom_private_subnet_name
        self.enable_no_public_ip = enable_no_public_ip
        self.load_balancer_backend_pool_name = load_balancer_backend_pool_name
        self.load_balancer_id = load_balancer_id
        self.nat_gateway_name = nat_gateway_name
        self.public_ip_name = public_ip_name
        self.prepare_encryption = prepare_encryption
        self.encryption = encryption
        self.require_infrastructure_encryption = require_infrastructure_encryption
        self.storage_account_name = storage_account_name
        self.storage_account_sku_name = storage_account_sku_name
        self.vnet_address_prefix = vnet_address_prefix
        self.resource_tags = None


class WorkspaceCustomStringParameter(_serialization.Model):
    """The Value.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of variable that this is. Known values are: "Bool", "Object", and
     "String".
    :vartype type: str or ~azure.mgmt.databricks.models.CustomParameterType
    :ivar value: The value which should be used for this field. Required.
    :vartype value: str
    """

    _validation = {
        "type": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs):
        """
        :keyword value: The value which should be used for this field. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = None
        self.value = value


class WorkspaceEncryptionParameter(_serialization.Model):
    """The object that contains details of encryption used on the workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of variable that this is. Known values are: "Bool", "Object", and
     "String".
    :vartype type: str or ~azure.mgmt.databricks.models.CustomParameterType
    :ivar value: The value which should be used for this field.
    :vartype value: ~azure.mgmt.databricks.models.Encryption
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "Encryption"},
    }

    def __init__(self, *, value: Optional["_models.Encryption"] = None, **kwargs):
        """
        :keyword value: The value which should be used for this field.
        :paramtype value: ~azure.mgmt.databricks.models.Encryption
        """
        super().__init__(**kwargs)
        self.type = None
        self.value = value


class WorkspaceListResult(_serialization.Model):
    """List of workspaces.

    :ivar value: The array of workspaces.
    :vartype value: list[~azure.mgmt.databricks.models.Workspace]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Workspace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Workspace"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The array of workspaces.
        :paramtype value: list[~azure.mgmt.databricks.models.Workspace]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkspacePropertiesEncryption(_serialization.Model):
    """Encryption properties for databricks workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar entities: Encryption entities definition for the workspace. Required.
    :vartype entities: ~azure.mgmt.databricks.models.EncryptionEntitiesDefinition
    """

    _validation = {
        "entities": {"required": True},
    }

    _attribute_map = {
        "entities": {"key": "entities", "type": "EncryptionEntitiesDefinition"},
    }

    def __init__(self, *, entities: "_models.EncryptionEntitiesDefinition", **kwargs):
        """
        :keyword entities: Encryption entities definition for the workspace. Required.
        :paramtype entities: ~azure.mgmt.databricks.models.EncryptionEntitiesDefinition
        """
        super().__init__(**kwargs)
        self.entities = entities


class WorkspaceProviderAuthorization(_serialization.Model):
    """The workspace provider authorization.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The provider's principal identifier. This is the identity that the provider
     will use to call ARM to manage the workspace resources. Required.
    :vartype principal_id: str
    :ivar role_definition_id: The provider's role definition identifier. This role will define all
     the permissions that the provider must have on the workspace's container resource group. This
     role definition cannot have permission to delete the resource group. Required.
    :vartype role_definition_id: str
    """

    _validation = {
        "principal_id": {"required": True},
        "role_definition_id": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
    }

    def __init__(self, *, principal_id: str, role_definition_id: str, **kwargs):
        """
        :keyword principal_id: The provider's principal identifier. This is the identity that the
         provider will use to call ARM to manage the workspace resources. Required.
        :paramtype principal_id: str
        :keyword role_definition_id: The provider's role definition identifier. This role will define
         all the permissions that the provider must have on the workspace's container resource group.
         This role definition cannot have permission to delete the resource group. Required.
        :paramtype role_definition_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id


class WorkspaceUpdate(_serialization.Model):
    """An update to a workspace.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
