# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AddressDetails(msrest.serialization.Model):
    """Address details for an order item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param forward_address: Required. Customer address and contact details. It should be address
     resource.
    :type forward_address: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressProperties
    :ivar return_address: Return shipping address.
    :vartype return_address: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressProperties
    """

    _validation = {
        'forward_address': {'required': True},
        'return_address': {'readonly': True},
    }

    _attribute_map = {
        'forward_address': {'key': 'forwardAddress', 'type': 'AddressProperties'},
        'return_address': {'key': 'returnAddress', 'type': 'AddressProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressDetails, self).__init__(**kwargs)
        self.forward_address = kwargs['forward_address']
        self.return_address = None


class AddressProperties(msrest.serialization.Model):
    """Address Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param shipping_address: Shipping details for the address.
    :type shipping_address: ~azure.mgmt.edgeorder.v2021_12_01.models.ShippingAddress
    :param contact_details: Required. Contact details for the address.
    :type contact_details: ~azure.mgmt.edgeorder.v2021_12_01.models.ContactDetails
    :ivar address_validation_status: Status of address validation. Possible values include:
     "Valid", "Invalid", "Ambiguous".
    :vartype address_validation_status: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.AddressValidationStatus
    """

    _validation = {
        'contact_details': {'required': True},
        'address_validation_status': {'readonly': True},
    }

    _attribute_map = {
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'address_validation_status': {'key': 'addressValidationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressProperties, self).__init__(**kwargs)
        self.shipping_address = kwargs.get('shipping_address', None)
        self.contact_details = kwargs['contact_details']
        self.address_validation_status = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class AddressResource(TrackedResource):
    """Address Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.v2021_12_01.models.SystemData
    :param shipping_address: Shipping details for the address.
    :type shipping_address: ~azure.mgmt.edgeorder.v2021_12_01.models.ShippingAddress
    :param contact_details: Required. Contact details for the address.
    :type contact_details: ~azure.mgmt.edgeorder.v2021_12_01.models.ContactDetails
    :ivar address_validation_status: Status of address validation. Possible values include:
     "Valid", "Invalid", "Ambiguous".
    :vartype address_validation_status: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.AddressValidationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'contact_details': {'required': True},
        'address_validation_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'shipping_address': {'key': 'properties.shippingAddress', 'type': 'ShippingAddress'},
        'contact_details': {'key': 'properties.contactDetails', 'type': 'ContactDetails'},
        'address_validation_status': {'key': 'properties.addressValidationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressResource, self).__init__(**kwargs)
        self.system_data = None
        self.shipping_address = kwargs.get('shipping_address', None)
        self.contact_details = kwargs['contact_details']
        self.address_validation_status = None


class AddressResourceList(msrest.serialization.Model):
    """Address Resource Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of address resources.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
    :param next_link: Link for the next set of job resources.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AddressResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressResourceList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class AddressUpdateParameter(msrest.serialization.Model):
    """The Address update parameters.

    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param shipping_address: Shipping details for the address.
    :type shipping_address: ~azure.mgmt.edgeorder.v2021_12_01.models.ShippingAddress
    :param contact_details: Contact details for the address.
    :type contact_details: ~azure.mgmt.edgeorder.v2021_12_01.models.ContactDetails
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'shipping_address': {'key': 'properties.shippingAddress', 'type': 'ShippingAddress'},
        'contact_details': {'key': 'properties.contactDetails', 'type': 'ContactDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressUpdateParameter, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.shipping_address = kwargs.get('shipping_address', None)
        self.contact_details = kwargs.get('contact_details', None)


class AvailabilityInformation(msrest.serialization.Model):
    """Availability information of a product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar availability_stage: Current availability stage of the product. Availability stage.
     Possible values include: "Available", "ComingSoon", "Preview", "Deprecated", "Signup",
     "Unavailable".
    :vartype availability_stage: str or ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityStage
    :ivar disabled_reason: Reason why the product is disabled. Possible values include: "None",
     "Country", "Region", "Feature", "OfferType", "NoSubscriptionInfo", "NotAvailable",
     "OutOfStock".
    :vartype disabled_reason: str or ~azure.mgmt.edgeorder.v2021_12_01.models.DisabledReason
    :ivar disabled_reason_message: Message for why the product is disabled.
    :vartype disabled_reason_message: str
    """

    _validation = {
        'availability_stage': {'readonly': True},
        'disabled_reason': {'readonly': True},
        'disabled_reason_message': {'readonly': True},
    }

    _attribute_map = {
        'availability_stage': {'key': 'availabilityStage', 'type': 'str'},
        'disabled_reason': {'key': 'disabledReason', 'type': 'str'},
        'disabled_reason_message': {'key': 'disabledReasonMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailabilityInformation, self).__init__(**kwargs)
        self.availability_stage = None
        self.disabled_reason = None
        self.disabled_reason_message = None


class BasicInformation(msrest.serialization.Model):
    """Basic information for any product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BasicInformation, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None


class BillingMeterDetails(msrest.serialization.Model):
    """Holds billing meter details for each type of billing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Represents Billing type name.
    :vartype name: str
    :ivar meter_details: Represents MeterDetails.
    :vartype meter_details: ~azure.mgmt.edgeorder.v2021_12_01.models.MeterDetails
    :ivar metering_type: Represents Metering type (eg one-time or recurrent). Possible values
     include: "OneTime", "Recurring", "Adhoc".
    :vartype metering_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.MeteringType
    :ivar frequency: Frequency of recurrence.
    :vartype frequency: str
    """

    _validation = {
        'name': {'readonly': True},
        'meter_details': {'readonly': True},
        'metering_type': {'readonly': True},
        'frequency': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'meter_details': {'key': 'meterDetails', 'type': 'MeterDetails'},
        'metering_type': {'key': 'meteringType', 'type': 'str'},
        'frequency': {'key': 'frequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingMeterDetails, self).__init__(**kwargs)
        self.name = None
        self.meter_details = None
        self.metering_type = None
        self.frequency = None


class CancellationReason(msrest.serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to Azure.

    :param reason: Required. Reason for cancellation.
    :type reason: str
    """

    _validation = {
        'reason': {'required': True},
    }

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CancellationReason, self).__init__(**kwargs)
        self.reason = kwargs['reason']


class CommonProperties(BasicInformation):
    """Represents common properties across product hierarchy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'filterableProperties', 'type': '[FilterableProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommonProperties, self).__init__(**kwargs)
        self.filterable_properties = None


class Configuration(msrest.serialization.Model):
    """Configuration object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar specifications: Specifications of the configuration.
    :vartype specifications: list[~azure.mgmt.edgeorder.v2021_12_01.models.Specification]
    :ivar dimensions: Dimensions of the configuration.
    :vartype dimensions: ~azure.mgmt.edgeorder.v2021_12_01.models.Dimensions
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'specifications': {'readonly': True},
        'dimensions': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'Description'},
        'image_information': {'key': 'properties.imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'properties.costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'properties.availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'properties.hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'properties.filterableProperties', 'type': '[FilterableProperty]'},
        'specifications': {'key': 'properties.specifications', 'type': '[Specification]'},
        'dimensions': {'key': 'properties.dimensions', 'type': 'Dimensions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.specifications = None
        self.dimensions = None


class ConfigurationFilters(msrest.serialization.Model):
    """Configuration filters.

    All required parameters must be populated in order to send to Azure.

    :param hierarchy_information: Required. Product hierarchy information.
    :type hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :param filterable_property: Filters specific to product.
    :type filterable_property: list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    """

    _validation = {
        'hierarchy_information': {'required': True},
    }

    _attribute_map = {
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_property': {'key': 'filterableProperty', 'type': '[FilterableProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationFilters, self).__init__(**kwargs)
        self.hierarchy_information = kwargs['hierarchy_information']
        self.filterable_property = kwargs.get('filterable_property', None)


class ConfigurationProperties(CommonProperties):
    """Properties of configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar specifications: Specifications of the configuration.
    :vartype specifications: list[~azure.mgmt.edgeorder.v2021_12_01.models.Specification]
    :ivar dimensions: Dimensions of the configuration.
    :vartype dimensions: ~azure.mgmt.edgeorder.v2021_12_01.models.Dimensions
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'specifications': {'readonly': True},
        'dimensions': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'filterableProperties', 'type': '[FilterableProperty]'},
        'specifications': {'key': 'specifications', 'type': '[Specification]'},
        'dimensions': {'key': 'dimensions', 'type': 'Dimensions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationProperties, self).__init__(**kwargs)
        self.specifications = None
        self.dimensions = None


class Configurations(msrest.serialization.Model):
    """The list of configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of configurations.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.Configuration]
    :param next_link: Link for the next set of configurations.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Configurations, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class ConfigurationsRequest(msrest.serialization.Model):
    """Configuration request object.

    All required parameters must be populated in order to send to Azure.

    :param configuration_filters: Required. Holds details about product hierarchy information and
     filterable property.
    :type configuration_filters:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.ConfigurationFilters]
    :param customer_subscription_details: Customer subscription properties. Clients can display
     available products to unregistered customers by explicitly passing subscription details.
    :type customer_subscription_details:
     ~azure.mgmt.edgeorder.v2021_12_01.models.CustomerSubscriptionDetails
    """

    _validation = {
        'configuration_filters': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'configuration_filters': {'key': 'configurationFilters', 'type': '[ConfigurationFilters]'},
        'customer_subscription_details': {'key': 'customerSubscriptionDetails', 'type': 'CustomerSubscriptionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationsRequest, self).__init__(**kwargs)
        self.configuration_filters = kwargs['configuration_filters']
        self.customer_subscription_details = kwargs.get('customer_subscription_details', None)


class ContactDetails(msrest.serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to Azure.

    :param contact_name: Required. Contact name of the person.
    :type contact_name: str
    :param phone: Required. Phone number of the contact person.
    :type phone: str
    :param phone_extension: Phone extension number of the contact person.
    :type phone_extension: str
    :param mobile: Mobile number of the contact person.
    :type mobile: str
    :param email_list: Required. List of Email-ids to be notified about job progress.
    :type email_list: list[str]
    """

    _validation = {
        'contact_name': {'required': True},
        'phone': {'required': True},
        'email_list': {'required': True},
    }

    _attribute_map = {
        'contact_name': {'key': 'contactName', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'phone_extension': {'key': 'phoneExtension', 'type': 'str'},
        'mobile': {'key': 'mobile', 'type': 'str'},
        'email_list': {'key': 'emailList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactDetails, self).__init__(**kwargs)
        self.contact_name = kwargs['contact_name']
        self.phone = kwargs['phone']
        self.phone_extension = kwargs.get('phone_extension', None)
        self.mobile = kwargs.get('mobile', None)
        self.email_list = kwargs['email_list']


class CostInformation(msrest.serialization.Model):
    """Cost information for the product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar billing_meter_details: Details on the various billing aspects for the product system.
    :vartype billing_meter_details:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.BillingMeterDetails]
    :ivar billing_info_url: Default url to display billing information.
    :vartype billing_info_url: str
    """

    _validation = {
        'billing_meter_details': {'readonly': True},
        'billing_info_url': {'readonly': True},
    }

    _attribute_map = {
        'billing_meter_details': {'key': 'billingMeterDetails', 'type': '[BillingMeterDetails]'},
        'billing_info_url': {'key': 'billingInfoUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CostInformation, self).__init__(**kwargs)
        self.billing_meter_details = None
        self.billing_info_url = None


class CustomerSubscriptionDetails(msrest.serialization.Model):
    """Holds Customer subscription details. Clients can display available products to unregistered customers by explicitly passing subscription details.

    All required parameters must be populated in order to send to Azure.

    :param registered_features: List of registered feature flags for subscription.
    :type registered_features:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.CustomerSubscriptionRegisteredFeatures]
    :param location_placement_id: Location placement Id of a subscription.
    :type location_placement_id: str
    :param quota_id: Required. Quota ID of a subscription.
    :type quota_id: str
    """

    _validation = {
        'quota_id': {'required': True},
    }

    _attribute_map = {
        'registered_features': {'key': 'registeredFeatures', 'type': '[CustomerSubscriptionRegisteredFeatures]'},
        'location_placement_id': {'key': 'locationPlacementId', 'type': 'str'},
        'quota_id': {'key': 'quotaId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomerSubscriptionDetails, self).__init__(**kwargs)
        self.registered_features = kwargs.get('registered_features', None)
        self.location_placement_id = kwargs.get('location_placement_id', None)
        self.quota_id = kwargs['quota_id']


class CustomerSubscriptionRegisteredFeatures(msrest.serialization.Model):
    """Represents subscription registered features.

    :param name: Name of subscription registered feature.
    :type name: str
    :param state: State of subscription registered feature.
    :type state: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomerSubscriptionRegisteredFeatures, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.state = kwargs.get('state', None)


class Description(msrest.serialization.Model):
    """Description related properties of a product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description_type: Type of description. Possible values include: "Base".
    :vartype description_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.DescriptionType
    :ivar short_description: Short description of the product system.
    :vartype short_description: str
    :ivar long_description: Long description of the product system.
    :vartype long_description: str
    :ivar keywords: Keywords for the product system.
    :vartype keywords: list[str]
    :ivar attributes: Attributes for the product system.
    :vartype attributes: list[str]
    :ivar links: Links for the product system.
    :vartype links: list[~azure.mgmt.edgeorder.v2021_12_01.models.Link]
    """

    _validation = {
        'description_type': {'readonly': True},
        'short_description': {'readonly': True},
        'long_description': {'readonly': True},
        'keywords': {'readonly': True},
        'attributes': {'readonly': True},
        'links': {'readonly': True},
    }

    _attribute_map = {
        'description_type': {'key': 'descriptionType', 'type': 'str'},
        'short_description': {'key': 'shortDescription', 'type': 'str'},
        'long_description': {'key': 'longDescription', 'type': 'str'},
        'keywords': {'key': 'keywords', 'type': '[str]'},
        'attributes': {'key': 'attributes', 'type': '[str]'},
        'links': {'key': 'links', 'type': '[Link]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Description, self).__init__(**kwargs)
        self.description_type = None
        self.short_description = None
        self.long_description = None
        self.keywords = None
        self.attributes = None
        self.links = None


class DeviceDetails(msrest.serialization.Model):
    """Device details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: device serial number.
    :vartype serial_number: str
    :ivar management_resource_id: Management Resource Id.
    :vartype management_resource_id: str
    :ivar management_resource_tenant_id: Management Resource Tenant ID.
    :vartype management_resource_tenant_id: str
    """

    _validation = {
        'serial_number': {'readonly': True},
        'management_resource_id': {'readonly': True},
        'management_resource_tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'management_resource_id': {'key': 'managementResourceId', 'type': 'str'},
        'management_resource_tenant_id': {'key': 'managementResourceTenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeviceDetails, self).__init__(**kwargs)
        self.serial_number = None
        self.management_resource_id = None
        self.management_resource_tenant_id = None


class Dimensions(msrest.serialization.Model):
    """Dimensions of a configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar length: Length of the device.
    :vartype length: float
    :ivar height: Height of the device.
    :vartype height: float
    :ivar width: Width of the device.
    :vartype width: float
    :ivar length_height_unit: Unit for the dimensions of length, height and width. Possible values
     include: "IN", "CM".
    :vartype length_height_unit: str or ~azure.mgmt.edgeorder.v2021_12_01.models.LengthHeightUnit
    :ivar weight: Weight of the device.
    :vartype weight: float
    :ivar depth: Depth of the device.
    :vartype depth: float
    :ivar weight_unit: Unit for the dimensions of weight. Possible values include: "LBS", "KGS".
    :vartype weight_unit: str or ~azure.mgmt.edgeorder.v2021_12_01.models.WeightMeasurementUnit
    """

    _validation = {
        'length': {'readonly': True},
        'height': {'readonly': True},
        'width': {'readonly': True},
        'length_height_unit': {'readonly': True},
        'weight': {'readonly': True},
        'depth': {'readonly': True},
        'weight_unit': {'readonly': True},
    }

    _attribute_map = {
        'length': {'key': 'length', 'type': 'float'},
        'height': {'key': 'height', 'type': 'float'},
        'width': {'key': 'width', 'type': 'float'},
        'length_height_unit': {'key': 'lengthHeightUnit', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'float'},
        'depth': {'key': 'depth', 'type': 'float'},
        'weight_unit': {'key': 'weightUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimensions, self).__init__(**kwargs)
        self.length = None
        self.height = None
        self.width = None
        self.length_height_unit = None
        self.weight = None
        self.depth = None
        self.weight_unit = None


class DisplayInfo(msrest.serialization.Model):
    """Describes product display information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar product_family_display_name: Product family display name.
    :vartype product_family_display_name: str
    :ivar configuration_display_name: Configuration display name.
    :vartype configuration_display_name: str
    """

    _validation = {
        'product_family_display_name': {'readonly': True},
        'configuration_display_name': {'readonly': True},
    }

    _attribute_map = {
        'product_family_display_name': {'key': 'productFamilyDisplayName', 'type': 'str'},
        'configuration_display_name': {'key': 'configurationDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DisplayInfo, self).__init__(**kwargs)
        self.product_family_display_name = None
        self.configuration_display_name = None


class EncryptionPreferences(msrest.serialization.Model):
    """Preferences related to the double encryption.

    :param double_encryption_status: Double encryption status as entered by the customer. It is
     compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured. Possible
     values include: "Disabled", "Enabled".
    :type double_encryption_status: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.DoubleEncryptionStatus
    """

    _attribute_map = {
        'double_encryption_status': {'key': 'doubleEncryptionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionPreferences, self).__init__(**kwargs)
        self.double_encryption_status = kwargs.get('double_encryption_status', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.edgeorder.v2021_12_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.edgeorder.v2021_12_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.edgeorder.v2021_12_01.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class FilterableProperty(msrest.serialization.Model):
    """Different types of filters supported and its values.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of product filter. Possible values include: "ShipToCountries",
     "DoubleEncryptionStatus".
    :type type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.SupportedFilterTypes
    :param supported_values: Required. Values to be filtered.
    :type supported_values: list[str]
    """

    _validation = {
        'type': {'required': True},
        'supported_values': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'supported_values': {'key': 'supportedValues', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilterableProperty, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.supported_values = kwargs['supported_values']


class ForwardShippingDetails(msrest.serialization.Model):
    """Forward shipment details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        'carrier_name': {'readonly': True},
        'carrier_display_name': {'readonly': True},
        'tracking_id': {'readonly': True},
        'tracking_url': {'readonly': True},
    }

    _attribute_map = {
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'carrier_display_name': {'key': 'carrierDisplayName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForwardShippingDetails, self).__init__(**kwargs)
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class HierarchyInformation(msrest.serialization.Model):
    """Holds details about product hierarchy information.

    :param product_family_name: Represents product family name that uniquely identifies product
     family.
    :type product_family_name: str
    :param product_line_name: Represents product line name that uniquely identifies product line.
    :type product_line_name: str
    :param product_name: Represents product name that uniquely identifies product.
    :type product_name: str
    :param configuration_name: Represents configuration name that uniquely identifies
     configuration.
    :type configuration_name: str
    """

    _attribute_map = {
        'product_family_name': {'key': 'productFamilyName', 'type': 'str'},
        'product_line_name': {'key': 'productLineName', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'configuration_name': {'key': 'configurationName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HierarchyInformation, self).__init__(**kwargs)
        self.product_family_name = kwargs.get('product_family_name', None)
        self.product_line_name = kwargs.get('product_line_name', None)
        self.product_name = kwargs.get('product_name', None)
        self.configuration_name = kwargs.get('configuration_name', None)


class ImageInformation(msrest.serialization.Model):
    """Image for the product.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar image_type: Type of the image. Possible values include: "MainImage", "BulletImage",
     "GenericImage".
    :vartype image_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ImageType
    :ivar image_url: Url of the image.
    :vartype image_url: str
    """

    _validation = {
        'image_type': {'readonly': True},
        'image_url': {'readonly': True},
    }

    _attribute_map = {
        'image_type': {'key': 'imageType', 'type': 'str'},
        'image_url': {'key': 'imageUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageInformation, self).__init__(**kwargs)
        self.image_type = None
        self.image_url = None


class Link(msrest.serialization.Model):
    """Returns link related to the product.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar link_type: Type of link. Possible values include: "Generic", "TermsAndConditions",
     "Specification", "Documentation", "KnowMore", "SignUp".
    :vartype link_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.LinkType
    :ivar link_url: Url of the link.
    :vartype link_url: str
    """

    _validation = {
        'link_type': {'readonly': True},
        'link_url': {'readonly': True},
    }

    _attribute_map = {
        'link_type': {'key': 'linkType', 'type': 'str'},
        'link_url': {'key': 'linkUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Link, self).__init__(**kwargs)
        self.link_type = None
        self.link_url = None


class ManagementResourcePreferences(msrest.serialization.Model):
    """Management resource preference to link device.

    :param preferred_management_resource_id: Customer preferred Management resource ARM ID.
    :type preferred_management_resource_id: str
    """

    _attribute_map = {
        'preferred_management_resource_id': {'key': 'preferredManagementResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementResourcePreferences, self).__init__(**kwargs)
        self.preferred_management_resource_id = kwargs.get('preferred_management_resource_id', None)


class MeterDetails(msrest.serialization.Model):
    """Holds details about billing type and its meter guids.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Pav2MeterDetails, PurchaseMeterDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param billing_type: Required. Represents billing type.Constant filled by server.  Possible
     values include: "Pav2", "Purchase".
    :type billing_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Possible values include: "PerOrder", "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ChargingType
    """

    _validation = {
        'billing_type': {'required': True},
        'multiplier': {'readonly': True},
        'charging_type': {'readonly': True},
    }

    _attribute_map = {
        'billing_type': {'key': 'billingType', 'type': 'str'},
        'multiplier': {'key': 'multiplier', 'type': 'float'},
        'charging_type': {'key': 'chargingType', 'type': 'str'},
    }

    _subtype_map = {
        'billing_type': {'Pav2': 'Pav2MeterDetails', 'Purchase': 'PurchaseMeterDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MeterDetails, self).__init__(**kwargs)
        self.billing_type = None  # type: Optional[str]
        self.multiplier = None
        self.charging_type = None


class NotificationPreference(msrest.serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to Azure.

    :param stage_name: Required. Name of the stage. Possible values include: "Shipped",
     "Delivered".
    :type stage_name: str or ~azure.mgmt.edgeorder.v2021_12_01.models.NotificationStageName
    :param send_notification: Required. Notification is required or not.
    :type send_notification: bool
    """

    _validation = {
        'stage_name': {'required': True},
        'send_notification': {'required': True},
    }

    _attribute_map = {
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'send_notification': {'key': 'sendNotification', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationPreference, self).__init__(**kwargs)
        self.stage_name = kwargs['stage_name']
        self.send_notification = kwargs['send_notification']


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :param display: Localized display information for this particular operation.
    :type display: ~azure.mgmt.edgeorder.v2021_12_01.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.edgeorder.v2021_12_01.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = kwargs.get('display', None)
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrderItemDetails(msrest.serialization.Model):
    """Order item details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param product_details: Required. Unique identifier for configuration.
    :type product_details: ~azure.mgmt.edgeorder.v2021_12_01.models.ProductDetails
    :param order_item_type: Required. Order item type. Possible values include: "Purchase",
     "Rental".
    :type order_item_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemType
    :ivar current_stage: Current Order item Status.
    :vartype current_stage: ~azure.mgmt.edgeorder.v2021_12_01.models.StageDetails
    :ivar order_item_stage_history: Order item status history.
    :vartype order_item_stage_history: list[~azure.mgmt.edgeorder.v2021_12_01.models.StageDetails]
    :param preferences: Customer notification Preferences.
    :type preferences: ~azure.mgmt.edgeorder.v2021_12_01.models.Preferences
    :ivar forward_shipping_details: Forward Package Shipping details.
    :vartype forward_shipping_details:
     ~azure.mgmt.edgeorder.v2021_12_01.models.ForwardShippingDetails
    :ivar reverse_shipping_details: Reverse Package Shipping details.
    :vartype reverse_shipping_details:
     ~azure.mgmt.edgeorder.v2021_12_01.models.ReverseShippingDetails
    :param notification_email_list: Additional notification email list.
    :type notification_email_list: list[str]
    :ivar cancellation_reason: Cancellation reason.
    :vartype cancellation_reason: str
    :ivar cancellation_status: Describes whether the order item is cancellable or not. Possible
     values include: "Cancellable", "CancellableWithFee", "NotCancellable".
    :vartype cancellation_status: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemCancellationEnum
    :ivar deletion_status: Describes whether the order item is deletable or not. Possible values
     include: "Allowed", "NotAllowed".
    :vartype deletion_status: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ActionStatusEnum
    :ivar return_reason: Return reason.
    :vartype return_reason: str
    :ivar return_status: Describes whether the order item is returnable or not. Possible values
     include: "Returnable", "ReturnableWithFee", "NotReturnable".
    :vartype return_status: str or ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemReturnEnum
    :ivar management_rp_details: Parent RP details - this returns only the first or default parent
     RP from the entire list.
    :vartype management_rp_details:
     ~azure.mgmt.edgeorder.v2021_12_01.models.ResourceProviderDetails
    :ivar management_rp_details_list: List of parent RP details supported for configuration.
    :vartype management_rp_details_list:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.ResourceProviderDetails]
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.edgeorder.v2021_12_01.models.ErrorDetail
    """

    _validation = {
        'product_details': {'required': True},
        'order_item_type': {'required': True},
        'current_stage': {'readonly': True},
        'order_item_stage_history': {'readonly': True},
        'forward_shipping_details': {'readonly': True},
        'reverse_shipping_details': {'readonly': True},
        'cancellation_reason': {'readonly': True},
        'cancellation_status': {'readonly': True},
        'deletion_status': {'readonly': True},
        'return_reason': {'readonly': True},
        'return_status': {'readonly': True},
        'management_rp_details': {'readonly': True},
        'management_rp_details_list': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'product_details': {'key': 'productDetails', 'type': 'ProductDetails'},
        'order_item_type': {'key': 'orderItemType', 'type': 'str'},
        'current_stage': {'key': 'currentStage', 'type': 'StageDetails'},
        'order_item_stage_history': {'key': 'orderItemStageHistory', 'type': '[StageDetails]'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'forward_shipping_details': {'key': 'forwardShippingDetails', 'type': 'ForwardShippingDetails'},
        'reverse_shipping_details': {'key': 'reverseShippingDetails', 'type': 'ReverseShippingDetails'},
        'notification_email_list': {'key': 'notificationEmailList', 'type': '[str]'},
        'cancellation_reason': {'key': 'cancellationReason', 'type': 'str'},
        'cancellation_status': {'key': 'cancellationStatus', 'type': 'str'},
        'deletion_status': {'key': 'deletionStatus', 'type': 'str'},
        'return_reason': {'key': 'returnReason', 'type': 'str'},
        'return_status': {'key': 'returnStatus', 'type': 'str'},
        'management_rp_details': {'key': 'managementRpDetails', 'type': 'ResourceProviderDetails'},
        'management_rp_details_list': {'key': 'managementRpDetailsList', 'type': '[ResourceProviderDetails]'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderItemDetails, self).__init__(**kwargs)
        self.product_details = kwargs['product_details']
        self.order_item_type = kwargs['order_item_type']
        self.current_stage = None
        self.order_item_stage_history = None
        self.preferences = kwargs.get('preferences', None)
        self.forward_shipping_details = None
        self.reverse_shipping_details = None
        self.notification_email_list = kwargs.get('notification_email_list', None)
        self.cancellation_reason = None
        self.cancellation_status = None
        self.deletion_status = None
        self.return_reason = None
        self.return_status = None
        self.management_rp_details = None
        self.management_rp_details_list = None
        self.error = None


class OrderItemResource(TrackedResource):
    """Represents order item contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.v2021_12_01.models.SystemData
    :param order_item_details: Required. Represents order item details.
    :type order_item_details: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemDetails
    :param address_details: Required. Represents shipping and return address for order item.
    :type address_details: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressDetails
    :ivar start_time: Start time of order item.
    :vartype start_time: ~datetime.datetime
    :param order_id: Required. Id of the order to which order item belongs to.
    :type order_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'order_item_details': {'required': True},
        'address_details': {'required': True},
        'start_time': {'readonly': True},
        'order_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'order_item_details': {'key': 'properties.orderItemDetails', 'type': 'OrderItemDetails'},
        'address_details': {'key': 'properties.addressDetails', 'type': 'AddressDetails'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'order_id': {'key': 'properties.orderId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderItemResource, self).__init__(**kwargs)
        self.system_data = None
        self.order_item_details = kwargs['order_item_details']
        self.address_details = kwargs['address_details']
        self.start_time = None
        self.order_id = kwargs['order_id']


class OrderItemResourceList(msrest.serialization.Model):
    """List of orderItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of order item resources.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
    :param next_link: Link for the next set of order item resources.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OrderItemResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderItemResourceList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class OrderItemUpdateParameter(msrest.serialization.Model):
    """Updates order item parameters.

    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param forward_address: Updates forward shipping address and contact details.
    :type forward_address: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressProperties
    :param preferences: Customer preference.
    :type preferences: ~azure.mgmt.edgeorder.v2021_12_01.models.Preferences
    :param notification_email_list: Additional notification email list.
    :type notification_email_list: list[str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'forward_address': {'key': 'properties.forwardAddress', 'type': 'AddressProperties'},
        'preferences': {'key': 'properties.preferences', 'type': 'Preferences'},
        'notification_email_list': {'key': 'properties.notificationEmailList', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderItemUpdateParameter, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.forward_address = kwargs.get('forward_address', None)
        self.preferences = kwargs.get('preferences', None)
        self.notification_email_list = kwargs.get('notification_email_list', None)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class OrderResource(ProxyResource):
    """Specifies the properties or parameters for an order. Order is a grouping of one or more order items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.v2021_12_01.models.SystemData
    :ivar order_item_ids: List of order item ARM Ids which are part of an order.
    :vartype order_item_ids: list[str]
    :ivar current_stage: Order current status.
    :vartype current_stage: ~azure.mgmt.edgeorder.v2021_12_01.models.StageDetails
    :ivar order_stage_history: Order status history.
    :vartype order_stage_history: list[~azure.mgmt.edgeorder.v2021_12_01.models.StageDetails]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'order_item_ids': {'readonly': True},
        'current_stage': {'readonly': True},
        'order_stage_history': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'order_item_ids': {'key': 'properties.orderItemIds', 'type': '[str]'},
        'current_stage': {'key': 'properties.currentStage', 'type': 'StageDetails'},
        'order_stage_history': {'key': 'properties.orderStageHistory', 'type': '[StageDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderResource, self).__init__(**kwargs)
        self.system_data = None
        self.order_item_ids = None
        self.current_stage = None
        self.order_stage_history = None


class OrderResourceList(msrest.serialization.Model):
    """List of orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of order resources.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.OrderResource]
    :param next_link: Link for the next set of order resources.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OrderResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderResourceList, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class Pav2MeterDetails(MeterDetails):
    """Billing type PAV2 meter details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param billing_type: Required. Represents billing type.Constant filled by server.  Possible
     values include: "Pav2", "Purchase".
    :type billing_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Possible values include: "PerOrder", "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ChargingType
    :ivar meter_guid: Validation status of requested data center and transport.
    :vartype meter_guid: str
    """

    _validation = {
        'billing_type': {'required': True},
        'multiplier': {'readonly': True},
        'charging_type': {'readonly': True},
        'meter_guid': {'readonly': True},
    }

    _attribute_map = {
        'billing_type': {'key': 'billingType', 'type': 'str'},
        'multiplier': {'key': 'multiplier', 'type': 'float'},
        'charging_type': {'key': 'chargingType', 'type': 'str'},
        'meter_guid': {'key': 'meterGuid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Pav2MeterDetails, self).__init__(**kwargs)
        self.billing_type = 'Pav2'  # type: str
        self.meter_guid = None


class Preferences(msrest.serialization.Model):
    """Preferences related to the order.

    :param notification_preferences: Notification preferences.
    :type notification_preferences:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.NotificationPreference]
    :param transport_preferences: Preferences related to the shipment logistics of the order.
    :type transport_preferences: ~azure.mgmt.edgeorder.v2021_12_01.models.TransportPreferences
    :param encryption_preferences: Preferences related to the Encryption.
    :type encryption_preferences: ~azure.mgmt.edgeorder.v2021_12_01.models.EncryptionPreferences
    :param management_resource_preferences: Preferences related to the Management resource.
    :type management_resource_preferences:
     ~azure.mgmt.edgeorder.v2021_12_01.models.ManagementResourcePreferences
    """

    _attribute_map = {
        'notification_preferences': {'key': 'notificationPreferences', 'type': '[NotificationPreference]'},
        'transport_preferences': {'key': 'transportPreferences', 'type': 'TransportPreferences'},
        'encryption_preferences': {'key': 'encryptionPreferences', 'type': 'EncryptionPreferences'},
        'management_resource_preferences': {'key': 'managementResourcePreferences', 'type': 'ManagementResourcePreferences'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Preferences, self).__init__(**kwargs)
        self.notification_preferences = kwargs.get('notification_preferences', None)
        self.transport_preferences = kwargs.get('transport_preferences', None)
        self.encryption_preferences = kwargs.get('encryption_preferences', None)
        self.management_resource_preferences = kwargs.get('management_resource_preferences', None)


class Product(msrest.serialization.Model):
    """List of Products.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar configurations: List of configurations for the product.
    :vartype configurations: list[~azure.mgmt.edgeorder.v2021_12_01.models.Configuration]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'configurations': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'Description'},
        'image_information': {'key': 'properties.imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'properties.costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'properties.availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'properties.hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'properties.filterableProperties', 'type': '[FilterableProperty]'},
        'configurations': {'key': 'properties.configurations', 'type': '[Configuration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Product, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.configurations = None


class ProductDetails(msrest.serialization.Model):
    """Represents product details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_info: Display details of the product.
    :type display_info: ~azure.mgmt.edgeorder.v2021_12_01.models.DisplayInfo
    :param hierarchy_information: Required. Hierarchy of the product which uniquely identifies the
     product.
    :type hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar count: Quantity of the product.
    :vartype count: int
    :ivar product_double_encryption_status: Double encryption status of the configuration.
     Read-only field. Possible values include: "Disabled", "Enabled".
    :vartype product_double_encryption_status: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.DoubleEncryptionStatus
    :ivar device_details: list of device details.
    :vartype device_details: list[~azure.mgmt.edgeorder.v2021_12_01.models.DeviceDetails]
    """

    _validation = {
        'hierarchy_information': {'required': True},
        'count': {'readonly': True},
        'product_double_encryption_status': {'readonly': True},
        'device_details': {'readonly': True},
    }

    _attribute_map = {
        'display_info': {'key': 'displayInfo', 'type': 'DisplayInfo'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'count': {'key': 'count', 'type': 'int'},
        'product_double_encryption_status': {'key': 'productDoubleEncryptionStatus', 'type': 'str'},
        'device_details': {'key': 'deviceDetails', 'type': '[DeviceDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductDetails, self).__init__(**kwargs)
        self.display_info = kwargs.get('display_info', None)
        self.hierarchy_information = kwargs['hierarchy_information']
        self.count = None
        self.product_double_encryption_status = None
        self.device_details = None


class ProductFamilies(msrest.serialization.Model):
    """The list of product families.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of product families.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamily]
    :param next_link: Link for the next set of product families.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProductFamily]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamilies, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class ProductFamiliesMetadata(msrest.serialization.Model):
    """Holds details about product family metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of product family metadata details.
    :vartype value: list[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamiliesMetadataDetails]
    :ivar next_link: Link for the next set of product families.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProductFamiliesMetadataDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamiliesMetadata, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProductFamiliesMetadataDetails(msrest.serialization.Model):
    """Product families metadata details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.v2021_12_01.models.ProductLine]
    :param resource_provider_details: Contains details related to resource provider.
    :type resource_provider_details:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.ResourceProviderDetails]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'product_lines': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'Description'},
        'image_information': {'key': 'properties.imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'properties.costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'properties.availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'properties.hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'properties.filterableProperties', 'type': '[FilterableProperty]'},
        'product_lines': {'key': 'properties.productLines', 'type': '[ProductLine]'},
        'resource_provider_details': {'key': 'properties.resourceProviderDetails', 'type': '[ResourceProviderDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamiliesMetadataDetails, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.product_lines = None
        self.resource_provider_details = kwargs.get('resource_provider_details', None)


class ProductFamiliesRequest(msrest.serialization.Model):
    """The filters for showing the product families.

    All required parameters must be populated in order to send to Azure.

    :param filterable_properties: Required. Dictionary of filterable properties on product family.
    :type filterable_properties: dict[str,
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]]
    :param customer_subscription_details: Customer subscription properties. Clients can display
     available products to unregistered customers by explicitly passing subscription details.
    :type customer_subscription_details:
     ~azure.mgmt.edgeorder.v2021_12_01.models.CustomerSubscriptionDetails
    """

    _validation = {
        'filterable_properties': {'required': True},
    }

    _attribute_map = {
        'filterable_properties': {'key': 'filterableProperties', 'type': '{[FilterableProperty]}'},
        'customer_subscription_details': {'key': 'customerSubscriptionDetails', 'type': 'CustomerSubscriptionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamiliesRequest, self).__init__(**kwargs)
        self.filterable_properties = kwargs['filterable_properties']
        self.customer_subscription_details = kwargs.get('customer_subscription_details', None)


class ProductFamily(msrest.serialization.Model):
    """Product Family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.v2021_12_01.models.ProductLine]
    :param resource_provider_details: Contains details related to resource provider.
    :type resource_provider_details:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.ResourceProviderDetails]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'product_lines': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'Description'},
        'image_information': {'key': 'properties.imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'properties.costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'properties.availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'properties.hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'properties.filterableProperties', 'type': '[FilterableProperty]'},
        'product_lines': {'key': 'properties.productLines', 'type': '[ProductLine]'},
        'resource_provider_details': {'key': 'properties.resourceProviderDetails', 'type': '[ResourceProviderDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamily, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.product_lines = None
        self.resource_provider_details = kwargs.get('resource_provider_details', None)


class ProductFamilyProperties(CommonProperties):
    """Properties of product family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.v2021_12_01.models.ProductLine]
    :param resource_provider_details: Contains details related to resource provider.
    :type resource_provider_details:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.ResourceProviderDetails]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'product_lines': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'filterableProperties', 'type': '[FilterableProperty]'},
        'product_lines': {'key': 'productLines', 'type': '[ProductLine]'},
        'resource_provider_details': {'key': 'resourceProviderDetails', 'type': '[ResourceProviderDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductFamilyProperties, self).__init__(**kwargs)
        self.product_lines = None
        self.resource_provider_details = kwargs.get('resource_provider_details', None)


class ProductLine(msrest.serialization.Model):
    """Product line.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar products: List of products in the product line.
    :vartype products: list[~azure.mgmt.edgeorder.v2021_12_01.models.Product]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'products': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'Description'},
        'image_information': {'key': 'properties.imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'properties.costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'properties.availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'properties.hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'properties.filterableProperties', 'type': '[FilterableProperty]'},
        'products': {'key': 'properties.products', 'type': '[Product]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductLine, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.products = None


class ProductLineProperties(CommonProperties):
    """Properties of product line.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar products: List of products in the product line.
    :vartype products: list[~azure.mgmt.edgeorder.v2021_12_01.models.Product]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'products': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'filterableProperties', 'type': '[FilterableProperty]'},
        'products': {'key': 'products', 'type': '[Product]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductLineProperties, self).__init__(**kwargs)
        self.products = None


class ProductProperties(CommonProperties):
    """Properties of products.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.v2021_12_01.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.v2021_12_01.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.v2021_12_01.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information:
     ~azure.mgmt.edgeorder.v2021_12_01.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.v2021_12_01.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties:
     list[~azure.mgmt.edgeorder.v2021_12_01.models.FilterableProperty]
    :ivar configurations: List of configurations for the product.
    :vartype configurations: list[~azure.mgmt.edgeorder.v2021_12_01.models.Configuration]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'image_information': {'readonly': True},
        'cost_information': {'readonly': True},
        'availability_information': {'readonly': True},
        'hierarchy_information': {'readonly': True},
        'filterable_properties': {'readonly': True},
        'configurations': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'Description'},
        'image_information': {'key': 'imageInformation', 'type': '[ImageInformation]'},
        'cost_information': {'key': 'costInformation', 'type': 'CostInformation'},
        'availability_information': {'key': 'availabilityInformation', 'type': 'AvailabilityInformation'},
        'hierarchy_information': {'key': 'hierarchyInformation', 'type': 'HierarchyInformation'},
        'filterable_properties': {'key': 'filterableProperties', 'type': '[FilterableProperty]'},
        'configurations': {'key': 'configurations', 'type': '[Configuration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductProperties, self).__init__(**kwargs)
        self.configurations = None


class PurchaseMeterDetails(MeterDetails):
    """Billing type Purchase meter details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param billing_type: Required. Represents billing type.Constant filled by server.  Possible
     values include: "Pav2", "Purchase".
    :type billing_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Possible values include: "PerOrder", "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.ChargingType
    :ivar product_id: Product Id.
    :vartype product_id: str
    :ivar sku_id: Sku Id.
    :vartype sku_id: str
    :ivar term_id: Term Id.
    :vartype term_id: str
    """

    _validation = {
        'billing_type': {'required': True},
        'multiplier': {'readonly': True},
        'charging_type': {'readonly': True},
        'product_id': {'readonly': True},
        'sku_id': {'readonly': True},
        'term_id': {'readonly': True},
    }

    _attribute_map = {
        'billing_type': {'key': 'billingType', 'type': 'str'},
        'multiplier': {'key': 'multiplier', 'type': 'float'},
        'charging_type': {'key': 'chargingType', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'sku_id': {'key': 'skuId', 'type': 'str'},
        'term_id': {'key': 'termId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurchaseMeterDetails, self).__init__(**kwargs)
        self.billing_type = 'Purchase'  # type: str
        self.product_id = None
        self.sku_id = None
        self.term_id = None


class ResourceIdentity(msrest.serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Identity type.
    :type type: str
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = None
        self.tenant_id = None


class ResourceProviderDetails(msrest.serialization.Model):
    """Management RP details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_provider_namespace: Resource provider namespace.
    :vartype resource_provider_namespace: str
    """

    _validation = {
        'resource_provider_namespace': {'readonly': True},
    }

    _attribute_map = {
        'resource_provider_namespace': {'key': 'resourceProviderNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderDetails, self).__init__(**kwargs)
        self.resource_provider_namespace = None


class ReturnOrderItemDetails(msrest.serialization.Model):
    """Return order item request body.

    All required parameters must be populated in order to send to Azure.

    :param return_address: customer return address.
    :type return_address: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressProperties
    :param return_reason: Required. Return Reason.
    :type return_reason: str
    :param service_tag: Service tag (located on the bottom-right corner of the device).
    :type service_tag: str
    :param shipping_box_required: Shipping Box required.
    :type shipping_box_required: bool
    """

    _validation = {
        'return_reason': {'required': True},
    }

    _attribute_map = {
        'return_address': {'key': 'returnAddress', 'type': 'AddressProperties'},
        'return_reason': {'key': 'returnReason', 'type': 'str'},
        'service_tag': {'key': 'serviceTag', 'type': 'str'},
        'shipping_box_required': {'key': 'shippingBoxRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReturnOrderItemDetails, self).__init__(**kwargs)
        self.return_address = kwargs.get('return_address', None)
        self.return_reason = kwargs['return_reason']
        self.service_tag = kwargs.get('service_tag', None)
        self.shipping_box_required = kwargs.get('shipping_box_required', False)


class ReverseShippingDetails(msrest.serialization.Model):
    """Reverse shipment details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sas_key_for_label: SAS key to download the reverse shipment label of the package.
    :vartype sas_key_for_label: str
    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        'sas_key_for_label': {'readonly': True},
        'carrier_name': {'readonly': True},
        'carrier_display_name': {'readonly': True},
        'tracking_id': {'readonly': True},
        'tracking_url': {'readonly': True},
    }

    _attribute_map = {
        'sas_key_for_label': {'key': 'sasKeyForLabel', 'type': 'str'},
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'carrier_display_name': {'key': 'carrierDisplayName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseShippingDetails, self).__init__(**kwargs)
        self.sas_key_for_label = None
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class ShippingAddress(msrest.serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to Azure.

    :param street_address1: Required. Street Address line 1.
    :type street_address1: str
    :param street_address2: Street Address line 2.
    :type street_address2: str
    :param street_address3: Street Address line 3.
    :type street_address3: str
    :param city: Name of the City.
    :type city: str
    :param state_or_province: Name of the State or Province.
    :type state_or_province: str
    :param country: Required. Name of the Country.
    :type country: str
    :param postal_code: Postal code.
    :type postal_code: str
    :param zip_extended_code: Extended Zip Code.
    :type zip_extended_code: str
    :param company_name: Name of the company.
    :type company_name: str
    :param address_type: Type of address. Possible values include: "None", "Residential",
     "Commercial".
    :type address_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.AddressType
    """

    _validation = {
        'street_address1': {'required': True},
        'country': {'required': True},
    }

    _attribute_map = {
        'street_address1': {'key': 'streetAddress1', 'type': 'str'},
        'street_address2': {'key': 'streetAddress2', 'type': 'str'},
        'street_address3': {'key': 'streetAddress3', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state_or_province': {'key': 'stateOrProvince', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'zip_extended_code': {'key': 'zipExtendedCode', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'address_type': {'key': 'addressType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShippingAddress, self).__init__(**kwargs)
        self.street_address1 = kwargs['street_address1']
        self.street_address2 = kwargs.get('street_address2', None)
        self.street_address3 = kwargs.get('street_address3', None)
        self.city = kwargs.get('city', None)
        self.state_or_province = kwargs.get('state_or_province', None)
        self.country = kwargs['country']
        self.postal_code = kwargs.get('postal_code', None)
        self.zip_extended_code = kwargs.get('zip_extended_code', None)
        self.company_name = kwargs.get('company_name', None)
        self.address_type = kwargs.get('address_type', None)


class ShippingDetails(msrest.serialization.Model):
    """Package shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        'carrier_name': {'readonly': True},
        'carrier_display_name': {'readonly': True},
        'tracking_id': {'readonly': True},
        'tracking_url': {'readonly': True},
    }

    _attribute_map = {
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'carrier_display_name': {'key': 'carrierDisplayName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShippingDetails, self).__init__(**kwargs)
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class Specification(msrest.serialization.Model):
    """Specifications of the configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the specification.
    :vartype name: str
    :ivar value: Value of the specification.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Specification, self).__init__(**kwargs)
        self.name = None
        self.value = None


class StageDetails(msrest.serialization.Model):
    """Resource stage details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_status: Stage status. Possible values include: "None", "InProgress", "Succeeded",
     "Failed", "Cancelled", "Cancelling".
    :vartype stage_status: str or ~azure.mgmt.edgeorder.v2021_12_01.models.StageStatus
    :ivar stage_name: Stage name. Possible values include: "Placed", "InReview", "Confirmed",
     "ReadyToShip", "Shipped", "Delivered", "InUse", "ReturnInitiated", "ReturnPickedUp",
     "ReturnedToMicrosoft", "ReturnCompleted", "Cancelled".
    :vartype stage_name: str or ~azure.mgmt.edgeorder.v2021_12_01.models.StageName
    :ivar display_name: Display name of the resource stage.
    :vartype display_name: str
    :ivar start_time: Stage start time.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        'stage_status': {'readonly': True},
        'stage_name': {'readonly': True},
        'display_name': {'readonly': True},
        'start_time': {'readonly': True},
    }

    _attribute_map = {
        'stage_status': {'key': 'stageStatus', 'type': 'str'},
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StageDetails, self).__init__(**kwargs)
        self.stage_status = None
        self.stage_name = None
        self.display_name = None
        self.start_time = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.edgeorder.v2021_12_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TransportPreferences(msrest.serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to Azure.

    :param preferred_shipment_type: Required. Indicates Shipment Logistics type that the customer
     preferred. Possible values include: "CustomerManaged", "MicrosoftManaged".
    :type preferred_shipment_type: str or
     ~azure.mgmt.edgeorder.v2021_12_01.models.TransportShipmentTypes
    """

    _validation = {
        'preferred_shipment_type': {'required': True},
    }

    _attribute_map = {
        'preferred_shipment_type': {'key': 'preferredShipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportPreferences, self).__init__(**kwargs)
        self.preferred_shipment_type = kwargs['preferred_shipment_type']
