# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from ..._serialization import Serializer
from .._vendor import KeyVaultClientMixinABC, _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/create")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str", pattern=r"^[0-9a-zA-Z-]+$"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_import_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str", pattern=r"^[0-9a-zA-Z-]+$"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_key_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_key_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_key_versions_request(key_name: str, *, maxresults: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/versions")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_keys_request(*, maxresults: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys")

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_backup_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/backup")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_restore_key_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/restore")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_encrypt_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/encrypt")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_decrypt_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/decrypt")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_sign_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/sign")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_verify_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/verify")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_wrap_key_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/wrapkey")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_unwrap_key_request(key_name: str, key_version: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keys/{key-name}/{key-version}/unwrapkey")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
        "key-version": _SERIALIZER.url("key_version", key_version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deleted_keys_request(*, maxresults: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedkeys")

    # Construct parameters
    if maxresults is not None:
        _params["maxresults"] = _SERIALIZER.query("maxresults", maxresults, "int", maximum=25, minimum=1)
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_deleted_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedkeys/{key-name}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_purge_deleted_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedkeys/{key-name}")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_recover_deleted_key_request(key_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/deletedkeys/{key-name}/recover")
    path_format_arguments = {
        "key-name": _SERIALIZER.url("key_name", key_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class KeyVaultClientOperationsMixin(KeyVaultClientMixinABC):
    @overload
    def create_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: _models.KeyCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_key(
        self, vault_base_url: str, key_name: str, parameters: Union[_models.KeyCreateParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyCreateParameters")

        request = build_create_key_request(
            key_name=key_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_key.metadata = {"url": "/keys/{key-name}/create"}  # type: ignore

    @overload
    def import_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: _models.KeyImportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyImportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def import_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def import_key(
        self, vault_base_url: str, key_name: str, parameters: Union[_models.KeyImportParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyImportParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyImportParameters")

        request = build_import_key_request(
            key_name=key_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.import_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    import_key.metadata = {"url": "/keys/{key-name}"}  # type: ignore

    @distributed_trace
    def delete_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.DeletedKeyBundle:
        """Deletes a key of any type from storage in Azure Key Vault.

        The delete key operation cannot be used to remove individual versions of a key. This operation
        removes the cryptographic material associated with the key, which means the key is not usable
        for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the
        keys/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key to delete. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.DeletedKeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedKeyBundle]

        request = build_delete_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.delete_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedKeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_key.metadata = {"url": "/keys/{key-name}"}  # type: ignore

    @overload
    def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyUpdateParameters")

        request = build_update_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_key.metadata = {"url": "/keys/{key-name}/{key-version}"}  # type: ignore

    @distributed_trace
    def get_key(self, vault_base_url: str, key_name: str, key_version: str, **kwargs: Any) -> _models.KeyBundle:
        """Gets the public part of a stored key.

        The get key operation is applicable to all key types. If the requested key is symmetric, then
        no key material is released in the response. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key to get. Required.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific version of a key. This
         URI fragment is optional. If not specified, the latest version of the key is returned.
         Required.
        :type key_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        request = build_get_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            template_url=self.get_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_key.metadata = {"url": "/keys/{key-name}/{key-version}"}  # type: ignore

    @distributed_trace
    def get_key_versions(
        self, vault_base_url: str, key_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.KeyItem"]:
        """Retrieves a list of individual key versions with the same key name.

        The full key identifier, attributes, and tags are provided in the response. This operation
        requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_2.models.KeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_key_versions_request(
                    key_name=key_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_key_versions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_key_versions.metadata = {"url": "/keys/{key-name}/versions"}  # type: ignore

    @distributed_trace
    def get_keys(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.KeyItem"]:
        """List keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a stored key. The LIST operation is applicable to all key types, however only
        the base key identifier, attributes, and tags are provided in the response. Individual versions
        of a key are not listed in the response. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_2.models.KeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_keys_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_keys.metadata = {"url": "/keys"}  # type: ignore

    @distributed_trace
    def backup_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.BackupKeyResult:
        """Requests that a backup of the specified key be downloaded to the client.

        The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this
        operation does NOT return key material in a form that can be used outside the Azure Key Vault
        system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key
        Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure
        Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance.
        The BACKUP operation may be used to export, in protected form, any key type from Azure Key
        Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed
        within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be
        restored to another geographical area. For example, a backup from the US geographical area
        cannot be restored in an EU geographical area. This operation requires the key/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupKeyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.BackupKeyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.BackupKeyResult]

        request = build_backup_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.backup_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("BackupKeyResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup_key.metadata = {"url": "/keys/{key-name}/backup"}  # type: ignore

    @overload
    def restore_key(
        self,
        vault_base_url: str,
        parameters: _models.KeyRestoreParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyRestoreParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def restore_key(
        self, vault_base_url: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def restore_key(
        self, vault_base_url: str, parameters: Union[_models.KeyRestoreParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyRestoreParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyRestoreParameters")

        request = build_restore_key_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.restore_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    restore_key.metadata = {"url": "/keys/restore"}  # type: ignore

    @overload
    def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyOperationResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_encrypt_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.encrypt.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    encrypt.metadata = {"url": "/keys/{key-name}/{key-version}/encrypt"}  # type: ignore

    @overload
    def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyOperationResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_decrypt_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.decrypt.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    decrypt.metadata = {"url": "/keys/{key-name}/{key-version}/decrypt"}  # type: ignore

    @overload
    def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeySignParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeySignParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeySignParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeySignParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyOperationResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeySignParameters")

        request = build_sign_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.sign.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    sign.metadata = {"url": "/keys/{key-name}/{key-version}/sign"}  # type: ignore

    @overload
    def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyVerifyParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyVerifyParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyVerifyParameters, IO],
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyVerifyParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyVerifyResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyVerifyParameters")

        request = build_verify_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.verify.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyVerifyResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    verify.metadata = {"url": "/keys/{key-name}/{key-version}/verify"}  # type: ignore

    @overload
    def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyOperationResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_wrap_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.wrap_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    wrap_key.metadata = {"url": "/keys/{key-name}/{key-version}/wrapkey"}  # type: ignore

    @overload
    def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.keyvault.v7_2.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyOperationResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_unwrap_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.unwrap_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    unwrap_key.metadata = {"url": "/keys/{key-name}/{key-version}/unwrapkey"}  # type: ignore

    @distributed_trace
    def get_deleted_keys(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.DeletedKeyItem"]:
        """Lists the deleted keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a deleted key. This operation includes deletion-specific information. The Get
        Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedKeyItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_2.models.DeletedKeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedKeyListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_deleted_keys_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_deleted_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("DeletedKeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    get_deleted_keys.metadata = {"url": "/deletedkeys"}  # type: ignore

    @distributed_trace
    def get_deleted_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.DeletedKeyBundle:
        """Gets the public part of a deleted key.

        The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.DeletedKeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DeletedKeyBundle]

        request = build_get_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.get_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedKeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deleted_key.metadata = {"url": "/deletedkeys/{key-name}"}  # type: ignore

    @distributed_trace
    def purge_deleted_key(  # pylint: disable=inconsistent-return-statements
        self, vault_base_url: str, key_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified key.

        The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the
        operation can be invoked on any vault, it will return an error if invoked on a non soft-delete
        enabled vault. This operation requires the keys/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_purge_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.purge_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_key.metadata = {"url": "/deletedkeys/{key-name}"}  # type: ignore

    @distributed_trace
    def recover_deleted_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.KeyBundle:
        """Recovers the deleted key to its latest version.

        The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults.
        It recovers the deleted key back to its latest version under /keys. An attempt to recover an
        non-deleted key will return an error. Consider this the inverse of the delete operation on
        soft-delete enabled vaults. This operation requires the keys/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the deleted key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v7_2.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "7.2"))  # type: Literal["7.2"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyBundle]

        request = build_recover_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.recover_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    recover_deleted_key.metadata = {"url": "/deletedkeys/{key-name}/recover"}  # type: ignore
