# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class BatchRequest(_serialization.Model):
    """This type represents the request body for the Batch service.

    :ivar batch_items: The list of queries to process.
    :vartype batch_items: list[~azure.maps.route.models.BatchRequestItem]
    """

    _attribute_map = {
        "batch_items": {"key": "batchItems", "type": "[BatchRequestItem]"},
    }

    def __init__(self, *, batch_items: Optional[List["_models.BatchRequestItem"]] = None, **kwargs):
        """
        :keyword batch_items: The list of queries to process.
        :paramtype batch_items: list[~azure.maps.route.models.BatchRequestItem]
        """
        super().__init__(**kwargs)
        self.batch_items = batch_items


class BatchRequestItem(_serialization.Model):
    """Batch request object.

    :ivar query: This parameter contains a query string used to perform an unstructured geocoding
     operation. The query string will be passed verbatim to the search API for processing.
    :vartype query: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, query: Optional[str] = None, **kwargs):
        """
        :keyword query: This parameter contains a query string used to perform an unstructured
         geocoding operation. The query string will be passed verbatim to the search API for processing.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.query = query


class BatchResult(_serialization.Model):
    """This object is returned from a successful Batch service call. Extend with 'batchItems' property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar batch_summary: Summary of the results for the batch request.
    :vartype batch_summary: ~azure.maps.route.models.BatchResultSummary
    """

    _validation = {
        "batch_summary": {"readonly": True},
    }

    _attribute_map = {
        "batch_summary": {"key": "summary", "type": "BatchResultSummary"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.batch_summary = None


class BatchResultItem(_serialization.Model):
    """An item returned from Batch API. Extend with 'response' property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: HTTP request status code.
    :vartype status_code: int
    """

    _validation = {
        "status_code": {"readonly": True},
    }

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status_code = None


class BatchResultSummary(_serialization.Model):
    """Summary of the results for the batch request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_requests: Number of successful requests in the batch.
    :vartype successful_requests: int
    :ivar total_requests: Total number of requests in the batch.
    :vartype total_requests: int
    """

    _validation = {
        "successful_requests": {"readonly": True},
        "total_requests": {"readonly": True},
    }

    _attribute_map = {
        "successful_requests": {"key": "successfulRequests", "type": "int"},
        "total_requests": {"key": "totalRequests", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.successful_requests = None
        self.total_requests = None


class EffectiveSetting(_serialization.Model):
    """Effective parameter or data used when calling this Route API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: Name of the parameter used.
    :vartype key: str
    :ivar value: Value of the parameter used.
    :vartype value: str
    """

    _validation = {
        "key": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.key = None
        self.value = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.maps.route.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.maps.route.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.maps.route.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.maps.route.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GeoJsonFeatureData(_serialization.Model):
    """GeoJsonFeatureData.

    All required parameters must be populated in order to send to Azure.

    :ivar geometry: A valid ``GeoJSON`` geometry object. The type must be one of the seven valid
     GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon
     and GeometryCollection. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1>`_ for details. Required.
    :vartype geometry: ~azure.maps.route.models.GeoJsonGeometry
    :ivar properties: Properties can contain any additional metadata about the ``Feature``. Value
     can be any JSON object or a JSON null value.
    :vartype properties: JSON
    :ivar id: Identifier for the feature.
    :vartype id: str
    :ivar feature_type: The type of the feature. The value depends on the data model the current
     feature is part of. Some data models may have an empty value.
    :vartype feature_type: str
    """

    _validation = {
        "geometry": {"required": True},
    }

    _attribute_map = {
        "geometry": {"key": "geometry", "type": "GeoJsonGeometry"},
        "properties": {"key": "properties", "type": "object"},
        "id": {"key": "id", "type": "str"},
        "feature_type": {"key": "featureType", "type": "str"},
    }

    def __init__(
        self,
        *,
        geometry: "_models.GeoJsonGeometry",
        properties: Optional[JSON] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        feature_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword geometry: A valid ``GeoJSON`` geometry object. The type must be one of the seven valid
         GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon
         and GeometryCollection. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1>`_ for details. Required.
        :paramtype geometry: ~azure.maps.route.models.GeoJsonGeometry
        :keyword properties: Properties can contain any additional metadata about the ``Feature``.
         Value can be any JSON object or a JSON null value.
        :paramtype properties: JSON
        :keyword id: Identifier for the feature.
        :paramtype id: str
        :keyword feature_type: The type of the feature. The value depends on the data model the current
         feature is part of. Some data models may have an empty value.
        :paramtype feature_type: str
        """
        super().__init__(**kwargs)
        self.geometry = geometry
        self.properties = properties
        self.id = id
        self.feature_type = feature_type


class GeoJsonObject(_serialization.Model):
    """A valid ``GeoJSON`` object. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3>`_ for details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GeoJsonFeature, GeoJsonFeatureCollection, GeoJsonGeometry

    All required parameters must be populated in order to send to Azure.

    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Feature": "GeoJsonFeature",
            "FeatureCollection": "GeoJsonFeatureCollection",
            "GeoJsonGeometry": "GeoJsonGeometry",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class GeoJsonFeature(GeoJsonObject, GeoJsonFeatureData):
    """A valid ``GeoJSON Feature`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.2>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar geometry: A valid ``GeoJSON`` geometry object. The type must be one of the seven valid
     GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon
     and GeometryCollection. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1>`_ for details. Required.
    :vartype geometry: ~azure.maps.route.models.GeoJsonGeometry
    :ivar properties: Properties can contain any additional metadata about the ``Feature``. Value
     can be any JSON object or a JSON null value.
    :vartype properties: JSON
    :ivar id: Identifier for the feature.
    :vartype id: str
    :ivar feature_type: The type of the feature. The value depends on the data model the current
     feature is part of. Some data models may have an empty value.
    :vartype feature_type: str
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "geometry": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "geometry": {"key": "geometry", "type": "GeoJsonGeometry"},
        "properties": {"key": "properties", "type": "object"},
        "id": {"key": "id", "type": "str"},
        "feature_type": {"key": "featureType", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        geometry: "_models.GeoJsonGeometry",
        properties: Optional[JSON] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        feature_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword geometry: A valid ``GeoJSON`` geometry object. The type must be one of the seven valid
         GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon
         and GeometryCollection. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1>`_ for details. Required.
        :paramtype geometry: ~azure.maps.route.models.GeoJsonGeometry
        :keyword properties: Properties can contain any additional metadata about the ``Feature``.
         Value can be any JSON object or a JSON null value.
        :paramtype properties: JSON
        :keyword id: Identifier for the feature.
        :paramtype id: str
        :keyword feature_type: The type of the feature. The value depends on the data model the current
         feature is part of. Some data models may have an empty value.
        :paramtype feature_type: str
        """
        super().__init__(geometry=geometry, properties=properties, id=id, feature_type=feature_type, **kwargs)
        self.geometry = geometry
        self.properties = properties
        self.id = id
        self.feature_type = feature_type
        self.type = "Feature"  # type: str


class GeoJsonFeatureCollectionData(_serialization.Model):
    """GeoJsonFeatureCollectionData.

    All required parameters must be populated in order to send to Azure.

    :ivar features: Contains a list of valid ``GeoJSON Feature`` objects. Required.
    :vartype features: list[~azure.maps.route.models.GeoJsonFeature]
    """

    _validation = {
        "features": {"required": True},
    }

    _attribute_map = {
        "features": {"key": "features", "type": "[GeoJsonFeature]"},
    }

    def __init__(self, *, features: List["_models.GeoJsonFeature"], **kwargs):
        """
        :keyword features: Contains a list of valid ``GeoJSON Feature`` objects. Required.
        :paramtype features: list[~azure.maps.route.models.GeoJsonFeature]
        """
        super().__init__(**kwargs)
        self.features = features


class GeoJsonFeatureCollection(GeoJsonObject, GeoJsonFeatureCollectionData):
    """A valid ``GeoJSON FeatureCollection`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.3>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar features: Contains a list of valid ``GeoJSON Feature`` objects. Required.
    :vartype features: list[~azure.maps.route.models.GeoJsonFeature]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "features": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "features": {"key": "features", "type": "[GeoJsonFeature]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, features: List["_models.GeoJsonFeature"], **kwargs):
        """
        :keyword features: Contains a list of valid ``GeoJSON Feature`` objects. Required.
        :paramtype features: list[~azure.maps.route.models.GeoJsonFeature]
        """
        super().__init__(features=features, **kwargs)
        self.features = features
        self.type = "FeatureCollection"  # type: str


class GeoJsonGeometry(GeoJsonObject):
    """A valid ``GeoJSON`` geometry object. The type must be one of the seven valid GeoJSON geometry types - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon and GeometryCollection. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1>`_ for details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GeoJsonGeometryCollection, GeoJsonLineString, GeoJsonMultiLineString, GeoJsonMultiPoint,
    GeoJsonMultiPolygon, GeoJsonPoint, GeoJsonPolygon

    All required parameters must be populated in order to send to Azure.

    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "GeometryCollection": "GeoJsonGeometryCollection",
            "LineString": "GeoJsonLineString",
            "MultiLineString": "GeoJsonMultiLineString",
            "MultiPoint": "GeoJsonMultiPoint",
            "MultiPolygon": "GeoJsonMultiPolygon",
            "Point": "GeoJsonPoint",
            "Polygon": "GeoJsonPolygon",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = "GeoJsonGeometry"  # type: str


class GeoJsonGeometryCollectionData(_serialization.Model):
    """GeoJsonGeometryCollectionData.

    All required parameters must be populated in order to send to Azure.

    :ivar geometries: Contains a list of valid ``GeoJSON`` geometry objects. **Note** that
     coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
    :vartype geometries: list[~azure.maps.route.models.GeoJsonGeometry]
    """

    _validation = {
        "geometries": {"required": True},
    }

    _attribute_map = {
        "geometries": {"key": "geometries", "type": "[GeoJsonGeometry]"},
    }

    def __init__(self, *, geometries: List["_models.GeoJsonGeometry"], **kwargs):
        """
        :keyword geometries: Contains a list of valid ``GeoJSON`` geometry objects. **Note** that
         coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
        :paramtype geometries: list[~azure.maps.route.models.GeoJsonGeometry]
        """
        super().__init__(**kwargs)
        self.geometries = geometries


class GeoJsonGeometryCollection(GeoJsonGeometry, GeoJsonGeometryCollectionData):
    """A valid ``GeoJSON GeometryCollection`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.8>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar geometries: Contains a list of valid ``GeoJSON`` geometry objects. **Note** that
     coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
    :vartype geometries: list[~azure.maps.route.models.GeoJsonGeometry]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "geometries": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "geometries": {"key": "geometries", "type": "[GeoJsonGeometry]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, geometries: List["_models.GeoJsonGeometry"], **kwargs):
        """
        :keyword geometries: Contains a list of valid ``GeoJSON`` geometry objects. **Note** that
         coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
        :paramtype geometries: list[~azure.maps.route.models.GeoJsonGeometry]
        """
        super().__init__(geometries=geometries, **kwargs)
        self.geometries = geometries
        self.type = "GeometryCollection"  # type: str


class GeoJsonLineStringData(_serialization.Model):
    """GeoJsonLineStringData.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson LineString`` geometry. Required.
    :vartype coordinates: list[list[float]]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[float]]"},
    }

    def __init__(self, *, coordinates: List[List[float]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson LineString`` geometry. Required.
        :paramtype coordinates: list[list[float]]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonLineString(GeoJsonGeometry, GeoJsonLineStringData):
    """A valid ``GeoJSON LineString`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.4>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson LineString`` geometry. Required.
    :vartype coordinates: list[list[float]]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[float]]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[List[float]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson LineString`` geometry. Required.
        :paramtype coordinates: list[list[float]]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "LineString"  # type: str


class GeoJsonMultiLineStringData(_serialization.Model):
    """GeoJsonMultiLineStringData.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson MultiLineString`` geometry. Required.
    :vartype coordinates: list[list[list[float]]]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[float]]]"},
    }

    def __init__(self, *, coordinates: List[List[List[float]]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson MultiLineString`` geometry. Required.
        :paramtype coordinates: list[list[list[float]]]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiLineString(GeoJsonGeometry, GeoJsonMultiLineStringData):
    """A valid ``GeoJSON MultiLineString`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.5>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson MultiLineString`` geometry. Required.
    :vartype coordinates: list[list[list[float]]]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[float]]]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[List[List[float]]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson MultiLineString`` geometry. Required.
        :paramtype coordinates: list[list[list[float]]]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "MultiLineString"  # type: str


class GeoJsonMultiPointData(_serialization.Model):
    """Data contained by a ``GeoJson MultiPoint``.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson MultiPoint`` geometry. Required.
    :vartype coordinates: list[list[float]]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[float]]"},
    }

    def __init__(self, *, coordinates: List[List[float]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson MultiPoint`` geometry. Required.
        :paramtype coordinates: list[list[float]]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiPoint(GeoJsonGeometry, GeoJsonMultiPointData):
    """A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.3>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson MultiPoint`` geometry. Required.
    :vartype coordinates: list[list[float]]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[float]]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[List[float]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson MultiPoint`` geometry. Required.
        :paramtype coordinates: list[list[float]]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "MultiPoint"  # type: str


class GeoJsonMultiPolygonData(_serialization.Model):
    """GeoJsonMultiPolygonData.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Contains a list of valid ``GeoJSON Polygon`` objects. **Note** that
     coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
    :vartype coordinates: list[list[list[list[float]]]]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[[float]]]]"},
    }

    def __init__(self, *, coordinates: List[List[List[List[float]]]], **kwargs):
        """
        :keyword coordinates: Contains a list of valid ``GeoJSON Polygon`` objects. **Note** that
         coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
        :paramtype coordinates: list[list[list[list[float]]]]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonMultiPolygon(GeoJsonGeometry, GeoJsonMultiPolygonData):
    """A valid ``GeoJSON MultiPolygon`` object type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.7>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Contains a list of valid ``GeoJSON Polygon`` objects. **Note** that
     coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
    :vartype coordinates: list[list[list[list[float]]]]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[[float]]]]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[List[List[List[float]]]], **kwargs):
        """
        :keyword coordinates: Contains a list of valid ``GeoJSON Polygon`` objects. **Note** that
         coordinates in GeoJSON are in x, y order (longitude, latitude). Required.
        :paramtype coordinates: list[list[list[list[float]]]]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "MultiPolygon"  # type: str


class GeoJsonPointData(_serialization.Model):
    """Data contained by a ``GeoJson Point``.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: A ``Position`` is an array of numbers with two or more elements. The first
     two elements are *longitude* and *latitude*\ , precisely in that order. *Altitude/Elevation* is
     an optional third element. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.1>`_ for details. Required.
    :vartype coordinates: list[float]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[float]"},
    }

    def __init__(self, *, coordinates: List[float], **kwargs):
        """
        :keyword coordinates: A ``Position`` is an array of numbers with two or more elements. The
         first two elements are *longitude* and *latitude*\ , precisely in that order.
         *Altitude/Elevation* is an optional third element. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1.1>`_ for details. Required.
        :paramtype coordinates: list[float]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonPoint(GeoJsonGeometry, GeoJsonPointData):
    """A valid ``GeoJSON Point`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.2>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: A ``Position`` is an array of numbers with two or more elements. The first
     two elements are *longitude* and *latitude*\ , precisely in that order. *Altitude/Elevation* is
     an optional third element. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.1>`_ for details. Required.
    :vartype coordinates: list[float]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[float]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[float], **kwargs):
        """
        :keyword coordinates: A ``Position`` is an array of numbers with two or more elements. The
         first two elements are *longitude* and *latitude*\ , precisely in that order.
         *Altitude/Elevation* is an optional third element. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1.1>`_ for details. Required.
        :paramtype coordinates: list[float]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "Point"  # type: str


class GeoJsonPolygonData(_serialization.Model):
    """GeoJsonPolygonData.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson Polygon`` geometry type. Required.
    :vartype coordinates: list[list[list[float]]]
    """

    _validation = {
        "coordinates": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[float]]]"},
    }

    def __init__(self, *, coordinates: List[List[List[float]]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson Polygon`` geometry type. Required.
        :paramtype coordinates: list[list[list[float]]]
        """
        super().__init__(**kwargs)
        self.coordinates = coordinates


class GeoJsonPolygon(GeoJsonGeometry, GeoJsonPolygonData):
    """A valid ``GeoJSON Polygon`` geometry type. Please refer to `RFC 7946 <https://tools.ietf.org/html/rfc7946#section-3.1.6>`_ for details.

    All required parameters must be populated in order to send to Azure.

    :ivar coordinates: Coordinates for the ``GeoJson Polygon`` geometry type. Required.
    :vartype coordinates: list[list[list[float]]]
    :ivar type: Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types
     - Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection,
     Feature and FeatureCollection. Required. Known values are: "Point", "MultiPoint", "LineString",
     "MultiLineString", "Polygon", "MultiPolygon", "GeometryCollection", "Feature", and
     "FeatureCollection".
    :vartype type: str or ~azure.maps.route.models.GeoJsonObjectType
    """

    _validation = {
        "coordinates": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "coordinates": {"key": "coordinates", "type": "[[[float]]]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, coordinates: List[List[List[float]]], **kwargs):
        """
        :keyword coordinates: Coordinates for the ``GeoJson Polygon`` geometry type. Required.
        :paramtype coordinates: list[list[list[float]]]
        """
        super().__init__(coordinates=coordinates, **kwargs)
        self.coordinates = coordinates
        self.type = "Polygon"  # type: str


class LatLongPair(_serialization.Model):
    """A location represented as a latitude and longitude.

    :ivar latitude: Latitude property.
    :vartype latitude: float
    :ivar longitude: Longitude property.
    :vartype longitude: float
    """

    _attribute_map = {
        "latitude": {"key": "latitude", "type": "float"},
        "longitude": {"key": "longitude", "type": "float"},
    }

    def __init__(self, *, latitude: Optional[float] = None, longitude: Optional[float] = None, **kwargs):
        """
        :keyword latitude: Latitude property.
        :paramtype latitude: float
        :keyword longitude: Longitude property.
        :paramtype longitude: float
        """
        super().__init__(**kwargs)
        self.latitude = latitude
        self.longitude = longitude


class Route(_serialization.Model):
    """Route.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object.
    :vartype summary: ~azure.maps.route.models.RouteSummary
    :ivar legs: Legs array.
    :vartype legs: list[~azure.maps.route.models.RouteLeg]
    :ivar sections: Sections array.
    :vartype sections: list[~azure.maps.route.models.RouteSection]
    :ivar guidance: Contains guidance related elements. This field is present only when guidance
     was requested and is available.
    :vartype guidance: ~azure.maps.route.models.RouteGuidance
    """

    _validation = {
        "summary": {"readonly": True},
        "legs": {"readonly": True},
        "sections": {"readonly": True},
        "guidance": {"readonly": True},
    }

    _attribute_map = {
        "summary": {"key": "summary", "type": "RouteSummary"},
        "legs": {"key": "legs", "type": "[RouteLeg]"},
        "sections": {"key": "sections", "type": "[RouteSection]"},
        "guidance": {"key": "guidance", "type": "RouteGuidance"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.summary = None
        self.legs = None
        self.sections = None
        self.guidance = None


class RouteDirectionParameters(_serialization.Model):
    """Post body parameters for Route directions.

    :ivar supporting_points: A GeoJSON Geometry collection representing sequence of coordinates
     used as input for route reconstruction and for calculating zero or more alternative routes to
     this reference route.


     * The provided sequence of supporting points is used as input for route reconstruction.
     * The alternative routes are calculated between the origin and destination points specified in
     the base path parameter locations.
     * If both *minDeviationDistance* and *minDeviationTime* are set to zero, then these origin and
     destination points are
       expected to be at (or very near) the beginning and end of the reference route, respectively.
     * Intermediate locations (\ *waypoints*\ ) are not supported when using
     :code:`<_supportingPoints_>`.
     * The reference route may contain traffic incidents of type _ROAD\ *CLOSURE*\ , which are
       ignored for the calculation of the reference route's travel time and traffic delay.
       Please refer to `Supporting Points
     <https://docs.microsoft.com/azure/azure-maps/how-to-use-best-practices-for-routing#calculate-and-bias-alternative-routes-using-supporting-points>`_
     for details.
    :vartype supporting_points: ~azure.maps.route.models.GeoJsonGeometryCollection
    :ivar avoid_vignette: This is a list of 3-character, ISO 3166-1, alpha-3 country codes of
     countries in which all toll roads with vignettes are to be avoided, e.g. "AUS,CHE". Toll roads
     with vignettes in countries not in the list are unaffected. Note: It is an error to specify
     both **avoidVignette** and **allowVignette**.
    :vartype avoid_vignette: list[str]
    :ivar allow_vignette: This is a list of 3-character, ISO 3166-1, alpha-3 country codes of
     countries in which toll roads with vignettes are allowed, e.g. "AUS,CHE". Specifying
     **allowVignette** with some countries X is equivalent to specifying **avoidVignette** with all
     countries but X. Specifying **allowVignette** with an empty list is the same as avoiding all
     toll roads with vignettes. Note: It is an error to specify both **avoidVignette** and
     **allowVignette**.
    :vartype allow_vignette: list[str]
    :ivar avoid_areas: A GeoJSON MultiPolygon representing list of areas to avoid. Only rectangle
     polygons are supported. The maximum size of a rectangle is about 160x160 km. Maximum number of
     avoided areas is **10**. It cannot cross the 180th meridian. It must be between -80 and +80
     degrees of latitude.
    :vartype avoid_areas: ~azure.maps.route.models.GeoJsonMultiPolygon
    """

    _attribute_map = {
        "supporting_points": {"key": "supportingPoints", "type": "GeoJsonGeometryCollection"},
        "avoid_vignette": {"key": "avoidVignette", "type": "[str]"},
        "allow_vignette": {"key": "allowVignette", "type": "[str]"},
        "avoid_areas": {"key": "avoidAreas", "type": "GeoJsonMultiPolygon"},
    }

    def __init__(
        self,
        *,
        supporting_points: Optional["_models.GeoJsonGeometryCollection"] = None,
        avoid_vignette: Optional[List[str]] = None,
        allow_vignette: Optional[List[str]] = None,
        avoid_areas: Optional["_models.GeoJsonMultiPolygon"] = None,
        **kwargs
    ):
        """
        :keyword supporting_points: A GeoJSON Geometry collection representing sequence of coordinates
         used as input for route reconstruction and for calculating zero or more alternative routes to
         this reference route.


         * The provided sequence of supporting points is used as input for route reconstruction.
         * The alternative routes are calculated between the origin and destination points specified in
         the base path parameter locations.
         * If both *minDeviationDistance* and *minDeviationTime* are set to zero, then these origin and
         destination points are
           expected to be at (or very near) the beginning and end of the reference route, respectively.
         * Intermediate locations (\ *waypoints*\ ) are not supported when using
         :code:`<_supportingPoints_>`.
         * The reference route may contain traffic incidents of type _ROAD\ *CLOSURE*\ , which are
           ignored for the calculation of the reference route's travel time and traffic delay.
           Please refer to `Supporting Points
         <https://docs.microsoft.com/azure/azure-maps/how-to-use-best-practices-for-routing#calculate-and-bias-alternative-routes-using-supporting-points>`_
         for details.
        :paramtype supporting_points: ~azure.maps.route.models.GeoJsonGeometryCollection
        :keyword avoid_vignette: This is a list of 3-character, ISO 3166-1, alpha-3 country codes of
         countries in which all toll roads with vignettes are to be avoided, e.g. "AUS,CHE". Toll roads
         with vignettes in countries not in the list are unaffected. Note: It is an error to specify
         both **avoidVignette** and **allowVignette**.
        :paramtype avoid_vignette: list[str]
        :keyword allow_vignette: This is a list of 3-character, ISO 3166-1, alpha-3 country codes of
         countries in which toll roads with vignettes are allowed, e.g. "AUS,CHE". Specifying
         **allowVignette** with some countries X is equivalent to specifying **avoidVignette** with all
         countries but X. Specifying **allowVignette** with an empty list is the same as avoiding all
         toll roads with vignettes. Note: It is an error to specify both **avoidVignette** and
         **allowVignette**.
        :paramtype allow_vignette: list[str]
        :keyword avoid_areas: A GeoJSON MultiPolygon representing list of areas to avoid. Only
         rectangle polygons are supported. The maximum size of a rectangle is about 160x160 km. Maximum
         number of avoided areas is **10**. It cannot cross the 180th meridian. It must be between -80
         and +80 degrees of latitude.
        :paramtype avoid_areas: ~azure.maps.route.models.GeoJsonMultiPolygon
        """
        super().__init__(**kwargs)
        self.supporting_points = supporting_points
        self.avoid_vignette = avoid_vignette
        self.allow_vignette = allow_vignette
        self.avoid_areas = avoid_areas


class RouteDirections(_serialization.Model):
    """This object is returned from a successful Route Directions call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar routes: Routes array.
    :vartype routes: list[~azure.maps.route.models.Route]
    :ivar optimized_waypoints: Optimized sequence of waypoints. It shows the index from the user
     provided waypoint sequence for the original and optimized list. For instance, a response:

     .. code-block::

        <optimizedWaypoints>
        <waypoint providedIndex="0" optimizedIndex="1"/>
        <waypoint providedIndex="1" optimizedIndex="2"/>
        <waypoint providedIndex="2" optimizedIndex="0"/>
        </optimizedWaypoints>

     means that the original sequence is [0, 1, 2] and optimized sequence is [1, 2, 0]. Since the
     index starts by 0 the original is "first, second, third" while the optimized is "second, third,
     first".
    :vartype optimized_waypoints: list[~azure.maps.route.models.RouteOptimizedWaypoint]
    :ivar report: Reports the effective settings used in the current call.
    :vartype report: ~azure.maps.route.models.RouteReport
    """

    _validation = {
        "format_version": {"readonly": True},
        "routes": {"readonly": True},
        "optimized_waypoints": {"readonly": True},
    }

    _attribute_map = {
        "format_version": {"key": "formatVersion", "type": "str"},
        "routes": {"key": "routes", "type": "[Route]"},
        "optimized_waypoints": {"key": "optimizedWaypoints", "type": "[RouteOptimizedWaypoint]"},
        "report": {"key": "report", "type": "RouteReport"},
    }

    def __init__(self, *, report: Optional["_models.RouteReport"] = None, **kwargs):
        """
        :keyword report: Reports the effective settings used in the current call.
        :paramtype report: ~azure.maps.route.models.RouteReport
        """
        super().__init__(**kwargs)
        self.format_version = None
        self.routes = None
        self.optimized_waypoints = None
        self.report = report


class RouteDirectionsBatchItem(BatchResultItem):
    """An item returned from Route Directions Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: HTTP request status code.
    :vartype status_code: int
    :ivar response: The result of the query. RouteDirections if the query completed successfully,
     ErrorResponse otherwise.
    :vartype response: ~azure.maps.route.models.RouteDirectionsBatchItemResponse
    """

    _validation = {
        "status_code": {"readonly": True},
        "response": {"readonly": True},
    }

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "int"},
        "response": {"key": "response", "type": "RouteDirectionsBatchItemResponse"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.response = None


class RouteDirectionsBatchItemResponse(RouteDirections, ErrorResponse):
    """The result of the query. RouteDirections if the query completed successfully, ErrorResponse otherwise.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.maps.route.models.ErrorDetail
    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar routes: Routes array.
    :vartype routes: list[~azure.maps.route.models.Route]
    :ivar optimized_waypoints: Optimized sequence of waypoints. It shows the index from the user
     provided waypoint sequence for the original and optimized list. For instance, a response:

     .. code-block::

        <optimizedWaypoints>
        <waypoint providedIndex="0" optimizedIndex="1"/>
        <waypoint providedIndex="1" optimizedIndex="2"/>
        <waypoint providedIndex="2" optimizedIndex="0"/>
        </optimizedWaypoints>

     means that the original sequence is [0, 1, 2] and optimized sequence is [1, 2, 0]. Since the
     index starts by 0 the original is "first, second, third" while the optimized is "second, third,
     first".
    :vartype optimized_waypoints: list[~azure.maps.route.models.RouteOptimizedWaypoint]
    :ivar report: Reports the effective settings used in the current call.
    :vartype report: ~azure.maps.route.models.RouteReport
    """

    _validation = {
        "format_version": {"readonly": True},
        "routes": {"readonly": True},
        "optimized_waypoints": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "format_version": {"key": "formatVersion", "type": "str"},
        "routes": {"key": "routes", "type": "[Route]"},
        "optimized_waypoints": {"key": "optimizedWaypoints", "type": "[RouteOptimizedWaypoint]"},
        "report": {"key": "report", "type": "RouteReport"},
    }

    def __init__(
        self, *, error: Optional["_models.ErrorDetail"] = None, report: Optional["_models.RouteReport"] = None, **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.maps.route.models.ErrorDetail
        :keyword report: Reports the effective settings used in the current call.
        :paramtype report: ~azure.maps.route.models.RouteReport
        """
        super().__init__(report=report, error=error, **kwargs)
        self.error = error
        self.format_version = None
        self.routes = None
        self.optimized_waypoints = None
        self.report = report


class RouteDirectionsBatchResult(BatchResult):
    """This object is returned from a successful Route Directions Batch service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar batch_summary: Summary of the results for the batch request.
    :vartype batch_summary: ~azure.maps.route.models.BatchResultSummary
    :ivar batch_items: Array containing the batch results.
    :vartype batch_items: list[~azure.maps.route.models.RouteDirectionsBatchItem]
    """

    _validation = {
        "batch_summary": {"readonly": True},
        "batch_items": {"readonly": True},
    }

    _attribute_map = {
        "batch_summary": {"key": "summary", "type": "BatchResultSummary"},
        "batch_items": {"key": "batchItems", "type": "[RouteDirectionsBatchItem]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.batch_items = None


class RouteGuidance(_serialization.Model):
    """Contains guidance related elements. This field is present only when guidance was requested and is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar instructions: A list of instructions describing maneuvers.
    :vartype instructions: list[~azure.maps.route.models.RouteInstruction]
    :ivar instruction_groups: Groups a sequence of instruction elements which are related to each
     other.
    :vartype instruction_groups: list[~azure.maps.route.models.RouteInstructionGroup]
    """

    _validation = {
        "instructions": {"readonly": True},
        "instruction_groups": {"readonly": True},
    }

    _attribute_map = {
        "instructions": {"key": "instructions", "type": "[RouteInstruction]"},
        "instruction_groups": {"key": "instructionGroups", "type": "[RouteInstructionGroup]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.instructions = None
        self.instruction_groups = None


class RouteInstruction(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A set of attributes describing a maneuver, e.g. 'Turn right', 'Keep left', 'Take the ferry', 'Take the motorway', 'Arrive'.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar route_offset_in_meters: Distance from the start of the route to the point of the
     instruction.
    :vartype route_offset_in_meters: int
    :ivar travel_time_in_seconds: Estimated travel time up to the point corresponding to
     routeOffsetInMeters.
    :vartype travel_time_in_seconds: int
    :ivar point: A location represented as a latitude and longitude.
    :vartype point: ~azure.maps.route.models.LatLongPair
    :ivar point_index: The index of the point in the list of polyline "points" corresponding to the
     point of the instruction.
    :vartype point_index: int
    :ivar instruction_type: Type of the instruction, e.g., turn or change of road form. Known
     values are: "TURN", "ROAD_CHANGE", "LOCATION_DEPARTURE", "LOCATION_ARRIVAL", "DIRECTION_INFO",
     and "LOCATION_WAYPOINT".
    :vartype instruction_type: str or ~azure.maps.route.models.GuidanceInstructionType
    :ivar road_numbers: The road number(s) of the next significant road segment(s) after the
     maneuver, or of the road(s) to be followed. Example: ["E34", "N205"].
    :vartype road_numbers: list[str]
    :ivar exit_number: The number(s) of a highway exit taken by the current maneuver. If an exit
     has multiple exit numbers, they will be separated by "," and possibly aggregated by "-", e.g.,
     "10, 13-15".
    :vartype exit_number: str
    :ivar street: Street name of the next significant road segment after the maneuver, or of the
     street that should be followed.
    :vartype street: str
    :ivar signpost_text: The text on a signpost which is most relevant to the maneuver, or to the
     direction that should be followed.
    :vartype signpost_text: str
    :ivar country_code: 3-character `ISO 3166-1 <https://www.iso.org/iso-3166-country-codes.html>`_
     alpha-3 country code. E.g. USA.
    :vartype country_code: str
    :ivar state_code: A subdivision (e.g., state) of the country, represented by the second part of
     an `ISO 3166-2 <https://www.iso.org/standard/63546.html>`_ code. This is only available for
     some countries like the US, Canada, and Mexico.
    :vartype state_code: str
    :ivar junction_type: The type of the junction where the maneuver takes place. For larger
     roundabouts, two separate instructions are generated for entering and leaving the roundabout.
     Known values are: "REGULAR", "ROUNDABOUT", and "BIFURCATION".
    :vartype junction_type: str or ~azure.maps.route.models.JunctionType
    :ivar turn_angle_in_degrees: Indicates the direction of an instruction. If junctionType
     indicates a turn instruction:


     * 180 = U-turn
     * [-179, -1] = Left turn
     * 0 = Straight on (a '0 degree' turn)
     * [1, 179] = Right turn

     If junctionType indicates a bifurcation instruction:


     * <0 - keep left
     * &gt;0 - keep right.
    :vartype turn_angle_in_degrees: int
    :ivar roundabout_exit_number: This indicates which exit to take at a roundabout.
    :vartype roundabout_exit_number: str
    :ivar possible_combine_with_next: It is possible to optionally combine the instruction with the
     next one. This can be used to build messages like "Turn left and then turn right".
    :vartype possible_combine_with_next: bool
    :ivar driving_side: Indicates left-hand vs. right-hand side driving at the point of the
     maneuver. Known values are: "LEFT" and "RIGHT".
    :vartype driving_side: str or ~azure.maps.route.models.DrivingSide
    :ivar maneuver: A code identifying the maneuver. Known values are: "ARRIVE", "ARRIVE_LEFT",
     "ARRIVE_RIGHT", "DEPART", "STRAIGHT", "KEEP_RIGHT", "BEAR_RIGHT", "TURN_RIGHT", "SHARP_RIGHT",
     "KEEP_LEFT", "BEAR_LEFT", "TURN_LEFT", "SHARP_LEFT", "MAKE_UTURN", "ENTER_MOTORWAY",
     "ENTER_FREEWAY", "ENTER_HIGHWAY", "TAKE_EXIT", "MOTORWAY_EXIT_LEFT", "MOTORWAY_EXIT_RIGHT",
     "TAKE_FERRY", "ROUNDABOUT_CROSS", "ROUNDABOUT_RIGHT", "ROUNDABOUT_LEFT", "ROUNDABOUT_BACK",
     "TRY_MAKE_UTURN", "FOLLOW", "SWITCH_PARALLEL_ROAD", "SWITCH_MAIN_ROAD", "ENTRANCE_RAMP",
     "WAYPOINT_LEFT", "WAYPOINT_RIGHT", and "WAYPOINT_REACHED".
    :vartype maneuver: str or ~azure.maps.route.models.GuidanceManeuver
    :ivar message: A human-readable message for the maneuver.
    :vartype message: str
    :ivar combined_message: A human-readable message for the maneuver combined with the message
     from the next instruction. Sometimes it is possible to combine two successive instructions into
     a single instruction making it easier to follow. When this is the case the
     possibleCombineWithNext flag will be true. For example:

     .. code-block::

        10. Turn left onto Einsteinweg/A10/E22 towards Ring Amsterdam
        11. Follow Einsteinweg/A10/E22 towards Ring Amsterdam

     The possibleCombineWithNext flag on instruction 10 is true. This indicates to the clients of
     coded guidance that it can be combined with instruction 11. The instructions will be combined
     automatically for clients requesting human-readable guidance. The combinedMessage field
     contains the combined message:

     .. code-block::

        Turn left onto Einsteinweg/A10/E22 towards Ring Amsterdam
        then follow Einsteinweg/A10/E22 towards Ring Amsterdam.
    :vartype combined_message: str
    """

    _validation = {
        "route_offset_in_meters": {"readonly": True},
        "travel_time_in_seconds": {"readonly": True},
        "point_index": {"readonly": True},
        "road_numbers": {"readonly": True},
        "exit_number": {"readonly": True},
        "street": {"readonly": True},
        "signpost_text": {"readonly": True},
        "country_code": {"readonly": True},
        "state_code": {"readonly": True},
        "junction_type": {"readonly": True},
        "turn_angle_in_degrees": {"readonly": True},
        "roundabout_exit_number": {"readonly": True},
        "possible_combine_with_next": {"readonly": True},
        "driving_side": {"readonly": True},
        "maneuver": {"readonly": True},
        "message": {"readonly": True},
        "combined_message": {"readonly": True},
    }

    _attribute_map = {
        "route_offset_in_meters": {"key": "routeOffsetInMeters", "type": "int"},
        "travel_time_in_seconds": {"key": "travelTimeInSeconds", "type": "int"},
        "point": {"key": "point", "type": "LatLongPair"},
        "point_index": {"key": "pointIndex", "type": "int"},
        "instruction_type": {"key": "instructionType", "type": "str"},
        "road_numbers": {"key": "roadNumbers", "type": "[str]"},
        "exit_number": {"key": "exitNumber", "type": "str"},
        "street": {"key": "street", "type": "str"},
        "signpost_text": {"key": "signpostText", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "state_code": {"key": "stateCode", "type": "str"},
        "junction_type": {"key": "junctionType", "type": "str"},
        "turn_angle_in_degrees": {"key": "turnAngleInDecimalDegrees", "type": "int"},
        "roundabout_exit_number": {"key": "roundaboutExitNumber", "type": "str"},
        "possible_combine_with_next": {"key": "possibleCombineWithNext", "type": "bool"},
        "driving_side": {"key": "drivingSide", "type": "str"},
        "maneuver": {"key": "maneuver", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "combined_message": {"key": "combinedMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        point: Optional["_models.LatLongPair"] = None,
        instruction_type: Optional[Union[str, "_models.GuidanceInstructionType"]] = None,
        **kwargs
    ):
        """
        :keyword point: A location represented as a latitude and longitude.
        :paramtype point: ~azure.maps.route.models.LatLongPair
        :keyword instruction_type: Type of the instruction, e.g., turn or change of road form. Known
         values are: "TURN", "ROAD_CHANGE", "LOCATION_DEPARTURE", "LOCATION_ARRIVAL", "DIRECTION_INFO",
         and "LOCATION_WAYPOINT".
        :paramtype instruction_type: str or ~azure.maps.route.models.GuidanceInstructionType
        """
        super().__init__(**kwargs)
        self.route_offset_in_meters = None
        self.travel_time_in_seconds = None
        self.point = point
        self.point_index = None
        self.instruction_type = instruction_type
        self.road_numbers = None
        self.exit_number = None
        self.street = None
        self.signpost_text = None
        self.country_code = None
        self.state_code = None
        self.junction_type = None
        self.turn_angle_in_degrees = None
        self.roundabout_exit_number = None
        self.possible_combine_with_next = None
        self.driving_side = None
        self.maneuver = None
        self.message = None
        self.combined_message = None


class RouteInstructionGroup(_serialization.Model):
    """Groups a sequence of instruction elements which are related to each other. The sequence range is constrained with firstInstructionIndex and lastInstructionIndex. When human-readable text messages are requested for guidance (instructionType=text or tagged), then the instructionGroup has a summary message returned when available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar first_instruction_index: Index of the first instruction in the instructions and belonging
     to this group.
    :vartype first_instruction_index: int
    :ivar last_instruction_index: Index of the last instruction in the instructions and belonging
     to this group.
    :vartype last_instruction_index: int
    :ivar group_length_in_meters: Length of the group.
    :vartype group_length_in_meters: int
    :ivar group_message: Summary message when human-readable text messages are requested for
     guidance (instructionType=text or tagged).
    :vartype group_message: str
    """

    _validation = {
        "first_instruction_index": {"readonly": True},
        "last_instruction_index": {"readonly": True},
        "group_length_in_meters": {"readonly": True},
        "group_message": {"readonly": True},
    }

    _attribute_map = {
        "first_instruction_index": {"key": "firstInstructionIndex", "type": "int"},
        "last_instruction_index": {"key": "lastInstructionIndex", "type": "int"},
        "group_length_in_meters": {"key": "groupLengthInMeters", "type": "int"},
        "group_message": {"key": "groupMessage", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.first_instruction_index = None
        self.last_instruction_index = None
        self.group_length_in_meters = None
        self.group_message = None


class RouteLeg(_serialization.Model):
    """A description of a part of a route, comprised of a list of points. Each additional waypoint provided in the request will result in an additional leg in the returned route.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for route section.
    :vartype summary: ~azure.maps.route.models.RouteLegSummary
    :ivar points: Points array.
    :vartype points: list[~azure.maps.route.models.LatLongPair]
    """

    _validation = {
        "summary": {"readonly": True},
        "points": {"readonly": True},
    }

    _attribute_map = {
        "summary": {"key": "summary", "type": "RouteLegSummary"},
        "points": {"key": "points", "type": "[LatLongPair]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.summary = None
        self.points = None


class RouteLegSummary(_serialization.Model):
    """Summary object for route section.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar length_in_meters: Length In Meters property.
    :vartype length_in_meters: int
    :ivar travel_time_in_seconds: Estimated travel time in seconds property that includes the delay
     due to real-time traffic. Note that even when traffic=false travelTimeInSeconds still includes
     the delay due to traffic. If DepartAt is in the future, travel time is calculated using
     time-dependent historic traffic data.
    :vartype travel_time_in_seconds: int
    :ivar traffic_delay_in_seconds: Estimated delay in seconds caused by the real-time incident(s)
     according to traffic information. For routes planned with departure time in the future, delays
     is always 0. To return additional travel times using different types of traffic information,
     parameter computeTravelTimeFor=all needs to be added.
    :vartype traffic_delay_in_seconds: int
    :ivar departure_time: The estimated departure time for the route or leg.
    :vartype departure_time: ~datetime.datetime
    :ivar arrival_time: The estimated arrival time for the route or leg.
    :vartype arrival_time: ~datetime.datetime
    :ivar no_traffic_travel_time_in_seconds: Estimated travel time calculated as if there are no
     delays on the route due to traffic conditions (e.g. congestion). Included only if
     computeTravelTimeFor = all is used in the query.
    :vartype no_traffic_travel_time_in_seconds: int
    :ivar historic_traffic_travel_time_in_seconds: Estimated travel time calculated using
     time-dependent historic traffic data. Included only if computeTravelTimeFor = all is used in
     the query.
    :vartype historic_traffic_travel_time_in_seconds: int
    :ivar live_traffic_incidents_travel_time_in_seconds: Estimated travel time calculated using
     real-time speed data. Included only if computeTravelTimeFor = all is used in the query.
    :vartype live_traffic_incidents_travel_time_in_seconds: int
    :ivar fuel_consumption_in_liters: Estimated fuel consumption in liters using the Combustion
     Consumption Model. Included if vehicleEngineType is set to *combustion* and
     constantSpeedConsumptionInLitersPerHundredkm is specified. The value will be non-negative.
    :vartype fuel_consumption_in_liters: float
    :ivar battery_consumption_in_kw_h: Estimated electric energy consumption in kilowatt hours
     (kWh) using the Electric Consumption Model. Included if vehicleEngineType is set to electric
     and constantSpeedConsumptionInkWhPerHundredkm is specified. The value of
     batteryConsumptionInkWh includes the recuperated electric energy and can therefore be negative
     (which indicates gaining energy). If both maxChargeInkWh and currentChargeInkWh are specified,
     recuperation will be capped to ensure that the battery charge level never exceeds
     maxChargeInkWh. If neither maxChargeInkWh nor currentChargeInkWh are specified, unconstrained
     recuperation is assumed in the consumption calculation.
    :vartype battery_consumption_in_kw_h: float
    """

    _validation = {
        "length_in_meters": {"readonly": True},
        "travel_time_in_seconds": {"readonly": True},
        "traffic_delay_in_seconds": {"readonly": True},
        "departure_time": {"readonly": True},
        "arrival_time": {"readonly": True},
        "no_traffic_travel_time_in_seconds": {"readonly": True},
        "historic_traffic_travel_time_in_seconds": {"readonly": True},
        "live_traffic_incidents_travel_time_in_seconds": {"readonly": True},
        "fuel_consumption_in_liters": {"readonly": True},
        "battery_consumption_in_kw_h": {"readonly": True},
    }

    _attribute_map = {
        "length_in_meters": {"key": "lengthInMeters", "type": "int"},
        "travel_time_in_seconds": {"key": "travelTimeInSeconds", "type": "int"},
        "traffic_delay_in_seconds": {"key": "trafficDelayInSeconds", "type": "int"},
        "departure_time": {"key": "departureTime", "type": "iso-8601"},
        "arrival_time": {"key": "arrivalTime", "type": "iso-8601"},
        "no_traffic_travel_time_in_seconds": {"key": "noTrafficTravelTimeInSeconds", "type": "int"},
        "historic_traffic_travel_time_in_seconds": {"key": "historicTrafficTravelTimeInSeconds", "type": "int"},
        "live_traffic_incidents_travel_time_in_seconds": {
            "key": "liveTrafficIncidentsTravelTimeInSeconds",
            "type": "int",
        },
        "fuel_consumption_in_liters": {"key": "fuelConsumptionInLiters", "type": "float"},
        "battery_consumption_in_kw_h": {"key": "batteryConsumptionInkWh", "type": "float"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.length_in_meters = None
        self.travel_time_in_seconds = None
        self.traffic_delay_in_seconds = None
        self.departure_time = None
        self.arrival_time = None
        self.no_traffic_travel_time_in_seconds = None
        self.historic_traffic_travel_time_in_seconds = None
        self.live_traffic_incidents_travel_time_in_seconds = None
        self.fuel_consumption_in_liters = None
        self.battery_consumption_in_kw_h = None


class RouteMatrix(_serialization.Model):
    """Matrix result object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status_code: StatusCode property for the current cell in the input matrix.
    :vartype status_code: int
    :ivar response: Response object of the current cell in the input matrix.
    :vartype response: ~azure.maps.route.models.RouteMatrixResultResponse
    """

    _validation = {
        "status_code": {"readonly": True},
        "response": {"readonly": True},
    }

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "int"},
        "response": {"key": "response", "type": "RouteMatrixResultResponse"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status_code = None
        self.response = None


class RouteMatrixQuery(_serialization.Model):
    """An object with a matrix of coordinates.

    :ivar origins: A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.3>`_ for details.
    :vartype origins: ~azure.maps.route.models.GeoJsonMultiPoint
    :ivar destinations: A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946
     <https://tools.ietf.org/html/rfc7946#section-3.1.3>`_ for details.
    :vartype destinations: ~azure.maps.route.models.GeoJsonMultiPoint
    """

    _attribute_map = {
        "origins": {"key": "origins", "type": "GeoJsonMultiPoint"},
        "destinations": {"key": "destinations", "type": "GeoJsonMultiPoint"},
    }

    def __init__(
        self,
        *,
        origins: Optional["_models.GeoJsonMultiPoint"] = None,
        destinations: Optional["_models.GeoJsonMultiPoint"] = None,
        **kwargs
    ):
        """
        :keyword origins: A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1.3>`_ for details.
        :paramtype origins: ~azure.maps.route.models.GeoJsonMultiPoint
        :keyword destinations: A valid ``GeoJSON MultiPoint`` geometry type. Please refer to `RFC 7946
         <https://tools.ietf.org/html/rfc7946#section-3.1.3>`_ for details.
        :paramtype destinations: ~azure.maps.route.models.GeoJsonMultiPoint
        """
        super().__init__(**kwargs)
        self.origins = origins
        self.destinations = destinations


class RouteMatrixResult(_serialization.Model):
    """This object is returned from a successful Route Matrix call. For ex, if 2 origins and 3 destinations are provided, there are going to 2 arrays with 3 elements in each. Each element's content depends on the options provided in the query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar matrix: Results as a 2 dimensional array of route summaries.
    :vartype matrix: list[list[~azure.maps.route.models.RouteMatrix]]
    :ivar summary: Summary object.
    :vartype summary: ~azure.maps.route.models.RouteMatrixSummary
    """

    _validation = {
        "format_version": {"readonly": True},
        "matrix": {"readonly": True},
        "summary": {"readonly": True},
    }

    _attribute_map = {
        "format_version": {"key": "formatVersion", "type": "str"},
        "matrix": {"key": "matrix", "type": "[[RouteMatrix]]"},
        "summary": {"key": "summary", "type": "RouteMatrixSummary"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.format_version = None
        self.matrix = None
        self.summary = None


class RouteMatrixResultResponse(_serialization.Model):
    """Response object of the current cell in the input matrix.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar summary: Summary object for route section.
    :vartype summary: ~azure.maps.route.models.RouteLegSummary
    """

    _validation = {
        "summary": {"readonly": True},
    }

    _attribute_map = {
        "summary": {"key": "routeSummary", "type": "RouteLegSummary"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.summary = None


class RouteMatrixSummary(_serialization.Model):
    """Summary object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_routes: Number of successful routes in the response.
    :vartype successful_routes: int
    :ivar total_routes: Total number of routes requested. Number of cells in the input matrix.
    :vartype total_routes: int
    """

    _validation = {
        "successful_routes": {"readonly": True},
        "total_routes": {"readonly": True},
    }

    _attribute_map = {
        "successful_routes": {"key": "successfulRoutes", "type": "int"},
        "total_routes": {"key": "totalRoutes", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.successful_routes = None
        self.total_routes = None


class RouteOptimizedWaypoint(_serialization.Model):
    """Optimized way point object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provided_index: Way point index provided by the user.
    :vartype provided_index: int
    :ivar optimized_index: Optimized way point index from the system.
    :vartype optimized_index: int
    """

    _validation = {
        "provided_index": {"readonly": True},
        "optimized_index": {"readonly": True},
    }

    _attribute_map = {
        "provided_index": {"key": "providedIndex", "type": "int"},
        "optimized_index": {"key": "optimizedIndex", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provided_index = None
        self.optimized_index = None


class RouteRange(_serialization.Model):
    """Reachable Range.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar center: Center point of the reachable range.
    :vartype center: ~azure.maps.route.models.LatLongPair
    :ivar boundary: Polygon boundary of the reachable range represented as a list of points.
    :vartype boundary: list[~azure.maps.route.models.LatLongPair]
    """

    _validation = {
        "boundary": {"readonly": True},
    }

    _attribute_map = {
        "center": {"key": "center", "type": "LatLongPair"},
        "boundary": {"key": "boundary", "type": "[LatLongPair]"},
    }

    def __init__(self, *, center: Optional["_models.LatLongPair"] = None, **kwargs):
        """
        :keyword center: Center point of the reachable range.
        :paramtype center: ~azure.maps.route.models.LatLongPair
        """
        super().__init__(**kwargs)
        self.center = center
        self.boundary = None


class RouteRangeResult(_serialization.Model):
    """This object is returned from a successful Route Reachable Range call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar reachable_range: Reachable Range.
    :vartype reachable_range: ~azure.maps.route.models.RouteRange
    :ivar report: Reports the effective settings used in the current call.
    :vartype report: ~azure.maps.route.models.RouteReport
    """

    _validation = {
        "format_version": {"readonly": True},
    }

    _attribute_map = {
        "format_version": {"key": "formatVersion", "type": "str"},
        "reachable_range": {"key": "reachableRange", "type": "RouteRange"},
        "report": {"key": "report", "type": "RouteReport"},
    }

    def __init__(
        self,
        *,
        reachable_range: Optional["_models.RouteRange"] = None,
        report: Optional["_models.RouteReport"] = None,
        **kwargs
    ):
        """
        :keyword reachable_range: Reachable Range.
        :paramtype reachable_range: ~azure.maps.route.models.RouteRange
        :keyword report: Reports the effective settings used in the current call.
        :paramtype report: ~azure.maps.route.models.RouteReport
        """
        super().__init__(**kwargs)
        self.format_version = None
        self.reachable_range = reachable_range
        self.report = report


class RouteReport(_serialization.Model):
    """Reports the effective settings used in the current call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar effective_settings: Effective parameters or data used when calling this Route API.
    :vartype effective_settings: list[~azure.maps.route.models.EffectiveSetting]
    """

    _validation = {
        "effective_settings": {"readonly": True},
    }

    _attribute_map = {
        "effective_settings": {"key": "effectiveSettings", "type": "[EffectiveSetting]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.effective_settings = None


class RouteSection(_serialization.Model):
    """Route sections contain additional information about parts of a route. Each section contains at least the elements ``startPointIndex``\ , ``endPointIndex``\ , and ``sectionType``.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_point_index: Index of the first point (offset 0) in the route this section applies
     to.
    :vartype start_point_index: int
    :ivar end_point_index: Index of the last point (offset 0) in the route this section applies to.
    :vartype end_point_index: int
    :ivar section_type: Section types of the reported route response. Known values are:
     "CAR_TRAIN", "COUNTRY", "FERRY", "MOTORWAY", "PEDESTRIAN", "TOLL_ROAD", "TOLL_VIGNETTE",
     "TRAFFIC", "TRAVEL_MODE", "TUNNEL", "CARPOOL", and "URBAN".
    :vartype section_type: str or ~azure.maps.route.models.ResponseSectionType
    :ivar travel_mode: Travel mode for the calculated route. The value will be set to ``other`` if
     the requested mode of transport is not possible in this section. Known values are: "car",
     "truck", "taxi", "bus", "van", "motorcycle", "bicycle", "pedestrian", and "other".
    :vartype travel_mode: str or ~azure.maps.route.models.ResponseTravelMode
    :ivar simple_category: Type of the incident. Can currently be JAM, ROAD_WORK, ROAD_CLOSURE, or
     OTHER. See "tec" for detailed information. Known values are: "JAM", "ROAD_WORK",
     "ROAD_CLOSURE", and "OTHER".
    :vartype simple_category: str or ~azure.maps.route.models.SimpleCategory
    :ivar effective_speed_in_kmh: Effective speed of the incident in km/h, averaged over its entire
     length.
    :vartype effective_speed_in_kmh: int
    :ivar delay_in_seconds: Delay in seconds caused by the incident.
    :vartype delay_in_seconds: int
    :ivar delay_magnitude: The magnitude of delay caused by the incident. These values correspond
     to the values of the response field ty of the `Get Traffic Incident Detail API
     <https://docs.microsoft.com/rest/api/maps/traffic/gettrafficincidentdetail>`_. Known values
     are: "0", "1", "2", "3", and "4".
    :vartype delay_magnitude: str or ~azure.maps.route.models.DelayMagnitude
    :ivar tec: Details of the traffic event, using definitions in the `TPEG2-TEC
     <https://www.iso.org/standard/63116.html>`_ standard. Can contain effectCode and causes
     elements.
    :vartype tec: ~azure.maps.route.models.RouteSectionTec
    """

    _validation = {
        "start_point_index": {"readonly": True},
        "end_point_index": {"readonly": True},
        "section_type": {"readonly": True},
        "travel_mode": {"readonly": True},
        "simple_category": {"readonly": True},
        "effective_speed_in_kmh": {"readonly": True},
        "delay_in_seconds": {"readonly": True},
        "delay_magnitude": {"readonly": True},
    }

    _attribute_map = {
        "start_point_index": {"key": "startPointIndex", "type": "int"},
        "end_point_index": {"key": "endPointIndex", "type": "int"},
        "section_type": {"key": "sectionType", "type": "str"},
        "travel_mode": {"key": "travelMode", "type": "str"},
        "simple_category": {"key": "simpleCategory", "type": "str"},
        "effective_speed_in_kmh": {"key": "effectiveSpeedInKmh", "type": "int"},
        "delay_in_seconds": {"key": "delayInSeconds", "type": "int"},
        "delay_magnitude": {"key": "magnitudeOfDelay", "type": "str"},
        "tec": {"key": "tec", "type": "RouteSectionTec"},
    }

    def __init__(self, *, tec: Optional["_models.RouteSectionTec"] = None, **kwargs):
        """
        :keyword tec: Details of the traffic event, using definitions in the `TPEG2-TEC
         <https://www.iso.org/standard/63116.html>`_ standard. Can contain effectCode and causes
         elements.
        :paramtype tec: ~azure.maps.route.models.RouteSectionTec
        """
        super().__init__(**kwargs)
        self.start_point_index = None
        self.end_point_index = None
        self.section_type = None
        self.travel_mode = None
        self.simple_category = None
        self.effective_speed_in_kmh = None
        self.delay_in_seconds = None
        self.delay_magnitude = None
        self.tec = tec


class RouteSectionTec(_serialization.Model):
    """Details of the traffic event, using definitions in the `TPEG2-TEC <https://www.iso.org/standard/63116.html>`_ standard. Can contain effectCode and causes elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar effect_code: The effect on the traffic flow. Contains a value in the tec001:EffectCode
     table, as defined in the `TPEG2-TEC <https://www.iso.org/standard/63116.html>`_ standard. Can
     be used to color-code traffic events according to severity.
    :vartype effect_code: int
    :ivar causes: Causes array.
    :vartype causes: list[~azure.maps.route.models.RouteSectionTecCause]
    """

    _validation = {
        "effect_code": {"readonly": True},
    }

    _attribute_map = {
        "effect_code": {"key": "effectCode", "type": "int"},
        "causes": {"key": "causes", "type": "[RouteSectionTecCause]"},
    }

    def __init__(self, *, causes: Optional[List["_models.RouteSectionTecCause"]] = None, **kwargs):
        """
        :keyword causes: Causes array.
        :paramtype causes: list[~azure.maps.route.models.RouteSectionTecCause]
        """
        super().__init__(**kwargs)
        self.effect_code = None
        self.causes = causes


class RouteSectionTecCause(_serialization.Model):
    """The cause of the traffic event. Can contain mainCauseCode and subCauseCode elements. Can be used to define iconography and descriptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar main_cause_code: The main cause of the traffic event. Contains a value in the
     tec002:CauseCode table, as defined in the `TPEG2-TEC
     <https://www.iso.org/standard/63116.html>`_ standard.
    :vartype main_cause_code: int
    :ivar sub_cause_code: The subcause of the traffic event. Contains a value in the sub cause
     table defined by the mainCauseCode, as defined in the `TPEG2-TEC
     <https://www.iso.org/standard/63116.html>`_ standard.
    :vartype sub_cause_code: int
    """

    _validation = {
        "main_cause_code": {"readonly": True},
        "sub_cause_code": {"readonly": True},
    }

    _attribute_map = {
        "main_cause_code": {"key": "mainCauseCode", "type": "int"},
        "sub_cause_code": {"key": "subCauseCode", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.main_cause_code = None
        self.sub_cause_code = None


class RouteSummary(_serialization.Model):
    """Summary object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar length_in_meters: Length In Meters property.
    :vartype length_in_meters: int
    :ivar travel_time_in_seconds: Estimated travel time in seconds property that includes the delay
     due to real-time traffic. Note that even when traffic=false travelTimeInSeconds still includes
     the delay due to traffic. If DepartAt is in the future, travel time is calculated using
     time-dependent historic traffic data.
    :vartype travel_time_in_seconds: int
    :ivar traffic_delay_in_seconds: Estimated delay in seconds caused by the real-time incident(s)
     according to traffic information. For routes planned with departure time in the future, delays
     is always 0. To return additional travel times using different types of traffic information,
     parameter computeTravelTimeFor=all needs to be added.
    :vartype traffic_delay_in_seconds: int
    :ivar departure_time: The estimated departure time for the route or leg.
    :vartype departure_time: ~datetime.datetime
    :ivar arrival_time: The estimated arrival time for the route or leg.
    :vartype arrival_time: ~datetime.datetime
    """

    _validation = {
        "length_in_meters": {"readonly": True},
        "travel_time_in_seconds": {"readonly": True},
        "traffic_delay_in_seconds": {"readonly": True},
        "departure_time": {"readonly": True},
        "arrival_time": {"readonly": True},
    }

    _attribute_map = {
        "length_in_meters": {"key": "lengthInMeters", "type": "int"},
        "travel_time_in_seconds": {"key": "travelTimeInSeconds", "type": "int"},
        "traffic_delay_in_seconds": {"key": "trafficDelayInSeconds", "type": "int"},
        "departure_time": {"key": "departureTime", "type": "iso-8601"},
        "arrival_time": {"key": "arrivalTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.length_in_meters = None
        self.travel_time_in_seconds = None
        self.traffic_delay_in_seconds = None
        self.departure_time = None
        self.arrival_time = None
