# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-recoveryservicessiterecovery
# USAGE
    python replication_fabrics_reassociate_gateway.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SiteRecoveryManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="7c943c1b-5122-4097-90c8-861411bdd574",
        resource_group_name="MadhaviVRG",
        resource_name="MadhaviVault",
    )

    response = client.replication_fabrics.begin_reassociate_gateway(
        fabric_name="GRACE-V2A-1",
        failover_process_server_request={
            "properties": {
                "containerName": "cloud_1f3c15af-2256-4568-9e06-e1ef4f728f75",
                "sourceProcessServerId": "AFA0EC54-1894-4E44-9CAB02DB8854B117",
                "targetProcessServerId": "5D3ED340-85AE-C646-B338641E015DA405",
                "updateType": "ServerLevel",
                "vmsToMigrate": ["Vm1", "Vm2"],
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2022-10-01/examples/ReplicationFabrics_ReassociateGateway.json
if __name__ == "__main__":
    main()
