# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from ..._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_get_request(
    scan_id: str, scan_result_id: str, resource_id: str, *, workspace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2020-07-01-preview")
    )  # type: Literal["2020-07-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "scanId": _SERIALIZER.url("scan_id", scan_id, "str"),
        "scanResultId": _SERIALIZER.url("scan_result_id", scan_result_id, "str"),
        "resourceId": _SERIALIZER.url("resource_id", resource_id, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["workspaceId"] = _SERIALIZER.query("workspace_id", workspace_id, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(scan_id: str, resource_id: str, *, workspace_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2020-07-01-preview")
    )  # type: Literal["2020-07-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "scanId": _SERIALIZER.url("scan_id", scan_id, "str"),
        "resourceId": _SERIALIZER.url("resource_id", resource_id, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["workspaceId"] = _SERIALIZER.query("workspace_id", workspace_id, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class SqlVulnerabilityAssessmentScanResultsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2020_07_01_preview.SecurityCenter`'s
        :attr:`sql_vulnerability_assessment_scan_results` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(
        self, scan_id: str, scan_result_id: str, workspace_id: str, resource_id: str, **kwargs: Any
    ) -> _models.ScanResult:
        """Gets the scan results of a single rule in a scan record.

        Gets the scan results of a single rule in a scan record.

        :param scan_id: The scan Id. Type 'latest' to get the scan results for the latest scan.
         Required.
        :type scan_id: str
        :param scan_result_id: The rule Id of the results. Required.
        :type scan_result_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ScanResult or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_07_01_preview.models.ScanResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-07-01-preview")
        )  # type: Literal["2020-07-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ScanResult]

        request = build_get_request(
            scan_id=scan_id,
            scan_result_id=scan_result_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ScanResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}"}  # type: ignore

    @distributed_trace
    def list(self, scan_id: str, workspace_id: str, resource_id: str, **kwargs: Any) -> _models.ScanResults:
        """Gets a list of scan results for a single scan record.

        Gets a list of scan results for a single scan record.

        :param scan_id: The scan Id. Type 'latest' to get the scan results for the latest scan.
         Required.
        :type scan_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ScanResults or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_07_01_preview.models.ScanResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-07-01-preview")
        )  # type: Literal["2020-07-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ScanResults]

        request = build_list_request(
            scan_id=scan_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            template_url=self.list.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ScanResults", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list.metadata = {"url": "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults"}  # type: ignore
