# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AccountSasParameters(_serialization.Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: The signed services accessible with the account SAS. Possible values include:
     Blob (b), Queue (q), Table (t), File (f). Required. Known values are: "b", "q", "t", and "f".
    :vartype services: str or ~azure.mgmt.storage.v2018_07_01.models.Services
    :ivar resource_types: The signed resource types that are accessible with the account SAS.
     Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
     Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     Required. Known values are: "s", "c", and "o".
    :vartype resource_types: str or ~azure.mgmt.storage.v2018_07_01.models.SignedResourceTypes
    :ivar permissions: The signed permissions for the account SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     Required. Known values are: "r", "d", "w", "l", "a", "c", "u", and "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2018_07_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Known values
     are: "https,http" and "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2018_07_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
     Required.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    """

    _validation = {
        "services": {"required": True},
        "resource_types": {"required": True},
        "permissions": {"required": True},
        "shared_access_expiry_time": {"required": True},
    }

    _attribute_map = {
        "services": {"key": "signedServices", "type": "str"},
        "resource_types": {"key": "signedResourceTypes", "type": "str"},
        "permissions": {"key": "signedPermission", "type": "str"},
        "ip_address_or_range": {"key": "signedIp", "type": "str"},
        "protocols": {"key": "signedProtocol", "type": "str"},
        "shared_access_start_time": {"key": "signedStart", "type": "iso-8601"},
        "shared_access_expiry_time": {"key": "signedExpiry", "type": "iso-8601"},
        "key_to_sign": {"key": "keyToSign", "type": "str"},
    }

    def __init__(
        self,
        *,
        services: Union[str, "_models.Services"],
        resource_types: Union[str, "_models.SignedResourceTypes"],
        permissions: Union[str, "_models.Permissions"],
        shared_access_expiry_time: datetime.datetime,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "_models.HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        key_to_sign: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword services: The signed services accessible with the account SAS. Possible values
         include: Blob (b), Queue (q), Table (t), File (f). Required. Known values are: "b", "q", "t",
         and "f".
        :paramtype services: str or ~azure.mgmt.storage.v2018_07_01.models.Services
        :keyword resource_types: The signed resource types that are accessible with the account SAS.
         Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
         Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
         Required. Known values are: "s", "c", and "o".
        :paramtype resource_types: str or ~azure.mgmt.storage.v2018_07_01.models.SignedResourceTypes
        :keyword permissions: The signed permissions for the account SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
         Required. Known values are: "r", "d", "w", "l", "a", "c", "u", and "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2018_07_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Known
         values are: "https,http" and "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2018_07_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid. Required.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        """
        super().__init__(**kwargs)
        self.services = services
        self.resource_types = resource_types
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.key_to_sign = key_to_sign


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.etag = None


class BlobContainer(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """Properties of the blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Known values are: "Container", "Blob", and "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2018_07_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Known values are: "Locked" and
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2018_07_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "immutability_policy": {"readonly": True},
        "legal_hold": {"readonly": True},
        "has_legal_hold": {"readonly": True},
        "has_immutability_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_access": {"key": "properties.publicAccess", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "immutability_policy": {"key": "properties.immutabilityPolicy", "type": "ImmutabilityPolicyProperties"},
        "legal_hold": {"key": "properties.legalHold", "type": "LegalHoldProperties"},
        "has_legal_hold": {"key": "properties.hasLegalHold", "type": "bool"},
        "has_immutability_policy": {"key": "properties.hasImmutabilityPolicy", "type": "bool"},
    }

    def __init__(
        self,
        *,
        public_access: Optional[Union[str, "_models.PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Known values are: "Container", "Blob", and "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2018_07_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        """
        super().__init__(**kwargs)
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class BlobServiceProperties(Resource):
    """The properties of a storage account’s Blob service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Blob service.
    :vartype cors: ~azure.mgmt.storage.v2018_07_01.models.CorsRules
    :ivar default_service_version: DefaultServiceVersion indicates the default version to use for
     requests to the Blob service if an incoming request’s version is not specified. Possible values
     include version 2008-10-27 and all more recent versions.
    :vartype default_service_version: str
    :ivar delete_retention_policy: The blob service properties for soft delete.
    :vartype delete_retention_policy: ~azure.mgmt.storage.v2018_07_01.models.DeleteRetentionPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cors": {"key": "properties.cors", "type": "CorsRules"},
        "default_service_version": {"key": "properties.defaultServiceVersion", "type": "str"},
        "delete_retention_policy": {"key": "properties.deleteRetentionPolicy", "type": "DeleteRetentionPolicy"},
    }

    def __init__(
        self,
        *,
        cors: Optional["_models.CorsRules"] = None,
        default_service_version: Optional[str] = None,
        delete_retention_policy: Optional["_models.DeleteRetentionPolicy"] = None,
        **kwargs
    ):
        """
        :keyword cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the Blob service.
        :paramtype cors: ~azure.mgmt.storage.v2018_07_01.models.CorsRules
        :keyword default_service_version: DefaultServiceVersion indicates the default version to use
         for requests to the Blob service if an incoming request’s version is not specified. Possible
         values include version 2008-10-27 and all more recent versions.
        :paramtype default_service_version: str
        :keyword delete_retention_policy: The blob service properties for soft delete.
        :paramtype delete_retention_policy:
         ~azure.mgmt.storage.v2018_07_01.models.DeleteRetentionPolicy
        """
        super().__init__(**kwargs)
        self.cors = cors
        self.default_service_version = default_service_version
        self.delete_retention_policy = delete_retention_policy


class CheckNameAvailabilityResult(_serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be used. The Reason element
     is only returned if NameAvailable is false. Known values are: "AccountNameInvalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storage.v2018_07_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CorsRule(_serialization.Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required if CorsRule element is present. A list of origin domains that
     will be allowed via CORS, or "*" to allow all domains. Required.
    :vartype allowed_origins: list[str]
    :ivar allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are
     allowed to be executed by the origin. Required.
    :vartype allowed_methods: list[str or
     ~azure.mgmt.storage.v2018_07_01.models.CorsRuleAllowedMethodsItem]
    :ivar max_age_in_seconds: Required if CorsRule element is present. The number of seconds that
     the client/browser should cache a preflight response. Required.
    :vartype max_age_in_seconds: int
    :ivar exposed_headers: Required if CorsRule element is present. A list of response headers to
     expose to CORS clients. Required.
    :vartype exposed_headers: list[str]
    :ivar allowed_headers: Required if CorsRule element is present. A list of headers allowed to be
     part of the cross-origin request. Required.
    :vartype allowed_headers: list[str]
    """

    _validation = {
        "allowed_origins": {"required": True},
        "allowed_methods": {"required": True},
        "max_age_in_seconds": {"required": True},
        "exposed_headers": {"required": True},
        "allowed_headers": {"required": True},
    }

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "allowed_methods": {"key": "allowedMethods", "type": "[str]"},
        "max_age_in_seconds": {"key": "maxAgeInSeconds", "type": "int"},
        "exposed_headers": {"key": "exposedHeaders", "type": "[str]"},
        "allowed_headers": {"key": "allowedHeaders", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_origins: List[str],
        allowed_methods: List[Union[str, "_models.CorsRuleAllowedMethodsItem"]],
        max_age_in_seconds: int,
        exposed_headers: List[str],
        allowed_headers: List[str],
        **kwargs
    ):
        """
        :keyword allowed_origins: Required if CorsRule element is present. A list of origin domains
         that will be allowed via CORS, or "*" to allow all domains. Required.
        :paramtype allowed_origins: list[str]
        :keyword allowed_methods: Required if CorsRule element is present. A list of HTTP methods that
         are allowed to be executed by the origin. Required.
        :paramtype allowed_methods: list[str or
         ~azure.mgmt.storage.v2018_07_01.models.CorsRuleAllowedMethodsItem]
        :keyword max_age_in_seconds: Required if CorsRule element is present. The number of seconds
         that the client/browser should cache a preflight response. Required.
        :paramtype max_age_in_seconds: int
        :keyword exposed_headers: Required if CorsRule element is present. A list of response headers
         to expose to CORS clients. Required.
        :paramtype exposed_headers: list[str]
        :keyword allowed_headers: Required if CorsRule element is present. A list of headers allowed to
         be part of the cross-origin request. Required.
        :paramtype allowed_headers: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.max_age_in_seconds = max_age_in_seconds
        self.exposed_headers = exposed_headers
        self.allowed_headers = allowed_headers


class CorsRules(_serialization.Model):
    """Sets the CORS rules. You can include up to five CorsRule elements in the request.

    :ivar cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the
     request.
    :vartype cors_rules: list[~azure.mgmt.storage.v2018_07_01.models.CorsRule]
    """

    _attribute_map = {
        "cors_rules": {"key": "corsRules", "type": "[CorsRule]"},
    }

    def __init__(self, *, cors_rules: Optional[List["_models.CorsRule"]] = None, **kwargs):
        """
        :keyword cors_rules: The List of CORS rules. You can include up to five CorsRule elements in
         the request.
        :paramtype cors_rules: list[~azure.mgmt.storage.v2018_07_01.models.CorsRule]
        """
        super().__init__(**kwargs)
        self.cors_rules = cors_rules


class CustomDomain(_serialization.Model):
    """The custom domain assigned to this storage account. This can be set via Update.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Gets or sets the custom domain name assigned to the storage account. Name is the
     CNAME source. Required.
    :vartype name: str
    :ivar use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
     value is false. This should only be set on updates.
    :vartype use_sub_domain_name: bool
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "use_sub_domain_name": {"key": "useSubDomainName", "type": "bool"},
    }

    def __init__(self, *, name: str, use_sub_domain_name: Optional[bool] = None, **kwargs):
        """
        :keyword name: Gets or sets the custom domain name assigned to the storage account. Name is the
         CNAME source. Required.
        :paramtype name: str
        :keyword use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
         value is false. This should only be set on updates.
        :paramtype use_sub_domain_name: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.use_sub_domain_name = use_sub_domain_name


class DeleteRetentionPolicy(_serialization.Model):
    """The blob service properties for soft delete.

    :ivar enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that the deleted blob should be retained. The minimum
     specified value can be 1 and the maximum value can be 365.
    :vartype days: int
    """

    _validation = {
        "days": {"maximum": 365, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "days": {"key": "days", "type": "int"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, days: Optional[int] = None, **kwargs):
        """
        :keyword enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that the deleted blob should be retained. The
         minimum specified value can be 1 and the maximum value can be 365.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class Dimension(_serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, display_name: Optional[str] = None, **kwargs):
        """
        :keyword name: Display name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class Encryption(_serialization.Model):
    """The encryption settings on the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: List of services which support encryption.
    :vartype services: ~azure.mgmt.storage.v2018_07_01.models.EncryptionServices
    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Microsoft.Storage, Microsoft.Keyvault. Known values are: "Microsoft.Storage" and
     "Microsoft.Keyvault".
    :vartype key_source: str or ~azure.mgmt.storage.v2018_07_01.models.KeySource
    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.storage.v2018_07_01.models.KeyVaultProperties
    """

    _validation = {
        "key_source": {"required": True},
    }

    _attribute_map = {
        "services": {"key": "services", "type": "EncryptionServices"},
        "key_source": {"key": "keySource", "type": "str"},
        "key_vault_properties": {"key": "keyvaultproperties", "type": "KeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        key_source: Union[str, "_models.KeySource"] = "Microsoft.Storage",
        services: Optional["_models.EncryptionServices"] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        **kwargs
    ):
        """
        :keyword services: List of services which support encryption.
        :paramtype services: ~azure.mgmt.storage.v2018_07_01.models.EncryptionServices
        :keyword key_source: The encryption keySource (provider). Possible values (case-insensitive):
         Microsoft.Storage, Microsoft.Keyvault. Known values are: "Microsoft.Storage" and
         "Microsoft.Keyvault".
        :paramtype key_source: str or ~azure.mgmt.storage.v2018_07_01.models.KeySource
        :keyword key_vault_properties: Properties provided by key vault.
        :paramtype key_vault_properties: ~azure.mgmt.storage.v2018_07_01.models.KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.services = services
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EncryptionService(_serialization.Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: A boolean indicating whether or not the service encrypts the data as it is
     stored.
    :vartype enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the encryption was last
     enabled by the user. Only returned when encryption is enabled. There might be some unencrypted
     blobs which were written after this time, as it is just a rough estimate.
    :vartype last_enabled_time: ~datetime.datetime
    """

    _validation = {
        "last_enabled_time": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "last_enabled_time": {"key": "lastEnabledTime", "type": "iso-8601"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: A boolean indicating whether or not the service encrypts the data as it is
         stored.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.last_enabled_time = None


class EncryptionServices(_serialization.Model):
    """A list of services that support encryption.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: The encryption function of the blob storage service.
    :vartype blob: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
    :ivar file: The encryption function of the file storage service.
    :vartype file: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
    :ivar table: The encryption function of the table storage service.
    :vartype table: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
    :ivar queue: The encryption function of the queue storage service.
    :vartype queue: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
    """

    _validation = {
        "table": {"readonly": True},
        "queue": {"readonly": True},
    }

    _attribute_map = {
        "blob": {"key": "blob", "type": "EncryptionService"},
        "file": {"key": "file", "type": "EncryptionService"},
        "table": {"key": "table", "type": "EncryptionService"},
        "queue": {"key": "queue", "type": "EncryptionService"},
    }

    def __init__(
        self,
        *,
        blob: Optional["_models.EncryptionService"] = None,
        file: Optional["_models.EncryptionService"] = None,
        **kwargs
    ):
        """
        :keyword blob: The encryption function of the blob storage service.
        :paramtype blob: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
        :keyword file: The encryption function of the file storage service.
        :paramtype file: ~azure.mgmt.storage.v2018_07_01.models.EncryptionService
        """
        super().__init__(**kwargs)
        self.blob = blob
        self.file = file
        self.table = None
        self.queue = None


class Endpoints(_serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        "blob": {"readonly": True},
        "queue": {"readonly": True},
        "table": {"readonly": True},
        "file": {"readonly": True},
        "web": {"readonly": True},
        "dfs": {"readonly": True},
    }

    _attribute_map = {
        "blob": {"key": "blob", "type": "str"},
        "queue": {"key": "queue", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "web": {"key": "web", "type": "str"},
        "dfs": {"key": "dfs", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None


class GeoReplicationStats(_serialization.Model):
    """Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the secondary location. Possible values are: - Live: Indicates that
     the secondary location is active and operational. - Bootstrap: Indicates initial
     synchronization from the primary location to the secondary location is in progress.This
     typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary
     location is temporarily unavailable. Known values are: "Live", "Bootstrap", and "Unavailable".
    :vartype status: str or ~azure.mgmt.storage.v2018_07_01.models.GeoReplicationStatus
    :ivar last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to
     be available for read operations. Primary writes following this point in time may or may not be
     available for reads. Element may be default value if value of LastSyncTime is not available,
     this can happen if secondary is offline or we are in bootstrap.
    :vartype last_sync_time: ~datetime.datetime
    :ivar can_failover: A boolean flag which indicates whether or not account failover is supported
     for the account.
    :vartype can_failover: bool
    """

    _validation = {
        "status": {"readonly": True},
        "last_sync_time": {"readonly": True},
        "can_failover": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "last_sync_time": {"key": "lastSyncTime", "type": "iso-8601"},
        "can_failover": {"key": "canFailover", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.last_sync_time = None
        self.can_failover = None


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Required. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "SystemAssigned"

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class ImmutabilityPolicy(AzureEntityResource):
    """The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days. Required.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Known values are: "Locked" and "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicyState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "immutability_period_since_creation_in_days": {"required": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "immutability_period_since_creation_in_days": {
            "key": "properties.immutabilityPeriodSinceCreationInDays",
            "type": "int",
        },
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(self, *, immutability_period_since_creation_in_days: int, **kwargs):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days. Required.
        :paramtype immutability_period_since_creation_in_days: int
        """
        super().__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None


class ImmutabilityPolicyProperties(_serialization.Model):
    """The properties of an ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar etag: ImmutabilityPolicy Etag.
    :vartype etag: str
    :ivar update_history: The ImmutabilityPolicy update history of the blob container.
    :vartype update_history: list[~azure.mgmt.storage.v2018_07_01.models.UpdateHistoryProperty]
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Known values are: "Locked" and "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicyState
    """

    _validation = {
        "etag": {"readonly": True},
        "update_history": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
        "update_history": {"key": "updateHistory", "type": "[UpdateHistoryProperty]"},
        "immutability_period_since_creation_in_days": {
            "key": "properties.immutabilityPeriodSinceCreationInDays",
            "type": "int",
        },
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(self, *, immutability_period_since_creation_in_days: Optional[int] = None, **kwargs):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        """
        super().__init__(**kwargs)
        self.etag = None
        self.update_history = None
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None


class IPRule(_serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
     allowed. Required.
    :vartype ip_address_or_range: str
    :ivar action: The action of IP ACL rule. Default value is "Allow".
    :vartype action: str
    """

    _validation = {
        "ip_address_or_range": {"required": True},
    }

    _attribute_map = {
        "ip_address_or_range": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, ip_address_or_range: str, action: Optional[Literal["Allow"]] = None, **kwargs):
        """
        :keyword ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
         allowed. Required.
        :paramtype ip_address_or_range: str
        :keyword action: The action of IP ACL rule. Default value is "Allow".
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range
        self.action = action


class KeyVaultProperties(_serialization.Model):
    """Properties of key vault.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    """

    _attribute_map = {
        "key_name": {"key": "keyname", "type": "str"},
        "key_version": {"key": "keyversion", "type": "str"},
        "key_vault_uri": {"key": "keyvaulturi", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri


class LeaseContainerRequest(_serialization.Model):
    """Lease Container request schema.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Specifies the lease action. Can be one of the available actions. Required. Known
     values are: "Acquire", "Renew", "Change", "Release", and "Break".
    :vartype action: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseContainerRequestAction
    :ivar lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :vartype lease_id: str
    :ivar break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :vartype break_period: int
    :ivar lease_duration: Required for acquire. Specifies the duration of the lease, in seconds, or
     negative one (-1) for a lease that never expires.
    :vartype lease_duration: int
    :ivar proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :vartype proposed_lease_id: str
    """

    _validation = {
        "action": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "lease_id": {"key": "leaseId", "type": "str"},
        "break_period": {"key": "breakPeriod", "type": "int"},
        "lease_duration": {"key": "leaseDuration", "type": "int"},
        "proposed_lease_id": {"key": "proposedLeaseId", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.LeaseContainerRequestAction"],
        lease_id: Optional[str] = None,
        break_period: Optional[int] = None,
        lease_duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action: Specifies the lease action. Can be one of the available actions. Required.
         Known values are: "Acquire", "Renew", "Change", "Release", and "Break".
        :paramtype action: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseContainerRequestAction
        :keyword lease_id: Identifies the lease. Can be specified in any valid GUID string format.
        :paramtype lease_id: str
        :keyword break_period: Optional. For a break action, proposed duration the lease should
         continue before it is broken, in seconds, between 0 and 60.
        :paramtype break_period: int
        :keyword lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
         or negative one (-1) for a lease that never expires.
        :paramtype lease_duration: int
        :keyword proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
         GUID string format.
        :paramtype proposed_lease_id: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.lease_id = lease_id
        self.break_period = break_period
        self.lease_duration = lease_duration
        self.proposed_lease_id = proposed_lease_id


class LeaseContainerResponse(_serialization.Model):
    """Lease Container response schema.

    :ivar lease_id: Returned unique lease ID that must be included with any request to delete the
     container, or to renew, change, or release the lease.
    :vartype lease_id: str
    :ivar lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :vartype lease_time_seconds: str
    """

    _attribute_map = {
        "lease_id": {"key": "leaseId", "type": "str"},
        "lease_time_seconds": {"key": "leaseTimeSeconds", "type": "str"},
    }

    def __init__(self, *, lease_id: Optional[str] = None, lease_time_seconds: Optional[str] = None, **kwargs):
        """
        :keyword lease_id: Returned unique lease ID that must be included with any request to delete
         the container, or to renew, change, or release the lease.
        :paramtype lease_id: str
        :keyword lease_time_seconds: Approximate time remaining in the lease period, in seconds.
        :paramtype lease_time_seconds: str
        """
        super().__init__(**kwargs)
        self.lease_id = lease_id
        self.lease_time_seconds = lease_time_seconds


class LegalHold(_serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case
     at SRP. Required.
    :vartype tags: list[str]
    """

    _validation = {
        "has_legal_hold": {"readonly": True},
        "tags": {"required": True},
    }

    _attribute_map = {
        "has_legal_hold": {"key": "hasLegalHold", "type": "bool"},
        "tags": {"key": "tags", "type": "[str]"},
    }

    def __init__(self, *, tags: List[str], **kwargs):
        """
        :keyword tags: Each tag should be 3 to 23 alphanumeric characters and is normalized to lower
         case at SRP. Required.
        :paramtype tags: list[str]
        """
        super().__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class LegalHoldProperties(_serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: The list of LegalHold tags of a blob container.
    :vartype tags: list[~azure.mgmt.storage.v2018_07_01.models.TagProperty]
    """

    _validation = {
        "has_legal_hold": {"readonly": True},
    }

    _attribute_map = {
        "has_legal_hold": {"key": "hasLegalHold", "type": "bool"},
        "tags": {"key": "tags", "type": "[TagProperty]"},
    }

    def __init__(self, *, tags: Optional[List["_models.TagProperty"]] = None, **kwargs):
        """
        :keyword tags: The list of LegalHold tags of a blob container.
        :paramtype tags: list[~azure.mgmt.storage.v2018_07_01.models.TagProperty]
        """
        super().__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags


class ListAccountSasResponse(_serialization.Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        "account_sas_token": {"readonly": True},
    }

    _attribute_map = {
        "account_sas_token": {"key": "accountSasToken", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.account_sas_token = None


class ListContainerItem(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """The blob container properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Known values are: "Container", "Blob", and "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2018_07_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Known values are: "Locked" and
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2018_07_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2018_07_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "immutability_policy": {"readonly": True},
        "legal_hold": {"readonly": True},
        "has_legal_hold": {"readonly": True},
        "has_immutability_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_access": {"key": "properties.publicAccess", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "immutability_policy": {"key": "properties.immutabilityPolicy", "type": "ImmutabilityPolicyProperties"},
        "legal_hold": {"key": "properties.legalHold", "type": "LegalHoldProperties"},
        "has_legal_hold": {"key": "properties.hasLegalHold", "type": "bool"},
        "has_immutability_policy": {"key": "properties.hasImmutabilityPolicy", "type": "bool"},
    }

    def __init__(
        self,
        *,
        public_access: Optional[Union[str, "_models.PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Known values are: "Container", "Blob", and "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2018_07_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        """
        super().__init__(**kwargs)
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None


class ListContainerItems(_serialization.Model):
    """The list of blob containers.

    :ivar value: The list of blob containers.
    :vartype value: list[~azure.mgmt.storage.v2018_07_01.models.ListContainerItem]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ListContainerItem]"},
    }

    def __init__(self, *, value: Optional[List["_models.ListContainerItem"]] = None, **kwargs):
        """
        :keyword value: The list of blob containers.
        :paramtype value: list[~azure.mgmt.storage.v2018_07_01.models.ListContainerItem]
        """
        super().__init__(**kwargs)
        self.value = value


class ListServiceSasResponse(_serialization.Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_sas_token: List service SAS credentials of specific resource.
    :vartype service_sas_token: str
    """

    _validation = {
        "service_sas_token": {"readonly": True},
    }

    _attribute_map = {
        "service_sas_token": {"key": "serviceSasToken", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.service_sas_token = None


class ManagementPoliciesRules(_serialization.Model):
    """The Storage Account ManagementPolicies Rules, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    :ivar policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
     in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: JSON
    """

    _attribute_map = {
        "policy": {"key": "policy", "type": "object"},
    }

    def __init__(self, *, policy: Optional[JSON] = None, **kwargs):
        """
        :keyword policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
         in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: JSON
        """
        super().__init__(**kwargs)
        self.policy = policy


class ManagementPoliciesRulesSetParameter(_serialization.Model):
    """The Storage Account ManagementPolicies Rules, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    :ivar policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
     in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: JSON
    """

    _attribute_map = {
        "policy": {"key": "properties.policy", "type": "object"},
    }

    def __init__(self, *, policy: Optional[JSON] = None, **kwargs):
        """
        :keyword policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
         in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: JSON
        """
        super().__init__(**kwargs)
        self.policy = policy


class MetricSpecification(_serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.storage.v2018_07_01.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "category": {"key": "category", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: Unit could be Bytes or Count.
        :paramtype unit: str
        :keyword dimensions: Dimensions of blobs, including blob type and access tier.
        :paramtype dimensions: list[~azure.mgmt.storage.v2018_07_01.models.Dimension]
        :keyword aggregation_type: Aggregation type could be Average.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: The property to decide fill gap with zero or not.
        :paramtype fill_gap_with_zero: bool
        :keyword category: The category this metric specification belong to, could be Capacity.
        :paramtype category: str
        :keyword resource_id_dimension_name_override: Account Resource Id.
        :paramtype resource_id_dimension_name_override: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NetworkRuleSet(_serialization.Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible
     values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"),
     or None to bypass none of those traffics. Known values are: "None", "Logging", "Metrics", and
     "AzureServices".
    :vartype bypass: str or ~azure.mgmt.storage.v2018_07_01.models.Bypass
    :ivar virtual_network_rules: Sets the virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.storage.v2018_07_01.models.VirtualNetworkRule]
    :ivar ip_rules: Sets the IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.storage.v2018_07_01.models.IPRule]
    :ivar default_action: Specifies the default action of allow or deny when no other rules match.
     Known values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.storage.v2018_07_01.models.DefaultAction
    """

    _validation = {
        "default_action": {"required": True},
    }

    _attribute_map = {
        "bypass": {"key": "bypass", "type": "str"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
        "default_action": {"key": "defaultAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "_models.DefaultAction"] = "Allow",
        bypass: Union[str, "_models.Bypass"] = "AzureServices",
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        ip_rules: Optional[List["_models.IPRule"]] = None,
        **kwargs
    ):
        """
        :keyword bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices.
         Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging,
         Metrics"), or None to bypass none of those traffics. Known values are: "None", "Logging",
         "Metrics", and "AzureServices".
        :paramtype bypass: str or ~azure.mgmt.storage.v2018_07_01.models.Bypass
        :keyword virtual_network_rules: Sets the virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.storage.v2018_07_01.models.VirtualNetworkRule]
        :keyword ip_rules: Sets the IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.storage.v2018_07_01.models.IPRule]
        :keyword default_action: Specifies the default action of allow or deny when no other rules
         match. Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.storage.v2018_07_01.models.DefaultAction
        """
        super().__init__(**kwargs)
        self.bypass = bypass
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action


class Operation(_serialization.Model):
    """Storage REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.storage.v2018_07_01.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.storage.v2018_07_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.storage.v2018_07_01.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.storage.v2018_07_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Storage.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft Storage.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.storage.v2018_07_01.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.storage.v2018_07_01.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class Restriction(_serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
     subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
     capacity at DC. Known values are: "QuotaId" and "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storage.v2018_07_01.models.ReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, *, reason_code: Optional[Union[str, "_models.ReasonCode"]] = None, **kwargs):
        """
        :keyword reason_code: The reason for the restriction. As of now this can be "QuotaId" or
         "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
         subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
         capacity at DC. Known values are: "QuotaId" and "NotAvailableForSubscription".
        :paramtype reason_code: str or ~azure.mgmt.storage.v2018_07_01.models.ReasonCode
        """
        super().__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class ServiceSasParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :ivar canonicalized_resource: The canonical path to the signed resource. Required.
    :vartype canonicalized_resource: str
    :ivar resource: The signed services accessible with the service SAS. Possible values include:
     Blob (b), Container (c), File (f), Share (s). Known values are: "b", "c", "f", and "s".
    :vartype resource: str or ~azure.mgmt.storage.v2018_07_01.models.SignedResource
    :ivar permissions: The signed permissions for the service SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Known
     values are: "r", "d", "w", "l", "a", "c", "u", and "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2018_07_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Known values
     are: "https,http" and "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2018_07_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar identifier: A unique value up to 64 characters in length that correlates to an access
     policy specified for the container, queue, or table.
    :vartype identifier: str
    :ivar partition_key_start: The start of partition key.
    :vartype partition_key_start: str
    :ivar partition_key_end: The end of partition key.
    :vartype partition_key_end: str
    :ivar row_key_start: The start of row key.
    :vartype row_key_start: str
    :ivar row_key_end: The end of row key.
    :vartype row_key_end: str
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    :ivar cache_control: The response header override for cache control.
    :vartype cache_control: str
    :ivar content_disposition: The response header override for content disposition.
    :vartype content_disposition: str
    :ivar content_encoding: The response header override for content encoding.
    :vartype content_encoding: str
    :ivar content_language: The response header override for content language.
    :vartype content_language: str
    :ivar content_type: The response header override for content type.
    :vartype content_type: str
    """

    _validation = {
        "canonicalized_resource": {"required": True},
        "identifier": {"max_length": 64},
    }

    _attribute_map = {
        "canonicalized_resource": {"key": "canonicalizedResource", "type": "str"},
        "resource": {"key": "signedResource", "type": "str"},
        "permissions": {"key": "signedPermission", "type": "str"},
        "ip_address_or_range": {"key": "signedIp", "type": "str"},
        "protocols": {"key": "signedProtocol", "type": "str"},
        "shared_access_start_time": {"key": "signedStart", "type": "iso-8601"},
        "shared_access_expiry_time": {"key": "signedExpiry", "type": "iso-8601"},
        "identifier": {"key": "signedIdentifier", "type": "str"},
        "partition_key_start": {"key": "startPk", "type": "str"},
        "partition_key_end": {"key": "endPk", "type": "str"},
        "row_key_start": {"key": "startRk", "type": "str"},
        "row_key_end": {"key": "endRk", "type": "str"},
        "key_to_sign": {"key": "keyToSign", "type": "str"},
        "cache_control": {"key": "rscc", "type": "str"},
        "content_disposition": {"key": "rscd", "type": "str"},
        "content_encoding": {"key": "rsce", "type": "str"},
        "content_language": {"key": "rscl", "type": "str"},
        "content_type": {"key": "rsct", "type": "str"},
    }

    def __init__(
        self,
        *,
        canonicalized_resource: str,
        resource: Optional[Union[str, "_models.SignedResource"]] = None,
        permissions: Optional[Union[str, "_models.Permissions"]] = None,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "_models.HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        shared_access_expiry_time: Optional[datetime.datetime] = None,
        identifier: Optional[str] = None,
        partition_key_start: Optional[str] = None,
        partition_key_end: Optional[str] = None,
        row_key_start: Optional[str] = None,
        row_key_end: Optional[str] = None,
        key_to_sign: Optional[str] = None,
        cache_control: Optional[str] = None,
        content_disposition: Optional[str] = None,
        content_encoding: Optional[str] = None,
        content_language: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword canonicalized_resource: The canonical path to the signed resource. Required.
        :paramtype canonicalized_resource: str
        :keyword resource: The signed services accessible with the service SAS. Possible values
         include: Blob (b), Container (c), File (f), Share (s). Known values are: "b", "c", "f", and
         "s".
        :paramtype resource: str or ~azure.mgmt.storage.v2018_07_01.models.SignedResource
        :keyword permissions: The signed permissions for the service SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Known
         values are: "r", "d", "w", "l", "a", "c", "u", and "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2018_07_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Known
         values are: "https,http" and "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2018_07_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword identifier: A unique value up to 64 characters in length that correlates to an access
         policy specified for the container, queue, or table.
        :paramtype identifier: str
        :keyword partition_key_start: The start of partition key.
        :paramtype partition_key_start: str
        :keyword partition_key_end: The end of partition key.
        :paramtype partition_key_end: str
        :keyword row_key_start: The start of row key.
        :paramtype row_key_start: str
        :keyword row_key_end: The end of row key.
        :paramtype row_key_end: str
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        :keyword cache_control: The response header override for cache control.
        :paramtype cache_control: str
        :keyword content_disposition: The response header override for content disposition.
        :paramtype content_disposition: str
        :keyword content_encoding: The response header override for content encoding.
        :paramtype content_encoding: str
        :keyword content_language: The response header override for content language.
        :paramtype content_language: str
        :keyword content_type: The response header override for content type.
        :paramtype content_type: str
        """
        super().__init__(**kwargs)
        self.canonicalized_resource = canonicalized_resource
        self.resource = resource
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.identifier = identifier
        self.partition_key_start = partition_key_start
        self.partition_key_end = partition_key_end
        self.row_key_start = row_key_start
        self.row_key_end = row_key_end
        self.key_to_sign = key_to_sign
        self.cache_control = cache_control
        self.content_disposition = content_disposition
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_type = content_type


class ServiceSpecification(_serialization.Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.storage.v2018_07_01.models.MetricSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(self, *, metric_specifications: Optional[List["_models.MetricSpecification"]] = None, **kwargs):
        """
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.storage.v2018_07_01.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Sku(_serialization.Model):
    """The SKU of the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Gets or sets the SKU name. Required for account creation; optional for update. Note
     that in older versions, SKU name was called accountType. Required. Known values are:
     "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", and
     "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.storage.v2018_07_01.models.SkuName
    :ivar tier: Gets the SKU tier. This is based on the SKU name. Known values are: "Standard" and
     "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2018_07_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is 'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Known values are: "Storage", "StorageV2",
     "BlobStorage", "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified SKU, including file encryption,
     network ACLs, change notification, etc.
    :vartype capabilities: list[~azure.mgmt.storage.v2018_07_01.models.SKUCapability]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storage.v2018_07_01.models.Restriction]
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
        "resource_type": {"readonly": True},
        "kind": {"readonly": True},
        "locations": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[SKUCapability]"},
        "restrictions": {"key": "restrictions", "type": "[Restriction]"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        restrictions: Optional[List["_models.Restriction"]] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets the SKU name. Required for account creation; optional for update.
         Note that in older versions, SKU name was called accountType. Required. Known values are:
         "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", and
         "Premium_ZRS".
        :paramtype name: str or ~azure.mgmt.storage.v2018_07_01.models.SkuName
        :keyword restrictions: The restrictions because of which SKU cannot be used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.storage.v2018_07_01.models.Restriction]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = restrictions


class SKUCapability(_serialization.Model):
    """The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability, The capability information in the specified SKU, including
     file encryption, network ACLs, change notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageAccount(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2018_07_01.models.Sku
    :ivar kind: Gets the Kind. Known values are: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
    :ivar provisioning_state: Gets the status of the storage account at the time the operation was
     called. Known values are: "Creating", "ResolvingDNS", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.storage.v2018_07_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob
     endpoint.
    :vartype primary_endpoints: ~azure.mgmt.storage.v2018_07_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary location of the storage
     account is available or unavailable. Known values are: "available" and "unavailable".
    :vartype status_of_primary: str or ~azure.mgmt.storage.v2018_07_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent instance of a failover to
     the secondary location. Only the most recent timestamp is retained. This element is not
     returned if there has never been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: ~datetime.datetime
    :ivar secondary_location: Gets the location of the geo-replicated secondary for the storage
     account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the secondary location of the
     storage account is available or unavailable. Only available if the SKU name is Standard_GRS or
     Standard_RAGRS. Known values are: "available" and "unavailable".
    :vartype status_of_secondary: str or ~azure.mgmt.storage.v2018_07_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage account in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this storage account.
    :vartype custom_domain: ~azure.mgmt.storage.v2018_07_01.models.CustomDomain
    :ivar secondary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object from the secondary location of the storage account. Only available if
     the SKU name is Standard_RAGRS.
    :vartype secondary_endpoints: ~azure.mgmt.storage.v2018_07_01.models.Endpoints
    :ivar encryption: Gets the encryption settings on the account. If unspecified, the account is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2018_07_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Known values are: "Hot" and "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2018_07_01.models.AccessTier
    :ivar enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if sets
     to true.
    :vartype enable_azure_files_aad_integration: bool
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2018_07_01.models.NetworkRuleSet
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    :ivar geo_replication_stats: Geo Replication Stats.
    :vartype geo_replication_stats: ~azure.mgmt.storage.v2018_07_01.models.GeoReplicationStats
    :ivar failover_in_progress: If the failover is in progress, the value will be true, otherwise,
     it will be null.
    :vartype failover_in_progress: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"readonly": True},
        "kind": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "primary_endpoints": {"readonly": True},
        "primary_location": {"readonly": True},
        "status_of_primary": {"readonly": True},
        "last_geo_failover_time": {"readonly": True},
        "secondary_location": {"readonly": True},
        "status_of_secondary": {"readonly": True},
        "creation_time": {"readonly": True},
        "custom_domain": {"readonly": True},
        "secondary_endpoints": {"readonly": True},
        "encryption": {"readonly": True},
        "access_tier": {"readonly": True},
        "network_rule_set": {"readonly": True},
        "geo_replication_stats": {"readonly": True},
        "failover_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "primary_endpoints": {"key": "properties.primaryEndpoints", "type": "Endpoints"},
        "primary_location": {"key": "properties.primaryLocation", "type": "str"},
        "status_of_primary": {"key": "properties.statusOfPrimary", "type": "str"},
        "last_geo_failover_time": {"key": "properties.lastGeoFailoverTime", "type": "iso-8601"},
        "secondary_location": {"key": "properties.secondaryLocation", "type": "str"},
        "status_of_secondary": {"key": "properties.statusOfSecondary", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "secondary_endpoints": {"key": "properties.secondaryEndpoints", "type": "Endpoints"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "enable_azure_files_aad_integration": {"key": "properties.azureFilesAadIntegration", "type": "bool"},
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
        "is_hns_enabled": {"key": "properties.isHnsEnabled", "type": "bool"},
        "geo_replication_stats": {"key": "properties.geoReplicationStats", "type": "GeoReplicationStats"},
        "failover_in_progress": {"key": "properties.failoverInProgress", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        enable_azure_files_aad_integration: Optional[bool] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
        :keyword enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if
         sets to true.
        :paramtype enable_azure_files_aad_integration: bool
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = None
        self.kind = None
        self.identity = identity
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.enable_azure_files_aad_integration = enable_azure_files_aad_integration
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = None
        self.is_hns_enabled = is_hns_enabled
        self.geo_replication_stats = None
        self.failover_in_progress = None


class StorageAccountCheckNameAvailabilityParameters(_serialization.Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The storage account name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.Storage/storageAccounts. Required. Default value is
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(self, *, name: str, **kwargs):
        """
        :keyword name: The storage account name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class StorageAccountCreateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar sku: Required. Gets or sets the SKU name. Required.
    :vartype sku: ~azure.mgmt.storage.v2018_07_01.models.Sku
    :ivar kind: Required. Indicates the type of storage account. Required. Known values are:
     "Storage", "StorageV2", "BlobStorage", "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
    :ivar location: Required. Gets or sets the location of the resource. This will be one of the
     supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The
     geo region of a resource cannot be changed once it is created, but if an identical geo region
     is specified on update, the request will succeed. Required.
    :vartype location: str
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key with a length no greater than 128
     characters and a value with a length no greater than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
    :ivar custom_domain: User domain assigned to the storage account. Name is the CNAME source.
     Only one custom domain is supported per storage account at this time. To clear the existing
     custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2018_07_01.models.CustomDomain
    :ivar encryption: Provides the encryption settings on the account. If left unspecified the
     account encryption settings will remain the same. The default setting is unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2018_07_01.models.Encryption
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2018_07_01.models.NetworkRuleSet
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Known values are: "Hot" and "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2018_07_01.models.AccessTier
    :ivar enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if sets
     to true.
    :vartype enable_azure_files_aad_integration: bool
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    """

    _validation = {
        "sku": {"required": True},
        "kind": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "enable_azure_files_aad_integration": {"key": "properties.azureFilesAadIntegration", "type": "bool"},
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "is_hns_enabled": {"key": "properties.isHnsEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        kind: Union[str, "_models.Kind"],
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        custom_domain: Optional["_models.CustomDomain"] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        access_tier: Optional[Union[str, "_models.AccessTier"]] = None,
        enable_azure_files_aad_integration: Optional[bool] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword sku: Required. Gets or sets the SKU name. Required.
        :paramtype sku: ~azure.mgmt.storage.v2018_07_01.models.Sku
        :keyword kind: Required. Indicates the type of storage account. Required. Known values are:
         "Storage", "StorageV2", "BlobStorage", "FileStorage", and "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
        :keyword location: Required. Gets or sets the location of the resource. This will be one of the
         supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The
         geo region of a resource cannot be changed once it is created, but if an identical geo region
         is specified on update, the request will succeed. Required.
        :paramtype location: str
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used for viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key with a length no greater than 128
         characters and a value with a length no greater than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
        :keyword custom_domain: User domain assigned to the storage account. Name is the CNAME source.
         Only one custom domain is supported per storage account at this time. To clear the existing
         custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2018_07_01.models.CustomDomain
        :keyword encryption: Provides the encryption settings on the account. If left unspecified the
         account encryption settings will remain the same. The default setting is unencrypted.
        :paramtype encryption: ~azure.mgmt.storage.v2018_07_01.models.Encryption
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2018_07_01.models.NetworkRuleSet
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Known values are: "Hot" and "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2018_07_01.models.AccessTier
        :keyword enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if
         sets to true.
        :paramtype enable_azure_files_aad_integration: bool
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.tags = tags
        self.identity = identity
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.network_rule_set = network_rule_set
        self.access_tier = access_tier
        self.enable_azure_files_aad_integration = enable_azure_files_aad_integration
        self.enable_https_traffic_only = enable_https_traffic_only
        self.is_hns_enabled = is_hns_enabled


class StorageAccountKey(_serialization.Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full permissions. Known values are:
     "Read" and "Full".
    :vartype permissions: str or ~azure.mgmt.storage.v2018_07_01.models.KeyPermission
    """

    _validation = {
        "key_name": {"readonly": True},
        "value": {"readonly": True},
        "permissions": {"readonly": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "permissions": {"key": "permissions", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None


class StorageAccountListKeysResult(_serialization.Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for the specified
     storage account.
    :vartype keys: list[~azure.mgmt.storage.v2018_07_01.models.StorageAccountKey]
    """

    _validation = {
        "keys": {"readonly": True},
    }

    _attribute_map = {
        "keys": {"key": "keys", "type": "[StorageAccountKey]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.keys = None


class StorageAccountListResult(_serialization.Model):
    """The response from the List Storage Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2018_07_01.models.StorageAccount]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccount]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class StorageAccountManagementPolicies(Resource):
    """The Get Storage Account ManagementPolicies operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
     in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: JSON
    :ivar last_modified_time: Returns the date and time the ManagementPolicies was last modified.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "policy": {"key": "properties.policy", "type": "object"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, *, policy: Optional[JSON] = None, **kwargs):
        """
        :keyword policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
         in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: JSON
        """
        super().__init__(**kwargs)
        self.policy = policy
        self.last_modified_time = None


class StorageAccountManagementPoliciesRulesProperty(ManagementPoliciesRules):
    """The Storage Account Data Policies properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
     in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: JSON
    :ivar last_modified_time: Returns the date and time the ManagementPolicies was last modified.
    :vartype last_modified_time: ~datetime.datetime
    """

    _validation = {
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "policy": {"key": "policy", "type": "object"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(self, *, policy: Optional[JSON] = None, **kwargs):
        """
        :keyword policy: The Storage Account ManagementPolicies Rules, in JSON format. See more details
         in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: JSON
        """
        super().__init__(policy=policy, **kwargs)
        self.last_modified_time = None


class StorageAccountRegenerateKeyParameters(_serialization.Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: The name of storage keys that want to be regenerated, possible values are key1,
     key2. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs):
        """
        :keyword key_name: The name of storage keys that want to be regenerated, possible values are
         key1, key2. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(_serialization.Model):
    """The parameters that can be provided when updating the storage account properties.

    :ivar sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS,
     Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any other value.
    :vartype sku: ~azure.mgmt.storage.v2018_07_01.models.Sku
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
    :ivar kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
     supported by server. Known values are: "Storage", "StorageV2", "BlobStorage", "FileStorage",
     and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
    :ivar custom_domain: Custom domain assigned to the storage account by the user. Name is the
     CNAME source. Only one custom domain is supported per storage account at this time. To clear
     the existing custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2018_07_01.models.CustomDomain
    :ivar encryption: Provides the encryption settings on the account. The default setting is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2018_07_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Known values are: "Hot" and "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2018_07_01.models.AccessTier
    :ivar enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if sets
     to true.
    :vartype enable_azure_files_aad_integration: bool
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2018_07_01.models.NetworkRuleSet
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "kind": {"key": "kind", "type": "str"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "enable_azure_files_aad_integration": {"key": "properties.azureFilesAadIntegration", "type": "bool"},
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        custom_domain: Optional["_models.CustomDomain"] = None,
        encryption: Optional["_models.Encryption"] = None,
        access_tier: Optional[Union[str, "_models.AccessTier"]] = None,
        enable_azure_files_aad_integration: Optional[bool] = None,
        enable_https_traffic_only: Optional[bool] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        **kwargs
    ):
        """
        :keyword sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to
         Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any
         other value.
        :paramtype sku: ~azure.mgmt.storage.v2018_07_01.models.Sku
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used in viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key no greater in length than 128
         characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2018_07_01.models.Identity
        :keyword kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
         supported by server. Known values are: "Storage", "StorageV2", "BlobStorage", "FileStorage",
         and "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2018_07_01.models.Kind
        :keyword custom_domain: Custom domain assigned to the storage account by the user. Name is the
         CNAME source. Only one custom domain is supported per storage account at this time. To clear
         the existing custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2018_07_01.models.CustomDomain
        :keyword encryption: Provides the encryption settings on the account. The default setting is
         unencrypted.
        :paramtype encryption: ~azure.mgmt.storage.v2018_07_01.models.Encryption
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         used for billing. Known values are: "Hot" and "Cool".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2018_07_01.models.AccessTier
        :keyword enable_azure_files_aad_integration: Enables Azure Files AAD Integration for SMB if
         sets to true.
        :paramtype enable_azure_files_aad_integration: bool
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2018_07_01.models.NetworkRuleSet
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.identity = identity
        self.kind = kind
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.access_tier = access_tier
        self.enable_azure_files_aad_integration = enable_azure_files_aad_integration
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = network_rule_set


class StorageSkuListResult(_serialization.Model):
    """The response from the List Storage SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Get the list result of storage SKUs and their properties.
    :vartype value: list[~azure.mgmt.storage.v2018_07_01.models.Sku]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Sku]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class TagProperty(_serialization.Model):
    """A tag of the LegalHold of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tag: The tag value.
    :vartype tag: str
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who added the tag.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who added the tag.
    :vartype upn: str
    """

    _validation = {
        "tag": {"readonly": True},
        "timestamp": {"readonly": True},
        "object_identifier": {"readonly": True},
        "tenant_id": {"readonly": True},
        "upn": {"readonly": True},
    }

    _attribute_map = {
        "tag": {"key": "tag", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "object_identifier": {"key": "objectIdentifier", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.tag = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class UpdateHistoryProperty(_serialization.Model):
    """An update history of the ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar update: The ImmutabilityPolicy update type of a blob container, possible values include:
     put, lock and extend. Known values are: "put", "lock", and "extend".
    :vartype update: str or ~azure.mgmt.storage.v2018_07_01.models.ImmutabilityPolicyUpdateType
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar timestamp: Returns the date and time the ImmutabilityPolicy was updated.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who updated the
     ImmutabilityPolicy.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
    :vartype upn: str
    """

    _validation = {
        "update": {"readonly": True},
        "immutability_period_since_creation_in_days": {"readonly": True},
        "timestamp": {"readonly": True},
        "object_identifier": {"readonly": True},
        "tenant_id": {"readonly": True},
        "upn": {"readonly": True},
    }

    _attribute_map = {
        "update": {"key": "update", "type": "str"},
        "immutability_period_since_creation_in_days": {"key": "immutabilityPeriodSinceCreationInDays", "type": "int"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "object_identifier": {"key": "objectIdentifier", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.update = None
        self.immutability_period_since_creation_in_days = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class Usage(_serialization.Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Known values are: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", and "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.storage.v2018_07_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2018_07_01.models.UsageName
    """

    _validation = {
        "unit": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(_serialization.Model):
    """The response from the List Usages operation.

    :ivar value: Gets or sets the list of Storage Resource Usages.
    :vartype value: list[~azure.mgmt.storage.v2018_07_01.models.Usage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, **kwargs):
        """
        :keyword value: Gets or sets the list of Storage Resource Usages.
        :paramtype value: list[~azure.mgmt.storage.v2018_07_01.models.Usage]
        """
        super().__init__(**kwargs)
        self.value = value


class UsageName(_serialization.Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.localized_value = None


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_resource_id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     Required.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. Default value is "Allow".
    :vartype action: str
    :ivar state: Gets the state of virtual network rule. Known values are: "provisioning",
     "deprovisioning", "succeeded", "failed", and "networkSourceDeleted".
    :vartype state: str or ~azure.mgmt.storage.v2018_07_01.models.State
    """

    _validation = {
        "virtual_network_resource_id": {"required": True},
    }

    _attribute_map = {
        "virtual_network_resource_id": {"key": "id", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[Literal["Allow"]] = None,
        state: Optional[Union[str, "_models.State"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_resource_id: Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
         Required.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. Default value is "Allow".
        :paramtype action: str
        :keyword state: Gets the state of virtual network rule. Known values are: "provisioning",
         "deprovisioning", "succeeded", "failed", and "networkSourceDeleted".
        :paramtype state: str or ~azure.mgmt.storage.v2018_07_01.models.State
        """
        super().__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = state
