# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessPolicy(_serialization.Model):
    """AccessPolicy.

    :ivar start_time: Start time of the access policy.
    :vartype start_time: ~datetime.datetime
    :ivar expiry_time: Expiry time of the access policy.
    :vartype expiry_time: ~datetime.datetime
    :ivar permission: List of abbreviated permissions.
    :vartype permission: str
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "permission": {"key": "permission", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        expiry_time: Optional[datetime.datetime] = None,
        permission: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time of the access policy.
        :paramtype start_time: ~datetime.datetime
        :keyword expiry_time: Expiry time of the access policy.
        :paramtype expiry_time: ~datetime.datetime
        :keyword permission: List of abbreviated permissions.
        :paramtype permission: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.expiry_time = expiry_time
        self.permission = permission


class AccountImmutabilityPolicyProperties(_serialization.Model):
    """This defines account-level immutability policy properties.

    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state defines the mode of the policy. Disabled state
     disables the policy, Unlocked state allows increase and decrease of immutability retention time
     and also allows toggling allowProtectedAppendWrites property, Locked state only allows the
     increase of the immutability retention time. A policy can only be created in a Disabled or
     Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state
     can transition to a Locked state which cannot be reverted. Known values are: "Unlocked",
     "Locked", and "Disabled".
    :vartype state: str or ~azure.mgmt.storage.v2022_09_01.models.AccountImmutabilityPolicyState
    :ivar allow_protected_append_writes: This property can only be changed for disabled and
     unlocked time-based retention policies. When enabled, new blocks can be written to an append
     blob while maintaining immutability protection and compliance. Only new blocks can be added and
     any existing blocks cannot be modified or deleted.
    :vartype allow_protected_append_writes: bool
    """

    _validation = {
        "immutability_period_since_creation_in_days": {"maximum": 146000, "minimum": 1},
    }

    _attribute_map = {
        "immutability_period_since_creation_in_days": {"key": "immutabilityPeriodSinceCreationInDays", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "allow_protected_append_writes": {"key": "allowProtectedAppendWrites", "type": "bool"},
    }

    def __init__(
        self,
        *,
        immutability_period_since_creation_in_days: Optional[int] = None,
        state: Optional[Union[str, "_models.AccountImmutabilityPolicyState"]] = None,
        allow_protected_append_writes: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        :keyword state: The ImmutabilityPolicy state defines the mode of the policy. Disabled state
         disables the policy, Unlocked state allows increase and decrease of immutability retention time
         and also allows toggling allowProtectedAppendWrites property, Locked state only allows the
         increase of the immutability retention time. A policy can only be created in a Disabled or
         Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state
         can transition to a Locked state which cannot be reverted. Known values are: "Unlocked",
         "Locked", and "Disabled".
        :paramtype state: str or ~azure.mgmt.storage.v2022_09_01.models.AccountImmutabilityPolicyState
        :keyword allow_protected_append_writes: This property can only be changed for disabled and
         unlocked time-based retention policies. When enabled, new blocks can be written to an append
         blob while maintaining immutability protection and compliance. Only new blocks can be added and
         any existing blocks cannot be modified or deleted.
        :paramtype allow_protected_append_writes: bool
        """
        super().__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = state
        self.allow_protected_append_writes = allow_protected_append_writes


class AccountSasParameters(_serialization.Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar services: The signed services accessible with the account SAS. Possible values include:
     Blob (b), Queue (q), Table (t), File (f). Required. Known values are: "b", "q", "t", and "f".
    :vartype services: str or ~azure.mgmt.storage.v2022_09_01.models.Services
    :ivar resource_types: The signed resource types that are accessible with the account SAS.
     Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
     Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     Required. Known values are: "s", "c", and "o".
    :vartype resource_types: str or ~azure.mgmt.storage.v2022_09_01.models.SignedResourceTypes
    :ivar permissions: The signed permissions for the account SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     Required. Known values are: "r", "d", "w", "l", "a", "c", "u", and "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2022_09_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Known values
     are: "https,http" and "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2022_09_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
     Required.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    """

    _validation = {
        "services": {"required": True},
        "resource_types": {"required": True},
        "permissions": {"required": True},
        "shared_access_expiry_time": {"required": True},
    }

    _attribute_map = {
        "services": {"key": "signedServices", "type": "str"},
        "resource_types": {"key": "signedResourceTypes", "type": "str"},
        "permissions": {"key": "signedPermission", "type": "str"},
        "ip_address_or_range": {"key": "signedIp", "type": "str"},
        "protocols": {"key": "signedProtocol", "type": "str"},
        "shared_access_start_time": {"key": "signedStart", "type": "iso-8601"},
        "shared_access_expiry_time": {"key": "signedExpiry", "type": "iso-8601"},
        "key_to_sign": {"key": "keyToSign", "type": "str"},
    }

    def __init__(
        self,
        *,
        services: Union[str, "_models.Services"],
        resource_types: Union[str, "_models.SignedResourceTypes"],
        permissions: Union[str, "_models.Permissions"],
        shared_access_expiry_time: datetime.datetime,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "_models.HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        key_to_sign: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword services: The signed services accessible with the account SAS. Possible values
         include: Blob (b), Queue (q), Table (t), File (f). Required. Known values are: "b", "q", "t",
         and "f".
        :paramtype services: str or ~azure.mgmt.storage.v2022_09_01.models.Services
        :keyword resource_types: The signed resource types that are accessible with the account SAS.
         Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
         Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
         Required. Known values are: "s", "c", and "o".
        :paramtype resource_types: str or ~azure.mgmt.storage.v2022_09_01.models.SignedResourceTypes
        :keyword permissions: The signed permissions for the account SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
         Required. Known values are: "r", "d", "w", "l", "a", "c", "u", and "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2022_09_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Known
         values are: "https,http" and "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2022_09_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid. Required.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        """
        super().__init__(**kwargs)
        self.services = services
        self.resource_types = resource_types
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.key_to_sign = key_to_sign


class ActiveDirectoryProperties(_serialization.Model):
    """Settings properties for Active Directory (AD).

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
     Required.
    :vartype domain_name: str
    :ivar net_bios_domain_name: Specifies the NetBIOS domain name.
    :vartype net_bios_domain_name: str
    :ivar forest_name: Specifies the Active Directory forest to get.
    :vartype forest_name: str
    :ivar domain_guid: Specifies the domain GUID. Required.
    :vartype domain_guid: str
    :ivar domain_sid: Specifies the security identifier (SID).
    :vartype domain_sid: str
    :ivar azure_storage_sid: Specifies the security identifier (SID) for Azure Storage.
    :vartype azure_storage_sid: str
    :ivar sam_account_name: Specifies the Active Directory SAMAccountName for Azure Storage.
    :vartype sam_account_name: str
    :ivar account_type: Specifies the Active Directory account type for Azure Storage. Known values
     are: "User" and "Computer".
    :vartype account_type: str or ~azure.mgmt.storage.v2022_09_01.models.AccountType
    """

    _validation = {
        "domain_name": {"required": True},
        "domain_guid": {"required": True},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "net_bios_domain_name": {"key": "netBiosDomainName", "type": "str"},
        "forest_name": {"key": "forestName", "type": "str"},
        "domain_guid": {"key": "domainGuid", "type": "str"},
        "domain_sid": {"key": "domainSid", "type": "str"},
        "azure_storage_sid": {"key": "azureStorageSid", "type": "str"},
        "sam_account_name": {"key": "samAccountName", "type": "str"},
        "account_type": {"key": "accountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        domain_guid: str,
        net_bios_domain_name: Optional[str] = None,
        forest_name: Optional[str] = None,
        domain_sid: Optional[str] = None,
        azure_storage_sid: Optional[str] = None,
        sam_account_name: Optional[str] = None,
        account_type: Optional[Union[str, "_models.AccountType"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
         Required.
        :paramtype domain_name: str
        :keyword net_bios_domain_name: Specifies the NetBIOS domain name.
        :paramtype net_bios_domain_name: str
        :keyword forest_name: Specifies the Active Directory forest to get.
        :paramtype forest_name: str
        :keyword domain_guid: Specifies the domain GUID. Required.
        :paramtype domain_guid: str
        :keyword domain_sid: Specifies the security identifier (SID).
        :paramtype domain_sid: str
        :keyword azure_storage_sid: Specifies the security identifier (SID) for Azure Storage.
        :paramtype azure_storage_sid: str
        :keyword sam_account_name: Specifies the Active Directory SAMAccountName for Azure Storage.
        :paramtype sam_account_name: str
        :keyword account_type: Specifies the Active Directory account type for Azure Storage. Known
         values are: "User" and "Computer".
        :paramtype account_type: str or ~azure.mgmt.storage.v2022_09_01.models.AccountType
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.net_bios_domain_name = net_bios_domain_name
        self.forest_name = forest_name
        self.domain_guid = domain_guid
        self.domain_sid = domain_sid
        self.azure_storage_sid = azure_storage_sid
        self.sam_account_name = sam_account_name
        self.account_type = account_type


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.etag = None


class AzureFilesIdentityBasedAuthentication(_serialization.Model):
    """Settings for Azure Files identity based authentication.

    All required parameters must be populated in order to send to Azure.

    :ivar directory_service_options: Indicates the directory service used. Note that this enum may
     be extended in the future. Required. Known values are: "None", "AADDS", "AD", and "AADKERB".
    :vartype directory_service_options: str or
     ~azure.mgmt.storage.v2022_09_01.models.DirectoryServiceOptions
    :ivar active_directory_properties: Required if directoryServiceOptions are AD, optional if they
     are AADKERB.
    :vartype active_directory_properties:
     ~azure.mgmt.storage.v2022_09_01.models.ActiveDirectoryProperties
    :ivar default_share_permission: Default share permission for users using Kerberos
     authentication if RBAC role is not assigned. Known values are: "None",
     "StorageFileDataSmbShareReader", "StorageFileDataSmbShareContributor", and
     "StorageFileDataSmbShareElevatedContributor".
    :vartype default_share_permission: str or
     ~azure.mgmt.storage.v2022_09_01.models.DefaultSharePermission
    """

    _validation = {
        "directory_service_options": {"required": True},
    }

    _attribute_map = {
        "directory_service_options": {"key": "directoryServiceOptions", "type": "str"},
        "active_directory_properties": {"key": "activeDirectoryProperties", "type": "ActiveDirectoryProperties"},
        "default_share_permission": {"key": "defaultSharePermission", "type": "str"},
    }

    def __init__(
        self,
        *,
        directory_service_options: Union[str, "_models.DirectoryServiceOptions"],
        active_directory_properties: Optional["_models.ActiveDirectoryProperties"] = None,
        default_share_permission: Optional[Union[str, "_models.DefaultSharePermission"]] = None,
        **kwargs
    ):
        """
        :keyword directory_service_options: Indicates the directory service used. Note that this enum
         may be extended in the future. Required. Known values are: "None", "AADDS", "AD", and
         "AADKERB".
        :paramtype directory_service_options: str or
         ~azure.mgmt.storage.v2022_09_01.models.DirectoryServiceOptions
        :keyword active_directory_properties: Required if directoryServiceOptions are AD, optional if
         they are AADKERB.
        :paramtype active_directory_properties:
         ~azure.mgmt.storage.v2022_09_01.models.ActiveDirectoryProperties
        :keyword default_share_permission: Default share permission for users using Kerberos
         authentication if RBAC role is not assigned. Known values are: "None",
         "StorageFileDataSmbShareReader", "StorageFileDataSmbShareContributor", and
         "StorageFileDataSmbShareElevatedContributor".
        :paramtype default_share_permission: str or
         ~azure.mgmt.storage.v2022_09_01.models.DefaultSharePermission
        """
        super().__init__(**kwargs)
        self.directory_service_options = directory_service_options
        self.active_directory_properties = active_directory_properties
        self.default_share_permission = default_share_permission


class BlobContainer(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """Properties of the blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar version: The version of the deleted blob container.
    :vartype version: str
    :ivar deleted: Indicates whether the blob container was deleted.
    :vartype deleted: bool
    :ivar deleted_time: Blob container deletion time.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for soft deleted blob container.
    :vartype remaining_retention_days: int
    :ivar default_encryption_scope: Default the container to use specified encryption scope for all
     writes.
    :vartype default_encryption_scope: str
    :ivar deny_encryption_scope_override: Block override of encryption scope from the container
     default.
    :vartype deny_encryption_scope_override: bool
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Known values are: "Container", "Blob", and "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2022_09_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Known values are: "Locked" and
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2022_09_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    :ivar immutable_storage_with_versioning: The object level immutability property of the
     container. The property is immutable and can only be set to true at the container creation
     time. Existing containers must undergo a migration process.
    :vartype immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageWithVersioning
    :ivar enable_nfs_v3_root_squash: Enable NFSv3 root squash on blob container.
    :vartype enable_nfs_v3_root_squash: bool
    :ivar enable_nfs_v3_all_squash: Enable NFSv3 all squash on blob container.
    :vartype enable_nfs_v3_all_squash: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "version": {"readonly": True},
        "deleted": {"readonly": True},
        "deleted_time": {"readonly": True},
        "remaining_retention_days": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "immutability_policy": {"readonly": True},
        "legal_hold": {"readonly": True},
        "has_legal_hold": {"readonly": True},
        "has_immutability_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "deleted": {"key": "properties.deleted", "type": "bool"},
        "deleted_time": {"key": "properties.deletedTime", "type": "iso-8601"},
        "remaining_retention_days": {"key": "properties.remainingRetentionDays", "type": "int"},
        "default_encryption_scope": {"key": "properties.defaultEncryptionScope", "type": "str"},
        "deny_encryption_scope_override": {"key": "properties.denyEncryptionScopeOverride", "type": "bool"},
        "public_access": {"key": "properties.publicAccess", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "immutability_policy": {"key": "properties.immutabilityPolicy", "type": "ImmutabilityPolicyProperties"},
        "legal_hold": {"key": "properties.legalHold", "type": "LegalHoldProperties"},
        "has_legal_hold": {"key": "properties.hasLegalHold", "type": "bool"},
        "has_immutability_policy": {"key": "properties.hasImmutabilityPolicy", "type": "bool"},
        "immutable_storage_with_versioning": {
            "key": "properties.immutableStorageWithVersioning",
            "type": "ImmutableStorageWithVersioning",
        },
        "enable_nfs_v3_root_squash": {"key": "properties.enableNfsV3RootSquash", "type": "bool"},
        "enable_nfs_v3_all_squash": {"key": "properties.enableNfsV3AllSquash", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default_encryption_scope: Optional[str] = None,
        deny_encryption_scope_override: Optional[bool] = None,
        public_access: Optional[Union[str, "_models.PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        immutable_storage_with_versioning: Optional["_models.ImmutableStorageWithVersioning"] = None,
        enable_nfs_v3_root_squash: Optional[bool] = None,
        enable_nfs_v3_all_squash: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword default_encryption_scope: Default the container to use specified encryption scope for
         all writes.
        :paramtype default_encryption_scope: str
        :keyword deny_encryption_scope_override: Block override of encryption scope from the container
         default.
        :paramtype deny_encryption_scope_override: bool
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Known values are: "Container", "Blob", and "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2022_09_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        :keyword immutable_storage_with_versioning: The object level immutability property of the
         container. The property is immutable and can only be set to true at the container creation
         time. Existing containers must undergo a migration process.
        :paramtype immutable_storage_with_versioning:
         ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageWithVersioning
        :keyword enable_nfs_v3_root_squash: Enable NFSv3 root squash on blob container.
        :paramtype enable_nfs_v3_root_squash: bool
        :keyword enable_nfs_v3_all_squash: Enable NFSv3 all squash on blob container.
        :paramtype enable_nfs_v3_all_squash: bool
        """
        super().__init__(**kwargs)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.default_encryption_scope = default_encryption_scope
        self.deny_encryption_scope_override = deny_encryption_scope_override
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None
        self.immutable_storage_with_versioning = immutable_storage_with_versioning
        self.enable_nfs_v3_root_squash = enable_nfs_v3_root_squash
        self.enable_nfs_v3_all_squash = enable_nfs_v3_all_squash


class BlobInventoryPolicy(Resource):
    """The storage account blob inventory policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.storage.v2022_09_01.models.SystemData
    :ivar last_modified_time: Returns the last modified date and time of the blob inventory policy.
    :vartype last_modified_time: ~datetime.datetime
    :ivar policy: The storage account blob inventory policy object. It is composed of policy rules.
    :vartype policy: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicySchema
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "policy": {"key": "properties.policy", "type": "BlobInventoryPolicySchema"},
    }

    def __init__(self, *, policy: Optional["_models.BlobInventoryPolicySchema"] = None, **kwargs):
        """
        :keyword policy: The storage account blob inventory policy object. It is composed of policy
         rules.
        :paramtype policy: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicySchema
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.last_modified_time = None
        self.policy = policy


class BlobInventoryPolicyDefinition(_serialization.Model):
    """An object that defines the blob inventory rule.

    All required parameters must be populated in order to send to Azure.

    :ivar filters: An object that defines the filter set.
    :vartype filters: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyFilter
    :ivar format: This is a required field, it specifies the format for the inventory files.
     Required. Known values are: "Csv" and "Parquet".
    :vartype format: str or ~azure.mgmt.storage.v2022_09_01.models.Format
    :ivar schedule: This is a required field. This field is used to schedule an inventory
     formation. Required. Known values are: "Daily" and "Weekly".
    :vartype schedule: str or ~azure.mgmt.storage.v2022_09_01.models.Schedule
    :ivar object_type: This is a required field. This field specifies the scope of the inventory
     created either at the blob or container level. Required. Known values are: "Blob" and
     "Container".
    :vartype object_type: str or ~azure.mgmt.storage.v2022_09_01.models.ObjectType
    :ivar schema_fields: This is a required field. This field specifies the fields and properties
     of the object to be included in the inventory. The Schema field value 'Name' is always
     required. The valid values for this field for the 'Blob' definition.objectType include 'Name,
     Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier,
     AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group,
     Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag,
     ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition,
     LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime,
     RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId,
     CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription,
     CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber,
     EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value
     'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container'
     definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState,
     LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope,
     DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version,
     DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner,
     Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field
     values 'Tags, TagCount' are only valid for Non-Hns accounts. Required.
    :vartype schema_fields: list[str]
    """

    _validation = {
        "format": {"required": True},
        "schedule": {"required": True},
        "object_type": {"required": True},
        "schema_fields": {"required": True},
    }

    _attribute_map = {
        "filters": {"key": "filters", "type": "BlobInventoryPolicyFilter"},
        "format": {"key": "format", "type": "str"},
        "schedule": {"key": "schedule", "type": "str"},
        "object_type": {"key": "objectType", "type": "str"},
        "schema_fields": {"key": "schemaFields", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        format: Union[str, "_models.Format"],
        schedule: Union[str, "_models.Schedule"],
        object_type: Union[str, "_models.ObjectType"],
        schema_fields: List[str],
        filters: Optional["_models.BlobInventoryPolicyFilter"] = None,
        **kwargs
    ):
        """
        :keyword filters: An object that defines the filter set.
        :paramtype filters: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyFilter
        :keyword format: This is a required field, it specifies the format for the inventory files.
         Required. Known values are: "Csv" and "Parquet".
        :paramtype format: str or ~azure.mgmt.storage.v2022_09_01.models.Format
        :keyword schedule: This is a required field. This field is used to schedule an inventory
         formation. Required. Known values are: "Daily" and "Weekly".
        :paramtype schedule: str or ~azure.mgmt.storage.v2022_09_01.models.Schedule
        :keyword object_type: This is a required field. This field specifies the scope of the inventory
         created either at the blob or container level. Required. Known values are: "Blob" and
         "Container".
        :paramtype object_type: str or ~azure.mgmt.storage.v2022_09_01.models.ObjectType
        :keyword schema_fields: This is a required field. This field specifies the fields and
         properties of the object to be included in the inventory. The Schema field value 'Name' is
         always required. The valid values for this field for the 'Blob' definition.objectType include
         'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier,
         AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group,
         Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag,
         ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition,
         LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime,
         RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId,
         CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription,
         CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber,
         EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value
         'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container'
         definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState,
         LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope,
         DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version,
         DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner,
         Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field
         values 'Tags, TagCount' are only valid for Non-Hns accounts. Required.
        :paramtype schema_fields: list[str]
        """
        super().__init__(**kwargs)
        self.filters = filters
        self.format = format
        self.schedule = schedule
        self.object_type = object_type
        self.schema_fields = schema_fields


class BlobInventoryPolicyFilter(_serialization.Model):
    """An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional.

    :ivar prefix_match: An array of strings with maximum 10 blob prefixes to be included in the
     inventory.
    :vartype prefix_match: list[str]
    :ivar exclude_prefix: An array of strings with maximum 10 blob prefixes to be excluded from the
     inventory.
    :vartype exclude_prefix: list[str]
    :ivar blob_types: An array of predefined enum values. Valid values include blockBlob,
     appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when
     definition.objectType property is set to 'Blob'.
    :vartype blob_types: list[str]
    :ivar include_blob_versions: Includes blob versions in blob inventory when value is set to
     true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this
     property is set to true, else they must be excluded.
    :vartype include_blob_versions: bool
    :ivar include_snapshots: Includes blob snapshots in blob inventory when value is set to true.
     The definition.schemaFields value 'Snapshot' is required if this property is set to true, else
     it must be excluded.
    :vartype include_snapshots: bool
    :ivar include_deleted: For 'Container' definition.objectType the definition.schemaFields must
     include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob'
     definition.objectType and HNS enabled storage accounts the definition.schemaFields must include
     'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the
     definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be
     excluded.
    :vartype include_deleted: bool
    """

    _attribute_map = {
        "prefix_match": {"key": "prefixMatch", "type": "[str]"},
        "exclude_prefix": {"key": "excludePrefix", "type": "[str]"},
        "blob_types": {"key": "blobTypes", "type": "[str]"},
        "include_blob_versions": {"key": "includeBlobVersions", "type": "bool"},
        "include_snapshots": {"key": "includeSnapshots", "type": "bool"},
        "include_deleted": {"key": "includeDeleted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        prefix_match: Optional[List[str]] = None,
        exclude_prefix: Optional[List[str]] = None,
        blob_types: Optional[List[str]] = None,
        include_blob_versions: Optional[bool] = None,
        include_snapshots: Optional[bool] = None,
        include_deleted: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword prefix_match: An array of strings with maximum 10 blob prefixes to be included in the
         inventory.
        :paramtype prefix_match: list[str]
        :keyword exclude_prefix: An array of strings with maximum 10 blob prefixes to be excluded from
         the inventory.
        :paramtype exclude_prefix: list[str]
        :keyword blob_types: An array of predefined enum values. Valid values include blockBlob,
         appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when
         definition.objectType property is set to 'Blob'.
        :paramtype blob_types: list[str]
        :keyword include_blob_versions: Includes blob versions in blob inventory when value is set to
         true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this
         property is set to true, else they must be excluded.
        :paramtype include_blob_versions: bool
        :keyword include_snapshots: Includes blob snapshots in blob inventory when value is set to
         true. The definition.schemaFields value 'Snapshot' is required if this property is set to true,
         else it must be excluded.
        :paramtype include_snapshots: bool
        :keyword include_deleted: For 'Container' definition.objectType the definition.schemaFields
         must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob'
         definition.objectType and HNS enabled storage accounts the definition.schemaFields must include
         'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the
         definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be
         excluded.
        :paramtype include_deleted: bool
        """
        super().__init__(**kwargs)
        self.prefix_match = prefix_match
        self.exclude_prefix = exclude_prefix
        self.blob_types = blob_types
        self.include_blob_versions = include_blob_versions
        self.include_snapshots = include_snapshots
        self.include_deleted = include_deleted


class BlobInventoryPolicyRule(_serialization.Model):
    """An object that wraps the blob inventory rule. Each rule is uniquely defined by name.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Rule is enabled when set to true. Required.
    :vartype enabled: bool
    :ivar name: A rule name can contain any combination of alpha numeric characters. Rule name is
     case-sensitive. It must be unique within a policy. Required.
    :vartype name: str
    :ivar destination: Container name where blob inventory files are stored. Must be pre-created.
     Required.
    :vartype destination: str
    :ivar definition: An object that defines the blob inventory policy rule. Required.
    :vartype definition: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyDefinition
    """

    _validation = {
        "enabled": {"required": True},
        "name": {"required": True},
        "destination": {"required": True},
        "definition": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "destination": {"key": "destination", "type": "str"},
        "definition": {"key": "definition", "type": "BlobInventoryPolicyDefinition"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        name: str,
        destination: str,
        definition: "_models.BlobInventoryPolicyDefinition",
        **kwargs
    ):
        """
        :keyword enabled: Rule is enabled when set to true. Required.
        :paramtype enabled: bool
        :keyword name: A rule name can contain any combination of alpha numeric characters. Rule name
         is case-sensitive. It must be unique within a policy. Required.
        :paramtype name: str
        :keyword destination: Container name where blob inventory files are stored. Must be
         pre-created. Required.
        :paramtype destination: str
        :keyword definition: An object that defines the blob inventory policy rule. Required.
        :paramtype definition: ~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyDefinition
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.name = name
        self.destination = destination
        self.definition = definition


class BlobInventoryPolicySchema(_serialization.Model):
    """The storage account blob inventory policy rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Policy is enabled if set to true. Required.
    :vartype enabled: bool
    :ivar destination: Deprecated Property from API version 2021-04-01 onwards, the required
     destination container name must be specified at the rule level 'policy.rule.destination'.
    :vartype destination: str
    :ivar type: The valid value is Inventory. Required. "Inventory"
    :vartype type: str or ~azure.mgmt.storage.v2022_09_01.models.InventoryRuleType
    :ivar rules: The storage account blob inventory policy rules. The rule is applied when it is
     enabled. Required.
    :vartype rules: list[~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyRule]
    """

    _validation = {
        "enabled": {"required": True},
        "destination": {"readonly": True},
        "type": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "destination": {"key": "destination", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rules": {"key": "rules", "type": "[BlobInventoryPolicyRule]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        type: Union[str, "_models.InventoryRuleType"],
        rules: List["_models.BlobInventoryPolicyRule"],
        **kwargs
    ):
        """
        :keyword enabled: Policy is enabled if set to true. Required.
        :paramtype enabled: bool
        :keyword type: The valid value is Inventory. Required. "Inventory"
        :paramtype type: str or ~azure.mgmt.storage.v2022_09_01.models.InventoryRuleType
        :keyword rules: The storage account blob inventory policy rules. The rule is applied when it is
         enabled. Required.
        :paramtype rules: list[~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicyRule]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.destination = None
        self.type = type
        self.rules = rules


class BlobRestoreParameters(_serialization.Model):
    """Blob restore parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar time_to_restore: Restore blob to the specified time. Required.
    :vartype time_to_restore: ~datetime.datetime
    :ivar blob_ranges: Blob ranges to restore. Required.
    :vartype blob_ranges: list[~azure.mgmt.storage.v2022_09_01.models.BlobRestoreRange]
    """

    _validation = {
        "time_to_restore": {"required": True},
        "blob_ranges": {"required": True},
    }

    _attribute_map = {
        "time_to_restore": {"key": "timeToRestore", "type": "iso-8601"},
        "blob_ranges": {"key": "blobRanges", "type": "[BlobRestoreRange]"},
    }

    def __init__(self, *, time_to_restore: datetime.datetime, blob_ranges: List["_models.BlobRestoreRange"], **kwargs):
        """
        :keyword time_to_restore: Restore blob to the specified time. Required.
        :paramtype time_to_restore: ~datetime.datetime
        :keyword blob_ranges: Blob ranges to restore. Required.
        :paramtype blob_ranges: list[~azure.mgmt.storage.v2022_09_01.models.BlobRestoreRange]
        """
        super().__init__(**kwargs)
        self.time_to_restore = time_to_restore
        self.blob_ranges = blob_ranges


class BlobRestoreRange(_serialization.Model):
    """Blob range.

    All required parameters must be populated in order to send to Azure.

    :ivar start_range: Blob start range. This is inclusive. Empty means account start. Required.
    :vartype start_range: str
    :ivar end_range: Blob end range. This is exclusive. Empty means account end. Required.
    :vartype end_range: str
    """

    _validation = {
        "start_range": {"required": True},
        "end_range": {"required": True},
    }

    _attribute_map = {
        "start_range": {"key": "startRange", "type": "str"},
        "end_range": {"key": "endRange", "type": "str"},
    }

    def __init__(self, *, start_range: str, end_range: str, **kwargs):
        """
        :keyword start_range: Blob start range. This is inclusive. Empty means account start. Required.
        :paramtype start_range: str
        :keyword end_range: Blob end range. This is exclusive. Empty means account end. Required.
        :paramtype end_range: str
        """
        super().__init__(**kwargs)
        self.start_range = start_range
        self.end_range = end_range


class BlobRestoreStatus(_serialization.Model):
    """Blob restore status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of blob restore progress. Possible values are: - InProgress: Indicates
     that blob restore is ongoing. - Complete: Indicates that blob restore has been completed
     successfully. - Failed: Indicates that blob restore is failed. Known values are: "InProgress",
     "Complete", and "Failed".
    :vartype status: str or ~azure.mgmt.storage.v2022_09_01.models.BlobRestoreProgressStatus
    :ivar failure_reason: Failure reason when blob restore is failed.
    :vartype failure_reason: str
    :ivar restore_id: Id for tracking blob restore request.
    :vartype restore_id: str
    :ivar parameters: Blob restore request parameters.
    :vartype parameters: ~azure.mgmt.storage.v2022_09_01.models.BlobRestoreParameters
    """

    _validation = {
        "status": {"readonly": True},
        "failure_reason": {"readonly": True},
        "restore_id": {"readonly": True},
        "parameters": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "failure_reason": {"key": "failureReason", "type": "str"},
        "restore_id": {"key": "restoreId", "type": "str"},
        "parameters": {"key": "parameters", "type": "BlobRestoreParameters"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.failure_reason = None
        self.restore_id = None
        self.parameters = None


class BlobServiceItems(_serialization.Model):
    """BlobServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blob services returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.BlobServiceProperties]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BlobServiceProperties]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class BlobServiceProperties(Resource):  # pylint: disable=too-many-instance-attributes
    """The properties of a storage account’s Blob service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
    :ivar cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Blob service.
    :vartype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
    :ivar default_service_version: DefaultServiceVersion indicates the default version to use for
     requests to the Blob service if an incoming request’s version is not specified. Possible values
     include version 2008-10-27 and all more recent versions.
    :vartype default_service_version: str
    :ivar delete_retention_policy: The blob service properties for blob soft delete.
    :vartype delete_retention_policy: ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
    :ivar is_versioning_enabled: Versioning is enabled if set to true.
    :vartype is_versioning_enabled: bool
    :ivar automatic_snapshot_policy_enabled: Deprecated in favor of isVersioningEnabled property.
    :vartype automatic_snapshot_policy_enabled: bool
    :ivar change_feed: The blob service properties for change feed events.
    :vartype change_feed: ~azure.mgmt.storage.v2022_09_01.models.ChangeFeed
    :ivar restore_policy: The blob service properties for blob restore policy.
    :vartype restore_policy: ~azure.mgmt.storage.v2022_09_01.models.RestorePolicyProperties
    :ivar container_delete_retention_policy: The blob service properties for container soft delete.
    :vartype container_delete_retention_policy:
     ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
    :ivar last_access_time_tracking_policy: The blob service property to configure last access time
     based tracking policy.
    :vartype last_access_time_tracking_policy:
     ~azure.mgmt.storage.v2022_09_01.models.LastAccessTimeTrackingPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "sku": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "cors": {"key": "properties.cors", "type": "CorsRules"},
        "default_service_version": {"key": "properties.defaultServiceVersion", "type": "str"},
        "delete_retention_policy": {"key": "properties.deleteRetentionPolicy", "type": "DeleteRetentionPolicy"},
        "is_versioning_enabled": {"key": "properties.isVersioningEnabled", "type": "bool"},
        "automatic_snapshot_policy_enabled": {"key": "properties.automaticSnapshotPolicyEnabled", "type": "bool"},
        "change_feed": {"key": "properties.changeFeed", "type": "ChangeFeed"},
        "restore_policy": {"key": "properties.restorePolicy", "type": "RestorePolicyProperties"},
        "container_delete_retention_policy": {
            "key": "properties.containerDeleteRetentionPolicy",
            "type": "DeleteRetentionPolicy",
        },
        "last_access_time_tracking_policy": {
            "key": "properties.lastAccessTimeTrackingPolicy",
            "type": "LastAccessTimeTrackingPolicy",
        },
    }

    def __init__(
        self,
        *,
        cors: Optional["_models.CorsRules"] = None,
        default_service_version: Optional[str] = None,
        delete_retention_policy: Optional["_models.DeleteRetentionPolicy"] = None,
        is_versioning_enabled: Optional[bool] = None,
        automatic_snapshot_policy_enabled: Optional[bool] = None,
        change_feed: Optional["_models.ChangeFeed"] = None,
        restore_policy: Optional["_models.RestorePolicyProperties"] = None,
        container_delete_retention_policy: Optional["_models.DeleteRetentionPolicy"] = None,
        last_access_time_tracking_policy: Optional["_models.LastAccessTimeTrackingPolicy"] = None,
        **kwargs
    ):
        """
        :keyword cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the Blob service.
        :paramtype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
        :keyword default_service_version: DefaultServiceVersion indicates the default version to use
         for requests to the Blob service if an incoming request’s version is not specified. Possible
         values include version 2008-10-27 and all more recent versions.
        :paramtype default_service_version: str
        :keyword delete_retention_policy: The blob service properties for blob soft delete.
        :paramtype delete_retention_policy:
         ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
        :keyword is_versioning_enabled: Versioning is enabled if set to true.
        :paramtype is_versioning_enabled: bool
        :keyword automatic_snapshot_policy_enabled: Deprecated in favor of isVersioningEnabled
         property.
        :paramtype automatic_snapshot_policy_enabled: bool
        :keyword change_feed: The blob service properties for change feed events.
        :paramtype change_feed: ~azure.mgmt.storage.v2022_09_01.models.ChangeFeed
        :keyword restore_policy: The blob service properties for blob restore policy.
        :paramtype restore_policy: ~azure.mgmt.storage.v2022_09_01.models.RestorePolicyProperties
        :keyword container_delete_retention_policy: The blob service properties for container soft
         delete.
        :paramtype container_delete_retention_policy:
         ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
        :keyword last_access_time_tracking_policy: The blob service property to configure last access
         time based tracking policy.
        :paramtype last_access_time_tracking_policy:
         ~azure.mgmt.storage.v2022_09_01.models.LastAccessTimeTrackingPolicy
        """
        super().__init__(**kwargs)
        self.sku = None
        self.cors = cors
        self.default_service_version = default_service_version
        self.delete_retention_policy = delete_retention_policy
        self.is_versioning_enabled = is_versioning_enabled
        self.automatic_snapshot_policy_enabled = automatic_snapshot_policy_enabled
        self.change_feed = change_feed
        self.restore_policy = restore_policy
        self.container_delete_retention_policy = container_delete_retention_policy
        self.last_access_time_tracking_policy = last_access_time_tracking_policy


class ChangeFeed(_serialization.Model):
    """The blob service properties for change feed events.

    :ivar enabled: Indicates whether change feed event logging is enabled for the Blob service.
    :vartype enabled: bool
    :ivar retention_in_days: Indicates the duration of changeFeed retention in days. Minimum value
     is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite
     retention of the change feed.
    :vartype retention_in_days: int
    """

    _validation = {
        "retention_in_days": {"maximum": 146000, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, retention_in_days: Optional[int] = None, **kwargs):
        """
        :keyword enabled: Indicates whether change feed event logging is enabled for the Blob service.
        :paramtype enabled: bool
        :keyword retention_in_days: Indicates the duration of changeFeed retention in days. Minimum
         value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite
         retention of the change feed.
        :paramtype retention_in_days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.retention_in_days = retention_in_days


class CheckNameAvailabilityResult(_serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be used. The Reason element
     is only returned if NameAvailable is false. Known values are: "AccountNameInvalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storage.v2022_09_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorBody(_serialization.Model):
    """An error response from the Storage service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.storage.v2022_09_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.storage.v2022_09_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CorsRule(_serialization.Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required if CorsRule element is present. A list of origin domains that
     will be allowed via CORS, or "*" to allow all domains. Required.
    :vartype allowed_origins: list[str]
    :ivar allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are
     allowed to be executed by the origin. Required.
    :vartype allowed_methods: list[str or ~azure.mgmt.storage.v2022_09_01.models.AllowedMethods]
    :ivar max_age_in_seconds: Required if CorsRule element is present. The number of seconds that
     the client/browser should cache a preflight response. Required.
    :vartype max_age_in_seconds: int
    :ivar exposed_headers: Required if CorsRule element is present. A list of response headers to
     expose to CORS clients. Required.
    :vartype exposed_headers: list[str]
    :ivar allowed_headers: Required if CorsRule element is present. A list of headers allowed to be
     part of the cross-origin request. Required.
    :vartype allowed_headers: list[str]
    """

    _validation = {
        "allowed_origins": {"required": True},
        "allowed_methods": {"required": True},
        "max_age_in_seconds": {"required": True},
        "exposed_headers": {"required": True},
        "allowed_headers": {"required": True},
    }

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "allowed_methods": {"key": "allowedMethods", "type": "[str]"},
        "max_age_in_seconds": {"key": "maxAgeInSeconds", "type": "int"},
        "exposed_headers": {"key": "exposedHeaders", "type": "[str]"},
        "allowed_headers": {"key": "allowedHeaders", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_origins: List[str],
        allowed_methods: List[Union[str, "_models.AllowedMethods"]],
        max_age_in_seconds: int,
        exposed_headers: List[str],
        allowed_headers: List[str],
        **kwargs
    ):
        """
        :keyword allowed_origins: Required if CorsRule element is present. A list of origin domains
         that will be allowed via CORS, or "*" to allow all domains. Required.
        :paramtype allowed_origins: list[str]
        :keyword allowed_methods: Required if CorsRule element is present. A list of HTTP methods that
         are allowed to be executed by the origin. Required.
        :paramtype allowed_methods: list[str or ~azure.mgmt.storage.v2022_09_01.models.AllowedMethods]
        :keyword max_age_in_seconds: Required if CorsRule element is present. The number of seconds
         that the client/browser should cache a preflight response. Required.
        :paramtype max_age_in_seconds: int
        :keyword exposed_headers: Required if CorsRule element is present. A list of response headers
         to expose to CORS clients. Required.
        :paramtype exposed_headers: list[str]
        :keyword allowed_headers: Required if CorsRule element is present. A list of headers allowed to
         be part of the cross-origin request. Required.
        :paramtype allowed_headers: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.max_age_in_seconds = max_age_in_seconds
        self.exposed_headers = exposed_headers
        self.allowed_headers = allowed_headers


class CorsRules(_serialization.Model):
    """Sets the CORS rules. You can include up to five CorsRule elements in the request.

    :ivar cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the
     request.
    :vartype cors_rules: list[~azure.mgmt.storage.v2022_09_01.models.CorsRule]
    """

    _attribute_map = {
        "cors_rules": {"key": "corsRules", "type": "[CorsRule]"},
    }

    def __init__(self, *, cors_rules: Optional[List["_models.CorsRule"]] = None, **kwargs):
        """
        :keyword cors_rules: The List of CORS rules. You can include up to five CorsRule elements in
         the request.
        :paramtype cors_rules: list[~azure.mgmt.storage.v2022_09_01.models.CorsRule]
        """
        super().__init__(**kwargs)
        self.cors_rules = cors_rules


class CustomDomain(_serialization.Model):
    """The custom domain assigned to this storage account. This can be set via Update.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Gets or sets the custom domain name assigned to the storage account. Name is the
     CNAME source. Required.
    :vartype name: str
    :ivar use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
     value is false. This should only be set on updates.
    :vartype use_sub_domain_name: bool
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "use_sub_domain_name": {"key": "useSubDomainName", "type": "bool"},
    }

    def __init__(self, *, name: str, use_sub_domain_name: Optional[bool] = None, **kwargs):
        """
        :keyword name: Gets or sets the custom domain name assigned to the storage account. Name is the
         CNAME source. Required.
        :paramtype name: str
        :keyword use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
         value is false. This should only be set on updates.
        :paramtype use_sub_domain_name: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.use_sub_domain_name = use_sub_domain_name


class DateAfterCreation(_serialization.Model):
    """Object to define snapshot and version action conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar days_after_creation_greater_than: Value indicating the age in days after creation.
     Required.
    :vartype days_after_creation_greater_than: float
    :ivar days_after_last_tier_change_greater_than: Value indicating the age in days after last
     blob tier change time. This property is only applicable for tierToArchive actions and requires
     daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob
     will be archived if both the conditions are satisfied.
    :vartype days_after_last_tier_change_greater_than: float
    """

    _validation = {
        "days_after_creation_greater_than": {"required": True, "minimum": 0, "multiple": 1},
        "days_after_last_tier_change_greater_than": {"minimum": 0, "multiple": 1},
    }

    _attribute_map = {
        "days_after_creation_greater_than": {"key": "daysAfterCreationGreaterThan", "type": "float"},
        "days_after_last_tier_change_greater_than": {"key": "daysAfterLastTierChangeGreaterThan", "type": "float"},
    }

    def __init__(
        self,
        *,
        days_after_creation_greater_than: float,
        days_after_last_tier_change_greater_than: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword days_after_creation_greater_than: Value indicating the age in days after creation.
         Required.
        :paramtype days_after_creation_greater_than: float
        :keyword days_after_last_tier_change_greater_than: Value indicating the age in days after last
         blob tier change time. This property is only applicable for tierToArchive actions and requires
         daysAfterCreationGreaterThan to be set for snapshots and blob version based actions. The blob
         will be archived if both the conditions are satisfied.
        :paramtype days_after_last_tier_change_greater_than: float
        """
        super().__init__(**kwargs)
        self.days_after_creation_greater_than = days_after_creation_greater_than
        self.days_after_last_tier_change_greater_than = days_after_last_tier_change_greater_than


class DateAfterModification(_serialization.Model):
    """Object to define the base blob action conditions. Properties daysAfterModificationGreaterThan, daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan are mutually exclusive. The daysAfterLastTierChangeGreaterThan property is only applicable for tierToArchive actions which requires daysAfterModificationGreaterThan to be set, also it cannot be used in conjunction with daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.

    :ivar days_after_modification_greater_than: Value indicating the age in days after last
     modification.
    :vartype days_after_modification_greater_than: float
    :ivar days_after_last_access_time_greater_than: Value indicating the age in days after last
     blob access. This property can only be used in conjunction with last access time tracking
     policy.
    :vartype days_after_last_access_time_greater_than: float
    :ivar days_after_last_tier_change_greater_than: Value indicating the age in days after last
     blob tier change time. This property is only applicable for tierToArchive actions and requires
     daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be
     archived if both the conditions are satisfied.
    :vartype days_after_last_tier_change_greater_than: float
    :ivar days_after_creation_greater_than: Value indicating the age in days after blob creation.
    :vartype days_after_creation_greater_than: float
    """

    _validation = {
        "days_after_modification_greater_than": {"minimum": 0, "multiple": 1},
        "days_after_last_access_time_greater_than": {"minimum": 0, "multiple": 1},
        "days_after_last_tier_change_greater_than": {"minimum": 0, "multiple": 1},
        "days_after_creation_greater_than": {"minimum": 0, "multiple": 1},
    }

    _attribute_map = {
        "days_after_modification_greater_than": {"key": "daysAfterModificationGreaterThan", "type": "float"},
        "days_after_last_access_time_greater_than": {"key": "daysAfterLastAccessTimeGreaterThan", "type": "float"},
        "days_after_last_tier_change_greater_than": {"key": "daysAfterLastTierChangeGreaterThan", "type": "float"},
        "days_after_creation_greater_than": {"key": "daysAfterCreationGreaterThan", "type": "float"},
    }

    def __init__(
        self,
        *,
        days_after_modification_greater_than: Optional[float] = None,
        days_after_last_access_time_greater_than: Optional[float] = None,
        days_after_last_tier_change_greater_than: Optional[float] = None,
        days_after_creation_greater_than: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword days_after_modification_greater_than: Value indicating the age in days after last
         modification.
        :paramtype days_after_modification_greater_than: float
        :keyword days_after_last_access_time_greater_than: Value indicating the age in days after last
         blob access. This property can only be used in conjunction with last access time tracking
         policy.
        :paramtype days_after_last_access_time_greater_than: float
        :keyword days_after_last_tier_change_greater_than: Value indicating the age in days after last
         blob tier change time. This property is only applicable for tierToArchive actions and requires
         daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be
         archived if both the conditions are satisfied.
        :paramtype days_after_last_tier_change_greater_than: float
        :keyword days_after_creation_greater_than: Value indicating the age in days after blob
         creation.
        :paramtype days_after_creation_greater_than: float
        """
        super().__init__(**kwargs)
        self.days_after_modification_greater_than = days_after_modification_greater_than
        self.days_after_last_access_time_greater_than = days_after_last_access_time_greater_than
        self.days_after_last_tier_change_greater_than = days_after_last_tier_change_greater_than
        self.days_after_creation_greater_than = days_after_creation_greater_than


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class DeletedAccount(ProxyResource):
    """Deleted storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar storage_account_resource_id: Full resource id of the original storage account.
    :vartype storage_account_resource_id: str
    :ivar location: Location of the deleted account.
    :vartype location: str
    :ivar restore_reference: Can be used to attempt recovering this deleted account via
     PutStorageAccount API.
    :vartype restore_reference: str
    :ivar creation_time: Creation time of the deleted account.
    :vartype creation_time: str
    :ivar deletion_time: Deletion time of the deleted account.
    :vartype deletion_time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "storage_account_resource_id": {"readonly": True},
        "location": {"readonly": True},
        "restore_reference": {"readonly": True},
        "creation_time": {"readonly": True},
        "deletion_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_account_resource_id": {"key": "properties.storageAccountResourceId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "restore_reference": {"key": "properties.restoreReference", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "str"},
        "deletion_time": {"key": "properties.deletionTime", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.storage_account_resource_id = None
        self.location = None
        self.restore_reference = None
        self.creation_time = None
        self.deletion_time = None


class DeletedAccountListResult(_serialization.Model):
    """The response from the List Deleted Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of deleted accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.DeletedAccount]
    :ivar next_link: Request URL that can be used to query next page of deleted accounts. Returned
     when total number of requested deleted accounts exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedAccount]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeletedShare(_serialization.Model):
    """The deleted share to be restored.

    All required parameters must be populated in order to send to Azure.

    :ivar deleted_share_name: Required. Identify the name of the deleted share that will be
     restored. Required.
    :vartype deleted_share_name: str
    :ivar deleted_share_version: Required. Identify the version of the deleted share that will be
     restored. Required.
    :vartype deleted_share_version: str
    """

    _validation = {
        "deleted_share_name": {"required": True},
        "deleted_share_version": {"required": True},
    }

    _attribute_map = {
        "deleted_share_name": {"key": "deletedShareName", "type": "str"},
        "deleted_share_version": {"key": "deletedShareVersion", "type": "str"},
    }

    def __init__(self, *, deleted_share_name: str, deleted_share_version: str, **kwargs):
        """
        :keyword deleted_share_name: Required. Identify the name of the deleted share that will be
         restored. Required.
        :paramtype deleted_share_name: str
        :keyword deleted_share_version: Required. Identify the version of the deleted share that will
         be restored. Required.
        :paramtype deleted_share_version: str
        """
        super().__init__(**kwargs)
        self.deleted_share_name = deleted_share_name
        self.deleted_share_version = deleted_share_version


class DeleteRetentionPolicy(_serialization.Model):
    """The service properties for soft delete.

    :ivar enabled: Indicates whether DeleteRetentionPolicy is enabled.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that the deleted item should be retained. The minimum
     specified value can be 1 and the maximum value can be 365.
    :vartype days: int
    :ivar allow_permanent_delete: This property when set to true allows deletion of the soft
     deleted blob versions and snapshots. This property cannot be used blob restore policy. This
     property only applies to blob service and does not apply to containers or file share.
    :vartype allow_permanent_delete: bool
    """

    _validation = {
        "days": {"maximum": 365, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "days": {"key": "days", "type": "int"},
        "allow_permanent_delete": {"key": "allowPermanentDelete", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        days: Optional[int] = None,
        allow_permanent_delete: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Indicates whether DeleteRetentionPolicy is enabled.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that the deleted item should be retained. The
         minimum specified value can be 1 and the maximum value can be 365.
        :paramtype days: int
        :keyword allow_permanent_delete: This property when set to true allows deletion of the soft
         deleted blob versions and snapshots. This property cannot be used blob restore policy. This
         property only applies to blob service and does not apply to containers or file share.
        :paramtype allow_permanent_delete: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days
        self.allow_permanent_delete = allow_permanent_delete


class Dimension(_serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, display_name: Optional[str] = None, **kwargs):
        """
        :keyword name: Display name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class Encryption(_serialization.Model):
    """The encryption settings on the storage account.

    :ivar services: List of services which support encryption.
    :vartype services: ~azure.mgmt.storage.v2022_09_01.models.EncryptionServices
    :ivar key_source: The encryption keySource (provider). Possible values (case-insensitive):
     Microsoft.Storage, Microsoft.Keyvault. Known values are: "Microsoft.Storage" and
     "Microsoft.Keyvault".
    :vartype key_source: str or ~azure.mgmt.storage.v2022_09_01.models.KeySource
    :ivar require_infrastructure_encryption: A boolean indicating whether or not the service
     applies a secondary layer of encryption with platform managed keys for data at rest.
    :vartype require_infrastructure_encryption: bool
    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.storage.v2022_09_01.models.KeyVaultProperties
    :ivar encryption_identity: The identity to be used with service-side encryption at rest.
    :vartype encryption_identity: ~azure.mgmt.storage.v2022_09_01.models.EncryptionIdentity
    """

    _attribute_map = {
        "services": {"key": "services", "type": "EncryptionServices"},
        "key_source": {"key": "keySource", "type": "str"},
        "require_infrastructure_encryption": {"key": "requireInfrastructureEncryption", "type": "bool"},
        "key_vault_properties": {"key": "keyvaultproperties", "type": "KeyVaultProperties"},
        "encryption_identity": {"key": "identity", "type": "EncryptionIdentity"},
    }

    def __init__(
        self,
        *,
        services: Optional["_models.EncryptionServices"] = None,
        key_source: Union[str, "_models.KeySource"] = "Microsoft.Storage",
        require_infrastructure_encryption: Optional[bool] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
        **kwargs
    ):
        """
        :keyword services: List of services which support encryption.
        :paramtype services: ~azure.mgmt.storage.v2022_09_01.models.EncryptionServices
        :keyword key_source: The encryption keySource (provider). Possible values (case-insensitive):
         Microsoft.Storage, Microsoft.Keyvault. Known values are: "Microsoft.Storage" and
         "Microsoft.Keyvault".
        :paramtype key_source: str or ~azure.mgmt.storage.v2022_09_01.models.KeySource
        :keyword require_infrastructure_encryption: A boolean indicating whether or not the service
         applies a secondary layer of encryption with platform managed keys for data at rest.
        :paramtype require_infrastructure_encryption: bool
        :keyword key_vault_properties: Properties provided by key vault.
        :paramtype key_vault_properties: ~azure.mgmt.storage.v2022_09_01.models.KeyVaultProperties
        :keyword encryption_identity: The identity to be used with service-side encryption at rest.
        :paramtype encryption_identity: ~azure.mgmt.storage.v2022_09_01.models.EncryptionIdentity
        """
        super().__init__(**kwargs)
        self.services = services
        self.key_source = key_source
        self.require_infrastructure_encryption = require_infrastructure_encryption
        self.key_vault_properties = key_vault_properties
        self.encryption_identity = encryption_identity


class EncryptionIdentity(_serialization.Model):
    """Encryption identity for the storage account.

    :ivar encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to be
     associated with server-side encryption on the storage account.
    :vartype encryption_user_assigned_identity: str
    :ivar encryption_federated_identity_client_id: ClientId of the multi-tenant application to be
     used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys
     server-side encryption on the storage account.
    :vartype encryption_federated_identity_client_id: str
    """

    _attribute_map = {
        "encryption_user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
        "encryption_federated_identity_client_id": {"key": "federatedIdentityClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        encryption_user_assigned_identity: Optional[str] = None,
        encryption_federated_identity_client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to
         be associated with server-side encryption on the storage account.
        :paramtype encryption_user_assigned_identity: str
        :keyword encryption_federated_identity_client_id: ClientId of the multi-tenant application to
         be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys
         server-side encryption on the storage account.
        :paramtype encryption_federated_identity_client_id: str
        """
        super().__init__(**kwargs)
        self.encryption_user_assigned_identity = encryption_user_assigned_identity
        self.encryption_federated_identity_client_id = encryption_federated_identity_client_id


class EncryptionScope(Resource):
    """The Encryption Scope resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar source: The provider for the encryption scope. Possible values (case-insensitive):
     Microsoft.Storage, Microsoft.KeyVault. Known values are: "Microsoft.Storage" and
     "Microsoft.KeyVault".
    :vartype source: str or ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeSource
    :ivar state: The state of the encryption scope. Possible values (case-insensitive):  Enabled,
     Disabled. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeState
    :ivar creation_time: Gets the creation date and time of the encryption scope in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modification date and time of the encryption scope in
     UTC.
    :vartype last_modified_time: ~datetime.datetime
    :ivar key_vault_properties: The key vault properties for the encryption scope. This is a
     required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
    :vartype key_vault_properties:
     ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeKeyVaultProperties
    :ivar require_infrastructure_encryption: A boolean indicating whether or not the service
     applies a secondary layer of encryption with platform managed keys for data at rest.
    :vartype require_infrastructure_encryption: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "creation_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "key_vault_properties": {"key": "properties.keyVaultProperties", "type": "EncryptionScopeKeyVaultProperties"},
        "require_infrastructure_encryption": {"key": "properties.requireInfrastructureEncryption", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source: Optional[Union[str, "_models.EncryptionScopeSource"]] = None,
        state: Optional[Union[str, "_models.EncryptionScopeState"]] = None,
        key_vault_properties: Optional["_models.EncryptionScopeKeyVaultProperties"] = None,
        require_infrastructure_encryption: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword source: The provider for the encryption scope. Possible values (case-insensitive):
         Microsoft.Storage, Microsoft.KeyVault. Known values are: "Microsoft.Storage" and
         "Microsoft.KeyVault".
        :paramtype source: str or ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeSource
        :keyword state: The state of the encryption scope. Possible values (case-insensitive):
         Enabled, Disabled. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeState
        :keyword key_vault_properties: The key vault properties for the encryption scope. This is a
         required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
        :paramtype key_vault_properties:
         ~azure.mgmt.storage.v2022_09_01.models.EncryptionScopeKeyVaultProperties
        :keyword require_infrastructure_encryption: A boolean indicating whether or not the service
         applies a secondary layer of encryption with platform managed keys for data at rest.
        :paramtype require_infrastructure_encryption: bool
        """
        super().__init__(**kwargs)
        self.source = source
        self.state = state
        self.creation_time = None
        self.last_modified_time = None
        self.key_vault_properties = key_vault_properties
        self.require_infrastructure_encryption = require_infrastructure_encryption


class EncryptionScopeKeyVaultProperties(_serialization.Model):
    """The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_uri: The object identifier for a key vault key object. When applied, the encryption
     scope will use the key referenced by the identifier to enable customer-managed key support on
     this encryption scope.
    :vartype key_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        "current_versioned_key_identifier": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "key_uri": {"key": "keyUri", "type": "str"},
        "current_versioned_key_identifier": {"key": "currentVersionedKeyIdentifier", "type": "str"},
        "last_key_rotation_timestamp": {"key": "lastKeyRotationTimestamp", "type": "iso-8601"},
    }

    def __init__(self, *, key_uri: Optional[str] = None, **kwargs):
        """
        :keyword key_uri: The object identifier for a key vault key object. When applied, the
         encryption scope will use the key referenced by the identifier to enable customer-managed key
         support on this encryption scope.
        :paramtype key_uri: str
        """
        super().__init__(**kwargs)
        self.key_uri = key_uri
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None


class EncryptionScopeListResult(_serialization.Model):
    """List of encryption scopes requested, and if paging is required, a URL to the next page of encryption scopes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of encryption scopes requested.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.EncryptionScope]
    :ivar next_link: Request URL that can be used to query next page of encryption scopes. Returned
     when total number of requested encryption scopes exceeds the maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EncryptionScope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class EncryptionService(_serialization.Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: A boolean indicating whether or not the service encrypts the data as it is
     stored. Encryption at rest is enabled by default today and cannot be disabled.
    :vartype enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the encryption was last
     enabled by the user. Data is encrypted at rest by default today and cannot be disabled.
    :vartype last_enabled_time: ~datetime.datetime
    :ivar key_type: Encryption key type to be used for the encryption service. 'Account' key type
     implies that an account-scoped encryption key will be used. 'Service' key type implies that a
     default service key is used. Known values are: "Service" and "Account".
    :vartype key_type: str or ~azure.mgmt.storage.v2022_09_01.models.KeyType
    """

    _validation = {
        "last_enabled_time": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "last_enabled_time": {"key": "lastEnabledTime", "type": "iso-8601"},
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(
        self, *, enabled: Optional[bool] = None, key_type: Optional[Union[str, "_models.KeyType"]] = None, **kwargs
    ):
        """
        :keyword enabled: A boolean indicating whether or not the service encrypts the data as it is
         stored. Encryption at rest is enabled by default today and cannot be disabled.
        :paramtype enabled: bool
        :keyword key_type: Encryption key type to be used for the encryption service. 'Account' key
         type implies that an account-scoped encryption key will be used. 'Service' key type implies
         that a default service key is used. Known values are: "Service" and "Account".
        :paramtype key_type: str or ~azure.mgmt.storage.v2022_09_01.models.KeyType
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.last_enabled_time = None
        self.key_type = key_type


class EncryptionServices(_serialization.Model):
    """A list of services that support encryption.

    :ivar blob: The encryption function of the blob storage service.
    :vartype blob: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
    :ivar file: The encryption function of the file storage service.
    :vartype file: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
    :ivar table: The encryption function of the table storage service.
    :vartype table: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
    :ivar queue: The encryption function of the queue storage service.
    :vartype queue: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
    """

    _attribute_map = {
        "blob": {"key": "blob", "type": "EncryptionService"},
        "file": {"key": "file", "type": "EncryptionService"},
        "table": {"key": "table", "type": "EncryptionService"},
        "queue": {"key": "queue", "type": "EncryptionService"},
    }

    def __init__(
        self,
        *,
        blob: Optional["_models.EncryptionService"] = None,
        file: Optional["_models.EncryptionService"] = None,
        table: Optional["_models.EncryptionService"] = None,
        queue: Optional["_models.EncryptionService"] = None,
        **kwargs
    ):
        """
        :keyword blob: The encryption function of the blob storage service.
        :paramtype blob: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
        :keyword file: The encryption function of the file storage service.
        :paramtype file: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
        :keyword table: The encryption function of the table storage service.
        :paramtype table: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
        :keyword queue: The encryption function of the queue storage service.
        :paramtype queue: ~azure.mgmt.storage.v2022_09_01.models.EncryptionService
        """
        super().__init__(**kwargs)
        self.blob = blob
        self.file = file
        self.table = table
        self.queue = queue


class Endpoints(_serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    :ivar microsoft_endpoints: Gets the microsoft routing storage endpoints.
    :vartype microsoft_endpoints:
     ~azure.mgmt.storage.v2022_09_01.models.StorageAccountMicrosoftEndpoints
    :ivar internet_endpoints: Gets the internet routing storage endpoints.
    :vartype internet_endpoints:
     ~azure.mgmt.storage.v2022_09_01.models.StorageAccountInternetEndpoints
    """

    _validation = {
        "blob": {"readonly": True},
        "queue": {"readonly": True},
        "table": {"readonly": True},
        "file": {"readonly": True},
        "web": {"readonly": True},
        "dfs": {"readonly": True},
    }

    _attribute_map = {
        "blob": {"key": "blob", "type": "str"},
        "queue": {"key": "queue", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "web": {"key": "web", "type": "str"},
        "dfs": {"key": "dfs", "type": "str"},
        "microsoft_endpoints": {"key": "microsoftEndpoints", "type": "StorageAccountMicrosoftEndpoints"},
        "internet_endpoints": {"key": "internetEndpoints", "type": "StorageAccountInternetEndpoints"},
    }

    def __init__(
        self,
        *,
        microsoft_endpoints: Optional["_models.StorageAccountMicrosoftEndpoints"] = None,
        internet_endpoints: Optional["_models.StorageAccountInternetEndpoints"] = None,
        **kwargs
    ):
        """
        :keyword microsoft_endpoints: Gets the microsoft routing storage endpoints.
        :paramtype microsoft_endpoints:
         ~azure.mgmt.storage.v2022_09_01.models.StorageAccountMicrosoftEndpoints
        :keyword internet_endpoints: Gets the internet routing storage endpoints.
        :paramtype internet_endpoints:
         ~azure.mgmt.storage.v2022_09_01.models.StorageAccountInternetEndpoints
        """
        super().__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None
        self.microsoft_endpoints = microsoft_endpoints
        self.internet_endpoints = internet_endpoints


class ErrorResponse(_serialization.Model):
    """An error response from the storage resource provider.

    :ivar error: Azure Storage Resource Provider error response body.
    :vartype error: ~azure.mgmt.storage.v2022_09_01.models.ErrorResponseBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseBody"] = None, **kwargs):
        """
        :keyword error: Azure Storage Resource Provider error response body.
        :paramtype error: ~azure.mgmt.storage.v2022_09_01.models.ErrorResponseBody
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseBody(_serialization.Model):
    """Error response body contract.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class FileServiceItems(_serialization.Model):
    """FileServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file services returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.FileServiceProperties]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FileServiceProperties]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class FileServiceProperties(Resource):
    """The properties of File services in storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
    :ivar cors: Specifies CORS rules for the File service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the File service.
    :vartype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
    :ivar share_delete_retention_policy: The file service properties for share soft delete.
    :vartype share_delete_retention_policy:
     ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
    :ivar protocol_settings: Protocol settings for file service.
    :vartype protocol_settings: ~azure.mgmt.storage.v2022_09_01.models.ProtocolSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "sku": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "cors": {"key": "properties.cors", "type": "CorsRules"},
        "share_delete_retention_policy": {
            "key": "properties.shareDeleteRetentionPolicy",
            "type": "DeleteRetentionPolicy",
        },
        "protocol_settings": {"key": "properties.protocolSettings", "type": "ProtocolSettings"},
    }

    def __init__(
        self,
        *,
        cors: Optional["_models.CorsRules"] = None,
        share_delete_retention_policy: Optional["_models.DeleteRetentionPolicy"] = None,
        protocol_settings: Optional["_models.ProtocolSettings"] = None,
        **kwargs
    ):
        """
        :keyword cors: Specifies CORS rules for the File service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the File service.
        :paramtype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
        :keyword share_delete_retention_policy: The file service properties for share soft delete.
        :paramtype share_delete_retention_policy:
         ~azure.mgmt.storage.v2022_09_01.models.DeleteRetentionPolicy
        :keyword protocol_settings: Protocol settings for file service.
        :paramtype protocol_settings: ~azure.mgmt.storage.v2022_09_01.models.ProtocolSettings
        """
        super().__init__(**kwargs)
        self.sku = None
        self.cors = cors
        self.share_delete_retention_policy = share_delete_retention_policy
        self.protocol_settings = protocol_settings


class FileShare(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """Properties of the file share, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar metadata: A name-value pair to associate with the share as metadata.
    :vartype metadata: dict[str, str]
    :ivar share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
    :vartype share_quota: int
    :ivar enabled_protocols: The authentication protocol that is used for the file share. Can only
     be specified when creating a share. Known values are: "SMB" and "NFS".
    :vartype enabled_protocols: str or ~azure.mgmt.storage.v2022_09_01.models.EnabledProtocols
    :ivar root_squash: The property is for NFS share only. The default is NoRootSquash. Known
     values are: "NoRootSquash", "RootSquash", and "AllSquash".
    :vartype root_squash: str or ~azure.mgmt.storage.v2022_09_01.models.RootSquashType
    :ivar version: The version of the share.
    :vartype version: str
    :ivar deleted: Indicates whether the share was deleted.
    :vartype deleted: bool
    :ivar deleted_time: The deleted time if the share was deleted.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for share that was soft deleted.
    :vartype remaining_retention_days: int
    :ivar access_tier: Access tier for specific share. GpV2 account can choose between
     TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Known
     values are: "TransactionOptimized", "Hot", "Cool", and "Premium".
    :vartype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.ShareAccessTier
    :ivar access_tier_change_time: Indicates the last modification time for share access tier.
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar access_tier_status: Indicates if there is a pending transition for access tier.
    :vartype access_tier_status: str
    :ivar share_usage_bytes: The approximate size of the data stored on the share. Note that this
     value may not include all recently created or recently resized files.
    :vartype share_usage_bytes: int
    :ivar lease_status: The lease status of the share. Known values are: "Locked" and "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseStatus
    :ivar lease_state: Lease state of the share. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a share is of infinite or fixed duration,
     only when the share is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseDuration
    :ivar signed_identifiers: List of stored access policies specified on the share.
    :vartype signed_identifiers: list[~azure.mgmt.storage.v2022_09_01.models.SignedIdentifier]
    :ivar snapshot_time: Creation time of share snapshot returned in the response of list shares
     with expand param "snapshots".
    :vartype snapshot_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "share_quota": {"maximum": 102400, "minimum": 1},
        "version": {"readonly": True},
        "deleted": {"readonly": True},
        "deleted_time": {"readonly": True},
        "remaining_retention_days": {"readonly": True},
        "access_tier_change_time": {"readonly": True},
        "access_tier_status": {"readonly": True},
        "share_usage_bytes": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "snapshot_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "share_quota": {"key": "properties.shareQuota", "type": "int"},
        "enabled_protocols": {"key": "properties.enabledProtocols", "type": "str"},
        "root_squash": {"key": "properties.rootSquash", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "deleted": {"key": "properties.deleted", "type": "bool"},
        "deleted_time": {"key": "properties.deletedTime", "type": "iso-8601"},
        "remaining_retention_days": {"key": "properties.remainingRetentionDays", "type": "int"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "access_tier_change_time": {"key": "properties.accessTierChangeTime", "type": "iso-8601"},
        "access_tier_status": {"key": "properties.accessTierStatus", "type": "str"},
        "share_usage_bytes": {"key": "properties.shareUsageBytes", "type": "int"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "signed_identifiers": {"key": "properties.signedIdentifiers", "type": "[SignedIdentifier]"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        share_quota: Optional[int] = None,
        enabled_protocols: Optional[Union[str, "_models.EnabledProtocols"]] = None,
        root_squash: Optional[Union[str, "_models.RootSquashType"]] = None,
        access_tier: Optional[Union[str, "_models.ShareAccessTier"]] = None,
        signed_identifiers: Optional[List["_models.SignedIdentifier"]] = None,
        **kwargs
    ):
        """
        :keyword metadata: A name-value pair to associate with the share as metadata.
        :paramtype metadata: dict[str, str]
        :keyword share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
         less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
        :paramtype share_quota: int
        :keyword enabled_protocols: The authentication protocol that is used for the file share. Can
         only be specified when creating a share. Known values are: "SMB" and "NFS".
        :paramtype enabled_protocols: str or ~azure.mgmt.storage.v2022_09_01.models.EnabledProtocols
        :keyword root_squash: The property is for NFS share only. The default is NoRootSquash. Known
         values are: "NoRootSquash", "RootSquash", and "AllSquash".
        :paramtype root_squash: str or ~azure.mgmt.storage.v2022_09_01.models.RootSquashType
        :keyword access_tier: Access tier for specific share. GpV2 account can choose between
         TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Known
         values are: "TransactionOptimized", "Hot", "Cool", and "Premium".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.ShareAccessTier
        :keyword signed_identifiers: List of stored access policies specified on the share.
        :paramtype signed_identifiers: list[~azure.mgmt.storage.v2022_09_01.models.SignedIdentifier]
        """
        super().__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota
        self.enabled_protocols = enabled_protocols
        self.root_squash = root_squash
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.access_tier = access_tier
        self.access_tier_change_time = None
        self.access_tier_status = None
        self.share_usage_bytes = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.signed_identifiers = signed_identifiers
        self.snapshot_time = None


class FileShareItem(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """The file share properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar metadata: A name-value pair to associate with the share as metadata.
    :vartype metadata: dict[str, str]
    :ivar share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
    :vartype share_quota: int
    :ivar enabled_protocols: The authentication protocol that is used for the file share. Can only
     be specified when creating a share. Known values are: "SMB" and "NFS".
    :vartype enabled_protocols: str or ~azure.mgmt.storage.v2022_09_01.models.EnabledProtocols
    :ivar root_squash: The property is for NFS share only. The default is NoRootSquash. Known
     values are: "NoRootSquash", "RootSquash", and "AllSquash".
    :vartype root_squash: str or ~azure.mgmt.storage.v2022_09_01.models.RootSquashType
    :ivar version: The version of the share.
    :vartype version: str
    :ivar deleted: Indicates whether the share was deleted.
    :vartype deleted: bool
    :ivar deleted_time: The deleted time if the share was deleted.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for share that was soft deleted.
    :vartype remaining_retention_days: int
    :ivar access_tier: Access tier for specific share. GpV2 account can choose between
     TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Known
     values are: "TransactionOptimized", "Hot", "Cool", and "Premium".
    :vartype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.ShareAccessTier
    :ivar access_tier_change_time: Indicates the last modification time for share access tier.
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar access_tier_status: Indicates if there is a pending transition for access tier.
    :vartype access_tier_status: str
    :ivar share_usage_bytes: The approximate size of the data stored on the share. Note that this
     value may not include all recently created or recently resized files.
    :vartype share_usage_bytes: int
    :ivar lease_status: The lease status of the share. Known values are: "Locked" and "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseStatus
    :ivar lease_state: Lease state of the share. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a share is of infinite or fixed duration,
     only when the share is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseDuration
    :ivar signed_identifiers: List of stored access policies specified on the share.
    :vartype signed_identifiers: list[~azure.mgmt.storage.v2022_09_01.models.SignedIdentifier]
    :ivar snapshot_time: Creation time of share snapshot returned in the response of list shares
     with expand param "snapshots".
    :vartype snapshot_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "share_quota": {"maximum": 102400, "minimum": 1},
        "version": {"readonly": True},
        "deleted": {"readonly": True},
        "deleted_time": {"readonly": True},
        "remaining_retention_days": {"readonly": True},
        "access_tier_change_time": {"readonly": True},
        "access_tier_status": {"readonly": True},
        "share_usage_bytes": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "snapshot_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "share_quota": {"key": "properties.shareQuota", "type": "int"},
        "enabled_protocols": {"key": "properties.enabledProtocols", "type": "str"},
        "root_squash": {"key": "properties.rootSquash", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "deleted": {"key": "properties.deleted", "type": "bool"},
        "deleted_time": {"key": "properties.deletedTime", "type": "iso-8601"},
        "remaining_retention_days": {"key": "properties.remainingRetentionDays", "type": "int"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "access_tier_change_time": {"key": "properties.accessTierChangeTime", "type": "iso-8601"},
        "access_tier_status": {"key": "properties.accessTierStatus", "type": "str"},
        "share_usage_bytes": {"key": "properties.shareUsageBytes", "type": "int"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "signed_identifiers": {"key": "properties.signedIdentifiers", "type": "[SignedIdentifier]"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        share_quota: Optional[int] = None,
        enabled_protocols: Optional[Union[str, "_models.EnabledProtocols"]] = None,
        root_squash: Optional[Union[str, "_models.RootSquashType"]] = None,
        access_tier: Optional[Union[str, "_models.ShareAccessTier"]] = None,
        signed_identifiers: Optional[List["_models.SignedIdentifier"]] = None,
        **kwargs
    ):
        """
        :keyword metadata: A name-value pair to associate with the share as metadata.
        :paramtype metadata: dict[str, str]
        :keyword share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
         less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
        :paramtype share_quota: int
        :keyword enabled_protocols: The authentication protocol that is used for the file share. Can
         only be specified when creating a share. Known values are: "SMB" and "NFS".
        :paramtype enabled_protocols: str or ~azure.mgmt.storage.v2022_09_01.models.EnabledProtocols
        :keyword root_squash: The property is for NFS share only. The default is NoRootSquash. Known
         values are: "NoRootSquash", "RootSquash", and "AllSquash".
        :paramtype root_squash: str or ~azure.mgmt.storage.v2022_09_01.models.RootSquashType
        :keyword access_tier: Access tier for specific share. GpV2 account can choose between
         TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Known
         values are: "TransactionOptimized", "Hot", "Cool", and "Premium".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.ShareAccessTier
        :keyword signed_identifiers: List of stored access policies specified on the share.
        :paramtype signed_identifiers: list[~azure.mgmt.storage.v2022_09_01.models.SignedIdentifier]
        """
        super().__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = metadata
        self.share_quota = share_quota
        self.enabled_protocols = enabled_protocols
        self.root_squash = root_squash
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.access_tier = access_tier
        self.access_tier_change_time = None
        self.access_tier_status = None
        self.share_usage_bytes = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.signed_identifiers = signed_identifiers
        self.snapshot_time = None


class FileShareItems(_serialization.Model):
    """Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next page of shares.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file shares returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.FileShareItem]
    :ivar next_link: Request URL that can be used to query next page of shares. Returned when total
     number of requested shares exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FileShareItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class GeoReplicationStats(_serialization.Model):
    """Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the secondary location. Possible values are: - Live: Indicates that
     the secondary location is active and operational. - Bootstrap: Indicates initial
     synchronization from the primary location to the secondary location is in progress.This
     typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary
     location is temporarily unavailable. Known values are: "Live", "Bootstrap", and "Unavailable".
    :vartype status: str or ~azure.mgmt.storage.v2022_09_01.models.GeoReplicationStatus
    :ivar last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to
     be available for read operations. Primary writes following this point in time may or may not be
     available for reads. Element may be default value if value of LastSyncTime is not available,
     this can happen if secondary is offline or we are in bootstrap.
    :vartype last_sync_time: ~datetime.datetime
    :ivar can_failover: A boolean flag which indicates whether or not account failover is supported
     for the account.
    :vartype can_failover: bool
    """

    _validation = {
        "status": {"readonly": True},
        "last_sync_time": {"readonly": True},
        "can_failover": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "last_sync_time": {"key": "lastSyncTime", "type": "iso-8601"},
        "can_failover": {"key": "canFailover", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.last_sync_time = None
        self.can_failover = None


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Required. Known values are: "None", "SystemAssigned",
     "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.storage.v2022_09_01.models.IdentityType
    :ivar user_assigned_identities: Gets or sets a list of key value pairs that describe the set of
     User Assigned identities that will be used with this storage account. The key is the ARM
     resource identifier of the identity. Only 1 User Assigned identity is permitted here.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storage.v2022_09_01.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Required. Known values are: "None", "SystemAssigned",
         "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.storage.v2022_09_01.models.IdentityType
        :keyword user_assigned_identities: Gets or sets a list of key value pairs that describe the set
         of User Assigned identities that will be used with this storage account. The key is the ARM
         resource identifier of the identity. Only 1 User Assigned identity is permitted here.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.storage.v2022_09_01.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImmutabilityPolicy(AzureEntityResource):
    """The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Known values are: "Locked" and "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2022_09_01.models.ImmutabilityPolicyState
    :ivar allow_protected_append_writes: This property can only be changed for unlocked time-based
     retention policies. When enabled, new blocks can be written to an append blob while maintaining
     immutability protection and compliance. Only new blocks can be added and any existing blocks
     cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
     API.
    :vartype allow_protected_append_writes: bool
    :ivar allow_protected_append_writes_all: This property can only be changed for unlocked
     time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
     Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
     and any existing blocks cannot be modified or deleted. This property cannot be changed with
     ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
     'allowProtectedAppendWritesAll' properties are mutually exclusive.
    :vartype allow_protected_append_writes_all: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "immutability_period_since_creation_in_days": {
            "key": "properties.immutabilityPeriodSinceCreationInDays",
            "type": "int",
        },
        "state": {"key": "properties.state", "type": "str"},
        "allow_protected_append_writes": {"key": "properties.allowProtectedAppendWrites", "type": "bool"},
        "allow_protected_append_writes_all": {"key": "properties.allowProtectedAppendWritesAll", "type": "bool"},
    }

    def __init__(
        self,
        *,
        immutability_period_since_creation_in_days: Optional[int] = None,
        allow_protected_append_writes: Optional[bool] = None,
        allow_protected_append_writes_all: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        :keyword allow_protected_append_writes: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to an append blob while
         maintaining immutability protection and compliance. Only new blocks can be added and any
         existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API.
        :paramtype allow_protected_append_writes: bool
        :keyword allow_protected_append_writes_all: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
         Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
         and any existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
         'allowProtectedAppendWritesAll' properties are mutually exclusive.
        :paramtype allow_protected_append_writes_all: bool
        """
        super().__init__(**kwargs)
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None
        self.allow_protected_append_writes = allow_protected_append_writes
        self.allow_protected_append_writes_all = allow_protected_append_writes_all


class ImmutabilityPolicyProperties(_serialization.Model):
    """The properties of an ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar etag: ImmutabilityPolicy Etag.
    :vartype etag: str
    :ivar update_history: The ImmutabilityPolicy update history of the blob container.
    :vartype update_history: list[~azure.mgmt.storage.v2022_09_01.models.UpdateHistoryProperty]
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Known values are: "Locked" and "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2022_09_01.models.ImmutabilityPolicyState
    :ivar allow_protected_append_writes: This property can only be changed for unlocked time-based
     retention policies. When enabled, new blocks can be written to an append blob while maintaining
     immutability protection and compliance. Only new blocks can be added and any existing blocks
     cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
     API.
    :vartype allow_protected_append_writes: bool
    :ivar allow_protected_append_writes_all: This property can only be changed for unlocked
     time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
     Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
     and any existing blocks cannot be modified or deleted. This property cannot be changed with
     ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
     'allowProtectedAppendWritesAll' properties are mutually exclusive.
    :vartype allow_protected_append_writes_all: bool
    """

    _validation = {
        "etag": {"readonly": True},
        "update_history": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
        "update_history": {"key": "updateHistory", "type": "[UpdateHistoryProperty]"},
        "immutability_period_since_creation_in_days": {
            "key": "properties.immutabilityPeriodSinceCreationInDays",
            "type": "int",
        },
        "state": {"key": "properties.state", "type": "str"},
        "allow_protected_append_writes": {"key": "properties.allowProtectedAppendWrites", "type": "bool"},
        "allow_protected_append_writes_all": {"key": "properties.allowProtectedAppendWritesAll", "type": "bool"},
    }

    def __init__(
        self,
        *,
        immutability_period_since_creation_in_days: Optional[int] = None,
        allow_protected_append_writes: Optional[bool] = None,
        allow_protected_append_writes_all: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword immutability_period_since_creation_in_days: The immutability period for the blobs in
         the container since the policy creation, in days.
        :paramtype immutability_period_since_creation_in_days: int
        :keyword allow_protected_append_writes: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to an append blob while
         maintaining immutability protection and compliance. Only new blocks can be added and any
         existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API.
        :paramtype allow_protected_append_writes: bool
        :keyword allow_protected_append_writes_all: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
         Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
         and any existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
         'allowProtectedAppendWritesAll' properties are mutually exclusive.
        :paramtype allow_protected_append_writes_all: bool
        """
        super().__init__(**kwargs)
        self.etag = None
        self.update_history = None
        self.immutability_period_since_creation_in_days = immutability_period_since_creation_in_days
        self.state = None
        self.allow_protected_append_writes = allow_protected_append_writes
        self.allow_protected_append_writes_all = allow_protected_append_writes_all


class ImmutableStorageAccount(_serialization.Model):
    """This property enables and defines account-level immutability. Enabling the feature auto-enables Blob Versioning.

    :ivar enabled: A boolean flag which enables account-level immutability. All the containers
     under such an account have object-level immutability enabled by default.
    :vartype enabled: bool
    :ivar immutability_policy: Specifies the default account-level immutability policy which is
     inherited and applied to objects that do not possess an explicit immutability policy at the
     object level. The object-level immutability policy has higher precedence than the
     container-level immutability policy, which has a higher precedence than the account-level
     immutability policy.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2022_09_01.models.AccountImmutabilityPolicyProperties
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "immutability_policy": {"key": "immutabilityPolicy", "type": "AccountImmutabilityPolicyProperties"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        immutability_policy: Optional["_models.AccountImmutabilityPolicyProperties"] = None,
        **kwargs
    ):
        """
        :keyword enabled: A boolean flag which enables account-level immutability. All the containers
         under such an account have object-level immutability enabled by default.
        :paramtype enabled: bool
        :keyword immutability_policy: Specifies the default account-level immutability policy which is
         inherited and applied to objects that do not possess an explicit immutability policy at the
         object level. The object-level immutability policy has higher precedence than the
         container-level immutability policy, which has a higher precedence than the account-level
         immutability policy.
        :paramtype immutability_policy:
         ~azure.mgmt.storage.v2022_09_01.models.AccountImmutabilityPolicyProperties
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.immutability_policy = immutability_policy


class ImmutableStorageWithVersioning(_serialization.Model):
    """Object level immutability properties of the container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: This is an immutable property, when set to true it enables object level
     immutability at the container level.
    :vartype enabled: bool
    :ivar time_stamp: Returns the date and time the object level immutability was enabled.
    :vartype time_stamp: ~datetime.datetime
    :ivar migration_state: This property denotes the container level immutability to object level
     immutability migration state. Known values are: "InProgress" and "Completed".
    :vartype migration_state: str or ~azure.mgmt.storage.v2022_09_01.models.MigrationState
    """

    _validation = {
        "time_stamp": {"readonly": True},
        "migration_state": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "migration_state": {"key": "migrationState", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: This is an immutable property, when set to true it enables object level
         immutability at the container level.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.time_stamp = None
        self.migration_state = None


class IPRule(_serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
     allowed. Required.
    :vartype ip_address_or_range: str
    :ivar action: The action of IP ACL rule. Default value is "Allow".
    :vartype action: str
    """

    _validation = {
        "ip_address_or_range": {"required": True},
    }

    _attribute_map = {
        "ip_address_or_range": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, ip_address_or_range: str, action: Optional[Literal["Allow"]] = None, **kwargs):
        """
        :keyword ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
         allowed. Required.
        :paramtype ip_address_or_range: str
        :keyword action: The action of IP ACL rule. Default value is "Allow".
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.ip_address_or_range = ip_address_or_range
        self.action = action


class KeyCreationTime(_serialization.Model):
    """Storage account keys creation time.

    :ivar key1:
    :vartype key1: ~datetime.datetime
    :ivar key2:
    :vartype key2: ~datetime.datetime
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "iso-8601"},
        "key2": {"key": "key2", "type": "iso-8601"},
    }

    def __init__(self, *, key1: Optional[datetime.datetime] = None, key2: Optional[datetime.datetime] = None, **kwargs):
        """
        :keyword key1:
        :paramtype key1: ~datetime.datetime
        :keyword key2:
        :paramtype key2: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class KeyPolicy(_serialization.Model):
    """KeyPolicy assigned to the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar key_expiration_period_in_days: The key expiration period in days. Required.
    :vartype key_expiration_period_in_days: int
    """

    _validation = {
        "key_expiration_period_in_days": {"required": True},
    }

    _attribute_map = {
        "key_expiration_period_in_days": {"key": "keyExpirationPeriodInDays", "type": "int"},
    }

    def __init__(self, *, key_expiration_period_in_days: int, **kwargs):
        """
        :keyword key_expiration_period_in_days: The key expiration period in days. Required.
        :paramtype key_expiration_period_in_days: int
        """
        super().__init__(**kwargs)
        self.key_expiration_period_in_days = key_expiration_period_in_days


class KeyVaultProperties(_serialization.Model):
    """Properties of key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar current_versioned_key_expiration_timestamp: This is a read only property that represents
     the expiration time of the current version of the customer managed key used for encryption.
    :vartype current_versioned_key_expiration_timestamp: ~datetime.datetime
    """

    _validation = {
        "current_versioned_key_identifier": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
        "current_versioned_key_expiration_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyname", "type": "str"},
        "key_version": {"key": "keyversion", "type": "str"},
        "key_vault_uri": {"key": "keyvaulturi", "type": "str"},
        "current_versioned_key_identifier": {"key": "currentVersionedKeyIdentifier", "type": "str"},
        "last_key_rotation_timestamp": {"key": "lastKeyRotationTimestamp", "type": "iso-8601"},
        "current_versioned_key_expiration_timestamp": {
            "key": "currentVersionedKeyExpirationTimestamp",
            "type": "iso-8601",
        },
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None
        self.current_versioned_key_expiration_timestamp = None


class LastAccessTimeTrackingPolicy(_serialization.Model):
    """The blob service properties for Last access time based tracking policy.

    All required parameters must be populated in order to send to Azure.

    :ivar enable: When set to true last access time based tracking is enabled. Required.
    :vartype enable: bool
    :ivar name: Name of the policy. The valid value is AccessTimeTracking. This field is currently
     read only. "AccessTimeTracking"
    :vartype name: str or ~azure.mgmt.storage.v2022_09_01.models.Name
    :ivar tracking_granularity_in_days: The field specifies blob object tracking granularity in
     days, typically how often the blob object should be tracked.This field is currently read only
     with value as 1.
    :vartype tracking_granularity_in_days: int
    :ivar blob_type: An array of predefined supported blob types. Only blockBlob is the supported
     value. This field is currently read only.
    :vartype blob_type: list[str]
    """

    _validation = {
        "enable": {"required": True},
    }

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "tracking_granularity_in_days": {"key": "trackingGranularityInDays", "type": "int"},
        "blob_type": {"key": "blobType", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enable: bool,
        name: Optional[Union[str, "_models.Name"]] = None,
        tracking_granularity_in_days: Optional[int] = None,
        blob_type: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword enable: When set to true last access time based tracking is enabled. Required.
        :paramtype enable: bool
        :keyword name: Name of the policy. The valid value is AccessTimeTracking. This field is
         currently read only. "AccessTimeTracking"
        :paramtype name: str or ~azure.mgmt.storage.v2022_09_01.models.Name
        :keyword tracking_granularity_in_days: The field specifies blob object tracking granularity in
         days, typically how often the blob object should be tracked.This field is currently read only
         with value as 1.
        :paramtype tracking_granularity_in_days: int
        :keyword blob_type: An array of predefined supported blob types. Only blockBlob is the
         supported value. This field is currently read only.
        :paramtype blob_type: list[str]
        """
        super().__init__(**kwargs)
        self.enable = enable
        self.name = name
        self.tracking_granularity_in_days = tracking_granularity_in_days
        self.blob_type = blob_type


class LeaseContainerRequest(_serialization.Model):
    """Lease Container request schema.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Specifies the lease action. Can be one of the available actions. Required. Known
     values are: "Acquire", "Renew", "Change", "Release", and "Break".
    :vartype action: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseContainerRequestEnum
    :ivar lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :vartype lease_id: str
    :ivar break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :vartype break_period: int
    :ivar lease_duration: Required for acquire. Specifies the duration of the lease, in seconds, or
     negative one (-1) for a lease that never expires.
    :vartype lease_duration: int
    :ivar proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :vartype proposed_lease_id: str
    """

    _validation = {
        "action": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "lease_id": {"key": "leaseId", "type": "str"},
        "break_period": {"key": "breakPeriod", "type": "int"},
        "lease_duration": {"key": "leaseDuration", "type": "int"},
        "proposed_lease_id": {"key": "proposedLeaseId", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.LeaseContainerRequestEnum"],
        lease_id: Optional[str] = None,
        break_period: Optional[int] = None,
        lease_duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action: Specifies the lease action. Can be one of the available actions. Required.
         Known values are: "Acquire", "Renew", "Change", "Release", and "Break".
        :paramtype action: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseContainerRequestEnum
        :keyword lease_id: Identifies the lease. Can be specified in any valid GUID string format.
        :paramtype lease_id: str
        :keyword break_period: Optional. For a break action, proposed duration the lease should
         continue before it is broken, in seconds, between 0 and 60.
        :paramtype break_period: int
        :keyword lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
         or negative one (-1) for a lease that never expires.
        :paramtype lease_duration: int
        :keyword proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
         GUID string format.
        :paramtype proposed_lease_id: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.lease_id = lease_id
        self.break_period = break_period
        self.lease_duration = lease_duration
        self.proposed_lease_id = proposed_lease_id


class LeaseContainerResponse(_serialization.Model):
    """Lease Container response schema.

    :ivar lease_id: Returned unique lease ID that must be included with any request to delete the
     container, or to renew, change, or release the lease.
    :vartype lease_id: str
    :ivar lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :vartype lease_time_seconds: str
    """

    _attribute_map = {
        "lease_id": {"key": "leaseId", "type": "str"},
        "lease_time_seconds": {"key": "leaseTimeSeconds", "type": "str"},
    }

    def __init__(self, *, lease_id: Optional[str] = None, lease_time_seconds: Optional[str] = None, **kwargs):
        """
        :keyword lease_id: Returned unique lease ID that must be included with any request to delete
         the container, or to renew, change, or release the lease.
        :paramtype lease_id: str
        :keyword lease_time_seconds: Approximate time remaining in the lease period, in seconds.
        :paramtype lease_time_seconds: str
        """
        super().__init__(**kwargs)
        self.lease_id = lease_id
        self.lease_time_seconds = lease_time_seconds


class LeaseShareRequest(_serialization.Model):
    """Lease Share request schema.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Specifies the lease action. Can be one of the available actions. Required. Known
     values are: "Acquire", "Renew", "Change", "Release", and "Break".
    :vartype action: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseShareAction
    :ivar lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :vartype lease_id: str
    :ivar break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :vartype break_period: int
    :ivar lease_duration: Required for acquire. Specifies the duration of the lease, in seconds, or
     negative one (-1) for a lease that never expires.
    :vartype lease_duration: int
    :ivar proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :vartype proposed_lease_id: str
    """

    _validation = {
        "action": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "lease_id": {"key": "leaseId", "type": "str"},
        "break_period": {"key": "breakPeriod", "type": "int"},
        "lease_duration": {"key": "leaseDuration", "type": "int"},
        "proposed_lease_id": {"key": "proposedLeaseId", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.LeaseShareAction"],
        lease_id: Optional[str] = None,
        break_period: Optional[int] = None,
        lease_duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action: Specifies the lease action. Can be one of the available actions. Required.
         Known values are: "Acquire", "Renew", "Change", "Release", and "Break".
        :paramtype action: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseShareAction
        :keyword lease_id: Identifies the lease. Can be specified in any valid GUID string format.
        :paramtype lease_id: str
        :keyword break_period: Optional. For a break action, proposed duration the lease should
         continue before it is broken, in seconds, between 0 and 60.
        :paramtype break_period: int
        :keyword lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
         or negative one (-1) for a lease that never expires.
        :paramtype lease_duration: int
        :keyword proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
         GUID string format.
        :paramtype proposed_lease_id: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.lease_id = lease_id
        self.break_period = break_period
        self.lease_duration = lease_duration
        self.proposed_lease_id = proposed_lease_id


class LeaseShareResponse(_serialization.Model):
    """Lease Share response schema.

    :ivar lease_id: Returned unique lease ID that must be included with any request to delete the
     share, or to renew, change, or release the lease.
    :vartype lease_id: str
    :ivar lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :vartype lease_time_seconds: str
    """

    _attribute_map = {
        "lease_id": {"key": "leaseId", "type": "str"},
        "lease_time_seconds": {"key": "leaseTimeSeconds", "type": "str"},
    }

    def __init__(self, *, lease_id: Optional[str] = None, lease_time_seconds: Optional[str] = None, **kwargs):
        """
        :keyword lease_id: Returned unique lease ID that must be included with any request to delete
         the share, or to renew, change, or release the lease.
        :paramtype lease_id: str
        :keyword lease_time_seconds: Approximate time remaining in the lease period, in seconds.
        :paramtype lease_time_seconds: str
        """
        super().__init__(**kwargs)
        self.lease_id = lease_id
        self.lease_time_seconds = lease_time_seconds


class LegalHold(_serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case
     at SRP. Required.
    :vartype tags: list[str]
    :ivar allow_protected_append_writes_all: When enabled, new blocks can be written to both
     'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks
     can be added and any existing blocks cannot be modified or deleted.
    :vartype allow_protected_append_writes_all: bool
    """

    _validation = {
        "has_legal_hold": {"readonly": True},
        "tags": {"required": True},
    }

    _attribute_map = {
        "has_legal_hold": {"key": "hasLegalHold", "type": "bool"},
        "tags": {"key": "tags", "type": "[str]"},
        "allow_protected_append_writes_all": {"key": "allowProtectedAppendWritesAll", "type": "bool"},
    }

    def __init__(self, *, tags: List[str], allow_protected_append_writes_all: Optional[bool] = None, **kwargs):
        """
        :keyword tags: Each tag should be 3 to 23 alphanumeric characters and is normalized to lower
         case at SRP. Required.
        :paramtype tags: list[str]
        :keyword allow_protected_append_writes_all: When enabled, new blocks can be written to both
         'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks
         can be added and any existing blocks cannot be modified or deleted.
        :paramtype allow_protected_append_writes_all: bool
        """
        super().__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags
        self.allow_protected_append_writes_all = allow_protected_append_writes_all


class LegalHoldProperties(_serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar tags: The list of LegalHold tags of a blob container.
    :vartype tags: list[~azure.mgmt.storage.v2022_09_01.models.TagProperty]
    :ivar protected_append_writes_history: Protected append blob writes history.
    :vartype protected_append_writes_history:
     ~azure.mgmt.storage.v2022_09_01.models.ProtectedAppendWritesHistory
    """

    _validation = {
        "has_legal_hold": {"readonly": True},
    }

    _attribute_map = {
        "has_legal_hold": {"key": "hasLegalHold", "type": "bool"},
        "tags": {"key": "tags", "type": "[TagProperty]"},
        "protected_append_writes_history": {
            "key": "protectedAppendWritesHistory",
            "type": "ProtectedAppendWritesHistory",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[List["_models.TagProperty"]] = None,
        protected_append_writes_history: Optional["_models.ProtectedAppendWritesHistory"] = None,
        **kwargs
    ):
        """
        :keyword tags: The list of LegalHold tags of a blob container.
        :paramtype tags: list[~azure.mgmt.storage.v2022_09_01.models.TagProperty]
        :keyword protected_append_writes_history: Protected append blob writes history.
        :paramtype protected_append_writes_history:
         ~azure.mgmt.storage.v2022_09_01.models.ProtectedAppendWritesHistory
        """
        super().__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = tags
        self.protected_append_writes_history = protected_append_writes_history


class ListAccountSasResponse(_serialization.Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        "account_sas_token": {"readonly": True},
    }

    _attribute_map = {
        "account_sas_token": {"key": "accountSasToken", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.account_sas_token = None


class ListBlobInventoryPolicy(_serialization.Model):
    """List of blob inventory policies returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blob inventory policies.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.BlobInventoryPolicy]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BlobInventoryPolicy]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class ListContainerItem(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """The blob container properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar version: The version of the deleted blob container.
    :vartype version: str
    :ivar deleted: Indicates whether the blob container was deleted.
    :vartype deleted: bool
    :ivar deleted_time: Blob container deletion time.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for soft deleted blob container.
    :vartype remaining_retention_days: int
    :ivar default_encryption_scope: Default the container to use specified encryption scope for all
     writes.
    :vartype default_encryption_scope: str
    :ivar deny_encryption_scope_override: Block override of encryption scope from the container
     default.
    :vartype deny_encryption_scope_override: bool
    :ivar public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Known values are: "Container", "Blob", and "None".
    :vartype public_access: str or ~azure.mgmt.storage.v2022_09_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Known values are: "Locked" and
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Known values are: "Available", "Leased",
     "Expired", "Breaking", and "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Known values are: "Infinite" and "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2022_09_01.models.LeaseDuration
    :ivar metadata: A name-value pair to associate with the container as metadata.
    :vartype metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2022_09_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    :ivar immutable_storage_with_versioning: The object level immutability property of the
     container. The property is immutable and can only be set to true at the container creation
     time. Existing containers must undergo a migration process.
    :vartype immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageWithVersioning
    :ivar enable_nfs_v3_root_squash: Enable NFSv3 root squash on blob container.
    :vartype enable_nfs_v3_root_squash: bool
    :ivar enable_nfs_v3_all_squash: Enable NFSv3 all squash on blob container.
    :vartype enable_nfs_v3_all_squash: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "version": {"readonly": True},
        "deleted": {"readonly": True},
        "deleted_time": {"readonly": True},
        "remaining_retention_days": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "lease_status": {"readonly": True},
        "lease_state": {"readonly": True},
        "lease_duration": {"readonly": True},
        "immutability_policy": {"readonly": True},
        "legal_hold": {"readonly": True},
        "has_legal_hold": {"readonly": True},
        "has_immutability_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "deleted": {"key": "properties.deleted", "type": "bool"},
        "deleted_time": {"key": "properties.deletedTime", "type": "iso-8601"},
        "remaining_retention_days": {"key": "properties.remainingRetentionDays", "type": "int"},
        "default_encryption_scope": {"key": "properties.defaultEncryptionScope", "type": "str"},
        "deny_encryption_scope_override": {"key": "properties.denyEncryptionScopeOverride", "type": "bool"},
        "public_access": {"key": "properties.publicAccess", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "lease_status": {"key": "properties.leaseStatus", "type": "str"},
        "lease_state": {"key": "properties.leaseState", "type": "str"},
        "lease_duration": {"key": "properties.leaseDuration", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "immutability_policy": {"key": "properties.immutabilityPolicy", "type": "ImmutabilityPolicyProperties"},
        "legal_hold": {"key": "properties.legalHold", "type": "LegalHoldProperties"},
        "has_legal_hold": {"key": "properties.hasLegalHold", "type": "bool"},
        "has_immutability_policy": {"key": "properties.hasImmutabilityPolicy", "type": "bool"},
        "immutable_storage_with_versioning": {
            "key": "properties.immutableStorageWithVersioning",
            "type": "ImmutableStorageWithVersioning",
        },
        "enable_nfs_v3_root_squash": {"key": "properties.enableNfsV3RootSquash", "type": "bool"},
        "enable_nfs_v3_all_squash": {"key": "properties.enableNfsV3AllSquash", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default_encryption_scope: Optional[str] = None,
        deny_encryption_scope_override: Optional[bool] = None,
        public_access: Optional[Union[str, "_models.PublicAccess"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        immutable_storage_with_versioning: Optional["_models.ImmutableStorageWithVersioning"] = None,
        enable_nfs_v3_root_squash: Optional[bool] = None,
        enable_nfs_v3_all_squash: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword default_encryption_scope: Default the container to use specified encryption scope for
         all writes.
        :paramtype default_encryption_scope: str
        :keyword deny_encryption_scope_override: Block override of encryption scope from the container
         default.
        :paramtype deny_encryption_scope_override: bool
        :keyword public_access: Specifies whether data in the container may be accessed publicly and
         the level of access. Known values are: "Container", "Blob", and "None".
        :paramtype public_access: str or ~azure.mgmt.storage.v2022_09_01.models.PublicAccess
        :keyword metadata: A name-value pair to associate with the container as metadata.
        :paramtype metadata: dict[str, str]
        :keyword immutable_storage_with_versioning: The object level immutability property of the
         container. The property is immutable and can only be set to true at the container creation
         time. Existing containers must undergo a migration process.
        :paramtype immutable_storage_with_versioning:
         ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageWithVersioning
        :keyword enable_nfs_v3_root_squash: Enable NFSv3 root squash on blob container.
        :paramtype enable_nfs_v3_root_squash: bool
        :keyword enable_nfs_v3_all_squash: Enable NFSv3 all squash on blob container.
        :paramtype enable_nfs_v3_all_squash: bool
        """
        super().__init__(**kwargs)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.default_encryption_scope = default_encryption_scope
        self.deny_encryption_scope_override = deny_encryption_scope_override
        self.public_access = public_access
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = metadata
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None
        self.immutable_storage_with_versioning = immutable_storage_with_versioning
        self.enable_nfs_v3_root_squash = enable_nfs_v3_root_squash
        self.enable_nfs_v3_all_squash = enable_nfs_v3_all_squash


class ListContainerItems(_serialization.Model):
    """Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to next page of containers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blobs containers returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.ListContainerItem]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ListContainerItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListQueue(Resource):
    """ListQueue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar metadata: A name-value pair that represents queue metadata.
    :vartype metadata: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
    }

    def __init__(self, *, metadata: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword metadata: A name-value pair that represents queue metadata.
        :paramtype metadata: dict[str, str]
        """
        super().__init__(**kwargs)
        self.metadata = metadata


class ListQueueResource(_serialization.Model):
    """Response schema. Contains list of queues returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of queues returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.ListQueue]
    :ivar next_link: Request URL that can be used to list next page of queues.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ListQueue]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListQueueServices(_serialization.Model):
    """ListQueueServices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of queue services returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.QueueServiceProperties]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[QueueServiceProperties]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class ListServiceSasResponse(_serialization.Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_sas_token: List service SAS credentials of specific resource.
    :vartype service_sas_token: str
    """

    _validation = {
        "service_sas_token": {"readonly": True},
    }

    _attribute_map = {
        "service_sas_token": {"key": "serviceSasToken", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.service_sas_token = None


class ListTableResource(_serialization.Model):
    """Response schema. Contains list of tables returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of tables returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.Table]
    :ivar next_link: Request URL that can be used to query next page of tables.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Table]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListTableServices(_serialization.Model):
    """ListTableServices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of table services returned.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.TableServiceProperties]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TableServiceProperties]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class LocalUser(Resource):  # pylint: disable=too-many-instance-attributes
    """The local user associated with the storage accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.storage.v2022_09_01.models.SystemData
    :ivar permission_scopes: The permission scopes of the local user.
    :vartype permission_scopes: list[~azure.mgmt.storage.v2022_09_01.models.PermissionScope]
    :ivar home_directory: Optional, local user home directory.
    :vartype home_directory: str
    :ivar ssh_authorized_keys: Optional, local user ssh authorized keys for SFTP.
    :vartype ssh_authorized_keys: list[~azure.mgmt.storage.v2022_09_01.models.SshPublicKey]
    :ivar sid: A unique Security Identifier that is generated by the server.
    :vartype sid: str
    :ivar has_shared_key: Indicates whether shared key exists. Set it to false to remove existing
     shared key.
    :vartype has_shared_key: bool
    :ivar has_ssh_key: Indicates whether ssh key exists. Set it to false to remove existing SSH
     key.
    :vartype has_ssh_key: bool
    :ivar has_ssh_password: Indicates whether ssh password exists. Set it to false to remove
     existing SSH password.
    :vartype has_ssh_password: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "permission_scopes": {"key": "properties.permissionScopes", "type": "[PermissionScope]"},
        "home_directory": {"key": "properties.homeDirectory", "type": "str"},
        "ssh_authorized_keys": {"key": "properties.sshAuthorizedKeys", "type": "[SshPublicKey]"},
        "sid": {"key": "properties.sid", "type": "str"},
        "has_shared_key": {"key": "properties.hasSharedKey", "type": "bool"},
        "has_ssh_key": {"key": "properties.hasSshKey", "type": "bool"},
        "has_ssh_password": {"key": "properties.hasSshPassword", "type": "bool"},
    }

    def __init__(
        self,
        *,
        permission_scopes: Optional[List["_models.PermissionScope"]] = None,
        home_directory: Optional[str] = None,
        ssh_authorized_keys: Optional[List["_models.SshPublicKey"]] = None,
        has_shared_key: Optional[bool] = None,
        has_ssh_key: Optional[bool] = None,
        has_ssh_password: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword permission_scopes: The permission scopes of the local user.
        :paramtype permission_scopes: list[~azure.mgmt.storage.v2022_09_01.models.PermissionScope]
        :keyword home_directory: Optional, local user home directory.
        :paramtype home_directory: str
        :keyword ssh_authorized_keys: Optional, local user ssh authorized keys for SFTP.
        :paramtype ssh_authorized_keys: list[~azure.mgmt.storage.v2022_09_01.models.SshPublicKey]
        :keyword has_shared_key: Indicates whether shared key exists. Set it to false to remove
         existing shared key.
        :paramtype has_shared_key: bool
        :keyword has_ssh_key: Indicates whether ssh key exists. Set it to false to remove existing SSH
         key.
        :paramtype has_ssh_key: bool
        :keyword has_ssh_password: Indicates whether ssh password exists. Set it to false to remove
         existing SSH password.
        :paramtype has_ssh_password: bool
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.permission_scopes = permission_scopes
        self.home_directory = home_directory
        self.ssh_authorized_keys = ssh_authorized_keys
        self.sid = None
        self.has_shared_key = has_shared_key
        self.has_ssh_key = has_ssh_key
        self.has_ssh_password = has_ssh_password


class LocalUserKeys(_serialization.Model):
    """The Storage Account Local User keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_authorized_keys: Optional, local user ssh authorized keys for SFTP.
    :vartype ssh_authorized_keys: list[~azure.mgmt.storage.v2022_09_01.models.SshPublicKey]
    :ivar shared_key: Auto generated by the server for SMB authentication.
    :vartype shared_key: str
    """

    _validation = {
        "shared_key": {"readonly": True},
    }

    _attribute_map = {
        "ssh_authorized_keys": {"key": "sshAuthorizedKeys", "type": "[SshPublicKey]"},
        "shared_key": {"key": "sharedKey", "type": "str"},
    }

    def __init__(self, *, ssh_authorized_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs):
        """
        :keyword ssh_authorized_keys: Optional, local user ssh authorized keys for SFTP.
        :paramtype ssh_authorized_keys: list[~azure.mgmt.storage.v2022_09_01.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.ssh_authorized_keys = ssh_authorized_keys
        self.shared_key = None


class LocalUserRegeneratePasswordResult(_serialization.Model):
    """The secrets of Storage Account Local User.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_password: Auto generated password by the server for SSH authentication if
     hasSshPassword is set to true on the creation of local user.
    :vartype ssh_password: str
    """

    _validation = {
        "ssh_password": {"readonly": True},
    }

    _attribute_map = {
        "ssh_password": {"key": "sshPassword", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.ssh_password = None


class LocalUsers(_serialization.Model):
    """List storage account local users.

    :ivar value: The local users associated with the storage account.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.LocalUser]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalUser]"},
    }

    def __init__(self, *, value: Optional[List["_models.LocalUser"]] = None, **kwargs):
        """
        :keyword value: The local users associated with the storage account.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.LocalUser]
        """
        super().__init__(**kwargs)
        self.value = value


class ManagementPolicy(Resource):
    """The Get Storage Account ManagementPolicies operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_modified_time: Returns the date and time the ManagementPolicies was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar policy: The Storage Account ManagementPolicy, in JSON format. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :vartype policy: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicySchema
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "policy": {"key": "properties.policy", "type": "ManagementPolicySchema"},
    }

    def __init__(self, *, policy: Optional["_models.ManagementPolicySchema"] = None, **kwargs):
        """
        :keyword policy: The Storage Account ManagementPolicy, in JSON format. See more details in:
         https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :paramtype policy: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicySchema
        """
        super().__init__(**kwargs)
        self.last_modified_time = None
        self.policy = policy


class ManagementPolicyAction(_serialization.Model):
    """Actions are applied to the filtered blobs when the execution condition is met.

    :ivar base_blob: The management policy action for base blob.
    :vartype base_blob: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyBaseBlob
    :ivar snapshot: The management policy action for snapshot.
    :vartype snapshot: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicySnapShot
    :ivar version: The management policy action for version.
    :vartype version: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyVersion
    """

    _attribute_map = {
        "base_blob": {"key": "baseBlob", "type": "ManagementPolicyBaseBlob"},
        "snapshot": {"key": "snapshot", "type": "ManagementPolicySnapShot"},
        "version": {"key": "version", "type": "ManagementPolicyVersion"},
    }

    def __init__(
        self,
        *,
        base_blob: Optional["_models.ManagementPolicyBaseBlob"] = None,
        snapshot: Optional["_models.ManagementPolicySnapShot"] = None,
        version: Optional["_models.ManagementPolicyVersion"] = None,
        **kwargs
    ):
        """
        :keyword base_blob: The management policy action for base blob.
        :paramtype base_blob: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyBaseBlob
        :keyword snapshot: The management policy action for snapshot.
        :paramtype snapshot: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicySnapShot
        :keyword version: The management policy action for version.
        :paramtype version: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyVersion
        """
        super().__init__(**kwargs)
        self.base_blob = base_blob
        self.snapshot = snapshot
        self.version = version


class ManagementPolicyBaseBlob(_serialization.Model):
    """Management policy action for base blob.

    :ivar tier_to_cool: The function to tier blobs to cool storage.
    :vartype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
    :ivar tier_to_archive: The function to tier blobs to archive storage.
    :vartype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
    :ivar tier_to_cold: The function to tier blobs to cold storage.
    :vartype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
    :ivar tier_to_hot: The function to tier blobs to hot storage. This action can only be used with
     Premium Block Blob Storage Accounts.
    :vartype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
    :ivar delete: The function to delete the blob.
    :vartype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
    :ivar enable_auto_tier_to_hot_from_cool: This property enables auto tiering of a blob from cool
     to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
    :vartype enable_auto_tier_to_hot_from_cool: bool
    """

    _attribute_map = {
        "tier_to_cool": {"key": "tierToCool", "type": "DateAfterModification"},
        "tier_to_archive": {"key": "tierToArchive", "type": "DateAfterModification"},
        "tier_to_cold": {"key": "tierToCold", "type": "DateAfterModification"},
        "tier_to_hot": {"key": "tierToHot", "type": "DateAfterModification"},
        "delete": {"key": "delete", "type": "DateAfterModification"},
        "enable_auto_tier_to_hot_from_cool": {"key": "enableAutoTierToHotFromCool", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tier_to_cool: Optional["_models.DateAfterModification"] = None,
        tier_to_archive: Optional["_models.DateAfterModification"] = None,
        tier_to_cold: Optional["_models.DateAfterModification"] = None,
        tier_to_hot: Optional["_models.DateAfterModification"] = None,
        delete: Optional["_models.DateAfterModification"] = None,
        enable_auto_tier_to_hot_from_cool: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tier_to_cool: The function to tier blobs to cool storage.
        :paramtype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
        :keyword tier_to_archive: The function to tier blobs to archive storage.
        :paramtype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
        :keyword tier_to_cold: The function to tier blobs to cold storage.
        :paramtype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
        :keyword tier_to_hot: The function to tier blobs to hot storage. This action can only be used
         with Premium Block Blob Storage Accounts.
        :paramtype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
        :keyword delete: The function to delete the blob.
        :paramtype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterModification
        :keyword enable_auto_tier_to_hot_from_cool: This property enables auto tiering of a blob from
         cool to hot on a blob access. This property requires
         tierToCool.daysAfterLastAccessTimeGreaterThan.
        :paramtype enable_auto_tier_to_hot_from_cool: bool
        """
        super().__init__(**kwargs)
        self.tier_to_cool = tier_to_cool
        self.tier_to_archive = tier_to_archive
        self.tier_to_cold = tier_to_cold
        self.tier_to_hot = tier_to_hot
        self.delete = delete
        self.enable_auto_tier_to_hot_from_cool = enable_auto_tier_to_hot_from_cool


class ManagementPolicyDefinition(_serialization.Model):
    """An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.

    All required parameters must be populated in order to send to Azure.

    :ivar actions: An object that defines the action set. Required.
    :vartype actions: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyAction
    :ivar filters: An object that defines the filter set.
    :vartype filters: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyFilter
    """

    _validation = {
        "actions": {"required": True},
    }

    _attribute_map = {
        "actions": {"key": "actions", "type": "ManagementPolicyAction"},
        "filters": {"key": "filters", "type": "ManagementPolicyFilter"},
    }

    def __init__(
        self,
        *,
        actions: "_models.ManagementPolicyAction",
        filters: Optional["_models.ManagementPolicyFilter"] = None,
        **kwargs
    ):
        """
        :keyword actions: An object that defines the action set. Required.
        :paramtype actions: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyAction
        :keyword filters: An object that defines the filter set.
        :paramtype filters: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyFilter
        """
        super().__init__(**kwargs)
        self.actions = actions
        self.filters = filters


class ManagementPolicyFilter(_serialization.Model):
    """Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.

    All required parameters must be populated in order to send to Azure.

    :ivar prefix_match: An array of strings for prefixes to be match.
    :vartype prefix_match: list[str]
    :ivar blob_types: An array of predefined enum values. Currently blockBlob supports all tiering
     and delete actions. Only delete actions are supported for appendBlob. Required.
    :vartype blob_types: list[str]
    :ivar blob_index_match: An array of blob index tag based filters, there can be at most 10 tag
     filters.
    :vartype blob_index_match: list[~azure.mgmt.storage.v2022_09_01.models.TagFilter]
    """

    _validation = {
        "blob_types": {"required": True},
    }

    _attribute_map = {
        "prefix_match": {"key": "prefixMatch", "type": "[str]"},
        "blob_types": {"key": "blobTypes", "type": "[str]"},
        "blob_index_match": {"key": "blobIndexMatch", "type": "[TagFilter]"},
    }

    def __init__(
        self,
        *,
        blob_types: List[str],
        prefix_match: Optional[List[str]] = None,
        blob_index_match: Optional[List["_models.TagFilter"]] = None,
        **kwargs
    ):
        """
        :keyword prefix_match: An array of strings for prefixes to be match.
        :paramtype prefix_match: list[str]
        :keyword blob_types: An array of predefined enum values. Currently blockBlob supports all
         tiering and delete actions. Only delete actions are supported for appendBlob. Required.
        :paramtype blob_types: list[str]
        :keyword blob_index_match: An array of blob index tag based filters, there can be at most 10
         tag filters.
        :paramtype blob_index_match: list[~azure.mgmt.storage.v2022_09_01.models.TagFilter]
        """
        super().__init__(**kwargs)
        self.prefix_match = prefix_match
        self.blob_types = blob_types
        self.blob_index_match = blob_index_match


class ManagementPolicyRule(_serialization.Model):
    """An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Rule is enabled if set to true.
    :vartype enabled: bool
    :ivar name: A rule name can contain any combination of alpha numeric characters. Rule name is
     case-sensitive. It must be unique within a policy. Required.
    :vartype name: str
    :ivar type: The valid value is Lifecycle. Required. "Lifecycle"
    :vartype type: str or ~azure.mgmt.storage.v2022_09_01.models.RuleType
    :ivar definition: An object that defines the Lifecycle rule. Required.
    :vartype definition: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyDefinition
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "definition": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "definition": {"key": "definition", "type": "ManagementPolicyDefinition"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.RuleType"],
        definition: "_models.ManagementPolicyDefinition",
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: Rule is enabled if set to true.
        :paramtype enabled: bool
        :keyword name: A rule name can contain any combination of alpha numeric characters. Rule name
         is case-sensitive. It must be unique within a policy. Required.
        :paramtype name: str
        :keyword type: The valid value is Lifecycle. Required. "Lifecycle"
        :paramtype type: str or ~azure.mgmt.storage.v2022_09_01.models.RuleType
        :keyword definition: An object that defines the Lifecycle rule. Required.
        :paramtype definition: ~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyDefinition
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.name = name
        self.type = type
        self.definition = definition


class ManagementPolicySchema(_serialization.Model):
    """The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    All required parameters must be populated in order to send to Azure.

    :ivar rules: The Storage Account ManagementPolicies Rules. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     Required.
    :vartype rules: list[~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyRule]
    """

    _validation = {
        "rules": {"required": True},
    }

    _attribute_map = {
        "rules": {"key": "rules", "type": "[ManagementPolicyRule]"},
    }

    def __init__(self, *, rules: List["_models.ManagementPolicyRule"], **kwargs):
        """
        :keyword rules: The Storage Account ManagementPolicies Rules. See more details in:
         https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
         Required.
        :paramtype rules: list[~azure.mgmt.storage.v2022_09_01.models.ManagementPolicyRule]
        """
        super().__init__(**kwargs)
        self.rules = rules


class ManagementPolicySnapShot(_serialization.Model):
    """Management policy action for snapshot.

    :ivar tier_to_cool: The function to tier blob snapshot to cool storage.
    :vartype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_archive: The function to tier blob snapshot to archive storage.
    :vartype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_cold: The function to tier blobs to cold storage.
    :vartype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_hot: The function to tier blobs to hot storage. This action can only be used with
     Premium Block Blob Storage Accounts.
    :vartype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar delete: The function to delete the blob snapshot.
    :vartype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    """

    _attribute_map = {
        "tier_to_cool": {"key": "tierToCool", "type": "DateAfterCreation"},
        "tier_to_archive": {"key": "tierToArchive", "type": "DateAfterCreation"},
        "tier_to_cold": {"key": "tierToCold", "type": "DateAfterCreation"},
        "tier_to_hot": {"key": "tierToHot", "type": "DateAfterCreation"},
        "delete": {"key": "delete", "type": "DateAfterCreation"},
    }

    def __init__(
        self,
        *,
        tier_to_cool: Optional["_models.DateAfterCreation"] = None,
        tier_to_archive: Optional["_models.DateAfterCreation"] = None,
        tier_to_cold: Optional["_models.DateAfterCreation"] = None,
        tier_to_hot: Optional["_models.DateAfterCreation"] = None,
        delete: Optional["_models.DateAfterCreation"] = None,
        **kwargs
    ):
        """
        :keyword tier_to_cool: The function to tier blob snapshot to cool storage.
        :paramtype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_archive: The function to tier blob snapshot to archive storage.
        :paramtype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_cold: The function to tier blobs to cold storage.
        :paramtype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_hot: The function to tier blobs to hot storage. This action can only be used
         with Premium Block Blob Storage Accounts.
        :paramtype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword delete: The function to delete the blob snapshot.
        :paramtype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        """
        super().__init__(**kwargs)
        self.tier_to_cool = tier_to_cool
        self.tier_to_archive = tier_to_archive
        self.tier_to_cold = tier_to_cold
        self.tier_to_hot = tier_to_hot
        self.delete = delete


class ManagementPolicyVersion(_serialization.Model):
    """Management policy action for blob version.

    :ivar tier_to_cool: The function to tier blob version to cool storage.
    :vartype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_archive: The function to tier blob version to archive storage.
    :vartype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_cold: The function to tier blobs to cold storage.
    :vartype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar tier_to_hot: The function to tier blobs to hot storage. This action can only be used with
     Premium Block Blob Storage Accounts.
    :vartype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    :ivar delete: The function to delete the blob version.
    :vartype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
    """

    _attribute_map = {
        "tier_to_cool": {"key": "tierToCool", "type": "DateAfterCreation"},
        "tier_to_archive": {"key": "tierToArchive", "type": "DateAfterCreation"},
        "tier_to_cold": {"key": "tierToCold", "type": "DateAfterCreation"},
        "tier_to_hot": {"key": "tierToHot", "type": "DateAfterCreation"},
        "delete": {"key": "delete", "type": "DateAfterCreation"},
    }

    def __init__(
        self,
        *,
        tier_to_cool: Optional["_models.DateAfterCreation"] = None,
        tier_to_archive: Optional["_models.DateAfterCreation"] = None,
        tier_to_cold: Optional["_models.DateAfterCreation"] = None,
        tier_to_hot: Optional["_models.DateAfterCreation"] = None,
        delete: Optional["_models.DateAfterCreation"] = None,
        **kwargs
    ):
        """
        :keyword tier_to_cool: The function to tier blob version to cool storage.
        :paramtype tier_to_cool: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_archive: The function to tier blob version to archive storage.
        :paramtype tier_to_archive: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_cold: The function to tier blobs to cold storage.
        :paramtype tier_to_cold: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword tier_to_hot: The function to tier blobs to hot storage. This action can only be used
         with Premium Block Blob Storage Accounts.
        :paramtype tier_to_hot: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        :keyword delete: The function to delete the blob version.
        :paramtype delete: ~azure.mgmt.storage.v2022_09_01.models.DateAfterCreation
        """
        super().__init__(**kwargs)
        self.tier_to_cool = tier_to_cool
        self.tier_to_archive = tier_to_archive
        self.tier_to_cold = tier_to_cold
        self.tier_to_hot = tier_to_hot
        self.delete = delete


class MetricSpecification(_serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.storage.v2022_09_01.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "category": {"key": "category", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: Unit could be Bytes or Count.
        :paramtype unit: str
        :keyword dimensions: Dimensions of blobs, including blob type and access tier.
        :paramtype dimensions: list[~azure.mgmt.storage.v2022_09_01.models.Dimension]
        :keyword aggregation_type: Aggregation type could be Average.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: The property to decide fill gap with zero or not.
        :paramtype fill_gap_with_zero: bool
        :keyword category: The category this metric specification belong to, could be Capacity.
        :paramtype category: str
        :keyword resource_id_dimension_name_override: Account Resource Id.
        :paramtype resource_id_dimension_name_override: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class Multichannel(_serialization.Model):
    """Multichannel setting. Applies to Premium FileStorage only.

    :ivar enabled: Indicates whether multichannel is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: Indicates whether multichannel is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class NetworkRuleSet(_serialization.Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible
     values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"),
     or None to bypass none of those traffics. Known values are: "None", "Logging", "Metrics", and
     "AzureServices".
    :vartype bypass: str or ~azure.mgmt.storage.v2022_09_01.models.Bypass
    :ivar resource_access_rules: Sets the resource access rules.
    :vartype resource_access_rules: list[~azure.mgmt.storage.v2022_09_01.models.ResourceAccessRule]
    :ivar virtual_network_rules: Sets the virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.storage.v2022_09_01.models.VirtualNetworkRule]
    :ivar ip_rules: Sets the IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.storage.v2022_09_01.models.IPRule]
    :ivar default_action: Specifies the default action of allow or deny when no other rules match.
     Known values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.storage.v2022_09_01.models.DefaultAction
    """

    _validation = {
        "default_action": {"required": True},
    }

    _attribute_map = {
        "bypass": {"key": "bypass", "type": "str"},
        "resource_access_rules": {"key": "resourceAccessRules", "type": "[ResourceAccessRule]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
        "default_action": {"key": "defaultAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "_models.DefaultAction"] = "Allow",
        bypass: Union[str, "_models.Bypass"] = "AzureServices",
        resource_access_rules: Optional[List["_models.ResourceAccessRule"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        ip_rules: Optional[List["_models.IPRule"]] = None,
        **kwargs
    ):
        """
        :keyword bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices.
         Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging,
         Metrics"), or None to bypass none of those traffics. Known values are: "None", "Logging",
         "Metrics", and "AzureServices".
        :paramtype bypass: str or ~azure.mgmt.storage.v2022_09_01.models.Bypass
        :keyword resource_access_rules: Sets the resource access rules.
        :paramtype resource_access_rules:
         list[~azure.mgmt.storage.v2022_09_01.models.ResourceAccessRule]
        :keyword virtual_network_rules: Sets the virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.storage.v2022_09_01.models.VirtualNetworkRule]
        :keyword ip_rules: Sets the IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.storage.v2022_09_01.models.IPRule]
        :keyword default_action: Specifies the default action of allow or deny when no other rules
         match. Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.storage.v2022_09_01.models.DefaultAction
        """
        super().__init__(**kwargs)
        self.bypass = bypass
        self.resource_access_rules = resource_access_rules
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action


class ObjectReplicationPolicies(_serialization.Model):
    """List storage account object replication policies.

    :ivar value: The replication policy between two storage accounts.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicy]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ObjectReplicationPolicy]"},
    }

    def __init__(self, *, value: Optional[List["_models.ObjectReplicationPolicy"]] = None, **kwargs):
        """
        :keyword value: The replication policy between two storage accounts.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicy]
        """
        super().__init__(**kwargs)
        self.value = value


class ObjectReplicationPolicy(Resource):
    """The replication policy between two storage accounts. Multiple rules can be defined in one policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar policy_id: A unique id for object replication policy.
    :vartype policy_id: str
    :ivar enabled_time: Indicates when the policy is enabled on the source account.
    :vartype enabled_time: ~datetime.datetime
    :ivar source_account: Required. Source account name. It should be full resource id if
     allowCrossTenantReplication set to false.
    :vartype source_account: str
    :ivar destination_account: Required. Destination account name. It should be full resource id if
     allowCrossTenantReplication set to false.
    :vartype destination_account: str
    :ivar rules: The storage account object replication rules.
    :vartype rules: list[~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicyRule]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_id": {"readonly": True},
        "enabled_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "policy_id": {"key": "properties.policyId", "type": "str"},
        "enabled_time": {"key": "properties.enabledTime", "type": "iso-8601"},
        "source_account": {"key": "properties.sourceAccount", "type": "str"},
        "destination_account": {"key": "properties.destinationAccount", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[ObjectReplicationPolicyRule]"},
    }

    def __init__(
        self,
        *,
        source_account: Optional[str] = None,
        destination_account: Optional[str] = None,
        rules: Optional[List["_models.ObjectReplicationPolicyRule"]] = None,
        **kwargs
    ):
        """
        :keyword source_account: Required. Source account name. It should be full resource id if
         allowCrossTenantReplication set to false.
        :paramtype source_account: str
        :keyword destination_account: Required. Destination account name. It should be full resource id
         if allowCrossTenantReplication set to false.
        :paramtype destination_account: str
        :keyword rules: The storage account object replication rules.
        :paramtype rules: list[~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicyRule]
        """
        super().__init__(**kwargs)
        self.policy_id = None
        self.enabled_time = None
        self.source_account = source_account
        self.destination_account = destination_account
        self.rules = rules


class ObjectReplicationPolicyFilter(_serialization.Model):
    """Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.

    :ivar prefix_match: Optional. Filters the results to replicate only blobs whose names begin
     with the specified prefix.
    :vartype prefix_match: list[str]
    :ivar min_creation_time: Blobs created after the time will be replicated to the destination. It
     must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z.
    :vartype min_creation_time: str
    """

    _attribute_map = {
        "prefix_match": {"key": "prefixMatch", "type": "[str]"},
        "min_creation_time": {"key": "minCreationTime", "type": "str"},
    }

    def __init__(self, *, prefix_match: Optional[List[str]] = None, min_creation_time: Optional[str] = None, **kwargs):
        """
        :keyword prefix_match: Optional. Filters the results to replicate only blobs whose names begin
         with the specified prefix.
        :paramtype prefix_match: list[str]
        :keyword min_creation_time: Blobs created after the time will be replicated to the destination.
         It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z.
        :paramtype min_creation_time: str
        """
        super().__init__(**kwargs)
        self.prefix_match = prefix_match
        self.min_creation_time = min_creation_time


class ObjectReplicationPolicyRule(_serialization.Model):
    """The replication policy rule between two containers.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: Rule Id is auto-generated for each new rule on destination account. It is
     required for put policy on source account.
    :vartype rule_id: str
    :ivar source_container: Required. Source container name. Required.
    :vartype source_container: str
    :ivar destination_container: Required. Destination container name. Required.
    :vartype destination_container: str
    :ivar filters: Optional. An object that defines the filter set.
    :vartype filters: ~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicyFilter
    """

    _validation = {
        "source_container": {"required": True},
        "destination_container": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "source_container": {"key": "sourceContainer", "type": "str"},
        "destination_container": {"key": "destinationContainer", "type": "str"},
        "filters": {"key": "filters", "type": "ObjectReplicationPolicyFilter"},
    }

    def __init__(
        self,
        *,
        source_container: str,
        destination_container: str,
        rule_id: Optional[str] = None,
        filters: Optional["_models.ObjectReplicationPolicyFilter"] = None,
        **kwargs
    ):
        """
        :keyword rule_id: Rule Id is auto-generated for each new rule on destination account. It is
         required for put policy on source account.
        :paramtype rule_id: str
        :keyword source_container: Required. Source container name. Required.
        :paramtype source_container: str
        :keyword destination_container: Required. Destination container name. Required.
        :paramtype destination_container: str
        :keyword filters: Optional. An object that defines the filter set.
        :paramtype filters: ~azure.mgmt.storage.v2022_09_01.models.ObjectReplicationPolicyFilter
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.source_container = source_container
        self.destination_container = destination_container
        self.filters = filters


class Operation(_serialization.Model):
    """Storage REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.storage.v2022_09_01.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.storage.v2022_09_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.storage.v2022_09_01.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.storage.v2022_09_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Storage.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft Storage.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class PermissionScope(_serialization.Model):
    """PermissionScope.

    All required parameters must be populated in order to send to Azure.

    :ivar permissions: The permissions for the local user. Possible values include: Read (r), Write
     (w), Delete (d), List (l), and Create (c). Required.
    :vartype permissions: str
    :ivar service: The service used by the local user, e.g. blob, file. Required.
    :vartype service: str
    :ivar resource_name: The name of resource, normally the container name or the file share name,
     used by the local user. Required.
    :vartype resource_name: str
    """

    _validation = {
        "permissions": {"required": True},
        "service": {"required": True},
        "resource_name": {"required": True},
    }

    _attribute_map = {
        "permissions": {"key": "permissions", "type": "str"},
        "service": {"key": "service", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(self, *, permissions: str, service: str, resource_name: str, **kwargs):
        """
        :keyword permissions: The permissions for the local user. Possible values include: Read (r),
         Write (w), Delete (d), List (l), and Create (c). Required.
        :paramtype permissions: str
        :keyword service: The service used by the local user, e.g. blob, file. Required.
        :paramtype service: str
        :keyword resource_name: The name of resource, normally the container name or the file share
         name, used by the local user. Required.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.permissions = permissions
        self.service = service
        self.resource_name = resource_name


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.storage.v2022_09_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.storage.v2022_09_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.storage.v2022_09_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.storage.v2022_09_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar action_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype action_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "action_required": {"key": "actionRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        action_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword action_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype action_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ProtectedAppendWritesHistory(_serialization.Model):
    """Protected append writes history setting for the blob container with Legal holds.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allow_protected_append_writes_all: When enabled, new blocks can be written to both
     'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks
     can be added and any existing blocks cannot be modified or deleted.
    :vartype allow_protected_append_writes_all: bool
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "timestamp": {"readonly": True},
    }

    _attribute_map = {
        "allow_protected_append_writes_all": {"key": "allowProtectedAppendWritesAll", "type": "bool"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(self, *, allow_protected_append_writes_all: Optional[bool] = None, **kwargs):
        """
        :keyword allow_protected_append_writes_all: When enabled, new blocks can be written to both
         'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks
         can be added and any existing blocks cannot be modified or deleted.
        :paramtype allow_protected_append_writes_all: bool
        """
        super().__init__(**kwargs)
        self.allow_protected_append_writes_all = allow_protected_append_writes_all
        self.timestamp = None


class ProtocolSettings(_serialization.Model):
    """Protocol settings for file service.

    :ivar smb: Setting for SMB protocol.
    :vartype smb: ~azure.mgmt.storage.v2022_09_01.models.SmbSetting
    """

    _attribute_map = {
        "smb": {"key": "smb", "type": "SmbSetting"},
    }

    def __init__(self, *, smb: Optional["_models.SmbSetting"] = None, **kwargs):
        """
        :keyword smb: Setting for SMB protocol.
        :paramtype smb: ~azure.mgmt.storage.v2022_09_01.models.SmbSetting
        """
        super().__init__(**kwargs)
        self.smb = smb


class QueueServiceProperties(Resource):
    """The properties of a storage account’s Queue service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar cors: Specifies CORS rules for the Queue service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Queue service.
    :vartype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cors": {"key": "properties.cors", "type": "CorsRules"},
    }

    def __init__(self, *, cors: Optional["_models.CorsRules"] = None, **kwargs):
        """
        :keyword cors: Specifies CORS rules for the Queue service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the Queue service.
        :paramtype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
        """
        super().__init__(**kwargs)
        self.cors = cors


class ResourceAccessRule(_serialization.Model):
    """Resource Access Rule.

    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, tenant_id: Optional[str] = None, resource_id: Optional[str] = None, **kwargs):
        """
        :keyword tenant_id: Tenant Id.
        :paramtype tenant_id: str
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.resource_id = resource_id


class RestorePolicyProperties(_serialization.Model):
    """The blob service properties for blob restore policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Blob restore is enabled if set to true. Required.
    :vartype enabled: bool
    :ivar days: how long this blob can be restored. It should be great than zero and less than
     DeleteRetentionPolicy.days.
    :vartype days: int
    :ivar last_enabled_time: Deprecated in favor of minRestoreTime property.
    :vartype last_enabled_time: ~datetime.datetime
    :ivar min_restore_time: Returns the minimum date and time that the restore can be started.
    :vartype min_restore_time: ~datetime.datetime
    """

    _validation = {
        "enabled": {"required": True},
        "days": {"maximum": 365, "minimum": 1},
        "last_enabled_time": {"readonly": True},
        "min_restore_time": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "days": {"key": "days", "type": "int"},
        "last_enabled_time": {"key": "lastEnabledTime", "type": "iso-8601"},
        "min_restore_time": {"key": "minRestoreTime", "type": "iso-8601"},
    }

    def __init__(self, *, enabled: bool, days: Optional[int] = None, **kwargs):
        """
        :keyword enabled: Blob restore is enabled if set to true. Required.
        :paramtype enabled: bool
        :keyword days: how long this blob can be restored. It should be great than zero and less than
         DeleteRetentionPolicy.days.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days
        self.last_enabled_time = None
        self.min_restore_time = None


class Restriction(_serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
     subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
     capacity at DC. Known values are: "QuotaId" and "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.storage.v2022_09_01.models.ReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, *, reason_code: Optional[Union[str, "_models.ReasonCode"]] = None, **kwargs):
        """
        :keyword reason_code: The reason for the restriction. As of now this can be "QuotaId" or
         "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
         subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
         capacity at DC. Known values are: "QuotaId" and "NotAvailableForSubscription".
        :paramtype reason_code: str or ~azure.mgmt.storage.v2022_09_01.models.ReasonCode
        """
        super().__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = reason_code


class RoutingPreference(_serialization.Model):
    """Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing.

    :ivar routing_choice: Routing Choice defines the kind of network routing opted by the user.
     Known values are: "MicrosoftRouting" and "InternetRouting".
    :vartype routing_choice: str or ~azure.mgmt.storage.v2022_09_01.models.RoutingChoice
    :ivar publish_microsoft_endpoints: A boolean flag which indicates whether microsoft routing
     storage endpoints are to be published.
    :vartype publish_microsoft_endpoints: bool
    :ivar publish_internet_endpoints: A boolean flag which indicates whether internet routing
     storage endpoints are to be published.
    :vartype publish_internet_endpoints: bool
    """

    _attribute_map = {
        "routing_choice": {"key": "routingChoice", "type": "str"},
        "publish_microsoft_endpoints": {"key": "publishMicrosoftEndpoints", "type": "bool"},
        "publish_internet_endpoints": {"key": "publishInternetEndpoints", "type": "bool"},
    }

    def __init__(
        self,
        *,
        routing_choice: Optional[Union[str, "_models.RoutingChoice"]] = None,
        publish_microsoft_endpoints: Optional[bool] = None,
        publish_internet_endpoints: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword routing_choice: Routing Choice defines the kind of network routing opted by the user.
         Known values are: "MicrosoftRouting" and "InternetRouting".
        :paramtype routing_choice: str or ~azure.mgmt.storage.v2022_09_01.models.RoutingChoice
        :keyword publish_microsoft_endpoints: A boolean flag which indicates whether microsoft routing
         storage endpoints are to be published.
        :paramtype publish_microsoft_endpoints: bool
        :keyword publish_internet_endpoints: A boolean flag which indicates whether internet routing
         storage endpoints are to be published.
        :paramtype publish_internet_endpoints: bool
        """
        super().__init__(**kwargs)
        self.routing_choice = routing_choice
        self.publish_microsoft_endpoints = publish_microsoft_endpoints
        self.publish_internet_endpoints = publish_internet_endpoints


class SasPolicy(_serialization.Model):
    """SasPolicy assigned to the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar sas_expiration_period: The SAS expiration period, DD.HH:MM:SS. Required.
    :vartype sas_expiration_period: str
    :ivar expiration_action: The SAS expiration action. Can only be Log. "Log"
    :vartype expiration_action: str or ~azure.mgmt.storage.v2022_09_01.models.ExpirationAction
    """

    _validation = {
        "sas_expiration_period": {"required": True},
        "expiration_action": {"required": True},
    }

    _attribute_map = {
        "sas_expiration_period": {"key": "sasExpirationPeriod", "type": "str"},
        "expiration_action": {"key": "expirationAction", "type": "str"},
    }

    def __init__(
        self, *, sas_expiration_period: str, expiration_action: Union[str, "_models.ExpirationAction"] = "Log", **kwargs
    ):
        """
        :keyword sas_expiration_period: The SAS expiration period, DD.HH:MM:SS. Required.
        :paramtype sas_expiration_period: str
        :keyword expiration_action: The SAS expiration action. Can only be Log. "Log"
        :paramtype expiration_action: str or ~azure.mgmt.storage.v2022_09_01.models.ExpirationAction
        """
        super().__init__(**kwargs)
        self.sas_expiration_period = sas_expiration_period
        self.expiration_action = expiration_action


class ServiceSasParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :ivar canonicalized_resource: The canonical path to the signed resource. Required.
    :vartype canonicalized_resource: str
    :ivar resource: The signed services accessible with the service SAS. Possible values include:
     Blob (b), Container (c), File (f), Share (s). Known values are: "b", "c", "f", and "s".
    :vartype resource: str or ~azure.mgmt.storage.v2022_09_01.models.SignedResource
    :ivar permissions: The signed permissions for the service SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Known
     values are: "r", "d", "w", "l", "a", "c", "u", and "p".
    :vartype permissions: str or ~azure.mgmt.storage.v2022_09_01.models.Permissions
    :ivar ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :vartype ip_address_or_range: str
    :ivar protocols: The protocol permitted for a request made with the account SAS. Known values
     are: "https,http" and "https".
    :vartype protocols: str or ~azure.mgmt.storage.v2022_09_01.models.HttpProtocol
    :ivar shared_access_start_time: The time at which the SAS becomes valid.
    :vartype shared_access_start_time: ~datetime.datetime
    :ivar shared_access_expiry_time: The time at which the shared access signature becomes invalid.
    :vartype shared_access_expiry_time: ~datetime.datetime
    :ivar identifier: A unique value up to 64 characters in length that correlates to an access
     policy specified for the container, queue, or table.
    :vartype identifier: str
    :ivar partition_key_start: The start of partition key.
    :vartype partition_key_start: str
    :ivar partition_key_end: The end of partition key.
    :vartype partition_key_end: str
    :ivar row_key_start: The start of row key.
    :vartype row_key_start: str
    :ivar row_key_end: The end of row key.
    :vartype row_key_end: str
    :ivar key_to_sign: The key to sign the account SAS token with.
    :vartype key_to_sign: str
    :ivar cache_control: The response header override for cache control.
    :vartype cache_control: str
    :ivar content_disposition: The response header override for content disposition.
    :vartype content_disposition: str
    :ivar content_encoding: The response header override for content encoding.
    :vartype content_encoding: str
    :ivar content_language: The response header override for content language.
    :vartype content_language: str
    :ivar content_type: The response header override for content type.
    :vartype content_type: str
    """

    _validation = {
        "canonicalized_resource": {"required": True},
        "identifier": {"max_length": 64},
    }

    _attribute_map = {
        "canonicalized_resource": {"key": "canonicalizedResource", "type": "str"},
        "resource": {"key": "signedResource", "type": "str"},
        "permissions": {"key": "signedPermission", "type": "str"},
        "ip_address_or_range": {"key": "signedIp", "type": "str"},
        "protocols": {"key": "signedProtocol", "type": "str"},
        "shared_access_start_time": {"key": "signedStart", "type": "iso-8601"},
        "shared_access_expiry_time": {"key": "signedExpiry", "type": "iso-8601"},
        "identifier": {"key": "signedIdentifier", "type": "str"},
        "partition_key_start": {"key": "startPk", "type": "str"},
        "partition_key_end": {"key": "endPk", "type": "str"},
        "row_key_start": {"key": "startRk", "type": "str"},
        "row_key_end": {"key": "endRk", "type": "str"},
        "key_to_sign": {"key": "keyToSign", "type": "str"},
        "cache_control": {"key": "rscc", "type": "str"},
        "content_disposition": {"key": "rscd", "type": "str"},
        "content_encoding": {"key": "rsce", "type": "str"},
        "content_language": {"key": "rscl", "type": "str"},
        "content_type": {"key": "rsct", "type": "str"},
    }

    def __init__(
        self,
        *,
        canonicalized_resource: str,
        resource: Optional[Union[str, "_models.SignedResource"]] = None,
        permissions: Optional[Union[str, "_models.Permissions"]] = None,
        ip_address_or_range: Optional[str] = None,
        protocols: Optional[Union[str, "_models.HttpProtocol"]] = None,
        shared_access_start_time: Optional[datetime.datetime] = None,
        shared_access_expiry_time: Optional[datetime.datetime] = None,
        identifier: Optional[str] = None,
        partition_key_start: Optional[str] = None,
        partition_key_end: Optional[str] = None,
        row_key_start: Optional[str] = None,
        row_key_end: Optional[str] = None,
        key_to_sign: Optional[str] = None,
        cache_control: Optional[str] = None,
        content_disposition: Optional[str] = None,
        content_encoding: Optional[str] = None,
        content_language: Optional[str] = None,
        content_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword canonicalized_resource: The canonical path to the signed resource. Required.
        :paramtype canonicalized_resource: str
        :keyword resource: The signed services accessible with the service SAS. Possible values
         include: Blob (b), Container (c), File (f), Share (s). Known values are: "b", "c", "f", and
         "s".
        :paramtype resource: str or ~azure.mgmt.storage.v2022_09_01.models.SignedResource
        :keyword permissions: The signed permissions for the service SAS. Possible values include: Read
         (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Known
         values are: "r", "d", "w", "l", "a", "c", "u", and "p".
        :paramtype permissions: str or ~azure.mgmt.storage.v2022_09_01.models.Permissions
        :keyword ip_address_or_range: An IP address or a range of IP addresses from which to accept
         requests.
        :paramtype ip_address_or_range: str
        :keyword protocols: The protocol permitted for a request made with the account SAS. Known
         values are: "https,http" and "https".
        :paramtype protocols: str or ~azure.mgmt.storage.v2022_09_01.models.HttpProtocol
        :keyword shared_access_start_time: The time at which the SAS becomes valid.
        :paramtype shared_access_start_time: ~datetime.datetime
        :keyword shared_access_expiry_time: The time at which the shared access signature becomes
         invalid.
        :paramtype shared_access_expiry_time: ~datetime.datetime
        :keyword identifier: A unique value up to 64 characters in length that correlates to an access
         policy specified for the container, queue, or table.
        :paramtype identifier: str
        :keyword partition_key_start: The start of partition key.
        :paramtype partition_key_start: str
        :keyword partition_key_end: The end of partition key.
        :paramtype partition_key_end: str
        :keyword row_key_start: The start of row key.
        :paramtype row_key_start: str
        :keyword row_key_end: The end of row key.
        :paramtype row_key_end: str
        :keyword key_to_sign: The key to sign the account SAS token with.
        :paramtype key_to_sign: str
        :keyword cache_control: The response header override for cache control.
        :paramtype cache_control: str
        :keyword content_disposition: The response header override for content disposition.
        :paramtype content_disposition: str
        :keyword content_encoding: The response header override for content encoding.
        :paramtype content_encoding: str
        :keyword content_language: The response header override for content language.
        :paramtype content_language: str
        :keyword content_type: The response header override for content type.
        :paramtype content_type: str
        """
        super().__init__(**kwargs)
        self.canonicalized_resource = canonicalized_resource
        self.resource = resource
        self.permissions = permissions
        self.ip_address_or_range = ip_address_or_range
        self.protocols = protocols
        self.shared_access_start_time = shared_access_start_time
        self.shared_access_expiry_time = shared_access_expiry_time
        self.identifier = identifier
        self.partition_key_start = partition_key_start
        self.partition_key_end = partition_key_end
        self.row_key_start = row_key_start
        self.row_key_end = row_key_end
        self.key_to_sign = key_to_sign
        self.cache_control = cache_control
        self.content_disposition = content_disposition
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_type = content_type


class ServiceSpecification(_serialization.Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications:
     list[~azure.mgmt.storage.v2022_09_01.models.MetricSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(self, *, metric_specifications: Optional[List["_models.MetricSpecification"]] = None, **kwargs):
        """
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.storage.v2022_09_01.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class SignedIdentifier(_serialization.Model):
    """SignedIdentifier.

    :ivar id: An unique identifier of the stored access policy.
    :vartype id: str
    :ivar access_policy: Access policy.
    :vartype access_policy: ~azure.mgmt.storage.v2022_09_01.models.AccessPolicy
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "access_policy": {"key": "accessPolicy", "type": "AccessPolicy"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        access_policy: Optional["_models.AccessPolicy"] = None,
        **kwargs
    ):
        """
        :keyword id: An unique identifier of the stored access policy.
        :paramtype id: str
        :keyword access_policy: Access policy.
        :paramtype access_policy: ~azure.mgmt.storage.v2022_09_01.models.AccessPolicy
        """
        super().__init__(**kwargs)
        self.id = id
        self.access_policy = access_policy


class Sku(_serialization.Model):
    """The SKU of the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name. Required for account creation; optional for update. Note that in
     older versions, SKU name was called accountType. Required. Known values are: "Standard_LRS",
     "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
     "Standard_GZRS", and "Standard_RAGZRS".
    :vartype name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. Known values are: "Standard" and
     "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2022_09_01.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.SkuName"], **kwargs):
        """
        :keyword name: The SKU name. Required for account creation; optional for update. Note that in
         older versions, SKU name was called accountType. Required. Known values are: "Standard_LRS",
         "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
         "Standard_GZRS", and "Standard_RAGZRS".
        :paramtype name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None


class SKUCapability(_serialization.Model):
    """The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability, The capability information in the specified SKU, including
     file encryption, network ACLs, change notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class SkuInformation(_serialization.Model):
    """Storage SKU and its properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name. Required for account creation; optional for update. Note that in
     older versions, SKU name was called accountType. Required. Known values are: "Standard_LRS",
     "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
     "Standard_GZRS", and "Standard_RAGZRS".
    :vartype name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. Known values are: "Standard" and
     "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2022_09_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is 'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Known values are: "Storage", "StorageV2",
     "BlobStorage", "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified SKU, including file encryption,
     network ACLs, change notification, etc.
    :vartype capabilities: list[~azure.mgmt.storage.v2022_09_01.models.SKUCapability]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.storage.v2022_09_01.models.Restriction]
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
        "resource_type": {"readonly": True},
        "kind": {"readonly": True},
        "locations": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[SKUCapability]"},
        "restrictions": {"key": "restrictions", "type": "[Restriction]"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        restrictions: Optional[List["_models.Restriction"]] = None,
        **kwargs
    ):
        """
        :keyword name: The SKU name. Required for account creation; optional for update. Note that in
         older versions, SKU name was called accountType. Required. Known values are: "Standard_LRS",
         "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
         "Standard_GZRS", and "Standard_RAGZRS".
        :paramtype name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
        :keyword restrictions: The restrictions because of which SKU cannot be used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.storage.v2022_09_01.models.Restriction]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = restrictions


class SmbSetting(_serialization.Model):
    """Setting for SMB protocol.

    :ivar multichannel: Multichannel setting. Applies to Premium FileStorage only.
    :vartype multichannel: ~azure.mgmt.storage.v2022_09_01.models.Multichannel
    :ivar versions: SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0,
     SMB3.1.1. Should be passed as a string with delimiter ';'.
    :vartype versions: str
    :ivar authentication_methods: SMB authentication methods supported by server. Valid values are
     NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
    :vartype authentication_methods: str
    :ivar kerberos_ticket_encryption: Kerberos ticket encryption supported by server. Valid values
     are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'.
    :vartype kerberos_ticket_encryption: str
    :ivar channel_encryption: SMB channel encryption supported by server. Valid values are
     AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
    :vartype channel_encryption: str
    """

    _attribute_map = {
        "multichannel": {"key": "multichannel", "type": "Multichannel"},
        "versions": {"key": "versions", "type": "str"},
        "authentication_methods": {"key": "authenticationMethods", "type": "str"},
        "kerberos_ticket_encryption": {"key": "kerberosTicketEncryption", "type": "str"},
        "channel_encryption": {"key": "channelEncryption", "type": "str"},
    }

    def __init__(
        self,
        *,
        multichannel: Optional["_models.Multichannel"] = None,
        versions: Optional[str] = None,
        authentication_methods: Optional[str] = None,
        kerberos_ticket_encryption: Optional[str] = None,
        channel_encryption: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword multichannel: Multichannel setting. Applies to Premium FileStorage only.
        :paramtype multichannel: ~azure.mgmt.storage.v2022_09_01.models.Multichannel
        :keyword versions: SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0,
         SMB3.1.1. Should be passed as a string with delimiter ';'.
        :paramtype versions: str
        :keyword authentication_methods: SMB authentication methods supported by server. Valid values
         are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
        :paramtype authentication_methods: str
        :keyword kerberos_ticket_encryption: Kerberos ticket encryption supported by server. Valid
         values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'.
        :paramtype kerberos_ticket_encryption: str
        :keyword channel_encryption: SMB channel encryption supported by server. Valid values are
         AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
        :paramtype channel_encryption: str
        """
        super().__init__(**kwargs)
        self.multichannel = multichannel
        self.versions = versions
        self.authentication_methods = authentication_methods
        self.kerberos_ticket_encryption = kerberos_ticket_encryption
        self.channel_encryption = channel_encryption


class SshPublicKey(_serialization.Model):
    """SshPublicKey.

    :ivar description: Optional. It is used to store the function/usage of the key.
    :vartype description: str
    :ivar key: Ssh public key base64 encoded. The format should be: ':code:`<keyType>`
     :code:`<keyData>`', e.g. ssh-rsa AAAABBBB.
    :vartype key: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, key: Optional[str] = None, **kwargs):
        """
        :keyword description: Optional. It is used to store the function/usage of the key.
        :paramtype description: str
        :keyword key: Ssh public key base64 encoded. The format should be: ':code:`<keyType>`
         :code:`<keyData>`', e.g. ssh-rsa AAAABBBB.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.key = key


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageAccount(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
    :ivar kind: Gets the Kind. Known values are: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocation
    :ivar provisioning_state: Gets the status of the storage account at the time the operation was
     called. Known values are: "Creating", "ResolvingDNS", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.storage.v2022_09_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob
     endpoint.
    :vartype primary_endpoints: ~azure.mgmt.storage.v2022_09_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary location of the storage
     account is available or unavailable. Known values are: "available" and "unavailable".
    :vartype status_of_primary: str or ~azure.mgmt.storage.v2022_09_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent instance of a failover to
     the secondary location. Only the most recent timestamp is retained. This element is not
     returned if there has never been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: ~datetime.datetime
    :ivar secondary_location: Gets the location of the geo-replicated secondary for the storage
     account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the secondary location of the
     storage account is available or unavailable. Only available if the SKU name is Standard_GRS or
     Standard_RAGRS. Known values are: "available" and "unavailable".
    :vartype status_of_secondary: str or ~azure.mgmt.storage.v2022_09_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage account in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this storage account.
    :vartype custom_domain: ~azure.mgmt.storage.v2022_09_01.models.CustomDomain
    :ivar sas_policy: SasPolicy assigned to the storage account.
    :vartype sas_policy: ~azure.mgmt.storage.v2022_09_01.models.SasPolicy
    :ivar key_policy: KeyPolicy assigned to the storage account.
    :vartype key_policy: ~azure.mgmt.storage.v2022_09_01.models.KeyPolicy
    :ivar key_creation_time: Storage account keys creation time.
    :vartype key_creation_time: ~azure.mgmt.storage.v2022_09_01.models.KeyCreationTime
    :ivar secondary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object from the secondary location of the storage account. Only available if
     the SKU name is Standard_RAGRS.
    :vartype secondary_endpoints: ~azure.mgmt.storage.v2022_09_01.models.Endpoints
    :ivar encryption: Encryption settings to be used for server-side encryption for the storage
     account.
    :vartype encryption: ~azure.mgmt.storage.v2022_09_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier is
     used for billing. The 'Premium' access tier is the default value for premium block blobs
     storage account type and it cannot be changed for the premium block blobs storage account type.
     Known values are: "Hot", "Cool", and "Premium".
    :vartype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2022_09_01.models.NetworkRuleSet
    :ivar is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
    :vartype is_sftp_enabled: bool
    :ivar is_local_user_enabled: Enables local users feature, if set to true.
    :vartype is_local_user_enabled: bool
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    :ivar geo_replication_stats: Geo Replication Stats.
    :vartype geo_replication_stats: ~azure.mgmt.storage.v2022_09_01.models.GeoReplicationStats
    :ivar failover_in_progress: If the failover is in progress, the value will be true, otherwise,
     it will be null.
    :vartype failover_in_progress: bool
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Known values are: "Disabled" and "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
    :ivar private_endpoint_connections: List of private endpoint connection associated with the
     specified storage account.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.storage.v2022_09_01.models.PrivateEndpointConnection]
    :ivar routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :vartype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
    :ivar blob_restore_status: Blob restore status.
    :vartype blob_restore_status: ~azure.mgmt.storage.v2022_09_01.models.BlobRestoreStatus
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0", "TLS1_1",
     and "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    :ivar enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
    :vartype enable_nfs_v3: bool
    :ivar allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :vartype allow_cross_tenant_replication: bool
    :ivar default_to_o_auth_authentication: A boolean flag which indicates whether the default
     authentication is OAuth or not. The default interpretation is false for this property.
    :vartype default_to_o_auth_authentication: bool
    :ivar public_network_access: Allow or disallow public network access to Storage Account. Value
     is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
    :ivar immutable_storage_with_versioning: The property is immutable and can only be set to true
     at the account creation time. When set to true, it enables object level immutability for all
     the containers in the account by default.
    :vartype immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
    :ivar allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
     with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
    :vartype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
    :ivar storage_account_sku_conversion_status: This property is readOnly and is set by server
     during asynchronous storage account sku conversion operations.
    :vartype storage_account_sku_conversion_status:
     ~azure.mgmt.storage.v2022_09_01.models.StorageAccountSkuConversionStatus
    :ivar dns_endpoint_type: Allows you to specify the type of endpoint. Set this to AzureDNSZone
     to create a large number of accounts in a single subscription, which creates accounts in an
     Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Known values
     are: "Standard" and "AzureDnsZone".
    :vartype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"readonly": True},
        "kind": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "primary_endpoints": {"readonly": True},
        "primary_location": {"readonly": True},
        "status_of_primary": {"readonly": True},
        "last_geo_failover_time": {"readonly": True},
        "secondary_location": {"readonly": True},
        "status_of_secondary": {"readonly": True},
        "creation_time": {"readonly": True},
        "custom_domain": {"readonly": True},
        "sas_policy": {"readonly": True},
        "key_policy": {"readonly": True},
        "key_creation_time": {"readonly": True},
        "secondary_endpoints": {"readonly": True},
        "encryption": {"readonly": True},
        "access_tier": {"readonly": True},
        "network_rule_set": {"readonly": True},
        "geo_replication_stats": {"readonly": True},
        "failover_in_progress": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "blob_restore_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "primary_endpoints": {"key": "properties.primaryEndpoints", "type": "Endpoints"},
        "primary_location": {"key": "properties.primaryLocation", "type": "str"},
        "status_of_primary": {"key": "properties.statusOfPrimary", "type": "str"},
        "last_geo_failover_time": {"key": "properties.lastGeoFailoverTime", "type": "iso-8601"},
        "secondary_location": {"key": "properties.secondaryLocation", "type": "str"},
        "status_of_secondary": {"key": "properties.statusOfSecondary", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "sas_policy": {"key": "properties.sasPolicy", "type": "SasPolicy"},
        "key_policy": {"key": "properties.keyPolicy", "type": "KeyPolicy"},
        "key_creation_time": {"key": "properties.keyCreationTime", "type": "KeyCreationTime"},
        "secondary_endpoints": {"key": "properties.secondaryEndpoints", "type": "Endpoints"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "azure_files_identity_based_authentication": {
            "key": "properties.azureFilesIdentityBasedAuthentication",
            "type": "AzureFilesIdentityBasedAuthentication",
        },
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
        "is_sftp_enabled": {"key": "properties.isSftpEnabled", "type": "bool"},
        "is_local_user_enabled": {"key": "properties.isLocalUserEnabled", "type": "bool"},
        "is_hns_enabled": {"key": "properties.isHnsEnabled", "type": "bool"},
        "geo_replication_stats": {"key": "properties.geoReplicationStats", "type": "GeoReplicationStats"},
        "failover_in_progress": {"key": "properties.failoverInProgress", "type": "bool"},
        "large_file_shares_state": {"key": "properties.largeFileSharesState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "routing_preference": {"key": "properties.routingPreference", "type": "RoutingPreference"},
        "blob_restore_status": {"key": "properties.blobRestoreStatus", "type": "BlobRestoreStatus"},
        "allow_blob_public_access": {"key": "properties.allowBlobPublicAccess", "type": "bool"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "allow_shared_key_access": {"key": "properties.allowSharedKeyAccess", "type": "bool"},
        "enable_nfs_v3": {"key": "properties.isNfsV3Enabled", "type": "bool"},
        "allow_cross_tenant_replication": {"key": "properties.allowCrossTenantReplication", "type": "bool"},
        "default_to_o_auth_authentication": {"key": "properties.defaultToOAuthAuthentication", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "immutable_storage_with_versioning": {
            "key": "properties.immutableStorageWithVersioning",
            "type": "ImmutableStorageAccount",
        },
        "allowed_copy_scope": {"key": "properties.allowedCopyScope", "type": "str"},
        "storage_account_sku_conversion_status": {
            "key": "properties.storageAccountSkuConversionStatus",
            "type": "StorageAccountSkuConversionStatus",
        },
        "dns_endpoint_type": {"key": "properties.dnsEndpointType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        azure_files_identity_based_authentication: Optional["_models.AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_sftp_enabled: Optional[bool] = None,
        is_local_user_enabled: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        large_file_shares_state: Optional[Union[str, "_models.LargeFileSharesState"]] = None,
        routing_preference: Optional["_models.RoutingPreference"] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        enable_nfs_v3: Optional[bool] = None,
        allow_cross_tenant_replication: Optional[bool] = None,
        default_to_o_auth_authentication: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        immutable_storage_with_versioning: Optional["_models.ImmutableStorageAccount"] = None,
        allowed_copy_scope: Optional[Union[str, "_models.AllowedCopyScope"]] = None,
        storage_account_sku_conversion_status: Optional["_models.StorageAccountSkuConversionStatus"] = None,
        dns_endpoint_type: Optional[Union[str, "_models.DnsEndpointType"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
        :keyword extended_location: The extendedLocation of the resource.
        :paramtype extended_location: ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocation
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
        :paramtype is_sftp_enabled: bool
        :keyword is_local_user_enabled: Enables local users feature, if set to true.
        :paramtype is_local_user_enabled: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Known values are: "Disabled" and "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
        :keyword routing_preference: Maintains information about the network routing choice opted by
         the user for data transfer.
        :paramtype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0",
         "TLS1_1", and "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        :keyword enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
        :paramtype enable_nfs_v3: bool
        :keyword allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
         The default interpretation is true for this property.
        :paramtype allow_cross_tenant_replication: bool
        :keyword default_to_o_auth_authentication: A boolean flag which indicates whether the default
         authentication is OAuth or not. The default interpretation is false for this property.
        :paramtype default_to_o_auth_authentication: bool
        :keyword public_network_access: Allow or disallow public network access to Storage Account.
         Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
        :keyword immutable_storage_with_versioning: The property is immutable and can only be set to
         true at the account creation time. When set to true, it enables object level immutability for
         all the containers in the account by default.
        :paramtype immutable_storage_with_versioning:
         ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
        :keyword allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
         with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
        :paramtype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
        :keyword storage_account_sku_conversion_status: This property is readOnly and is set by server
         during asynchronous storage account sku conversion operations.
        :paramtype storage_account_sku_conversion_status:
         ~azure.mgmt.storage.v2022_09_01.models.StorageAccountSkuConversionStatus
        :keyword dns_endpoint_type: Allows you to specify the type of endpoint. Set this to
         AzureDNSZone to create a large number of accounts in a single subscription, which creates
         accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone
         identifier. Known values are: "Standard" and "AzureDnsZone".
        :paramtype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = None
        self.kind = None
        self.identity = identity
        self.extended_location = extended_location
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.sas_policy = None
        self.key_policy = None
        self.key_creation_time = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.network_rule_set = None
        self.is_sftp_enabled = is_sftp_enabled
        self.is_local_user_enabled = is_local_user_enabled
        self.is_hns_enabled = is_hns_enabled
        self.geo_replication_stats = None
        self.failover_in_progress = None
        self.large_file_shares_state = large_file_shares_state
        self.private_endpoint_connections = None
        self.routing_preference = routing_preference
        self.blob_restore_status = None
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access
        self.enable_nfs_v3 = enable_nfs_v3
        self.allow_cross_tenant_replication = allow_cross_tenant_replication
        self.default_to_o_auth_authentication = default_to_o_auth_authentication
        self.public_network_access = public_network_access
        self.immutable_storage_with_versioning = immutable_storage_with_versioning
        self.allowed_copy_scope = allowed_copy_scope
        self.storage_account_sku_conversion_status = storage_account_sku_conversion_status
        self.dns_endpoint_type = dns_endpoint_type


class StorageAccountCheckNameAvailabilityParameters(_serialization.Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The storage account name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.Storage/storageAccounts. Required. Default value is
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(self, *, name: str, **kwargs):
        """
        :keyword name: The storage account name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class StorageAccountCreateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar sku: Required. Gets or sets the SKU name. Required.
    :vartype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
    :ivar kind: Required. Indicates the type of storage account. Required. Known values are:
     "Storage", "StorageV2", "BlobStorage", "FileStorage", and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
    :ivar location: Required. Gets or sets the location of the resource. This will be one of the
     supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The
     geo region of a resource cannot be changed once it is created, but if an identical geo region
     is specified on update, the request will succeed. Required.
    :vartype location: str
    :ivar extended_location: Optional. Set the extended location of the resource. If not set, the
     storage account will be created in Azure main region. Otherwise it will be created in the
     specified extended location.
    :vartype extended_location: ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocation
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key with a length no greater than 128
     characters and a value with a length no greater than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
    :ivar allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
     with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
    :vartype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
    :ivar public_network_access: Allow or disallow public network access to Storage Account. Value
     is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
    :ivar sas_policy: SasPolicy assigned to the storage account.
    :vartype sas_policy: ~azure.mgmt.storage.v2022_09_01.models.SasPolicy
    :ivar key_policy: KeyPolicy assigned to the storage account.
    :vartype key_policy: ~azure.mgmt.storage.v2022_09_01.models.KeyPolicy
    :ivar custom_domain: User domain assigned to the storage account. Name is the CNAME source.
     Only one custom domain is supported per storage account at this time. To clear the existing
     custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2022_09_01.models.CustomDomain
    :ivar encryption: Encryption settings to be used for server-side encryption for the storage
     account.
    :vartype encryption: ~azure.mgmt.storage.v2022_09_01.models.Encryption
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2022_09_01.models.NetworkRuleSet
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier is
     used for billing. The 'Premium' access tier is the default value for premium block blobs
     storage account type and it cannot be changed for the premium block blobs storage account type.
     Known values are: "Hot", "Cool", and "Premium".
    :vartype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
     The default value is true since API version 2019-04-01.
    :vartype enable_https_traffic_only: bool
    :ivar is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
    :vartype is_sftp_enabled: bool
    :ivar is_local_user_enabled: Enables local users feature, if set to true.
    :vartype is_local_user_enabled: bool
    :ivar is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :vartype is_hns_enabled: bool
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Known values are: "Disabled" and "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
    :ivar routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :vartype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0", "TLS1_1",
     and "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    :ivar enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
    :vartype enable_nfs_v3: bool
    :ivar allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :vartype allow_cross_tenant_replication: bool
    :ivar default_to_o_auth_authentication: A boolean flag which indicates whether the default
     authentication is OAuth or not. The default interpretation is false for this property.
    :vartype default_to_o_auth_authentication: bool
    :ivar immutable_storage_with_versioning: The property is immutable and can only be set to true
     at the account creation time. When set to true, it enables object level immutability for all
     the new containers in the account by default.
    :vartype immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
    :ivar dns_endpoint_type: Allows you to specify the type of endpoint. Set this to AzureDNSZone
     to create a large number of accounts in a single subscription, which creates accounts in an
     Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Known values
     are: "Standard" and "AzureDnsZone".
    :vartype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
    """

    _validation = {
        "sku": {"required": True},
        "kind": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "allowed_copy_scope": {"key": "properties.allowedCopyScope", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "sas_policy": {"key": "properties.sasPolicy", "type": "SasPolicy"},
        "key_policy": {"key": "properties.keyPolicy", "type": "KeyPolicy"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "azure_files_identity_based_authentication": {
            "key": "properties.azureFilesIdentityBasedAuthentication",
            "type": "AzureFilesIdentityBasedAuthentication",
        },
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "is_sftp_enabled": {"key": "properties.isSftpEnabled", "type": "bool"},
        "is_local_user_enabled": {"key": "properties.isLocalUserEnabled", "type": "bool"},
        "is_hns_enabled": {"key": "properties.isHnsEnabled", "type": "bool"},
        "large_file_shares_state": {"key": "properties.largeFileSharesState", "type": "str"},
        "routing_preference": {"key": "properties.routingPreference", "type": "RoutingPreference"},
        "allow_blob_public_access": {"key": "properties.allowBlobPublicAccess", "type": "bool"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "allow_shared_key_access": {"key": "properties.allowSharedKeyAccess", "type": "bool"},
        "enable_nfs_v3": {"key": "properties.isNfsV3Enabled", "type": "bool"},
        "allow_cross_tenant_replication": {"key": "properties.allowCrossTenantReplication", "type": "bool"},
        "default_to_o_auth_authentication": {"key": "properties.defaultToOAuthAuthentication", "type": "bool"},
        "immutable_storage_with_versioning": {
            "key": "properties.immutableStorageWithVersioning",
            "type": "ImmutableStorageAccount",
        },
        "dns_endpoint_type": {"key": "properties.dnsEndpointType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: "_models.Sku",
        kind: Union[str, "_models.Kind"],
        location: str,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        allowed_copy_scope: Optional[Union[str, "_models.AllowedCopyScope"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        sas_policy: Optional["_models.SasPolicy"] = None,
        key_policy: Optional["_models.KeyPolicy"] = None,
        custom_domain: Optional["_models.CustomDomain"] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        access_tier: Optional[Union[str, "_models.AccessTier"]] = None,
        azure_files_identity_based_authentication: Optional["_models.AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_sftp_enabled: Optional[bool] = None,
        is_local_user_enabled: Optional[bool] = None,
        is_hns_enabled: Optional[bool] = None,
        large_file_shares_state: Optional[Union[str, "_models.LargeFileSharesState"]] = None,
        routing_preference: Optional["_models.RoutingPreference"] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        enable_nfs_v3: Optional[bool] = None,
        allow_cross_tenant_replication: Optional[bool] = None,
        default_to_o_auth_authentication: Optional[bool] = None,
        immutable_storage_with_versioning: Optional["_models.ImmutableStorageAccount"] = None,
        dns_endpoint_type: Optional[Union[str, "_models.DnsEndpointType"]] = None,
        **kwargs
    ):
        """
        :keyword sku: Required. Gets or sets the SKU name. Required.
        :paramtype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
        :keyword kind: Required. Indicates the type of storage account. Required. Known values are:
         "Storage", "StorageV2", "BlobStorage", "FileStorage", and "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
        :keyword location: Required. Gets or sets the location of the resource. This will be one of the
         supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The
         geo region of a resource cannot be changed once it is created, but if an identical geo region
         is specified on update, the request will succeed. Required.
        :paramtype location: str
        :keyword extended_location: Optional. Set the extended location of the resource. If not set,
         the storage account will be created in Azure main region. Otherwise it will be created in the
         specified extended location.
        :paramtype extended_location: ~azure.mgmt.storage.v2022_09_01.models.ExtendedLocation
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used for viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key with a length no greater than 128
         characters and a value with a length no greater than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
        :keyword allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
         with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
        :paramtype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
        :keyword public_network_access: Allow or disallow public network access to Storage Account.
         Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
        :keyword sas_policy: SasPolicy assigned to the storage account.
        :paramtype sas_policy: ~azure.mgmt.storage.v2022_09_01.models.SasPolicy
        :keyword key_policy: KeyPolicy assigned to the storage account.
        :paramtype key_policy: ~azure.mgmt.storage.v2022_09_01.models.KeyPolicy
        :keyword custom_domain: User domain assigned to the storage account. Name is the CNAME source.
         Only one custom domain is supported per storage account at this time. To clear the existing
         custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2022_09_01.models.CustomDomain
        :keyword encryption: Encryption settings to be used for server-side encryption for the storage
         account.
        :paramtype encryption: ~azure.mgmt.storage.v2022_09_01.models.Encryption
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2022_09_01.models.NetworkRuleSet
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         is used for billing. The 'Premium' access tier is the default value for premium block blobs
         storage account type and it cannot be changed for the premium block blobs storage account type.
         Known values are: "Hot", "Cool", and "Premium".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.AccessTier
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true. The default value is true since API version 2019-04-01.
        :paramtype enable_https_traffic_only: bool
        :keyword is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
        :paramtype is_sftp_enabled: bool
        :keyword is_local_user_enabled: Enables local users feature, if set to true.
        :paramtype is_local_user_enabled: bool
        :keyword is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
        :paramtype is_hns_enabled: bool
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Known values are: "Disabled" and "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
        :keyword routing_preference: Maintains information about the network routing choice opted by
         the user for data transfer.
        :paramtype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0",
         "TLS1_1", and "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        :keyword enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
        :paramtype enable_nfs_v3: bool
        :keyword allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
         The default interpretation is true for this property.
        :paramtype allow_cross_tenant_replication: bool
        :keyword default_to_o_auth_authentication: A boolean flag which indicates whether the default
         authentication is OAuth or not. The default interpretation is false for this property.
        :paramtype default_to_o_auth_authentication: bool
        :keyword immutable_storage_with_versioning: The property is immutable and can only be set to
         true at the account creation time. When set to true, it enables object level immutability for
         all the new containers in the account by default.
        :paramtype immutable_storage_with_versioning:
         ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
        :keyword dns_endpoint_type: Allows you to specify the type of endpoint. Set this to
         AzureDNSZone to create a large number of accounts in a single subscription, which creates
         accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone
         identifier. Known values are: "Standard" and "AzureDnsZone".
        :paramtype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.location = location
        self.extended_location = extended_location
        self.tags = tags
        self.identity = identity
        self.allowed_copy_scope = allowed_copy_scope
        self.public_network_access = public_network_access
        self.sas_policy = sas_policy
        self.key_policy = key_policy
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.network_rule_set = network_rule_set
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.is_sftp_enabled = is_sftp_enabled
        self.is_local_user_enabled = is_local_user_enabled
        self.is_hns_enabled = is_hns_enabled
        self.large_file_shares_state = large_file_shares_state
        self.routing_preference = routing_preference
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access
        self.enable_nfs_v3 = enable_nfs_v3
        self.allow_cross_tenant_replication = allow_cross_tenant_replication
        self.default_to_o_auth_authentication = default_to_o_auth_authentication
        self.immutable_storage_with_versioning = immutable_storage_with_versioning
        self.dns_endpoint_type = dns_endpoint_type


class StorageAccountInternetEndpoints(_serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        "blob": {"readonly": True},
        "file": {"readonly": True},
        "web": {"readonly": True},
        "dfs": {"readonly": True},
    }

    _attribute_map = {
        "blob": {"key": "blob", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "web": {"key": "web", "type": "str"},
        "dfs": {"key": "dfs", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.blob = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountKey(_serialization.Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full permissions. Known values are:
     "Read" and "Full".
    :vartype permissions: str or ~azure.mgmt.storage.v2022_09_01.models.KeyPermission
    :ivar creation_time: Creation time of the key, in round trip date format.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "key_name": {"readonly": True},
        "value": {"readonly": True},
        "permissions": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "permissions": {"key": "permissions", "type": "str"},
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None
        self.creation_time = None


class StorageAccountListKeysResult(_serialization.Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for the specified
     storage account.
    :vartype keys: list[~azure.mgmt.storage.v2022_09_01.models.StorageAccountKey]
    """

    _validation = {
        "keys": {"readonly": True},
    }

    _attribute_map = {
        "keys": {"key": "keys", "type": "[StorageAccountKey]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.keys = None


class StorageAccountListResult(_serialization.Model):
    """The response from the List Storage Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.StorageAccount]
    :ivar next_link: Request URL that can be used to query next page of storage accounts. Returned
     when total number of requested storage accounts exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccount]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageAccountMicrosoftEndpoints(_serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via a microsoft routing endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        "blob": {"readonly": True},
        "queue": {"readonly": True},
        "table": {"readonly": True},
        "file": {"readonly": True},
        "web": {"readonly": True},
        "dfs": {"readonly": True},
    }

    _attribute_map = {
        "blob": {"key": "blob", "type": "str"},
        "queue": {"key": "queue", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "web": {"key": "web", "type": "str"},
        "dfs": {"key": "dfs", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountRegenerateKeyParameters(_serialization.Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: The name of storage keys that want to be regenerated, possible values are key1,
     key2, kerb1, kerb2. Required.
    :vartype key_name: str
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: str, **kwargs):
        """
        :keyword key_name: The name of storage keys that want to be regenerated, possible values are
         key1, key2, kerb1, kerb2. Required.
        :paramtype key_name: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class StorageAccountSkuConversionStatus(_serialization.Model):
    """This defines the sku conversion status object for asynchronous sku conversions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku_conversion_status: This property indicates the current sku conversion status. Known
     values are: "InProgress", "Succeeded", and "Failed".
    :vartype sku_conversion_status: str or
     ~azure.mgmt.storage.v2022_09_01.models.SkuConversionStatus
    :ivar target_sku_name: This property represents the target sku name to which the account sku is
     being converted asynchronously. Known values are: "Standard_LRS", "Standard_GRS",
     "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS", "Standard_GZRS", and
     "Standard_RAGZRS".
    :vartype target_sku_name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
    :ivar start_time: This property represents the sku conversion start time.
    :vartype start_time: str
    :ivar end_time: This property represents the sku conversion end time.
    :vartype end_time: str
    """

    _validation = {
        "sku_conversion_status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "sku_conversion_status": {"key": "skuConversionStatus", "type": "str"},
        "target_sku_name": {"key": "targetSkuName", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
    }

    def __init__(self, *, target_sku_name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs):
        """
        :keyword target_sku_name: This property represents the target sku name to which the account sku
         is being converted asynchronously. Known values are: "Standard_LRS", "Standard_GRS",
         "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS", "Standard_GZRS", and
         "Standard_RAGZRS".
        :paramtype target_sku_name: str or ~azure.mgmt.storage.v2022_09_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.sku_conversion_status = None
        self.target_sku_name = target_sku_name
        self.start_time = None
        self.end_time = None


class StorageAccountUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The parameters that can be provided when updating the storage account properties.

    :ivar sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to Standard_ZRS,
     Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any other value.
    :vartype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
    :ivar kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
     supported by server. Known values are: "Storage", "StorageV2", "BlobStorage", "FileStorage",
     and "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
    :ivar custom_domain: Custom domain assigned to the storage account by the user. Name is the
     CNAME source. Only one custom domain is supported per storage account at this time. To clear
     the existing custom domain, use an empty string for the custom domain name property.
    :vartype custom_domain: ~azure.mgmt.storage.v2022_09_01.models.CustomDomain
    :ivar encryption: Not applicable. Azure Storage encryption at rest is enabled by default for
     all storage accounts and cannot be disabled.
    :vartype encryption: ~azure.mgmt.storage.v2022_09_01.models.Encryption
    :ivar sas_policy: SasPolicy assigned to the storage account.
    :vartype sas_policy: ~azure.mgmt.storage.v2022_09_01.models.SasPolicy
    :ivar key_policy: KeyPolicy assigned to the storage account.
    :vartype key_policy: ~azure.mgmt.storage.v2022_09_01.models.KeyPolicy
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier is
     used for billing. The 'Premium' access tier is the default value for premium block blobs
     storage account type and it cannot be changed for the premium block blobs storage account type.
     Known values are: "Hot", "Cool", and "Premium".
    :vartype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.AccessTier
    :ivar azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :vartype azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
    :ivar enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :vartype enable_https_traffic_only: bool
    :ivar is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
    :vartype is_sftp_enabled: bool
    :ivar is_local_user_enabled: Enables local users feature, if set to true.
    :vartype is_local_user_enabled: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2022_09_01.models.NetworkRuleSet
    :ivar large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Known values are: "Disabled" and "Enabled".
    :vartype large_file_shares_state: str or
     ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
    :ivar routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :vartype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
    :ivar allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :vartype allow_blob_public_access: bool
    :ivar minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0", "TLS1_1",
     and "TLS1_2".
    :vartype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
    :ivar allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :vartype allow_shared_key_access: bool
    :ivar allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :vartype allow_cross_tenant_replication: bool
    :ivar default_to_o_auth_authentication: A boolean flag which indicates whether the default
     authentication is OAuth or not. The default interpretation is false for this property.
    :vartype default_to_o_auth_authentication: bool
    :ivar public_network_access: Allow or disallow public network access to Storage Account. Value
     is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
    :ivar immutable_storage_with_versioning: The property is immutable and can only be set to true
     at the account creation time. When set to true, it enables object level immutability for all
     the containers in the account by default.
    :vartype immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
    :ivar allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
     with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
    :vartype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
    :ivar dns_endpoint_type: Allows you to specify the type of endpoint. Set this to AzureDNSZone
     to create a large number of accounts in a single subscription, which creates accounts in an
     Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier. Known values
     are: "Standard" and "AzureDnsZone".
    :vartype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "kind": {"key": "kind", "type": "str"},
        "custom_domain": {"key": "properties.customDomain", "type": "CustomDomain"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "sas_policy": {"key": "properties.sasPolicy", "type": "SasPolicy"},
        "key_policy": {"key": "properties.keyPolicy", "type": "KeyPolicy"},
        "access_tier": {"key": "properties.accessTier", "type": "str"},
        "azure_files_identity_based_authentication": {
            "key": "properties.azureFilesIdentityBasedAuthentication",
            "type": "AzureFilesIdentityBasedAuthentication",
        },
        "enable_https_traffic_only": {"key": "properties.supportsHttpsTrafficOnly", "type": "bool"},
        "is_sftp_enabled": {"key": "properties.isSftpEnabled", "type": "bool"},
        "is_local_user_enabled": {"key": "properties.isLocalUserEnabled", "type": "bool"},
        "network_rule_set": {"key": "properties.networkAcls", "type": "NetworkRuleSet"},
        "large_file_shares_state": {"key": "properties.largeFileSharesState", "type": "str"},
        "routing_preference": {"key": "properties.routingPreference", "type": "RoutingPreference"},
        "allow_blob_public_access": {"key": "properties.allowBlobPublicAccess", "type": "bool"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "allow_shared_key_access": {"key": "properties.allowSharedKeyAccess", "type": "bool"},
        "allow_cross_tenant_replication": {"key": "properties.allowCrossTenantReplication", "type": "bool"},
        "default_to_o_auth_authentication": {"key": "properties.defaultToOAuthAuthentication", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "immutable_storage_with_versioning": {
            "key": "properties.immutableStorageWithVersioning",
            "type": "ImmutableStorageAccount",
        },
        "allowed_copy_scope": {"key": "properties.allowedCopyScope", "type": "str"},
        "dns_endpoint_type": {"key": "properties.dnsEndpointType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        custom_domain: Optional["_models.CustomDomain"] = None,
        encryption: Optional["_models.Encryption"] = None,
        sas_policy: Optional["_models.SasPolicy"] = None,
        key_policy: Optional["_models.KeyPolicy"] = None,
        access_tier: Optional[Union[str, "_models.AccessTier"]] = None,
        azure_files_identity_based_authentication: Optional["_models.AzureFilesIdentityBasedAuthentication"] = None,
        enable_https_traffic_only: Optional[bool] = None,
        is_sftp_enabled: Optional[bool] = None,
        is_local_user_enabled: Optional[bool] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        large_file_shares_state: Optional[Union[str, "_models.LargeFileSharesState"]] = None,
        routing_preference: Optional["_models.RoutingPreference"] = None,
        allow_blob_public_access: Optional[bool] = None,
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        allow_shared_key_access: Optional[bool] = None,
        allow_cross_tenant_replication: Optional[bool] = None,
        default_to_o_auth_authentication: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        immutable_storage_with_versioning: Optional["_models.ImmutableStorageAccount"] = None,
        allowed_copy_scope: Optional[Union[str, "_models.AllowedCopyScope"]] = None,
        dns_endpoint_type: Optional[Union[str, "_models.DnsEndpointType"]] = None,
        **kwargs
    ):
        """
        :keyword sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to
         Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any
         other value.
        :paramtype sku: ~azure.mgmt.storage.v2022_09_01.models.Sku
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used in viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key no greater in length than 128
         characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storage.v2022_09_01.models.Identity
        :keyword kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
         supported by server. Known values are: "Storage", "StorageV2", "BlobStorage", "FileStorage",
         and "BlockBlobStorage".
        :paramtype kind: str or ~azure.mgmt.storage.v2022_09_01.models.Kind
        :keyword custom_domain: Custom domain assigned to the storage account by the user. Name is the
         CNAME source. Only one custom domain is supported per storage account at this time. To clear
         the existing custom domain, use an empty string for the custom domain name property.
        :paramtype custom_domain: ~azure.mgmt.storage.v2022_09_01.models.CustomDomain
        :keyword encryption: Not applicable. Azure Storage encryption at rest is enabled by default for
         all storage accounts and cannot be disabled.
        :paramtype encryption: ~azure.mgmt.storage.v2022_09_01.models.Encryption
        :keyword sas_policy: SasPolicy assigned to the storage account.
        :paramtype sas_policy: ~azure.mgmt.storage.v2022_09_01.models.SasPolicy
        :keyword key_policy: KeyPolicy assigned to the storage account.
        :paramtype key_policy: ~azure.mgmt.storage.v2022_09_01.models.KeyPolicy
        :keyword access_tier: Required for storage accounts where kind = BlobStorage. The access tier
         is used for billing. The 'Premium' access tier is the default value for premium block blobs
         storage account type and it cannot be changed for the premium block blobs storage account type.
         Known values are: "Hot", "Cool", and "Premium".
        :paramtype access_tier: str or ~azure.mgmt.storage.v2022_09_01.models.AccessTier
        :keyword azure_files_identity_based_authentication: Provides the identity based authentication
         settings for Azure Files.
        :paramtype azure_files_identity_based_authentication:
         ~azure.mgmt.storage.v2022_09_01.models.AzureFilesIdentityBasedAuthentication
        :keyword enable_https_traffic_only: Allows https traffic only to storage service if sets to
         true.
        :paramtype enable_https_traffic_only: bool
        :keyword is_sftp_enabled: Enables Secure File Transfer Protocol, if set to true.
        :paramtype is_sftp_enabled: bool
        :keyword is_local_user_enabled: Enables local users feature, if set to true.
        :paramtype is_local_user_enabled: bool
        :keyword network_rule_set: Network rule set.
        :paramtype network_rule_set: ~azure.mgmt.storage.v2022_09_01.models.NetworkRuleSet
        :keyword large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
         disabled once it is enabled. Known values are: "Disabled" and "Enabled".
        :paramtype large_file_shares_state: str or
         ~azure.mgmt.storage.v2022_09_01.models.LargeFileSharesState
        :keyword routing_preference: Maintains information about the network routing choice opted by
         the user for data transfer.
        :paramtype routing_preference: ~azure.mgmt.storage.v2022_09_01.models.RoutingPreference
        :keyword allow_blob_public_access: Allow or disallow public access to all blobs or containers
         in the storage account. The default interpretation is true for this property.
        :paramtype allow_blob_public_access: bool
        :keyword minimum_tls_version: Set the minimum TLS version to be permitted on requests to
         storage. The default interpretation is TLS 1.0 for this property. Known values are: "TLS1_0",
         "TLS1_1", and "TLS1_2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.storage.v2022_09_01.models.MinimumTlsVersion
        :keyword allow_shared_key_access: Indicates whether the storage account permits requests to be
         authorized with the account access key via Shared Key. If false, then all requests, including
         shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
         default value is null, which is equivalent to true.
        :paramtype allow_shared_key_access: bool
        :keyword allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
         The default interpretation is true for this property.
        :paramtype allow_cross_tenant_replication: bool
        :keyword default_to_o_auth_authentication: A boolean flag which indicates whether the default
         authentication is OAuth or not. The default interpretation is false for this property.
        :paramtype default_to_o_auth_authentication: bool
        :keyword public_network_access: Allow or disallow public network access to Storage Account.
         Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.storage.v2022_09_01.models.PublicNetworkAccess
        :keyword immutable_storage_with_versioning: The property is immutable and can only be set to
         true at the account creation time. When set to true, it enables object level immutability for
         all the containers in the account by default.
        :paramtype immutable_storage_with_versioning:
         ~azure.mgmt.storage.v2022_09_01.models.ImmutableStorageAccount
        :keyword allowed_copy_scope: Restrict copy to and from Storage Accounts within an AAD tenant or
         with Private Links to the same VNet. Known values are: "PrivateLink" and "AAD".
        :paramtype allowed_copy_scope: str or ~azure.mgmt.storage.v2022_09_01.models.AllowedCopyScope
        :keyword dns_endpoint_type: Allows you to specify the type of endpoint. Set this to
         AzureDNSZone to create a large number of accounts in a single subscription, which creates
         accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone
         identifier. Known values are: "Standard" and "AzureDnsZone".
        :paramtype dns_endpoint_type: str or ~azure.mgmt.storage.v2022_09_01.models.DnsEndpointType
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.identity = identity
        self.kind = kind
        self.custom_domain = custom_domain
        self.encryption = encryption
        self.sas_policy = sas_policy
        self.key_policy = key_policy
        self.access_tier = access_tier
        self.azure_files_identity_based_authentication = azure_files_identity_based_authentication
        self.enable_https_traffic_only = enable_https_traffic_only
        self.is_sftp_enabled = is_sftp_enabled
        self.is_local_user_enabled = is_local_user_enabled
        self.network_rule_set = network_rule_set
        self.large_file_shares_state = large_file_shares_state
        self.routing_preference = routing_preference
        self.allow_blob_public_access = allow_blob_public_access
        self.minimum_tls_version = minimum_tls_version
        self.allow_shared_key_access = allow_shared_key_access
        self.allow_cross_tenant_replication = allow_cross_tenant_replication
        self.default_to_o_auth_authentication = default_to_o_auth_authentication
        self.public_network_access = public_network_access
        self.immutable_storage_with_versioning = immutable_storage_with_versioning
        self.allowed_copy_scope = allowed_copy_scope
        self.dns_endpoint_type = dns_endpoint_type


class StorageQueue(Resource):
    """StorageQueue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar metadata: A name-value pair that represents queue metadata.
    :vartype metadata: dict[str, str]
    :ivar approximate_message_count: Integer indicating an approximate number of messages in the
     queue. This number is not lower than the actual number of messages in the queue, but could be
     higher.
    :vartype approximate_message_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "approximate_message_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "approximate_message_count": {"key": "properties.approximateMessageCount", "type": "int"},
    }

    def __init__(self, *, metadata: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword metadata: A name-value pair that represents queue metadata.
        :paramtype metadata: dict[str, str]
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.approximate_message_count = None


class StorageSkuListResult(_serialization.Model):
    """The response from the List Storage SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Get the list result of storage SKUs and their properties.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.SkuInformation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInformation]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storage.v2022_09_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storage.v2022_09_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storage.v2022_09_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storage.v2022_09_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Table(Resource):
    """Properties of the table, including Id, resource name, resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar table_name: Table name under the specified account.
    :vartype table_name: str
    :ivar signed_identifiers: List of stored access policies specified on the table.
    :vartype signed_identifiers: list[~azure.mgmt.storage.v2022_09_01.models.TableSignedIdentifier]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "table_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
        "signed_identifiers": {"key": "properties.signedIdentifiers", "type": "[TableSignedIdentifier]"},
    }

    def __init__(self, *, signed_identifiers: Optional[List["_models.TableSignedIdentifier"]] = None, **kwargs):
        """
        :keyword signed_identifiers: List of stored access policies specified on the table.
        :paramtype signed_identifiers:
         list[~azure.mgmt.storage.v2022_09_01.models.TableSignedIdentifier]
        """
        super().__init__(**kwargs)
        self.table_name = None
        self.signed_identifiers = signed_identifiers


class TableAccessPolicy(_serialization.Model):
    """Table Access Policy Properties Object.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: Start time of the access policy.
    :vartype start_time: ~datetime.datetime
    :ivar expiry_time: Expiry time of the access policy.
    :vartype expiry_time: ~datetime.datetime
    :ivar permission: Required. List of abbreviated permissions. Supported permission values
     include 'r','a','u','d'. Required.
    :vartype permission: str
    """

    _validation = {
        "permission": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "permission": {"key": "permission", "type": "str"},
    }

    def __init__(
        self,
        *,
        permission: str,
        start_time: Optional[datetime.datetime] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time of the access policy.
        :paramtype start_time: ~datetime.datetime
        :keyword expiry_time: Expiry time of the access policy.
        :paramtype expiry_time: ~datetime.datetime
        :keyword permission: Required. List of abbreviated permissions. Supported permission values
         include 'r','a','u','d'. Required.
        :paramtype permission: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.expiry_time = expiry_time
        self.permission = permission


class TableServiceProperties(Resource):
    """The properties of a storage account’s Table service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar cors: Specifies CORS rules for the Table service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Table service.
    :vartype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cors": {"key": "properties.cors", "type": "CorsRules"},
    }

    def __init__(self, *, cors: Optional["_models.CorsRules"] = None, **kwargs):
        """
        :keyword cors: Specifies CORS rules for the Table service. You can include up to five CorsRule
         elements in the request. If no CorsRule elements are included in the request body, all CORS
         rules will be deleted, and CORS will be disabled for the Table service.
        :paramtype cors: ~azure.mgmt.storage.v2022_09_01.models.CorsRules
        """
        super().__init__(**kwargs)
        self.cors = cors


class TableSignedIdentifier(_serialization.Model):
    """Object to set Table Access Policy.

    All required parameters must be populated in order to send to Azure.

    :ivar id: unique-64-character-value of the stored access policy. Required.
    :vartype id: str
    :ivar access_policy: Access policy.
    :vartype access_policy: ~azure.mgmt.storage.v2022_09_01.models.TableAccessPolicy
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "access_policy": {"key": "accessPolicy", "type": "TableAccessPolicy"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        access_policy: Optional["_models.TableAccessPolicy"] = None,
        **kwargs
    ):
        """
        :keyword id: unique-64-character-value of the stored access policy. Required.
        :paramtype id: str
        :keyword access_policy: Access policy.
        :paramtype access_policy: ~azure.mgmt.storage.v2022_09_01.models.TableAccessPolicy
        """
        super().__init__(**kwargs)
        self.id = id
        self.access_policy = access_policy


class TagFilter(_serialization.Model):
    """Blob index tag based filtering for blob objects.

    All required parameters must be populated in order to send to Azure.

    :ivar name: This is the filter tag name, it can have 1 - 128 characters. Required.
    :vartype name: str
    :ivar op: This is the comparison operator which is used for object comparison and filtering.
     Only == (equality operator) is currently supported. Required.
    :vartype op: str
    :ivar value: This is the filter tag value field used for tag based filtering, it can have 0 -
     256 characters. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True, "max_length": 128, "min_length": 1},
        "op": {"required": True},
        "value": {"required": True, "max_length": 256},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "op": {"key": "op", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, op: str, value: str, **kwargs):
        """
        :keyword name: This is the filter tag name, it can have 1 - 128 characters. Required.
        :paramtype name: str
        :keyword op: This is the comparison operator which is used for object comparison and filtering.
         Only == (equality operator) is currently supported. Required.
        :paramtype op: str
        :keyword value: This is the filter tag value field used for tag based filtering, it can have 0
         - 256 characters. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.op = op
        self.value = value


class TagProperty(_serialization.Model):
    """A tag of the LegalHold of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tag: The tag value.
    :vartype tag: str
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who added the tag.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who added the tag.
    :vartype upn: str
    """

    _validation = {
        "tag": {"readonly": True},
        "timestamp": {"readonly": True},
        "object_identifier": {"readonly": True},
        "tenant_id": {"readonly": True},
        "upn": {"readonly": True},
    }

    _attribute_map = {
        "tag": {"key": "tag", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "object_identifier": {"key": "objectIdentifier", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.tag = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class UpdateHistoryProperty(_serialization.Model):
    """An update history of the ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar update: The ImmutabilityPolicy update type of a blob container, possible values include:
     put, lock and extend. Known values are: "put", "lock", and "extend".
    :vartype update: str or ~azure.mgmt.storage.v2022_09_01.models.ImmutabilityPolicyUpdateType
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar timestamp: Returns the date and time the ImmutabilityPolicy was updated.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who updated the
     ImmutabilityPolicy.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
    :vartype upn: str
    :ivar allow_protected_append_writes: This property can only be changed for unlocked time-based
     retention policies. When enabled, new blocks can be written to an append blob while maintaining
     immutability protection and compliance. Only new blocks can be added and any existing blocks
     cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
     API.
    :vartype allow_protected_append_writes: bool
    :ivar allow_protected_append_writes_all: This property can only be changed for unlocked
     time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
     Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
     and any existing blocks cannot be modified or deleted. This property cannot be changed with
     ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
     'allowProtectedAppendWritesAll' properties are mutually exclusive.
    :vartype allow_protected_append_writes_all: bool
    """

    _validation = {
        "update": {"readonly": True},
        "immutability_period_since_creation_in_days": {"readonly": True},
        "timestamp": {"readonly": True},
        "object_identifier": {"readonly": True},
        "tenant_id": {"readonly": True},
        "upn": {"readonly": True},
    }

    _attribute_map = {
        "update": {"key": "update", "type": "str"},
        "immutability_period_since_creation_in_days": {"key": "immutabilityPeriodSinceCreationInDays", "type": "int"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "object_identifier": {"key": "objectIdentifier", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "allow_protected_append_writes": {"key": "allowProtectedAppendWrites", "type": "bool"},
        "allow_protected_append_writes_all": {"key": "allowProtectedAppendWritesAll", "type": "bool"},
    }

    def __init__(
        self,
        *,
        allow_protected_append_writes: Optional[bool] = None,
        allow_protected_append_writes_all: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword allow_protected_append_writes: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to an append blob while
         maintaining immutability protection and compliance. Only new blocks can be added and any
         existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API.
        :paramtype allow_protected_append_writes: bool
        :keyword allow_protected_append_writes_all: This property can only be changed for unlocked
         time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock
         Blobs' while maintaining immutability protection and compliance. Only new blocks can be added
         and any existing blocks cannot be modified or deleted. This property cannot be changed with
         ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
         'allowProtectedAppendWritesAll' properties are mutually exclusive.
        :paramtype allow_protected_append_writes_all: bool
        """
        super().__init__(**kwargs)
        self.update = None
        self.immutability_period_since_creation_in_days = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None
        self.allow_protected_append_writes = allow_protected_append_writes
        self.allow_protected_append_writes_all = allow_protected_append_writes_all


class Usage(_serialization.Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Known values are: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", and "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.storage.v2022_09_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2022_09_01.models.UsageName
    """

    _validation = {
        "unit": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(_serialization.Model):
    """The response from the List Usages operation.

    :ivar value: Gets or sets the list of Storage Resource Usages.
    :vartype value: list[~azure.mgmt.storage.v2022_09_01.models.Usage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, **kwargs):
        """
        :keyword value: Gets or sets the list of Storage Resource Usages.
        :paramtype value: list[~azure.mgmt.storage.v2022_09_01.models.Usage]
        """
        super().__init__(**kwargs)
        self.value = value


class UsageName(_serialization.Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.localized_value = None


class UserAssignedIdentity(_serialization.Model):
    """UserAssignedIdentity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_resource_id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     Required.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. Default value is "Allow".
    :vartype action: str
    :ivar state: Gets the state of virtual network rule. Known values are: "Provisioning",
     "Deprovisioning", "Succeeded", "Failed", and "NetworkSourceDeleted".
    :vartype state: str or ~azure.mgmt.storage.v2022_09_01.models.State
    """

    _validation = {
        "virtual_network_resource_id": {"required": True},
    }

    _attribute_map = {
        "virtual_network_resource_id": {"key": "id", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[Literal["Allow"]] = None,
        state: Optional[Union[str, "_models.State"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_resource_id: Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
         Required.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. Default value is "Allow".
        :paramtype action: str
        :keyword state: Gets the state of virtual network rule. Known values are: "Provisioning",
         "Deprovisioning", "Succeeded", "Failed", and "NetworkSourceDeleted".
        :paramtype state: str or ~azure.mgmt.storage.v2022_09_01.models.State
        """
        super().__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action
        self.state = state
