# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import TestBaseConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AnalysisResultsOperations,
    AvailableOSOperations,
    BillingHubServiceOperations,
    CustomerEventsOperations,
    EmailEventsOperations,
    FavoriteProcessesOperations,
    FlightingRingsOperations,
    OSUpdatesOperations,
    Operations,
    PackagesOperations,
    SkusOperations,
    TestBaseAccountsOperations,
    TestResultsOperations,
    TestSummariesOperations,
    TestTypesOperations,
    UsageOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class TestBase:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Test Base.

    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.testbase.operations.SkusOperations
    :ivar test_base_accounts: TestBaseAccountsOperations operations
    :vartype test_base_accounts: azure.mgmt.testbase.operations.TestBaseAccountsOperations
    :ivar usage: UsageOperations operations
    :vartype usage: azure.mgmt.testbase.operations.UsageOperations
    :ivar available_os: AvailableOSOperations operations
    :vartype available_os: azure.mgmt.testbase.operations.AvailableOSOperations
    :ivar flighting_rings: FlightingRingsOperations operations
    :vartype flighting_rings: azure.mgmt.testbase.operations.FlightingRingsOperations
    :ivar test_types: TestTypesOperations operations
    :vartype test_types: azure.mgmt.testbase.operations.TestTypesOperations
    :ivar packages: PackagesOperations operations
    :vartype packages: azure.mgmt.testbase.operations.PackagesOperations
    :ivar test_summaries: TestSummariesOperations operations
    :vartype test_summaries: azure.mgmt.testbase.operations.TestSummariesOperations
    :ivar test_results: TestResultsOperations operations
    :vartype test_results: azure.mgmt.testbase.operations.TestResultsOperations
    :ivar os_updates: OSUpdatesOperations operations
    :vartype os_updates: azure.mgmt.testbase.operations.OSUpdatesOperations
    :ivar favorite_processes: FavoriteProcessesOperations operations
    :vartype favorite_processes: azure.mgmt.testbase.operations.FavoriteProcessesOperations
    :ivar analysis_results: AnalysisResultsOperations operations
    :vartype analysis_results: azure.mgmt.testbase.operations.AnalysisResultsOperations
    :ivar email_events: EmailEventsOperations operations
    :vartype email_events: azure.mgmt.testbase.operations.EmailEventsOperations
    :ivar customer_events: CustomerEventsOperations operations
    :vartype customer_events: azure.mgmt.testbase.operations.CustomerEventsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.testbase.operations.Operations
    :ivar billing_hub_service: BillingHubServiceOperations operations
    :vartype billing_hub_service: azure.mgmt.testbase.operations.BillingHubServiceOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The Azure subscription ID. This is a GUID-formatted string. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-04-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = TestBaseConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.test_base_accounts = TestBaseAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usage = UsageOperations(self._client, self._config, self._serialize, self._deserialize)
        self.available_os = AvailableOSOperations(self._client, self._config, self._serialize, self._deserialize)
        self.flighting_rings = FlightingRingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.test_types = TestTypesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.packages = PackagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.test_summaries = TestSummariesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.test_results = TestResultsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.os_updates = OSUpdatesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.favorite_processes = FavoriteProcessesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.analysis_results = AnalysisResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.email_events = EmailEventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.customer_events = CustomerEventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.billing_hub_service = BillingHubServiceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> TestBase
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
