# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ApplicationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WordPress instance provisioning state."""

    NOT_SPECIFIED = "NotSpecified"
    ACCEPTED = "Accepted"
    CREATED = "Created"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    INSTALLING = "Installing"


class AzureFrontDoorEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to enable Azure front door."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CentralServerVirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of central server VM."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    UNKNOWN = "Unknown"
    ASCS = "ASCS"
    ERS_INACTIVE = "ERSInactive"
    ERS = "ERS"
    STANDBY = "Standby"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DatabaseTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of the server SKU."""

    BURSTABLE = "Burstable"
    GENERAL_PURPOSE = "GeneralPurpose"
    MEMORY_OPTIMIZED = "MemoryOptimized"


class DatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database type."""

    MY_SQL = "MySql"


class DiskStorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage type."""

    PREMIUM_LRS = "Premium_LRS"
    STANDARD_LRS = "Standard_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"


class EnableBackup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to enable Azure backup for the workload."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class EnableSslEnforcement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to enable SSL enforcement on the database."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class EnqueueReplicationServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of Enqueue Replication Server."""

    ENQUEUE_REPLICATOR1 = "EnqueueReplicator1"
    ENQUEUE_REPLICATOR2 = "EnqueueReplicator2"


class FileShareStorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """File share backing storage type."""

    STANDARD_LRS = "Standard_LRS"
    STANDARD_GRS = "Standard_GRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"


class FileShareType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Share type."""

    NFS_ON_CONTROLLER = "NfsOnController"
    AZURE_FILES = "AzureFiles"


class HAEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to enable HA for the server."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class LoadBalancerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Load balancer type."""

    APPLICATION_GATEWAY = "ApplicationGateway"
    LOAD_BALANCER = "LoadBalancer"


class LocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the extended location."""

    REGION = "Region"
    EDGE_ZONE = "EdgeZone"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (only None, UserAssigned types are allowed)."""

    NONE = "None"
    USER_ASSIGNED = "UserAssigned"


class OperationProperties(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the workload operation origin."""

    NOT_SPECIFIED = "NotSpecified"
    USER = "User"
    SYSTEM = "System"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class OSImageOffer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OS image offer."""

    UBUNTU_SERVER = "UbuntuServer"


class OSImagePublisher(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OS image publisher."""

    CANONICAL = "Canonical"


class OSImageSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OS image sku."""

    EIGHTEEN04_LTS = "18.04-LTS"
    SIXTEEN04_LTS = "16.04-LTS"


class OSImageVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OS image version."""

    LATEST = "latest"


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS Type."""

    LINUX = "Linux"
    WINDOWS = "Windows"


class PHPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PHP version."""

    SEVEN2 = "7.2"
    SEVEN3 = "7.3"
    SEVEN4 = "7.4"


class PhpWorkloadProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Php workload resource provisioning state."""

    NOT_SPECIFIED = "NotSpecified"
    ACCEPTED = "Accepted"
    CREATED = "Created"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    DELETING = "Deleting"


class RedisCacheFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cache family."""

    C = "C"
    P = "P"


class RoutingPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to
    the customer VNET.
    """

    DEFAULT = "Default"
    ROUTE_ALL = "RouteAll"


class SAPConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The configuration Type."""

    DEPLOYMENT = "Deployment"
    DISCOVERY = "Discovery"
    DEPLOYMENT_WITH_OS_CONFIG = "DeploymentWithOSConfig"


class SAPDatabaseScaleMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The database scale method."""

    SCALE_UP = "ScaleUp"


class SAPDatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the supported SAP Database types."""

    HANA = "HANA"
    DB2 = "DB2"


class SAPDeploymentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of SAP deployment, single server or Three tier."""

    SINGLE_SERVER = "SingleServer"
    THREE_TIER = "ThreeTier"


class SAPEnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the environment type - Production/Non Production."""

    NON_PROD = "NonProd"
    PROD = "Prod"


class SAPHealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the health of SAP Instances."""

    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    DEGRADED = "Degraded"


class SAPHighAvailabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The high availability Type. AvailabilitySet guarantees 99.95% availability. Availability Zone
    guarantees 99.99% availability.
    """

    AVAILABILITY_SET = "AvailabilitySet"
    AVAILABILITY_ZONE = "AvailabilityZone"


class SAPProductType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Product type."""

    ECC = "ECC"
    S4_HANA = "S4HANA"
    OTHER = "Other"


class SAPSoftwareInstallationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SAP software installation Type."""

    SERVICE_INITIATED = "ServiceInitiated"
    SAP_INSTALL_WITHOUT_OS_CONFIG = "SAPInstallWithoutOSConfig"
    EXTERNAL = "External"


class SapVirtualInstanceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the provisioning states."""

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    CREATING = "Creating"
    FAILED = "Failed"
    DELETING = "Deleting"


class SAPVirtualInstanceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the Virtual Instance for SAP state."""

    INFRASTRUCTURE_DEPLOYMENT_PENDING = "InfrastructureDeploymentPending"
    INFRASTRUCTURE_DEPLOYMENT_IN_PROGRESS = "InfrastructureDeploymentInProgress"
    INFRASTRUCTURE_DEPLOYMENT_FAILED = "InfrastructureDeploymentFailed"
    SOFTWARE_INSTALLATION_PENDING = "SoftwareInstallationPending"
    SOFTWARE_INSTALLATION_IN_PROGRESS = "SoftwareInstallationInProgress"
    SOFTWARE_INSTALLATION_FAILED = "SoftwareInstallationFailed"
    SOFTWARE_DETECTION_IN_PROGRESS = "SoftwareDetectionInProgress"
    SOFTWARE_DETECTION_FAILED = "SoftwareDetectionFailed"
    DISCOVERY_PENDING = "DiscoveryPending"
    DISCOVERY_IN_PROGRESS = "DiscoveryInProgress"
    DISCOVERY_FAILED = "DiscoveryFailed"
    REGISTRATION_COMPLETE = "RegistrationComplete"


class SAPVirtualInstanceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Instance status."""

    STARTING = "Starting"
    RUNNING = "Running"
    STOPPING = "Stopping"
    OFFLINE = "Offline"
    PARTIALLY_RUNNING = "PartiallyRunning"
    UNAVAILABLE = "Unavailable"


class SearchType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Search type."""

    ELASTIC = "Elastic"


class SkuRestrictionReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU restriction reason code."""

    NOT_SPECIFIED = "NotSpecified"
    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class SkuRestrictionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU restriction type."""

    NOT_SPECIFIED = "NotSpecified"
    LOCATION = "Location"
    ZONE = "Zone"


class SkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scale type of the SKU capacity."""

    NONE = "None"
    MANUAL = "Manual"
    AUTOMATIC = "Automatic"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class SslPreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets certificate preference if secure communication is enabled."""

    DISABLED = "Disabled"
    ROOT_CERTIFICATE = "RootCertificate"
    SERVER_CERTIFICATE = "ServerCertificate"


class WordpressVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Application version."""

    FIVE4_3 = "5.4.3"
    FIVE4_2 = "5.4.2"
    FIVE4_1 = "5.4.1"
    FIVE4 = "5.4"


class WorkloadKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates which kind of php workload this resource represent e.g WordPress."""

    WORD_PRESS = "WordPress"


class WorkloadMonitorActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the action type of workload operation."""

    NOT_SPECIFIED = "NotSpecified"
    INTERNAL = "Internal"


class WorkloadMonitorProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of provisioning of the SAP monitor."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"
