# Generated by Django 2.2 on 2022-07-17 19:34

from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('test_app', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CustomSample',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The human/computer readable name.', max_length=100, unique=True, verbose_name='Name')),
                ('percent', models.DecimalField(decimal_places=1, help_text='A number between 0.0 and 100.0 to indicate a percentage of the time this sample will be active.', max_digits=4, verbose_name='Percent')),
                ('note', models.TextField(blank=True, help_text='Note where this Sample is used.', verbose_name='Note')),
                ('created', models.DateTimeField(db_index=True, default=django.utils.timezone.now, help_text='Date when this Sample was created.', verbose_name='Created')),
                ('modified', models.DateTimeField(default=django.utils.timezone.now, help_text='Date when this Sample was last modified.', verbose_name='Modified')),
            ],
            options={
                'verbose_name': 'Sample',
                'verbose_name_plural': 'Samples',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CustomSwitch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The human/computer readable name.', max_length=100, unique=True, verbose_name='Name')),
                ('active', models.BooleanField(default=False, help_text='Is this switch active?', verbose_name='Active')),
                ('note', models.TextField(blank=True, help_text='Note where this Switch is used.', verbose_name='Note')),
                ('created', models.DateTimeField(db_index=True, default=django.utils.timezone.now, help_text='Date when this Switch was created.', verbose_name='Created')),
                ('modified', models.DateTimeField(default=django.utils.timezone.now, help_text='Date when this Switch was last modified.', verbose_name='Modified')),
            ],
            options={
                'verbose_name': 'Switch',
                'verbose_name_plural': 'Switches',
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='companyawareflag',
            name='everyone',
            field=models.BooleanField(blank=True, help_text='Flip this flag on (Yes) or off (No) for everyone, overriding all other settings. Leave as Unknown to use normally.', null=True, verbose_name='Everyone'),
        ),
    ]
