##
##   LTSP server status
##
##   Copyright (C) 2007 Canonical Ltd.
##
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2, or (at your option)
##   any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.

"""
status offers simple functions to check the different 
server processes used by ltsp servers.

Copyright 2007, Canonical Ltd.
"""

import os

def check_server(binary_name):
    """
    checks if binary_name is currently running and returns True/False

    binary_name: name of a server bianry to look for in the processlist (i.e. nfsd)
    """
    status=os.popen('ps -C '+binary_name+' --no-headers')
    for line in status:
        if line:
            return True
    return False

def check_inetd(service):
    """
    checks if service is enabled in /etc/inetd.conf and checks if inetd is
    running. returns True/False
        
    service: service name (i.e. tftp) or a portnumber
    """
    status=os.popen('grep ^'+service+' /etc/inetd.conf')
    if status.read():
        return check_server('inetd')
    return False

def tftp():
    """
    returns True if tftp service is ok
    """
    return check_inetd('tftp')

def ldminfo():
    """
    returns True if ldminfo service is ok
    """
    return check_inetd('9571')

def nbdswap():
    """
    returns True if nbdswap service is ok
    """
    return check_inetd('9572')

def dhcp():
    """
    returns True if dhcp service is ok
    """
    return check_server('dhcpd3')

def nfs():
    """
    returns True if nfs service is ok
    """
    return check_server('nfsd')
