/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "singlemsgshistoryview.h"

#include <QGridLayout>
#include <QDateTime>
#include <QListWidgetItem>
#include <QHeaderView>

#include "singlemessage.h"
#include "singlemsgshistorymodel.h"
#include "qchaticon.h"

SingleMsgsHistoryView::SingleMsgsHistoryView(QWidget *parent) :
  QWidget(parent),
  m_model(NULL)
{
  QGridLayout* grid           = new QGridLayout(this);
  QGridLayout* btns_grid      = new QGridLayout(0);

  m_treeView                  = new QTreeView(this);
  m_layoutCmbx                = new QComboBox(this);
  m_viewFormatLab             = new QLabel(this);
  m_nextNewMessageBtn         = new QToolButton(this);
  m_prevNewMessageBtn         = new QToolButton(this);
  m_nextOpenedMessageBtn      = new QToolButton(this);
  m_prevOpenedMessageBtn      = new QToolButton(this);
  m_closeAllNewMessagesBtn    = new QToolButton(this);
  m_closeAllOpenedMessagesBtn = new QToolButton(this);
  m_currentCloseChbx          = new QCheckBox(this);

  m_nextNewMessageAct         = new QAction(this);
  m_prevNewMessageAct         = new QAction(this);
  m_nextOpenedMessageAct      = new QAction(this);
  m_prevOpenedMessageAct      = new QAction(this);
  m_closeAllNewMessagesAct    = new QAction(this);
  m_closeAllOpenedMessagesAct = new QAction(this);

  m_treeView->header()->setClickable(true);
  m_treeView->header()->setMovable(false);

  m_treeView->setSortingEnabled(true);

  grid->addWidget(m_viewFormatLab            , 0, 0);
  grid->addWidget(m_layoutCmbx               , 0, 1);

  grid->addWidget(m_treeView                 , 1, 0, 1, 3);

  btns_grid->addWidget(m_currentCloseChbx, 0, 4);
  btns_grid->addWidget(new QLabel(tr("New Messages :"), this), 0, 0);
  btns_grid->addWidget(m_prevNewMessageBtn        , 0, 1);
  btns_grid->addWidget(m_nextNewMessageBtn        , 0, 2);
  btns_grid->addWidget(m_closeAllNewMessagesBtn   , 0, 3);

  btns_grid->addWidget(new QLabel(tr("Opened Messages :"), this), 1, 0);
  btns_grid->addWidget(m_prevOpenedMessageBtn     , 1, 1);
  btns_grid->addWidget(m_nextOpenedMessageBtn     , 1, 2);
  btns_grid->addWidget(m_closeAllOpenedMessagesBtn, 1, 3);

  btns_grid->setColumnStretch(4, 1);

  grid->addLayout(btns_grid, 2, 0, 1, 3);

  grid->setColumnStretch(1, 1);
  grid->setColumnStretch(2, 1);

  connect(m_treeView  , SIGNAL(doubleClicked(QModelIndex)), this, SIGNAL(doubleClicked(QModelIndex)));
  connect(m_layoutCmbx, SIGNAL(currentIndexChanged(int))  , this, SLOT  (setTreeLayout(int)));
  connect(m_treeView->header(), SIGNAL(sortIndicatorChanged(int, Qt::SortOrder)), this, SLOT(sort(int, Qt::SortOrder)));

  connect(m_nextNewMessageBtn        , SIGNAL(clicked()), this, SLOT(nextNewMessage()));
  connect(m_prevNewMessageBtn        , SIGNAL(clicked()), this, SLOT(prevNewMessage()));
  connect(m_nextOpenedMessageBtn     , SIGNAL(clicked()), this, SLOT(nextOpenedMessage()));
  connect(m_prevOpenedMessageBtn     , SIGNAL(clicked()), this, SLOT(prevOpenedMessage()));
  connect(m_closeAllNewMessagesBtn   , SIGNAL(clicked()), this, SLOT(closeAllNewMessages()));
  connect(m_closeAllOpenedMessagesBtn, SIGNAL(clicked()), this, SLOT(closeAllOpenedMessages()));

  connect(m_nextNewMessageAct        , SIGNAL(triggered(bool)), this, SLOT(nextNewMessage()));
  connect(m_prevNewMessageAct        , SIGNAL(triggered(bool)), this, SLOT(prevNewMessage()));
  connect(m_nextOpenedMessageAct     , SIGNAL(triggered(bool)), this, SLOT(nextOpenedMessage()));
  connect(m_prevOpenedMessageAct     , SIGNAL(triggered(bool)), this, SLOT(prevOpenedMessage()));
  connect(m_closeAllNewMessagesAct   , SIGNAL(triggered(bool)), this, SLOT(closeAllNewMessages()));
  connect(m_closeAllOpenedMessagesAct, SIGNAL(triggered(bool)), this, SLOT(closeAllOpenedMessages()));

  resize(800, 600);

  retranslate();

  updateShortcuts();
}

SingleMsgsHistoryView::~SingleMsgsHistoryView()
{
}

void SingleMsgsHistoryView::retranslate()
{
  m_layoutCmbx->clear();

  m_layoutCmbx->addItem(tr("Direction / IP - Nickname / Date | Message"), SingleMsgsHistoryModel::IpUserDate);
  m_layoutCmbx->addItem(tr("Direction / Date | IP | Nickname | Message"), SingleMsgsHistoryModel::Date);

  m_viewFormatLab->setText(tr("View Format:"));

  m_nextNewMessageBtn        ->setText(tr("Next new message"));
  m_prevNewMessageBtn        ->setText(tr("Previous new message"));
  m_nextOpenedMessageBtn     ->setText(tr("Next opened message"));
  m_prevOpenedMessageBtn     ->setText(tr("Previous opened message"));
  m_closeAllNewMessagesBtn   ->setText(tr("Close all new messages"));
  m_closeAllOpenedMessagesBtn->setText(tr("Close all opened messages"));

  m_nextNewMessageBtn        ->setToolTip(tr("Next new message"));
  m_prevNewMessageBtn        ->setToolTip(tr("Previous new message"));
  m_nextOpenedMessageBtn     ->setToolTip(tr("Next opened message"));
  m_prevOpenedMessageBtn     ->setToolTip(tr("Previous opened message"));
  m_closeAllNewMessagesBtn   ->setToolTip(tr("Close all new messages"));
  m_closeAllOpenedMessagesBtn->setToolTip(tr("Close all opened messages"));

  m_currentCloseChbx->setText(tr("Close current message before switching to next"));

  m_nextNewMessageBtn        ->setIcon(QIcon(QChatIcon::icon("go-next")));
  m_prevNewMessageBtn        ->setIcon(QIcon(QChatIcon::icon("go-previous")));
  m_nextOpenedMessageBtn     ->setIcon(QIcon(QChatIcon::icon("go-next")));
  m_prevOpenedMessageBtn     ->setIcon(QIcon(QChatIcon::icon("go-previous")));
  m_closeAllNewMessagesBtn   ->setIcon(QIcon(QChatIcon::icon("dialog-close")));
  m_closeAllOpenedMessagesBtn->setIcon(QIcon(QChatIcon::icon("dialog-close")));
}

void SingleMsgsHistoryView::setTreeLayout(int idx)
{
  if(m_model)
  {
    m_model->rebuildTree(m_layoutCmbx->itemData(idx).toInt());

    m_treeView->expandAll();

    m_treeView->resizeColumnToContents(0);
    m_treeView->resizeColumnToContents(1);
    m_treeView->resizeColumnToContents(2);
    m_treeView->resizeColumnToContents(3);

    m_treeView->header()->setClickable(true);
  }
}

void SingleMsgsHistoryView::sort(int column, Qt::SortOrder order)
{
  if(m_model)
    m_model->sort(column, order);
//     m_treeView->sortByColumn(column, order);
}

void SingleMsgsHistoryView::setModel(QAbstractItemModel * model)
{
  m_model = (SingleMsgsHistoryModel*)model;
  m_treeView->setModel(model);
//   m_model->rebuildTree(SingleMsgsHistoryModel::IpUserDate);
}

void SingleMsgsHistoryView::update()
{
  if(m_model) m_model->update();
}

void SingleMsgsHistoryView::updateShortcuts()
{
  QChatSettings* prefs = QChatSettings::settings();

  m_nextNewMessageAct        ->setShortcut(prefs->shortcut("NextNewMessage"));
  m_prevNewMessageAct        ->setShortcut(prefs->shortcut("PrevNewMessage"));
  m_nextOpenedMessageAct     ->setShortcut(prefs->shortcut("NextOpenedMessage"));
  m_prevOpenedMessageAct     ->setShortcut(prefs->shortcut("PrevOpenedMessage"));
  m_closeAllNewMessagesAct   ->setShortcut(prefs->shortcut("CloseAllNewMessages"));
  m_closeAllOpenedMessagesAct->setShortcut(prefs->shortcut("CloseAllOpenedMessages"));
}
