/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDOMFileSystem.h"

#include "DOMFileSystem.h"
#include "DirectoryEntry.h"
#include "JSDirectoryEntry.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMFileSystem);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMFileSystemTableValues[4] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "root", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemRoot), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMFileSystemTable = { 9, 7, JSDOMFileSystemTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMFileSystemConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMFileSystemConstructorTable = { 1, 0, JSDOMFileSystemConstructorTableValues, 0 };
class JSDOMFileSystemConstructor : public DOMConstructorObject {
public:
    JSDOMFileSystemConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMFileSystemConstructor::s_info = { "DOMFileSystemConstructor", &DOMConstructorObject::s_info, &JSDOMFileSystemConstructorTable, 0 };

JSDOMFileSystemConstructor::JSDOMFileSystemConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMFileSystemPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMFileSystemConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMFileSystemConstructor, JSDOMWrapper>(exec, &JSDOMFileSystemConstructorTable, this, propertyName, slot);
}

bool JSDOMFileSystemConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMFileSystemConstructor, JSDOMWrapper>(exec, &JSDOMFileSystemConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMFileSystemPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMFileSystemPrototypeTable = { 1, 0, JSDOMFileSystemPrototypeTableValues, 0 };
static const HashTable* getJSDOMFileSystemPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMFileSystemPrototypeTable);
}

const ClassInfo JSDOMFileSystemPrototype::s_info = { "DOMFileSystemPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSDOMFileSystemPrototypeTable };

JSObject* JSDOMFileSystemPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMFileSystem>(exec, globalObject);
}

static const HashTable* getJSDOMFileSystemTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMFileSystemTable);
}

const ClassInfo JSDOMFileSystem::s_info = { "DOMFileSystem", &JSDOMWrapper::s_info, 0, getJSDOMFileSystemTable };

JSDOMFileSystem::JSDOMFileSystem(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMFileSystem> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMFileSystem::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMFileSystemPrototype(exec->globalData(), globalObject, JSDOMFileSystemPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSDOMFileSystem::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMFileSystem, Base>(exec, getJSDOMFileSystemTable(exec), this, propertyName, slot);
}

bool JSDOMFileSystem::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMFileSystem, Base>(exec, getJSDOMFileSystemTable(exec), this, propertyName, descriptor);
}

JSValue jsDOMFileSystemName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMFileSystem* castedThis = static_cast<JSDOMFileSystem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystem* imp = static_cast<DOMFileSystem*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsDOMFileSystemRoot(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMFileSystem* castedThis = static_cast<JSDOMFileSystem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystem* imp = static_cast<DOMFileSystem*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->root()));
    return result;
}


JSValue jsDOMFileSystemConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMFileSystem* domObject = static_cast<JSDOMFileSystem*>(asObject(slotBase));
    return JSDOMFileSystem::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMFileSystem::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMFileSystemConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSDOMFileSystem* jsDOMFileSystem)
{
    if (jsDOMFileSystem->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMFileSystemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMFileSystem* jsDOMFileSystem = static_cast<JSDOMFileSystem*>(handle.get().asCell());
    if (jsDOMFileSystem->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsDOMFileSystem))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMFileSystemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMFileSystem* jsDOMFileSystem = static_cast<JSDOMFileSystem*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMFileSystem->impl(), jsDOMFileSystem);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMFileSystem* impl)
{
    return wrap<JSDOMFileSystem>(exec, globalObject, impl);
}

DOMFileSystem* toDOMFileSystem(JSC::JSValue value)
{
    return value.inherits(&JSDOMFileSystem::s_info) ? static_cast<JSDOMFileSystem*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
