% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{integrateWithSingleCell}
\alias{integrateWithSingleCell}
\title{Integrate bulk DE results with Bioconductor single-cell RNA-seq datasets}
\usage{
integrateWithSingleCell(res, dds, ...)
}
\arguments{
\item{res}{a results table, as produced via \code{\link{results}}}

\item{dds}{a DESeqDataSet with the bulk gene expression data
(should contain gene-level counts)}

\item{...}{additional arguments passed to the dataset-accessing function}
}
\value{
list containing: res, dds, and a SingleCellExperiment as selected
by the user
}
\description{
A function that assists with integration of bulk DE results tables
with pre-processed scRNA-seq datasets available on Bioconductor,
for downstream visualization tasks. The user is prompted to pick
a scRNA-seq dataset from a menu. The output of the function is
a list with the original results table, bulk gene counts,
and the SingleCellExperiment object selected by the user.
}
\details{
This function assists the user in choosing a datset from a menu of options
that are selected based on the organism of the current dataset.
Currently only human and mouse bulk and single-cell RNA-seq datasets
are supported, and it is assumed that the bulk DE dataset has GENCODE
or Ensembl gene identifiers. Following the selection of the scRNA-seq
dataset, visualization can be performed with a package \code{vizWithSCE},
which can be installed with \code{install_github("KwameForbes/vizWithSCE")}.
}
\examples{

\dontrun{
  # involves interactive menu selection...
  dds <- makeExampleDESeqDataSet()
  rownames(dds) <- paste0("ENSG",1:nrow(dds))
  dds <- DESeq(dds)
  res <- results(dds)
  dat <- integrateWithSingleCell(res, dds)
}

}
\author{
Kwame Forbes
}
