% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{groups_by_filter}
\alias{groups_by_filter}
\title{Stratify hypotheses based on increasing value of the covariate}
\usage{
groups_by_filter(covariate, nbins, ties.method = "random", seed = NULL)
}
\arguments{
\item{covariate}{Numeric vector of ordinal covariates based on which the stratification will be done.}

\item{nbins}{Integer, number of groups/strata into which p-values will be split based on covariate.}

\item{ties.method}{Character specifying how ties are treated, see \code{\link{rank}} function.}

\item{seed}{Integer, specifies random seed to be used when ties.method=="random".}
}
\value{
A factor with nbins different levels, each entry corresponds to the stratum the i-th hypothesis
 was assigned to.
}
\description{
Hypotheses are stratified into nbins different strata of (approximately) equal size based on
increasing value of the covariate
}
\examples{
 covariates <- runif(100)
 groups <- groups_by_filter(covariates,10)
 table(groups)
}
