% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowQuantiles.R
\name{rowQuantiles}
\alias{rowQuantiles}
\alias{rowQuantiles,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowQuantiles,ANY-method}
\alias{colQuantiles}
\alias{colQuantiles,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colQuantiles,ANY-method}
\title{Calculates quantiles for each row (column) of a matrix-like object}
\usage{
rowQuantiles(x, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1,
  by = 0.25), na.rm = FALSE, type = 7L, ..., useNames = NA,
  drop = TRUE)

\S4method{rowQuantiles}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = FALSE,
  type = 7L, ..., useNames = NA, drop = TRUE)

\S4method{rowQuantiles}{ANY}(x, rows = NULL, cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25), na.rm = FALSE, type = 7L,
  ..., useNames = NA, drop = TRUE)

colQuantiles(x, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1,
  by = 0.25), na.rm = FALSE, type = 7L, ..., useNames = NA,
  drop = TRUE)

\S4method{colQuantiles}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = FALSE,
  type = 7L, ..., useNames = NA, drop = TRUE)

\S4method{colQuantiles}{ANY}(x, rows = NULL, cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25), na.rm = FALSE, type = 7L,
  ..., useNames = NA, drop = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{probs}{A numeric vector of J probabilities in [0, 1].}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{type}{An integer specifying the type of estimator. See
\code{stats::\link[stats]{quantile}()}. for more details.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{drop}{If \code{TRUE} a vector is returned if \code{J == 1}.}
}
\value{
a \code{\link{numeric}} \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) for
which the J values are calculated.
}
\description{
Calculates quantiles for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowQuantiles}
/ \code{matrixStats::colQuantiles}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowQuantiles(mat)
  colQuantiles(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowQuantiles}()} and
\code{matrixStats::\link[matrixStats:rowQuantiles]{colQuantiles}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item \link[stats:quantile]{stats::quantile}
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
