% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\name{readRlf}
\alias{readRlf}
\title{Read RLF file}
\usage{
readRlf(rlf)
}
\arguments{
\item{rlf}{Path to the .RLF file}
}
\value{
A data frame containing the contents of the .RLF file.
}
\description{
Reads the contents of an .RLF file into a data frame. RNA \dQuote{spike-in} concentrations recorded in the
GeneName for positive and negative control probes are stripped and stored in a separate
column in the output. An error will be generated for any recognized deviations from the
expected file format.
}
\examples{
rlf <- system.file("extdata", "RLF", "NQCP_example.rlf", package="NanoStringQCPro")
rlf.df <- readRlf(rlf)

}
\author{
Robert Ziman
}
