% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getJobInfo.R
\name{getJobInfo}
\alias{getJobInfo}
\title{Get computational information of jobs.}
\usage{
getJobInfo(reg, ids, pars = FALSE, prefix.pars = FALSE, select,
  unit = "seconds")
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Ids of jobs.
Default is all jobs.}

\item{pars}{[\code{logical(1)}]\cr
Include job parameters in the output?
Default is \code{FALSE}.}

\item{prefix.pars}{[\code{logical(1)}]\cr
Should a prefix be added to job parameter names (column names) to avoid name clashes?
Default is \code{FALSE}.}

\item{select}{[\code{character}]\cr
Select only a subset of columns.
Usually this is not required and you can subset yourself,
but in some rare cases it may be advantageous to not query all information.
Note that the column \dQuote{id} (job id) is always selected.
If not provided, all columns are queried and returned.}

\item{unit}{[\code{character(1)}]\cr
Unit to convert execution and queing times to.
Possible values: \dQuote{seconds}, \dQuote{minutes}, \dQuote{hours},
\dQuote{days} and \dQuote{weeks}.
Default is \dQuote{seconds}.}
}
\value{
[\code{data.frame}].
}
\description{
Returns time stamps (submitted, started, done, error),
time running, approximate memory usage (in Mb),
error messages (shortened, see \code{\link{showLog}} for detailed error messages),
time in queue, hostname of the host the job was executed,
assigned batch ID, the R PID and the seed of the job.

To estimate memory usage the sum of the last column of \code{\link[base]{gc}} is used.

Column \dQuote{time.running} displays the time until either the job was done, or an error occured;
it will by \code{NA} in case of time outs or hard R crashes.
}
\seealso{
Other debug: \code{\link{debugMulticore}},
  \code{\link{debugSSH}}, \code{\link{getErrorMessages}},
  \code{\link{getLogFiles}}, \code{\link{grepLogs}},
  \code{\link{killJobs}}, \code{\link{resetJobs}},
  \code{\link{setJobFunction}}, \code{\link{showLog}},
  \code{\link{testJob}}
}
