% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R
\name{brmsfamily}
\alias{brmsfamily}
\alias{student}
\alias{bernoulli}
\alias{beta_binomial}
\alias{negbinomial}
\alias{geometric}
\alias{lognormal}
\alias{shifted_lognormal}
\alias{skew_normal}
\alias{exponential}
\alias{weibull}
\alias{frechet}
\alias{gen_extreme_value}
\alias{exgaussian}
\alias{wiener}
\alias{Beta}
\alias{dirichlet}
\alias{logistic_normal}
\alias{von_mises}
\alias{asym_laplace}
\alias{cox}
\alias{hurdle_poisson}
\alias{hurdle_negbinomial}
\alias{hurdle_gamma}
\alias{hurdle_lognormal}
\alias{zero_inflated_beta}
\alias{zero_one_inflated_beta}
\alias{zero_inflated_poisson}
\alias{zero_inflated_negbinomial}
\alias{zero_inflated_binomial}
\alias{zero_inflated_beta_binomial}
\alias{categorical}
\alias{multinomial}
\alias{cumulative}
\alias{sratio}
\alias{cratio}
\alias{acat}
\title{Special Family Functions for \pkg{brms} Models}
\usage{
brmsfamily(
  family,
  link = NULL,
  link_sigma = "log",
  link_shape = "log",
  link_nu = "logm1",
  link_phi = "log",
  link_kappa = "log",
  link_beta = "log",
  link_zi = "logit",
  link_hu = "logit",
  link_zoi = "logit",
  link_coi = "logit",
  link_disc = "log",
  link_bs = "log",
  link_ndt = "log",
  link_bias = "logit",
  link_xi = "log1p",
  link_alpha = "identity",
  link_quantile = "logit",
  threshold = "flexible",
  refcat = NULL,
  bhaz = NULL
)

student(link = "identity", link_sigma = "log", link_nu = "logm1")

bernoulli(link = "logit")

beta_binomial(link = "logit", link_phi = "log")

negbinomial(link = "log", link_shape = "log")

geometric(link = "log")

lognormal(link = "identity", link_sigma = "log")

shifted_lognormal(link = "identity", link_sigma = "log", link_ndt = "log")

skew_normal(link = "identity", link_sigma = "log", link_alpha = "identity")

exponential(link = "log")

weibull(link = "log", link_shape = "log")

frechet(link = "log", link_nu = "logm1")

gen_extreme_value(link = "identity", link_sigma = "log", link_xi = "log1p")

exgaussian(link = "identity", link_sigma = "log", link_beta = "log")

wiener(
  link = "identity",
  link_bs = "log",
  link_ndt = "log",
  link_bias = "logit"
)

Beta(link = "logit", link_phi = "log")

dirichlet(link = "logit", link_phi = "log", refcat = NULL)

logistic_normal(link = "identity", link_sigma = "log", refcat = NULL)

von_mises(link = "tan_half", link_kappa = "log")

asym_laplace(link = "identity", link_sigma = "log", link_quantile = "logit")

cox(link = "log", bhaz = NULL)

hurdle_poisson(link = "log")

hurdle_negbinomial(link = "log", link_shape = "log", link_hu = "logit")

hurdle_gamma(link = "log", link_shape = "log", link_hu = "logit")

hurdle_lognormal(link = "identity", link_sigma = "log", link_hu = "logit")

zero_inflated_beta(link = "logit", link_phi = "log", link_zi = "logit")

zero_one_inflated_beta(
  link = "logit",
  link_phi = "log",
  link_zoi = "logit",
  link_coi = "logit"
)

zero_inflated_poisson(link = "log", link_zi = "logit")

zero_inflated_negbinomial(link = "log", link_shape = "log", link_zi = "logit")

zero_inflated_binomial(link = "logit", link_zi = "logit")

zero_inflated_beta_binomial(
  link = "logit",
  link_phi = "log",
  link_zi = "logit"
)

categorical(link = "logit", refcat = NULL)

multinomial(link = "logit", refcat = NULL)

cumulative(link = "logit", link_disc = "log", threshold = "flexible")

sratio(link = "logit", link_disc = "log", threshold = "flexible")

cratio(link = "logit", link_disc = "log", threshold = "flexible")

acat(link = "logit", link_disc = "log", threshold = "flexible")
}
\arguments{
\item{family}{A character string naming the distribution of the response
variable be used in the model. Currently, the following families are
supported: \code{gaussian}, \code{student}, \code{binomial},
\code{bernoulli}, \code{beta-binomial}, \code{poisson}, \code{negbinomial},
\code{geometric}, \code{Gamma}, \code{skew_normal}, \code{lognormal},
\code{shifted_lognormal}, \code{exgaussian}, \code{wiener},
\code{inverse.gaussian}, \code{exponential}, \code{weibull},
\code{frechet}, \code{Beta}, \code{dirichlet}, \code{von_mises},
\code{asym_laplace}, \code{gen_extreme_value}, \code{categorical},
\code{multinomial}, \code{cumulative}, \code{cratio}, \code{sratio},
\code{acat}, \code{hurdle_poisson}, \code{hurdle_negbinomial},
\code{hurdle_gamma}, \code{hurdle_lognormal},
\code{zero_inflated_binomial}, \code{zero_inflated_beta_binomial},
\code{zero_inflated_beta}, \code{zero_inflated_negbinomial},
\code{zero_inflated_poisson}, and \code{zero_one_inflated_beta}.}

\item{link}{A specification for the model link function. This can be a
name/expression or character string. See the 'Details' section for more
information on link functions supported by each family.}

\item{link_sigma}{Link of auxiliary parameter \code{sigma} if being predicted.}

\item{link_shape}{Link of auxiliary parameter \code{shape} if being predicted.}

\item{link_nu}{Link of auxiliary parameter \code{nu} if being predicted.}

\item{link_phi}{Link of auxiliary parameter \code{phi} if being predicted.}

\item{link_kappa}{Link of auxiliary parameter \code{kappa} if being predicted.}

\item{link_beta}{Link of auxiliary parameter \code{beta} if being predicted.}

\item{link_zi}{Link of auxiliary parameter \code{zi} if being predicted.}

\item{link_hu}{Link of auxiliary parameter \code{hu} if being predicted.}

\item{link_zoi}{Link of auxiliary parameter \code{zoi} if being predicted.}

\item{link_coi}{Link of auxiliary parameter \code{coi} if being predicted.}

\item{link_disc}{Link of auxiliary parameter \code{disc} if being predicted.}

\item{link_bs}{Link of auxiliary parameter \code{bs} if being predicted.}

\item{link_ndt}{Link of auxiliary parameter \code{ndt} if being predicted.}

\item{link_bias}{Link of auxiliary parameter \code{bias} if being predicted.}

\item{link_xi}{Link of auxiliary parameter \code{xi} if being predicted.}

\item{link_alpha}{Link of auxiliary parameter \code{alpha} if being predicted.}

\item{link_quantile}{Link of auxiliary parameter \code{quantile} if being predicted.}

\item{threshold}{A character string indicating the type
of thresholds (i.e. intercepts) used in an ordinal model.
\code{"flexible"} provides the standard unstructured thresholds,
\code{"equidistant"} restricts the distance between
consecutive thresholds to the same value, and
\code{"sum_to_zero"} ensures the thresholds sum to zero.}

\item{refcat}{Optional name of the reference response category used in
\code{categorical}, \code{multinomial}, \code{dirichlet} and
\code{logistic_normal} models. If \code{NULL} (the default), the first
category is used as the reference. If \code{NA}, all categories will be
predicted, which requires strong priors or carefully specified predictor
terms in order to lead to an identified model.}

\item{bhaz}{Currently for experimental purposes only.}
}
\description{
Family objects provide a convenient way to specify the details of the models
used by many model fitting functions. The family functions presented here are
for use with \pkg{brms} only and will **not** work with other model
fitting functions such as \code{glm} or \code{glmer}.
However, the standard family functions as described in
\code{\link[stats:family]{family}} will work with \pkg{brms}.
You can also specify custom families for use in \pkg{brms} with
the \code{\link{custom_family}} function.
}
\details{
Below, we list common use cases for the different families.
  This list is not ment to be exhaustive.
  \itemize{
  \item{Family \code{gaussian} can be used for linear regression.}

  \item{Family \code{student} can be used for robust linear regression
  that is less influenced by outliers.}

  \item{Family \code{skew_normal} can handle skewed responses in linear
  regression.}

  \item{Families \code{poisson}, \code{negbinomial}, and \code{geometric}
  can be used for regression of unbounded count data.}

  \item{Families \code{bernoulli}, \code{binomial}, and \code{beta_binomial}
  can be used for binary regression (i.e., most commonly logistic
  regression).}

  \item{Families \code{categorical} and \code{multinomial} can be used for
  multi-logistic regression when there are more than two possible outcomes.}

  \item{Families \code{cumulative}, \code{cratio} ('continuation ratio'),
  \code{sratio} ('stopping ratio'), and \code{acat} ('adjacent category')
  leads to ordinal regression.}

  \item{Families \code{Gamma}, \code{weibull}, \code{exponential},
  \code{lognormal}, \code{frechet}, \code{inverse.gaussian}, and \code{cox}
  (Cox proportional hazards model) can be used (among others) for
  time-to-event regression also known as survival regression.}

  \item{Families \code{weibull}, \code{frechet}, and \code{gen_extreme_value}
  ('generalized extreme value') allow for modeling extremes.}

  \item{Families \code{beta}, \code{dirichlet}, and \code{logistic_normal}
  can be used to model responses representing rates or probabilities.}

  \item{Family \code{asym_laplace} allows for quantile regression when fixing
  the auxiliary \code{quantile} parameter to the quantile of interest.}

  \item{Family \code{exgaussian} ('exponentially modified Gaussian') and
  \code{shifted_lognormal} are especially suited to model reaction times.}

  \item{Family \code{wiener} provides an implementation of the Wiener
  diffusion model. For this family, the main formula predicts the drift
  parameter 'delta' and all other parameters are modeled as auxiliary parameters
  (see \code{\link{brmsformula}} for details).}

  \item{Families \code{hurdle_poisson}, \code{hurdle_negbinomial},
  \code{hurdle_gamma}, \code{hurdle_lognormal}, \code{zero_inflated_poisson},
  \code{zero_inflated_negbinomial}, \code{zero_inflated_binomial},
  \code{zero_inflated_beta_binomial}, \code{zero_inflated_beta}, and
  \code{zero_one_inflated_beta} allow to estimate zero-inflated and hurdle
  models. These models can be very helpful when there are many zeros in the
  data (or ones in case of one-inflated models)
  that cannot be explained by the primary distribution of the response.}
  }

  Below, we list all possible links for each family.
  The first link mentioned for each family is the default.
  \itemize{
  \item{Families \code{gaussian}, \code{student}, \code{skew_normal},
  \code{exgaussian}, \code{asym_laplace}, and \code{gen_extreme_value}
  support the links (as names) \code{identity}, \code{log}, \code{inverse},
  and \code{softplus}.}

  \item{Families \code{poisson}, \code{negbinomial}, \code{geometric},
  \code{zero_inflated_poisson}, \code{zero_inflated_negbinomial},
  \code{hurdle_poisson}, and \code{hurdle_negbinomial} support
  \code{log}, \code{identity}, \code{sqrt}, and \code{softplus}.}

  \item{Families \code{binomial}, \code{bernoulli}, \code{beta_binomial},
  \code{zero_inflated_binomial}, \code{zero_inflated_beta_binomial},
  \code{Beta}, \code{zero_inflated_beta}, and \code{zero_one_inflated_beta}
  support \code{logit}, \code{probit}, \code{probit_approx}, \code{cloglog},
  \code{cauchit}, \code{identity}, and \code{log}.}

  \item{Families \code{cumulative}, \code{cratio}, \code{sratio},
  and \code{acat} support \code{logit}, \code{probit},
  \code{probit_approx}, \code{cloglog}, and \code{cauchit}.}

  \item{Families \code{categorical}, \code{multinomial}, and \code{dirichlet}
  support \code{logit}.}

  \item{Families \code{Gamma}, \code{weibull}, \code{exponential},
  \code{frechet}, and \code{hurdle_gamma} support
  \code{log}, \code{identity}, \code{inverse}, and \code{softplus}.}

  \item{Families \code{lognormal} and \code{hurdle_lognormal}
  support \code{identity} and \code{inverse}.}

  \item{Family \code{logistic_normal} supports \code{identity}.}

  \item{Family \code{inverse.gaussian} supports \code{1/mu^2},
  \code{inverse}, \code{identity}, \code{log}, and \code{softplus}.}

  \item{Family \code{von_mises} supports \code{tan_half} and
  \code{identity}.}

  \item{Family \code{cox} supports \code{log}, \code{identity},
  and \code{softplus} for the proportional hazards parameter.}

  \item{Family \code{wiener} supports \code{identity}, \code{log},
  and \code{softplus} for the main parameter which represents the
  drift rate.}
  }

  Please note that when calling the \code{\link[stats:family]{Gamma}} family
  function of the \pkg{stats} package, the default link will be
  \code{inverse} instead of \code{log} although the latter is the default in
  \pkg{brms}. Also, when using the family functions \code{gaussian},
  \code{binomial}, \code{poisson}, and \code{Gamma} of the \pkg{stats}
  package (see \code{\link[stats:family]{family}}), special link functions
  such as \code{softplus} or \code{cauchit} won't work. In this case, you
  have to use \code{brmsfamily} to specify the family with corresponding link
  function.
}
\examples{
 # create a family object
 (fam1 <- student("log"))
 # alternatively use the brmsfamily function
 (fam2 <- brmsfamily("student", "log"))
 # both leads to the same object
 identical(fam1, fam2)

}
\seealso{
\code{\link[brms:brm]{brm}},
  \code{\link[stats:family]{family}},
  \code{\link{customfamily}}
}
